# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RouteArgs', 'Route']

@pulumi.input_type
class RouteArgs:
    def __init__(__self__, *,
                 escalation_chain_id: pulumi.Input[builtins.str],
                 integration_id: pulumi.Input[builtins.str],
                 position: pulumi.Input[builtins.int],
                 routing_regex: pulumi.Input[builtins.str],
                 msteams: Optional[pulumi.Input['RouteMsteamsArgs']] = None,
                 routing_type: Optional[pulumi.Input[builtins.str]] = None,
                 slack: Optional[pulumi.Input['RouteSlackArgs']] = None,
                 telegram: Optional[pulumi.Input['RouteTelegramArgs']] = None):
        """
        The set of arguments for constructing a Route resource.
        :param pulumi.Input[builtins.str] escalation_chain_id: The ID of the escalation chain.
        :param pulumi.Input[builtins.str] integration_id: The ID of the integration.
        :param pulumi.Input[builtins.int] position: The position of the route (starts from 0).
        :param pulumi.Input[builtins.str] routing_regex: Python Regex query. Route is chosen for an alert if there is a match inside the alert payload.
        :param pulumi.Input['RouteMsteamsArgs'] msteams: MS teams-specific settings for a route.
        :param pulumi.Input[builtins.str] routing_type: The type of route. Can be jinja2, regex Defaults to `regex`.
        :param pulumi.Input['RouteSlackArgs'] slack: Slack-specific settings for a route.
        :param pulumi.Input['RouteTelegramArgs'] telegram: Telegram-specific settings for a route.
        """
        pulumi.set(__self__, "escalation_chain_id", escalation_chain_id)
        pulumi.set(__self__, "integration_id", integration_id)
        pulumi.set(__self__, "position", position)
        pulumi.set(__self__, "routing_regex", routing_regex)
        if msteams is not None:
            pulumi.set(__self__, "msteams", msteams)
        if routing_type is not None:
            pulumi.set(__self__, "routing_type", routing_type)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if telegram is not None:
            pulumi.set(__self__, "telegram", telegram)

    @property
    @pulumi.getter(name="escalationChainId")
    def escalation_chain_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the escalation chain.
        """
        return pulumi.get(self, "escalation_chain_id")

    @escalation_chain_id.setter
    def escalation_chain_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "escalation_chain_id", value)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the integration.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter
    def position(self) -> pulumi.Input[builtins.int]:
        """
        The position of the route (starts from 0).
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="routingRegex")
    def routing_regex(self) -> pulumi.Input[builtins.str]:
        """
        Python Regex query. Route is chosen for an alert if there is a match inside the alert payload.
        """
        return pulumi.get(self, "routing_regex")

    @routing_regex.setter
    def routing_regex(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "routing_regex", value)

    @property
    @pulumi.getter
    def msteams(self) -> Optional[pulumi.Input['RouteMsteamsArgs']]:
        """
        MS teams-specific settings for a route.
        """
        return pulumi.get(self, "msteams")

    @msteams.setter
    def msteams(self, value: Optional[pulumi.Input['RouteMsteamsArgs']]):
        pulumi.set(self, "msteams", value)

    @property
    @pulumi.getter(name="routingType")
    def routing_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of route. Can be jinja2, regex Defaults to `regex`.
        """
        return pulumi.get(self, "routing_type")

    @routing_type.setter
    def routing_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_type", value)

    @property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['RouteSlackArgs']]:
        """
        Slack-specific settings for a route.
        """
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['RouteSlackArgs']]):
        pulumi.set(self, "slack", value)

    @property
    @pulumi.getter
    def telegram(self) -> Optional[pulumi.Input['RouteTelegramArgs']]:
        """
        Telegram-specific settings for a route.
        """
        return pulumi.get(self, "telegram")

    @telegram.setter
    def telegram(self, value: Optional[pulumi.Input['RouteTelegramArgs']]):
        pulumi.set(self, "telegram", value)


@pulumi.input_type
class _RouteState:
    def __init__(__self__, *,
                 escalation_chain_id: Optional[pulumi.Input[builtins.str]] = None,
                 integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 msteams: Optional[pulumi.Input['RouteMsteamsArgs']] = None,
                 position: Optional[pulumi.Input[builtins.int]] = None,
                 routing_regex: Optional[pulumi.Input[builtins.str]] = None,
                 routing_type: Optional[pulumi.Input[builtins.str]] = None,
                 slack: Optional[pulumi.Input['RouteSlackArgs']] = None,
                 telegram: Optional[pulumi.Input['RouteTelegramArgs']] = None):
        """
        Input properties used for looking up and filtering Route resources.
        :param pulumi.Input[builtins.str] escalation_chain_id: The ID of the escalation chain.
        :param pulumi.Input[builtins.str] integration_id: The ID of the integration.
        :param pulumi.Input['RouteMsteamsArgs'] msteams: MS teams-specific settings for a route.
        :param pulumi.Input[builtins.int] position: The position of the route (starts from 0).
        :param pulumi.Input[builtins.str] routing_regex: Python Regex query. Route is chosen for an alert if there is a match inside the alert payload.
        :param pulumi.Input[builtins.str] routing_type: The type of route. Can be jinja2, regex Defaults to `regex`.
        :param pulumi.Input['RouteSlackArgs'] slack: Slack-specific settings for a route.
        :param pulumi.Input['RouteTelegramArgs'] telegram: Telegram-specific settings for a route.
        """
        if escalation_chain_id is not None:
            pulumi.set(__self__, "escalation_chain_id", escalation_chain_id)
        if integration_id is not None:
            pulumi.set(__self__, "integration_id", integration_id)
        if msteams is not None:
            pulumi.set(__self__, "msteams", msteams)
        if position is not None:
            pulumi.set(__self__, "position", position)
        if routing_regex is not None:
            pulumi.set(__self__, "routing_regex", routing_regex)
        if routing_type is not None:
            pulumi.set(__self__, "routing_type", routing_type)
        if slack is not None:
            pulumi.set(__self__, "slack", slack)
        if telegram is not None:
            pulumi.set(__self__, "telegram", telegram)

    @property
    @pulumi.getter(name="escalationChainId")
    def escalation_chain_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the escalation chain.
        """
        return pulumi.get(self, "escalation_chain_id")

    @escalation_chain_id.setter
    def escalation_chain_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "escalation_chain_id", value)

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the integration.
        """
        return pulumi.get(self, "integration_id")

    @integration_id.setter
    def integration_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "integration_id", value)

    @property
    @pulumi.getter
    def msteams(self) -> Optional[pulumi.Input['RouteMsteamsArgs']]:
        """
        MS teams-specific settings for a route.
        """
        return pulumi.get(self, "msteams")

    @msteams.setter
    def msteams(self, value: Optional[pulumi.Input['RouteMsteamsArgs']]):
        pulumi.set(self, "msteams", value)

    @property
    @pulumi.getter
    def position(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The position of the route (starts from 0).
        """
        return pulumi.get(self, "position")

    @position.setter
    def position(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "position", value)

    @property
    @pulumi.getter(name="routingRegex")
    def routing_regex(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Python Regex query. Route is chosen for an alert if there is a match inside the alert payload.
        """
        return pulumi.get(self, "routing_regex")

    @routing_regex.setter
    def routing_regex(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_regex", value)

    @property
    @pulumi.getter(name="routingType")
    def routing_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The type of route. Can be jinja2, regex Defaults to `regex`.
        """
        return pulumi.get(self, "routing_type")

    @routing_type.setter
    def routing_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "routing_type", value)

    @property
    @pulumi.getter
    def slack(self) -> Optional[pulumi.Input['RouteSlackArgs']]:
        """
        Slack-specific settings for a route.
        """
        return pulumi.get(self, "slack")

    @slack.setter
    def slack(self, value: Optional[pulumi.Input['RouteSlackArgs']]):
        pulumi.set(self, "slack", value)

    @property
    @pulumi.getter
    def telegram(self) -> Optional[pulumi.Input['RouteTelegramArgs']]:
        """
        Telegram-specific settings for a route.
        """
        return pulumi.get(self, "telegram")

    @telegram.setter
    def telegram(self, value: Optional[pulumi.Input['RouteTelegramArgs']]):
        pulumi.set(self, "telegram", value)


@pulumi.type_token("grafana:onCall/route:Route")
class Route(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 escalation_chain_id: Optional[pulumi.Input[builtins.str]] = None,
                 integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 msteams: Optional[pulumi.Input[Union['RouteMsteamsArgs', 'RouteMsteamsArgsDict']]] = None,
                 position: Optional[pulumi.Input[builtins.int]] = None,
                 routing_regex: Optional[pulumi.Input[builtins.str]] = None,
                 routing_type: Optional[pulumi.Input[builtins.str]] = None,
                 slack: Optional[pulumi.Input[Union['RouteSlackArgs', 'RouteSlackArgsDict']]] = None,
                 telegram: Optional[pulumi.Input[Union['RouteTelegramArgs', 'RouteTelegramArgsDict']]] = None,
                 __props__=None):
        """
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/routes/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        example_slack_channel = grafana.onCall.get_slack_channel(name="example_slack_channel")
        default = grafana.on_call.EscalationChain("default", name="default")
        example_integration = grafana.on_call.Integration("example_integration",
            name="Grafana Integration",
            type="grafana",
            default_route={})
        example_route = grafana.on_call.Route("example_route",
            integration_id=example_integration.id,
            escalation_chain_id=default.id,
            routing_regex="us-(east|west)",
            position=0,
            slack={
                "channel_id": example_slack_channel.slack_id,
                "enabled": True,
            },
            telegram={
                "id": "ONCALLTELEGRAMID",
                "enabled": True,
            },
            msteams={
                "id": "ONCALLMSTEAMSID",
                "enabled": False,
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:onCall/route:Route name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] escalation_chain_id: The ID of the escalation chain.
        :param pulumi.Input[builtins.str] integration_id: The ID of the integration.
        :param pulumi.Input[Union['RouteMsteamsArgs', 'RouteMsteamsArgsDict']] msteams: MS teams-specific settings for a route.
        :param pulumi.Input[builtins.int] position: The position of the route (starts from 0).
        :param pulumi.Input[builtins.str] routing_regex: Python Regex query. Route is chosen for an alert if there is a match inside the alert payload.
        :param pulumi.Input[builtins.str] routing_type: The type of route. Can be jinja2, regex Defaults to `regex`.
        :param pulumi.Input[Union['RouteSlackArgs', 'RouteSlackArgsDict']] slack: Slack-specific settings for a route.
        :param pulumi.Input[Union['RouteTelegramArgs', 'RouteTelegramArgsDict']] telegram: Telegram-specific settings for a route.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * [HTTP API](https://grafana.com/docs/oncall/latest/oncall-api-reference/routes/)

        ## Example Usage

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        example_slack_channel = grafana.onCall.get_slack_channel(name="example_slack_channel")
        default = grafana.on_call.EscalationChain("default", name="default")
        example_integration = grafana.on_call.Integration("example_integration",
            name="Grafana Integration",
            type="grafana",
            default_route={})
        example_route = grafana.on_call.Route("example_route",
            integration_id=example_integration.id,
            escalation_chain_id=default.id,
            routing_regex="us-(east|west)",
            position=0,
            slack={
                "channel_id": example_slack_channel.slack_id,
                "enabled": True,
            },
            telegram={
                "id": "ONCALLTELEGRAMID",
                "enabled": True,
            },
            msteams={
                "id": "ONCALLMSTEAMSID",
                "enabled": False,
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:onCall/route:Route name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param RouteArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 escalation_chain_id: Optional[pulumi.Input[builtins.str]] = None,
                 integration_id: Optional[pulumi.Input[builtins.str]] = None,
                 msteams: Optional[pulumi.Input[Union['RouteMsteamsArgs', 'RouteMsteamsArgsDict']]] = None,
                 position: Optional[pulumi.Input[builtins.int]] = None,
                 routing_regex: Optional[pulumi.Input[builtins.str]] = None,
                 routing_type: Optional[pulumi.Input[builtins.str]] = None,
                 slack: Optional[pulumi.Input[Union['RouteSlackArgs', 'RouteSlackArgsDict']]] = None,
                 telegram: Optional[pulumi.Input[Union['RouteTelegramArgs', 'RouteTelegramArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteArgs.__new__(RouteArgs)

            if escalation_chain_id is None and not opts.urn:
                raise TypeError("Missing required property 'escalation_chain_id'")
            __props__.__dict__["escalation_chain_id"] = escalation_chain_id
            if integration_id is None and not opts.urn:
                raise TypeError("Missing required property 'integration_id'")
            __props__.__dict__["integration_id"] = integration_id
            __props__.__dict__["msteams"] = msteams
            if position is None and not opts.urn:
                raise TypeError("Missing required property 'position'")
            __props__.__dict__["position"] = position
            if routing_regex is None and not opts.urn:
                raise TypeError("Missing required property 'routing_regex'")
            __props__.__dict__["routing_regex"] = routing_regex
            __props__.__dict__["routing_type"] = routing_type
            __props__.__dict__["slack"] = slack
            __props__.__dict__["telegram"] = telegram
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/oncallRoute:OncallRoute")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Route, __self__).__init__(
            'grafana:onCall/route:Route',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            escalation_chain_id: Optional[pulumi.Input[builtins.str]] = None,
            integration_id: Optional[pulumi.Input[builtins.str]] = None,
            msteams: Optional[pulumi.Input[Union['RouteMsteamsArgs', 'RouteMsteamsArgsDict']]] = None,
            position: Optional[pulumi.Input[builtins.int]] = None,
            routing_regex: Optional[pulumi.Input[builtins.str]] = None,
            routing_type: Optional[pulumi.Input[builtins.str]] = None,
            slack: Optional[pulumi.Input[Union['RouteSlackArgs', 'RouteSlackArgsDict']]] = None,
            telegram: Optional[pulumi.Input[Union['RouteTelegramArgs', 'RouteTelegramArgsDict']]] = None) -> 'Route':
        """
        Get an existing Route resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] escalation_chain_id: The ID of the escalation chain.
        :param pulumi.Input[builtins.str] integration_id: The ID of the integration.
        :param pulumi.Input[Union['RouteMsteamsArgs', 'RouteMsteamsArgsDict']] msteams: MS teams-specific settings for a route.
        :param pulumi.Input[builtins.int] position: The position of the route (starts from 0).
        :param pulumi.Input[builtins.str] routing_regex: Python Regex query. Route is chosen for an alert if there is a match inside the alert payload.
        :param pulumi.Input[builtins.str] routing_type: The type of route. Can be jinja2, regex Defaults to `regex`.
        :param pulumi.Input[Union['RouteSlackArgs', 'RouteSlackArgsDict']] slack: Slack-specific settings for a route.
        :param pulumi.Input[Union['RouteTelegramArgs', 'RouteTelegramArgsDict']] telegram: Telegram-specific settings for a route.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteState.__new__(_RouteState)

        __props__.__dict__["escalation_chain_id"] = escalation_chain_id
        __props__.__dict__["integration_id"] = integration_id
        __props__.__dict__["msteams"] = msteams
        __props__.__dict__["position"] = position
        __props__.__dict__["routing_regex"] = routing_regex
        __props__.__dict__["routing_type"] = routing_type
        __props__.__dict__["slack"] = slack
        __props__.__dict__["telegram"] = telegram
        return Route(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="escalationChainId")
    def escalation_chain_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the escalation chain.
        """
        return pulumi.get(self, "escalation_chain_id")

    @property
    @pulumi.getter(name="integrationId")
    def integration_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the integration.
        """
        return pulumi.get(self, "integration_id")

    @property
    @pulumi.getter
    def msteams(self) -> pulumi.Output[Optional['outputs.RouteMsteams']]:
        """
        MS teams-specific settings for a route.
        """
        return pulumi.get(self, "msteams")

    @property
    @pulumi.getter
    def position(self) -> pulumi.Output[builtins.int]:
        """
        The position of the route (starts from 0).
        """
        return pulumi.get(self, "position")

    @property
    @pulumi.getter(name="routingRegex")
    def routing_regex(self) -> pulumi.Output[builtins.str]:
        """
        Python Regex query. Route is chosen for an alert if there is a match inside the alert payload.
        """
        return pulumi.get(self, "routing_regex")

    @property
    @pulumi.getter(name="routingType")
    def routing_type(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        The type of route. Can be jinja2, regex Defaults to `regex`.
        """
        return pulumi.get(self, "routing_type")

    @property
    @pulumi.getter
    def slack(self) -> pulumi.Output[Optional['outputs.RouteSlack']]:
        """
        Slack-specific settings for a route.
        """
        return pulumi.get(self, "slack")

    @property
    @pulumi.getter
    def telegram(self) -> pulumi.Output[Optional['outputs.RouteTelegram']]:
        """
        Telegram-specific settings for a route.
        """
        return pulumi.get(self, "telegram")

