# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DashboardPermissionPermission',
    'FolderPermissionPermission',
    'PlaylistItem',
    'ServiceAccountPermissionPermission',
    'SsoSettingsLdapSettings',
    'SsoSettingsLdapSettingsConfig',
    'SsoSettingsLdapSettingsConfigServer',
    'SsoSettingsLdapSettingsConfigServerGroupMapping',
    'SsoSettingsOauth2Settings',
    'SsoSettingsSamlSettings',
    'TeamPreferences',
    'TeamTeamSync',
    'GetDashboardsDashboardResult',
    'GetFoldersFolderResult',
    'GetLibraryPanelsPanelResult',
    'GetTeamPreferenceResult',
    'GetTeamTeamSyncResult',
    'GetUsersUserResult',
]

@pulumi.output_type
class DashboardPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "teamId":
            suggest = "team_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DashboardPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DashboardPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DashboardPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: builtins.str,
                 role: Optional[builtins.str] = None,
                 team_id: Optional[builtins.str] = None,
                 user_id: Optional[builtins.str] = None):
        """
        :param builtins.str permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param builtins.str role: Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        :param builtins.str team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param builtins.str user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def permission(self) -> builtins.str:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[builtins.str]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[builtins.str]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class FolderPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "teamId":
            suggest = "team_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FolderPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FolderPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FolderPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: builtins.str,
                 role: Optional[builtins.str] = None,
                 team_id: Optional[builtins.str] = None,
                 user_id: Optional[builtins.str] = None):
        """
        :param builtins.str permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param builtins.str role: Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        :param builtins.str team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param builtins.str user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def permission(self) -> builtins.str:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter
    def role(self) -> Optional[builtins.str]:
        """
        Name of the basic role to manage permissions for. Options: `Viewer`, `Editor` or `Admin`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[builtins.str]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[builtins.str]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class PlaylistItem(dict):
    def __init__(__self__, *,
                 order: builtins.int,
                 title: builtins.str,
                 id: Optional[builtins.str] = None,
                 type: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        pulumi.set(__self__, "order", order)
        pulumi.set(__self__, "title", title)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def order(self) -> builtins.int:
        return pulumi.get(self, "order")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def type(self) -> Optional[builtins.str]:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        return pulumi.get(self, "value")


@pulumi.output_type
class ServiceAccountPermissionPermission(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "teamId":
            suggest = "team_id"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceAccountPermissionPermission. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceAccountPermissionPermission.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceAccountPermissionPermission.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: builtins.str,
                 team_id: Optional[builtins.str] = None,
                 user_id: Optional[builtins.str] = None):
        """
        :param builtins.str permission: Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        :param builtins.str team_id: ID of the team to manage permissions for. Defaults to `0`.
        :param builtins.str user_id: ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        pulumi.set(__self__, "permission", permission)
        if team_id is not None:
            pulumi.set(__self__, "team_id", team_id)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def permission(self) -> builtins.str:
        """
        Permission to associate with item. Must be one of `View`, `Edit`, or `Admin`.
        """
        return pulumi.get(self, "permission")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> Optional[builtins.str]:
        """
        ID of the team to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "team_id")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[builtins.str]:
        """
        ID of the user or service account to manage permissions for. Defaults to `0`.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class SsoSettingsLdapSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowSignUp":
            suggest = "allow_sign_up"
        elif key == "skipOrgRoleSync":
            suggest = "skip_org_role_sync"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsLdapSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsLdapSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsLdapSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: 'outputs.SsoSettingsLdapSettingsConfig',
                 allow_sign_up: Optional[builtins.bool] = None,
                 enabled: Optional[builtins.bool] = None,
                 skip_org_role_sync: Optional[builtins.bool] = None):
        """
        :param 'SsoSettingsLdapSettingsConfigArgs' config: The LDAP configuration.
        :param builtins.bool allow_sign_up: Whether to allow new Grafana user creation through LDAP login. If set to false, then only existing Grafana users can log in with LDAP.
        :param builtins.bool enabled: Define whether this configuration is enabled for LDAP. Defaults to `true`.
        :param builtins.bool skip_org_role_sync: Prevent synchronizing users’ organization roles from LDAP.
        """
        pulumi.set(__self__, "config", config)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.SsoSettingsLdapSettingsConfig':
        """
        The LDAP configuration.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[builtins.bool]:
        """
        Whether to allow new Grafana user creation through LDAP login. If set to false, then only existing Grafana users can log in with LDAP.
        """
        return pulumi.get(self, "allow_sign_up")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Define whether this configuration is enabled for LDAP. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[builtins.bool]:
        """
        Prevent synchronizing users’ organization roles from LDAP.
        """
        return pulumi.get(self, "skip_org_role_sync")


@pulumi.output_type
class SsoSettingsLdapSettingsConfig(dict):
    def __init__(__self__, *,
                 servers: Sequence['outputs.SsoSettingsLdapSettingsConfigServer']):
        """
        :param Sequence['SsoSettingsLdapSettingsConfigServerArgs'] servers: The LDAP servers configuration.
        """
        pulumi.set(__self__, "servers", servers)

    @property
    @pulumi.getter
    def servers(self) -> Sequence['outputs.SsoSettingsLdapSettingsConfigServer']:
        """
        The LDAP servers configuration.
        """
        return pulumi.get(self, "servers")


@pulumi.output_type
class SsoSettingsLdapSettingsConfigServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "searchBaseDns":
            suggest = "search_base_dns"
        elif key == "searchFilter":
            suggest = "search_filter"
        elif key == "bindDn":
            suggest = "bind_dn"
        elif key == "bindPassword":
            suggest = "bind_password"
        elif key == "clientCert":
            suggest = "client_cert"
        elif key == "clientCertValue":
            suggest = "client_cert_value"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clientKeyValue":
            suggest = "client_key_value"
        elif key == "groupMappings":
            suggest = "group_mappings"
        elif key == "groupSearchBaseDns":
            suggest = "group_search_base_dns"
        elif key == "groupSearchFilter":
            suggest = "group_search_filter"
        elif key == "groupSearchFilterUserAttribute":
            suggest = "group_search_filter_user_attribute"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "rootCaCert":
            suggest = "root_ca_cert"
        elif key == "rootCaCertValues":
            suggest = "root_ca_cert_values"
        elif key == "sslSkipVerify":
            suggest = "ssl_skip_verify"
        elif key == "startTls":
            suggest = "start_tls"
        elif key == "tlsCiphers":
            suggest = "tls_ciphers"
        elif key == "useSsl":
            suggest = "use_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsLdapSettingsConfigServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsLdapSettingsConfigServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsLdapSettingsConfigServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host: builtins.str,
                 search_base_dns: Sequence[builtins.str],
                 search_filter: builtins.str,
                 attributes: Optional[Mapping[str, builtins.str]] = None,
                 bind_dn: Optional[builtins.str] = None,
                 bind_password: Optional[builtins.str] = None,
                 client_cert: Optional[builtins.str] = None,
                 client_cert_value: Optional[builtins.str] = None,
                 client_key: Optional[builtins.str] = None,
                 client_key_value: Optional[builtins.str] = None,
                 group_mappings: Optional[Sequence['outputs.SsoSettingsLdapSettingsConfigServerGroupMapping']] = None,
                 group_search_base_dns: Optional[Sequence[builtins.str]] = None,
                 group_search_filter: Optional[builtins.str] = None,
                 group_search_filter_user_attribute: Optional[builtins.str] = None,
                 min_tls_version: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 root_ca_cert: Optional[builtins.str] = None,
                 root_ca_cert_values: Optional[Sequence[builtins.str]] = None,
                 ssl_skip_verify: Optional[builtins.bool] = None,
                 start_tls: Optional[builtins.bool] = None,
                 timeout: Optional[builtins.int] = None,
                 tls_ciphers: Optional[Sequence[builtins.str]] = None,
                 use_ssl: Optional[builtins.bool] = None):
        """
        :param builtins.str host: The LDAP server host.
        :param Sequence[builtins.str] search_base_dns: An array of base DNs to search through.
        :param builtins.str search_filter: The user search filter, for example "(cn=%s)" or "(sAMAccountName=%s)" or "(uid=%s)".
        :param Mapping[str, builtins.str] attributes: The LDAP server attributes. The following attributes can be configured: email, member_of, name, surname, username.
        :param builtins.str bind_dn: The search user bind DN.
        :param builtins.str bind_password: The search user bind password.
        :param builtins.str client_cert: The path to the client certificate.
        :param builtins.str client_cert_value: The Base64 encoded value of the client certificate.
        :param builtins.str client_key: The path to the client private key.
        :param builtins.str client_key_value: The Base64 encoded value of the client private key.
        :param Sequence['SsoSettingsLdapSettingsConfigServerGroupMappingArgs'] group_mappings: For mapping an LDAP group to a Grafana organization and role.
        :param Sequence[builtins.str] group_search_base_dns: An array of the base DNs to search through for groups. Typically uses ou=groups.
        :param builtins.str group_search_filter: Group search filter, to retrieve the groups of which the user is a member (only set if memberOf attribute is not available).
        :param builtins.str group_search_filter_user_attribute: The %s in the search filter will be replaced with the attribute defined in this field.
        :param builtins.str min_tls_version: Minimum TLS version allowed. Accepted values are: TLS1.2, TLS1.3.
        :param builtins.int port: The LDAP server port.
        :param builtins.str root_ca_cert: The path to the root CA certificate.
        :param Sequence[builtins.str] root_ca_cert_values: The Base64 encoded values of the root CA certificates.
        :param builtins.bool ssl_skip_verify: If set to true, the SSL cert validation will be skipped.
        :param builtins.bool start_tls: If set to true, use LDAP with STARTTLS instead of LDAPS.
        :param builtins.int timeout: The timeout in seconds for connecting to the LDAP host.
        :param Sequence[builtins.str] tls_ciphers: Accepted TLS ciphers. For a complete list of supported ciphers, refer to: https://go.dev/src/crypto/tls/cipher_suites.go.
        :param builtins.bool use_ssl: Set to true if LDAP server should use an encrypted TLS connection (either with STARTTLS or LDAPS).
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "search_base_dns", search_base_dns)
        pulumi.set(__self__, "search_filter", search_filter)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if bind_dn is not None:
            pulumi.set(__self__, "bind_dn", bind_dn)
        if bind_password is not None:
            pulumi.set(__self__, "bind_password", bind_password)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_cert_value is not None:
            pulumi.set(__self__, "client_cert_value", client_cert_value)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if client_key_value is not None:
            pulumi.set(__self__, "client_key_value", client_key_value)
        if group_mappings is not None:
            pulumi.set(__self__, "group_mappings", group_mappings)
        if group_search_base_dns is not None:
            pulumi.set(__self__, "group_search_base_dns", group_search_base_dns)
        if group_search_filter is not None:
            pulumi.set(__self__, "group_search_filter", group_search_filter)
        if group_search_filter_user_attribute is not None:
            pulumi.set(__self__, "group_search_filter_user_attribute", group_search_filter_user_attribute)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if root_ca_cert is not None:
            pulumi.set(__self__, "root_ca_cert", root_ca_cert)
        if root_ca_cert_values is not None:
            pulumi.set(__self__, "root_ca_cert_values", root_ca_cert_values)
        if ssl_skip_verify is not None:
            pulumi.set(__self__, "ssl_skip_verify", ssl_skip_verify)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)
        if tls_ciphers is not None:
            pulumi.set(__self__, "tls_ciphers", tls_ciphers)
        if use_ssl is not None:
            pulumi.set(__self__, "use_ssl", use_ssl)

    @property
    @pulumi.getter
    def host(self) -> builtins.str:
        """
        The LDAP server host.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="searchBaseDns")
    def search_base_dns(self) -> Sequence[builtins.str]:
        """
        An array of base DNs to search through.
        """
        return pulumi.get(self, "search_base_dns")

    @property
    @pulumi.getter(name="searchFilter")
    def search_filter(self) -> builtins.str:
        """
        The user search filter, for example "(cn=%s)" or "(sAMAccountName=%s)" or "(uid=%s)".
        """
        return pulumi.get(self, "search_filter")

    @property
    @pulumi.getter
    def attributes(self) -> Optional[Mapping[str, builtins.str]]:
        """
        The LDAP server attributes. The following attributes can be configured: email, member_of, name, surname, username.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="bindDn")
    def bind_dn(self) -> Optional[builtins.str]:
        """
        The search user bind DN.
        """
        return pulumi.get(self, "bind_dn")

    @property
    @pulumi.getter(name="bindPassword")
    def bind_password(self) -> Optional[builtins.str]:
        """
        The search user bind password.
        """
        return pulumi.get(self, "bind_password")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[builtins.str]:
        """
        The path to the client certificate.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientCertValue")
    def client_cert_value(self) -> Optional[builtins.str]:
        """
        The Base64 encoded value of the client certificate.
        """
        return pulumi.get(self, "client_cert_value")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[builtins.str]:
        """
        The path to the client private key.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clientKeyValue")
    def client_key_value(self) -> Optional[builtins.str]:
        """
        The Base64 encoded value of the client private key.
        """
        return pulumi.get(self, "client_key_value")

    @property
    @pulumi.getter(name="groupMappings")
    def group_mappings(self) -> Optional[Sequence['outputs.SsoSettingsLdapSettingsConfigServerGroupMapping']]:
        """
        For mapping an LDAP group to a Grafana organization and role.
        """
        return pulumi.get(self, "group_mappings")

    @property
    @pulumi.getter(name="groupSearchBaseDns")
    def group_search_base_dns(self) -> Optional[Sequence[builtins.str]]:
        """
        An array of the base DNs to search through for groups. Typically uses ou=groups.
        """
        return pulumi.get(self, "group_search_base_dns")

    @property
    @pulumi.getter(name="groupSearchFilter")
    def group_search_filter(self) -> Optional[builtins.str]:
        """
        Group search filter, to retrieve the groups of which the user is a member (only set if memberOf attribute is not available).
        """
        return pulumi.get(self, "group_search_filter")

    @property
    @pulumi.getter(name="groupSearchFilterUserAttribute")
    def group_search_filter_user_attribute(self) -> Optional[builtins.str]:
        """
        The %s in the search filter will be replaced with the attribute defined in this field.
        """
        return pulumi.get(self, "group_search_filter_user_attribute")

    @property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[builtins.str]:
        """
        Minimum TLS version allowed. Accepted values are: TLS1.2, TLS1.3.
        """
        return pulumi.get(self, "min_tls_version")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        The LDAP server port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="rootCaCert")
    def root_ca_cert(self) -> Optional[builtins.str]:
        """
        The path to the root CA certificate.
        """
        return pulumi.get(self, "root_ca_cert")

    @property
    @pulumi.getter(name="rootCaCertValues")
    def root_ca_cert_values(self) -> Optional[Sequence[builtins.str]]:
        """
        The Base64 encoded values of the root CA certificates.
        """
        return pulumi.get(self, "root_ca_cert_values")

    @property
    @pulumi.getter(name="sslSkipVerify")
    def ssl_skip_verify(self) -> Optional[builtins.bool]:
        """
        If set to true, the SSL cert validation will be skipped.
        """
        return pulumi.get(self, "ssl_skip_verify")

    @property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[builtins.bool]:
        """
        If set to true, use LDAP with STARTTLS instead of LDAPS.
        """
        return pulumi.get(self, "start_tls")

    @property
    @pulumi.getter
    def timeout(self) -> Optional[builtins.int]:
        """
        The timeout in seconds for connecting to the LDAP host.
        """
        return pulumi.get(self, "timeout")

    @property
    @pulumi.getter(name="tlsCiphers")
    def tls_ciphers(self) -> Optional[Sequence[builtins.str]]:
        """
        Accepted TLS ciphers. For a complete list of supported ciphers, refer to: https://go.dev/src/crypto/tls/cipher_suites.go.
        """
        return pulumi.get(self, "tls_ciphers")

    @property
    @pulumi.getter(name="useSsl")
    def use_ssl(self) -> Optional[builtins.bool]:
        """
        Set to true if LDAP server should use an encrypted TLS connection (either with STARTTLS or LDAPS).
        """
        return pulumi.get(self, "use_ssl")


@pulumi.output_type
class SsoSettingsLdapSettingsConfigServerGroupMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupDn":
            suggest = "group_dn"
        elif key == "orgRole":
            suggest = "org_role"
        elif key == "grafanaAdmin":
            suggest = "grafana_admin"
        elif key == "orgId":
            suggest = "org_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsLdapSettingsConfigServerGroupMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsLdapSettingsConfigServerGroupMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsLdapSettingsConfigServerGroupMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_dn: builtins.str,
                 org_role: builtins.str,
                 grafana_admin: Optional[builtins.bool] = None,
                 org_id: Optional[builtins.int] = None):
        """
        :param builtins.str group_dn: LDAP distinguished name (DN) of LDAP group. If you want to match all (or no LDAP groups) then you can use wildcard ("*").
        :param builtins.str org_role: Assign users of group_dn the organization role Admin, Editor, or Viewer.
        :param builtins.bool grafana_admin: If set to true, it makes the user of group_dn Grafana server admin.
        :param builtins.int org_id: The Grafana organization database id.
        """
        pulumi.set(__self__, "group_dn", group_dn)
        pulumi.set(__self__, "org_role", org_role)
        if grafana_admin is not None:
            pulumi.set(__self__, "grafana_admin", grafana_admin)
        if org_id is not None:
            pulumi.set(__self__, "org_id", org_id)

    @property
    @pulumi.getter(name="groupDn")
    def group_dn(self) -> builtins.str:
        """
        LDAP distinguished name (DN) of LDAP group. If you want to match all (or no LDAP groups) then you can use wildcard ("*").
        """
        return pulumi.get(self, "group_dn")

    @property
    @pulumi.getter(name="orgRole")
    def org_role(self) -> builtins.str:
        """
        Assign users of group_dn the organization role Admin, Editor, or Viewer.
        """
        return pulumi.get(self, "org_role")

    @property
    @pulumi.getter(name="grafanaAdmin")
    def grafana_admin(self) -> Optional[builtins.bool]:
        """
        If set to true, it makes the user of group_dn Grafana server admin.
        """
        return pulumi.get(self, "grafana_admin")

    @property
    @pulumi.getter(name="orgId")
    def org_id(self) -> Optional[builtins.int]:
        """
        The Grafana organization database id.
        """
        return pulumi.get(self, "org_id")


@pulumi.output_type
class SsoSettingsOauth2Settings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "allowAssignGrafanaAdmin":
            suggest = "allow_assign_grafana_admin"
        elif key == "allowSignUp":
            suggest = "allow_sign_up"
        elif key == "allowedDomains":
            suggest = "allowed_domains"
        elif key == "allowedGroups":
            suggest = "allowed_groups"
        elif key == "allowedOrganizations":
            suggest = "allowed_organizations"
        elif key == "apiUrl":
            suggest = "api_url"
        elif key == "authStyle":
            suggest = "auth_style"
        elif key == "authUrl":
            suggest = "auth_url"
        elif key == "autoLogin":
            suggest = "auto_login"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "defineAllowedGroups":
            suggest = "define_allowed_groups"
        elif key == "defineAllowedTeamsIds":
            suggest = "define_allowed_teams_ids"
        elif key == "emailAttributeName":
            suggest = "email_attribute_name"
        elif key == "emailAttributePath":
            suggest = "email_attribute_path"
        elif key == "emptyScopes":
            suggest = "empty_scopes"
        elif key == "groupsAttributePath":
            suggest = "groups_attribute_path"
        elif key == "idTokenAttributeName":
            suggest = "id_token_attribute_name"
        elif key == "loginAttributePath":
            suggest = "login_attribute_path"
        elif key == "nameAttributePath":
            suggest = "name_attribute_path"
        elif key == "orgAttributePath":
            suggest = "org_attribute_path"
        elif key == "orgMapping":
            suggest = "org_mapping"
        elif key == "roleAttributePath":
            suggest = "role_attribute_path"
        elif key == "roleAttributeStrict":
            suggest = "role_attribute_strict"
        elif key == "signoutRedirectUrl":
            suggest = "signout_redirect_url"
        elif key == "skipOrgRoleSync":
            suggest = "skip_org_role_sync"
        elif key == "teamIds":
            suggest = "team_ids"
        elif key == "teamIdsAttributePath":
            suggest = "team_ids_attribute_path"
        elif key == "teamsUrl":
            suggest = "teams_url"
        elif key == "tlsClientCa":
            suggest = "tls_client_ca"
        elif key == "tlsClientCert":
            suggest = "tls_client_cert"
        elif key == "tlsClientKey":
            suggest = "tls_client_key"
        elif key == "tlsSkipVerifyInsecure":
            suggest = "tls_skip_verify_insecure"
        elif key == "tokenUrl":
            suggest = "token_url"
        elif key == "usePkce":
            suggest = "use_pkce"
        elif key == "useRefreshToken":
            suggest = "use_refresh_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsOauth2Settings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsOauth2Settings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsOauth2Settings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: builtins.str,
                 allow_assign_grafana_admin: Optional[builtins.bool] = None,
                 allow_sign_up: Optional[builtins.bool] = None,
                 allowed_domains: Optional[builtins.str] = None,
                 allowed_groups: Optional[builtins.str] = None,
                 allowed_organizations: Optional[builtins.str] = None,
                 api_url: Optional[builtins.str] = None,
                 auth_style: Optional[builtins.str] = None,
                 auth_url: Optional[builtins.str] = None,
                 auto_login: Optional[builtins.bool] = None,
                 client_secret: Optional[builtins.str] = None,
                 custom: Optional[Mapping[str, builtins.str]] = None,
                 define_allowed_groups: Optional[builtins.bool] = None,
                 define_allowed_teams_ids: Optional[builtins.bool] = None,
                 email_attribute_name: Optional[builtins.str] = None,
                 email_attribute_path: Optional[builtins.str] = None,
                 empty_scopes: Optional[builtins.bool] = None,
                 enabled: Optional[builtins.bool] = None,
                 groups_attribute_path: Optional[builtins.str] = None,
                 id_token_attribute_name: Optional[builtins.str] = None,
                 login_attribute_path: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 name_attribute_path: Optional[builtins.str] = None,
                 org_attribute_path: Optional[builtins.str] = None,
                 org_mapping: Optional[builtins.str] = None,
                 role_attribute_path: Optional[builtins.str] = None,
                 role_attribute_strict: Optional[builtins.bool] = None,
                 scopes: Optional[builtins.str] = None,
                 signout_redirect_url: Optional[builtins.str] = None,
                 skip_org_role_sync: Optional[builtins.bool] = None,
                 team_ids: Optional[builtins.str] = None,
                 team_ids_attribute_path: Optional[builtins.str] = None,
                 teams_url: Optional[builtins.str] = None,
                 tls_client_ca: Optional[builtins.str] = None,
                 tls_client_cert: Optional[builtins.str] = None,
                 tls_client_key: Optional[builtins.str] = None,
                 tls_skip_verify_insecure: Optional[builtins.bool] = None,
                 token_url: Optional[builtins.str] = None,
                 use_pkce: Optional[builtins.bool] = None,
                 use_refresh_token: Optional[builtins.bool] = None):
        """
        :param builtins.str client_id: The client Id of your OAuth2 app.
        :param builtins.bool allow_assign_grafana_admin: If enabled, it will automatically sync the Grafana server administrator role.
        :param builtins.bool allow_sign_up: If not enabled, only existing Grafana users can log in using OAuth.
        :param builtins.str allowed_domains: List of comma- or space-separated domains. The user should belong to at least one domain to log in.
        :param builtins.str allowed_groups: List of comma- or space-separated groups. The user should be a member of at least one group to log in. For Generic OAuth, if you configure allowed*groups, you must also configure groups*attribute_path.
        :param builtins.str allowed_organizations: List of comma- or space-separated organizations. The user should be a member of at least one organization to log in.
        :param builtins.str api_url: The user information endpoint of your OAuth2 provider. Required for okta and generic_oauth providers.
        :param builtins.str auth_style: It determines how client*id and client*secret are sent to Oauth2 provider. Possible values are AutoDetect, InParams, InHeader. Default is AutoDetect.
        :param builtins.str auth_url: The authorization endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        :param builtins.bool auto_login: Log in automatically, skipping the login screen.
        :param builtins.str client_secret: The client secret of your OAuth2 app.
        :param Mapping[str, builtins.str] custom: Custom fields to configure for OAuth2 such as the [force*use*graph_api](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-authentication/azuread/#force-fetching-groups-from-microsoft-graph-api) field.
        :param builtins.bool define_allowed_groups: Define allowed groups.
        :param builtins.bool define_allowed_teams_ids: Define allowed teams ids.
        :param builtins.str email_attribute_name: Name of the key to use for user email lookup within the attributes map of OAuth2 ID token. Only applicable to Generic OAuth.
        :param builtins.str email_attribute_path: JMESPath expression to use for user email lookup from the user information. Only applicable to Generic OAuth.
        :param builtins.bool empty_scopes: If enabled, no scopes will be sent to the OAuth2 provider.
        :param builtins.bool enabled: Define whether this configuration is enabled for the specified provider. Defaults to `true`.
        :param builtins.str groups_attribute_path: JMESPath expression to use for user group lookup. If you configure allowed*groups, you must also configure groups*attribute_path.
        :param builtins.str id_token_attribute_name: The name of the key used to extract the ID token from the returned OAuth2 token. Only applicable to Generic OAuth.
        :param builtins.str login_attribute_path: JMESPath expression to use for user login lookup from the user ID token. Only applicable to Generic OAuth.
        :param builtins.str name: Helpful if you use more than one identity providers or SSO protocols.
        :param builtins.str name_attribute_path: JMESPath expression to use for user name lookup from the user ID token. This name will be used as the user’s display name. Only applicable to Generic OAuth.
        :param builtins.str org_attribute_path: JMESPath expression to use for the organization mapping lookup from the user ID token. The extracted list will be used for the organization mapping (to match "Organization" in the "org_mapping"). Only applicable to Generic OAuth and Okta.
        :param builtins.str org_mapping: List of comma- or space-separated Organization:OrgIdOrOrgName:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: None, Viewer, Editor or Admin.
        :param builtins.str role_attribute_path: JMESPath expression to use for Grafana role lookup.
        :param builtins.bool role_attribute_strict: If enabled, denies user login if the Grafana role cannot be extracted using Role attribute path.
        :param builtins.str scopes: List of comma- or space-separated OAuth2 scopes.
        :param builtins.str signout_redirect_url: The URL to redirect the user to after signing out from Grafana.
        :param builtins.bool skip_org_role_sync: Prevent synchronizing users’ organization roles from your IdP.
        :param builtins.str team_ids: String list of Team Ids. If set, the user must be a member of one of the given teams to log in. If you configure team*ids, you must also configure teams*url and team*ids*attribute_path.
        :param builtins.str team_ids_attribute_path: The JMESPath expression to use for Grafana Team Id lookup within the results returned by the teams_url endpoint. Only applicable to Generic OAuth.
        :param builtins.str teams_url: The URL used to query for Team Ids. If not set, the default value is /teams. If you configure teams*url, you must also configure team*ids*attribute*path. Only applicable to Generic OAuth.
        :param builtins.str tls_client_ca: The path to the trusted certificate authority list. Is not applicable on Grafana Cloud.
        :param builtins.str tls_client_cert: The path to the certificate. Is not applicable on Grafana Cloud.
        :param builtins.str tls_client_key: The path to the key. Is not applicable on Grafana Cloud.
        :param builtins.bool tls_skip_verify_insecure: If enabled, the client accepts any certificate presented by the server and any host name in that certificate. You should only use this for testing, because this mode leaves SSL/TLS susceptible to man-in-the-middle attacks.
        :param builtins.str token_url: The token endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        :param builtins.bool use_pkce: If enabled, Grafana will use Proof Key for Code Exchange (PKCE) with the OAuth2 Authorization Code Grant.
        :param builtins.bool use_refresh_token: If enabled, Grafana will fetch a new access token using the refresh token provided by the OAuth2 provider.
        """
        pulumi.set(__self__, "client_id", client_id)
        if allow_assign_grafana_admin is not None:
            pulumi.set(__self__, "allow_assign_grafana_admin", allow_assign_grafana_admin)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_groups is not None:
            pulumi.set(__self__, "allowed_groups", allowed_groups)
        if allowed_organizations is not None:
            pulumi.set(__self__, "allowed_organizations", allowed_organizations)
        if api_url is not None:
            pulumi.set(__self__, "api_url", api_url)
        if auth_style is not None:
            pulumi.set(__self__, "auth_style", auth_style)
        if auth_url is not None:
            pulumi.set(__self__, "auth_url", auth_url)
        if auto_login is not None:
            pulumi.set(__self__, "auto_login", auto_login)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if define_allowed_groups is not None:
            pulumi.set(__self__, "define_allowed_groups", define_allowed_groups)
        if define_allowed_teams_ids is not None:
            pulumi.set(__self__, "define_allowed_teams_ids", define_allowed_teams_ids)
        if email_attribute_name is not None:
            pulumi.set(__self__, "email_attribute_name", email_attribute_name)
        if email_attribute_path is not None:
            pulumi.set(__self__, "email_attribute_path", email_attribute_path)
        if empty_scopes is not None:
            pulumi.set(__self__, "empty_scopes", empty_scopes)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if groups_attribute_path is not None:
            pulumi.set(__self__, "groups_attribute_path", groups_attribute_path)
        if id_token_attribute_name is not None:
            pulumi.set(__self__, "id_token_attribute_name", id_token_attribute_name)
        if login_attribute_path is not None:
            pulumi.set(__self__, "login_attribute_path", login_attribute_path)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_attribute_path is not None:
            pulumi.set(__self__, "name_attribute_path", name_attribute_path)
        if org_attribute_path is not None:
            pulumi.set(__self__, "org_attribute_path", org_attribute_path)
        if org_mapping is not None:
            pulumi.set(__self__, "org_mapping", org_mapping)
        if role_attribute_path is not None:
            pulumi.set(__self__, "role_attribute_path", role_attribute_path)
        if role_attribute_strict is not None:
            pulumi.set(__self__, "role_attribute_strict", role_attribute_strict)
        if scopes is not None:
            pulumi.set(__self__, "scopes", scopes)
        if signout_redirect_url is not None:
            pulumi.set(__self__, "signout_redirect_url", signout_redirect_url)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)
        if team_ids is not None:
            pulumi.set(__self__, "team_ids", team_ids)
        if team_ids_attribute_path is not None:
            pulumi.set(__self__, "team_ids_attribute_path", team_ids_attribute_path)
        if teams_url is not None:
            pulumi.set(__self__, "teams_url", teams_url)
        if tls_client_ca is not None:
            pulumi.set(__self__, "tls_client_ca", tls_client_ca)
        if tls_client_cert is not None:
            pulumi.set(__self__, "tls_client_cert", tls_client_cert)
        if tls_client_key is not None:
            pulumi.set(__self__, "tls_client_key", tls_client_key)
        if tls_skip_verify_insecure is not None:
            pulumi.set(__self__, "tls_skip_verify_insecure", tls_skip_verify_insecure)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)
        if use_pkce is not None:
            pulumi.set(__self__, "use_pkce", use_pkce)
        if use_refresh_token is not None:
            pulumi.set(__self__, "use_refresh_token", use_refresh_token)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> builtins.str:
        """
        The client Id of your OAuth2 app.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="allowAssignGrafanaAdmin")
    def allow_assign_grafana_admin(self) -> Optional[builtins.bool]:
        """
        If enabled, it will automatically sync the Grafana server administrator role.
        """
        return pulumi.get(self, "allow_assign_grafana_admin")

    @property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[builtins.bool]:
        """
        If not enabled, only existing Grafana users can log in using OAuth.
        """
        return pulumi.get(self, "allow_sign_up")

    @property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated domains. The user should belong to at least one domain to log in.
        """
        return pulumi.get(self, "allowed_domains")

    @property
    @pulumi.getter(name="allowedGroups")
    def allowed_groups(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated groups. The user should be a member of at least one group to log in. For Generic OAuth, if you configure allowed*groups, you must also configure groups*attribute_path.
        """
        return pulumi.get(self, "allowed_groups")

    @property
    @pulumi.getter(name="allowedOrganizations")
    def allowed_organizations(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated organizations. The user should be a member of at least one organization to log in.
        """
        return pulumi.get(self, "allowed_organizations")

    @property
    @pulumi.getter(name="apiUrl")
    def api_url(self) -> Optional[builtins.str]:
        """
        The user information endpoint of your OAuth2 provider. Required for okta and generic_oauth providers.
        """
        return pulumi.get(self, "api_url")

    @property
    @pulumi.getter(name="authStyle")
    def auth_style(self) -> Optional[builtins.str]:
        """
        It determines how client*id and client*secret are sent to Oauth2 provider. Possible values are AutoDetect, InParams, InHeader. Default is AutoDetect.
        """
        return pulumi.get(self, "auth_style")

    @property
    @pulumi.getter(name="authUrl")
    def auth_url(self) -> Optional[builtins.str]:
        """
        The authorization endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        return pulumi.get(self, "auth_url")

    @property
    @pulumi.getter(name="autoLogin")
    def auto_login(self) -> Optional[builtins.bool]:
        """
        Log in automatically, skipping the login screen.
        """
        return pulumi.get(self, "auto_login")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[builtins.str]:
        """
        The client secret of your OAuth2 app.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def custom(self) -> Optional[Mapping[str, builtins.str]]:
        """
        Custom fields to configure for OAuth2 such as the [force*use*graph_api](https://grafana.com/docs/grafana/latest/setup-grafana/configure-security/configure-authentication/azuread/#force-fetching-groups-from-microsoft-graph-api) field.
        """
        return pulumi.get(self, "custom")

    @property
    @pulumi.getter(name="defineAllowedGroups")
    def define_allowed_groups(self) -> Optional[builtins.bool]:
        """
        Define allowed groups.
        """
        return pulumi.get(self, "define_allowed_groups")

    @property
    @pulumi.getter(name="defineAllowedTeamsIds")
    def define_allowed_teams_ids(self) -> Optional[builtins.bool]:
        """
        Define allowed teams ids.
        """
        return pulumi.get(self, "define_allowed_teams_ids")

    @property
    @pulumi.getter(name="emailAttributeName")
    def email_attribute_name(self) -> Optional[builtins.str]:
        """
        Name of the key to use for user email lookup within the attributes map of OAuth2 ID token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "email_attribute_name")

    @property
    @pulumi.getter(name="emailAttributePath")
    def email_attribute_path(self) -> Optional[builtins.str]:
        """
        JMESPath expression to use for user email lookup from the user information. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "email_attribute_path")

    @property
    @pulumi.getter(name="emptyScopes")
    def empty_scopes(self) -> Optional[builtins.bool]:
        """
        If enabled, no scopes will be sent to the OAuth2 provider.
        """
        return pulumi.get(self, "empty_scopes")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Define whether this configuration is enabled for the specified provider. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="groupsAttributePath")
    def groups_attribute_path(self) -> Optional[builtins.str]:
        """
        JMESPath expression to use for user group lookup. If you configure allowed*groups, you must also configure groups*attribute_path.
        """
        return pulumi.get(self, "groups_attribute_path")

    @property
    @pulumi.getter(name="idTokenAttributeName")
    def id_token_attribute_name(self) -> Optional[builtins.str]:
        """
        The name of the key used to extract the ID token from the returned OAuth2 token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "id_token_attribute_name")

    @property
    @pulumi.getter(name="loginAttributePath")
    def login_attribute_path(self) -> Optional[builtins.str]:
        """
        JMESPath expression to use for user login lookup from the user ID token. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "login_attribute_path")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Helpful if you use more than one identity providers or SSO protocols.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameAttributePath")
    def name_attribute_path(self) -> Optional[builtins.str]:
        """
        JMESPath expression to use for user name lookup from the user ID token. This name will be used as the user’s display name. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "name_attribute_path")

    @property
    @pulumi.getter(name="orgAttributePath")
    def org_attribute_path(self) -> Optional[builtins.str]:
        """
        JMESPath expression to use for the organization mapping lookup from the user ID token. The extracted list will be used for the organization mapping (to match "Organization" in the "org_mapping"). Only applicable to Generic OAuth and Okta.
        """
        return pulumi.get(self, "org_attribute_path")

    @property
    @pulumi.getter(name="orgMapping")
    def org_mapping(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated Organization:OrgIdOrOrgName:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: None, Viewer, Editor or Admin.
        """
        return pulumi.get(self, "org_mapping")

    @property
    @pulumi.getter(name="roleAttributePath")
    def role_attribute_path(self) -> Optional[builtins.str]:
        """
        JMESPath expression to use for Grafana role lookup.
        """
        return pulumi.get(self, "role_attribute_path")

    @property
    @pulumi.getter(name="roleAttributeStrict")
    def role_attribute_strict(self) -> Optional[builtins.bool]:
        """
        If enabled, denies user login if the Grafana role cannot be extracted using Role attribute path.
        """
        return pulumi.get(self, "role_attribute_strict")

    @property
    @pulumi.getter
    def scopes(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated OAuth2 scopes.
        """
        return pulumi.get(self, "scopes")

    @property
    @pulumi.getter(name="signoutRedirectUrl")
    def signout_redirect_url(self) -> Optional[builtins.str]:
        """
        The URL to redirect the user to after signing out from Grafana.
        """
        return pulumi.get(self, "signout_redirect_url")

    @property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[builtins.bool]:
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        return pulumi.get(self, "skip_org_role_sync")

    @property
    @pulumi.getter(name="teamIds")
    def team_ids(self) -> Optional[builtins.str]:
        """
        String list of Team Ids. If set, the user must be a member of one of the given teams to log in. If you configure team*ids, you must also configure teams*url and team*ids*attribute_path.
        """
        return pulumi.get(self, "team_ids")

    @property
    @pulumi.getter(name="teamIdsAttributePath")
    def team_ids_attribute_path(self) -> Optional[builtins.str]:
        """
        The JMESPath expression to use for Grafana Team Id lookup within the results returned by the teams_url endpoint. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "team_ids_attribute_path")

    @property
    @pulumi.getter(name="teamsUrl")
    def teams_url(self) -> Optional[builtins.str]:
        """
        The URL used to query for Team Ids. If not set, the default value is /teams. If you configure teams*url, you must also configure team*ids*attribute*path. Only applicable to Generic OAuth.
        """
        return pulumi.get(self, "teams_url")

    @property
    @pulumi.getter(name="tlsClientCa")
    def tls_client_ca(self) -> Optional[builtins.str]:
        """
        The path to the trusted certificate authority list. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_ca")

    @property
    @pulumi.getter(name="tlsClientCert")
    def tls_client_cert(self) -> Optional[builtins.str]:
        """
        The path to the certificate. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_cert")

    @property
    @pulumi.getter(name="tlsClientKey")
    def tls_client_key(self) -> Optional[builtins.str]:
        """
        The path to the key. Is not applicable on Grafana Cloud.
        """
        return pulumi.get(self, "tls_client_key")

    @property
    @pulumi.getter(name="tlsSkipVerifyInsecure")
    def tls_skip_verify_insecure(self) -> Optional[builtins.bool]:
        """
        If enabled, the client accepts any certificate presented by the server and any host name in that certificate. You should only use this for testing, because this mode leaves SSL/TLS susceptible to man-in-the-middle attacks.
        """
        return pulumi.get(self, "tls_skip_verify_insecure")

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[builtins.str]:
        """
        The token endpoint of your OAuth2 provider. Required for azuread, okta and generic_oauth providers.
        """
        return pulumi.get(self, "token_url")

    @property
    @pulumi.getter(name="usePkce")
    def use_pkce(self) -> Optional[builtins.bool]:
        """
        If enabled, Grafana will use Proof Key for Code Exchange (PKCE) with the OAuth2 Authorization Code Grant.
        """
        return pulumi.get(self, "use_pkce")

    @property
    @pulumi.getter(name="useRefreshToken")
    def use_refresh_token(self) -> Optional[builtins.bool]:
        """
        If enabled, Grafana will fetch a new access token using the refresh token provided by the OAuth2 provider.
        """
        return pulumi.get(self, "use_refresh_token")


@pulumi.output_type
class SsoSettingsSamlSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowIdpInitiated":
            suggest = "allow_idp_initiated"
        elif key == "allowSignUp":
            suggest = "allow_sign_up"
        elif key == "allowedOrganizations":
            suggest = "allowed_organizations"
        elif key == "assertionAttributeEmail":
            suggest = "assertion_attribute_email"
        elif key == "assertionAttributeGroups":
            suggest = "assertion_attribute_groups"
        elif key == "assertionAttributeLogin":
            suggest = "assertion_attribute_login"
        elif key == "assertionAttributeName":
            suggest = "assertion_attribute_name"
        elif key == "assertionAttributeOrg":
            suggest = "assertion_attribute_org"
        elif key == "assertionAttributeRole":
            suggest = "assertion_attribute_role"
        elif key == "autoLogin":
            suggest = "auto_login"
        elif key == "certificatePath":
            suggest = "certificate_path"
        elif key == "clientId":
            suggest = "client_id"
        elif key == "clientSecret":
            suggest = "client_secret"
        elif key == "entityId":
            suggest = "entity_id"
        elif key == "forceUseGraphApi":
            suggest = "force_use_graph_api"
        elif key == "idpMetadata":
            suggest = "idp_metadata"
        elif key == "idpMetadataPath":
            suggest = "idp_metadata_path"
        elif key == "idpMetadataUrl":
            suggest = "idp_metadata_url"
        elif key == "maxIssueDelay":
            suggest = "max_issue_delay"
        elif key == "metadataValidDuration":
            suggest = "metadata_valid_duration"
        elif key == "nameIdFormat":
            suggest = "name_id_format"
        elif key == "orgMapping":
            suggest = "org_mapping"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "privateKeyPath":
            suggest = "private_key_path"
        elif key == "relayState":
            suggest = "relay_state"
        elif key == "roleValuesAdmin":
            suggest = "role_values_admin"
        elif key == "roleValuesEditor":
            suggest = "role_values_editor"
        elif key == "roleValuesGrafanaAdmin":
            suggest = "role_values_grafana_admin"
        elif key == "roleValuesNone":
            suggest = "role_values_none"
        elif key == "roleValuesViewer":
            suggest = "role_values_viewer"
        elif key == "signatureAlgorithm":
            suggest = "signature_algorithm"
        elif key == "singleLogout":
            suggest = "single_logout"
        elif key == "skipOrgRoleSync":
            suggest = "skip_org_role_sync"
        elif key == "tokenUrl":
            suggest = "token_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SsoSettingsSamlSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SsoSettingsSamlSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SsoSettingsSamlSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_idp_initiated: Optional[builtins.bool] = None,
                 allow_sign_up: Optional[builtins.bool] = None,
                 allowed_organizations: Optional[builtins.str] = None,
                 assertion_attribute_email: Optional[builtins.str] = None,
                 assertion_attribute_groups: Optional[builtins.str] = None,
                 assertion_attribute_login: Optional[builtins.str] = None,
                 assertion_attribute_name: Optional[builtins.str] = None,
                 assertion_attribute_org: Optional[builtins.str] = None,
                 assertion_attribute_role: Optional[builtins.str] = None,
                 auto_login: Optional[builtins.bool] = None,
                 certificate: Optional[builtins.str] = None,
                 certificate_path: Optional[builtins.str] = None,
                 client_id: Optional[builtins.str] = None,
                 client_secret: Optional[builtins.str] = None,
                 enabled: Optional[builtins.bool] = None,
                 entity_id: Optional[builtins.str] = None,
                 force_use_graph_api: Optional[builtins.bool] = None,
                 idp_metadata: Optional[builtins.str] = None,
                 idp_metadata_path: Optional[builtins.str] = None,
                 idp_metadata_url: Optional[builtins.str] = None,
                 max_issue_delay: Optional[builtins.str] = None,
                 metadata_valid_duration: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None,
                 name_id_format: Optional[builtins.str] = None,
                 org_mapping: Optional[builtins.str] = None,
                 private_key: Optional[builtins.str] = None,
                 private_key_path: Optional[builtins.str] = None,
                 relay_state: Optional[builtins.str] = None,
                 role_values_admin: Optional[builtins.str] = None,
                 role_values_editor: Optional[builtins.str] = None,
                 role_values_grafana_admin: Optional[builtins.str] = None,
                 role_values_none: Optional[builtins.str] = None,
                 role_values_viewer: Optional[builtins.str] = None,
                 signature_algorithm: Optional[builtins.str] = None,
                 single_logout: Optional[builtins.bool] = None,
                 skip_org_role_sync: Optional[builtins.bool] = None,
                 token_url: Optional[builtins.str] = None):
        """
        :param builtins.bool allow_idp_initiated: Whether SAML IdP-initiated login is allowed.
        :param builtins.bool allow_sign_up: Whether to allow new Grafana user creation through SAML login. If set to false, then only existing Grafana users can log in with SAML.
        :param builtins.str allowed_organizations: List of comma- or space-separated organizations. User should be a member of at least one organization to log in.
        :param builtins.str assertion_attribute_email: Friendly name or name of the attribute within the SAML assertion to use as the user email.
        :param builtins.str assertion_attribute_groups: Friendly name or name of the attribute within the SAML assertion to use as the user groups.
        :param builtins.str assertion_attribute_login: Friendly name or name of the attribute within the SAML assertion to use as the user login handle.
        :param builtins.str assertion_attribute_name: Friendly name or name of the attribute within the SAML assertion to use as the user name. Alternatively, this can be a template with variables that match the names of attributes within the SAML assertion.
        :param builtins.str assertion_attribute_org: Friendly name or name of the attribute within the SAML assertion to use as the user organization.
        :param builtins.str assertion_attribute_role: Friendly name or name of the attribute within the SAML assertion to use as the user roles.
        :param builtins.bool auto_login: Whether SAML auto login is enabled.
        :param builtins.str certificate: Base64-encoded string for the SP X.509 certificate.
        :param builtins.str certificate_path: Path for the SP X.509 certificate.
        :param builtins.str client_id: The client Id of your OAuth2 app.
        :param builtins.str client_secret: The client secret of your OAuth2 app.
        :param builtins.bool enabled: Define whether this configuration is enabled for SAML. Defaults to `true`.
        :param builtins.str entity_id: The entity ID is a globally unique identifier for the service provider. It is used to identify the service provider to the identity provider. Defaults to the URL of the Grafana instance if not set.
        :param builtins.bool force_use_graph_api: If enabled, Grafana will fetch groups from Microsoft Graph API instead of using the groups claim from the ID token.
        :param builtins.str idp_metadata: Base64-encoded string for the IdP SAML metadata XML.
        :param builtins.str idp_metadata_path: Path for the IdP SAML metadata XML.
        :param builtins.str idp_metadata_url: URL for the IdP SAML metadata XML.
        :param builtins.str max_issue_delay: Duration, since the IdP issued a response and the SP is allowed to process it. For example: 90s, 1h.
        :param builtins.str metadata_valid_duration: Duration, for how long the SP metadata is valid. For example: 48h, 5d.
        :param builtins.str name: Name used to refer to the SAML authentication.
        :param builtins.str name_id_format: The Name ID Format to request within the SAML assertion. Defaults to urn:oasis:names:tc:SAML:2.0:nameid-format:transient
        :param builtins.str org_mapping: List of comma- or space-separated Organization:OrgId:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: Viewer, Editor or Admin.
        :param builtins.str private_key: Base64-encoded string for the SP private key.
        :param builtins.str private_key_path: Path for the SP private key.
        :param builtins.str relay_state: Relay state for IdP-initiated login. Should match relay state configured in IdP.
        :param builtins.str role_values_admin: List of comma- or space-separated roles which will be mapped into the Admin role.
        :param builtins.str role_values_editor: List of comma- or space-separated roles which will be mapped into the Editor role.
        :param builtins.str role_values_grafana_admin: List of comma- or space-separated roles which will be mapped into the Grafana Admin (Super Admin) role.
        :param builtins.str role_values_none: List of comma- or space-separated roles which will be mapped into the None role.
        :param builtins.str role_values_viewer: List of comma- or space-separated roles which will be mapped into the Viewer role.
        :param builtins.str signature_algorithm: Signature algorithm used for signing requests to the IdP. Supported values are rsa-sha1, rsa-sha256, rsa-sha512.
        :param builtins.bool single_logout: Whether SAML Single Logout is enabled.
        :param builtins.bool skip_org_role_sync: Prevent synchronizing users’ organization roles from your IdP.
        :param builtins.str token_url: The token endpoint of your OAuth2 provider. Required for Azure AD providers.
        """
        if allow_idp_initiated is not None:
            pulumi.set(__self__, "allow_idp_initiated", allow_idp_initiated)
        if allow_sign_up is not None:
            pulumi.set(__self__, "allow_sign_up", allow_sign_up)
        if allowed_organizations is not None:
            pulumi.set(__self__, "allowed_organizations", allowed_organizations)
        if assertion_attribute_email is not None:
            pulumi.set(__self__, "assertion_attribute_email", assertion_attribute_email)
        if assertion_attribute_groups is not None:
            pulumi.set(__self__, "assertion_attribute_groups", assertion_attribute_groups)
        if assertion_attribute_login is not None:
            pulumi.set(__self__, "assertion_attribute_login", assertion_attribute_login)
        if assertion_attribute_name is not None:
            pulumi.set(__self__, "assertion_attribute_name", assertion_attribute_name)
        if assertion_attribute_org is not None:
            pulumi.set(__self__, "assertion_attribute_org", assertion_attribute_org)
        if assertion_attribute_role is not None:
            pulumi.set(__self__, "assertion_attribute_role", assertion_attribute_role)
        if auto_login is not None:
            pulumi.set(__self__, "auto_login", auto_login)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if certificate_path is not None:
            pulumi.set(__self__, "certificate_path", certificate_path)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if force_use_graph_api is not None:
            pulumi.set(__self__, "force_use_graph_api", force_use_graph_api)
        if idp_metadata is not None:
            pulumi.set(__self__, "idp_metadata", idp_metadata)
        if idp_metadata_path is not None:
            pulumi.set(__self__, "idp_metadata_path", idp_metadata_path)
        if idp_metadata_url is not None:
            pulumi.set(__self__, "idp_metadata_url", idp_metadata_url)
        if max_issue_delay is not None:
            pulumi.set(__self__, "max_issue_delay", max_issue_delay)
        if metadata_valid_duration is not None:
            pulumi.set(__self__, "metadata_valid_duration", metadata_valid_duration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if name_id_format is not None:
            pulumi.set(__self__, "name_id_format", name_id_format)
        if org_mapping is not None:
            pulumi.set(__self__, "org_mapping", org_mapping)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if private_key_path is not None:
            pulumi.set(__self__, "private_key_path", private_key_path)
        if relay_state is not None:
            pulumi.set(__self__, "relay_state", relay_state)
        if role_values_admin is not None:
            pulumi.set(__self__, "role_values_admin", role_values_admin)
        if role_values_editor is not None:
            pulumi.set(__self__, "role_values_editor", role_values_editor)
        if role_values_grafana_admin is not None:
            pulumi.set(__self__, "role_values_grafana_admin", role_values_grafana_admin)
        if role_values_none is not None:
            pulumi.set(__self__, "role_values_none", role_values_none)
        if role_values_viewer is not None:
            pulumi.set(__self__, "role_values_viewer", role_values_viewer)
        if signature_algorithm is not None:
            pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        if single_logout is not None:
            pulumi.set(__self__, "single_logout", single_logout)
        if skip_org_role_sync is not None:
            pulumi.set(__self__, "skip_org_role_sync", skip_org_role_sync)
        if token_url is not None:
            pulumi.set(__self__, "token_url", token_url)

    @property
    @pulumi.getter(name="allowIdpInitiated")
    def allow_idp_initiated(self) -> Optional[builtins.bool]:
        """
        Whether SAML IdP-initiated login is allowed.
        """
        return pulumi.get(self, "allow_idp_initiated")

    @property
    @pulumi.getter(name="allowSignUp")
    def allow_sign_up(self) -> Optional[builtins.bool]:
        """
        Whether to allow new Grafana user creation through SAML login. If set to false, then only existing Grafana users can log in with SAML.
        """
        return pulumi.get(self, "allow_sign_up")

    @property
    @pulumi.getter(name="allowedOrganizations")
    def allowed_organizations(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated organizations. User should be a member of at least one organization to log in.
        """
        return pulumi.get(self, "allowed_organizations")

    @property
    @pulumi.getter(name="assertionAttributeEmail")
    def assertion_attribute_email(self) -> Optional[builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user email.
        """
        return pulumi.get(self, "assertion_attribute_email")

    @property
    @pulumi.getter(name="assertionAttributeGroups")
    def assertion_attribute_groups(self) -> Optional[builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user groups.
        """
        return pulumi.get(self, "assertion_attribute_groups")

    @property
    @pulumi.getter(name="assertionAttributeLogin")
    def assertion_attribute_login(self) -> Optional[builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user login handle.
        """
        return pulumi.get(self, "assertion_attribute_login")

    @property
    @pulumi.getter(name="assertionAttributeName")
    def assertion_attribute_name(self) -> Optional[builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user name. Alternatively, this can be a template with variables that match the names of attributes within the SAML assertion.
        """
        return pulumi.get(self, "assertion_attribute_name")

    @property
    @pulumi.getter(name="assertionAttributeOrg")
    def assertion_attribute_org(self) -> Optional[builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user organization.
        """
        return pulumi.get(self, "assertion_attribute_org")

    @property
    @pulumi.getter(name="assertionAttributeRole")
    def assertion_attribute_role(self) -> Optional[builtins.str]:
        """
        Friendly name or name of the attribute within the SAML assertion to use as the user roles.
        """
        return pulumi.get(self, "assertion_attribute_role")

    @property
    @pulumi.getter(name="autoLogin")
    def auto_login(self) -> Optional[builtins.bool]:
        """
        Whether SAML auto login is enabled.
        """
        return pulumi.get(self, "auto_login")

    @property
    @pulumi.getter
    def certificate(self) -> Optional[builtins.str]:
        """
        Base64-encoded string for the SP X.509 certificate.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="certificatePath")
    def certificate_path(self) -> Optional[builtins.str]:
        """
        Path for the SP X.509 certificate.
        """
        return pulumi.get(self, "certificate_path")

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[builtins.str]:
        """
        The client Id of your OAuth2 app.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[builtins.str]:
        """
        The client secret of your OAuth2 app.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[builtins.bool]:
        """
        Define whether this configuration is enabled for SAML. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[builtins.str]:
        """
        The entity ID is a globally unique identifier for the service provider. It is used to identify the service provider to the identity provider. Defaults to the URL of the Grafana instance if not set.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="forceUseGraphApi")
    def force_use_graph_api(self) -> Optional[builtins.bool]:
        """
        If enabled, Grafana will fetch groups from Microsoft Graph API instead of using the groups claim from the ID token.
        """
        return pulumi.get(self, "force_use_graph_api")

    @property
    @pulumi.getter(name="idpMetadata")
    def idp_metadata(self) -> Optional[builtins.str]:
        """
        Base64-encoded string for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata")

    @property
    @pulumi.getter(name="idpMetadataPath")
    def idp_metadata_path(self) -> Optional[builtins.str]:
        """
        Path for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata_path")

    @property
    @pulumi.getter(name="idpMetadataUrl")
    def idp_metadata_url(self) -> Optional[builtins.str]:
        """
        URL for the IdP SAML metadata XML.
        """
        return pulumi.get(self, "idp_metadata_url")

    @property
    @pulumi.getter(name="maxIssueDelay")
    def max_issue_delay(self) -> Optional[builtins.str]:
        """
        Duration, since the IdP issued a response and the SP is allowed to process it. For example: 90s, 1h.
        """
        return pulumi.get(self, "max_issue_delay")

    @property
    @pulumi.getter(name="metadataValidDuration")
    def metadata_valid_duration(self) -> Optional[builtins.str]:
        """
        Duration, for how long the SP metadata is valid. For example: 48h, 5d.
        """
        return pulumi.get(self, "metadata_valid_duration")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        Name used to refer to the SAML authentication.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameIdFormat")
    def name_id_format(self) -> Optional[builtins.str]:
        """
        The Name ID Format to request within the SAML assertion. Defaults to urn:oasis:names:tc:SAML:2.0:nameid-format:transient
        """
        return pulumi.get(self, "name_id_format")

    @property
    @pulumi.getter(name="orgMapping")
    def org_mapping(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated Organization:OrgId:Role mappings. Organization can be * meaning “All users”. Role is optional and can have the following values: Viewer, Editor or Admin.
        """
        return pulumi.get(self, "org_mapping")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[builtins.str]:
        """
        Base64-encoded string for the SP private key.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="privateKeyPath")
    def private_key_path(self) -> Optional[builtins.str]:
        """
        Path for the SP private key.
        """
        return pulumi.get(self, "private_key_path")

    @property
    @pulumi.getter(name="relayState")
    def relay_state(self) -> Optional[builtins.str]:
        """
        Relay state for IdP-initiated login. Should match relay state configured in IdP.
        """
        return pulumi.get(self, "relay_state")

    @property
    @pulumi.getter(name="roleValuesAdmin")
    def role_values_admin(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Admin role.
        """
        return pulumi.get(self, "role_values_admin")

    @property
    @pulumi.getter(name="roleValuesEditor")
    def role_values_editor(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Editor role.
        """
        return pulumi.get(self, "role_values_editor")

    @property
    @pulumi.getter(name="roleValuesGrafanaAdmin")
    def role_values_grafana_admin(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Grafana Admin (Super Admin) role.
        """
        return pulumi.get(self, "role_values_grafana_admin")

    @property
    @pulumi.getter(name="roleValuesNone")
    def role_values_none(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the None role.
        """
        return pulumi.get(self, "role_values_none")

    @property
    @pulumi.getter(name="roleValuesViewer")
    def role_values_viewer(self) -> Optional[builtins.str]:
        """
        List of comma- or space-separated roles which will be mapped into the Viewer role.
        """
        return pulumi.get(self, "role_values_viewer")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> Optional[builtins.str]:
        """
        Signature algorithm used for signing requests to the IdP. Supported values are rsa-sha1, rsa-sha256, rsa-sha512.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="singleLogout")
    def single_logout(self) -> Optional[builtins.bool]:
        """
        Whether SAML Single Logout is enabled.
        """
        return pulumi.get(self, "single_logout")

    @property
    @pulumi.getter(name="skipOrgRoleSync")
    def skip_org_role_sync(self) -> Optional[builtins.bool]:
        """
        Prevent synchronizing users’ organization roles from your IdP.
        """
        return pulumi.get(self, "skip_org_role_sync")

    @property
    @pulumi.getter(name="tokenUrl")
    def token_url(self) -> Optional[builtins.str]:
        """
        The token endpoint of your OAuth2 provider. Required for Azure AD providers.
        """
        return pulumi.get(self, "token_url")


@pulumi.output_type
class TeamPreferences(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "homeDashboardUid":
            suggest = "home_dashboard_uid"
        elif key == "weekStart":
            suggest = "week_start"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TeamPreferences. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TeamPreferences.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TeamPreferences.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 home_dashboard_uid: Optional[builtins.str] = None,
                 theme: Optional[builtins.str] = None,
                 timezone: Optional[builtins.str] = None,
                 week_start: Optional[builtins.str] = None):
        """
        :param builtins.str home_dashboard_uid: The UID of the dashboard to display when a team member logs in.
        :param builtins.str theme: The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        :param builtins.str timezone: The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        :param builtins.str week_start: The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        if home_dashboard_uid is not None:
            pulumi.set(__self__, "home_dashboard_uid", home_dashboard_uid)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> Optional[builtins.str]:
        """
        The UID of the dashboard to display when a team member logs in.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @property
    @pulumi.getter
    def theme(self) -> Optional[builtins.str]:
        """
        The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        """
        return pulumi.get(self, "theme")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[builtins.str]:
        """
        The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[builtins.str]:
        """
        The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        return pulumi.get(self, "week_start")


@pulumi.output_type
class TeamTeamSync(dict):
    def __init__(__self__, *,
                 groups: Optional[Sequence[builtins.str]] = None):
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "groups")


@pulumi.output_type
class GetDashboardsDashboardResult(dict):
    def __init__(__self__, *,
                 folder_title: builtins.str,
                 title: builtins.str,
                 uid: builtins.str):
        pulumi.set(__self__, "folder_title", folder_title)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="folderTitle")
    def folder_title(self) -> builtins.str:
        return pulumi.get(self, "folder_title")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetFoldersFolderResult(dict):
    def __init__(__self__, *,
                 id: builtins.int,
                 title: builtins.str,
                 uid: builtins.str,
                 url: builtins.str):
        """
        :param builtins.int id: The folder ID.
        :param builtins.str title: The folder title.
        :param builtins.str uid: The folder's unique identifier.
        :param builtins.str url: The folder's URL
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "uid", uid)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        """
        The folder ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def title(self) -> builtins.str:
        """
        The folder title.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        """
        The folder's unique identifier.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The folder's URL
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class GetLibraryPanelsPanelResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 folder_uid: builtins.str,
                 model_json: builtins.str,
                 name: builtins.str,
                 uid: builtins.str):
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "folder_uid", folder_uid)
        pulumi.set(__self__, "model_json", model_json)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="folderUid")
    def folder_uid(self) -> builtins.str:
        return pulumi.get(self, "folder_uid")

    @property
    @pulumi.getter(name="modelJson")
    def model_json(self) -> builtins.str:
        return pulumi.get(self, "model_json")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uid(self) -> builtins.str:
        return pulumi.get(self, "uid")


@pulumi.output_type
class GetTeamPreferenceResult(dict):
    def __init__(__self__, *,
                 home_dashboard_uid: Optional[builtins.str] = None,
                 theme: Optional[builtins.str] = None,
                 timezone: Optional[builtins.str] = None,
                 week_start: Optional[builtins.str] = None):
        """
        :param builtins.str home_dashboard_uid: The UID of the dashboard to display when a team member logs in.
        :param builtins.str theme: The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        :param builtins.str timezone: The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        :param builtins.str week_start: The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        if home_dashboard_uid is not None:
            pulumi.set(__self__, "home_dashboard_uid", home_dashboard_uid)
        if theme is not None:
            pulumi.set(__self__, "theme", theme)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if week_start is not None:
            pulumi.set(__self__, "week_start", week_start)

    @property
    @pulumi.getter(name="homeDashboardUid")
    def home_dashboard_uid(self) -> Optional[builtins.str]:
        """
        The UID of the dashboard to display when a team member logs in.
        """
        return pulumi.get(self, "home_dashboard_uid")

    @property
    @pulumi.getter
    def theme(self) -> Optional[builtins.str]:
        """
        The default theme for this team. Available themes are `light`, `dark`, `system`, or an empty string for the default theme.
        """
        return pulumi.get(self, "theme")

    @property
    @pulumi.getter
    def timezone(self) -> Optional[builtins.str]:
        """
        The default timezone for this team. Available values are `utc`, `browser`, or an empty string for the default.
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter(name="weekStart")
    def week_start(self) -> Optional[builtins.str]:
        """
        The default week start day for this team. Available values are `sunday`, `monday`, `saturday`, or an empty string for the default.
        """
        return pulumi.get(self, "week_start")


@pulumi.output_type
class GetTeamTeamSyncResult(dict):
    def __init__(__self__, *,
                 groups: Optional[Sequence[builtins.str]] = None):
        if groups is not None:
            pulumi.set(__self__, "groups", groups)

    @property
    @pulumi.getter
    def groups(self) -> Optional[Sequence[builtins.str]]:
        return pulumi.get(self, "groups")


@pulumi.output_type
class GetUsersUserResult(dict):
    def __init__(__self__, *,
                 email: builtins.str,
                 id: builtins.int,
                 is_admin: builtins.bool,
                 login: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str email: The user's email.
        :param builtins.int id: The user ID.
        :param builtins.bool is_admin: Whether the user is admin or not.
        :param builtins.str login: The user's login.
        :param builtins.str name: The user's name.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_admin", is_admin)
        pulumi.set(__self__, "login", login)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> builtins.str:
        """
        The user's email.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> builtins.int:
        """
        The user ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> builtins.bool:
        """
        Whether the user is admin or not.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter
    def login(self) -> builtins.str:
        """
        The user's login.
        """
        return pulumi.get(self, "login")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The user's name.
        """
        return pulumi.get(self, "name")


