# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ServiceAccountTokenArgs', 'ServiceAccountToken']

@pulumi.input_type
class ServiceAccountTokenArgs:
    def __init__(__self__, *,
                 service_account_id: pulumi.Input[builtins.str],
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a ServiceAccountToken resource.
        :param pulumi.Input[builtins.str] service_account_id: The ID of the service account to which the token belongs.
        :param pulumi.Input[builtins.str] name: The name of the service account token.
        :param pulumi.Input[builtins.int] seconds_to_live: The key expiration in seconds. It is optional. If it is a positive number an expiration date for the key is set. If it is null, zero or is omitted completely (unless `api_key_max_seconds_to_live` configuration option is set) the key will never expire.
        """
        pulumi.set(__self__, "service_account_id", service_account_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if seconds_to_live is not None:
            pulumi.set(__self__, "seconds_to_live", seconds_to_live)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Input[builtins.str]:
        """
        The ID of the service account to which the token belongs.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "service_account_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the service account token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The key expiration in seconds. It is optional. If it is a positive number an expiration date for the key is set. If it is null, zero or is omitted completely (unless `api_key_max_seconds_to_live` configuration option is set) the key will never expire.
        """
        return pulumi.get(self, "seconds_to_live")

    @seconds_to_live.setter
    def seconds_to_live(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_to_live", value)


@pulumi.input_type
class _ServiceAccountTokenState:
    def __init__(__self__, *,
                 expiration: Optional[pulumi.Input[builtins.str]] = None,
                 has_expired: Optional[pulumi.Input[builtins.bool]] = None,
                 key: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
                 service_account_id: Optional[pulumi.Input[builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServiceAccountToken resources.
        :param pulumi.Input[builtins.str] expiration: The expiration date of the service account token.
        :param pulumi.Input[builtins.bool] has_expired: The status of the service account token.
        :param pulumi.Input[builtins.str] key: The key of the service account token.
        :param pulumi.Input[builtins.str] name: The name of the service account token.
        :param pulumi.Input[builtins.int] seconds_to_live: The key expiration in seconds. It is optional. If it is a positive number an expiration date for the key is set. If it is null, zero or is omitted completely (unless `api_key_max_seconds_to_live` configuration option is set) the key will never expire.
        :param pulumi.Input[builtins.str] service_account_id: The ID of the service account to which the token belongs.
        """
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if has_expired is not None:
            pulumi.set(__self__, "has_expired", has_expired)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if seconds_to_live is not None:
            pulumi.set(__self__, "seconds_to_live", seconds_to_live)
        if service_account_id is not None:
            pulumi.set(__self__, "service_account_id", service_account_id)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The expiration date of the service account token.
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter(name="hasExpired")
    def has_expired(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        The status of the service account token.
        """
        return pulumi.get(self, "has_expired")

    @has_expired.setter
    def has_expired(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "has_expired", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The key of the service account token.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the service account token.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The key expiration in seconds. It is optional. If it is a positive number an expiration date for the key is set. If it is null, zero or is omitted completely (unless `api_key_max_seconds_to_live` configuration option is set) the key will never expire.
        """
        return pulumi.get(self, "seconds_to_live")

    @seconds_to_live.setter
    def seconds_to_live(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "seconds_to_live", value)

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The ID of the service account to which the token belongs.
        """
        return pulumi.get(self, "service_account_id")

    @service_account_id.setter
    def service_account_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "service_account_id", value)


@pulumi.type_token("grafana:oss/serviceAccountToken:ServiceAccountToken")
class ServiceAccountToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
                 service_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        """
        **Note:** This resource is available only with Grafana 9.1+.

        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/service-accounts/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.oss.ServiceAccount("test",
            name="test-service-account",
            role="Viewer")
        foo = grafana.oss.ServiceAccountToken("foo",
            name="key_foo",
            service_account_id=test.id)
        bar = grafana.oss.ServiceAccountToken("bar",
            name="key_bar",
            service_account_id=test.id,
            seconds_to_live=30)
        pulumi.export("serviceAccountTokenFooKeyOnly", foo.key)
        pulumi.export("serviceAccountTokenBar", bar)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] name: The name of the service account token.
        :param pulumi.Input[builtins.int] seconds_to_live: The key expiration in seconds. It is optional. If it is a positive number an expiration date for the key is set. If it is null, zero or is omitted completely (unless `api_key_max_seconds_to_live` configuration option is set) the key will never expire.
        :param pulumi.Input[builtins.str] service_account_id: The ID of the service account to which the token belongs.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServiceAccountTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        **Note:** This resource is available only with Grafana 9.1+.

        * [Official documentation](https://grafana.com/docs/grafana/latest/administration/service-accounts/)
        * [HTTP API](https://grafana.com/docs/grafana/latest/developers/http_api/serviceaccount/#service-account-api)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        test = grafana.oss.ServiceAccount("test",
            name="test-service-account",
            role="Viewer")
        foo = grafana.oss.ServiceAccountToken("foo",
            name="key_foo",
            service_account_id=test.id)
        bar = grafana.oss.ServiceAccountToken("bar",
            name="key_bar",
            service_account_id=test.id,
            seconds_to_live=30)
        pulumi.export("serviceAccountTokenFooKeyOnly", foo.key)
        pulumi.export("serviceAccountTokenBar", bar)
        ```

        :param str resource_name: The name of the resource.
        :param ServiceAccountTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServiceAccountTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
                 service_account_id: Optional[pulumi.Input[builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServiceAccountTokenArgs.__new__(ServiceAccountTokenArgs)

            __props__.__dict__["name"] = name
            __props__.__dict__["seconds_to_live"] = seconds_to_live
            if service_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'service_account_id'")
            __props__.__dict__["service_account_id"] = service_account_id
            __props__.__dict__["expiration"] = None
            __props__.__dict__["has_expired"] = None
            __props__.__dict__["key"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/serviceAccountToken:ServiceAccountToken")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["key"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(ServiceAccountToken, __self__).__init__(
            'grafana:oss/serviceAccountToken:ServiceAccountToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            expiration: Optional[pulumi.Input[builtins.str]] = None,
            has_expired: Optional[pulumi.Input[builtins.bool]] = None,
            key: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            seconds_to_live: Optional[pulumi.Input[builtins.int]] = None,
            service_account_id: Optional[pulumi.Input[builtins.str]] = None) -> 'ServiceAccountToken':
        """
        Get an existing ServiceAccountToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] expiration: The expiration date of the service account token.
        :param pulumi.Input[builtins.bool] has_expired: The status of the service account token.
        :param pulumi.Input[builtins.str] key: The key of the service account token.
        :param pulumi.Input[builtins.str] name: The name of the service account token.
        :param pulumi.Input[builtins.int] seconds_to_live: The key expiration in seconds. It is optional. If it is a positive number an expiration date for the key is set. If it is null, zero or is omitted completely (unless `api_key_max_seconds_to_live` configuration option is set) the key will never expire.
        :param pulumi.Input[builtins.str] service_account_id: The ID of the service account to which the token belongs.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServiceAccountTokenState.__new__(_ServiceAccountTokenState)

        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["has_expired"] = has_expired
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["seconds_to_live"] = seconds_to_live
        __props__.__dict__["service_account_id"] = service_account_id
        return ServiceAccountToken(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[builtins.str]:
        """
        The expiration date of the service account token.
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter(name="hasExpired")
    def has_expired(self) -> pulumi.Output[builtins.bool]:
        """
        The status of the service account token.
        """
        return pulumi.get(self, "has_expired")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[builtins.str]:
        """
        The key of the service account token.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the service account token.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secondsToLive")
    def seconds_to_live(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        The key expiration in seconds. It is optional. If it is a positive number an expiration date for the key is set. If it is null, zero or is omitted completely (unless `api_key_max_seconds_to_live` configuration option is set) the key will never expire.
        """
        return pulumi.get(self, "seconds_to_live")

    @property
    @pulumi.getter(name="serviceAccountId")
    def service_account_id(self) -> pulumi.Output[builtins.str]:
        """
        The ID of the service account to which the token belongs.
        """
        return pulumi.get(self, "service_account_id")

