# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CheckArgs', 'Check']

@pulumi.input_type
class CheckArgs:
    def __init__(__self__, *,
                 job: pulumi.Input[builtins.str],
                 probes: pulumi.Input[Sequence[pulumi.Input[builtins.int]]],
                 settings: pulumi.Input['CheckSettingsArgs'],
                 target: pulumi.Input[builtins.str],
                 alert_sensitivity: Optional[pulumi.Input[builtins.str]] = None,
                 basic_metrics_only: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[builtins.int]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        The set of arguments for constructing a Check resource.
        :param pulumi.Input[builtins.str] job: Name used for job label.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] probes: List of probe location IDs where this target will be checked from.
        :param pulumi.Input['CheckSettingsArgs'] settings: Check settings. Should contain exactly one nested block.
        :param pulumi.Input[builtins.str] target: Hostname to ping.
        :param pulumi.Input[builtins.str] alert_sensitivity: Can be set to `none`, `low`, `medium`, or `high` to correspond to the check [alert levels](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/synthetic-monitoring-alerting/). Defaults to `none`.
        :param pulumi.Input[builtins.bool] basic_metrics_only: Metrics are reduced by default. Set this to `false` if you'd like to publish all metrics. We maintain a [full list of metrics](https://github.com/grafana/synthetic-monitoring-agent/tree/main/internal/scraper/testdata) collected for each. Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the check. Defaults to `true`.
        :param pulumi.Input[builtins.int] frequency: How often the check runs in milliseconds (the value is not truly a "frequency" but a "period"). The minimum acceptable value is 1 second (1000 ms), and the maximum is 1 hour (3600000 ms). Defaults to `60000`.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Custom labels to be included with collected metrics and logs. The maximum number of labels that can be specified per check is 5. These are applied, along with the probe-specific labels, to the outgoing metrics. The names and values of the labels cannot be empty, and the maximum length is 32 bytes.
        :param pulumi.Input[builtins.int] timeout: Specifies the maximum running time for the check in milliseconds. The minimum acceptable value is 1 second (1000 ms), and the maximum 180 seconds (180000 ms). Defaults to `3000`.
        """
        pulumi.set(__self__, "job", job)
        pulumi.set(__self__, "probes", probes)
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "target", target)
        if alert_sensitivity is not None:
            pulumi.set(__self__, "alert_sensitivity", alert_sensitivity)
        if basic_metrics_only is not None:
            pulumi.set(__self__, "basic_metrics_only", basic_metrics_only)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter
    def job(self) -> pulumi.Input[builtins.str]:
        """
        Name used for job label.
        """
        return pulumi.get(self, "job")

    @job.setter
    def job(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "job", value)

    @property
    @pulumi.getter
    def probes(self) -> pulumi.Input[Sequence[pulumi.Input[builtins.int]]]:
        """
        List of probe location IDs where this target will be checked from.
        """
        return pulumi.get(self, "probes")

    @probes.setter
    def probes(self, value: pulumi.Input[Sequence[pulumi.Input[builtins.int]]]):
        pulumi.set(self, "probes", value)

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Input['CheckSettingsArgs']:
        """
        Check settings. Should contain exactly one nested block.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: pulumi.Input['CheckSettingsArgs']):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def target(self) -> pulumi.Input[builtins.str]:
        """
        Hostname to ping.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="alertSensitivity")
    def alert_sensitivity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be set to `none`, `low`, `medium`, or `high` to correspond to the check [alert levels](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/synthetic-monitoring-alerting/). Defaults to `none`.
        """
        return pulumi.get(self, "alert_sensitivity")

    @alert_sensitivity.setter
    def alert_sensitivity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_sensitivity", value)

    @property
    @pulumi.getter(name="basicMetricsOnly")
    def basic_metrics_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Metrics are reduced by default. Set this to `false` if you'd like to publish all metrics. We maintain a [full list of metrics](https://github.com/grafana/synthetic-monitoring-agent/tree/main/internal/scraper/testdata) collected for each. Defaults to `true`.
        """
        return pulumi.get(self, "basic_metrics_only")

    @basic_metrics_only.setter
    def basic_metrics_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "basic_metrics_only", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable the check. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        How often the check runs in milliseconds (the value is not truly a "frequency" but a "period"). The minimum acceptable value is 1 second (1000 ms), and the maximum is 1 hour (3600000 ms). Defaults to `60000`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom labels to be included with collected metrics and logs. The maximum number of labels that can be specified per check is 5. These are applied, along with the probe-specific labels, to the outgoing metrics. The names and values of the labels cannot be empty, and the maximum length is 32 bytes.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum running time for the check in milliseconds. The minimum acceptable value is 1 second (1000 ms), and the maximum 180 seconds (180000 ms). Defaults to `3000`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.input_type
class _CheckState:
    def __init__(__self__, *,
                 alert_sensitivity: Optional[pulumi.Input[builtins.str]] = None,
                 basic_metrics_only: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[builtins.int]] = None,
                 job: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 settings: Optional[pulumi.Input['CheckSettingsArgs']] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[builtins.int]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering Check resources.
        :param pulumi.Input[builtins.str] alert_sensitivity: Can be set to `none`, `low`, `medium`, or `high` to correspond to the check [alert levels](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/synthetic-monitoring-alerting/). Defaults to `none`.
        :param pulumi.Input[builtins.bool] basic_metrics_only: Metrics are reduced by default. Set this to `false` if you'd like to publish all metrics. We maintain a [full list of metrics](https://github.com/grafana/synthetic-monitoring-agent/tree/main/internal/scraper/testdata) collected for each. Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the check. Defaults to `true`.
        :param pulumi.Input[builtins.int] frequency: How often the check runs in milliseconds (the value is not truly a "frequency" but a "period"). The minimum acceptable value is 1 second (1000 ms), and the maximum is 1 hour (3600000 ms). Defaults to `60000`.
        :param pulumi.Input[builtins.str] job: Name used for job label.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Custom labels to be included with collected metrics and logs. The maximum number of labels that can be specified per check is 5. These are applied, along with the probe-specific labels, to the outgoing metrics. The names and values of the labels cannot be empty, and the maximum length is 32 bytes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] probes: List of probe location IDs where this target will be checked from.
        :param pulumi.Input['CheckSettingsArgs'] settings: Check settings. Should contain exactly one nested block.
        :param pulumi.Input[builtins.str] target: Hostname to ping.
        :param pulumi.Input[builtins.int] tenant_id: The tenant ID of the check.
        :param pulumi.Input[builtins.int] timeout: Specifies the maximum running time for the check in milliseconds. The minimum acceptable value is 1 second (1000 ms), and the maximum 180 seconds (180000 ms). Defaults to `3000`.
        """
        if alert_sensitivity is not None:
            pulumi.set(__self__, "alert_sensitivity", alert_sensitivity)
        if basic_metrics_only is not None:
            pulumi.set(__self__, "basic_metrics_only", basic_metrics_only)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if frequency is not None:
            pulumi.set(__self__, "frequency", frequency)
        if job is not None:
            pulumi.set(__self__, "job", job)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if probes is not None:
            pulumi.set(__self__, "probes", probes)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if target is not None:
            pulumi.set(__self__, "target", target)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="alertSensitivity")
    def alert_sensitivity(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Can be set to `none`, `low`, `medium`, or `high` to correspond to the check [alert levels](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/synthetic-monitoring-alerting/). Defaults to `none`.
        """
        return pulumi.get(self, "alert_sensitivity")

    @alert_sensitivity.setter
    def alert_sensitivity(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "alert_sensitivity", value)

    @property
    @pulumi.getter(name="basicMetricsOnly")
    def basic_metrics_only(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Metrics are reduced by default. Set this to `false` if you'd like to publish all metrics. We maintain a [full list of metrics](https://github.com/grafana/synthetic-monitoring-agent/tree/main/internal/scraper/testdata) collected for each. Defaults to `true`.
        """
        return pulumi.get(self, "basic_metrics_only")

    @basic_metrics_only.setter
    def basic_metrics_only(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "basic_metrics_only", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Whether to enable the check. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def frequency(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        How often the check runs in milliseconds (the value is not truly a "frequency" but a "period"). The minimum acceptable value is 1 second (1000 ms), and the maximum is 1 hour (3600000 ms). Defaults to `60000`.
        """
        return pulumi.get(self, "frequency")

    @frequency.setter
    def frequency(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "frequency", value)

    @property
    @pulumi.getter
    def job(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Name used for job label.
        """
        return pulumi.get(self, "job")

    @job.setter
    def job(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "job", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]:
        """
        Custom labels to be included with collected metrics and logs. The maximum number of labels that can be specified per check is 5. These are applied, along with the probe-specific labels, to the outgoing metrics. The names and values of the labels cannot be empty, and the maximum length is 32 bytes.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def probes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]:
        """
        List of probe location IDs where this target will be checked from.
        """
        return pulumi.get(self, "probes")

    @probes.setter
    def probes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]]):
        pulumi.set(self, "probes", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input['CheckSettingsArgs']]:
        """
        Check settings. Should contain exactly one nested block.
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input['CheckSettingsArgs']]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Hostname to ping.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "target", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The tenant ID of the check.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter
    def timeout(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        Specifies the maximum running time for the check in milliseconds. The minimum acceptable value is 1 second (1000 ms), and the maximum 180 seconds (180000 ms). Defaults to `3000`.
        """
        return pulumi.get(self, "timeout")

    @timeout.setter
    def timeout(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "timeout", value)


@pulumi.type_token("grafana:syntheticMonitoring/check:Check")
class Check(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_sensitivity: Optional[pulumi.Input[builtins.str]] = None,
                 basic_metrics_only: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[builtins.int]] = None,
                 job: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 settings: Optional[pulumi.Input[Union['CheckSettingsArgs', 'CheckSettingsArgsDict']]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Synthetic Monitoring checks are tests that run on selected probes at defined
        intervals and report metrics and logs back to your Grafana Cloud account. The
        target for checks can be a domain name, a server, or a website, depending on
        what information you would like to gather about your endpoint. You can define
        multiple checks for a single endpoint to check different capabilities.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/)

        ## Example Usage

        ### DNS Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        dns = grafana.synthetic_monitoring.Check("dns",
            job="DNS Defaults",
            target="grafana.com",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "dns": {},
            })
        ```

        ### DNS Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        dns = grafana.synthetic_monitoring.Check("dns",
            job="DNS Updated",
            target="grafana.net",
            enabled=False,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "dns": {
                    "ip_version": "Any",
                    "server": "8.8.4.4",
                    "port": 8600,
                    "record_type": "CNAME",
                    "protocol": "TCP",
                    "valid_r_codes": [
                        "NOERROR",
                        "NOTAUTH",
                    ],
                    "validate_answer_rrs": {
                        "fail_if_matches_regexps": [".+-bad-stuff*"],
                        "fail_if_not_matches_regexps": [".+-good-stuff*"],
                    },
                    "validate_authority_rrs": {
                        "fail_if_matches_regexps": [".+-bad-stuff*"],
                        "fail_if_not_matches_regexps": [".+-good-stuff*"],
                    },
                    "validate_additional_rrs": [{
                        "fail_if_matches_regexps": [".+-bad-stuff*"],
                        "fail_if_not_matches_regexps": [".+-good-stuff*"],
                    }],
                },
            })
        ```

        ### HTTP Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        http = grafana.synthetic_monitoring.Check("http",
            job="HTTP Defaults",
            target="https://grafana.com",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "http": {},
            })
        ```

        ### HTTP Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        http = grafana.synthetic_monitoring.Check("http",
            job="HTTP Defaults",
            target="https://grafana.org",
            enabled=False,
            probes=[
                main.probes["mumbai"],
                main.probes["mumbai"],
            ],
            labels={
                "foo": "bar",
            },
            settings={
                "http": {
                    "ip_version": "V6",
                    "method": "TRACE",
                    "body": "and spirit",
                    "no_follow_redirects": True,
                    "bearer_token": "asdfjkl;",
                    "proxy_url": "https://almost-there",
                    "fail_if_ssl": True,
                    "fail_if_not_ssl": True,
                    "compression": "deflate",
                    "cache_busting_query_param_name": "pineapple",
                    "tls_config": {
                        "server_name": "grafana.org",
                        "client_cert": \"\"\"-----BEGIN CERTIFICATE-----
        MIIEljCCAn4CCQCKJPUQQxeO0zANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJT
        RTAeFw0yMTA1MjkxOTIyNTdaFw0yNDAzMTgxOTIyNTdaMA0xCzAJBgNVBAYTAlNF
        MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAnmbazDNUT0rSI4BpGZK+
        0AJ+9FDkIYWJUtRLJoxw8CF+AobMFploYA2L2Myt80cTA1w8FrewjC8qlqdnrPWr
        h1ely2zsUljgi1/niH0ndjFzliL7UkinXQiAsTtYOrOQmzyd/o5PNdu7dz0m7stD
        BN/Sz5TlXZnA1/eJbqV/kqMau6b1MaBx8SbRfUG9+cSmUobFJwuktDrPuwJhcEkl
        iDmhEqu1GuZzmKvzPacLTVia1vSlmCTCu89NiHI8iGiiLtqNrapup7f8j5m3a3SL
        a+vXhplFj2piNl7Nc0dfuVgtEliTI+qUL2/+4A7gzRWZpHy21/LxMMXmBhdJW9En
        FWkev97VZLgb5TR3+qpSWmXcodjPy4dibvwsOMpdd+Q4AYulwvlDw5idRPVgGvk7
        qq03+w9ppZ5Fugws9k2CD9F/75JX2mCbRpkuPe8XXZ7bqrMaQgQMLOrs68HuiiCk
        FTklglq4DMKxnf/Y/T/MgIa9Q1o28YSevh6A7FnfPGARj2H2T4rToi+bC1Vf7qNB
        Z18bDpz99tRUTbyiRUSBMWLCGhU6c4HAqUrfrkpperOKFBQ3i38a79838oFdXHBW
        6rx1t5cC3XwtEoUyeBKAygez8G1LDXbN3607MxVhAjhHKtPkYvuBfysSNU6JrR0z
        UV1IURJANt2UMuKgSEkG/IMCAwEAATANBgkqhkiG9w0BAQsFAAOCAgEAcipMhp/w
        yzfPy61faVAw9SPaMNRlnW9FCDC3N9CGOjo2knjXpObPzyzsJiUURTjrA9eFMpRA
        e2Rgn2j+nvm2XdLAlC4Kh8jqv/wCL0X6BTQMdN5aOhXdSiXtpXOMvXYY/dQ4ebRZ
        XeRCVWQD79JbV6/uyx0nCV3FVcU7L1P4UjxroefVr0soLPMirgxHmOxLnkoVgdcB
        tqufP5kJx9CIeJXPx3QQsk1XfEtxtUvuw4ZaZkQnNUqvGl7V+AZpur5Eqfv3zBi8
        QxxL7qGkARNssNWH2Ju+tqpM/UZRnjlFrDR4SXUgT0coTduBalUY6qHkciHmRpiP
        tf3SgpDeiCSOV2iVFGdaR1mz3muWoAYWFstcWN3a3HjjVugIi23yLN8Gv8CNeoH4
        prulinFCLrFgAh8SLAF8mOAZanT06LH8jOIFYrdUxH+ZeRBR0rLoFjUF+JB7UKD9
        5TA+B4EBzQ1tMbGFU1DX79MjAejq0IV0Nzq+GMfBvLHxEf4+Oz8nqhDXQcJ6TdtY
        l3Lyw5zBvOL80SBK+Mr0UP7d9U3VXgbGHCYVJU6Ot1TwiGwahtWALRALA3TWeGkq
        7kyD1H+nm+9lfKhuyBRQnRGBVyze2lAp7oxwshJuhBwEXosXFxq1Cy6QhPN77r6N
        vuhxvtppolNnyOgGxwG4zquqq2V5/+vKjKY=
        -----END CERTIFICATE-----
        \"\"\",
                    },
                    "headers": ["Content-Type: multipart/form-data; boundary=something"],
                    "basic_auth": {
                        "username": "open",
                        "password": "sesame",
                    },
                    "valid_status_codes": [
                        200,
                        201,
                    ],
                    "valid_http_versions": [
                        "HTTP/1.0",
                        "HTTP/1.1",
                        "HTTP/2.0",
                    ],
                    "fail_if_body_matches_regexps": [".*bad stuff.*"],
                    "fail_if_body_not_matches_regexps": [".*good stuff.*"],
                    "fail_if_header_matches_regexps": [{
                        "header": "Content-Type",
                        "regexp": "application/soap*",
                        "allow_missing": True,
                    }],
                },
            })
        ```

        ### Ping Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        ping = grafana.synthetic_monitoring.Check("ping",
            job="Ping Defaults",
            target="grafana.com",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "ping": {},
            })
        ```

        ### Ping Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        ping = grafana.synthetic_monitoring.Check("ping",
            job="Ping Updated",
            target="grafana.net",
            enabled=False,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "ping": {
                    "ip_version": "Any",
                    "payload_size": 20,
                    "dont_fragment": True,
                },
            })
        ```

        ### TCP Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        tcp = grafana.synthetic_monitoring.Check("tcp",
            job="TCP Defaults",
            target="grafana.com:80",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "tcp": {},
            })
        ```

        ### TCP Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        tcp = grafana.synthetic_monitoring.Check("tcp",
            job="TCP Defaults",
            target="grafana.com:443",
            enabled=False,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "tcp": {
                    "ip_version": "V6",
                    "tls": True,
                    "query_responses": [
                        {
                            "send": "howdy",
                            "expect": "hi",
                        },
                        {
                            "send": "like this",
                            "expect": "like that",
                            "start_tls": True,
                        },
                    ],
                    "tls_config": {
                        "server_name": "grafana.com",
                        "ca_cert": \"\"\"-----BEGIN CERTIFICATE-----
        MIIEljCCAn4CCQCKJPUQQxeO0zANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJT
        RTAeFw0yMTA1MjkxOTIyNTdaFw0yNDAzMTgxOTIyNTdaMA0xCzAJBgNVBAYTAlNF
        MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAnmbazDNUT0rSI4BpGZK+
        0AJ+9FDkIYWJUtRLJoxw8CF+AobMFploYA2L2Myt80cTA1w8FrewjC8qlqdnrPWr
        h1ely2zsUljgi1/niH0ndjFzliL7UkinXQiAsTtYOrOQmzyd/o5PNdu7dz0m7stD
        BN/Sz5TlXZnA1/eJbqV/kqMau6b1MaBx8SbRfUG9+cSmUobFJwuktDrPuwJhcEkl
        iDmhEqu1GuZzmKvzPacLTVia1vSlmCTCu89NiHI8iGiiLtqNrapup7f8j5m3a3SL
        a+vXhplFj2piNl7Nc0dfuVgtEliTI+qUL2/+4A7gzRWZpHy21/LxMMXmBhdJW9En
        FWkev97VZLgb5TR3+qpSWmXcodjPy4dibvwsOMpdd+Q4AYulwvlDw5idRPVgGvk7
        qq03+w9ppZ5Fugws9k2CD9F/75JX2mCbRpkuPe8XXZ7bqrMaQgQMLOrs68HuiiCk
        FTklglq4DMKxnf/Y/T/MgIa9Q1o28YSevh6A7FnfPGARj2H2T4rToi+bC1Vf7qNB
        Z18bDpz99tRUTbyiRUSBMWLCGhU6c4HAqUrfrkpperOKFBQ3i38a79838oFdXHBW
        6rx1t5cC3XwtEoUyeBKAygez8G1LDXbN3607MxVhAjhHKtPkYvuBfysSNU6JrR0z
        UV1IURJANt2UMuKgSEkG/IMCAwEAATANBgkqhkiG9w0BAQsFAAOCAgEAcipMhp/w
        yzfPy61faVAw9SPaMNRlnW9FCDC3N9CGOjo2knjXpObPzyzsJiUURTjrA9eFMpRA
        e2Rgn2j+nvm2XdLAlC4Kh8jqv/wCL0X6BTQMdN5aOhXdSiXtpXOMvXYY/dQ4ebRZ
        XeRCVWQD79JbV6/uyx0nCV3FVcU7L1P4UjxroefVr0soLPMirgxHmOxLnkoVgdcB
        tqufP5kJx9CIeJXPx3QQsk1XfEtxtUvuw4ZaZkQnNUqvGl7V+AZpur5Eqfv3zBi8
        QxxL7qGkARNssNWH2Ju+tqpM/UZRnjlFrDR4SXUgT0coTduBalUY6qHkciHmRpiP
        tf3SgpDeiCSOV2iVFGdaR1mz3muWoAYWFstcWN3a3HjjVugIi23yLN8Gv8CNeoH4
        prulinFCLrFgAh8SLAF8mOAZanT06LH8jOIFYrdUxH+ZeRBR0rLoFjUF+JB7UKD9
        5TA+B4EBzQ1tMbGFU1DX79MjAejq0IV0Nzq+GMfBvLHxEf4+Oz8nqhDXQcJ6TdtY
        l3Lyw5zBvOL80SBK+Mr0UP7d9U3VXgbGHCYVJU6Ot1TwiGwahtWALRALA3TWeGkq
        7kyD1H+nm+9lfKhuyBRQnRGBVyze2lAp7oxwshJuhBwEXosXFxq1Cy6QhPN77r6N
        vuhxvtppolNnyOgGxwG4zquqq2V5/+vKjKY=
        -----END CERTIFICATE-----
        \"\"\",
                    },
                },
            })
        ```

        ### Traceroute Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        traceroute = grafana.synthetic_monitoring.Check("traceroute",
            job="Traceroute defaults",
            target="grafana.com",
            enabled=False,
            frequency=120000,
            timeout=30000,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "traceroute": {},
            })
        ```

        ### Traceroute Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        traceroute = grafana.synthetic_monitoring.Check("traceroute",
            job="Traceroute complex",
            target="grafana.net",
            enabled=False,
            frequency=120000,
            timeout=30000,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "traceroute": {
                    "max_hops": 25,
                    "max_unknown_hops": 10,
                    "ptr_lookup": False,
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:syntheticMonitoring/check:Check name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_sensitivity: Can be set to `none`, `low`, `medium`, or `high` to correspond to the check [alert levels](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/synthetic-monitoring-alerting/). Defaults to `none`.
        :param pulumi.Input[builtins.bool] basic_metrics_only: Metrics are reduced by default. Set this to `false` if you'd like to publish all metrics. We maintain a [full list of metrics](https://github.com/grafana/synthetic-monitoring-agent/tree/main/internal/scraper/testdata) collected for each. Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the check. Defaults to `true`.
        :param pulumi.Input[builtins.int] frequency: How often the check runs in milliseconds (the value is not truly a "frequency" but a "period"). The minimum acceptable value is 1 second (1000 ms), and the maximum is 1 hour (3600000 ms). Defaults to `60000`.
        :param pulumi.Input[builtins.str] job: Name used for job label.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Custom labels to be included with collected metrics and logs. The maximum number of labels that can be specified per check is 5. These are applied, along with the probe-specific labels, to the outgoing metrics. The names and values of the labels cannot be empty, and the maximum length is 32 bytes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] probes: List of probe location IDs where this target will be checked from.
        :param pulumi.Input[Union['CheckSettingsArgs', 'CheckSettingsArgsDict']] settings: Check settings. Should contain exactly one nested block.
        :param pulumi.Input[builtins.str] target: Hostname to ping.
        :param pulumi.Input[builtins.int] timeout: Specifies the maximum running time for the check in milliseconds. The minimum acceptable value is 1 second (1000 ms), and the maximum 180 seconds (180000 ms). Defaults to `3000`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CheckArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Synthetic Monitoring checks are tests that run on selected probes at defined
        intervals and report metrics and logs back to your Grafana Cloud account. The
        target for checks can be a domain name, a server, or a website, depending on
        what information you would like to gather about your endpoint. You can define
        multiple checks for a single endpoint to check different capabilities.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/)

        ## Example Usage

        ### DNS Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        dns = grafana.synthetic_monitoring.Check("dns",
            job="DNS Defaults",
            target="grafana.com",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "dns": {},
            })
        ```

        ### DNS Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        dns = grafana.synthetic_monitoring.Check("dns",
            job="DNS Updated",
            target="grafana.net",
            enabled=False,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "dns": {
                    "ip_version": "Any",
                    "server": "8.8.4.4",
                    "port": 8600,
                    "record_type": "CNAME",
                    "protocol": "TCP",
                    "valid_r_codes": [
                        "NOERROR",
                        "NOTAUTH",
                    ],
                    "validate_answer_rrs": {
                        "fail_if_matches_regexps": [".+-bad-stuff*"],
                        "fail_if_not_matches_regexps": [".+-good-stuff*"],
                    },
                    "validate_authority_rrs": {
                        "fail_if_matches_regexps": [".+-bad-stuff*"],
                        "fail_if_not_matches_regexps": [".+-good-stuff*"],
                    },
                    "validate_additional_rrs": [{
                        "fail_if_matches_regexps": [".+-bad-stuff*"],
                        "fail_if_not_matches_regexps": [".+-good-stuff*"],
                    }],
                },
            })
        ```

        ### HTTP Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        http = grafana.synthetic_monitoring.Check("http",
            job="HTTP Defaults",
            target="https://grafana.com",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "http": {},
            })
        ```

        ### HTTP Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        http = grafana.synthetic_monitoring.Check("http",
            job="HTTP Defaults",
            target="https://grafana.org",
            enabled=False,
            probes=[
                main.probes["mumbai"],
                main.probes["mumbai"],
            ],
            labels={
                "foo": "bar",
            },
            settings={
                "http": {
                    "ip_version": "V6",
                    "method": "TRACE",
                    "body": "and spirit",
                    "no_follow_redirects": True,
                    "bearer_token": "asdfjkl;",
                    "proxy_url": "https://almost-there",
                    "fail_if_ssl": True,
                    "fail_if_not_ssl": True,
                    "compression": "deflate",
                    "cache_busting_query_param_name": "pineapple",
                    "tls_config": {
                        "server_name": "grafana.org",
                        "client_cert": \"\"\"-----BEGIN CERTIFICATE-----
        MIIEljCCAn4CCQCKJPUQQxeO0zANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJT
        RTAeFw0yMTA1MjkxOTIyNTdaFw0yNDAzMTgxOTIyNTdaMA0xCzAJBgNVBAYTAlNF
        MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAnmbazDNUT0rSI4BpGZK+
        0AJ+9FDkIYWJUtRLJoxw8CF+AobMFploYA2L2Myt80cTA1w8FrewjC8qlqdnrPWr
        h1ely2zsUljgi1/niH0ndjFzliL7UkinXQiAsTtYOrOQmzyd/o5PNdu7dz0m7stD
        BN/Sz5TlXZnA1/eJbqV/kqMau6b1MaBx8SbRfUG9+cSmUobFJwuktDrPuwJhcEkl
        iDmhEqu1GuZzmKvzPacLTVia1vSlmCTCu89NiHI8iGiiLtqNrapup7f8j5m3a3SL
        a+vXhplFj2piNl7Nc0dfuVgtEliTI+qUL2/+4A7gzRWZpHy21/LxMMXmBhdJW9En
        FWkev97VZLgb5TR3+qpSWmXcodjPy4dibvwsOMpdd+Q4AYulwvlDw5idRPVgGvk7
        qq03+w9ppZ5Fugws9k2CD9F/75JX2mCbRpkuPe8XXZ7bqrMaQgQMLOrs68HuiiCk
        FTklglq4DMKxnf/Y/T/MgIa9Q1o28YSevh6A7FnfPGARj2H2T4rToi+bC1Vf7qNB
        Z18bDpz99tRUTbyiRUSBMWLCGhU6c4HAqUrfrkpperOKFBQ3i38a79838oFdXHBW
        6rx1t5cC3XwtEoUyeBKAygez8G1LDXbN3607MxVhAjhHKtPkYvuBfysSNU6JrR0z
        UV1IURJANt2UMuKgSEkG/IMCAwEAATANBgkqhkiG9w0BAQsFAAOCAgEAcipMhp/w
        yzfPy61faVAw9SPaMNRlnW9FCDC3N9CGOjo2knjXpObPzyzsJiUURTjrA9eFMpRA
        e2Rgn2j+nvm2XdLAlC4Kh8jqv/wCL0X6BTQMdN5aOhXdSiXtpXOMvXYY/dQ4ebRZ
        XeRCVWQD79JbV6/uyx0nCV3FVcU7L1P4UjxroefVr0soLPMirgxHmOxLnkoVgdcB
        tqufP5kJx9CIeJXPx3QQsk1XfEtxtUvuw4ZaZkQnNUqvGl7V+AZpur5Eqfv3zBi8
        QxxL7qGkARNssNWH2Ju+tqpM/UZRnjlFrDR4SXUgT0coTduBalUY6qHkciHmRpiP
        tf3SgpDeiCSOV2iVFGdaR1mz3muWoAYWFstcWN3a3HjjVugIi23yLN8Gv8CNeoH4
        prulinFCLrFgAh8SLAF8mOAZanT06LH8jOIFYrdUxH+ZeRBR0rLoFjUF+JB7UKD9
        5TA+B4EBzQ1tMbGFU1DX79MjAejq0IV0Nzq+GMfBvLHxEf4+Oz8nqhDXQcJ6TdtY
        l3Lyw5zBvOL80SBK+Mr0UP7d9U3VXgbGHCYVJU6Ot1TwiGwahtWALRALA3TWeGkq
        7kyD1H+nm+9lfKhuyBRQnRGBVyze2lAp7oxwshJuhBwEXosXFxq1Cy6QhPN77r6N
        vuhxvtppolNnyOgGxwG4zquqq2V5/+vKjKY=
        -----END CERTIFICATE-----
        \"\"\",
                    },
                    "headers": ["Content-Type: multipart/form-data; boundary=something"],
                    "basic_auth": {
                        "username": "open",
                        "password": "sesame",
                    },
                    "valid_status_codes": [
                        200,
                        201,
                    ],
                    "valid_http_versions": [
                        "HTTP/1.0",
                        "HTTP/1.1",
                        "HTTP/2.0",
                    ],
                    "fail_if_body_matches_regexps": [".*bad stuff.*"],
                    "fail_if_body_not_matches_regexps": [".*good stuff.*"],
                    "fail_if_header_matches_regexps": [{
                        "header": "Content-Type",
                        "regexp": "application/soap*",
                        "allow_missing": True,
                    }],
                },
            })
        ```

        ### Ping Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        ping = grafana.synthetic_monitoring.Check("ping",
            job="Ping Defaults",
            target="grafana.com",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "ping": {},
            })
        ```

        ### Ping Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        ping = grafana.synthetic_monitoring.Check("ping",
            job="Ping Updated",
            target="grafana.net",
            enabled=False,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "ping": {
                    "ip_version": "Any",
                    "payload_size": 20,
                    "dont_fragment": True,
                },
            })
        ```

        ### TCP Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        tcp = grafana.synthetic_monitoring.Check("tcp",
            job="TCP Defaults",
            target="grafana.com:80",
            enabled=False,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "tcp": {},
            })
        ```

        ### TCP Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        tcp = grafana.synthetic_monitoring.Check("tcp",
            job="TCP Defaults",
            target="grafana.com:443",
            enabled=False,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "tcp": {
                    "ip_version": "V6",
                    "tls": True,
                    "query_responses": [
                        {
                            "send": "howdy",
                            "expect": "hi",
                        },
                        {
                            "send": "like this",
                            "expect": "like that",
                            "start_tls": True,
                        },
                    ],
                    "tls_config": {
                        "server_name": "grafana.com",
                        "ca_cert": \"\"\"-----BEGIN CERTIFICATE-----
        MIIEljCCAn4CCQCKJPUQQxeO0zANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJT
        RTAeFw0yMTA1MjkxOTIyNTdaFw0yNDAzMTgxOTIyNTdaMA0xCzAJBgNVBAYTAlNF
        MIICIjANBgkqhkiG9w0BAQEFAAOCAg8AMIICCgKCAgEAnmbazDNUT0rSI4BpGZK+
        0AJ+9FDkIYWJUtRLJoxw8CF+AobMFploYA2L2Myt80cTA1w8FrewjC8qlqdnrPWr
        h1ely2zsUljgi1/niH0ndjFzliL7UkinXQiAsTtYOrOQmzyd/o5PNdu7dz0m7stD
        BN/Sz5TlXZnA1/eJbqV/kqMau6b1MaBx8SbRfUG9+cSmUobFJwuktDrPuwJhcEkl
        iDmhEqu1GuZzmKvzPacLTVia1vSlmCTCu89NiHI8iGiiLtqNrapup7f8j5m3a3SL
        a+vXhplFj2piNl7Nc0dfuVgtEliTI+qUL2/+4A7gzRWZpHy21/LxMMXmBhdJW9En
        FWkev97VZLgb5TR3+qpSWmXcodjPy4dibvwsOMpdd+Q4AYulwvlDw5idRPVgGvk7
        qq03+w9ppZ5Fugws9k2CD9F/75JX2mCbRpkuPe8XXZ7bqrMaQgQMLOrs68HuiiCk
        FTklglq4DMKxnf/Y/T/MgIa9Q1o28YSevh6A7FnfPGARj2H2T4rToi+bC1Vf7qNB
        Z18bDpz99tRUTbyiRUSBMWLCGhU6c4HAqUrfrkpperOKFBQ3i38a79838oFdXHBW
        6rx1t5cC3XwtEoUyeBKAygez8G1LDXbN3607MxVhAjhHKtPkYvuBfysSNU6JrR0z
        UV1IURJANt2UMuKgSEkG/IMCAwEAATANBgkqhkiG9w0BAQsFAAOCAgEAcipMhp/w
        yzfPy61faVAw9SPaMNRlnW9FCDC3N9CGOjo2knjXpObPzyzsJiUURTjrA9eFMpRA
        e2Rgn2j+nvm2XdLAlC4Kh8jqv/wCL0X6BTQMdN5aOhXdSiXtpXOMvXYY/dQ4ebRZ
        XeRCVWQD79JbV6/uyx0nCV3FVcU7L1P4UjxroefVr0soLPMirgxHmOxLnkoVgdcB
        tqufP5kJx9CIeJXPx3QQsk1XfEtxtUvuw4ZaZkQnNUqvGl7V+AZpur5Eqfv3zBi8
        QxxL7qGkARNssNWH2Ju+tqpM/UZRnjlFrDR4SXUgT0coTduBalUY6qHkciHmRpiP
        tf3SgpDeiCSOV2iVFGdaR1mz3muWoAYWFstcWN3a3HjjVugIi23yLN8Gv8CNeoH4
        prulinFCLrFgAh8SLAF8mOAZanT06LH8jOIFYrdUxH+ZeRBR0rLoFjUF+JB7UKD9
        5TA+B4EBzQ1tMbGFU1DX79MjAejq0IV0Nzq+GMfBvLHxEf4+Oz8nqhDXQcJ6TdtY
        l3Lyw5zBvOL80SBK+Mr0UP7d9U3VXgbGHCYVJU6Ot1TwiGwahtWALRALA3TWeGkq
        7kyD1H+nm+9lfKhuyBRQnRGBVyze2lAp7oxwshJuhBwEXosXFxq1Cy6QhPN77r6N
        vuhxvtppolNnyOgGxwG4zquqq2V5/+vKjKY=
        -----END CERTIFICATE-----
        \"\"\",
                    },
                },
            })
        ```

        ### Traceroute Basic

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        traceroute = grafana.synthetic_monitoring.Check("traceroute",
            job="Traceroute defaults",
            target="grafana.com",
            enabled=False,
            frequency=120000,
            timeout=30000,
            probes=[main.probes["ohio"]],
            labels={
                "foo": "bar",
            },
            settings={
                "traceroute": {},
            })
        ```

        ### Traceroute Complex

        ```python
        import pulumi
        import pulumi_grafana as grafana
        import pulumiverse_grafana as grafana

        main = grafana.syntheticMonitoring.get_probes()
        traceroute = grafana.synthetic_monitoring.Check("traceroute",
            job="Traceroute complex",
            target="grafana.net",
            enabled=False,
            frequency=120000,
            timeout=30000,
            probes=[
                main.probes["frankfurt"],
                main.probes["london"],
            ],
            labels={
                "foo": "baz",
            },
            settings={
                "traceroute": {
                    "max_hops": 25,
                    "max_unknown_hops": 10,
                    "ptr_lookup": False,
                },
            })
        ```

        ## Import

        ```sh
        $ pulumi import grafana:syntheticMonitoring/check:Check name "{{ id }}"
        ```

        :param str resource_name: The name of the resource.
        :param CheckArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CheckArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alert_sensitivity: Optional[pulumi.Input[builtins.str]] = None,
                 basic_metrics_only: Optional[pulumi.Input[builtins.bool]] = None,
                 enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 frequency: Optional[pulumi.Input[builtins.int]] = None,
                 job: Optional[pulumi.Input[builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
                 probes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
                 settings: Optional[pulumi.Input[Union['CheckSettingsArgs', 'CheckSettingsArgsDict']]] = None,
                 target: Optional[pulumi.Input[builtins.str]] = None,
                 timeout: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CheckArgs.__new__(CheckArgs)

            __props__.__dict__["alert_sensitivity"] = alert_sensitivity
            __props__.__dict__["basic_metrics_only"] = basic_metrics_only
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["frequency"] = frequency
            if job is None and not opts.urn:
                raise TypeError("Missing required property 'job'")
            __props__.__dict__["job"] = job
            __props__.__dict__["labels"] = labels
            if probes is None and not opts.urn:
                raise TypeError("Missing required property 'probes'")
            __props__.__dict__["probes"] = probes
            if settings is None and not opts.urn:
                raise TypeError("Missing required property 'settings'")
            __props__.__dict__["settings"] = settings
            if target is None and not opts.urn:
                raise TypeError("Missing required property 'target'")
            __props__.__dict__["target"] = target
            __props__.__dict__["timeout"] = timeout
            __props__.__dict__["tenant_id"] = None
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="grafana:index/syntheticMonitoringCheck:SyntheticMonitoringCheck")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(Check, __self__).__init__(
            'grafana:syntheticMonitoring/check:Check',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alert_sensitivity: Optional[pulumi.Input[builtins.str]] = None,
            basic_metrics_only: Optional[pulumi.Input[builtins.bool]] = None,
            enabled: Optional[pulumi.Input[builtins.bool]] = None,
            frequency: Optional[pulumi.Input[builtins.int]] = None,
            job: Optional[pulumi.Input[builtins.str]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]]] = None,
            probes: Optional[pulumi.Input[Sequence[pulumi.Input[builtins.int]]]] = None,
            settings: Optional[pulumi.Input[Union['CheckSettingsArgs', 'CheckSettingsArgsDict']]] = None,
            target: Optional[pulumi.Input[builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[builtins.int]] = None,
            timeout: Optional[pulumi.Input[builtins.int]] = None) -> 'Check':
        """
        Get an existing Check resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[builtins.str] alert_sensitivity: Can be set to `none`, `low`, `medium`, or `high` to correspond to the check [alert levels](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/synthetic-monitoring-alerting/). Defaults to `none`.
        :param pulumi.Input[builtins.bool] basic_metrics_only: Metrics are reduced by default. Set this to `false` if you'd like to publish all metrics. We maintain a [full list of metrics](https://github.com/grafana/synthetic-monitoring-agent/tree/main/internal/scraper/testdata) collected for each. Defaults to `true`.
        :param pulumi.Input[builtins.bool] enabled: Whether to enable the check. Defaults to `true`.
        :param pulumi.Input[builtins.int] frequency: How often the check runs in milliseconds (the value is not truly a "frequency" but a "period"). The minimum acceptable value is 1 second (1000 ms), and the maximum is 1 hour (3600000 ms). Defaults to `60000`.
        :param pulumi.Input[builtins.str] job: Name used for job label.
        :param pulumi.Input[Mapping[str, pulumi.Input[builtins.str]]] labels: Custom labels to be included with collected metrics and logs. The maximum number of labels that can be specified per check is 5. These are applied, along with the probe-specific labels, to the outgoing metrics. The names and values of the labels cannot be empty, and the maximum length is 32 bytes.
        :param pulumi.Input[Sequence[pulumi.Input[builtins.int]]] probes: List of probe location IDs where this target will be checked from.
        :param pulumi.Input[Union['CheckSettingsArgs', 'CheckSettingsArgsDict']] settings: Check settings. Should contain exactly one nested block.
        :param pulumi.Input[builtins.str] target: Hostname to ping.
        :param pulumi.Input[builtins.int] tenant_id: The tenant ID of the check.
        :param pulumi.Input[builtins.int] timeout: Specifies the maximum running time for the check in milliseconds. The minimum acceptable value is 1 second (1000 ms), and the maximum 180 seconds (180000 ms). Defaults to `3000`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CheckState.__new__(_CheckState)

        __props__.__dict__["alert_sensitivity"] = alert_sensitivity
        __props__.__dict__["basic_metrics_only"] = basic_metrics_only
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["frequency"] = frequency
        __props__.__dict__["job"] = job
        __props__.__dict__["labels"] = labels
        __props__.__dict__["probes"] = probes
        __props__.__dict__["settings"] = settings
        __props__.__dict__["target"] = target
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["timeout"] = timeout
        return Check(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alertSensitivity")
    def alert_sensitivity(self) -> pulumi.Output[Optional[builtins.str]]:
        """
        Can be set to `none`, `low`, `medium`, or `high` to correspond to the check [alert levels](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/synthetic-monitoring-alerting/). Defaults to `none`.
        """
        return pulumi.get(self, "alert_sensitivity")

    @property
    @pulumi.getter(name="basicMetricsOnly")
    def basic_metrics_only(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Metrics are reduced by default. Set this to `false` if you'd like to publish all metrics. We maintain a [full list of metrics](https://github.com/grafana/synthetic-monitoring-agent/tree/main/internal/scraper/testdata) collected for each. Defaults to `true`.
        """
        return pulumi.get(self, "basic_metrics_only")

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[builtins.bool]]:
        """
        Whether to enable the check. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def frequency(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        How often the check runs in milliseconds (the value is not truly a "frequency" but a "period"). The minimum acceptable value is 1 second (1000 ms), and the maximum is 1 hour (3600000 ms). Defaults to `60000`.
        """
        return pulumi.get(self, "frequency")

    @property
    @pulumi.getter
    def job(self) -> pulumi.Output[builtins.str]:
        """
        Name used for job label.
        """
        return pulumi.get(self, "job")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, builtins.str]]]:
        """
        Custom labels to be included with collected metrics and logs. The maximum number of labels that can be specified per check is 5. These are applied, along with the probe-specific labels, to the outgoing metrics. The names and values of the labels cannot be empty, and the maximum length is 32 bytes.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def probes(self) -> pulumi.Output[Sequence[builtins.int]]:
        """
        List of probe location IDs where this target will be checked from.
        """
        return pulumi.get(self, "probes")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output['outputs.CheckSettings']:
        """
        Check settings. Should contain exactly one nested block.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def target(self) -> pulumi.Output[builtins.str]:
        """
        Hostname to ping.
        """
        return pulumi.get(self, "target")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[builtins.int]:
        """
        The tenant ID of the check.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter
    def timeout(self) -> pulumi.Output[Optional[builtins.int]]:
        """
        Specifies the maximum running time for the check in milliseconds. The minimum acceptable value is 1 second (1000 ms), and the maximum 180 seconds (180000 ms). Defaults to `3000`.
        """
        return pulumi.get(self, "timeout")

