# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CheckAlertsArgs', 'CheckAlerts']

@pulumi.input_type
class CheckAlertsArgs:
    def __init__(__self__, *,
                 alerts: pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]],
                 check_id: pulumi.Input[builtins.int]):
        """
        The set of arguments for constructing a CheckAlerts resource.
        :param pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]] alerts: List of alerts for the check.
        :param pulumi.Input[builtins.int] check_id: The ID of the check to manage alerts for.
        """
        pulumi.set(__self__, "alerts", alerts)
        pulumi.set(__self__, "check_id", check_id)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]]:
        """
        List of alerts for the check.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="checkId")
    def check_id(self) -> pulumi.Input[builtins.int]:
        """
        The ID of the check to manage alerts for.
        """
        return pulumi.get(self, "check_id")

    @check_id.setter
    def check_id(self, value: pulumi.Input[builtins.int]):
        pulumi.set(self, "check_id", value)


@pulumi.input_type
class _CheckAlertsState:
    def __init__(__self__, *,
                 alerts: Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]]] = None,
                 check_id: Optional[pulumi.Input[builtins.int]] = None):
        """
        Input properties used for looking up and filtering CheckAlerts resources.
        :param pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]] alerts: List of alerts for the check.
        :param pulumi.Input[builtins.int] check_id: The ID of the check to manage alerts for.
        """
        if alerts is not None:
            pulumi.set(__self__, "alerts", alerts)
        if check_id is not None:
            pulumi.set(__self__, "check_id", check_id)

    @property
    @pulumi.getter
    def alerts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]]]:
        """
        List of alerts for the check.
        """
        return pulumi.get(self, "alerts")

    @alerts.setter
    def alerts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CheckAlertsAlertArgs']]]]):
        pulumi.set(self, "alerts", value)

    @property
    @pulumi.getter(name="checkId")
    def check_id(self) -> Optional[pulumi.Input[builtins.int]]:
        """
        The ID of the check to manage alerts for.
        """
        return pulumi.get(self, "check_id")

    @check_id.setter
    def check_id(self, value: Optional[pulumi.Input[builtins.int]]):
        pulumi.set(self, "check_id", value)


@pulumi.type_token("grafana:syntheticMonitoring/checkAlerts:CheckAlerts")
class CheckAlerts(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertsAlertArgs', 'CheckAlertsAlertArgsDict']]]]] = None,
                 check_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        """
        Manages alerts for a check in Grafana Synthetic Monitoring.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/configure-per-check-alerts/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        main = grafana.synthetic_monitoring.Check("main",
            job="Check Alert Test",
            target="https://grafana.com",
            enabled=True,
            probes=[1],
            labels={},
            settings={
                "http": {
                    "ip_version": "V4",
                    "method": "GET",
                },
            })
        main_check_alerts = grafana.synthetic_monitoring.CheckAlerts("main",
            check_id=main.id,
            alerts=[
                {
                    "name": "ProbeFailedExecutionsTooHigh",
                    "threshold": 1,
                    "period": "15m",
                },
                {
                    "name": "TLSTargetCertificateCloseToExpiring",
                    "threshold": 14,
                    "period": "",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:syntheticMonitoring/checkAlerts:CheckAlerts name "{{ check_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertsAlertArgs', 'CheckAlertsAlertArgsDict']]]] alerts: List of alerts for the check.
        :param pulumi.Input[builtins.int] check_id: The ID of the check to manage alerts for.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CheckAlertsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages alerts for a check in Grafana Synthetic Monitoring.

        * [Official documentation](https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/configure-alerts/configure-per-check-alerts/)

        ## Example Usage

        ```python
        import pulumi
        import pulumiverse_grafana as grafana

        main = grafana.synthetic_monitoring.Check("main",
            job="Check Alert Test",
            target="https://grafana.com",
            enabled=True,
            probes=[1],
            labels={},
            settings={
                "http": {
                    "ip_version": "V4",
                    "method": "GET",
                },
            })
        main_check_alerts = grafana.synthetic_monitoring.CheckAlerts("main",
            check_id=main.id,
            alerts=[
                {
                    "name": "ProbeFailedExecutionsTooHigh",
                    "threshold": 1,
                    "period": "15m",
                },
                {
                    "name": "TLSTargetCertificateCloseToExpiring",
                    "threshold": 14,
                    "period": "",
                },
            ])
        ```

        ## Import

        ```sh
        $ pulumi import grafana:syntheticMonitoring/checkAlerts:CheckAlerts name "{{ check_id }}"
        ```

        :param str resource_name: The name of the resource.
        :param CheckAlertsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CheckAlertsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alerts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertsAlertArgs', 'CheckAlertsAlertArgsDict']]]]] = None,
                 check_id: Optional[pulumi.Input[builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CheckAlertsArgs.__new__(CheckAlertsArgs)

            if alerts is None and not opts.urn:
                raise TypeError("Missing required property 'alerts'")
            __props__.__dict__["alerts"] = alerts
            if check_id is None and not opts.urn:
                raise TypeError("Missing required property 'check_id'")
            __props__.__dict__["check_id"] = check_id
        super(CheckAlerts, __self__).__init__(
            'grafana:syntheticMonitoring/checkAlerts:CheckAlerts',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alerts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertsAlertArgs', 'CheckAlertsAlertArgsDict']]]]] = None,
            check_id: Optional[pulumi.Input[builtins.int]] = None) -> 'CheckAlerts':
        """
        Get an existing CheckAlerts resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CheckAlertsAlertArgs', 'CheckAlertsAlertArgsDict']]]] alerts: List of alerts for the check.
        :param pulumi.Input[builtins.int] check_id: The ID of the check to manage alerts for.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CheckAlertsState.__new__(_CheckAlertsState)

        __props__.__dict__["alerts"] = alerts
        __props__.__dict__["check_id"] = check_id
        return CheckAlerts(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def alerts(self) -> pulumi.Output[Sequence['outputs.CheckAlertsAlert']]:
        """
        List of alerts for the check.
        """
        return pulumi.get(self, "alerts")

    @property
    @pulumi.getter(name="checkId")
    def check_id(self) -> pulumi.Output[builtins.int]:
        """
        The ID of the check to manage alerts for.
        """
        return pulumi.get(self, "check_id")

