# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'CheckAlertsAlert',
    'CheckSettings',
    'CheckSettingsBrowser',
    'CheckSettingsDns',
    'CheckSettingsDnsValidateAdditionalRr',
    'CheckSettingsDnsValidateAnswerRrs',
    'CheckSettingsDnsValidateAuthorityRrs',
    'CheckSettingsGrpc',
    'CheckSettingsGrpcTlsConfig',
    'CheckSettingsHttp',
    'CheckSettingsHttpBasicAuth',
    'CheckSettingsHttpFailIfHeaderMatchesRegexp',
    'CheckSettingsHttpFailIfHeaderNotMatchesRegexp',
    'CheckSettingsHttpTlsConfig',
    'CheckSettingsMultihttp',
    'CheckSettingsMultihttpEntry',
    'CheckSettingsMultihttpEntryAssertion',
    'CheckSettingsMultihttpEntryRequest',
    'CheckSettingsMultihttpEntryRequestBody',
    'CheckSettingsMultihttpEntryRequestHeader',
    'CheckSettingsMultihttpEntryRequestQueryField',
    'CheckSettingsMultihttpEntryVariable',
    'CheckSettingsPing',
    'CheckSettingsScripted',
    'CheckSettingsTcp',
    'CheckSettingsTcpQueryResponse',
    'CheckSettingsTcpTlsConfig',
    'CheckSettingsTraceroute',
]

@pulumi.output_type
class CheckAlertsAlert(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 threshold: builtins.float,
                 period: Optional[builtins.str] = None):
        """
        :param builtins.str name: Name of the alert. Required.
        :param builtins.float threshold: Threshold value for the alert.
        :param builtins.str period: Period for the alert. Required and must be one of: `5m`, `10m`, `15m`, `20m`, `30m`, `1h`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "threshold", threshold)
        if period is not None:
            pulumi.set(__self__, "period", period)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the alert. Required.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def threshold(self) -> builtins.float:
        """
        Threshold value for the alert.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def period(self) -> Optional[builtins.str]:
        """
        Period for the alert. Required and must be one of: `5m`, `10m`, `15m`, `20m`, `30m`, `1h`.
        """
        return pulumi.get(self, "period")


@pulumi.output_type
class CheckSettings(dict):
    def __init__(__self__, *,
                 browser: Optional['outputs.CheckSettingsBrowser'] = None,
                 dns: Optional['outputs.CheckSettingsDns'] = None,
                 grpc: Optional['outputs.CheckSettingsGrpc'] = None,
                 http: Optional['outputs.CheckSettingsHttp'] = None,
                 multihttp: Optional['outputs.CheckSettingsMultihttp'] = None,
                 ping: Optional['outputs.CheckSettingsPing'] = None,
                 scripted: Optional['outputs.CheckSettingsScripted'] = None,
                 tcp: Optional['outputs.CheckSettingsTcp'] = None,
                 traceroute: Optional['outputs.CheckSettingsTraceroute'] = None):
        """
        :param 'CheckSettingsBrowserArgs' browser: Settings for browser check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6-browser/.
        :param 'CheckSettingsDnsArgs' dns: Settings for DNS check. The target must be a valid hostname (or IP address for `PTR` records).
        :param 'CheckSettingsGrpcArgs' grpc: Settings for gRPC Health check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        :param 'CheckSettingsHttpArgs' http: Settings for HTTP check. The target must be a URL (http or https).
        :param 'CheckSettingsMultihttpArgs' multihttp: Settings for MultiHTTP check. The target must be a URL (http or https)
        :param 'CheckSettingsPingArgs' ping: Settings for ping (ICMP) check. The target must be a valid hostname or IP address.
        :param 'CheckSettingsScriptedArgs' scripted: Settings for scripted check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6/.
        :param 'CheckSettingsTcpArgs' tcp: Settings for TCP check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        :param 'CheckSettingsTracerouteArgs' traceroute: Settings for traceroute check. The target must be a valid hostname or IP address
        """
        if browser is not None:
            pulumi.set(__self__, "browser", browser)
        if dns is not None:
            pulumi.set(__self__, "dns", dns)
        if grpc is not None:
            pulumi.set(__self__, "grpc", grpc)
        if http is not None:
            pulumi.set(__self__, "http", http)
        if multihttp is not None:
            pulumi.set(__self__, "multihttp", multihttp)
        if ping is not None:
            pulumi.set(__self__, "ping", ping)
        if scripted is not None:
            pulumi.set(__self__, "scripted", scripted)
        if tcp is not None:
            pulumi.set(__self__, "tcp", tcp)
        if traceroute is not None:
            pulumi.set(__self__, "traceroute", traceroute)

    @property
    @pulumi.getter
    def browser(self) -> Optional['outputs.CheckSettingsBrowser']:
        """
        Settings for browser check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6-browser/.
        """
        return pulumi.get(self, "browser")

    @property
    @pulumi.getter
    def dns(self) -> Optional['outputs.CheckSettingsDns']:
        """
        Settings for DNS check. The target must be a valid hostname (or IP address for `PTR` records).
        """
        return pulumi.get(self, "dns")

    @property
    @pulumi.getter
    def grpc(self) -> Optional['outputs.CheckSettingsGrpc']:
        """
        Settings for gRPC Health check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        """
        return pulumi.get(self, "grpc")

    @property
    @pulumi.getter
    def http(self) -> Optional['outputs.CheckSettingsHttp']:
        """
        Settings for HTTP check. The target must be a URL (http or https).
        """
        return pulumi.get(self, "http")

    @property
    @pulumi.getter
    def multihttp(self) -> Optional['outputs.CheckSettingsMultihttp']:
        """
        Settings for MultiHTTP check. The target must be a URL (http or https)
        """
        return pulumi.get(self, "multihttp")

    @property
    @pulumi.getter
    def ping(self) -> Optional['outputs.CheckSettingsPing']:
        """
        Settings for ping (ICMP) check. The target must be a valid hostname or IP address.
        """
        return pulumi.get(self, "ping")

    @property
    @pulumi.getter
    def scripted(self) -> Optional['outputs.CheckSettingsScripted']:
        """
        Settings for scripted check. See https://grafana.com/docs/grafana-cloud/testing/synthetic-monitoring/create-checks/checks/k6/.
        """
        return pulumi.get(self, "scripted")

    @property
    @pulumi.getter
    def tcp(self) -> Optional['outputs.CheckSettingsTcp']:
        """
        Settings for TCP check. The target must be of the form `<host>:<port>`, where the host portion must be a valid hostname or IP address.
        """
        return pulumi.get(self, "tcp")

    @property
    @pulumi.getter
    def traceroute(self) -> Optional['outputs.CheckSettingsTraceroute']:
        """
        Settings for traceroute check. The target must be a valid hostname or IP address
        """
        return pulumi.get(self, "traceroute")


@pulumi.output_type
class CheckSettingsBrowser(dict):
    def __init__(__self__, *,
                 script: builtins.str):
        pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def script(self) -> builtins.str:
        return pulumi.get(self, "script")


@pulumi.output_type
class CheckSettingsDns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipVersion":
            suggest = "ip_version"
        elif key == "recordType":
            suggest = "record_type"
        elif key == "sourceIpAddress":
            suggest = "source_ip_address"
        elif key == "validRCodes":
            suggest = "valid_r_codes"
        elif key == "validateAdditionalRrs":
            suggest = "validate_additional_rrs"
        elif key == "validateAnswerRrs":
            suggest = "validate_answer_rrs"
        elif key == "validateAuthorityRrs":
            suggest = "validate_authority_rrs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsDns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsDns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsDns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_version: Optional[builtins.str] = None,
                 port: Optional[builtins.int] = None,
                 protocol: Optional[builtins.str] = None,
                 record_type: Optional[builtins.str] = None,
                 server: Optional[builtins.str] = None,
                 source_ip_address: Optional[builtins.str] = None,
                 valid_r_codes: Optional[Sequence[builtins.str]] = None,
                 validate_additional_rrs: Optional[Sequence['outputs.CheckSettingsDnsValidateAdditionalRr']] = None,
                 validate_answer_rrs: Optional['outputs.CheckSettingsDnsValidateAnswerRrs'] = None,
                 validate_authority_rrs: Optional['outputs.CheckSettingsDnsValidateAuthorityRrs'] = None):
        """
        :param builtins.str ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param builtins.int port: Port to target. Defaults to `53`.
        :param builtins.str protocol: `TCP` or `UDP`. Defaults to `UDP`.
        :param builtins.str record_type: One of `ANY`, `A`, `AAAA`, `CNAME`, `MX`, `NS`, `PTR`, `SOA`, `SRV`, `TXT`. Defaults to `A`.
        :param builtins.str server: DNS server address to target. Defaults to `8.8.8.8`.
        :param builtins.str source_ip_address: Source IP address.
        :param Sequence[builtins.str] valid_r_codes: List of valid response codes. Options include `NOERROR`, `BADALG`, `BADMODE`, `BADKEY`, `BADCOOKIE`, `BADNAME`, `BADSIG`, `BADTIME`, `BADTRUNC`, `BADVERS`, `FORMERR`, `NOTIMP`, `NOTAUTH`, `NOTZONE`, `NXDOMAIN`, `NXRRSET`, `REFUSED`, `SERVFAIL`, `YXDOMAIN`, `YXRRSET`.
        :param Sequence['CheckSettingsDnsValidateAdditionalRrArgs'] validate_additional_rrs: Validate additional matches.
        :param 'CheckSettingsDnsValidateAnswerRrsArgs' validate_answer_rrs: Validate response answer.
        :param 'CheckSettingsDnsValidateAuthorityRrsArgs' validate_authority_rrs: Validate response authority.
        """
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if record_type is not None:
            pulumi.set(__self__, "record_type", record_type)
        if server is not None:
            pulumi.set(__self__, "server", server)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if valid_r_codes is not None:
            pulumi.set(__self__, "valid_r_codes", valid_r_codes)
        if validate_additional_rrs is not None:
            pulumi.set(__self__, "validate_additional_rrs", validate_additional_rrs)
        if validate_answer_rrs is not None:
            pulumi.set(__self__, "validate_answer_rrs", validate_answer_rrs)
        if validate_authority_rrs is not None:
            pulumi.set(__self__, "validate_authority_rrs", validate_authority_rrs)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[builtins.str]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def port(self) -> Optional[builtins.int]:
        """
        Port to target. Defaults to `53`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> Optional[builtins.str]:
        """
        `TCP` or `UDP`. Defaults to `UDP`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="recordType")
    def record_type(self) -> Optional[builtins.str]:
        """
        One of `ANY`, `A`, `AAAA`, `CNAME`, `MX`, `NS`, `PTR`, `SOA`, `SRV`, `TXT`. Defaults to `A`.
        """
        return pulumi.get(self, "record_type")

    @property
    @pulumi.getter
    def server(self) -> Optional[builtins.str]:
        """
        DNS server address to target. Defaults to `8.8.8.8`.
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[builtins.str]:
        """
        Source IP address.
        """
        return pulumi.get(self, "source_ip_address")

    @property
    @pulumi.getter(name="validRCodes")
    def valid_r_codes(self) -> Optional[Sequence[builtins.str]]:
        """
        List of valid response codes. Options include `NOERROR`, `BADALG`, `BADMODE`, `BADKEY`, `BADCOOKIE`, `BADNAME`, `BADSIG`, `BADTIME`, `BADTRUNC`, `BADVERS`, `FORMERR`, `NOTIMP`, `NOTAUTH`, `NOTZONE`, `NXDOMAIN`, `NXRRSET`, `REFUSED`, `SERVFAIL`, `YXDOMAIN`, `YXRRSET`.
        """
        return pulumi.get(self, "valid_r_codes")

    @property
    @pulumi.getter(name="validateAdditionalRrs")
    def validate_additional_rrs(self) -> Optional[Sequence['outputs.CheckSettingsDnsValidateAdditionalRr']]:
        """
        Validate additional matches.
        """
        return pulumi.get(self, "validate_additional_rrs")

    @property
    @pulumi.getter(name="validateAnswerRrs")
    def validate_answer_rrs(self) -> Optional['outputs.CheckSettingsDnsValidateAnswerRrs']:
        """
        Validate response answer.
        """
        return pulumi.get(self, "validate_answer_rrs")

    @property
    @pulumi.getter(name="validateAuthorityRrs")
    def validate_authority_rrs(self) -> Optional['outputs.CheckSettingsDnsValidateAuthorityRrs']:
        """
        Validate response authority.
        """
        return pulumi.get(self, "validate_authority_rrs")


@pulumi.output_type
class CheckSettingsDnsValidateAdditionalRr(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failIfMatchesRegexps":
            suggest = "fail_if_matches_regexps"
        elif key == "failIfNotMatchesRegexps":
            suggest = "fail_if_not_matches_regexps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsDnsValidateAdditionalRr. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsDnsValidateAdditionalRr.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsDnsValidateAdditionalRr.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[Sequence[builtins.str]] = None,
                 fail_if_not_matches_regexps: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] fail_if_matches_regexps: Fail if value matches regex.
        :param Sequence[builtins.str] fail_if_not_matches_regexps: Fail if value does not match regex.
        """
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        Fail if value matches regex.
        """
        return pulumi.get(self, "fail_if_matches_regexps")

    @property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        Fail if value does not match regex.
        """
        return pulumi.get(self, "fail_if_not_matches_regexps")


@pulumi.output_type
class CheckSettingsDnsValidateAnswerRrs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failIfMatchesRegexps":
            suggest = "fail_if_matches_regexps"
        elif key == "failIfNotMatchesRegexps":
            suggest = "fail_if_not_matches_regexps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsDnsValidateAnswerRrs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsDnsValidateAnswerRrs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsDnsValidateAnswerRrs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[Sequence[builtins.str]] = None,
                 fail_if_not_matches_regexps: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] fail_if_matches_regexps: Fail if value matches regex.
        :param Sequence[builtins.str] fail_if_not_matches_regexps: Fail if value does not match regex.
        """
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        Fail if value matches regex.
        """
        return pulumi.get(self, "fail_if_matches_regexps")

    @property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        Fail if value does not match regex.
        """
        return pulumi.get(self, "fail_if_not_matches_regexps")


@pulumi.output_type
class CheckSettingsDnsValidateAuthorityRrs(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failIfMatchesRegexps":
            suggest = "fail_if_matches_regexps"
        elif key == "failIfNotMatchesRegexps":
            suggest = "fail_if_not_matches_regexps"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsDnsValidateAuthorityRrs. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsDnsValidateAuthorityRrs.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsDnsValidateAuthorityRrs.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fail_if_matches_regexps: Optional[Sequence[builtins.str]] = None,
                 fail_if_not_matches_regexps: Optional[Sequence[builtins.str]] = None):
        """
        :param Sequence[builtins.str] fail_if_matches_regexps: Fail if value matches regex.
        :param Sequence[builtins.str] fail_if_not_matches_regexps: Fail if value does not match regex.
        """
        if fail_if_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_matches_regexps", fail_if_matches_regexps)
        if fail_if_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_not_matches_regexps", fail_if_not_matches_regexps)

    @property
    @pulumi.getter(name="failIfMatchesRegexps")
    def fail_if_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        Fail if value matches regex.
        """
        return pulumi.get(self, "fail_if_matches_regexps")

    @property
    @pulumi.getter(name="failIfNotMatchesRegexps")
    def fail_if_not_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        Fail if value does not match regex.
        """
        return pulumi.get(self, "fail_if_not_matches_regexps")


@pulumi.output_type
class CheckSettingsGrpc(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipVersion":
            suggest = "ip_version"
        elif key == "tlsConfig":
            suggest = "tls_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsGrpc. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsGrpc.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsGrpc.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_version: Optional[builtins.str] = None,
                 service: Optional[builtins.str] = None,
                 tls: Optional[builtins.bool] = None,
                 tls_config: Optional['outputs.CheckSettingsGrpcTlsConfig'] = None):
        """
        :param builtins.str ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param builtins.str service: gRPC service.
        :param builtins.bool tls: Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        :param 'CheckSettingsGrpcTlsConfigArgs' tls_config: TLS config.
        """
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if service is not None:
            pulumi.set(__self__, "service", service)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[builtins.str]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def service(self) -> Optional[builtins.str]:
        """
        gRPC service.
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter
    def tls(self) -> Optional[builtins.bool]:
        """
        Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional['outputs.CheckSettingsGrpcTlsConfig']:
        """
        TLS config.
        """
        return pulumi.get(self, "tls_config")


@pulumi.output_type
class CheckSettingsGrpcTlsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCert":
            suggest = "ca_cert"
        elif key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "insecureSkipVerify":
            suggest = "insecure_skip_verify"
        elif key == "serverName":
            suggest = "server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsGrpcTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsGrpcTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsGrpcTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_cert: Optional[builtins.str] = None,
                 client_cert: Optional[builtins.str] = None,
                 client_key: Optional[builtins.str] = None,
                 insecure_skip_verify: Optional[builtins.bool] = None,
                 server_name: Optional[builtins.str] = None):
        """
        :param builtins.str ca_cert: CA certificate in PEM format.
        :param builtins.str client_cert: Client certificate in PEM format.
        :param builtins.str client_key: Client key in PEM format.
        :param builtins.bool insecure_skip_verify: Disable target certificate validation. Defaults to `false`.
        :param builtins.str server_name: Used to verify the hostname for the targets.
        """
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[builtins.str]:
        """
        CA certificate in PEM format.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[builtins.str]:
        """
        Client certificate in PEM format.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[builtins.str]:
        """
        Client key in PEM format.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[builtins.bool]:
        """
        Disable target certificate validation. Defaults to `false`.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[builtins.str]:
        """
        Used to verify the hostname for the targets.
        """
        return pulumi.get(self, "server_name")


@pulumi.output_type
class CheckSettingsHttp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "basicAuth":
            suggest = "basic_auth"
        elif key == "bearerToken":
            suggest = "bearer_token"
        elif key == "cacheBustingQueryParamName":
            suggest = "cache_busting_query_param_name"
        elif key == "failIfBodyMatchesRegexps":
            suggest = "fail_if_body_matches_regexps"
        elif key == "failIfBodyNotMatchesRegexps":
            suggest = "fail_if_body_not_matches_regexps"
        elif key == "failIfHeaderMatchesRegexps":
            suggest = "fail_if_header_matches_regexps"
        elif key == "failIfHeaderNotMatchesRegexps":
            suggest = "fail_if_header_not_matches_regexps"
        elif key == "failIfNotSsl":
            suggest = "fail_if_not_ssl"
        elif key == "failIfSsl":
            suggest = "fail_if_ssl"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "noFollowRedirects":
            suggest = "no_follow_redirects"
        elif key == "proxyConnectHeaders":
            suggest = "proxy_connect_headers"
        elif key == "proxyUrl":
            suggest = "proxy_url"
        elif key == "tlsConfig":
            suggest = "tls_config"
        elif key == "validHttpVersions":
            suggest = "valid_http_versions"
        elif key == "validStatusCodes":
            suggest = "valid_status_codes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsHttp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsHttp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsHttp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 basic_auth: Optional['outputs.CheckSettingsHttpBasicAuth'] = None,
                 bearer_token: Optional[builtins.str] = None,
                 body: Optional[builtins.str] = None,
                 cache_busting_query_param_name: Optional[builtins.str] = None,
                 compression: Optional[builtins.str] = None,
                 fail_if_body_matches_regexps: Optional[Sequence[builtins.str]] = None,
                 fail_if_body_not_matches_regexps: Optional[Sequence[builtins.str]] = None,
                 fail_if_header_matches_regexps: Optional[Sequence['outputs.CheckSettingsHttpFailIfHeaderMatchesRegexp']] = None,
                 fail_if_header_not_matches_regexps: Optional[Sequence['outputs.CheckSettingsHttpFailIfHeaderNotMatchesRegexp']] = None,
                 fail_if_not_ssl: Optional[builtins.bool] = None,
                 fail_if_ssl: Optional[builtins.bool] = None,
                 headers: Optional[Sequence[builtins.str]] = None,
                 ip_version: Optional[builtins.str] = None,
                 method: Optional[builtins.str] = None,
                 no_follow_redirects: Optional[builtins.bool] = None,
                 proxy_connect_headers: Optional[Sequence[builtins.str]] = None,
                 proxy_url: Optional[builtins.str] = None,
                 tls_config: Optional['outputs.CheckSettingsHttpTlsConfig'] = None,
                 valid_http_versions: Optional[Sequence[builtins.str]] = None,
                 valid_status_codes: Optional[Sequence[builtins.int]] = None):
        """
        :param 'CheckSettingsHttpBasicAuthArgs' basic_auth: Basic auth settings.
        :param builtins.str bearer_token: Token for use with bearer authorization header.
        :param builtins.str body: The body of the HTTP request used in probe.
        :param builtins.str cache_busting_query_param_name: The name of the query parameter used to prevent the server from using a cached response. Each probe will assign a random value to this parameter each time a request is made.
        :param builtins.str compression: Check fails if the response body is not compressed using this compression algorithm. One of `none`, `identity`, `br`, `gzip`, `deflate`.
        :param Sequence[builtins.str] fail_if_body_matches_regexps: List of regexes. If any match the response body, the check will fail.
        :param Sequence[builtins.str] fail_if_body_not_matches_regexps: List of regexes. If any do not match the response body, the check will fail.
        :param Sequence['CheckSettingsHttpFailIfHeaderMatchesRegexpArgs'] fail_if_header_matches_regexps: Check fails if headers match.
        :param Sequence['CheckSettingsHttpFailIfHeaderNotMatchesRegexpArgs'] fail_if_header_not_matches_regexps: Check fails if headers do not match.
        :param builtins.bool fail_if_not_ssl: Fail if SSL is not present. Defaults to `false`.
        :param builtins.bool fail_if_ssl: Fail if SSL is present. Defaults to `false`.
        :param Sequence[builtins.str] headers: The HTTP headers set for the probe.
        :param builtins.str ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param builtins.str method: Request method. One of `GET`, `CONNECT`, `DELETE`, `HEAD`, `OPTIONS`, `POST`, `PUT`, `TRACE` Defaults to `GET`.
        :param builtins.bool no_follow_redirects: Do not follow redirects. Defaults to `false`.
        :param Sequence[builtins.str] proxy_connect_headers: The HTTP headers sent to the proxy URL
        :param builtins.str proxy_url: Proxy URL.
        :param 'CheckSettingsHttpTlsConfigArgs' tls_config: TLS config.
        :param Sequence[builtins.str] valid_http_versions: List of valid HTTP versions. Options include `HTTP/1.0`, `HTTP/1.1`, `HTTP/2.0`
        :param Sequence[builtins.int] valid_status_codes: Accepted status codes. If unset, defaults to 2xx.
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if bearer_token is not None:
            pulumi.set(__self__, "bearer_token", bearer_token)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if cache_busting_query_param_name is not None:
            pulumi.set(__self__, "cache_busting_query_param_name", cache_busting_query_param_name)
        if compression is not None:
            pulumi.set(__self__, "compression", compression)
        if fail_if_body_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_body_matches_regexps", fail_if_body_matches_regexps)
        if fail_if_body_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_body_not_matches_regexps", fail_if_body_not_matches_regexps)
        if fail_if_header_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_header_matches_regexps", fail_if_header_matches_regexps)
        if fail_if_header_not_matches_regexps is not None:
            pulumi.set(__self__, "fail_if_header_not_matches_regexps", fail_if_header_not_matches_regexps)
        if fail_if_not_ssl is not None:
            pulumi.set(__self__, "fail_if_not_ssl", fail_if_not_ssl)
        if fail_if_ssl is not None:
            pulumi.set(__self__, "fail_if_ssl", fail_if_ssl)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if method is not None:
            pulumi.set(__self__, "method", method)
        if no_follow_redirects is not None:
            pulumi.set(__self__, "no_follow_redirects", no_follow_redirects)
        if proxy_connect_headers is not None:
            pulumi.set(__self__, "proxy_connect_headers", proxy_connect_headers)
        if proxy_url is not None:
            pulumi.set(__self__, "proxy_url", proxy_url)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)
        if valid_http_versions is not None:
            pulumi.set(__self__, "valid_http_versions", valid_http_versions)
        if valid_status_codes is not None:
            pulumi.set(__self__, "valid_status_codes", valid_status_codes)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional['outputs.CheckSettingsHttpBasicAuth']:
        """
        Basic auth settings.
        """
        return pulumi.get(self, "basic_auth")

    @property
    @pulumi.getter(name="bearerToken")
    def bearer_token(self) -> Optional[builtins.str]:
        """
        Token for use with bearer authorization header.
        """
        return pulumi.get(self, "bearer_token")

    @property
    @pulumi.getter
    def body(self) -> Optional[builtins.str]:
        """
        The body of the HTTP request used in probe.
        """
        return pulumi.get(self, "body")

    @property
    @pulumi.getter(name="cacheBustingQueryParamName")
    def cache_busting_query_param_name(self) -> Optional[builtins.str]:
        """
        The name of the query parameter used to prevent the server from using a cached response. Each probe will assign a random value to this parameter each time a request is made.
        """
        return pulumi.get(self, "cache_busting_query_param_name")

    @property
    @pulumi.getter
    def compression(self) -> Optional[builtins.str]:
        """
        Check fails if the response body is not compressed using this compression algorithm. One of `none`, `identity`, `br`, `gzip`, `deflate`.
        """
        return pulumi.get(self, "compression")

    @property
    @pulumi.getter(name="failIfBodyMatchesRegexps")
    def fail_if_body_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        List of regexes. If any match the response body, the check will fail.
        """
        return pulumi.get(self, "fail_if_body_matches_regexps")

    @property
    @pulumi.getter(name="failIfBodyNotMatchesRegexps")
    def fail_if_body_not_matches_regexps(self) -> Optional[Sequence[builtins.str]]:
        """
        List of regexes. If any do not match the response body, the check will fail.
        """
        return pulumi.get(self, "fail_if_body_not_matches_regexps")

    @property
    @pulumi.getter(name="failIfHeaderMatchesRegexps")
    def fail_if_header_matches_regexps(self) -> Optional[Sequence['outputs.CheckSettingsHttpFailIfHeaderMatchesRegexp']]:
        """
        Check fails if headers match.
        """
        return pulumi.get(self, "fail_if_header_matches_regexps")

    @property
    @pulumi.getter(name="failIfHeaderNotMatchesRegexps")
    def fail_if_header_not_matches_regexps(self) -> Optional[Sequence['outputs.CheckSettingsHttpFailIfHeaderNotMatchesRegexp']]:
        """
        Check fails if headers do not match.
        """
        return pulumi.get(self, "fail_if_header_not_matches_regexps")

    @property
    @pulumi.getter(name="failIfNotSsl")
    def fail_if_not_ssl(self) -> Optional[builtins.bool]:
        """
        Fail if SSL is not present. Defaults to `false`.
        """
        return pulumi.get(self, "fail_if_not_ssl")

    @property
    @pulumi.getter(name="failIfSsl")
    def fail_if_ssl(self) -> Optional[builtins.bool]:
        """
        Fail if SSL is present. Defaults to `false`.
        """
        return pulumi.get(self, "fail_if_ssl")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence[builtins.str]]:
        """
        The HTTP headers set for the probe.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[builtins.str]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def method(self) -> Optional[builtins.str]:
        """
        Request method. One of `GET`, `CONNECT`, `DELETE`, `HEAD`, `OPTIONS`, `POST`, `PUT`, `TRACE` Defaults to `GET`.
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter(name="noFollowRedirects")
    def no_follow_redirects(self) -> Optional[builtins.bool]:
        """
        Do not follow redirects. Defaults to `false`.
        """
        return pulumi.get(self, "no_follow_redirects")

    @property
    @pulumi.getter(name="proxyConnectHeaders")
    def proxy_connect_headers(self) -> Optional[Sequence[builtins.str]]:
        """
        The HTTP headers sent to the proxy URL
        """
        return pulumi.get(self, "proxy_connect_headers")

    @property
    @pulumi.getter(name="proxyUrl")
    def proxy_url(self) -> Optional[builtins.str]:
        """
        Proxy URL.
        """
        return pulumi.get(self, "proxy_url")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional['outputs.CheckSettingsHttpTlsConfig']:
        """
        TLS config.
        """
        return pulumi.get(self, "tls_config")

    @property
    @pulumi.getter(name="validHttpVersions")
    def valid_http_versions(self) -> Optional[Sequence[builtins.str]]:
        """
        List of valid HTTP versions. Options include `HTTP/1.0`, `HTTP/1.1`, `HTTP/2.0`
        """
        return pulumi.get(self, "valid_http_versions")

    @property
    @pulumi.getter(name="validStatusCodes")
    def valid_status_codes(self) -> Optional[Sequence[builtins.int]]:
        """
        Accepted status codes. If unset, defaults to 2xx.
        """
        return pulumi.get(self, "valid_status_codes")


@pulumi.output_type
class CheckSettingsHttpBasicAuth(dict):
    def __init__(__self__, *,
                 password: builtins.str,
                 username: builtins.str):
        """
        :param builtins.str password: Basic auth password.
        :param builtins.str username: Basic auth username.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> builtins.str:
        """
        Basic auth password.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> builtins.str:
        """
        Basic auth username.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class CheckSettingsHttpFailIfHeaderMatchesRegexp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMissing":
            suggest = "allow_missing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsHttpFailIfHeaderMatchesRegexp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsHttpFailIfHeaderMatchesRegexp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsHttpFailIfHeaderMatchesRegexp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header: builtins.str,
                 regexp: builtins.str,
                 allow_missing: Optional[builtins.bool] = None):
        """
        :param builtins.str header: Header name.
        :param builtins.str regexp: Regex that header value should match.
        :param builtins.bool allow_missing: Allow header to be missing from responses. Defaults to `false`.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "regexp", regexp)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        Header name.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def regexp(self) -> builtins.str:
        """
        Regex that header value should match.
        """
        return pulumi.get(self, "regexp")

    @property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[builtins.bool]:
        """
        Allow header to be missing from responses. Defaults to `false`.
        """
        return pulumi.get(self, "allow_missing")


@pulumi.output_type
class CheckSettingsHttpFailIfHeaderNotMatchesRegexp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowMissing":
            suggest = "allow_missing"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsHttpFailIfHeaderNotMatchesRegexp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsHttpFailIfHeaderNotMatchesRegexp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsHttpFailIfHeaderNotMatchesRegexp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 header: builtins.str,
                 regexp: builtins.str,
                 allow_missing: Optional[builtins.bool] = None):
        """
        :param builtins.str header: Header name.
        :param builtins.str regexp: Regex that header value should match.
        :param builtins.bool allow_missing: Allow header to be missing from responses. Defaults to `false`.
        """
        pulumi.set(__self__, "header", header)
        pulumi.set(__self__, "regexp", regexp)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)

    @property
    @pulumi.getter
    def header(self) -> builtins.str:
        """
        Header name.
        """
        return pulumi.get(self, "header")

    @property
    @pulumi.getter
    def regexp(self) -> builtins.str:
        """
        Regex that header value should match.
        """
        return pulumi.get(self, "regexp")

    @property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[builtins.bool]:
        """
        Allow header to be missing from responses. Defaults to `false`.
        """
        return pulumi.get(self, "allow_missing")


@pulumi.output_type
class CheckSettingsHttpTlsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCert":
            suggest = "ca_cert"
        elif key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "insecureSkipVerify":
            suggest = "insecure_skip_verify"
        elif key == "serverName":
            suggest = "server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsHttpTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsHttpTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsHttpTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_cert: Optional[builtins.str] = None,
                 client_cert: Optional[builtins.str] = None,
                 client_key: Optional[builtins.str] = None,
                 insecure_skip_verify: Optional[builtins.bool] = None,
                 server_name: Optional[builtins.str] = None):
        """
        :param builtins.str ca_cert: CA certificate in PEM format.
        :param builtins.str client_cert: Client certificate in PEM format.
        :param builtins.str client_key: Client key in PEM format.
        :param builtins.bool insecure_skip_verify: Disable target certificate validation. Defaults to `false`.
        :param builtins.str server_name: Used to verify the hostname for the targets.
        """
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[builtins.str]:
        """
        CA certificate in PEM format.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[builtins.str]:
        """
        Client certificate in PEM format.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[builtins.str]:
        """
        Client key in PEM format.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[builtins.bool]:
        """
        Disable target certificate validation. Defaults to `false`.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[builtins.str]:
        """
        Used to verify the hostname for the targets.
        """
        return pulumi.get(self, "server_name")


@pulumi.output_type
class CheckSettingsMultihttp(dict):
    def __init__(__self__, *,
                 entries: Optional[Sequence['outputs.CheckSettingsMultihttpEntry']] = None):
        if entries is not None:
            pulumi.set(__self__, "entries", entries)

    @property
    @pulumi.getter
    def entries(self) -> Optional[Sequence['outputs.CheckSettingsMultihttpEntry']]:
        return pulumi.get(self, "entries")


@pulumi.output_type
class CheckSettingsMultihttpEntry(dict):
    def __init__(__self__, *,
                 assertions: Optional[Sequence['outputs.CheckSettingsMultihttpEntryAssertion']] = None,
                 request: Optional['outputs.CheckSettingsMultihttpEntryRequest'] = None,
                 variables: Optional[Sequence['outputs.CheckSettingsMultihttpEntryVariable']] = None):
        """
        :param Sequence['CheckSettingsMultihttpEntryAssertionArgs'] assertions: Assertions to make on the request response
        :param 'CheckSettingsMultihttpEntryRequestArgs' request: An individual MultiHTTP request
        :param Sequence['CheckSettingsMultihttpEntryVariableArgs'] variables: Variables to extract from the request response
        """
        if assertions is not None:
            pulumi.set(__self__, "assertions", assertions)
        if request is not None:
            pulumi.set(__self__, "request", request)
        if variables is not None:
            pulumi.set(__self__, "variables", variables)

    @property
    @pulumi.getter
    def assertions(self) -> Optional[Sequence['outputs.CheckSettingsMultihttpEntryAssertion']]:
        """
        Assertions to make on the request response
        """
        return pulumi.get(self, "assertions")

    @property
    @pulumi.getter
    def request(self) -> Optional['outputs.CheckSettingsMultihttpEntryRequest']:
        """
        An individual MultiHTTP request
        """
        return pulumi.get(self, "request")

    @property
    @pulumi.getter
    def variables(self) -> Optional[Sequence['outputs.CheckSettingsMultihttpEntryVariable']]:
        """
        Variables to extract from the request response
        """
        return pulumi.get(self, "variables")


@pulumi.output_type
class CheckSettingsMultihttpEntryAssertion(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 condition: Optional[builtins.str] = None,
                 expression: Optional[builtins.str] = None,
                 subject: Optional[builtins.str] = None,
                 value: Optional[builtins.str] = None):
        """
        :param builtins.str type: The type of assertion to make: TEXT, JSON*PATH*VALUE, JSON*PATH*ASSERTION, REGEX_ASSERTION
        :param builtins.str condition: The condition of the assertion: NOT*CONTAINS, EQUALS, STARTS*WITH, ENDS*WITH, TYPE*OF, CONTAINS
        :param builtins.str expression: The expression of the assertion. Should start with $.
        :param builtins.str subject: The subject of the assertion: RESPONSE*HEADERS, HTTP*STATUS*CODE, RESPONSE*BODY
        :param builtins.str value: The value of the assertion
        """
        pulumi.set(__self__, "type", type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The type of assertion to make: TEXT, JSON*PATH*VALUE, JSON*PATH*ASSERTION, REGEX_ASSERTION
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def condition(self) -> Optional[builtins.str]:
        """
        The condition of the assertion: NOT*CONTAINS, EQUALS, STARTS*WITH, ENDS*WITH, TYPE*OF, CONTAINS
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        The expression of the assertion. Should start with $.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def subject(self) -> Optional[builtins.str]:
        """
        The subject of the assertion: RESPONSE*HEADERS, HTTP*STATUS*CODE, RESPONSE*BODY
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def value(self) -> Optional[builtins.str]:
        """
        The value of the assertion
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CheckSettingsMultihttpEntryRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryFields":
            suggest = "query_fields"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsMultihttpEntryRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsMultihttpEntryRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsMultihttpEntryRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 method: builtins.str,
                 url: builtins.str,
                 bodies: Optional[Sequence['outputs.CheckSettingsMultihttpEntryRequestBody']] = None,
                 headers: Optional[Sequence['outputs.CheckSettingsMultihttpEntryRequestHeader']] = None,
                 query_fields: Optional[Sequence['outputs.CheckSettingsMultihttpEntryRequestQueryField']] = None):
        """
        :param builtins.str method: The HTTP method to use
        :param builtins.str url: The URL for the request
        :param Sequence['CheckSettingsMultihttpEntryRequestBodyArgs'] bodies: The body of the HTTP request used in probe.
        :param Sequence['CheckSettingsMultihttpEntryRequestHeaderArgs'] headers: The headers to send with the request
        :param Sequence['CheckSettingsMultihttpEntryRequestQueryFieldArgs'] query_fields: Query fields to send with the request
        """
        pulumi.set(__self__, "method", method)
        pulumi.set(__self__, "url", url)
        if bodies is not None:
            pulumi.set(__self__, "bodies", bodies)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if query_fields is not None:
            pulumi.set(__self__, "query_fields", query_fields)

    @property
    @pulumi.getter
    def method(self) -> builtins.str:
        """
        The HTTP method to use
        """
        return pulumi.get(self, "method")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        The URL for the request
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def bodies(self) -> Optional[Sequence['outputs.CheckSettingsMultihttpEntryRequestBody']]:
        """
        The body of the HTTP request used in probe.
        """
        return pulumi.get(self, "bodies")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.CheckSettingsMultihttpEntryRequestHeader']]:
        """
        The headers to send with the request
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="queryFields")
    def query_fields(self) -> Optional[Sequence['outputs.CheckSettingsMultihttpEntryRequestQueryField']]:
        """
        Query fields to send with the request
        """
        return pulumi.get(self, "query_fields")


@pulumi.output_type
class CheckSettingsMultihttpEntryRequestBody(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contentEncoding":
            suggest = "content_encoding"
        elif key == "contentType":
            suggest = "content_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsMultihttpEntryRequestBody. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsMultihttpEntryRequestBody.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsMultihttpEntryRequestBody.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content_encoding: Optional[builtins.str] = None,
                 content_type: Optional[builtins.str] = None,
                 payload: Optional[builtins.str] = None):
        """
        :param builtins.str content_encoding: The content encoding of the body
        :param builtins.str content_type: The content type of the body
        :param builtins.str payload: The body payload
        """
        if content_encoding is not None:
            pulumi.set(__self__, "content_encoding", content_encoding)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if payload is not None:
            pulumi.set(__self__, "payload", payload)

    @property
    @pulumi.getter(name="contentEncoding")
    def content_encoding(self) -> Optional[builtins.str]:
        """
        The content encoding of the body
        """
        return pulumi.get(self, "content_encoding")

    @property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[builtins.str]:
        """
        The content type of the body
        """
        return pulumi.get(self, "content_type")

    @property
    @pulumi.getter
    def payload(self) -> Optional[builtins.str]:
        """
        The body payload
        """
        return pulumi.get(self, "payload")


@pulumi.output_type
class CheckSettingsMultihttpEntryRequestHeader(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the header to send
        :param builtins.str value: Value of the header to send
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the header to send
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the header to send
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CheckSettingsMultihttpEntryRequestQueryField(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 value: builtins.str):
        """
        :param builtins.str name: Name of the query field to send
        :param builtins.str value: Value of the query field to send
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Name of the query field to send
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Value of the query field to send
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class CheckSettingsMultihttpEntryVariable(dict):
    def __init__(__self__, *,
                 type: builtins.str,
                 attribute: Optional[builtins.str] = None,
                 expression: Optional[builtins.str] = None,
                 name: Optional[builtins.str] = None):
        """
        :param builtins.str type: The method of finding the variable value to extract. JSON*PATH, REGEX, CSS*SELECTOR
        :param builtins.str attribute: The attribute to use when finding the variable value. Only used when type is CSS_SELECTOR
        :param builtins.str expression: The expression to when finding the variable. Should start with $. Only use when type is JSON_PATH or REGEX
        :param builtins.str name: The name of the variable to extract
        """
        pulumi.set(__self__, "type", type)
        if attribute is not None:
            pulumi.set(__self__, "attribute", attribute)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        The method of finding the variable value to extract. JSON*PATH, REGEX, CSS*SELECTOR
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def attribute(self) -> Optional[builtins.str]:
        """
        The attribute to use when finding the variable value. Only used when type is CSS_SELECTOR
        """
        return pulumi.get(self, "attribute")

    @property
    @pulumi.getter
    def expression(self) -> Optional[builtins.str]:
        """
        The expression to when finding the variable. Should start with $. Only use when type is JSON_PATH or REGEX
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def name(self) -> Optional[builtins.str]:
        """
        The name of the variable to extract
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CheckSettingsPing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dontFragment":
            suggest = "dont_fragment"
        elif key == "ipVersion":
            suggest = "ip_version"
        elif key == "payloadSize":
            suggest = "payload_size"
        elif key == "sourceIpAddress":
            suggest = "source_ip_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsPing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsPing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsPing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dont_fragment: Optional[builtins.bool] = None,
                 ip_version: Optional[builtins.str] = None,
                 payload_size: Optional[builtins.int] = None,
                 source_ip_address: Optional[builtins.str] = None):
        """
        :param builtins.bool dont_fragment: Set the DF-bit in the IP-header. Only works with ipV4. Defaults to `false`.
        :param builtins.str ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param builtins.int payload_size: Payload size. Defaults to `0`.
        :param builtins.str source_ip_address: Source IP address.
        """
        if dont_fragment is not None:
            pulumi.set(__self__, "dont_fragment", dont_fragment)
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if payload_size is not None:
            pulumi.set(__self__, "payload_size", payload_size)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)

    @property
    @pulumi.getter(name="dontFragment")
    def dont_fragment(self) -> Optional[builtins.bool]:
        """
        Set the DF-bit in the IP-header. Only works with ipV4. Defaults to `false`.
        """
        return pulumi.get(self, "dont_fragment")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[builtins.str]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="payloadSize")
    def payload_size(self) -> Optional[builtins.int]:
        """
        Payload size. Defaults to `0`.
        """
        return pulumi.get(self, "payload_size")

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[builtins.str]:
        """
        Source IP address.
        """
        return pulumi.get(self, "source_ip_address")


@pulumi.output_type
class CheckSettingsScripted(dict):
    def __init__(__self__, *,
                 script: builtins.str):
        pulumi.set(__self__, "script", script)

    @property
    @pulumi.getter
    def script(self) -> builtins.str:
        return pulumi.get(self, "script")


@pulumi.output_type
class CheckSettingsTcp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipVersion":
            suggest = "ip_version"
        elif key == "queryResponses":
            suggest = "query_responses"
        elif key == "sourceIpAddress":
            suggest = "source_ip_address"
        elif key == "tlsConfig":
            suggest = "tls_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsTcp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsTcp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsTcp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_version: Optional[builtins.str] = None,
                 query_responses: Optional[Sequence['outputs.CheckSettingsTcpQueryResponse']] = None,
                 source_ip_address: Optional[builtins.str] = None,
                 tls: Optional[builtins.bool] = None,
                 tls_config: Optional['outputs.CheckSettingsTcpTlsConfig'] = None):
        """
        :param builtins.str ip_version: Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        :param Sequence['CheckSettingsTcpQueryResponseArgs'] query_responses: The query sent in the TCP probe and the expected associated response.
        :param builtins.str source_ip_address: Source IP address.
        :param builtins.bool tls: Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        :param 'CheckSettingsTcpTlsConfigArgs' tls_config: TLS config.
        """
        if ip_version is not None:
            pulumi.set(__self__, "ip_version", ip_version)
        if query_responses is not None:
            pulumi.set(__self__, "query_responses", query_responses)
        if source_ip_address is not None:
            pulumi.set(__self__, "source_ip_address", source_ip_address)
        if tls is not None:
            pulumi.set(__self__, "tls", tls)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[builtins.str]:
        """
        Options are `V4`, `V6`, `Any`. Specifies whether the corresponding check will be performed using IPv4 or IPv6. The `Any` value indicates that IPv6 should be used, falling back to IPv4 if that's not available. Defaults to `V4`.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="queryResponses")
    def query_responses(self) -> Optional[Sequence['outputs.CheckSettingsTcpQueryResponse']]:
        """
        The query sent in the TCP probe and the expected associated response.
        """
        return pulumi.get(self, "query_responses")

    @property
    @pulumi.getter(name="sourceIpAddress")
    def source_ip_address(self) -> Optional[builtins.str]:
        """
        Source IP address.
        """
        return pulumi.get(self, "source_ip_address")

    @property
    @pulumi.getter
    def tls(self) -> Optional[builtins.bool]:
        """
        Whether or not TLS is used when the connection is initiated. Defaults to `false`.
        """
        return pulumi.get(self, "tls")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional['outputs.CheckSettingsTcpTlsConfig']:
        """
        TLS config.
        """
        return pulumi.get(self, "tls_config")


@pulumi.output_type
class CheckSettingsTcpQueryResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startTls":
            suggest = "start_tls"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsTcpQueryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsTcpQueryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsTcpQueryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expect: builtins.str,
                 send: builtins.str,
                 start_tls: Optional[builtins.bool] = None):
        """
        :param builtins.str expect: Response to expect.
        :param builtins.str send: Data to send.
        :param builtins.bool start_tls: Upgrade TCP connection to TLS. Defaults to `false`.
        """
        pulumi.set(__self__, "expect", expect)
        pulumi.set(__self__, "send", send)
        if start_tls is not None:
            pulumi.set(__self__, "start_tls", start_tls)

    @property
    @pulumi.getter
    def expect(self) -> builtins.str:
        """
        Response to expect.
        """
        return pulumi.get(self, "expect")

    @property
    @pulumi.getter
    def send(self) -> builtins.str:
        """
        Data to send.
        """
        return pulumi.get(self, "send")

    @property
    @pulumi.getter(name="startTls")
    def start_tls(self) -> Optional[builtins.bool]:
        """
        Upgrade TCP connection to TLS. Defaults to `false`.
        """
        return pulumi.get(self, "start_tls")


@pulumi.output_type
class CheckSettingsTcpTlsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCert":
            suggest = "ca_cert"
        elif key == "clientCert":
            suggest = "client_cert"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "insecureSkipVerify":
            suggest = "insecure_skip_verify"
        elif key == "serverName":
            suggest = "server_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsTcpTlsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsTcpTlsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsTcpTlsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_cert: Optional[builtins.str] = None,
                 client_cert: Optional[builtins.str] = None,
                 client_key: Optional[builtins.str] = None,
                 insecure_skip_verify: Optional[builtins.bool] = None,
                 server_name: Optional[builtins.str] = None):
        """
        :param builtins.str ca_cert: CA certificate in PEM format.
        :param builtins.str client_cert: Client certificate in PEM format.
        :param builtins.str client_key: Client key in PEM format.
        :param builtins.bool insecure_skip_verify: Disable target certificate validation. Defaults to `false`.
        :param builtins.str server_name: Used to verify the hostname for the targets.
        """
        if ca_cert is not None:
            pulumi.set(__self__, "ca_cert", ca_cert)
        if client_cert is not None:
            pulumi.set(__self__, "client_cert", client_cert)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if insecure_skip_verify is not None:
            pulumi.set(__self__, "insecure_skip_verify", insecure_skip_verify)
        if server_name is not None:
            pulumi.set(__self__, "server_name", server_name)

    @property
    @pulumi.getter(name="caCert")
    def ca_cert(self) -> Optional[builtins.str]:
        """
        CA certificate in PEM format.
        """
        return pulumi.get(self, "ca_cert")

    @property
    @pulumi.getter(name="clientCert")
    def client_cert(self) -> Optional[builtins.str]:
        """
        Client certificate in PEM format.
        """
        return pulumi.get(self, "client_cert")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[builtins.str]:
        """
        Client key in PEM format.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="insecureSkipVerify")
    def insecure_skip_verify(self) -> Optional[builtins.bool]:
        """
        Disable target certificate validation. Defaults to `false`.
        """
        return pulumi.get(self, "insecure_skip_verify")

    @property
    @pulumi.getter(name="serverName")
    def server_name(self) -> Optional[builtins.str]:
        """
        Used to verify the hostname for the targets.
        """
        return pulumi.get(self, "server_name")


@pulumi.output_type
class CheckSettingsTraceroute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxHops":
            suggest = "max_hops"
        elif key == "maxUnknownHops":
            suggest = "max_unknown_hops"
        elif key == "ptrLookup":
            suggest = "ptr_lookup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CheckSettingsTraceroute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CheckSettingsTraceroute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CheckSettingsTraceroute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_hops: Optional[builtins.int] = None,
                 max_unknown_hops: Optional[builtins.int] = None,
                 ptr_lookup: Optional[builtins.bool] = None):
        """
        :param builtins.int max_hops: Maximum TTL for the trace Defaults to `64`.
        :param builtins.int max_unknown_hops: Maximum number of hosts to travers that give no response Defaults to `15`.
        :param builtins.bool ptr_lookup: Reverse lookup hostnames from IP addresses Defaults to `true`.
        """
        if max_hops is not None:
            pulumi.set(__self__, "max_hops", max_hops)
        if max_unknown_hops is not None:
            pulumi.set(__self__, "max_unknown_hops", max_unknown_hops)
        if ptr_lookup is not None:
            pulumi.set(__self__, "ptr_lookup", ptr_lookup)

    @property
    @pulumi.getter(name="maxHops")
    def max_hops(self) -> Optional[builtins.int]:
        """
        Maximum TTL for the trace Defaults to `64`.
        """
        return pulumi.get(self, "max_hops")

    @property
    @pulumi.getter(name="maxUnknownHops")
    def max_unknown_hops(self) -> Optional[builtins.int]:
        """
        Maximum number of hosts to travers that give no response Defaults to `15`.
        """
        return pulumi.get(self, "max_unknown_hops")

    @property
    @pulumi.getter(name="ptrLookup")
    def ptr_lookup(self) -> Optional[builtins.bool]:
        """
        Reverse lookup hostnames from IP addresses Defaults to `true`.
        """
        return pulumi.get(self, "ptr_lookup")


