# Asterix specifications

# This file is generated, DO NOT EDIT!
# For more details, see:
#     - https://github.com/zoranbosnjak/asterix-specs

from asterix.base import *

asterix_specs_ref = "git:3989dcea2507e4bb165b6039f6a90f9ec41bdfde"
asterix_specs_date = "2025-03-25T13:43:08+01:00"
code_generator_version = "0.7.0"

# Asterix types

class Content_0(ContentRaw):
    cv_arg: TypeAlias = int

class RuleContent_0(RuleContentContextFree):
    cv_arg: TypeAlias = Content_0.cv_arg
    cv_content: TypeAlias = Content_0

    @property
    def content(self) -> Content_0:
        return self._get_content() # type: ignore

class Variation_165(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_165.cv_arg") -> "Variation_165":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_159(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_165.cv_arg
    cv_variation: TypeAlias = Variation_165

    @classmethod
    def create(cls, arg : "RuleVariation_159.cv_arg") -> "RuleVariation_159":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_165:
        return self.arg # type: ignore

class NonSpare_1662(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SAC"
    cv_title = "System Area Code"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1662.cv_arg") -> "NonSpare_1662":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_860(Item):
    cv_arg: TypeAlias = NonSpare_1662.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1662

    @classmethod
    def create(cls, arg : "Item_860.cv_arg") -> "Item_860":
        return cls._create(arg) # type: ignore

class NonSpare_1717(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SIC"
    cv_title = "System Identification Code"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1717.cv_arg") -> "NonSpare_1717":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_891(Item):
    cv_arg: TypeAlias = NonSpare_1717.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1717

    @classmethod
    def create(cls, arg : "Item_891.cv_arg") -> "Item_891":
        return cls._create(arg) # type: ignore

class Variation_1198(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["SAC"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["SIC"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1198.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_860, 8), (Item_891, 8)]
    cv_items_dict = {"SAC": RuleVariation_159, "SIC": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> Type[RuleVariation_159]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> Type[RuleVariation_159]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1198.cv_arg") -> 'Variation_1198':
        return cls._create(arg) # type: ignore

class RuleVariation_1146(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1198.cv_arg
    cv_variation: TypeAlias = Variation_1198

    @classmethod
    def create(cls, arg : "RuleVariation_1146.cv_arg") -> "RuleVariation_1146":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1198:
        return self.arg # type: ignore

class NonSpare_36(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1146.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1146

    @classmethod
    def create(cls, arg : "NonSpare_36.cv_arg") -> "NonSpare_36":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1198:
        return self.rule.variation

class UapItem_36(UapItem):
    cv_non_spare: TypeAlias = NonSpare_36

class Content_429(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Plot", 1: "Track"}

class RuleContent_429(RuleContentContextFree):
    cv_arg: TypeAlias = Content_429.cv_arg
    cv_content: TypeAlias = Content_429

    @property
    def content(self) -> Content_429:
        return self._get_content() # type: ignore

class Variation_72(Element):
    cv_arg: TypeAlias = RuleContent_429.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_429

    @classmethod
    def create(cls, arg: "Variation_72.cv_arg") -> "Variation_72":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_429:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_429:
        return self.rule.content

class RuleVariation_72(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_72.cv_arg
    cv_variation: TypeAlias = Variation_72

    @classmethod
    def create(cls, arg : "RuleVariation_72.cv_arg") -> "RuleVariation_72":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_72:
        return self.arg # type: ignore

class Content_19(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual plot or track", 1: "Simulated plot or track"}

class RuleContent_19(RuleContentContextFree):
    cv_arg: TypeAlias = Content_19.cv_arg
    cv_content: TypeAlias = Content_19

    @property
    def content(self) -> Content_19:
        return self._get_content() # type: ignore

class Variation_403(Element):
    cv_arg: TypeAlias = RuleContent_19.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_19

    @classmethod
    def create(cls, arg: "Variation_403.cv_arg") -> "Variation_403":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_19:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_19:
        return self.rule.content

class RuleVariation_392(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_403.cv_arg
    cv_variation: TypeAlias = Variation_403

    @classmethod
    def create(cls, arg : "RuleVariation_392.cv_arg") -> "RuleVariation_392":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_403:
        return self.arg # type: ignore

class Content_349(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No detection", 1: "Sole primary detection", 2: "Sole secondary detection", 3: "Combined primary and secondary detection"}

class RuleContent_349(RuleContentContextFree):
    cv_arg: TypeAlias = Content_349.cv_arg
    cv_content: TypeAlias = Content_349

    @property
    def content(self) -> Content_349:
        return self._get_content() # type: ignore

class Variation_594(Element):
    cv_arg: TypeAlias = RuleContent_349.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_349

    @classmethod
    def create(cls, arg: "Variation_594.cv_arg") -> "Variation_594":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_349:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_349:
        return self.rule.content

class RuleVariation_583(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_594.cv_arg
    cv_variation: TypeAlias = Variation_594

    @classmethod
    def create(cls, arg : "RuleVariation_583.cv_arg") -> "RuleVariation_583":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_594:
        return self.arg # type: ignore

class Content_485(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Target report from antenna 1", 1: "Target report from antenna 2"}

class RuleContent_485(RuleContentContextFree):
    cv_arg: TypeAlias = Content_485.cv_arg
    cv_content: TypeAlias = Content_485

    @property
    def content(self) -> Content_485:
        return self._get_content() # type: ignore

class Variation_756(Element):
    cv_arg: TypeAlias = RuleContent_485.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_485

    @classmethod
    def create(cls, arg: "Variation_756.cv_arg") -> "Variation_756":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_485:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_485:
        return self.rule.content

class RuleVariation_745(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_756.cv_arg
    cv_variation: TypeAlias = Variation_756

    @classmethod
    def create(cls, arg : "RuleVariation_745.cv_arg") -> "RuleVariation_745":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_756:
        return self.arg # type: ignore

class Content_153(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Special Position Identification"}

class RuleContent_153(RuleContentContextFree):
    cv_arg: TypeAlias = Content_153.cv_arg
    cv_content: TypeAlias = Content_153

    @property
    def content(self) -> Content_153:
        return self._get_content() # type: ignore

class Variation_841(Element):
    cv_arg: TypeAlias = RuleContent_153.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_153

    @classmethod
    def create(cls, arg: "Variation_841.cv_arg") -> "Variation_841":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_153:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_153:
        return self.rule.content

class RuleVariation_811(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_841.cv_arg
    cv_variation: TypeAlias = Variation_841

    @classmethod
    def create(cls, arg : "RuleVariation_811.cv_arg") -> "RuleVariation_811":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_841:
        return self.arg # type: ignore

class Content_141(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Plot or track from a fixed transponder"}

class RuleContent_141(RuleContentContextFree):
    cv_arg: TypeAlias = Content_141.cv_arg
    cv_content: TypeAlias = Content_141

    @property
    def content(self) -> Content_141:
        return self._get_content() # type: ignore

class Variation_920(Element):
    cv_arg: TypeAlias = RuleContent_141.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_141

    @classmethod
    def create(cls, arg: "Variation_920.cv_arg") -> "Variation_920":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_141:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_141:
        return self.rule.content

class RuleVariation_890(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_920.cv_arg
    cv_variation: TypeAlias = Variation_920

    @classmethod
    def create(cls, arg : "RuleVariation_890.cv_arg") -> "RuleVariation_890":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_920:
        return self.arg # type: ignore

class Content_157(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test target indicator"}

class RuleContent_157(RuleContentContextFree):
    cv_arg: TypeAlias = Content_157.cv_arg
    cv_content: TypeAlias = Content_157

    @property
    def content(self) -> Content_157:
        return self._get_content() # type: ignore

class Variation_36(Element):
    cv_arg: TypeAlias = RuleContent_157.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_157

    @classmethod
    def create(cls, arg: "Variation_36.cv_arg") -> "Variation_36":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_157:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_157:
        return self.rule.content

class RuleVariation_36(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_36.cv_arg
    cv_variation: TypeAlias = Variation_36

    @classmethod
    def create(cls, arg : "RuleVariation_36.cv_arg") -> "RuleVariation_36":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_36:
        return self.arg # type: ignore

class Content_160(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Unlawful interference (code 7500)", 2: "Radio-communication failure (code 7600)", 3: "Emergency (code 7700)"}

class RuleContent_160(RuleContentContextFree):
    cv_arg: TypeAlias = Content_160.cv_arg
    cv_content: TypeAlias = Content_160

    @property
    def content(self) -> Content_160:
        return self._get_content() # type: ignore

class Variation_468(Element):
    cv_arg: TypeAlias = RuleContent_160.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 2
    cv_rule = RuleContent_160

    @classmethod
    def create(cls, arg: "Variation_468.cv_arg") -> "Variation_468":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_160:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_160:
        return self.rule.content

class RuleVariation_457(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_468.cv_arg
    cv_variation: TypeAlias = Variation_468

    @classmethod
    def create(cls, arg : "RuleVariation_457.cv_arg") -> "RuleVariation_457":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_468:
        return self.arg # type: ignore

class Content_117(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Military emergency"}

class RuleContent_117(RuleContentContextFree):
    cv_arg: TypeAlias = Content_117.cv_arg
    cv_content: TypeAlias = Content_117

    @property
    def content(self) -> Content_117:
        return self._get_content() # type: ignore

class Variation_628(Element):
    cv_arg: TypeAlias = RuleContent_117.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_117

    @classmethod
    def create(cls, arg: "Variation_628.cv_arg") -> "Variation_628":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_117:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_117:
        return self.rule.content

class RuleVariation_617(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_628.cv_arg
    cv_variation: TypeAlias = Variation_628

    @classmethod
    def create(cls, arg : "RuleVariation_617.cv_arg") -> "RuleVariation_617":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_628:
        return self.arg # type: ignore

class Content_118(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Military identification"}

class RuleContent_118(RuleContentContextFree):
    cv_arg: TypeAlias = Content_118.cv_arg
    cv_content: TypeAlias = Content_118

    @property
    def content(self) -> Content_118:
        return self._get_content() # type: ignore

class Variation_710(Element):
    cv_arg: TypeAlias = RuleContent_118.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_118

    @classmethod
    def create(cls, arg: "Variation_710.cv_arg") -> "Variation_710":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_118:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_118:
        return self.rule.content

class RuleVariation_699(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_710.cv_arg
    cv_variation: TypeAlias = Variation_710

    @classmethod
    def create(cls, arg : "RuleVariation_699.cv_arg") -> "RuleVariation_699":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_710:
        return self.arg # type: ignore

class NonSpare_1964(NonSpare):
    cv_arg: TypeAlias = RuleVariation_72.cv_arg
    cv_name = "TYP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_72

    @classmethod
    def create(cls, arg : "NonSpare_1964.cv_arg") -> "NonSpare_1964":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_72:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_72:
        return self.rule.variation

class Item_1075(Item):
    cv_arg: TypeAlias = NonSpare_1964.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1964

    @classmethod
    def create(cls, arg : "Item_1075.cv_arg") -> "Item_1075":
        return cls._create(arg) # type: ignore

class NonSpare_1732(NonSpare):
    cv_arg: TypeAlias = RuleVariation_392.cv_arg
    cv_name = "SIM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_392

    @classmethod
    def create(cls, arg : "NonSpare_1732.cv_arg") -> "NonSpare_1732":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_392:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_403:
        return self.rule.variation

class Item_904(Item):
    cv_arg: TypeAlias = NonSpare_1732.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1732

    @classmethod
    def create(cls, arg : "Item_904.cv_arg") -> "Item_904":
        return cls._create(arg) # type: ignore

class NonSpare_1774(NonSpare):
    cv_arg: TypeAlias = RuleVariation_583.cv_arg
    cv_name = "SSRPSR"
    cv_title = "Radar Detection in Last Antenna Scan"
    cv_rule: TypeAlias = RuleVariation_583

    @classmethod
    def create(cls, arg : "NonSpare_1774.cv_arg") -> "NonSpare_1774":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_583:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_594:
        return self.rule.variation

class Item_936(Item):
    cv_arg: TypeAlias = NonSpare_1774.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1774

    @classmethod
    def create(cls, arg : "Item_936.cv_arg") -> "Item_936":
        return cls._create(arg) # type: ignore

class NonSpare_613(NonSpare):
    cv_arg: TypeAlias = RuleVariation_745.cv_arg
    cv_name = "ANT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_745

    @classmethod
    def create(cls, arg : "NonSpare_613.cv_arg") -> "NonSpare_613":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_745:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_756:
        return self.rule.variation

class Item_74(Item):
    cv_arg: TypeAlias = NonSpare_613.cv_arg
    cv_non_spare: TypeAlias = NonSpare_613

    @classmethod
    def create(cls, arg : "Item_74.cv_arg") -> "Item_74":
        return cls._create(arg) # type: ignore

class NonSpare_1747(NonSpare):
    cv_arg: TypeAlias = RuleVariation_811.cv_arg
    cv_name = "SPI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_811

    @classmethod
    def create(cls, arg : "NonSpare_1747.cv_arg") -> "NonSpare_1747":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_811:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_841:
        return self.rule.variation

class Item_917(Item):
    cv_arg: TypeAlias = NonSpare_1747.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1747

    @classmethod
    def create(cls, arg : "Item_917.cv_arg") -> "Item_917":
        return cls._create(arg) # type: ignore

class NonSpare_1545(NonSpare):
    cv_arg: TypeAlias = RuleVariation_890.cv_arg
    cv_name = "RAB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_890

    @classmethod
    def create(cls, arg : "NonSpare_1545.cv_arg") -> "NonSpare_1545":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_890:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_920:
        return self.rule.variation

class Item_772(Item):
    cv_arg: TypeAlias = NonSpare_1545.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1545

    @classmethod
    def create(cls, arg : "Item_772.cv_arg") -> "Item_772":
        return cls._create(arg) # type: ignore

class NonSpare_1940(NonSpare):
    cv_arg: TypeAlias = RuleVariation_36.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_36

    @classmethod
    def create(cls, arg : "NonSpare_1940.cv_arg") -> "NonSpare_1940":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_36:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_36:
        return self.rule.variation

class Item_1054(Item):
    cv_arg: TypeAlias = NonSpare_1940.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1940

    @classmethod
    def create(cls, arg : "Item_1054.cv_arg") -> "Item_1054":
        return cls._create(arg) # type: ignore

class NonSpare_907(NonSpare):
    cv_arg: TypeAlias = RuleVariation_457.cv_arg
    cv_name = "DS1DS2"
    cv_title = "Radar Detection in Last Antenna Scan"
    cv_rule: TypeAlias = RuleVariation_457

    @classmethod
    def create(cls, arg : "NonSpare_907.cv_arg") -> "NonSpare_907":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_457:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_468:
        return self.rule.variation

class Item_277(Item):
    cv_arg: TypeAlias = NonSpare_907.cv_arg
    cv_non_spare: TypeAlias = NonSpare_907

    @classmethod
    def create(cls, arg : "Item_277.cv_arg") -> "Item_277":
        return cls._create(arg) # type: ignore

class NonSpare_1270(NonSpare):
    cv_arg: TypeAlias = RuleVariation_617.cv_arg
    cv_name = "ME"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_617

    @classmethod
    def create(cls, arg : "NonSpare_1270.cv_arg") -> "NonSpare_1270":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_617:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_628:
        return self.rule.variation

class Item_545(Item):
    cv_arg: TypeAlias = NonSpare_1270.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1270

    @classmethod
    def create(cls, arg : "Item_545.cv_arg") -> "Item_545":
        return cls._create(arg) # type: ignore

class NonSpare_1288(NonSpare):
    cv_arg: TypeAlias = RuleVariation_699.cv_arg
    cv_name = "MI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_699

    @classmethod
    def create(cls, arg : "NonSpare_1288.cv_arg") -> "NonSpare_1288":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_699:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_710:
        return self.rule.variation

class Item_552(Item):
    cv_arg: TypeAlias = NonSpare_1288.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1288

    @classmethod
    def create(cls, arg : "Item_552.cv_arg") -> "Item_552":
        return cls._create(arg) # type: ignore

class Item_24(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 5
    cv_bit_size = 2

class Variation_1397(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_72.cv_arg, Tuple[Literal["TYP"], RuleVariation_72.cv_arg]], Union[RuleVariation_392.cv_arg, Tuple[Literal["SIM"], RuleVariation_392.cv_arg]], Union[RuleVariation_583.cv_arg, Tuple[Literal["SSRPSR"], RuleVariation_583.cv_arg]], Union[RuleVariation_745.cv_arg, Tuple[Literal["ANT"], RuleVariation_745.cv_arg]], Union[RuleVariation_811.cv_arg, Tuple[Literal["SPI"], RuleVariation_811.cv_arg]], Union[RuleVariation_890.cv_arg, Tuple[Literal["RAB"], RuleVariation_890.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_36.cv_arg, Tuple[Literal["TST"], RuleVariation_36.cv_arg]], Union[RuleVariation_457.cv_arg, Tuple[Literal["DS1DS2"], RuleVariation_457.cv_arg]], Union[RuleVariation_617.cv_arg, Tuple[Literal["ME"], RuleVariation_617.cv_arg]], Union[RuleVariation_699.cv_arg, Tuple[Literal["MI"], RuleVariation_699.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1397.cv_arg_group_1"],
        Tuple["Variation_1397.cv_arg_group_1", "Variation_1397.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_1075, 1), (Item_904, 1), (Item_936, 2), (Item_74, 1), (Item_917, 1), (Item_772, 1), None], [(Item_1054, 1), (Item_277, 2), (Item_545, 1), (Item_552, 1), (Item_24, 2), None]]

    @classmethod
    def create(cls, arg: "Variation_1397.cv_arg") -> 'Variation_1397':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["TYP"]) -> RuleVariation_72:
        ...
    @overload
    def get_item(self, key : Literal["SIM"]) -> RuleVariation_392:
        ...
    @overload
    def get_item(self, key : Literal["SSRPSR"]) -> RuleVariation_583:
        ...
    @overload
    def get_item(self, key : Literal["ANT"]) -> RuleVariation_745:
        ...
    @overload
    def get_item(self, key : Literal["SPI"]) -> RuleVariation_811:
        ...
    @overload
    def get_item(self, key : Literal["RAB"]) -> RuleVariation_890:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_36]:
        ...
    @overload
    def get_item(self, key : Literal["DS1DS2"]) -> Optional[RuleVariation_457]:
        ...
    @overload
    def get_item(self, key : Literal["ME"]) -> Optional[RuleVariation_617]:
        ...
    @overload
    def get_item(self, key : Literal["MI"]) -> Optional[RuleVariation_699]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1318(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1397.cv_arg
    cv_variation: TypeAlias = Variation_1397

    @classmethod
    def create(cls, arg : "RuleVariation_1318.cv_arg") -> "RuleVariation_1318":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1397:
        return self.arg # type: ignore

class NonSpare_87(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1318.cv_arg
    cv_name = "020"
    cv_title = "Target Report Descriptor"
    cv_rule: TypeAlias = RuleVariation_1318

    @classmethod
    def create(cls, arg : "NonSpare_87.cv_arg") -> "NonSpare_87":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1318:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1397:
        return self.rule.variation

class UapItem_87(UapItem):
    cv_non_spare: TypeAlias = NonSpare_87

class Content_769(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_768(RuleContentContextFree):
    cv_arg: TypeAlias = Content_769.cv_arg
    cv_content: TypeAlias = Content_769

    @property
    def content(self) -> Content_769:
        return self._get_content() # type: ignore

class Variation_332(Element):
    cv_arg: TypeAlias = RuleContent_768.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_768

    @classmethod
    def create(cls, arg: "Variation_332.cv_arg") -> "Variation_332":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_768:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_769:
        return self.rule.content

class RuleVariation_325(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_332.cv_arg
    cv_variation: TypeAlias = Variation_332

    @classmethod
    def create(cls, arg : "RuleVariation_325.cv_arg") -> "RuleVariation_325":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_332:
        return self.arg # type: ignore

class NonSpare_1595(NonSpare):
    cv_arg: TypeAlias = RuleVariation_325.cv_arg
    cv_name = "RHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_325

    @classmethod
    def create(cls, arg : "NonSpare_1595.cv_arg") -> "NonSpare_1595":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_325:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_332:
        return self.rule.variation

class Item_817(Item):
    cv_arg: TypeAlias = NonSpare_1595.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1595

    @classmethod
    def create(cls, arg : "Item_817.cv_arg") -> "Item_817":
        return cls._create(arg) # type: ignore

class Content_794(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 5.4931640625e-3
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_793(RuleContentContextFree):
    cv_arg: TypeAlias = Content_794.cv_arg
    cv_content: TypeAlias = Content_794

    @property
    def content(self) -> Content_794:
        return self._get_content() # type: ignore

class Variation_343(Element):
    cv_arg: TypeAlias = RuleContent_793.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_793

    @classmethod
    def create(cls, arg: "Variation_343.cv_arg") -> "Variation_343":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_793:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_794:
        return self.rule.content

class RuleVariation_336(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_343.cv_arg
    cv_variation: TypeAlias = Variation_343

    @classmethod
    def create(cls, arg : "RuleVariation_336.cv_arg") -> "RuleVariation_336":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_343:
        return self.arg # type: ignore

class NonSpare_1862(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "THETA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1862.cv_arg") -> "NonSpare_1862":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_997(Item):
    cv_arg: TypeAlias = NonSpare_1862.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1862

    @classmethod
    def create(cls, arg : "Item_997.cv_arg") -> "Item_997":
        return cls._create(arg) # type: ignore

class Variation_1184(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_325.cv_arg, Tuple[Literal["RHO"], RuleVariation_325.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["THETA"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1184.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_817, 16), (Item_997, 16)]
    cv_items_dict = {"RHO": RuleVariation_325, "THETA": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["RHO"]) -> Type[RuleVariation_325]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["THETA"]) -> Type[RuleVariation_336]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RHO"], Literal["THETA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RHO"]) -> RuleVariation_325:
        ...
    @overload
    def get_item(self, key : Literal["THETA"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1184.cv_arg") -> 'Variation_1184':
        return cls._create(arg) # type: ignore

class RuleVariation_1135(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1184.cv_arg
    cv_variation: TypeAlias = Variation_1184

    @classmethod
    def create(cls, arg : "RuleVariation_1135.cv_arg") -> "RuleVariation_1135":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1184:
        return self.arg # type: ignore

class NonSpare_138(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1135.cv_arg
    cv_name = "040"
    cv_title = "Measured Position in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1135

    @classmethod
    def create(cls, arg : "NonSpare_138.cv_arg") -> "NonSpare_138":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1135:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1184:
        return self.rule.variation

class UapItem_138(UapItem):
    cv_non_spare: TypeAlias = NonSpare_138

class Content_57(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Code validated", 1: "Code not validated"}

class RuleContent_57(RuleContentContextFree):
    cv_arg: TypeAlias = Content_57.cv_arg
    cv_content: TypeAlias = Content_57

    @property
    def content(self) -> Content_57:
        return self._get_content() # type: ignore

class Variation_15(Element):
    cv_arg: TypeAlias = RuleContent_57.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_57

    @classmethod
    def create(cls, arg: "Variation_15.cv_arg") -> "Variation_15":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_57:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_57:
        return self.rule.content

class RuleVariation_15(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_15.cv_arg
    cv_variation: TypeAlias = Variation_15

    @classmethod
    def create(cls, arg : "RuleVariation_15.cv_arg") -> "RuleVariation_15":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_15:
        return self.arg # type: ignore

class NonSpare_1998(NonSpare):
    cv_arg: TypeAlias = RuleVariation_15.cv_arg
    cv_name = "V"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_15

    @classmethod
    def create(cls, arg : "NonSpare_1998.cv_arg") -> "NonSpare_1998":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_15:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_15:
        return self.rule.variation

class Item_1106(Item):
    cv_arg: TypeAlias = NonSpare_1998.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1998

    @classmethod
    def create(cls, arg : "Item_1106.cv_arg") -> "Item_1106":
        return cls._create(arg) # type: ignore

class Content_98(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Garbled code"}

class RuleContent_98(RuleContentContextFree):
    cv_arg: TypeAlias = Content_98.cv_arg
    cv_content: TypeAlias = Content_98

    @property
    def content(self) -> Content_98:
        return self._get_content() # type: ignore

class Variation_407(Element):
    cv_arg: TypeAlias = RuleContent_98.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_98

    @classmethod
    def create(cls, arg: "Variation_407.cv_arg") -> "Variation_407":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_98:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_98:
        return self.rule.content

class RuleVariation_396(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_407.cv_arg
    cv_variation: TypeAlias = Variation_407

    @classmethod
    def create(cls, arg : "RuleVariation_396.cv_arg") -> "RuleVariation_396":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_407:
        return self.arg # type: ignore

class NonSpare_1014(NonSpare):
    cv_arg: TypeAlias = RuleVariation_396.cv_arg
    cv_name = "G"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_396

    @classmethod
    def create(cls, arg : "NonSpare_1014.cv_arg") -> "NonSpare_1014":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_396:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_407:
        return self.rule.variation

class Item_357(Item):
    cv_arg: TypeAlias = NonSpare_1014.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1014

    @classmethod
    def create(cls, arg : "Item_357.cv_arg") -> "Item_357":
        return cls._create(arg) # type: ignore

class Content_293(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-3/A code derived from the reply of the transponder", 1: "Smoothed Mode-3/A code as provided by a local tracker"}

class RuleContent_293(RuleContentContextFree):
    cv_arg: TypeAlias = Content_293.cv_arg
    cv_content: TypeAlias = Content_293

    @property
    def content(self) -> Content_293:
        return self._get_content() # type: ignore

class Variation_556(Element):
    cv_arg: TypeAlias = RuleContent_293.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_293

    @classmethod
    def create(cls, arg: "Variation_556.cv_arg") -> "Variation_556":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_293:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_293:
        return self.rule.content

class RuleVariation_545(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_556.cv_arg
    cv_variation: TypeAlias = Variation_556

    @classmethod
    def create(cls, arg : "RuleVariation_545.cv_arg") -> "RuleVariation_545":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_556:
        return self.arg # type: ignore

class NonSpare_1148(NonSpare):
    cv_arg: TypeAlias = RuleVariation_545.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_545

    @classmethod
    def create(cls, arg : "NonSpare_1148.cv_arg") -> "NonSpare_1148":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_545:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_556:
        return self.rule.variation

class Item_457(Item):
    cv_arg: TypeAlias = NonSpare_1148.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1148

    @classmethod
    def create(cls, arg : "Item_457.cv_arg") -> "Item_457":
        return cls._create(arg) # type: ignore

class Item_16(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 1

class Content_612(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringOctal

class RuleContent_612(RuleContentContextFree):
    cv_arg: TypeAlias = Content_612.cv_arg
    cv_content: TypeAlias = Content_612

    @property
    def content(self) -> Content_612:
        return self._get_content() # type: ignore

class Variation_812(Element):
    cv_arg: TypeAlias = RuleContent_612.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 12
    cv_rule = RuleContent_612

    @classmethod
    def create(cls, arg: "Variation_812.cv_arg") -> "Variation_812":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_612:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_612:
        return self.rule.content

class RuleVariation_782(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_812.cv_arg
    cv_variation: TypeAlias = Variation_812

    @classmethod
    def create(cls, arg : "RuleVariation_782.cv_arg") -> "RuleVariation_782":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_812:
        return self.arg # type: ignore

class NonSpare_1314(NonSpare):
    cv_arg: TypeAlias = RuleVariation_782.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Reply in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_782

    @classmethod
    def create(cls, arg : "NonSpare_1314.cv_arg") -> "NonSpare_1314":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_782:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_812:
        return self.rule.variation

class Item_577(Item):
    cv_arg: TypeAlias = NonSpare_1314.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1314

    @classmethod
    def create(cls, arg : "Item_577.cv_arg") -> "Item_577":
        return cls._create(arg) # type: ignore

class Variation_1273(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_545.cv_arg, Tuple[Literal["L"], RuleVariation_545.cv_arg]], int, Union[RuleVariation_782.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_782.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1273.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1106, 1), (Item_357, 1), (Item_457, 1), (Item_16, 1), (Item_577, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "L": RuleVariation_545, "MODE3A": RuleVariation_782}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> Type[RuleVariation_15]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> Type[RuleVariation_396]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> Type[RuleVariation_545]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> Type[RuleVariation_782]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE3A"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_545:
        ...
    @overload
    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_782:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1273.cv_arg") -> 'Variation_1273':
        return cls._create(arg) # type: ignore

class RuleVariation_1202(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1273.cv_arg
    cv_variation: TypeAlias = Variation_1273

    @classmethod
    def create(cls, arg : "RuleVariation_1202.cv_arg") -> "RuleVariation_1202":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1273:
        return self.arg # type: ignore

class NonSpare_214(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1202.cv_arg
    cv_name = "070"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1202

    @classmethod
    def create(cls, arg : "NonSpare_214.cv_arg") -> "NonSpare_214":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1202:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1273:
        return self.rule.variation

class UapItem_214(UapItem):
    cv_non_spare: TypeAlias = NonSpare_214

class Content_654(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_654(RuleContentContextFree):
    cv_arg: TypeAlias = Content_654.cv_arg
    cv_content: TypeAlias = Content_654

    @property
    def content(self) -> Content_654:
        return self._get_content() # type: ignore

class Variation_610(Element):
    cv_arg: TypeAlias = RuleContent_654.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 14
    cv_rule = RuleContent_654

    @classmethod
    def create(cls, arg: "Variation_610.cv_arg") -> "Variation_610":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_654:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_654:
        return self.rule.content

class RuleVariation_599(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_610.cv_arg
    cv_variation: TypeAlias = Variation_610

    @classmethod
    def create(cls, arg : "RuleVariation_599.cv_arg") -> "RuleVariation_599":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_610:
        return self.arg # type: ignore

class NonSpare_1074(NonSpare):
    cv_arg: TypeAlias = RuleVariation_599.cv_arg
    cv_name = "HGT"
    cv_title = "Mode-C HEIGHT"
    cv_rule: TypeAlias = RuleVariation_599

    @classmethod
    def create(cls, arg : "NonSpare_1074.cv_arg") -> "NonSpare_1074":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_599:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_610:
        return self.rule.variation

class Item_397(Item):
    cv_arg: TypeAlias = NonSpare_1074.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1074

    @classmethod
    def create(cls, arg : "Item_397.cv_arg") -> "Item_397":
        return cls._create(arg) # type: ignore

class Variation_1265(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_599.cv_arg, Tuple[Literal["HGT"], RuleVariation_599.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1265.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1106, 1), (Item_357, 1), (Item_397, 14)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "HGT": RuleVariation_599}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> Type[RuleVariation_15]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> Type[RuleVariation_396]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["HGT"]) -> Type[RuleVariation_599]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["HGT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["HGT"]) -> RuleVariation_599:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1265.cv_arg") -> 'Variation_1265':
        return cls._create(arg) # type: ignore

class RuleVariation_1194(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1265.cv_arg
    cv_variation: TypeAlias = Variation_1265

    @classmethod
    def create(cls, arg : "RuleVariation_1194.cv_arg") -> "RuleVariation_1194":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1265:
        return self.arg # type: ignore

class NonSpare_254(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1194.cv_arg
    cv_name = "090"
    cv_title = "Mode-C Code in Binary Representation"
    cv_rule: TypeAlias = RuleVariation_1194

    @classmethod
    def create(cls, arg : "NonSpare_254.cv_arg") -> "NonSpare_254":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1194:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1265:
        return self.rule.variation

class UapItem_254(UapItem):
    cv_non_spare: TypeAlias = NonSpare_254

class Variation_150(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_150.cv_arg") -> "Variation_150":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class Variation_1463(Repetitive):
    cv_arg: TypeAlias = List[Variation_150.cv_arg]
    cv_rep_bytes = None
    cv_variation: TypeAlias = Variation_150

    @classmethod
    def create(cls, arg: "Variation_1463.cv_arg") -> 'Variation_1463':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_150]:
        return self._get_list() # type: ignore

class RuleVariation_1384(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1463.cv_arg
    cv_variation: TypeAlias = Variation_1463

    @classmethod
    def create(cls, arg : "RuleVariation_1384.cv_arg") -> "RuleVariation_1384":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1463:
        return self.arg # type: ignore

class NonSpare_313(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "130"
    cv_title = "Radar Plot Characteristics"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_313.cv_arg") -> "NonSpare_313":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1463:
        return self.rule.variation

class UapItem_313(UapItem):
    cv_non_spare: TypeAlias = NonSpare_313

class Content_771(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "s"

    def as_quantity(self, cv_unit : Optional[Literal["s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_770(RuleContentContextFree):
    cv_arg: TypeAlias = Content_771.cv_arg
    cv_content: TypeAlias = Content_771

    @property
    def content(self) -> Content_771:
        return self._get_content() # type: ignore

class Variation_334(Element):
    cv_arg: TypeAlias = RuleContent_770.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_770

    @classmethod
    def create(cls, arg: "Variation_334.cv_arg") -> "Variation_334":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_770:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_771:
        return self.rule.content

class RuleVariation_327(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_334.cv_arg
    cv_variation: TypeAlias = Variation_334

    @classmethod
    def create(cls, arg : "RuleVariation_327.cv_arg") -> "RuleVariation_327":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_334:
        return self.arg # type: ignore

class NonSpare_338(NonSpare):
    cv_arg: TypeAlias = RuleVariation_327.cv_arg
    cv_name = "141"
    cv_title = "Truncated Time of Day"
    cv_rule: TypeAlias = RuleVariation_327

    @classmethod
    def create(cls, arg : "NonSpare_338.cv_arg") -> "NonSpare_338":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_327:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_334:
        return self.rule.variation

class UapItem_338(UapItem):
    cv_non_spare: TypeAlias = NonSpare_338

class Content_287(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-2 code as derived from the reply of the transponder", 1: "Smoothed Mode-2 code as provided by a local tracker"}

class RuleContent_287(RuleContentContextFree):
    cv_arg: TypeAlias = Content_287.cv_arg
    cv_content: TypeAlias = Content_287

    @property
    def content(self) -> Content_287:
        return self._get_content() # type: ignore

class Variation_550(Element):
    cv_arg: TypeAlias = RuleContent_287.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_287

    @classmethod
    def create(cls, arg: "Variation_550.cv_arg") -> "Variation_550":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_287:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_287:
        return self.rule.content

class RuleVariation_539(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_550.cv_arg
    cv_variation: TypeAlias = Variation_550

    @classmethod
    def create(cls, arg : "RuleVariation_539.cv_arg") -> "RuleVariation_539":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_550:
        return self.arg # type: ignore

class NonSpare_1142(NonSpare):
    cv_arg: TypeAlias = RuleVariation_539.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_539

    @classmethod
    def create(cls, arg : "NonSpare_1142.cv_arg") -> "NonSpare_1142":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_539:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_550:
        return self.rule.variation

class Item_451(Item):
    cv_arg: TypeAlias = NonSpare_1142.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1142

    @classmethod
    def create(cls, arg : "Item_451.cv_arg") -> "Item_451":
        return cls._create(arg) # type: ignore

class NonSpare_1308(NonSpare):
    cv_arg: TypeAlias = RuleVariation_782.cv_arg
    cv_name = "MODE2"
    cv_title = "Mode-2 Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_782

    @classmethod
    def create(cls, arg : "NonSpare_1308.cv_arg") -> "NonSpare_1308":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_782:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_812:
        return self.rule.variation

class Item_571(Item):
    cv_arg: TypeAlias = NonSpare_1308.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1308

    @classmethod
    def create(cls, arg : "Item_571.cv_arg") -> "Item_571":
        return cls._create(arg) # type: ignore

class Variation_1268(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_539.cv_arg, Tuple[Literal["L"], RuleVariation_539.cv_arg]], int, Union[RuleVariation_782.cv_arg, Tuple[Literal["MODE2"], RuleVariation_782.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1268.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1106, 1), (Item_357, 1), (Item_451, 1), (Item_16, 1), (Item_571, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "L": RuleVariation_539, "MODE2": RuleVariation_782}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> Type[RuleVariation_15]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> Type[RuleVariation_396]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> Type[RuleVariation_539]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE2"]) -> Type[RuleVariation_782]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_539:
        ...
    @overload
    def get_item(self, key : Literal["MODE2"]) -> RuleVariation_782:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1268.cv_arg") -> 'Variation_1268':
        return cls._create(arg) # type: ignore

class RuleVariation_1197(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1268.cv_arg
    cv_variation: TypeAlias = Variation_1268

    @classmethod
    def create(cls, arg : "RuleVariation_1197.cv_arg") -> "RuleVariation_1197":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1268:
        return self.arg # type: ignore

class NonSpare_174(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1197.cv_arg
    cv_name = "050"
    cv_title = "Mode-2 Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1197

    @classmethod
    def create(cls, arg : "NonSpare_174.cv_arg") -> "NonSpare_174":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1268:
        return self.rule.variation

class UapItem_174(UapItem):
    cv_non_spare: TypeAlias = NonSpare_174

class Content_682(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 3.90625e-3
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_682(RuleContentContextFree):
    cv_arg: TypeAlias = Content_682.cv_arg
    cv_content: TypeAlias = Content_682

    @property
    def content(self) -> Content_682:
        return self._get_content() # type: ignore

class Variation_218(Element):
    cv_arg: TypeAlias = RuleContent_682.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_682

    @classmethod
    def create(cls, arg: "Variation_218.cv_arg") -> "Variation_218":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_682:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_682:
        return self.rule.content

class RuleVariation_211(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_218.cv_arg
    cv_variation: TypeAlias = Variation_218

    @classmethod
    def create(cls, arg : "RuleVariation_211.cv_arg") -> "RuleVariation_211":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_218:
        return self.arg # type: ignore

class NonSpare_301(NonSpare):
    cv_arg: TypeAlias = RuleVariation_211.cv_arg
    cv_name = "120"
    cv_title = "Measured Radial Doppler Speed"
    cv_rule: TypeAlias = RuleVariation_211

    @classmethod
    def create(cls, arg : "NonSpare_301.cv_arg") -> "NonSpare_301":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_211:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_218:
        return self.rule.variation

class UapItem_301(UapItem):
    cv_non_spare: TypeAlias = NonSpare_301

class Content_626(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["dBm"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "dBm"

    def as_quantity(self, cv_unit : Optional[Literal["dBm"]] = None) -> float:
        return self._as_quantity()

class RuleContent_626(RuleContentContextFree):
    cv_arg: TypeAlias = Content_626.cv_arg
    cv_content: TypeAlias = Content_626

    @property
    def content(self) -> Content_626:
        return self._get_content() # type: ignore

class Variation_208(Element):
    cv_arg: TypeAlias = RuleContent_626.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_626

    @classmethod
    def create(cls, arg: "Variation_208.cv_arg") -> "Variation_208":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_626:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_626:
        return self.rule.content

class RuleVariation_201(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_208.cv_arg
    cv_variation: TypeAlias = Variation_208

    @classmethod
    def create(cls, arg : "RuleVariation_201.cv_arg") -> "RuleVariation_201":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_208:
        return self.arg # type: ignore

class NonSpare_317(NonSpare):
    cv_arg: TypeAlias = RuleVariation_201.cv_arg
    cv_name = "131"
    cv_title = "Received Power"
    cv_rule: TypeAlias = RuleVariation_201

    @classmethod
    def create(cls, arg : "NonSpare_317.cv_arg") -> "NonSpare_317":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_201:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_208:
        return self.rule.variation

class UapItem_317(UapItem):
    cv_non_spare: TypeAlias = NonSpare_317

class Item_3(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 4

class Content_228(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A4", 1: "Low quality pulse A4"}

class RuleContent_228(RuleContentContextFree):
    cv_arg: TypeAlias = Content_228.cv_arg
    cv_content: TypeAlias = Content_228

    @property
    def content(self) -> Content_228:
        return self._get_content() # type: ignore

class Variation_728(Element):
    cv_arg: TypeAlias = RuleContent_228.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_228

    @classmethod
    def create(cls, arg: "Variation_728.cv_arg") -> "Variation_728":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_228:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_228:
        return self.rule.content

class RuleVariation_717(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_728.cv_arg
    cv_variation: TypeAlias = Variation_728

    @classmethod
    def create(cls, arg : "RuleVariation_717.cv_arg") -> "RuleVariation_717":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_728:
        return self.arg # type: ignore

class NonSpare_1503(NonSpare):
    cv_arg: TypeAlias = RuleVariation_717.cv_arg
    cv_name = "QA4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_717

    @classmethod
    def create(cls, arg : "NonSpare_1503.cv_arg") -> "NonSpare_1503":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_717:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_728:
        return self.rule.variation

class Item_733(Item):
    cv_arg: TypeAlias = NonSpare_1503.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1503

    @classmethod
    def create(cls, arg : "Item_733.cv_arg") -> "Item_733":
        return cls._create(arg) # type: ignore

class Content_227(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A2", 1: "Low quality pulse A2"}

class RuleContent_227(RuleContentContextFree):
    cv_arg: TypeAlias = Content_227.cv_arg
    cv_content: TypeAlias = Content_227

    @property
    def content(self) -> Content_227:
        return self._get_content() # type: ignore

class Variation_856(Element):
    cv_arg: TypeAlias = RuleContent_227.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_227

    @classmethod
    def create(cls, arg: "Variation_856.cv_arg") -> "Variation_856":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_227:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_227:
        return self.rule.content

class RuleVariation_826(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_856.cv_arg
    cv_variation: TypeAlias = Variation_856

    @classmethod
    def create(cls, arg : "RuleVariation_826.cv_arg") -> "RuleVariation_826":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_856:
        return self.arg # type: ignore

class NonSpare_1498(NonSpare):
    cv_arg: TypeAlias = RuleVariation_826.cv_arg
    cv_name = "QA2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_826

    @classmethod
    def create(cls, arg : "NonSpare_1498.cv_arg") -> "NonSpare_1498":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_826:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_856:
        return self.rule.variation

class Item_728(Item):
    cv_arg: TypeAlias = NonSpare_1498.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1498

    @classmethod
    def create(cls, arg : "Item_728.cv_arg") -> "Item_728":
        return cls._create(arg) # type: ignore

class Content_226(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse A1", 1: "Low quality pulse A1"}

class RuleContent_226(RuleContentContextFree):
    cv_arg: TypeAlias = Content_226.cv_arg
    cv_content: TypeAlias = Content_226

    @property
    def content(self) -> Content_226:
        return self._get_content() # type: ignore

class Variation_932(Element):
    cv_arg: TypeAlias = RuleContent_226.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_226

    @classmethod
    def create(cls, arg: "Variation_932.cv_arg") -> "Variation_932":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_226:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_226:
        return self.rule.content

class RuleVariation_902(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_932.cv_arg
    cv_variation: TypeAlias = Variation_932

    @classmethod
    def create(cls, arg : "RuleVariation_902.cv_arg") -> "RuleVariation_902":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_932:
        return self.arg # type: ignore

class NonSpare_1495(NonSpare):
    cv_arg: TypeAlias = RuleVariation_902.cv_arg
    cv_name = "QA1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_902

    @classmethod
    def create(cls, arg : "NonSpare_1495.cv_arg") -> "NonSpare_1495":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_902:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_932:
        return self.rule.variation

class Item_725(Item):
    cv_arg: TypeAlias = NonSpare_1495.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1495

    @classmethod
    def create(cls, arg : "Item_725.cv_arg") -> "Item_725":
        return cls._create(arg) # type: ignore

class Content_231(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B4", 1: "Low quality pulse B4"}

class RuleContent_231(RuleContentContextFree):
    cv_arg: TypeAlias = Content_231.cv_arg
    cv_content: TypeAlias = Content_231

    @property
    def content(self) -> Content_231:
        return self._get_content() # type: ignore

class Variation_981(Element):
    cv_arg: TypeAlias = RuleContent_231.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_231

    @classmethod
    def create(cls, arg: "Variation_981.cv_arg") -> "Variation_981":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_231:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_231:
        return self.rule.content

class RuleVariation_951(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_981.cv_arg
    cv_variation: TypeAlias = Variation_981

    @classmethod
    def create(cls, arg : "RuleVariation_951.cv_arg") -> "RuleVariation_951":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_981:
        return self.arg # type: ignore

class NonSpare_1514(NonSpare):
    cv_arg: TypeAlias = RuleVariation_951.cv_arg
    cv_name = "QB4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_951

    @classmethod
    def create(cls, arg : "NonSpare_1514.cv_arg") -> "NonSpare_1514":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_951:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_981:
        return self.rule.variation

class Item_744(Item):
    cv_arg: TypeAlias = NonSpare_1514.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1514

    @classmethod
    def create(cls, arg : "Item_744.cv_arg") -> "Item_744":
        return cls._create(arg) # type: ignore

class Content_230(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B2", 1: "Low quality pulse B2"}

class RuleContent_230(RuleContentContextFree):
    cv_arg: TypeAlias = Content_230.cv_arg
    cv_content: TypeAlias = Content_230

    @property
    def content(self) -> Content_230:
        return self._get_content() # type: ignore

class Variation_46(Element):
    cv_arg: TypeAlias = RuleContent_230.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_230

    @classmethod
    def create(cls, arg: "Variation_46.cv_arg") -> "Variation_46":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_230:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_230:
        return self.rule.content

class RuleVariation_46(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_46.cv_arg
    cv_variation: TypeAlias = Variation_46

    @classmethod
    def create(cls, arg : "RuleVariation_46.cv_arg") -> "RuleVariation_46":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_46:
        return self.arg # type: ignore

class NonSpare_1509(NonSpare):
    cv_arg: TypeAlias = RuleVariation_46.cv_arg
    cv_name = "QB2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_46

    @classmethod
    def create(cls, arg : "NonSpare_1509.cv_arg") -> "NonSpare_1509":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_46:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_46:
        return self.rule.variation

class Item_739(Item):
    cv_arg: TypeAlias = NonSpare_1509.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1509

    @classmethod
    def create(cls, arg : "Item_739.cv_arg") -> "Item_739":
        return cls._create(arg) # type: ignore

class Content_229(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse B1", 1: "Low quality pulse B1"}

class RuleContent_229(RuleContentContextFree):
    cv_arg: TypeAlias = Content_229.cv_arg
    cv_content: TypeAlias = Content_229

    @property
    def content(self) -> Content_229:
        return self._get_content() # type: ignore

class Variation_432(Element):
    cv_arg: TypeAlias = RuleContent_229.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_229

    @classmethod
    def create(cls, arg: "Variation_432.cv_arg") -> "Variation_432":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_229:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_229:
        return self.rule.content

class RuleVariation_421(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_432.cv_arg
    cv_variation: TypeAlias = Variation_432

    @classmethod
    def create(cls, arg : "RuleVariation_421.cv_arg") -> "RuleVariation_421":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_432:
        return self.arg # type: ignore

class NonSpare_1505(NonSpare):
    cv_arg: TypeAlias = RuleVariation_421.cv_arg
    cv_name = "QB1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_421

    @classmethod
    def create(cls, arg : "NonSpare_1505.cv_arg") -> "NonSpare_1505":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_421:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_432:
        return self.rule.variation

class Item_735(Item):
    cv_arg: TypeAlias = NonSpare_1505.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1505

    @classmethod
    def create(cls, arg : "Item_735.cv_arg") -> "Item_735":
        return cls._create(arg) # type: ignore

class Content_234(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C4", 1: "Low quality pulse C4"}

class RuleContent_234(RuleContentContextFree):
    cv_arg: TypeAlias = Content_234.cv_arg
    cv_content: TypeAlias = Content_234

    @property
    def content(self) -> Content_234:
        return self._get_content() # type: ignore

class Variation_539(Element):
    cv_arg: TypeAlias = RuleContent_234.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_234

    @classmethod
    def create(cls, arg: "Variation_539.cv_arg") -> "Variation_539":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_234:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_234:
        return self.rule.content

class RuleVariation_528(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_539.cv_arg
    cv_variation: TypeAlias = Variation_539

    @classmethod
    def create(cls, arg : "RuleVariation_528.cv_arg") -> "RuleVariation_528":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_539:
        return self.arg # type: ignore

class NonSpare_1522(NonSpare):
    cv_arg: TypeAlias = RuleVariation_528.cv_arg
    cv_name = "QC4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_528

    @classmethod
    def create(cls, arg : "NonSpare_1522.cv_arg") -> "NonSpare_1522":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_528:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_539:
        return self.rule.variation

class Item_752(Item):
    cv_arg: TypeAlias = NonSpare_1522.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1522

    @classmethod
    def create(cls, arg : "Item_752.cv_arg") -> "Item_752":
        return cls._create(arg) # type: ignore

class Content_233(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C2", 1: "Low quality pulse C2"}

class RuleContent_233(RuleContentContextFree):
    cv_arg: TypeAlias = Content_233.cv_arg
    cv_content: TypeAlias = Content_233

    @property
    def content(self) -> Content_233:
        return self._get_content() # type: ignore

class Variation_643(Element):
    cv_arg: TypeAlias = RuleContent_233.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_233

    @classmethod
    def create(cls, arg: "Variation_643.cv_arg") -> "Variation_643":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_233:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_233:
        return self.rule.content

class RuleVariation_632(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_643.cv_arg
    cv_variation: TypeAlias = Variation_643

    @classmethod
    def create(cls, arg : "RuleVariation_632.cv_arg") -> "RuleVariation_632":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_643:
        return self.arg # type: ignore

class NonSpare_1518(NonSpare):
    cv_arg: TypeAlias = RuleVariation_632.cv_arg
    cv_name = "QC2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_632

    @classmethod
    def create(cls, arg : "NonSpare_1518.cv_arg") -> "NonSpare_1518":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_632:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_643:
        return self.rule.variation

class Item_748(Item):
    cv_arg: TypeAlias = NonSpare_1518.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1518

    @classmethod
    def create(cls, arg : "Item_748.cv_arg") -> "Item_748":
        return cls._create(arg) # type: ignore

class Content_232(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse C1", 1: "Low quality pulse C1"}

class RuleContent_232(RuleContentContextFree):
    cv_arg: TypeAlias = Content_232.cv_arg
    cv_content: TypeAlias = Content_232

    @property
    def content(self) -> Content_232:
        return self._get_content() # type: ignore

class Variation_730(Element):
    cv_arg: TypeAlias = RuleContent_232.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_232

    @classmethod
    def create(cls, arg: "Variation_730.cv_arg") -> "Variation_730":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_232:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_232:
        return self.rule.content

class RuleVariation_719(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_730.cv_arg
    cv_variation: TypeAlias = Variation_730

    @classmethod
    def create(cls, arg : "RuleVariation_719.cv_arg") -> "RuleVariation_719":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_730:
        return self.arg # type: ignore

class NonSpare_1516(NonSpare):
    cv_arg: TypeAlias = RuleVariation_719.cv_arg
    cv_name = "QC1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_719

    @classmethod
    def create(cls, arg : "NonSpare_1516.cv_arg") -> "NonSpare_1516":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_719:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_730:
        return self.rule.variation

class Item_746(Item):
    cv_arg: TypeAlias = NonSpare_1516.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1516

    @classmethod
    def create(cls, arg : "Item_746.cv_arg") -> "Item_746":
        return cls._create(arg) # type: ignore

class Content_237(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D4", 1: "Low quality pulse D4"}

class RuleContent_237(RuleContentContextFree):
    cv_arg: TypeAlias = Content_237.cv_arg
    cv_content: TypeAlias = Content_237

    @property
    def content(self) -> Content_237:
        return self._get_content() # type: ignore

class Variation_859(Element):
    cv_arg: TypeAlias = RuleContent_237.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_237

    @classmethod
    def create(cls, arg: "Variation_859.cv_arg") -> "Variation_859":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_237:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_237:
        return self.rule.content

class RuleVariation_829(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_859.cv_arg
    cv_variation: TypeAlias = Variation_859

    @classmethod
    def create(cls, arg : "RuleVariation_829.cv_arg") -> "RuleVariation_829":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_859:
        return self.arg # type: ignore

class NonSpare_1530(NonSpare):
    cv_arg: TypeAlias = RuleVariation_829.cv_arg
    cv_name = "QD4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_829

    @classmethod
    def create(cls, arg : "NonSpare_1530.cv_arg") -> "NonSpare_1530":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_829:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_859:
        return self.rule.variation

class Item_760(Item):
    cv_arg: TypeAlias = NonSpare_1530.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1530

    @classmethod
    def create(cls, arg : "Item_760.cv_arg") -> "Item_760":
        return cls._create(arg) # type: ignore

class Content_236(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D2", 1: "Low quality pulse D2"}

class RuleContent_236(RuleContentContextFree):
    cv_arg: TypeAlias = Content_236.cv_arg
    cv_content: TypeAlias = Content_236

    @property
    def content(self) -> Content_236:
        return self._get_content() # type: ignore

class Variation_936(Element):
    cv_arg: TypeAlias = RuleContent_236.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_236

    @classmethod
    def create(cls, arg: "Variation_936.cv_arg") -> "Variation_936":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_236:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_236:
        return self.rule.content

class RuleVariation_906(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_936.cv_arg
    cv_variation: TypeAlias = Variation_936

    @classmethod
    def create(cls, arg : "RuleVariation_906.cv_arg") -> "RuleVariation_906":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_936:
        return self.arg # type: ignore

class NonSpare_1528(NonSpare):
    cv_arg: TypeAlias = RuleVariation_906.cv_arg
    cv_name = "QD2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_906

    @classmethod
    def create(cls, arg : "NonSpare_1528.cv_arg") -> "NonSpare_1528":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_906:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_936:
        return self.rule.variation

class Item_758(Item):
    cv_arg: TypeAlias = NonSpare_1528.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1528

    @classmethod
    def create(cls, arg : "Item_758.cv_arg") -> "Item_758":
        return cls._create(arg) # type: ignore

class Content_235(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "High quality pulse D1", 1: "Low quality pulse D1"}

class RuleContent_235(RuleContentContextFree):
    cv_arg: TypeAlias = Content_235.cv_arg
    cv_content: TypeAlias = Content_235

    @property
    def content(self) -> Content_235:
        return self._get_content() # type: ignore

class Variation_982(Element):
    cv_arg: TypeAlias = RuleContent_235.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_235

    @classmethod
    def create(cls, arg: "Variation_982.cv_arg") -> "Variation_982":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_235:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_235:
        return self.rule.content

class RuleVariation_952(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_982.cv_arg
    cv_variation: TypeAlias = Variation_982

    @classmethod
    def create(cls, arg : "RuleVariation_952.cv_arg") -> "RuleVariation_952":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_982:
        return self.arg # type: ignore

class NonSpare_1525(NonSpare):
    cv_arg: TypeAlias = RuleVariation_952.cv_arg
    cv_name = "QD1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_952

    @classmethod
    def create(cls, arg : "NonSpare_1525.cv_arg") -> "NonSpare_1525":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_952:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_982:
        return self.rule.variation

class Item_755(Item):
    cv_arg: TypeAlias = NonSpare_1525.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1525

    @classmethod
    def create(cls, arg : "Item_755.cv_arg") -> "Item_755":
        return cls._create(arg) # type: ignore

class Variation_1036(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_717.cv_arg, Tuple[Literal["QA4"], RuleVariation_717.cv_arg]], Union[RuleVariation_826.cv_arg, Tuple[Literal["QA2"], RuleVariation_826.cv_arg]], Union[RuleVariation_902.cv_arg, Tuple[Literal["QA1"], RuleVariation_902.cv_arg]], Union[RuleVariation_951.cv_arg, Tuple[Literal["QB4"], RuleVariation_951.cv_arg]], Union[RuleVariation_46.cv_arg, Tuple[Literal["QB2"], RuleVariation_46.cv_arg]], Union[RuleVariation_421.cv_arg, Tuple[Literal["QB1"], RuleVariation_421.cv_arg]], Union[RuleVariation_528.cv_arg, Tuple[Literal["QC4"], RuleVariation_528.cv_arg]], Union[RuleVariation_632.cv_arg, Tuple[Literal["QC2"], RuleVariation_632.cv_arg]], Union[RuleVariation_719.cv_arg, Tuple[Literal["QC1"], RuleVariation_719.cv_arg]], Union[RuleVariation_829.cv_arg, Tuple[Literal["QD4"], RuleVariation_829.cv_arg]], Union[RuleVariation_906.cv_arg, Tuple[Literal["QD2"], RuleVariation_906.cv_arg]], Union[RuleVariation_952.cv_arg, Tuple[Literal["QD1"], RuleVariation_952.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1036.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_733, 1), (Item_728, 1), (Item_725, 1), (Item_744, 1), (Item_739, 1), (Item_735, 1), (Item_752, 1), (Item_748, 1), (Item_746, 1), (Item_760, 1), (Item_758, 1), (Item_755, 1)]
    cv_items_dict = {"QA4": RuleVariation_717, "QA2": RuleVariation_826, "QA1": RuleVariation_902, "QB4": RuleVariation_951, "QB2": RuleVariation_46, "QB1": RuleVariation_421, "QC4": RuleVariation_528, "QC2": RuleVariation_632, "QC1": RuleVariation_719, "QD4": RuleVariation_829, "QD2": RuleVariation_906, "QD1": RuleVariation_952}

    @overload
    @classmethod
    def spec(cls, key : Literal["QA4"]) -> Type[RuleVariation_717]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA2"]) -> Type[RuleVariation_826]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA1"]) -> Type[RuleVariation_902]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB4"]) -> Type[RuleVariation_951]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB2"]) -> Type[RuleVariation_46]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB1"]) -> Type[RuleVariation_421]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC4"]) -> Type[RuleVariation_528]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC2"]) -> Type[RuleVariation_632]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC1"]) -> Type[RuleVariation_719]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD4"]) -> Type[RuleVariation_829]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD2"]) -> Type[RuleVariation_906]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD1"]) -> Type[RuleVariation_952]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["QA4"], Literal["QA2"], Literal["QA1"], Literal["QB4"], Literal["QB2"], Literal["QB1"], Literal["QC4"], Literal["QC2"], Literal["QC1"], Literal["QD4"], Literal["QD2"], Literal["QD1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["QA4"]) -> RuleVariation_717:
        ...
    @overload
    def get_item(self, key : Literal["QA2"]) -> RuleVariation_826:
        ...
    @overload
    def get_item(self, key : Literal["QA1"]) -> RuleVariation_902:
        ...
    @overload
    def get_item(self, key : Literal["QB4"]) -> RuleVariation_951:
        ...
    @overload
    def get_item(self, key : Literal["QB2"]) -> RuleVariation_46:
        ...
    @overload
    def get_item(self, key : Literal["QB1"]) -> RuleVariation_421:
        ...
    @overload
    def get_item(self, key : Literal["QC4"]) -> RuleVariation_528:
        ...
    @overload
    def get_item(self, key : Literal["QC2"]) -> RuleVariation_632:
        ...
    @overload
    def get_item(self, key : Literal["QC1"]) -> RuleVariation_719:
        ...
    @overload
    def get_item(self, key : Literal["QD4"]) -> RuleVariation_829:
        ...
    @overload
    def get_item(self, key : Literal["QD2"]) -> RuleVariation_906:
        ...
    @overload
    def get_item(self, key : Literal["QD1"]) -> RuleVariation_952:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1036.cv_arg") -> 'Variation_1036':
        return cls._create(arg) # type: ignore

class RuleVariation_1004(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1036.cv_arg
    cv_variation: TypeAlias = Variation_1036

    @classmethod
    def create(cls, arg : "RuleVariation_1004.cv_arg") -> "RuleVariation_1004":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1036:
        return self.arg # type: ignore

class NonSpare_234(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1004.cv_arg
    cv_name = "080"
    cv_title = "Mode-3/A Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_1004

    @classmethod
    def create(cls, arg : "NonSpare_234.cv_arg") -> "NonSpare_234":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1004:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1036:
        return self.rule.variation

class UapItem_234(UapItem):
    cv_non_spare: TypeAlias = NonSpare_234

class Item_12(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 2
    cv_bit_size = 2

class Variation_811(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 12
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_811.cv_arg") -> "Variation_811":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_781(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_811.cv_arg
    cv_variation: TypeAlias = Variation_811

    @classmethod
    def create(cls, arg : "RuleVariation_781.cv_arg") -> "RuleVariation_781":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_811:
        return self.arg # type: ignore

class NonSpare_1315(NonSpare):
    cv_arg: TypeAlias = RuleVariation_781.cv_arg
    cv_name = "MODEC"
    cv_title = "Mode-C Reply in Gray Notation"
    cv_rule: TypeAlias = RuleVariation_781

    @classmethod
    def create(cls, arg : "NonSpare_1315.cv_arg") -> "NonSpare_1315":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_781:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_811:
        return self.rule.variation

class Item_578(Item):
    cv_arg: TypeAlias = NonSpare_1315.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1315

    @classmethod
    def create(cls, arg : "Item_578.cv_arg") -> "Item_578":
        return cls._create(arg) # type: ignore

class Variation_855(Element):
    cv_arg: TypeAlias = RuleContent_226.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_226

    @classmethod
    def create(cls, arg: "Variation_855.cv_arg") -> "Variation_855":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_226:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_226:
        return self.rule.content

class RuleVariation_825(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_855.cv_arg
    cv_variation: TypeAlias = Variation_855

    @classmethod
    def create(cls, arg : "RuleVariation_825.cv_arg") -> "RuleVariation_825":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_855:
        return self.arg # type: ignore

class NonSpare_1494(NonSpare):
    cv_arg: TypeAlias = RuleVariation_825.cv_arg
    cv_name = "QA1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_825

    @classmethod
    def create(cls, arg : "NonSpare_1494.cv_arg") -> "NonSpare_1494":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_825:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_855:
        return self.rule.variation

class Item_724(Item):
    cv_arg: TypeAlias = NonSpare_1494.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1494

    @classmethod
    def create(cls, arg : "Item_724.cv_arg") -> "Item_724":
        return cls._create(arg) # type: ignore

class Variation_935(Element):
    cv_arg: TypeAlias = RuleContent_233.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_233

    @classmethod
    def create(cls, arg: "Variation_935.cv_arg") -> "Variation_935":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_233:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_233:
        return self.rule.content

class RuleVariation_905(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_935.cv_arg
    cv_variation: TypeAlias = Variation_935

    @classmethod
    def create(cls, arg : "RuleVariation_905.cv_arg") -> "RuleVariation_905":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_935:
        return self.arg # type: ignore

class NonSpare_1519(NonSpare):
    cv_arg: TypeAlias = RuleVariation_905.cv_arg
    cv_name = "QC2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_905

    @classmethod
    def create(cls, arg : "NonSpare_1519.cv_arg") -> "NonSpare_1519":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_905:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_935:
        return self.rule.variation

class Item_749(Item):
    cv_arg: TypeAlias = NonSpare_1519.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1519

    @classmethod
    def create(cls, arg : "Item_749.cv_arg") -> "Item_749":
        return cls._create(arg) # type: ignore

class Variation_979(Element):
    cv_arg: TypeAlias = RuleContent_227.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_227

    @classmethod
    def create(cls, arg: "Variation_979.cv_arg") -> "Variation_979":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_227:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_227:
        return self.rule.content

class RuleVariation_949(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_979.cv_arg
    cv_variation: TypeAlias = Variation_979

    @classmethod
    def create(cls, arg : "RuleVariation_949.cv_arg") -> "RuleVariation_949":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_979:
        return self.arg # type: ignore

class NonSpare_1499(NonSpare):
    cv_arg: TypeAlias = RuleVariation_949.cv_arg
    cv_name = "QA2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_949

    @classmethod
    def create(cls, arg : "NonSpare_1499.cv_arg") -> "NonSpare_1499":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_949:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_979:
        return self.rule.variation

class Item_729(Item):
    cv_arg: TypeAlias = NonSpare_1499.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1499

    @classmethod
    def create(cls, arg : "Item_729.cv_arg") -> "Item_729":
        return cls._create(arg) # type: ignore

class Variation_47(Element):
    cv_arg: TypeAlias = RuleContent_234.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_234

    @classmethod
    def create(cls, arg: "Variation_47.cv_arg") -> "Variation_47":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_234:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_234:
        return self.rule.content

class RuleVariation_47(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_47.cv_arg
    cv_variation: TypeAlias = Variation_47

    @classmethod
    def create(cls, arg : "RuleVariation_47.cv_arg") -> "RuleVariation_47":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_47:
        return self.arg # type: ignore

class NonSpare_1521(NonSpare):
    cv_arg: TypeAlias = RuleVariation_47.cv_arg
    cv_name = "QC4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_47

    @classmethod
    def create(cls, arg : "NonSpare_1521.cv_arg") -> "NonSpare_1521":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_47:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_47:
        return self.rule.variation

class Item_751(Item):
    cv_arg: TypeAlias = NonSpare_1521.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1521

    @classmethod
    def create(cls, arg : "Item_751.cv_arg") -> "Item_751":
        return cls._create(arg) # type: ignore

class Variation_431(Element):
    cv_arg: TypeAlias = RuleContent_228.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_228

    @classmethod
    def create(cls, arg: "Variation_431.cv_arg") -> "Variation_431":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_228:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_228:
        return self.rule.content

class RuleVariation_420(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_431.cv_arg
    cv_variation: TypeAlias = Variation_431

    @classmethod
    def create(cls, arg : "RuleVariation_420.cv_arg") -> "RuleVariation_420":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_431:
        return self.arg # type: ignore

class NonSpare_1501(NonSpare):
    cv_arg: TypeAlias = RuleVariation_420.cv_arg
    cv_name = "QA4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_420

    @classmethod
    def create(cls, arg : "NonSpare_1501.cv_arg") -> "NonSpare_1501":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_420:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_431:
        return self.rule.variation

class Item_731(Item):
    cv_arg: TypeAlias = NonSpare_1501.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1501

    @classmethod
    def create(cls, arg : "Item_731.cv_arg") -> "Item_731":
        return cls._create(arg) # type: ignore

class Variation_538(Element):
    cv_arg: TypeAlias = RuleContent_229.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_229

    @classmethod
    def create(cls, arg: "Variation_538.cv_arg") -> "Variation_538":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_229:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_229:
        return self.rule.content

class RuleVariation_527(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_538.cv_arg
    cv_variation: TypeAlias = Variation_538

    @classmethod
    def create(cls, arg : "RuleVariation_527.cv_arg") -> "RuleVariation_527":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_538:
        return self.arg # type: ignore

class NonSpare_1506(NonSpare):
    cv_arg: TypeAlias = RuleVariation_527.cv_arg
    cv_name = "QB1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_527

    @classmethod
    def create(cls, arg : "NonSpare_1506.cv_arg") -> "NonSpare_1506":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_527:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_538:
        return self.rule.variation

class Item_736(Item):
    cv_arg: TypeAlias = NonSpare_1506.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1506

    @classmethod
    def create(cls, arg : "Item_736.cv_arg") -> "Item_736":
        return cls._create(arg) # type: ignore

class Variation_644(Element):
    cv_arg: TypeAlias = RuleContent_235.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_235

    @classmethod
    def create(cls, arg: "Variation_644.cv_arg") -> "Variation_644":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_235:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_235:
        return self.rule.content

class RuleVariation_633(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_644.cv_arg
    cv_variation: TypeAlias = Variation_644

    @classmethod
    def create(cls, arg : "RuleVariation_633.cv_arg") -> "RuleVariation_633":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_644:
        return self.arg # type: ignore

class NonSpare_1524(NonSpare):
    cv_arg: TypeAlias = RuleVariation_633.cv_arg
    cv_name = "QD1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_633

    @classmethod
    def create(cls, arg : "NonSpare_1524.cv_arg") -> "NonSpare_1524":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_633:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_644:
        return self.rule.variation

class Item_754(Item):
    cv_arg: TypeAlias = NonSpare_1524.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1524

    @classmethod
    def create(cls, arg : "Item_754.cv_arg") -> "Item_754":
        return cls._create(arg) # type: ignore

class Variation_729(Element):
    cv_arg: TypeAlias = RuleContent_230.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_230

    @classmethod
    def create(cls, arg: "Variation_729.cv_arg") -> "Variation_729":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_230:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_230:
        return self.rule.content

class RuleVariation_718(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_729.cv_arg
    cv_variation: TypeAlias = Variation_729

    @classmethod
    def create(cls, arg : "RuleVariation_718.cv_arg") -> "RuleVariation_718":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_729:
        return self.arg # type: ignore

class NonSpare_1510(NonSpare):
    cv_arg: TypeAlias = RuleVariation_718.cv_arg
    cv_name = "QB2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_718

    @classmethod
    def create(cls, arg : "NonSpare_1510.cv_arg") -> "NonSpare_1510":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_718:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_729:
        return self.rule.variation

class Item_740(Item):
    cv_arg: TypeAlias = NonSpare_1510.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1510

    @classmethod
    def create(cls, arg : "Item_740.cv_arg") -> "Item_740":
        return cls._create(arg) # type: ignore

class Variation_858(Element):
    cv_arg: TypeAlias = RuleContent_236.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_236

    @classmethod
    def create(cls, arg: "Variation_858.cv_arg") -> "Variation_858":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_236:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_236:
        return self.rule.content

class RuleVariation_828(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_858.cv_arg
    cv_variation: TypeAlias = Variation_858

    @classmethod
    def create(cls, arg : "RuleVariation_828.cv_arg") -> "RuleVariation_828":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_858:
        return self.arg # type: ignore

class NonSpare_1527(NonSpare):
    cv_arg: TypeAlias = RuleVariation_828.cv_arg
    cv_name = "QD2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_828

    @classmethod
    def create(cls, arg : "NonSpare_1527.cv_arg") -> "NonSpare_1527":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_828:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_858:
        return self.rule.variation

class Item_757(Item):
    cv_arg: TypeAlias = NonSpare_1527.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1527

    @classmethod
    def create(cls, arg : "Item_757.cv_arg") -> "Item_757":
        return cls._create(arg) # type: ignore

class Variation_934(Element):
    cv_arg: TypeAlias = RuleContent_231.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_231

    @classmethod
    def create(cls, arg: "Variation_934.cv_arg") -> "Variation_934":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_231:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_231:
        return self.rule.content

class RuleVariation_904(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_934.cv_arg
    cv_variation: TypeAlias = Variation_934

    @classmethod
    def create(cls, arg : "RuleVariation_904.cv_arg") -> "RuleVariation_904":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_934:
        return self.arg # type: ignore

class NonSpare_1513(NonSpare):
    cv_arg: TypeAlias = RuleVariation_904.cv_arg
    cv_name = "QB4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_904

    @classmethod
    def create(cls, arg : "NonSpare_1513.cv_arg") -> "NonSpare_1513":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_904:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_934:
        return self.rule.variation

class Item_743(Item):
    cv_arg: TypeAlias = NonSpare_1513.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1513

    @classmethod
    def create(cls, arg : "Item_743.cv_arg") -> "Item_743":
        return cls._create(arg) # type: ignore

class Variation_983(Element):
    cv_arg: TypeAlias = RuleContent_237.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_237

    @classmethod
    def create(cls, arg: "Variation_983.cv_arg") -> "Variation_983":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_237:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_237:
        return self.rule.content

class RuleVariation_953(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_983.cv_arg
    cv_variation: TypeAlias = Variation_983

    @classmethod
    def create(cls, arg : "RuleVariation_953.cv_arg") -> "RuleVariation_953":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_983:
        return self.arg # type: ignore

class NonSpare_1531(NonSpare):
    cv_arg: TypeAlias = RuleVariation_953.cv_arg
    cv_name = "QD4"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_953

    @classmethod
    def create(cls, arg : "NonSpare_1531.cv_arg") -> "NonSpare_1531":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_953:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_983:
        return self.rule.variation

class Item_761(Item):
    cv_arg: TypeAlias = NonSpare_1531.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1531

    @classmethod
    def create(cls, arg : "Item_761.cv_arg") -> "Item_761":
        return cls._create(arg) # type: ignore

class Variation_1260(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], int, Union[RuleVariation_781.cv_arg, Tuple[Literal["MODEC"], RuleVariation_781.cv_arg]], int, Union[RuleVariation_719.cv_arg, Tuple[Literal["QC1"], RuleVariation_719.cv_arg]], Union[RuleVariation_825.cv_arg, Tuple[Literal["QA1"], RuleVariation_825.cv_arg]], Union[RuleVariation_905.cv_arg, Tuple[Literal["QC2"], RuleVariation_905.cv_arg]], Union[RuleVariation_949.cv_arg, Tuple[Literal["QA2"], RuleVariation_949.cv_arg]], Union[RuleVariation_47.cv_arg, Tuple[Literal["QC4"], RuleVariation_47.cv_arg]], Union[RuleVariation_420.cv_arg, Tuple[Literal["QA4"], RuleVariation_420.cv_arg]], Union[RuleVariation_527.cv_arg, Tuple[Literal["QB1"], RuleVariation_527.cv_arg]], Union[RuleVariation_633.cv_arg, Tuple[Literal["QD1"], RuleVariation_633.cv_arg]], Union[RuleVariation_718.cv_arg, Tuple[Literal["QB2"], RuleVariation_718.cv_arg]], Union[RuleVariation_828.cv_arg, Tuple[Literal["QD2"], RuleVariation_828.cv_arg]], Union[RuleVariation_904.cv_arg, Tuple[Literal["QB4"], RuleVariation_904.cv_arg]], Union[RuleVariation_953.cv_arg, Tuple[Literal["QD4"], RuleVariation_953.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1260.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1106, 1), (Item_357, 1), (Item_12, 2), (Item_578, 12), (Item_3, 4), (Item_746, 1), (Item_724, 1), (Item_749, 1), (Item_729, 1), (Item_751, 1), (Item_731, 1), (Item_736, 1), (Item_754, 1), (Item_740, 1), (Item_757, 1), (Item_743, 1), (Item_761, 1)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "MODEC": RuleVariation_781, "QC1": RuleVariation_719, "QA1": RuleVariation_825, "QC2": RuleVariation_905, "QA2": RuleVariation_949, "QC4": RuleVariation_47, "QA4": RuleVariation_420, "QB1": RuleVariation_527, "QD1": RuleVariation_633, "QB2": RuleVariation_718, "QD2": RuleVariation_828, "QB4": RuleVariation_904, "QD4": RuleVariation_953}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> Type[RuleVariation_15]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> Type[RuleVariation_396]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODEC"]) -> Type[RuleVariation_781]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC1"]) -> Type[RuleVariation_719]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA1"]) -> Type[RuleVariation_825]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC2"]) -> Type[RuleVariation_905]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA2"]) -> Type[RuleVariation_949]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QC4"]) -> Type[RuleVariation_47]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QA4"]) -> Type[RuleVariation_420]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB1"]) -> Type[RuleVariation_527]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD1"]) -> Type[RuleVariation_633]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB2"]) -> Type[RuleVariation_718]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD2"]) -> Type[RuleVariation_828]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QB4"]) -> Type[RuleVariation_904]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["QD4"]) -> Type[RuleVariation_953]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["MODEC"], Literal["QC1"], Literal["QA1"], Literal["QC2"], Literal["QA2"], Literal["QC4"], Literal["QA4"], Literal["QB1"], Literal["QD1"], Literal["QB2"], Literal["QD2"], Literal["QB4"], Literal["QD4"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["MODEC"]) -> RuleVariation_781:
        ...
    @overload
    def get_item(self, key : Literal["QC1"]) -> RuleVariation_719:
        ...
    @overload
    def get_item(self, key : Literal["QA1"]) -> RuleVariation_825:
        ...
    @overload
    def get_item(self, key : Literal["QC2"]) -> RuleVariation_905:
        ...
    @overload
    def get_item(self, key : Literal["QA2"]) -> RuleVariation_949:
        ...
    @overload
    def get_item(self, key : Literal["QC4"]) -> RuleVariation_47:
        ...
    @overload
    def get_item(self, key : Literal["QA4"]) -> RuleVariation_420:
        ...
    @overload
    def get_item(self, key : Literal["QB1"]) -> RuleVariation_527:
        ...
    @overload
    def get_item(self, key : Literal["QD1"]) -> RuleVariation_633:
        ...
    @overload
    def get_item(self, key : Literal["QB2"]) -> RuleVariation_718:
        ...
    @overload
    def get_item(self, key : Literal["QD2"]) -> RuleVariation_828:
        ...
    @overload
    def get_item(self, key : Literal["QB4"]) -> RuleVariation_904:
        ...
    @overload
    def get_item(self, key : Literal["QD4"]) -> RuleVariation_953:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1260.cv_arg") -> 'Variation_1260':
        return cls._create(arg) # type: ignore

class RuleVariation_1189(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1260.cv_arg
    cv_variation: TypeAlias = Variation_1260

    @classmethod
    def create(cls, arg : "RuleVariation_1189.cv_arg") -> "RuleVariation_1189":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1260:
        return self.arg # type: ignore

class NonSpare_275(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1189.cv_arg
    cv_name = "100"
    cv_title = "Mode-C Code and Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_1189

    @classmethod
    def create(cls, arg : "NonSpare_275.cv_arg") -> "NonSpare_275":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1189:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1260:
        return self.rule.variation

class UapItem_275(UapItem):
    cv_non_spare: TypeAlias = NonSpare_275

class NonSpare_189(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1004.cv_arg
    cv_name = "060"
    cv_title = "Mode-2 Code Confidence Indicator"
    cv_rule: TypeAlias = RuleVariation_1004

    @classmethod
    def create(cls, arg : "NonSpare_189.cv_arg") -> "NonSpare_189":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1004:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1036:
        return self.rule.variation

class UapItem_189(UapItem):
    cv_non_spare: TypeAlias = NonSpare_189

class Content_378(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No warning nor error condition", 1: "Garbled reply", 2: "Reflection", 3: "Sidelobe reply", 4: "Split plot", 5: "Second time around reply", 6: "Angels", 7: "Terrestrial vehicles", 64: "Possible wrong code in Mode-3/A", 65: "Possible wrong altitude information, transmitted when the Code C credibility check fails together with the Mode-C code in binary notation", 66: "Possible phantom MSSR plot", 80: "Fixed PSR plot", 81: "Slow PSR plot", 82: "Low quality PSR plot"}

class RuleContent_378(RuleContentContextFree):
    cv_arg: TypeAlias = Content_378.cv_arg
    cv_content: TypeAlias = Content_378

    @property
    def content(self) -> Content_378:
        return self._get_content() # type: ignore

class Variation_152(Element):
    cv_arg: TypeAlias = RuleContent_378.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_378

    @classmethod
    def create(cls, arg: "Variation_152.cv_arg") -> "Variation_152":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_378:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_378:
        return self.rule.content

class Variation_1464(Repetitive):
    cv_arg: TypeAlias = List[Variation_152.cv_arg]
    cv_rep_bytes = None
    cv_variation: TypeAlias = Variation_152

    @classmethod
    def create(cls, arg: "Variation_1464.cv_arg") -> 'Variation_1464':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_152]:
        return self._get_list() # type: ignore

class RuleVariation_1385(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1464.cv_arg
    cv_variation: TypeAlias = Variation_1464

    @classmethod
    def create(cls, arg : "RuleVariation_1385.cv_arg") -> "RuleVariation_1385":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1464:
        return self.arg # type: ignore

class NonSpare_117(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1385.cv_arg
    cv_name = "030"
    cv_title = "Warning/Error Conditions"
    cv_rule: TypeAlias = RuleVariation_1385

    @classmethod
    def create(cls, arg : "NonSpare_117.cv_arg") -> "NonSpare_117":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1464:
        return self.rule.variation

class UapItem_117(UapItem):
    cv_non_spare: TypeAlias = NonSpare_117

class Content_168(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-3/A reply"}

class RuleContent_168(RuleContentContextFree):
    cv_arg: TypeAlias = Content_168.cv_arg
    cv_content: TypeAlias = Content_168

    @property
    def content(self) -> Content_168:
        return self._get_content() # type: ignore

class Variation_37(Element):
    cv_arg: TypeAlias = RuleContent_168.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_168

    @classmethod
    def create(cls, arg: "Variation_37.cv_arg") -> "Variation_37":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_168:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_168:
        return self.rule.content

class RuleVariation_37(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_37.cv_arg
    cv_variation: TypeAlias = Variation_37

    @classmethod
    def create(cls, arg : "RuleVariation_37.cv_arg") -> "RuleVariation_37":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_37:
        return self.arg # type: ignore

class NonSpare_2124(NonSpare):
    cv_arg: TypeAlias = RuleVariation_37.cv_arg
    cv_name = "XA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_37

    @classmethod
    def create(cls, arg : "NonSpare_2124.cv_arg") -> "NonSpare_2124":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_37:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_37:
        return self.rule.variation

class Item_1221(Item):
    cv_arg: TypeAlias = NonSpare_2124.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2124

    @classmethod
    def create(cls, arg : "Item_1221.cv_arg") -> "Item_1221":
        return cls._create(arg) # type: ignore

class Item_7(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 1
    cv_bit_size = 1

class Content_169(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-C reply"}

class RuleContent_169(RuleContentContextFree):
    cv_arg: TypeAlias = Content_169.cv_arg
    cv_content: TypeAlias = Content_169

    @property
    def content(self) -> Content_169:
        return self._get_content() # type: ignore

class Variation_526(Element):
    cv_arg: TypeAlias = RuleContent_169.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_169

    @classmethod
    def create(cls, arg: "Variation_526.cv_arg") -> "Variation_526":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_169:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_169:
        return self.rule.content

class RuleVariation_515(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_526.cv_arg
    cv_variation: TypeAlias = Variation_526

    @classmethod
    def create(cls, arg : "RuleVariation_515.cv_arg") -> "RuleVariation_515":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_526:
        return self.arg # type: ignore

class NonSpare_2125(NonSpare):
    cv_arg: TypeAlias = RuleVariation_515.cv_arg
    cv_name = "XC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_515

    @classmethod
    def create(cls, arg : "NonSpare_2125.cv_arg") -> "NonSpare_2125":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_515:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_526:
        return self.rule.variation

class Item_1222(Item):
    cv_arg: TypeAlias = NonSpare_2125.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2125

    @classmethod
    def create(cls, arg : "Item_1222.cv_arg") -> "Item_1222":
        return cls._create(arg) # type: ignore

class Item_17(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 2

class Content_167(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "X-pulse received in Mode-2 reply"}

class RuleContent_167(RuleContentContextFree):
    cv_arg: TypeAlias = Content_167.cv_arg
    cv_content: TypeAlias = Content_167

    @property
    def content(self) -> Content_167:
        return self._get_content() # type: ignore

class Variation_845(Element):
    cv_arg: TypeAlias = RuleContent_167.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_167

    @classmethod
    def create(cls, arg: "Variation_845.cv_arg") -> "Variation_845":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_167:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_167:
        return self.rule.content

class RuleVariation_815(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_845.cv_arg
    cv_variation: TypeAlias = Variation_845

    @classmethod
    def create(cls, arg : "RuleVariation_815.cv_arg") -> "RuleVariation_815":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_845:
        return self.arg # type: ignore

class NonSpare_2118(NonSpare):
    cv_arg: TypeAlias = RuleVariation_815.cv_arg
    cv_name = "X2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_815

    @classmethod
    def create(cls, arg : "NonSpare_2118.cv_arg") -> "NonSpare_2118":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_815:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_845:
        return self.rule.variation

class Item_1215(Item):
    cv_arg: TypeAlias = NonSpare_2118.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2118

    @classmethod
    def create(cls, arg : "Item_1215.cv_arg") -> "Item_1215":
        return cls._create(arg) # type: ignore

class Item_27(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 6
    cv_bit_size = 2

class Variation_1327(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_37.cv_arg, Tuple[Literal["XA"], RuleVariation_37.cv_arg]], int, Union[RuleVariation_515.cv_arg, Tuple[Literal["XC"], RuleVariation_515.cv_arg]], int, Union[RuleVariation_815.cv_arg, Tuple[Literal["X2"], RuleVariation_815.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1327.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1221, 1), (Item_7, 1), (Item_1222, 1), (Item_17, 2), (Item_1215, 1), (Item_27, 2)]
    cv_items_dict = {"XA": RuleVariation_37, "XC": RuleVariation_515, "X2": RuleVariation_815}

    @overload
    @classmethod
    def spec(cls, key : Literal["XA"]) -> Type[RuleVariation_37]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["XC"]) -> Type[RuleVariation_515]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["X2"]) -> Type[RuleVariation_815]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["XA"], Literal["XC"], Literal["X2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["XA"]) -> RuleVariation_37:
        ...
    @overload
    def get_item(self, key : Literal["XC"]) -> RuleVariation_515:
        ...
    @overload
    def get_item(self, key : Literal["X2"]) -> RuleVariation_815:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1327.cv_arg") -> 'Variation_1327':
        return cls._create(arg) # type: ignore

class RuleVariation_1251(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1327.cv_arg
    cv_variation: TypeAlias = Variation_1327

    @classmethod
    def create(cls, arg : "RuleVariation_1251.cv_arg") -> "RuleVariation_1251":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1327:
        return self.arg # type: ignore

class NonSpare_347(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1251.cv_arg
    cv_name = "150"
    cv_title = "Presence of X-Pulse"
    cv_rule: TypeAlias = RuleVariation_1251

    @classmethod
    def create(cls, arg : "NonSpare_347.cv_arg") -> "NonSpare_347":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1251:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1327:
        return self.rule.variation

class UapItem_347(UapItem):
    cv_non_spare: TypeAlias = NonSpare_347

class UapItem_551(UapItemSpare):
    pass

class Variation_1473(Explicit):
    cv_arg: TypeAlias = bytes
    cv_explicit_type: TypeAlias = SpecialPurpose

    @classmethod
    def create(cls, arg: "Variation_1473.cv_arg") -> 'Variation_1473':
        return cls._create(arg) # type: ignore

class RuleVariation_1394(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1473.cv_arg
    cv_variation: TypeAlias = Variation_1473

    @classmethod
    def create(cls, arg : "RuleVariation_1394.cv_arg") -> "RuleVariation_1394":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1473:
        return self.arg # type: ignore

class NonSpare_1739(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1394.cv_arg
    cv_name = "SP"
    cv_title = "Special Purpose Field"
    cv_rule: TypeAlias = RuleVariation_1394

    @classmethod
    def create(cls, arg : "NonSpare_1739.cv_arg") -> "NonSpare_1739":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1394:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1473:
        return self.rule.variation

class UapItem_550(UapItem):
    cv_non_spare: TypeAlias = NonSpare_1739

class UapItem_552(UapItemRFS):
    pass

class Record_18(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "020": NonSpare_87.cv_arg,
        "040": NonSpare_138.cv_arg,
        "070": NonSpare_214.cv_arg,
        "090": NonSpare_254.cv_arg,
        "130": NonSpare_313.cv_arg,
        "141": NonSpare_338.cv_arg,
        "050": NonSpare_174.cv_arg,
        "120": NonSpare_301.cv_arg,
        "131": NonSpare_317.cv_arg,
        "080": NonSpare_234.cv_arg,
        "100": NonSpare_275.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "150": NonSpare_347.cv_arg,
        "SP": NonSpare_1739.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_36.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["070"], NonSpare_214.cv_arg],
        Tuple[Literal["090"], NonSpare_254.cv_arg],
        Tuple[Literal["130"], NonSpare_313.cv_arg],
        Tuple[Literal["141"], NonSpare_338.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["120"], NonSpare_301.cv_arg],
        Tuple[Literal["131"], NonSpare_317.cv_arg],
        Tuple[Literal["080"], NonSpare_234.cv_arg],
        Tuple[Literal["100"], NonSpare_275.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["150"], NonSpare_347.cv_arg],
        Tuple[Literal["SP"], NonSpare_1739.cv_arg],
    ]
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_36, UapItem_87, UapItem_138, UapItem_214, UapItem_254, UapItem_313, UapItem_338, UapItem_174, UapItem_301, UapItem_317, UapItem_234, UapItem_275, UapItem_189, UapItem_117, UapItem_347, UapItem_551, UapItem_551, UapItem_551, UapItem_551, UapItem_550, UapItem_552]
    cv_items_dict = {"010": NonSpare_36, "020": NonSpare_87, "040": NonSpare_138, "070": NonSpare_214, "090": NonSpare_254, "130": NonSpare_313, "141": NonSpare_338, "050": NonSpare_174, "120": NonSpare_301, "131": NonSpare_317, "080": NonSpare_234, "100": NonSpare_275, "060": NonSpare_189, "030": NonSpare_117, "150": NonSpare_347, "SP": NonSpare_1739}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_36]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_87]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_138]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_214]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_254]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> Type[NonSpare_313]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> Type[NonSpare_338]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> Type[NonSpare_174]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> Type[NonSpare_301]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> Type[NonSpare_317]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> Type[NonSpare_234]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_275]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_189]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_117]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> Type[NonSpare_347]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["040"], Literal["070"], Literal["090"], Literal["130"], Literal["141"], Literal["050"], Literal["120"], Literal["131"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["150"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_214]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_254]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_313]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_338]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_301]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_317]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_234]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_275]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_347]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_214.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_254.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_313.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_338.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_301.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_317.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_234.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_275.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_347.cv_arg) -> 'Record_18':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_18':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_18':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_18':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_36]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_214]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_254]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_313]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_338]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_301]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_317]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_234]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_275]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_347]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1739]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_18.cv_arg", rfs: Optional[List["Record_18.cv_union"]] = None) -> 'Record_18':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_18", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Variation_253(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_253.cv_arg") -> "Variation_253":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_246(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_253.cv_arg
    cv_variation: TypeAlias = Variation_253

    @classmethod
    def create(cls, arg : "RuleVariation_246.cv_arg") -> "RuleVariation_246":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_253:
        return self.arg # type: ignore

class NonSpare_367(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "161"
    cv_title = "Track Plot Number"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_367.cv_arg") -> "NonSpare_367":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_367(UapItem):
    cv_non_spare: TypeAlias = NonSpare_367

class Content_675(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.5625e-2
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_675(RuleContentContextFree):
    cv_arg: TypeAlias = Content_675.cv_arg
    cv_content: TypeAlias = Content_675

    @property
    def content(self) -> Content_675:
        return self._get_content() # type: ignore

class Variation_284(Element):
    cv_arg: TypeAlias = RuleContent_675.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_675

    @classmethod
    def create(cls, arg: "Variation_284.cv_arg") -> "Variation_284":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_675:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_675:
        return self.rule.content

class RuleVariation_277(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_284.cv_arg
    cv_variation: TypeAlias = Variation_284

    @classmethod
    def create(cls, arg : "RuleVariation_277.cv_arg") -> "RuleVariation_277":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_284:
        return self.arg # type: ignore

class NonSpare_2110(NonSpare):
    cv_arg: TypeAlias = RuleVariation_277.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_277

    @classmethod
    def create(cls, arg : "NonSpare_2110.cv_arg") -> "NonSpare_2110":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_277:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_284:
        return self.rule.variation

class Item_1207(Item):
    cv_arg: TypeAlias = NonSpare_2110.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2110

    @classmethod
    def create(cls, arg : "Item_1207.cv_arg") -> "Item_1207":
        return cls._create(arg) # type: ignore

class NonSpare_2164(NonSpare):
    cv_arg: TypeAlias = RuleVariation_277.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_277

    @classmethod
    def create(cls, arg : "NonSpare_2164.cv_arg") -> "NonSpare_2164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_277:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_284:
        return self.rule.variation

class Item_1258(Item):
    cv_arg: TypeAlias = NonSpare_2164.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2164

    @classmethod
    def create(cls, arg : "Item_1258.cv_arg") -> "Item_1258":
        return cls._create(arg) # type: ignore

class Variation_1320(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_277.cv_arg, Tuple[Literal["X"], RuleVariation_277.cv_arg]], Union[RuleVariation_277.cv_arg, Tuple[Literal["Y"], RuleVariation_277.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1320.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1207, 16), (Item_1258, 16)]
    cv_items_dict = {"X": RuleVariation_277, "Y": RuleVariation_277}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> Type[RuleVariation_277]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> Type[RuleVariation_277]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_277:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_277:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1320.cv_arg") -> 'Variation_1320':
        return cls._create(arg) # type: ignore

class RuleVariation_1247(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1320.cv_arg
    cv_variation: TypeAlias = Variation_1320

    @classmethod
    def create(cls, arg : "RuleVariation_1247.cv_arg") -> "RuleVariation_1247":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1320:
        return self.arg # type: ignore

class NonSpare_159(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1247.cv_arg
    cv_name = "042"
    cv_title = "Calculated Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1247

    @classmethod
    def create(cls, arg : "NonSpare_159.cv_arg") -> "NonSpare_159":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1247:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1320:
        return self.rule.variation

class UapItem_159(UapItem):
    cv_non_spare: TypeAlias = NonSpare_159

class Content_779(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 6.103515625e-5
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_778(RuleContentContextFree):
    cv_arg: TypeAlias = Content_779.cv_arg
    cv_content: TypeAlias = Content_779

    @property
    def content(self) -> Content_779:
        return self._get_content() # type: ignore

class Variation_338(Element):
    cv_arg: TypeAlias = RuleContent_778.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_778

    @classmethod
    def create(cls, arg: "Variation_338.cv_arg") -> "Variation_338":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_778:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_779:
        return self.rule.content

class RuleVariation_331(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_338.cv_arg
    cv_variation: TypeAlias = Variation_338

    @classmethod
    def create(cls, arg : "RuleVariation_331.cv_arg") -> "RuleVariation_331":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_338:
        return self.arg # type: ignore

class NonSpare_1046(NonSpare):
    cv_arg: TypeAlias = RuleVariation_331.cv_arg
    cv_name = "GSP"
    cv_title = "Calculated Groundspeed"
    cv_rule: TypeAlias = RuleVariation_331

    @classmethod
    def create(cls, arg : "NonSpare_1046.cv_arg") -> "NonSpare_1046":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_331:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_338:
        return self.rule.variation

class Item_377(Item):
    cv_arg: TypeAlias = NonSpare_1046.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1046

    @classmethod
    def create(cls, arg : "Item_377.cv_arg") -> "Item_377":
        return cls._create(arg) # type: ignore

class NonSpare_1066(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "HDG"
    cv_title = "Calculated Heading"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1066.cv_arg") -> "NonSpare_1066":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_391(Item):
    cv_arg: TypeAlias = NonSpare_1066.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1066

    @classmethod
    def create(cls, arg : "Item_391.cv_arg") -> "Item_391":
        return cls._create(arg) # type: ignore

class Variation_1119(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_331.cv_arg, Tuple[Literal["GSP"], RuleVariation_331.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["HDG"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1119.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_377, 16), (Item_391, 16)]
    cv_items_dict = {"GSP": RuleVariation_331, "HDG": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["GSP"]) -> Type[RuleVariation_331]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["HDG"]) -> Type[RuleVariation_336]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["GSP"], Literal["HDG"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["GSP"]) -> RuleVariation_331:
        ...
    @overload
    def get_item(self, key : Literal["HDG"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1119.cv_arg") -> 'Variation_1119':
        return cls._create(arg) # type: ignore

class RuleVariation_1077(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1119.cv_arg
    cv_variation: TypeAlias = Variation_1119

    @classmethod
    def create(cls, arg : "RuleVariation_1077.cv_arg") -> "RuleVariation_1077":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1119:
        return self.arg # type: ignore

class NonSpare_390(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1077.cv_arg
    cv_name = "200"
    cv_title = "Calculated Track Velocity in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1077

    @classmethod
    def create(cls, arg : "NonSpare_390.cv_arg") -> "NonSpare_390":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1077:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1119:
        return self.rule.variation

class UapItem_390(UapItem):
    cv_non_spare: TypeAlias = NonSpare_390

class Content_62(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed Track", 1: "Track in initialisation phase"}

class RuleContent_62(RuleContentContextFree):
    cv_arg: TypeAlias = Content_62.cv_arg
    cv_content: TypeAlias = Content_62

    @property
    def content(self) -> Content_62:
        return self._get_content() # type: ignore

class Variation_17(Element):
    cv_arg: TypeAlias = RuleContent_62.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_62

    @classmethod
    def create(cls, arg: "Variation_17.cv_arg") -> "Variation_17":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_62:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_62:
        return self.rule.content

class RuleVariation_17(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_17.cv_arg
    cv_variation: TypeAlias = Variation_17

    @classmethod
    def create(cls, arg : "RuleVariation_17.cv_arg") -> "RuleVariation_17":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_17:
        return self.arg # type: ignore

class Content_432(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Primary track", 1: "SSR/Combined track"}

class RuleContent_432(RuleContentContextFree):
    cv_arg: TypeAlias = Content_432.cv_arg
    cv_content: TypeAlias = Content_432

    @property
    def content(self) -> Content_432:
        return self._get_content() # type: ignore

class Variation_450(Element):
    cv_arg: TypeAlias = RuleContent_432.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_432

    @classmethod
    def create(cls, arg: "Variation_450.cv_arg") -> "Variation_450":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_432:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_432:
        return self.rule.content

class RuleVariation_439(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_450.cv_arg
    cv_variation: TypeAlias = Variation_450

    @classmethod
    def create(cls, arg : "RuleVariation_439.cv_arg") -> "RuleVariation_439":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_450:
        return self.arg # type: ignore

class Content_85(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Aircraft manoeuvring"}

class RuleContent_85(RuleContentContextFree):
    cv_arg: TypeAlias = Content_85.cv_arg
    cv_content: TypeAlias = Content_85

    @property
    def content(self) -> Content_85:
        return self._get_content() # type: ignore

class Variation_516(Element):
    cv_arg: TypeAlias = RuleContent_85.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_85

    @classmethod
    def create(cls, arg: "Variation_516.cv_arg") -> "Variation_516":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_85:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_85:
        return self.rule.content

class RuleVariation_505(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_516.cv_arg
    cv_variation: TypeAlias = Variation_516

    @classmethod
    def create(cls, arg : "RuleVariation_505.cv_arg") -> "RuleVariation_505":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_516:
        return self.arg # type: ignore

class Content_95(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Doubtful plot to track association"}

class RuleContent_95(RuleContentContextFree):
    cv_arg: TypeAlias = Content_95.cv_arg
    cv_content: TypeAlias = Content_95

    @property
    def content(self) -> Content_95:
        return self._get_content() # type: ignore

class Variation_622(Element):
    cv_arg: TypeAlias = RuleContent_95.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_95

    @classmethod
    def create(cls, arg: "Variation_622.cv_arg") -> "Variation_622":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_95:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_95:
        return self.rule.content

class RuleVariation_611(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_622.cv_arg
    cv_variation: TypeAlias = Variation_622

    @classmethod
    def create(cls, arg : "RuleVariation_611.cv_arg") -> "RuleVariation_611":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_622:
        return self.arg # type: ignore

class Content_434(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "RDP Chain 1", 1: "RDP Chain 2"}

class RuleContent_434(RuleContentContextFree):
    cv_arg: TypeAlias = Content_434.cv_arg
    cv_content: TypeAlias = Content_434

    @property
    def content(self) -> Content_434:
        return self._get_content() # type: ignore

class Variation_748(Element):
    cv_arg: TypeAlias = RuleContent_434.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_434

    @classmethod
    def create(cls, arg: "Variation_748.cv_arg") -> "Variation_748":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_434:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_434:
        return self.rule.content

class RuleVariation_737(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_748.cv_arg
    cv_variation: TypeAlias = Variation_748

    @classmethod
    def create(cls, arg : "RuleVariation_737.cv_arg") -> "RuleVariation_737":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_748:
        return self.arg # type: ignore

class Content_100(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Ghost track"}

class RuleContent_100(RuleContentContextFree):
    cv_arg: TypeAlias = Content_100.cv_arg
    cv_content: TypeAlias = Content_100

    @property
    def content(self) -> Content_100:
        return self._get_content() # type: ignore

class Variation_915(Element):
    cv_arg: TypeAlias = RuleContent_100.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_100

    @classmethod
    def create(cls, arg: "Variation_915.cv_arg") -> "Variation_915":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_100:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_100:
        return self.rule.content

class RuleVariation_885(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_915.cv_arg
    cv_variation: TypeAlias = Variation_915

    @classmethod
    def create(cls, arg : "RuleVariation_885.cv_arg") -> "RuleVariation_885":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_915:
        return self.arg # type: ignore

class Content_113(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Last report for a track"}

class RuleContent_113(RuleContentContextFree):
    cv_arg: TypeAlias = Content_113.cv_arg
    cv_content: TypeAlias = Content_113

    @property
    def content(self) -> Content_113:
        return self._get_content() # type: ignore

class Variation_31(Element):
    cv_arg: TypeAlias = RuleContent_113.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_113

    @classmethod
    def create(cls, arg: "Variation_31.cv_arg") -> "Variation_31":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_113:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_113:
        return self.rule.content

class RuleVariation_31(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_31.cv_arg
    cv_variation: TypeAlias = Variation_31

    @classmethod
    def create(cls, arg : "RuleVariation_31.cv_arg") -> "RuleVariation_31":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_31:
        return self.arg # type: ignore

class NonSpare_795(NonSpare):
    cv_arg: TypeAlias = RuleVariation_17.cv_arg
    cv_name = "CON"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_17

    @classmethod
    def create(cls, arg : "NonSpare_795.cv_arg") -> "NonSpare_795":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_17:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_17:
        return self.rule.variation

class Item_191(Item):
    cv_arg: TypeAlias = NonSpare_795.cv_arg
    cv_non_spare: TypeAlias = NonSpare_795

    @classmethod
    def create(cls, arg : "Item_191.cv_arg") -> "Item_191":
        return cls._create(arg) # type: ignore

class NonSpare_1550(NonSpare):
    cv_arg: TypeAlias = RuleVariation_439.cv_arg
    cv_name = "RAD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_439

    @classmethod
    def create(cls, arg : "NonSpare_1550.cv_arg") -> "NonSpare_1550":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_439:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_450:
        return self.rule.variation

class Item_777(Item):
    cv_arg: TypeAlias = NonSpare_1550.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1550

    @classmethod
    def create(cls, arg : "Item_777.cv_arg") -> "Item_777":
        return cls._create(arg) # type: ignore

class NonSpare_1234(NonSpare):
    cv_arg: TypeAlias = RuleVariation_505.cv_arg
    cv_name = "MAN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_505

    @classmethod
    def create(cls, arg : "NonSpare_1234.cv_arg") -> "NonSpare_1234":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_505:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_516:
        return self.rule.variation

class Item_530(Item):
    cv_arg: TypeAlias = NonSpare_1234.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1234

    @classmethod
    def create(cls, arg : "Item_530.cv_arg") -> "Item_530":
        return cls._create(arg) # type: ignore

class NonSpare_899(NonSpare):
    cv_arg: TypeAlias = RuleVariation_611.cv_arg
    cv_name = "DOU"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_611

    @classmethod
    def create(cls, arg : "NonSpare_899.cv_arg") -> "NonSpare_899":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_611:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_622:
        return self.rule.variation

class Item_271(Item):
    cv_arg: TypeAlias = NonSpare_899.cv_arg
    cv_non_spare: TypeAlias = NonSpare_899

    @classmethod
    def create(cls, arg : "Item_271.cv_arg") -> "Item_271":
        return cls._create(arg) # type: ignore

class NonSpare_1566(NonSpare):
    cv_arg: TypeAlias = RuleVariation_737.cv_arg
    cv_name = "RDPC"
    cv_title = "Radar Data Processing Chain"
    cv_rule: TypeAlias = RuleVariation_737

    @classmethod
    def create(cls, arg : "NonSpare_1566.cv_arg") -> "NonSpare_1566":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_737:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_748:
        return self.rule.variation

class Item_791(Item):
    cv_arg: TypeAlias = NonSpare_1566.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1566

    @classmethod
    def create(cls, arg : "Item_791.cv_arg") -> "Item_791":
        return cls._create(arg) # type: ignore

class Item_23(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 5
    cv_bit_size = 1

class NonSpare_1041(NonSpare):
    cv_arg: TypeAlias = RuleVariation_885.cv_arg
    cv_name = "GHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_885

    @classmethod
    def create(cls, arg : "NonSpare_1041.cv_arg") -> "NonSpare_1041":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_885:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_915:
        return self.rule.variation

class Item_373(Item):
    cv_arg: TypeAlias = NonSpare_1041.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1041

    @classmethod
    def create(cls, arg : "Item_373.cv_arg") -> "Item_373":
        return cls._create(arg) # type: ignore

class NonSpare_1921(NonSpare):
    cv_arg: TypeAlias = RuleVariation_31.cv_arg
    cv_name = "TRE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_31

    @classmethod
    def create(cls, arg : "NonSpare_1921.cv_arg") -> "NonSpare_1921":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_31:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_31:
        return self.rule.variation

class Item_1039(Item):
    cv_arg: TypeAlias = NonSpare_1921.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1921

    @classmethod
    def create(cls, arg : "Item_1039.cv_arg") -> "Item_1039":
        return cls._create(arg) # type: ignore

class Item_9(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 1
    cv_bit_size = 6

class Variation_1364(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_17.cv_arg, Tuple[Literal["CON"], RuleVariation_17.cv_arg]], Union[RuleVariation_439.cv_arg, Tuple[Literal["RAD"], RuleVariation_439.cv_arg]], Union[RuleVariation_505.cv_arg, Tuple[Literal["MAN"], RuleVariation_505.cv_arg]], Union[RuleVariation_611.cv_arg, Tuple[Literal["DOU"], RuleVariation_611.cv_arg]], Union[RuleVariation_737.cv_arg, Tuple[Literal["RDPC"], RuleVariation_737.cv_arg]], int, Union[RuleVariation_885.cv_arg, Tuple[Literal["GHO"], RuleVariation_885.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_31.cv_arg, Tuple[Literal["TRE"], RuleVariation_31.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1364.cv_arg_group_1"],
        Tuple["Variation_1364.cv_arg_group_1", "Variation_1364.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_191, 1), (Item_777, 1), (Item_530, 1), (Item_271, 1), (Item_791, 1), (Item_23, 1), (Item_373, 1), None], [(Item_1039, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1364.cv_arg") -> 'Variation_1364':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["CON"]) -> RuleVariation_17:
        ...
    @overload
    def get_item(self, key : Literal["RAD"]) -> RuleVariation_439:
        ...
    @overload
    def get_item(self, key : Literal["MAN"]) -> RuleVariation_505:
        ...
    @overload
    def get_item(self, key : Literal["DOU"]) -> RuleVariation_611:
        ...
    @overload
    def get_item(self, key : Literal["RDPC"]) -> RuleVariation_737:
        ...
    @overload
    def get_item(self, key : Literal["GHO"]) -> RuleVariation_885:
        ...
    @overload
    def get_item(self, key : Literal["TRE"]) -> Optional[RuleVariation_31]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1285(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1364.cv_arg
    cv_variation: TypeAlias = Variation_1364

    @classmethod
    def create(cls, arg : "RuleVariation_1285.cv_arg") -> "RuleVariation_1285":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1364:
        return self.arg # type: ignore

class NonSpare_379(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1285.cv_arg
    cv_name = "170"
    cv_title = "Track Status"
    cv_rule: TypeAlias = RuleVariation_1285

    @classmethod
    def create(cls, arg : "NonSpare_379.cv_arg") -> "NonSpare_379":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1285:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1364:
        return self.rule.variation

class UapItem_379(UapItem):
    cv_non_spare: TypeAlias = NonSpare_379

class NonSpare_418(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "210"
    cv_title = "Track Quality"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_418.cv_arg") -> "NonSpare_418":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1463:
        return self.rule.variation

class UapItem_418(UapItem):
    cv_non_spare: TypeAlias = NonSpare_418

class Record_19(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_36.cv_arg,
        "020": NonSpare_87.cv_arg,
        "161": NonSpare_367.cv_arg,
        "040": NonSpare_138.cv_arg,
        "042": NonSpare_159.cv_arg,
        "200": NonSpare_390.cv_arg,
        "070": NonSpare_214.cv_arg,
        "090": NonSpare_254.cv_arg,
        "141": NonSpare_338.cv_arg,
        "130": NonSpare_313.cv_arg,
        "131": NonSpare_317.cv_arg,
        "120": NonSpare_301.cv_arg,
        "170": NonSpare_379.cv_arg,
        "210": NonSpare_418.cv_arg,
        "050": NonSpare_174.cv_arg,
        "080": NonSpare_234.cv_arg,
        "100": NonSpare_275.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "SP": NonSpare_1739.cv_arg,
        "150": NonSpare_347.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_36.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["161"], NonSpare_367.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["042"], NonSpare_159.cv_arg],
        Tuple[Literal["200"], NonSpare_390.cv_arg],
        Tuple[Literal["070"], NonSpare_214.cv_arg],
        Tuple[Literal["090"], NonSpare_254.cv_arg],
        Tuple[Literal["141"], NonSpare_338.cv_arg],
        Tuple[Literal["130"], NonSpare_313.cv_arg],
        Tuple[Literal["131"], NonSpare_317.cv_arg],
        Tuple[Literal["120"], NonSpare_301.cv_arg],
        Tuple[Literal["170"], NonSpare_379.cv_arg],
        Tuple[Literal["210"], NonSpare_418.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["080"], NonSpare_234.cv_arg],
        Tuple[Literal["100"], NonSpare_275.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["SP"], NonSpare_1739.cv_arg],
        Tuple[Literal["150"], NonSpare_347.cv_arg],
    ]
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_36, UapItem_87, UapItem_367, UapItem_138, UapItem_159, UapItem_390, UapItem_214, UapItem_254, UapItem_338, UapItem_313, UapItem_317, UapItem_301, UapItem_379, UapItem_418, UapItem_174, UapItem_234, UapItem_275, UapItem_189, UapItem_117, UapItem_550, UapItem_552, UapItem_347]
    cv_items_dict = {"010": NonSpare_36, "020": NonSpare_87, "161": NonSpare_367, "040": NonSpare_138, "042": NonSpare_159, "200": NonSpare_390, "070": NonSpare_214, "090": NonSpare_254, "141": NonSpare_338, "130": NonSpare_313, "131": NonSpare_317, "120": NonSpare_301, "170": NonSpare_379, "210": NonSpare_418, "050": NonSpare_174, "080": NonSpare_234, "100": NonSpare_275, "060": NonSpare_189, "030": NonSpare_117, "SP": NonSpare_1739, "150": NonSpare_347}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_36]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_87]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> Type[NonSpare_367]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_138]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> Type[NonSpare_159]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> Type[NonSpare_390]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_214]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_254]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> Type[NonSpare_338]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> Type[NonSpare_313]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> Type[NonSpare_317]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> Type[NonSpare_301]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> Type[NonSpare_379]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> Type[NonSpare_418]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> Type[NonSpare_174]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> Type[NonSpare_234]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_275]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_189]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_117]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> Type[NonSpare_347]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["161"], Literal["040"], Literal["042"], Literal["200"], Literal["070"], Literal["090"], Literal["141"], Literal["130"], Literal["131"], Literal["120"], Literal["170"], Literal["210"], Literal["050"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["SP"], Literal["150"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_36]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_367]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_159]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_390]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_214]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_254]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_338]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_313]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_317]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_301]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_379]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_418]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_234]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_275]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_347]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_36.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_367.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_159.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_390.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_214.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_254.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_338.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_313.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_317.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_301.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_379.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_418.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_234.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_275.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_19':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_347.cv_arg) -> 'Record_19':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_19':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_19':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_36]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["161"]) -> List[NonSpare_367]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["042"]) -> List[NonSpare_159]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["200"]) -> List[NonSpare_390]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_214]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_254]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_338]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_313]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_317]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_301]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["170"]) -> List[NonSpare_379]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["210"]) -> List[NonSpare_418]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_234]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_275]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1739]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_347]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_19.cv_arg", rfs: Optional[List["Record_19.cv_union"]] = None) -> 'Record_19':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_19", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_49(UapMultiple):
    cv_arg: TypeAlias = Union[Record_18, Record_19]
    cv_uaps = {"plot": Record_18, "track": Record_19}
    cv_selector = (["020", "TYP"], {0: "plot", 1: "track"})

    @overload
    @classmethod
    def spec(cls, key : Literal["plot"]) -> Type[Record_18]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["track"]) -> Type[Record_19]:
        ...
    @classmethod
    def spec(cls, key : Any) -> Any:
        return cls._spec(key)

    @overload
    @classmethod
    def parse(cls, uap : Literal["plot"], bs : Bits) -> Union[ValueError, List[Record_18]]:
        ...
    @overload
    @classmethod
    def parse(cls, uap : Literal["track"], bs : Bits) -> Union[ValueError, List[Record_19]]:
        ...
    @classmethod
    def parse(cls, uap : str, bs : Bits) -> Any:
        return cls._parse(uap, bs)

    @classmethod
    def parse_any_uap(cls, bs : Bits) -> "List[List[Uap_49.cv_arg]]":
        return cls._parse_any_uap(bs)

class Asterix_0(AstCat):
    cv_category = 1
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_49

    @classmethod
    def create(cls, records : List[Uap_49.cv_arg]) -> "Asterix_0":
        return cls._create(records) # type: ignore

class NonSpare_37(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1146.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1146

    @classmethod
    def create(cls, arg : "NonSpare_37.cv_arg") -> "NonSpare_37":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1198:
        return self.rule.variation

class UapItem_37(UapItem):
    cv_non_spare: TypeAlias = NonSpare_37

class Record_25(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "020": NonSpare_87.cv_arg,
        "040": NonSpare_138.cv_arg,
        "070": NonSpare_214.cv_arg,
        "090": NonSpare_254.cv_arg,
        "130": NonSpare_313.cv_arg,
        "141": NonSpare_338.cv_arg,
        "050": NonSpare_174.cv_arg,
        "120": NonSpare_301.cv_arg,
        "131": NonSpare_317.cv_arg,
        "080": NonSpare_234.cv_arg,
        "100": NonSpare_275.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "150": NonSpare_347.cv_arg,
        "SP": NonSpare_1739.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_37.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["070"], NonSpare_214.cv_arg],
        Tuple[Literal["090"], NonSpare_254.cv_arg],
        Tuple[Literal["130"], NonSpare_313.cv_arg],
        Tuple[Literal["141"], NonSpare_338.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["120"], NonSpare_301.cv_arg],
        Tuple[Literal["131"], NonSpare_317.cv_arg],
        Tuple[Literal["080"], NonSpare_234.cv_arg],
        Tuple[Literal["100"], NonSpare_275.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["150"], NonSpare_347.cv_arg],
        Tuple[Literal["SP"], NonSpare_1739.cv_arg],
    ]
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_37, UapItem_87, UapItem_138, UapItem_214, UapItem_254, UapItem_313, UapItem_338, UapItem_174, UapItem_301, UapItem_317, UapItem_234, UapItem_275, UapItem_189, UapItem_117, UapItem_347, UapItem_551, UapItem_551, UapItem_551, UapItem_551, UapItem_550, UapItem_552]
    cv_items_dict = {"010": NonSpare_37, "020": NonSpare_87, "040": NonSpare_138, "070": NonSpare_214, "090": NonSpare_254, "130": NonSpare_313, "141": NonSpare_338, "050": NonSpare_174, "120": NonSpare_301, "131": NonSpare_317, "080": NonSpare_234, "100": NonSpare_275, "060": NonSpare_189, "030": NonSpare_117, "150": NonSpare_347, "SP": NonSpare_1739}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_37]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_87]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_138]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_214]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_254]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> Type[NonSpare_313]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> Type[NonSpare_338]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> Type[NonSpare_174]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> Type[NonSpare_301]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> Type[NonSpare_317]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> Type[NonSpare_234]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_275]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_189]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_117]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> Type[NonSpare_347]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["040"], Literal["070"], Literal["090"], Literal["130"], Literal["141"], Literal["050"], Literal["120"], Literal["131"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["150"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_214]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_254]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_313]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_338]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_301]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_317]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_234]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_275]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_347]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_214.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_254.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_313.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_338.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_301.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_317.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_234.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_275.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_347.cv_arg) -> 'Record_25':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_25':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_25':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_25':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_37]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_214]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_254]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_313]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_338]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_301]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_317]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_234]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_275]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_347]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1739]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_25.cv_arg", rfs: Optional[List["Record_25.cv_union"]] = None) -> 'Record_25':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_25", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Record_26(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "020": NonSpare_87.cv_arg,
        "161": NonSpare_367.cv_arg,
        "040": NonSpare_138.cv_arg,
        "042": NonSpare_159.cv_arg,
        "200": NonSpare_390.cv_arg,
        "070": NonSpare_214.cv_arg,
        "090": NonSpare_254.cv_arg,
        "141": NonSpare_338.cv_arg,
        "130": NonSpare_313.cv_arg,
        "131": NonSpare_317.cv_arg,
        "120": NonSpare_301.cv_arg,
        "170": NonSpare_379.cv_arg,
        "210": NonSpare_418.cv_arg,
        "050": NonSpare_174.cv_arg,
        "080": NonSpare_234.cv_arg,
        "100": NonSpare_275.cv_arg,
        "060": NonSpare_189.cv_arg,
        "030": NonSpare_117.cv_arg,
        "SP": NonSpare_1739.cv_arg,
        "150": NonSpare_347.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_37.cv_arg],
        Tuple[Literal["020"], NonSpare_87.cv_arg],
        Tuple[Literal["161"], NonSpare_367.cv_arg],
        Tuple[Literal["040"], NonSpare_138.cv_arg],
        Tuple[Literal["042"], NonSpare_159.cv_arg],
        Tuple[Literal["200"], NonSpare_390.cv_arg],
        Tuple[Literal["070"], NonSpare_214.cv_arg],
        Tuple[Literal["090"], NonSpare_254.cv_arg],
        Tuple[Literal["141"], NonSpare_338.cv_arg],
        Tuple[Literal["130"], NonSpare_313.cv_arg],
        Tuple[Literal["131"], NonSpare_317.cv_arg],
        Tuple[Literal["120"], NonSpare_301.cv_arg],
        Tuple[Literal["170"], NonSpare_379.cv_arg],
        Tuple[Literal["210"], NonSpare_418.cv_arg],
        Tuple[Literal["050"], NonSpare_174.cv_arg],
        Tuple[Literal["080"], NonSpare_234.cv_arg],
        Tuple[Literal["100"], NonSpare_275.cv_arg],
        Tuple[Literal["060"], NonSpare_189.cv_arg],
        Tuple[Literal["030"], NonSpare_117.cv_arg],
        Tuple[Literal["SP"], NonSpare_1739.cv_arg],
        Tuple[Literal["150"], NonSpare_347.cv_arg],
    ]
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_37, UapItem_87, UapItem_367, UapItem_138, UapItem_159, UapItem_390, UapItem_214, UapItem_254, UapItem_338, UapItem_313, UapItem_317, UapItem_301, UapItem_379, UapItem_418, UapItem_174, UapItem_234, UapItem_275, UapItem_189, UapItem_117, UapItem_550, UapItem_552, UapItem_347]
    cv_items_dict = {"010": NonSpare_37, "020": NonSpare_87, "161": NonSpare_367, "040": NonSpare_138, "042": NonSpare_159, "200": NonSpare_390, "070": NonSpare_214, "090": NonSpare_254, "141": NonSpare_338, "130": NonSpare_313, "131": NonSpare_317, "120": NonSpare_301, "170": NonSpare_379, "210": NonSpare_418, "050": NonSpare_174, "080": NonSpare_234, "100": NonSpare_275, "060": NonSpare_189, "030": NonSpare_117, "SP": NonSpare_1739, "150": NonSpare_347}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_37]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_87]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> Type[NonSpare_367]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_138]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> Type[NonSpare_159]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> Type[NonSpare_390]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_214]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_254]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["141"]) -> Type[NonSpare_338]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["130"]) -> Type[NonSpare_313]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> Type[NonSpare_317]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> Type[NonSpare_301]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> Type[NonSpare_379]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> Type[NonSpare_418]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> Type[NonSpare_174]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> Type[NonSpare_234]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_275]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_189]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_117]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["150"]) -> Type[NonSpare_347]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["020"], Literal["161"], Literal["040"], Literal["042"], Literal["200"], Literal["070"], Literal["090"], Literal["141"], Literal["130"], Literal["131"], Literal["120"], Literal["170"], Literal["210"], Literal["050"], Literal["080"], Literal["100"], Literal["060"], Literal["030"], Literal["SP"], Literal["150"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_87]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_367]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_138]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_159]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_390]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_214]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_254]:
        ...
    @overload
    def get_item(self, key : Literal["141"]) -> Optional[NonSpare_338]:
        ...
    @overload
    def get_item(self, key : Literal["130"]) -> Optional[NonSpare_313]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_317]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_301]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_379]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_418]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_174]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_234]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_275]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_189]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_117]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    @overload
    def get_item(self, key : Literal["150"]) -> Optional[NonSpare_347]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_87.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_367.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_138.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_159.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_390.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_214.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_254.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["141"], val : NonSpare_338.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["130"], val : NonSpare_313.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_317.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_301.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_379.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_418.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_174.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_234.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_275.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_189.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_117.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_26':
        ...
    @overload
    def set_item(self, key : Literal["150"], val : NonSpare_347.cv_arg) -> 'Record_26':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["141"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["130"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_26':
        ...
    @overload
    def del_item(self, key : Literal["150"]) -> 'Record_26':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_37]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_87]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["161"]) -> List[NonSpare_367]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_138]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["042"]) -> List[NonSpare_159]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["200"]) -> List[NonSpare_390]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_214]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_254]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["141"]) -> List[NonSpare_338]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["130"]) -> List[NonSpare_313]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["131"]) -> List[NonSpare_317]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_301]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["170"]) -> List[NonSpare_379]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["210"]) -> List[NonSpare_418]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_174]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_234]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_275]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_189]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_117]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1739]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["150"]) -> List[NonSpare_347]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_26.cv_arg", rfs: Optional[List["Record_26.cv_union"]] = None) -> 'Record_26':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_26", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_50(UapMultiple):
    cv_arg: TypeAlias = Union[Record_25, Record_26]
    cv_uaps = {"plot": Record_25, "track": Record_26}
    cv_selector = (["020", "TYP"], {0: "plot", 1: "track"})

    @overload
    @classmethod
    def spec(cls, key : Literal["plot"]) -> Type[Record_25]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["track"]) -> Type[Record_26]:
        ...
    @classmethod
    def spec(cls, key : Any) -> Any:
        return cls._spec(key)

    @overload
    @classmethod
    def parse(cls, uap : Literal["plot"], bs : Bits) -> Union[ValueError, List[Record_25]]:
        ...
    @overload
    @classmethod
    def parse(cls, uap : Literal["track"], bs : Bits) -> Union[ValueError, List[Record_26]]:
        ...
    @classmethod
    def parse(cls, uap : str, bs : Bits) -> Any:
        return cls._parse(uap, bs)

    @classmethod
    def parse_any_uap(cls, bs : Bits) -> "List[List[Uap_50.cv_arg]]":
        return cls._parse_any_uap(bs)

class Asterix_1(AstCat):
    cv_category = 1
    cv_edition = (1, 3)
    cv_uap: TypeAlias = Uap_50

    @classmethod
    def create(cls, records : List[Uap_50.cv_arg]) -> "Asterix_1":
        return cls._create(records) # type: ignore

class Asterix_2(AstCat):
    cv_category = 1
    cv_edition = (1, 4)
    cv_uap: TypeAlias = Uap_50

    @classmethod
    def create(cls, records : List[Uap_50.cv_arg]) -> "Asterix_2":
        return cls._create(records) # type: ignore

class NonSpare_47(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1146.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1146

    @classmethod
    def create(cls, arg : "NonSpare_47.cv_arg") -> "NonSpare_47":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1198:
        return self.rule.variation

class UapItem_47(UapItem):
    cv_non_spare: TypeAlias = NonSpare_47

class Content_591(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "North marker message", 2: "Sector crossing message", 3: "South marker message", 8: "Activation of blind zone filtering", 9: "Stop of blind zone filtering"}

class RuleContent_591(RuleContentContextFree):
    cv_arg: TypeAlias = Content_591.cv_arg
    cv_content: TypeAlias = Content_591

    @property
    def content(self) -> Content_591:
        return self._get_content() # type: ignore

class Variation_190(Element):
    cv_arg: TypeAlias = RuleContent_591.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_591

    @classmethod
    def create(cls, arg: "Variation_190.cv_arg") -> "Variation_190":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_591:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_591:
        return self.rule.content

class RuleVariation_183(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_190.cv_arg
    cv_variation: TypeAlias = Variation_190

    @classmethod
    def create(cls, arg : "RuleVariation_183.cv_arg") -> "RuleVariation_183":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_190:
        return self.arg # type: ignore

class NonSpare_7(NonSpare):
    cv_arg: TypeAlias = RuleVariation_183.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_183

    @classmethod
    def create(cls, arg : "NonSpare_7.cv_arg") -> "NonSpare_7":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_183:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_190:
        return self.rule.variation

class UapItem_7(UapItem):
    cv_non_spare: TypeAlias = NonSpare_7

class Content_791(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.40625
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_790(RuleContentContextFree):
    cv_arg: TypeAlias = Content_791.cv_arg
    cv_content: TypeAlias = Content_791

    @property
    def content(self) -> Content_791:
        return self._get_content() # type: ignore

class Variation_243(Element):
    cv_arg: TypeAlias = RuleContent_790.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_790

    @classmethod
    def create(cls, arg: "Variation_243.cv_arg") -> "Variation_243":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_790:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_791:
        return self.rule.content

class RuleVariation_236(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_243.cv_arg
    cv_variation: TypeAlias = Variation_243

    @classmethod
    def create(cls, arg : "RuleVariation_236.cv_arg") -> "RuleVariation_236":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_243:
        return self.arg # type: ignore

class NonSpare_81(NonSpare):
    cv_arg: TypeAlias = RuleVariation_236.cv_arg
    cv_name = "020"
    cv_title = "Sector Number"
    cv_rule: TypeAlias = RuleVariation_236

    @classmethod
    def create(cls, arg : "NonSpare_81.cv_arg") -> "NonSpare_81":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_236:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_243:
        return self.rule.variation

class UapItem_81(UapItem):
    cv_non_spare: TypeAlias = NonSpare_81

class Variation_370(Element):
    cv_arg: TypeAlias = RuleContent_770.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_770

    @classmethod
    def create(cls, arg: "Variation_370.cv_arg") -> "Variation_370":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_770:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_771:
        return self.rule.content

class RuleVariation_363(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_370.cv_arg
    cv_variation: TypeAlias = Variation_370

    @classmethod
    def create(cls, arg : "RuleVariation_363.cv_arg") -> "RuleVariation_363":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_370:
        return self.arg # type: ignore

class NonSpare_109(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "030"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_109.cv_arg") -> "NonSpare_109":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_109(UapItem):
    cv_non_spare: TypeAlias = NonSpare_109

class NonSpare_152(NonSpare):
    cv_arg: TypeAlias = RuleVariation_327.cv_arg
    cv_name = "041"
    cv_title = "Antenna Rotation Speed"
    cv_rule: TypeAlias = RuleVariation_327

    @classmethod
    def create(cls, arg : "NonSpare_152.cv_arg") -> "NonSpare_152":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_327:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_334:
        return self.rule.variation

class UapItem_152(UapItem):
    cv_non_spare: TypeAlias = NonSpare_152

class NonSpare_180(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "050"
    cv_title = "Station Configuration Status"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_180.cv_arg") -> "NonSpare_180":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1463:
        return self.rule.variation

class UapItem_180(UapItem):
    cv_non_spare: TypeAlias = NonSpare_180

class NonSpare_198(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "060"
    cv_title = "Station Processing Mode"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_198.cv_arg") -> "NonSpare_198":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1463:
        return self.rule.variation

class UapItem_198(UapItem):
    cv_non_spare: TypeAlias = NonSpare_198

class Content_70(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Counter for antenna 1", 1: "Counter for antenna 2"}

class RuleContent_70(RuleContentContextFree):
    cv_arg: TypeAlias = Content_70.cv_arg
    cv_content: TypeAlias = Content_70

    @property
    def content(self) -> Content_70:
        return self._get_content() # type: ignore

class Variation_21(Element):
    cv_arg: TypeAlias = RuleContent_70.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_70

    @classmethod
    def create(cls, arg: "Variation_21.cv_arg") -> "Variation_21":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_70:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_70:
        return self.rule.content

class RuleVariation_21(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_21.cv_arg
    cv_variation: TypeAlias = Variation_21

    @classmethod
    def create(cls, arg : "RuleVariation_21.cv_arg") -> "RuleVariation_21":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_21:
        return self.arg # type: ignore

class NonSpare_550(NonSpare):
    cv_arg: TypeAlias = RuleVariation_21.cv_arg
    cv_name = "A"
    cv_title = "Aerial Identification"
    cv_rule: TypeAlias = RuleVariation_21

    @classmethod
    def create(cls, arg : "NonSpare_550.cv_arg") -> "NonSpare_550":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_21:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_21:
        return self.rule.variation

class Item_33(Item):
    cv_arg: TypeAlias = NonSpare_550.cv_arg
    cv_non_spare: TypeAlias = NonSpare_550

    @classmethod
    def create(cls, arg : "Item_33.cv_arg") -> "Item_33":
        return cls._create(arg) # type: ignore

class Content_596(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Sole primary plots", 2: "Sole SSR plots", 3: "Combined plots"}

class RuleContent_596(RuleContentContextFree):
    cv_arg: TypeAlias = Content_596.cv_arg
    cv_content: TypeAlias = Content_596

    @property
    def content(self) -> Content_596:
        return self._get_content() # type: ignore

class Variation_492(Element):
    cv_arg: TypeAlias = RuleContent_596.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 5
    cv_rule = RuleContent_596

    @classmethod
    def create(cls, arg: "Variation_492.cv_arg") -> "Variation_492":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_596:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_596:
        return self.rule.content

class RuleVariation_481(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_492.cv_arg
    cv_variation: TypeAlias = Variation_492

    @classmethod
    def create(cls, arg : "RuleVariation_481.cv_arg") -> "RuleVariation_481":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_492:
        return self.arg # type: ignore

class NonSpare_1118(NonSpare):
    cv_arg: TypeAlias = RuleVariation_481.cv_arg
    cv_name = "IDENT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_481

    @classmethod
    def create(cls, arg : "NonSpare_1118.cv_arg") -> "NonSpare_1118":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_481:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_492:
        return self.rule.variation

class Item_432(Item):
    cv_arg: TypeAlias = NonSpare_1118.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1118

    @classmethod
    def create(cls, arg : "Item_432.cv_arg") -> "Item_432":
        return cls._create(arg) # type: ignore

class Content_614(ContentInteger):
    cv_arg: TypeAlias = int
    cv_signedness: TypeAlias = Unsigned

class RuleContent_614(RuleContentContextFree):
    cv_arg: TypeAlias = Content_614.cv_arg
    cv_content: TypeAlias = Content_614

    @property
    def content(self) -> Content_614:
        return self._get_content() # type: ignore

class Variation_970(Element):
    cv_arg: TypeAlias = RuleContent_614.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 10
    cv_rule = RuleContent_614

    @classmethod
    def create(cls, arg: "Variation_970.cv_arg") -> "Variation_970":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_614:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_614:
        return self.rule.content

class RuleVariation_940(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_970.cv_arg
    cv_variation: TypeAlias = Variation_970

    @classmethod
    def create(cls, arg : "RuleVariation_940.cv_arg") -> "RuleVariation_940":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_970:
        return self.arg # type: ignore

class NonSpare_805(NonSpare):
    cv_arg: TypeAlias = RuleVariation_940.cv_arg
    cv_name = "COUNTER"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_940

    @classmethod
    def create(cls, arg : "NonSpare_805.cv_arg") -> "NonSpare_805":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_940:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_970:
        return self.rule.variation

class Item_201(Item):
    cv_arg: TypeAlias = NonSpare_805.cv_arg
    cv_non_spare: TypeAlias = NonSpare_805

    @classmethod
    def create(cls, arg : "Item_201.cv_arg") -> "Item_201":
        return cls._create(arg) # type: ignore

class Variation_1048(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_21.cv_arg, Tuple[Literal["A"], RuleVariation_21.cv_arg]], Union[RuleVariation_481.cv_arg, Tuple[Literal["IDENT"], RuleVariation_481.cv_arg]], Union[RuleVariation_940.cv_arg, Tuple[Literal["COUNTER"], RuleVariation_940.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1048.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_33, 1), (Item_432, 5), (Item_201, 10)]
    cv_items_dict = {"A": RuleVariation_21, "IDENT": RuleVariation_481, "COUNTER": RuleVariation_940}

    @overload
    @classmethod
    def spec(cls, key : Literal["A"]) -> Type[RuleVariation_21]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["IDENT"]) -> Type[RuleVariation_481]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COUNTER"]) -> Type[RuleVariation_940]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["A"], Literal["IDENT"], Literal["COUNTER"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["A"]) -> RuleVariation_21:
        ...
    @overload
    def get_item(self, key : Literal["IDENT"]) -> RuleVariation_481:
        ...
    @overload
    def get_item(self, key : Literal["COUNTER"]) -> RuleVariation_940:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1048.cv_arg") -> 'Variation_1048':
        return cls._create(arg) # type: ignore

class Variation_1418(Repetitive):
    cv_arg: TypeAlias = List[Variation_1048.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1048

    @classmethod
    def create(cls, arg: "Variation_1418.cv_arg") -> 'Variation_1418':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1048]:
        return self._get_list() # type: ignore

class RuleVariation_1339(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1418.cv_arg
    cv_variation: TypeAlias = Variation_1418

    @classmethod
    def create(cls, arg : "RuleVariation_1339.cv_arg") -> "RuleVariation_1339":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1418:
        return self.arg # type: ignore

class NonSpare_217(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1339.cv_arg
    cv_name = "070"
    cv_title = "Plot Count Values"
    cv_rule: TypeAlias = RuleVariation_1339

    @classmethod
    def create(cls, arg : "NonSpare_217.cv_arg") -> "NonSpare_217":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1339:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1418:
        return self.rule.variation

class UapItem_217(UapItem):
    cv_non_spare: TypeAlias = NonSpare_217

class Content_768(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_767(RuleContentContextFree):
    cv_arg: TypeAlias = Content_768.cv_arg
    cv_content: TypeAlias = Content_768

    @property
    def content(self) -> Content_768:
        return self._get_content() # type: ignore

class Variation_331(Element):
    cv_arg: TypeAlias = RuleContent_767.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_767

    @classmethod
    def create(cls, arg: "Variation_331.cv_arg") -> "Variation_331":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_767:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_768:
        return self.rule.content

class RuleVariation_324(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_331.cv_arg
    cv_variation: TypeAlias = Variation_331

    @classmethod
    def create(cls, arg : "RuleVariation_324.cv_arg") -> "RuleVariation_324":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_331:
        return self.arg # type: ignore

class NonSpare_1620(NonSpare):
    cv_arg: TypeAlias = RuleVariation_324.cv_arg
    cv_name = "RS"
    cv_title = "Rho Start"
    cv_rule: TypeAlias = RuleVariation_324

    @classmethod
    def create(cls, arg : "NonSpare_1620.cv_arg") -> "NonSpare_1620":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_324:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_331:
        return self.rule.variation

class Item_835(Item):
    cv_arg: TypeAlias = NonSpare_1620.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1620

    @classmethod
    def create(cls, arg : "Item_835.cv_arg") -> "Item_835":
        return cls._create(arg) # type: ignore

class NonSpare_1575(NonSpare):
    cv_arg: TypeAlias = RuleVariation_324.cv_arg
    cv_name = "RE"
    cv_title = "Rho End"
    cv_rule: TypeAlias = RuleVariation_324

    @classmethod
    def create(cls, arg : "NonSpare_1575.cv_arg") -> "NonSpare_1575":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_324:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_331:
        return self.rule.variation

class Item_797(Item):
    cv_arg: TypeAlias = NonSpare_1575.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1575

    @classmethod
    def create(cls, arg : "Item_797.cv_arg") -> "Item_797":
        return cls._create(arg) # type: ignore

class NonSpare_1933(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TS"
    cv_title = "Theta Start"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1933.cv_arg") -> "NonSpare_1933":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_1047(Item):
    cv_arg: TypeAlias = NonSpare_1933.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1933

    @classmethod
    def create(cls, arg : "Item_1047.cv_arg") -> "Item_1047":
        return cls._create(arg) # type: ignore

class NonSpare_1859(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TE"
    cv_title = "Theta End"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1859.cv_arg") -> "NonSpare_1859":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_995(Item):
    cv_arg: TypeAlias = NonSpare_1859.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1859

    @classmethod
    def create(cls, arg : "Item_995.cv_arg") -> "Item_995":
        return cls._create(arg) # type: ignore

class Variation_1191(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_324.cv_arg, Tuple[Literal["RS"], RuleVariation_324.cv_arg]], Union[RuleVariation_324.cv_arg, Tuple[Literal["RE"], RuleVariation_324.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TS"], RuleVariation_336.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TE"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1191.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_835, 16), (Item_797, 16), (Item_1047, 16), (Item_995, 16)]
    cv_items_dict = {"RS": RuleVariation_324, "RE": RuleVariation_324, "TS": RuleVariation_336, "TE": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["RS"]) -> Type[RuleVariation_324]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> Type[RuleVariation_324]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TS"]) -> Type[RuleVariation_336]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TE"]) -> Type[RuleVariation_336]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RS"], Literal["RE"], Literal["TS"], Literal["TE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RS"]) -> RuleVariation_324:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> RuleVariation_324:
        ...
    @overload
    def get_item(self, key : Literal["TS"]) -> RuleVariation_336:
        ...
    @overload
    def get_item(self, key : Literal["TE"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1191.cv_arg") -> 'Variation_1191':
        return cls._create(arg) # type: ignore

class RuleVariation_1141(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1191.cv_arg
    cv_variation: TypeAlias = Variation_1191

    @classmethod
    def create(cls, arg : "RuleVariation_1141.cv_arg") -> "RuleVariation_1141":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1191:
        return self.arg # type: ignore

class NonSpare_270(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1141.cv_arg
    cv_name = "100"
    cv_title = "Dynamic Window Type 1"
    cv_rule: TypeAlias = RuleVariation_1141

    @classmethod
    def create(cls, arg : "NonSpare_270.cv_arg") -> "NonSpare_270":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1141:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1191:
        return self.rule.variation

class UapItem_270(UapItem):
    cv_non_spare: TypeAlias = NonSpare_270

class Content_678(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 7.8125e-3
    cv_unit = "NM"

    def as_quantity(self, cv_unit : Optional[Literal["NM"]] = None) -> float:
        return self._as_quantity()

class RuleContent_678(RuleContentContextFree):
    cv_arg: TypeAlias = Content_678.cv_arg
    cv_content: TypeAlias = Content_678

    @property
    def content(self) -> Content_678:
        return self._get_content() # type: ignore

class Variation_215(Element):
    cv_arg: TypeAlias = RuleContent_678.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_678

    @classmethod
    def create(cls, arg: "Variation_215.cv_arg") -> "Variation_215":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_678:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_678:
        return self.rule.content

class RuleVariation_208(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_215.cv_arg
    cv_variation: TypeAlias = Variation_215

    @classmethod
    def create(cls, arg : "RuleVariation_208.cv_arg") -> "RuleVariation_208":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_215:
        return self.arg # type: ignore

class NonSpare_1571(NonSpare):
    cv_arg: TypeAlias = RuleVariation_208.cv_arg
    cv_name = "RE"
    cv_title = "Range Error"
    cv_rule: TypeAlias = RuleVariation_208

    @classmethod
    def create(cls, arg : "NonSpare_1571.cv_arg") -> "NonSpare_1571":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_208:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_215:
        return self.rule.variation

class Item_794(Item):
    cv_arg: TypeAlias = NonSpare_1571.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1571

    @classmethod
    def create(cls, arg : "Item_794.cv_arg") -> "Item_794":
        return cls._create(arg) # type: ignore

class Content_709(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 2.197265625e-2
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_709(RuleContentContextFree):
    cv_arg: TypeAlias = Content_709.cv_arg
    cv_content: TypeAlias = Content_709

    @property
    def content(self) -> Content_709:
        return self._get_content() # type: ignore

class Variation_220(Element):
    cv_arg: TypeAlias = RuleContent_709.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_709

    @classmethod
    def create(cls, arg: "Variation_220.cv_arg") -> "Variation_220":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_709:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_709:
        return self.rule.content

class RuleVariation_213(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_220.cv_arg
    cv_variation: TypeAlias = Variation_220

    @classmethod
    def create(cls, arg : "RuleVariation_213.cv_arg") -> "RuleVariation_213":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_220:
        return self.arg # type: ignore

class NonSpare_581(NonSpare):
    cv_arg: TypeAlias = RuleVariation_213.cv_arg
    cv_name = "AE"
    cv_title = "Azimuth Error"
    cv_rule: TypeAlias = RuleVariation_213

    @classmethod
    def create(cls, arg : "NonSpare_581.cv_arg") -> "NonSpare_581":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_213:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_220:
        return self.rule.variation

class Item_49(Item):
    cv_arg: TypeAlias = NonSpare_581.cv_arg
    cv_non_spare: TypeAlias = NonSpare_581

    @classmethod
    def create(cls, arg : "Item_49.cv_arg") -> "Item_49":
        return cls._create(arg) # type: ignore

class Variation_1177(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_208.cv_arg, Tuple[Literal["RE"], RuleVariation_208.cv_arg]], Union[RuleVariation_213.cv_arg, Tuple[Literal["AE"], RuleVariation_213.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1177.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_794, 8), (Item_49, 8)]
    cv_items_dict = {"RE": RuleVariation_208, "AE": RuleVariation_213}

    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> Type[RuleVariation_208]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AE"]) -> Type[RuleVariation_213]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RE"], Literal["AE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RE"]) -> RuleVariation_208:
        ...
    @overload
    def get_item(self, key : Literal["AE"]) -> RuleVariation_213:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1177.cv_arg") -> 'Variation_1177':
        return cls._create(arg) # type: ignore

class RuleVariation_1128(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1177.cv_arg
    cv_variation: TypeAlias = Variation_1177

    @classmethod
    def create(cls, arg : "RuleVariation_1128.cv_arg") -> "RuleVariation_1128":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1177:
        return self.arg # type: ignore

class NonSpare_245(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1128.cv_arg
    cv_name = "090"
    cv_title = "Collimation Error"
    cv_rule: TypeAlias = RuleVariation_1128

    @classmethod
    def create(cls, arg : "NonSpare_245.cv_arg") -> "NonSpare_245":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1128:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1177:
        return self.rule.variation

class UapItem_245(UapItem):
    cv_non_spare: TypeAlias = NonSpare_245

class NonSpare_243(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "080"
    cv_title = "Warning/Error Conditions"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_243.cv_arg") -> "NonSpare_243":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1463:
        return self.rule.variation

class UapItem_243(UapItem):
    cv_non_spare: TypeAlias = NonSpare_243

class Record_47(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_47.cv_arg,
        "000": NonSpare_7.cv_arg,
        "020": NonSpare_81.cv_arg,
        "030": NonSpare_109.cv_arg,
        "041": NonSpare_152.cv_arg,
        "050": NonSpare_180.cv_arg,
        "060": NonSpare_198.cv_arg,
        "070": NonSpare_217.cv_arg,
        "100": NonSpare_270.cv_arg,
        "090": NonSpare_245.cv_arg,
        "080": NonSpare_243.cv_arg,
        "SP": NonSpare_1739.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_47.cv_arg],
        Tuple[Literal["000"], NonSpare_7.cv_arg],
        Tuple[Literal["020"], NonSpare_81.cv_arg],
        Tuple[Literal["030"], NonSpare_109.cv_arg],
        Tuple[Literal["041"], NonSpare_152.cv_arg],
        Tuple[Literal["050"], NonSpare_180.cv_arg],
        Tuple[Literal["060"], NonSpare_198.cv_arg],
        Tuple[Literal["070"], NonSpare_217.cv_arg],
        Tuple[Literal["100"], NonSpare_270.cv_arg],
        Tuple[Literal["090"], NonSpare_245.cv_arg],
        Tuple[Literal["080"], NonSpare_243.cv_arg],
        Tuple[Literal["SP"], NonSpare_1739.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_47, UapItem_7, UapItem_81, UapItem_109, UapItem_152, UapItem_180, UapItem_198, UapItem_217, UapItem_270, UapItem_245, UapItem_243, UapItem_551, UapItem_550, UapItem_552]
    cv_items_dict = {"010": NonSpare_47, "000": NonSpare_7, "020": NonSpare_81, "030": NonSpare_109, "041": NonSpare_152, "050": NonSpare_180, "060": NonSpare_198, "070": NonSpare_217, "100": NonSpare_270, "090": NonSpare_245, "080": NonSpare_243, "SP": NonSpare_1739}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_47]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> Type[NonSpare_7]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_81]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_109]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> Type[NonSpare_152]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> Type[NonSpare_180]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_198]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_217]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_270]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_245]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> Type[NonSpare_243]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["041"], Literal["050"], Literal["060"], Literal["070"], Literal["100"], Literal["090"], Literal["080"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_47]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_7]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_81]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_109]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_152]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_180]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_198]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_217]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_270]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_245]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_243]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_47.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_7.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_81.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_109.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_152.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_180.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_198.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_217.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_270.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_245.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_243.cv_arg) -> 'Record_47':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_47':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_47':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_47':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_47]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_7]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_81]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_109]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["041"]) -> List[NonSpare_152]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_180]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_198]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_217]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_270]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_245]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_243]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1739]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_47.cv_arg", rfs: Optional[List["Record_47.cv_union"]] = None) -> 'Record_47':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_47", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_43(UapSingle):
    cv_arg: TypeAlias = Record_47
    cv_record: TypeAlias = Record_47

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_47]]:
        return cls._parse(bs)

class Asterix_3(AstCat):
    cv_category = 2
    cv_edition = (1, 0)
    cv_uap: TypeAlias = Uap_43
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_43.cv_arg]) -> "Asterix_3":
        return cls._create(records) # type: ignore

class NonSpare_38(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1146.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1146

    @classmethod
    def create(cls, arg : "NonSpare_38.cv_arg") -> "NonSpare_38":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1198:
        return self.rule.variation

class UapItem_38(UapItem):
    cv_non_spare: TypeAlias = NonSpare_38

class Record_27(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_38.cv_arg,
        "000": NonSpare_7.cv_arg,
        "020": NonSpare_81.cv_arg,
        "030": NonSpare_109.cv_arg,
        "041": NonSpare_152.cv_arg,
        "050": NonSpare_180.cv_arg,
        "060": NonSpare_198.cv_arg,
        "070": NonSpare_217.cv_arg,
        "100": NonSpare_270.cv_arg,
        "090": NonSpare_245.cv_arg,
        "080": NonSpare_243.cv_arg,
        "SP": NonSpare_1739.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_38.cv_arg],
        Tuple[Literal["000"], NonSpare_7.cv_arg],
        Tuple[Literal["020"], NonSpare_81.cv_arg],
        Tuple[Literal["030"], NonSpare_109.cv_arg],
        Tuple[Literal["041"], NonSpare_152.cv_arg],
        Tuple[Literal["050"], NonSpare_180.cv_arg],
        Tuple[Literal["060"], NonSpare_198.cv_arg],
        Tuple[Literal["070"], NonSpare_217.cv_arg],
        Tuple[Literal["100"], NonSpare_270.cv_arg],
        Tuple[Literal["090"], NonSpare_245.cv_arg],
        Tuple[Literal["080"], NonSpare_243.cv_arg],
        Tuple[Literal["SP"], NonSpare_1739.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_38, UapItem_7, UapItem_81, UapItem_109, UapItem_152, UapItem_180, UapItem_198, UapItem_217, UapItem_270, UapItem_245, UapItem_243, UapItem_551, UapItem_550, UapItem_552]
    cv_items_dict = {"010": NonSpare_38, "000": NonSpare_7, "020": NonSpare_81, "030": NonSpare_109, "041": NonSpare_152, "050": NonSpare_180, "060": NonSpare_198, "070": NonSpare_217, "100": NonSpare_270, "090": NonSpare_245, "080": NonSpare_243, "SP": NonSpare_1739}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_38]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> Type[NonSpare_7]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_81]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_109]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> Type[NonSpare_152]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> Type[NonSpare_180]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_198]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_217]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_270]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_245]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> Type[NonSpare_243]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["041"], Literal["050"], Literal["060"], Literal["070"], Literal["100"], Literal["090"], Literal["080"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_38]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_7]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_81]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_109]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_152]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_180]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_198]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_217]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_270]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_245]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_243]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_38.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_7.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_81.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_109.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_152.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_180.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_198.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_217.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_270.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_245.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_243.cv_arg) -> 'Record_27':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_27':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_27':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_27':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_38]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_7]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_81]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["030"]) -> List[NonSpare_109]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["041"]) -> List[NonSpare_152]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_180]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["060"]) -> List[NonSpare_198]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["070"]) -> List[NonSpare_217]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_270]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_245]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["080"]) -> List[NonSpare_243]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1739]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_27.cv_arg", rfs: Optional[List["Record_27.cv_union"]] = None) -> 'Record_27':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_27", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_23(UapSingle):
    cv_arg: TypeAlias = Record_27
    cv_record: TypeAlias = Record_27

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_27]]:
        return cls._parse(bs)

class Asterix_4(AstCat):
    cv_category = 2
    cv_edition = (1, 1)
    cv_uap: TypeAlias = Uap_23
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_23.cv_arg]) -> "Asterix_4":
        return cls._create(records) # type: ignore

class Asterix_5(AstCat):
    cv_category = 2
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_23
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_23.cv_arg]) -> "Asterix_5":
        return cls._create(records) # type: ignore

class NonSpare_34(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1146.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1146

    @classmethod
    def create(cls, arg : "NonSpare_34.cv_arg") -> "NonSpare_34":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1198:
        return self.rule.variation

class UapItem_34(UapItem):
    cv_non_spare: TypeAlias = NonSpare_34

class Content_577(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Alive Message (AM)", 2: "Route Adherence Monitor Longitudinal Deviation (RAMLD)", 3: "Route Adherence Monitor Heading Deviation (RAMHD)", 4: "Minimum Safe Altitude Warning (MSAW)", 5: "Area Proximity Warning (APW)", 6: "Clearance Level Adherence Monitor (CLAM)", 7: "Short Term Conflict Alert (STCA)", 8: "Approach Path Monitor (APM)", 9: "RIMCAS Arrival / Landing Monitor (ALM)", 10: "RIMCAS Arrival / Departure Wrong Runway Alert (WRA)", 11: "RIMCAS Arrival / Departure Opposite Traffic Alert (OTA)", 12: "RIMCAS Departure Monitor (RDM)", 13: "RIMCAS Runway / Taxiway Crossing Monitor (RCM)", 14: "RIMCAS Taxiway Separation Monitor (TSM)", 15: "RIMCAS Unauthorized Taxiway Movement Monitor(UTMM)", 16: "RIMCAS Stop Bar Overrun Alert (SBOA)", 17: "End Of Conflict (EOC)", 18: "ACAS Resolution Advisory (ACASRA)", 19: "Near Term Conflict Alert (NTCA)", 20: "Downlinked Barometric Pressure Setting Monitor (DBPSM)", 21: "Speed Adherence Monitor (SAM)", 22: "Outside Controlled Airspace Tool (OCAT)", 23: "Vertical Conflict Detection (VCD)", 24: "Vertical Rate Adherence Monitor (VRAM)", 25: "Cleared Heading Adherence Monitor (CHAM)", 26: "Downlinked Selected Altitude Monitor (DSAM)", 27: "Holding Adherence Monitor (HAM)", 28: "Vertical Path Monitor (VPM)", 29: "RIMCAS Taxiway Traffic Alert (TTA)", 30: "RIMCAS Arrival/Departure Close Runway Alert (CRA)", 31: "RIMCAS Arrival/Departure Aircraft Separation Monitor (ASM)", 32: "RIMCAS ILS Area Violation Monitor (IAVM)", 33: "Final Target Distance Indicator (FTD)", 34: "Initial Target Distance Indicator (ITD)", 35: "Wake Vortex Indicator Infringement Alert (IIA)", 36: "Sequence Warning (SQW)", 37: "Catch Up Warning (CUW)", 38: "Conflicting ATC Clearances (CATC)", 39: "No ATC Clearance (NOCLR)", 40: "Aircraft Not Moving despite ATC Clearance (NOMOV)", 41: "Aircraft leaving/entering the aerodrome area without proper handover (NOH)", 42: "Wrong Runway or Taxiway Type (WRTY)", 43: "Stand Occupied (STOCC)", 44: "Ongoing Alert (ONGOING)", 97: "Lost Track Warning (LTW)", 98: "Holding Volume Infringement (HVI)", 99: "Airspace Infringement Warning (AIW)"}

class RuleContent_577(RuleContentContextFree):
    cv_arg: TypeAlias = Content_577.cv_arg
    cv_content: TypeAlias = Content_577

    @property
    def content(self) -> Content_577:
        return self._get_content() # type: ignore

class Variation_180(Element):
    cv_arg: TypeAlias = RuleContent_577.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_577

    @classmethod
    def create(cls, arg: "Variation_180.cv_arg") -> "Variation_180":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_577:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_577:
        return self.rule.content

class RuleVariation_173(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_180.cv_arg
    cv_variation: TypeAlias = Variation_180

    @classmethod
    def create(cls, arg : "RuleVariation_173.cv_arg") -> "RuleVariation_173":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_180:
        return self.arg # type: ignore

class NonSpare_3(NonSpare):
    cv_arg: TypeAlias = RuleVariation_173.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_173

    @classmethod
    def create(cls, arg : "NonSpare_3.cv_arg") -> "NonSpare_3":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_173:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_180:
        return self.rule.variation

class UapItem_3(UapItem):
    cv_non_spare: TypeAlias = NonSpare_3

class Variation_1438(Repetitive):
    cv_arg: TypeAlias = List[Variation_1198.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1198

    @classmethod
    def create(cls, arg: "Variation_1438.cv_arg") -> 'Variation_1438':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1198]:
        return self._get_list() # type: ignore

class RuleVariation_1359(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1438.cv_arg
    cv_variation: TypeAlias = Variation_1438

    @classmethod
    def create(cls, arg : "RuleVariation_1359.cv_arg") -> "RuleVariation_1359":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1438:
        return self.arg # type: ignore

class NonSpare_58(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1359.cv_arg
    cv_name = "015"
    cv_title = "SDPS Identifier"
    cv_rule: TypeAlias = RuleVariation_1359

    @classmethod
    def create(cls, arg : "NonSpare_58.cv_arg") -> "NonSpare_58":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1359:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1438:
        return self.rule.variation

class UapItem_58(UapItem):
    cv_non_spare: TypeAlias = NonSpare_58

class NonSpare_94(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "020"
    cv_title = "Time of Message"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_94.cv_arg") -> "NonSpare_94":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_94(UapItem):
    cv_non_spare: TypeAlias = NonSpare_94

class NonSpare_136(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "040"
    cv_title = "Alert Identifier"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_136.cv_arg") -> "NonSpare_136":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_136(UapItem):
    cv_non_spare: TypeAlias = NonSpare_136

class Variation_776(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_776.cv_arg") -> "Variation_776":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_765(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_776.cv_arg
    cv_variation: TypeAlias = Variation_776

    @classmethod
    def create(cls, arg : "RuleVariation_765.cv_arg") -> "RuleVariation_765":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_776:
        return self.arg # type: ignore

class NonSpare_1790(NonSpare):
    cv_arg: TypeAlias = RuleVariation_765.cv_arg
    cv_name = "STAT"
    cv_title = "Status of the Alert"
    cv_rule: TypeAlias = RuleVariation_765

    @classmethod
    def create(cls, arg : "NonSpare_1790.cv_arg") -> "NonSpare_1790":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_765:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_776:
        return self.rule.variation

class Item_948(Item):
    cv_arg: TypeAlias = NonSpare_1790.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1790

    @classmethod
    def create(cls, arg : "Item_948.cv_arg") -> "Item_948":
        return cls._create(arg) # type: ignore

class Item_29(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 7
    cv_bit_size = 1

class Variation_1037(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_765.cv_arg, Tuple[Literal["STAT"], RuleVariation_765.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1037.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_3, 4), (Item_948, 3), (Item_29, 1)]
    cv_items_dict = {"STAT": RuleVariation_765}

    @classmethod
    def spec(cls, key : Literal["STAT"]) -> Type[RuleVariation_765]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["STAT"]) -> RuleVariation_765:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1037.cv_arg") -> 'Variation_1037':
        return cls._create(arg) # type: ignore

class RuleVariation_1005(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1037.cv_arg
    cv_variation: TypeAlias = Variation_1037

    @classmethod
    def create(cls, arg : "RuleVariation_1005.cv_arg") -> "RuleVariation_1005":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1037:
        return self.arg # type: ignore

class NonSpare_163(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1005.cv_arg
    cv_name = "045"
    cv_title = "Alert Status"
    cv_rule: TypeAlias = RuleVariation_1005

    @classmethod
    def create(cls, arg : "NonSpare_163.cv_arg") -> "NonSpare_163":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1005:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1037:
        return self.rule.variation

class UapItem_163(UapItem):
    cv_non_spare: TypeAlias = NonSpare_163

class Content_115(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "MRVA function"}

class RuleContent_115(RuleContentContextFree):
    cv_arg: TypeAlias = Content_115.cv_arg
    cv_content: TypeAlias = Content_115

    @property
    def content(self) -> Content_115:
        return self._get_content() # type: ignore

class Variation_32(Element):
    cv_arg: TypeAlias = RuleContent_115.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_115

    @classmethod
    def create(cls, arg: "Variation_32.cv_arg") -> "Variation_32":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_115:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_115:
        return self.rule.content

class RuleVariation_32(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_32.cv_arg
    cv_variation: TypeAlias = Variation_32

    @classmethod
    def create(cls, arg : "RuleVariation_32.cv_arg") -> "RuleVariation_32":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_32:
        return self.arg # type: ignore

class Content_143(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RAMLD function"}

class RuleContent_143(RuleContentContextFree):
    cv_arg: TypeAlias = Content_143.cv_arg
    cv_content: TypeAlias = Content_143

    @property
    def content(self) -> Content_143:
        return self._get_content() # type: ignore

class Variation_416(Element):
    cv_arg: TypeAlias = RuleContent_143.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_143

    @classmethod
    def create(cls, arg: "Variation_416.cv_arg") -> "Variation_416":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_143:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_143:
        return self.rule.content

class RuleVariation_405(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_416.cv_arg
    cv_variation: TypeAlias = Variation_416

    @classmethod
    def create(cls, arg : "RuleVariation_405.cv_arg") -> "RuleVariation_405":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_416:
        return self.arg # type: ignore

class Content_142(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RAMHD function"}

class RuleContent_142(RuleContentContextFree):
    cv_arg: TypeAlias = Content_142.cv_arg
    cv_content: TypeAlias = Content_142

    @property
    def content(self) -> Content_142:
        return self._get_content() # type: ignore

class Variation_525(Element):
    cv_arg: TypeAlias = RuleContent_142.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_142

    @classmethod
    def create(cls, arg: "Variation_525.cv_arg") -> "Variation_525":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_142:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_142:
        return self.rule.content

class RuleVariation_514(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_525.cv_arg
    cv_variation: TypeAlias = Variation_525

    @classmethod
    def create(cls, arg : "RuleVariation_514.cv_arg") -> "RuleVariation_514":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_525:
        return self.arg # type: ignore

class Content_116(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "MSAW function"}

class RuleContent_116(RuleContentContextFree):
    cv_arg: TypeAlias = Content_116.cv_arg
    cv_content: TypeAlias = Content_116

    @property
    def content(self) -> Content_116:
        return self._get_content() # type: ignore

class Variation_627(Element):
    cv_arg: TypeAlias = RuleContent_116.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_116

    @classmethod
    def create(cls, arg: "Variation_627.cv_arg") -> "Variation_627":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_116:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_116:
        return self.rule.content

class RuleVariation_616(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_627.cv_arg
    cv_variation: TypeAlias = Variation_627

    @classmethod
    def create(cls, arg : "RuleVariation_616.cv_arg") -> "RuleVariation_616":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_627:
        return self.arg # type: ignore

class Content_83(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "APW function"}

class RuleContent_83(RuleContentContextFree):
    cv_arg: TypeAlias = Content_83.cv_arg
    cv_content: TypeAlias = Content_83

    @property
    def content(self) -> Content_83:
        return self._get_content() # type: ignore

class Variation_707(Element):
    cv_arg: TypeAlias = RuleContent_83.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_83

    @classmethod
    def create(cls, arg: "Variation_707.cv_arg") -> "Variation_707":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_83:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_83:
        return self.rule.content

class RuleVariation_696(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_707.cv_arg
    cv_variation: TypeAlias = Variation_707

    @classmethod
    def create(cls, arg : "RuleVariation_696.cv_arg") -> "RuleVariation_696":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_707:
        return self.arg # type: ignore

class Content_88(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CLAM function"}

class RuleContent_88(RuleContentContextFree):
    cv_arg: TypeAlias = Content_88.cv_arg
    cv_content: TypeAlias = Content_88

    @property
    def content(self) -> Content_88:
        return self._get_content() # type: ignore

class Variation_833(Element):
    cv_arg: TypeAlias = RuleContent_88.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_88

    @classmethod
    def create(cls, arg: "Variation_833.cv_arg") -> "Variation_833":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_88:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_88:
        return self.rule.content

class RuleVariation_803(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_833.cv_arg
    cv_variation: TypeAlias = Variation_833

    @classmethod
    def create(cls, arg : "RuleVariation_803.cv_arg") -> "RuleVariation_803":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_833:
        return self.arg # type: ignore

class Content_151(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "STCA function"}

class RuleContent_151(RuleContentContextFree):
    cv_arg: TypeAlias = Content_151.cv_arg
    cv_content: TypeAlias = Content_151

    @property
    def content(self) -> Content_151:
        return self._get_content() # type: ignore

class Variation_922(Element):
    cv_arg: TypeAlias = RuleContent_151.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_151

    @classmethod
    def create(cls, arg: "Variation_922.cv_arg") -> "Variation_922":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_151:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_151:
        return self.rule.content

class RuleVariation_892(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_922.cv_arg
    cv_variation: TypeAlias = Variation_922

    @classmethod
    def create(cls, arg : "RuleVariation_892.cv_arg") -> "RuleVariation_892":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_922:
        return self.arg # type: ignore

class Content_82(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "APM function"}

class RuleContent_82(RuleContentContextFree):
    cv_arg: TypeAlias = Content_82.cv_arg
    cv_content: TypeAlias = Content_82

    @property
    def content(self) -> Content_82:
        return self._get_content() # type: ignore

class Variation_24(Element):
    cv_arg: TypeAlias = RuleContent_82.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_82

    @classmethod
    def create(cls, arg: "Variation_24.cv_arg") -> "Variation_24":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_82:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_82:
        return self.rule.content

class RuleVariation_24(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_24.cv_arg
    cv_variation: TypeAlias = Variation_24

    @classmethod
    def create(cls, arg : "RuleVariation_24.cv_arg") -> "RuleVariation_24":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_24:
        return self.arg # type: ignore

class Content_144(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "RIMCA function"}

class RuleContent_144(RuleContentContextFree):
    cv_arg: TypeAlias = Content_144.cv_arg
    cv_content: TypeAlias = Content_144

    @property
    def content(self) -> Content_144:
        return self._get_content() # type: ignore

class Variation_417(Element):
    cv_arg: TypeAlias = RuleContent_144.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_144

    @classmethod
    def create(cls, arg: "Variation_417.cv_arg") -> "Variation_417":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_144:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_144:
        return self.rule.content

class RuleVariation_406(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_417.cv_arg
    cv_variation: TypeAlias = Variation_417

    @classmethod
    def create(cls, arg : "RuleVariation_406.cv_arg") -> "RuleVariation_406":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_417:
        return self.arg # type: ignore

class Content_80(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ACAS RA function"}

class RuleContent_80(RuleContentContextFree):
    cv_arg: TypeAlias = Content_80.cv_arg
    cv_content: TypeAlias = Content_80

    @property
    def content(self) -> Content_80:
        return self._get_content() # type: ignore

class Variation_515(Element):
    cv_arg: TypeAlias = RuleContent_80.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_80

    @classmethod
    def create(cls, arg: "Variation_515.cv_arg") -> "Variation_515":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_80:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_80:
        return self.rule.content

class RuleVariation_504(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_515.cv_arg
    cv_variation: TypeAlias = Variation_515

    @classmethod
    def create(cls, arg : "RuleVariation_504.cv_arg") -> "RuleVariation_504":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_515:
        return self.arg # type: ignore

class Content_133(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NTCA function"}

class RuleContent_133(RuleContentContextFree):
    cv_arg: TypeAlias = Content_133.cv_arg
    cv_content: TypeAlias = Content_133

    @property
    def content(self) -> Content_133:
        return self._get_content() # type: ignore

class Variation_632(Element):
    cv_arg: TypeAlias = RuleContent_133.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_133

    @classmethod
    def create(cls, arg: "Variation_632.cv_arg") -> "Variation_632":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_133:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_133:
        return self.rule.content

class RuleVariation_621(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_632.cv_arg
    cv_variation: TypeAlias = Variation_632

    @classmethod
    def create(cls, arg : "RuleVariation_621.cv_arg") -> "RuleVariation_621":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_632:
        return self.arg # type: ignore

class Content_154(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "System degraded"}

class RuleContent_154(RuleContentContextFree):
    cv_arg: TypeAlias = Content_154.cv_arg
    cv_content: TypeAlias = Content_154

    @property
    def content(self) -> Content_154:
        return self._get_content() # type: ignore

class Variation_713(Element):
    cv_arg: TypeAlias = RuleContent_154.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_154

    @classmethod
    def create(cls, arg: "Variation_713.cv_arg") -> "Variation_713":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_154:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_154:
        return self.rule.content

class RuleVariation_702(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_713.cv_arg
    cv_variation: TypeAlias = Variation_713

    @classmethod
    def create(cls, arg : "RuleVariation_702.cv_arg") -> "RuleVariation_702":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_713:
        return self.arg # type: ignore

class Content_137(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Overflow error"}

class RuleContent_137(RuleContentContextFree):
    cv_arg: TypeAlias = Content_137.cv_arg
    cv_content: TypeAlias = Content_137

    @property
    def content(self) -> Content_137:
        return self._get_content() # type: ignore

class Variation_837(Element):
    cv_arg: TypeAlias = RuleContent_137.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_137

    @classmethod
    def create(cls, arg: "Variation_837.cv_arg") -> "Variation_837":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_137:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_137:
        return self.rule.content

class RuleVariation_807(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_837.cv_arg
    cv_variation: TypeAlias = Variation_837

    @classmethod
    def create(cls, arg : "RuleVariation_807.cv_arg") -> "RuleVariation_807":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_837:
        return self.arg # type: ignore

class Content_139(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Overload error"}

class RuleContent_139(RuleContentContextFree):
    cv_arg: TypeAlias = Content_139.cv_arg
    cv_content: TypeAlias = Content_139

    @property
    def content(self) -> Content_139:
        return self._get_content() # type: ignore

class Variation_919(Element):
    cv_arg: TypeAlias = RuleContent_139.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_139

    @classmethod
    def create(cls, arg: "Variation_919.cv_arg") -> "Variation_919":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_139:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_139:
        return self.rule.content

class RuleVariation_889(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_919.cv_arg
    cv_variation: TypeAlias = Variation_919

    @classmethod
    def create(cls, arg : "RuleVariation_889.cv_arg") -> "RuleVariation_889":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_919:
        return self.arg # type: ignore

class Content_81(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "AIW function"}

class RuleContent_81(RuleContentContextFree):
    cv_arg: TypeAlias = Content_81.cv_arg
    cv_content: TypeAlias = Content_81

    @property
    def content(self) -> Content_81:
        return self._get_content() # type: ignore

class Variation_23(Element):
    cv_arg: TypeAlias = RuleContent_81.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_81

    @classmethod
    def create(cls, arg: "Variation_23.cv_arg") -> "Variation_23":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_81:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_81:
        return self.rule.content

class RuleVariation_23(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_23.cv_arg
    cv_variation: TypeAlias = Variation_23

    @classmethod
    def create(cls, arg : "RuleVariation_23.cv_arg") -> "RuleVariation_23":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_23:
        return self.arg # type: ignore

class Content_140(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "PAIW function"}

class RuleContent_140(RuleContentContextFree):
    cv_arg: TypeAlias = Content_140.cv_arg
    cv_content: TypeAlias = Content_140

    @property
    def content(self) -> Content_140:
        return self._get_content() # type: ignore

class Variation_415(Element):
    cv_arg: TypeAlias = RuleContent_140.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_140

    @classmethod
    def create(cls, arg: "Variation_415.cv_arg") -> "Variation_415":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_140:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_140:
        return self.rule.content

class RuleVariation_404(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_415.cv_arg
    cv_variation: TypeAlias = Variation_415

    @classmethod
    def create(cls, arg : "RuleVariation_404.cv_arg") -> "RuleVariation_404":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_415:
        return self.arg # type: ignore

class Content_135(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "OCAT function"}

class RuleContent_135(RuleContentContextFree):
    cv_arg: TypeAlias = Content_135.cv_arg
    cv_content: TypeAlias = Content_135

    @property
    def content(self) -> Content_135:
        return self._get_content() # type: ignore

class Variation_523(Element):
    cv_arg: TypeAlias = RuleContent_135.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_135

    @classmethod
    def create(cls, arg: "Variation_523.cv_arg") -> "Variation_523":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_135:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_135:
        return self.rule.content

class RuleVariation_512(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_523.cv_arg
    cv_variation: TypeAlias = Variation_523

    @classmethod
    def create(cls, arg : "RuleVariation_512.cv_arg") -> "RuleVariation_512":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_523:
        return self.arg # type: ignore

class Content_149(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "SAM function"}

class RuleContent_149(RuleContentContextFree):
    cv_arg: TypeAlias = Content_149.cv_arg
    cv_content: TypeAlias = Content_149

    @property
    def content(self) -> Content_149:
        return self._get_content() # type: ignore

class Variation_633(Element):
    cv_arg: TypeAlias = RuleContent_149.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_149

    @classmethod
    def create(cls, arg: "Variation_633.cv_arg") -> "Variation_633":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_149:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_149:
        return self.rule.content

class RuleVariation_622(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_633.cv_arg
    cv_variation: TypeAlias = Variation_633

    @classmethod
    def create(cls, arg : "RuleVariation_622.cv_arg") -> "RuleVariation_622":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_633:
        return self.arg # type: ignore

class Content_161(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VCD function"}

class RuleContent_161(RuleContentContextFree):
    cv_arg: TypeAlias = Content_161.cv_arg
    cv_content: TypeAlias = Content_161

    @property
    def content(self) -> Content_161:
        return self._get_content() # type: ignore

class Variation_714(Element):
    cv_arg: TypeAlias = RuleContent_161.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_161

    @classmethod
    def create(cls, arg: "Variation_714.cv_arg") -> "Variation_714":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_161:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_161:
        return self.rule.content

class RuleVariation_703(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_714.cv_arg
    cv_variation: TypeAlias = Variation_714

    @classmethod
    def create(cls, arg : "RuleVariation_703.cv_arg") -> "RuleVariation_703":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_714:
        return self.arg # type: ignore

class Content_87(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CHAM function"}

class RuleContent_87(RuleContentContextFree):
    cv_arg: TypeAlias = Content_87.cv_arg
    cv_content: TypeAlias = Content_87

    @property
    def content(self) -> Content_87:
        return self._get_content() # type: ignore

class Variation_832(Element):
    cv_arg: TypeAlias = RuleContent_87.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_87

    @classmethod
    def create(cls, arg: "Variation_832.cv_arg") -> "Variation_832":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_87:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_87:
        return self.rule.content

class RuleVariation_802(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_832.cv_arg
    cv_variation: TypeAlias = Variation_832

    @classmethod
    def create(cls, arg : "RuleVariation_802.cv_arg") -> "RuleVariation_802":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_832:
        return self.arg # type: ignore

class Content_94(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DSAM function"}

class RuleContent_94(RuleContentContextFree):
    cv_arg: TypeAlias = Content_94.cv_arg
    cv_content: TypeAlias = Content_94

    @property
    def content(self) -> Content_94:
        return self._get_content() # type: ignore

class Variation_913(Element):
    cv_arg: TypeAlias = RuleContent_94.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_94

    @classmethod
    def create(cls, arg: "Variation_913.cv_arg") -> "Variation_913":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_94:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_94:
        return self.rule.content

class RuleVariation_883(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_913.cv_arg
    cv_variation: TypeAlias = Variation_913

    @classmethod
    def create(cls, arg : "RuleVariation_883.cv_arg") -> "RuleVariation_883":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_913:
        return self.arg # type: ignore

class Content_91(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM ARR sub-function"}

class RuleContent_91(RuleContentContextFree):
    cv_arg: TypeAlias = Content_91.cv_arg
    cv_content: TypeAlias = Content_91

    @property
    def content(self) -> Content_91:
        return self._get_content() # type: ignore

class Variation_27(Element):
    cv_arg: TypeAlias = RuleContent_91.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_91

    @classmethod
    def create(cls, arg: "Variation_27.cv_arg") -> "Variation_27":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_91:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_91:
        return self.rule.content

class RuleVariation_27(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_27.cv_arg
    cv_variation: TypeAlias = Variation_27

    @classmethod
    def create(cls, arg : "RuleVariation_27.cv_arg") -> "RuleVariation_27":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_27:
        return self.arg # type: ignore

class Content_92(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM DEP sub-function"}

class RuleContent_92(RuleContentContextFree):
    cv_arg: TypeAlias = Content_92.cv_arg
    cv_content: TypeAlias = Content_92

    @property
    def content(self) -> Content_92:
        return self._get_content() # type: ignore

class Variation_406(Element):
    cv_arg: TypeAlias = RuleContent_92.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_92

    @classmethod
    def create(cls, arg: "Variation_406.cv_arg") -> "Variation_406":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_92:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_92:
        return self.rule.content

class RuleVariation_395(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_406.cv_arg
    cv_variation: TypeAlias = Variation_406

    @classmethod
    def create(cls, arg : "RuleVariation_395.cv_arg") -> "RuleVariation_395":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_406:
        return self.arg # type: ignore

class Content_93(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "DBPSM TL sub-function"}

class RuleContent_93(RuleContentContextFree):
    cv_arg: TypeAlias = Content_93.cv_arg
    cv_content: TypeAlias = Content_93

    @property
    def content(self) -> Content_93:
        return self._get_content() # type: ignore

class Variation_517(Element):
    cv_arg: TypeAlias = RuleContent_93.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_93

    @classmethod
    def create(cls, arg: "Variation_517.cv_arg") -> "Variation_517":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_93:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_93:
        return self.rule.content

class RuleVariation_506(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_517.cv_arg
    cv_variation: TypeAlias = Variation_517

    @classmethod
    def create(cls, arg : "RuleVariation_506.cv_arg") -> "RuleVariation_506":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_517:
        return self.arg # type: ignore

class Content_163(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM CRM sub-function"}

class RuleContent_163(RuleContentContextFree):
    cv_arg: TypeAlias = Content_163.cv_arg
    cv_content: TypeAlias = Content_163

    @property
    def content(self) -> Content_163:
        return self._get_content() # type: ignore

class Variation_635(Element):
    cv_arg: TypeAlias = RuleContent_163.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_163

    @classmethod
    def create(cls, arg: "Variation_635.cv_arg") -> "Variation_635":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_163:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_163:
        return self.rule.content

class RuleVariation_624(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_635.cv_arg
    cv_variation: TypeAlias = Variation_635

    @classmethod
    def create(cls, arg : "RuleVariation_624.cv_arg") -> "RuleVariation_624":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_635:
        return self.arg # type: ignore

class Content_165(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM VTM sub-function"}

class RuleContent_165(RuleContentContextFree):
    cv_arg: TypeAlias = Content_165.cv_arg
    cv_content: TypeAlias = Content_165

    @property
    def content(self) -> Content_165:
        return self._get_content() # type: ignore

class Variation_716(Element):
    cv_arg: TypeAlias = RuleContent_165.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_165

    @classmethod
    def create(cls, arg: "Variation_716.cv_arg") -> "Variation_716":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_165:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_165:
        return self.rule.content

class RuleVariation_705(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_716.cv_arg
    cv_variation: TypeAlias = Variation_716

    @classmethod
    def create(cls, arg : "RuleVariation_705.cv_arg") -> "RuleVariation_705":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_716:
        return self.arg # type: ignore

class Content_164(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VRAM VRM sub-function"}

class RuleContent_164(RuleContentContextFree):
    cv_arg: TypeAlias = Content_164.cv_arg
    cv_content: TypeAlias = Content_164

    @property
    def content(self) -> Content_164:
        return self._get_content() # type: ignore

class Variation_844(Element):
    cv_arg: TypeAlias = RuleContent_164.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_164

    @classmethod
    def create(cls, arg: "Variation_844.cv_arg") -> "Variation_844":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_164:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_164:
        return self.rule.content

class RuleVariation_814(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_844.cv_arg
    cv_variation: TypeAlias = Variation_844

    @classmethod
    def create(cls, arg : "RuleVariation_814.cv_arg") -> "RuleVariation_814":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_844:
        return self.arg # type: ignore

class Content_102(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM HD sub-function"}

class RuleContent_102(RuleContentContextFree):
    cv_arg: TypeAlias = Content_102.cv_arg
    cv_content: TypeAlias = Content_102

    @property
    def content(self) -> Content_102:
        return self._get_content() # type: ignore

class Variation_916(Element):
    cv_arg: TypeAlias = RuleContent_102.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_102

    @classmethod
    def create(cls, arg: "Variation_916.cv_arg") -> "Variation_916":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_102:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_102:
        return self.rule.content

class RuleVariation_886(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_916.cv_arg
    cv_variation: TypeAlias = Variation_916

    @classmethod
    def create(cls, arg : "RuleVariation_886.cv_arg") -> "RuleVariation_886":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_916:
        return self.arg # type: ignore

class Content_103(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM RD sub-function"}

class RuleContent_103(RuleContentContextFree):
    cv_arg: TypeAlias = Content_103.cv_arg
    cv_content: TypeAlias = Content_103

    @property
    def content(self) -> Content_103:
        return self._get_content() # type: ignore

class Variation_29(Element):
    cv_arg: TypeAlias = RuleContent_103.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_103

    @classmethod
    def create(cls, arg: "Variation_29.cv_arg") -> "Variation_29":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_103:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_103:
        return self.rule.content

class RuleVariation_29(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_29.cv_arg
    cv_variation: TypeAlias = Variation_29

    @classmethod
    def create(cls, arg : "RuleVariation_29.cv_arg") -> "RuleVariation_29":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_29:
        return self.arg # type: ignore

class Content_104(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HAM VD sub-function"}

class RuleContent_104(RuleContentContextFree):
    cv_arg: TypeAlias = Content_104.cv_arg
    cv_content: TypeAlias = Content_104

    @property
    def content(self) -> Content_104:
        return self._get_content() # type: ignore

class Variation_409(Element):
    cv_arg: TypeAlias = RuleContent_104.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_104

    @classmethod
    def create(cls, arg: "Variation_409.cv_arg") -> "Variation_409":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_104:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_104:
        return self.rule.content

class RuleVariation_398(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_409.cv_arg
    cv_variation: TypeAlias = Variation_409

    @classmethod
    def create(cls, arg : "RuleVariation_398.cv_arg") -> "RuleVariation_398":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_409:
        return self.arg # type: ignore

class Content_105(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "HVI function"}

class RuleContent_105(RuleContentContextFree):
    cv_arg: TypeAlias = Content_105.cv_arg
    cv_content: TypeAlias = Content_105

    @property
    def content(self) -> Content_105:
        return self._get_content() # type: ignore

class Variation_519(Element):
    cv_arg: TypeAlias = RuleContent_105.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_105

    @classmethod
    def create(cls, arg: "Variation_519.cv_arg") -> "Variation_519":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_105:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_105:
        return self.rule.content

class RuleVariation_508(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_519.cv_arg
    cv_variation: TypeAlias = Variation_519

    @classmethod
    def create(cls, arg : "RuleVariation_508.cv_arg") -> "RuleVariation_508":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_519:
        return self.arg # type: ignore

class Content_112(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "LTW function"}

class RuleContent_112(RuleContentContextFree):
    cv_arg: TypeAlias = Content_112.cv_arg
    cv_content: TypeAlias = Content_112

    @property
    def content(self) -> Content_112:
        return self._get_content() # type: ignore

class Variation_626(Element):
    cv_arg: TypeAlias = RuleContent_112.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_112

    @classmethod
    def create(cls, arg: "Variation_626.cv_arg") -> "Variation_626":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_112:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_112:
        return self.rule.content

class RuleVariation_615(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_626.cv_arg
    cv_variation: TypeAlias = Variation_626

    @classmethod
    def create(cls, arg : "RuleVariation_615.cv_arg") -> "RuleVariation_615":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_626:
        return self.arg # type: ignore

class Content_162(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "VPM function"}

class RuleContent_162(RuleContentContextFree):
    cv_arg: TypeAlias = Content_162.cv_arg
    cv_content: TypeAlias = Content_162

    @property
    def content(self) -> Content_162:
        return self._get_content() # type: ignore

class Variation_715(Element):
    cv_arg: TypeAlias = RuleContent_162.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_162

    @classmethod
    def create(cls, arg: "Variation_715.cv_arg") -> "Variation_715":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_162:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_162:
        return self.rule.content

class RuleVariation_704(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_715.cv_arg
    cv_variation: TypeAlias = Variation_715

    @classmethod
    def create(cls, arg : "RuleVariation_704.cv_arg") -> "RuleVariation_704":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_715:
        return self.arg # type: ignore

class Content_155(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "TTA function"}

class RuleContent_155(RuleContentContextFree):
    cv_arg: TypeAlias = Content_155.cv_arg
    cv_content: TypeAlias = Content_155

    @property
    def content(self) -> Content_155:
        return self._get_content() # type: ignore

class Variation_842(Element):
    cv_arg: TypeAlias = RuleContent_155.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_155

    @classmethod
    def create(cls, arg: "Variation_842.cv_arg") -> "Variation_842":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_155:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_155:
        return self.rule.content

class RuleVariation_812(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_842.cv_arg
    cv_variation: TypeAlias = Variation_842

    @classmethod
    def create(cls, arg : "RuleVariation_812.cv_arg") -> "RuleVariation_812":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_842:
        return self.arg # type: ignore

class Content_89(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CRA function"}

class RuleContent_89(RuleContentContextFree):
    cv_arg: TypeAlias = Content_89.cv_arg
    cv_content: TypeAlias = Content_89

    @property
    def content(self) -> Content_89:
        return self._get_content() # type: ignore

class Variation_911(Element):
    cv_arg: TypeAlias = RuleContent_89.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_89

    @classmethod
    def create(cls, arg: "Variation_911.cv_arg") -> "Variation_911":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_89:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_89:
        return self.rule.content

class RuleVariation_881(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_911.cv_arg
    cv_variation: TypeAlias = Variation_911

    @classmethod
    def create(cls, arg : "RuleVariation_881.cv_arg") -> "RuleVariation_881":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_911:
        return self.arg # type: ignore

class Content_84(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ASM sub-function"}

class RuleContent_84(RuleContentContextFree):
    cv_arg: TypeAlias = Content_84.cv_arg
    cv_content: TypeAlias = Content_84

    @property
    def content(self) -> Content_84:
        return self._get_content() # type: ignore

class Variation_25(Element):
    cv_arg: TypeAlias = RuleContent_84.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_84

    @classmethod
    def create(cls, arg: "Variation_25.cv_arg") -> "Variation_25":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_84:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_84:
        return self.rule.content

class RuleVariation_25(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_25.cv_arg
    cv_variation: TypeAlias = Variation_25

    @classmethod
    def create(cls, arg : "RuleVariation_25.cv_arg") -> "RuleVariation_25":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_25:
        return self.arg # type: ignore

class Content_107(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "IAVM sub-function"}

class RuleContent_107(RuleContentContextFree):
    cv_arg: TypeAlias = Content_107.cv_arg
    cv_content: TypeAlias = Content_107

    @property
    def content(self) -> Content_107:
        return self._get_content() # type: ignore

class Variation_410(Element):
    cv_arg: TypeAlias = RuleContent_107.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_107

    @classmethod
    def create(cls, arg: "Variation_410.cv_arg") -> "Variation_410":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_107:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_107:
        return self.rule.content

class RuleVariation_399(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_410.cv_arg
    cv_variation: TypeAlias = Variation_410

    @classmethod
    def create(cls, arg : "RuleVariation_399.cv_arg") -> "RuleVariation_399":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_410:
        return self.arg # type: ignore

class Content_97(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "FTD Function"}

class RuleContent_97(RuleContentContextFree):
    cv_arg: TypeAlias = Content_97.cv_arg
    cv_content: TypeAlias = Content_97

    @property
    def content(self) -> Content_97:
        return self._get_content() # type: ignore

class Variation_518(Element):
    cv_arg: TypeAlias = RuleContent_97.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_97

    @classmethod
    def create(cls, arg: "Variation_518.cv_arg") -> "Variation_518":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_97:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_97:
        return self.rule.content

class RuleVariation_507(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_518.cv_arg
    cv_variation: TypeAlias = Variation_518

    @classmethod
    def create(cls, arg : "RuleVariation_507.cv_arg") -> "RuleVariation_507":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_518:
        return self.arg # type: ignore

class Content_109(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ITD function"}

class RuleContent_109(RuleContentContextFree):
    cv_arg: TypeAlias = Content_109.cv_arg
    cv_content: TypeAlias = Content_109

    @property
    def content(self) -> Content_109:
        return self._get_content() # type: ignore

class Variation_624(Element):
    cv_arg: TypeAlias = RuleContent_109.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_109

    @classmethod
    def create(cls, arg: "Variation_624.cv_arg") -> "Variation_624":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_109:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_109:
        return self.rule.content

class RuleVariation_613(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_624.cv_arg
    cv_variation: TypeAlias = Variation_624

    @classmethod
    def create(cls, arg : "RuleVariation_613.cv_arg") -> "RuleVariation_613":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_624:
        return self.arg # type: ignore

class Content_108(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "IIA function"}

class RuleContent_108(RuleContentContextFree):
    cv_arg: TypeAlias = Content_108.cv_arg
    cv_content: TypeAlias = Content_108

    @property
    def content(self) -> Content_108:
        return self._get_content() # type: ignore

class Variation_709(Element):
    cv_arg: TypeAlias = RuleContent_108.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_108

    @classmethod
    def create(cls, arg: "Variation_709.cv_arg") -> "Variation_709":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_108:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_108:
        return self.rule.content

class RuleVariation_698(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_709.cv_arg
    cv_variation: TypeAlias = Variation_709

    @classmethod
    def create(cls, arg : "RuleVariation_698.cv_arg") -> "RuleVariation_698":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_709:
        return self.arg # type: ignore

class Content_150(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "SQW function"}

class RuleContent_150(RuleContentContextFree):
    cv_arg: TypeAlias = Content_150.cv_arg
    cv_content: TypeAlias = Content_150

    @property
    def content(self) -> Content_150:
        return self._get_content() # type: ignore

class Variation_839(Element):
    cv_arg: TypeAlias = RuleContent_150.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_150

    @classmethod
    def create(cls, arg: "Variation_839.cv_arg") -> "Variation_839":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_150:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_150:
        return self.rule.content

class RuleVariation_809(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_839.cv_arg
    cv_variation: TypeAlias = Variation_839

    @classmethod
    def create(cls, arg : "RuleVariation_809.cv_arg") -> "RuleVariation_809":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_839:
        return self.arg # type: ignore

class Content_90(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CUW function"}

class RuleContent_90(RuleContentContextFree):
    cv_arg: TypeAlias = Content_90.cv_arg
    cv_content: TypeAlias = Content_90

    @property
    def content(self) -> Content_90:
        return self._get_content() # type: ignore

class Variation_912(Element):
    cv_arg: TypeAlias = RuleContent_90.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_90

    @classmethod
    def create(cls, arg: "Variation_912.cv_arg") -> "Variation_912":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_90:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_90:
        return self.rule.content

class RuleVariation_882(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_912.cv_arg
    cv_variation: TypeAlias = Variation_912

    @classmethod
    def create(cls, arg : "RuleVariation_882.cv_arg") -> "RuleVariation_882":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_912:
        return self.arg # type: ignore

class Content_86(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "CATC function"}

class RuleContent_86(RuleContentContextFree):
    cv_arg: TypeAlias = Content_86.cv_arg
    cv_content: TypeAlias = Content_86

    @property
    def content(self) -> Content_86:
        return self._get_content() # type: ignore

class Variation_26(Element):
    cv_arg: TypeAlias = RuleContent_86.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_86

    @classmethod
    def create(cls, arg: "Variation_26.cv_arg") -> "Variation_26":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_86:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_86:
        return self.rule.content

class RuleVariation_26(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_26.cv_arg
    cv_variation: TypeAlias = Variation_26

    @classmethod
    def create(cls, arg : "RuleVariation_26.cv_arg") -> "RuleVariation_26":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_26:
        return self.arg # type: ignore

class Content_130(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOCLR sub-function"}

class RuleContent_130(RuleContentContextFree):
    cv_arg: TypeAlias = Content_130.cv_arg
    cv_content: TypeAlias = Content_130

    @property
    def content(self) -> Content_130:
        return self._get_content() # type: ignore

class Variation_414(Element):
    cv_arg: TypeAlias = RuleContent_130.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_130

    @classmethod
    def create(cls, arg: "Variation_414.cv_arg") -> "Variation_414":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_130:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_130:
        return self.rule.content

class RuleVariation_403(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_414.cv_arg
    cv_variation: TypeAlias = Variation_414

    @classmethod
    def create(cls, arg : "RuleVariation_403.cv_arg") -> "RuleVariation_403":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_414:
        return self.arg # type: ignore

class Content_132(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOMOV Function"}

class RuleContent_132(RuleContentContextFree):
    cv_arg: TypeAlias = Content_132.cv_arg
    cv_content: TypeAlias = Content_132

    @property
    def content(self) -> Content_132:
        return self._get_content() # type: ignore

class Variation_522(Element):
    cv_arg: TypeAlias = RuleContent_132.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_132

    @classmethod
    def create(cls, arg: "Variation_522.cv_arg") -> "Variation_522":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_132:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_132:
        return self.rule.content

class RuleVariation_511(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_522.cv_arg
    cv_variation: TypeAlias = Variation_522

    @classmethod
    def create(cls, arg : "RuleVariation_511.cv_arg") -> "RuleVariation_511":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_522:
        return self.arg # type: ignore

class Content_131(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "NOH function"}

class RuleContent_131(RuleContentContextFree):
    cv_arg: TypeAlias = Content_131.cv_arg
    cv_content: TypeAlias = Content_131

    @property
    def content(self) -> Content_131:
        return self._get_content() # type: ignore

class Variation_631(Element):
    cv_arg: TypeAlias = RuleContent_131.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_131

    @classmethod
    def create(cls, arg: "Variation_631.cv_arg") -> "Variation_631":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_131:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_131:
        return self.rule.content

class RuleVariation_620(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_631.cv_arg
    cv_variation: TypeAlias = Variation_631

    @classmethod
    def create(cls, arg : "RuleVariation_620.cv_arg") -> "RuleVariation_620":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_631:
        return self.arg # type: ignore

class Content_166(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "WRTY function"}

class RuleContent_166(RuleContentContextFree):
    cv_arg: TypeAlias = Content_166.cv_arg
    cv_content: TypeAlias = Content_166

    @property
    def content(self) -> Content_166:
        return self._get_content() # type: ignore

class Variation_717(Element):
    cv_arg: TypeAlias = RuleContent_166.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_166

    @classmethod
    def create(cls, arg: "Variation_717.cv_arg") -> "Variation_717":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_166:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_166:
        return self.rule.content

class RuleVariation_706(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_717.cv_arg
    cv_variation: TypeAlias = Variation_717

    @classmethod
    def create(cls, arg : "RuleVariation_706.cv_arg") -> "RuleVariation_706":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_717:
        return self.arg # type: ignore

class Content_152(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "STOCC function"}

class RuleContent_152(RuleContentContextFree):
    cv_arg: TypeAlias = Content_152.cv_arg
    cv_content: TypeAlias = Content_152

    @property
    def content(self) -> Content_152:
        return self._get_content() # type: ignore

class Variation_840(Element):
    cv_arg: TypeAlias = RuleContent_152.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_152

    @classmethod
    def create(cls, arg: "Variation_840.cv_arg") -> "Variation_840":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_152:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_152:
        return self.rule.content

class RuleVariation_810(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_840.cv_arg
    cv_variation: TypeAlias = Variation_840

    @classmethod
    def create(cls, arg : "RuleVariation_810.cv_arg") -> "RuleVariation_810":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_840:
        return self.arg # type: ignore

class Content_136(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "ONGOING function"}

class RuleContent_136(RuleContentContextFree):
    cv_arg: TypeAlias = Content_136.cv_arg
    cv_content: TypeAlias = Content_136

    @property
    def content(self) -> Content_136:
        return self._get_content() # type: ignore

class Variation_918(Element):
    cv_arg: TypeAlias = RuleContent_136.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_136

    @classmethod
    def create(cls, arg: "Variation_918.cv_arg") -> "Variation_918":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_136:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_136:
        return self.rule.content

class RuleVariation_888(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_918.cv_arg
    cv_variation: TypeAlias = Variation_918

    @classmethod
    def create(cls, arg : "RuleVariation_888.cv_arg") -> "RuleVariation_888":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_918:
        return self.arg # type: ignore

class NonSpare_1323(NonSpare):
    cv_arg: TypeAlias = RuleVariation_32.cv_arg
    cv_name = "MRVA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_32

    @classmethod
    def create(cls, arg : "NonSpare_1323.cv_arg") -> "NonSpare_1323":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_32:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_32:
        return self.rule.variation

class Item_586(Item):
    cv_arg: TypeAlias = NonSpare_1323.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1323

    @classmethod
    def create(cls, arg : "Item_586.cv_arg") -> "Item_586":
        return cls._create(arg) # type: ignore

class NonSpare_1553(NonSpare):
    cv_arg: TypeAlias = RuleVariation_405.cv_arg
    cv_name = "RAMLD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_405

    @classmethod
    def create(cls, arg : "NonSpare_1553.cv_arg") -> "NonSpare_1553":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_405:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_416:
        return self.rule.variation

class Item_780(Item):
    cv_arg: TypeAlias = NonSpare_1553.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1553

    @classmethod
    def create(cls, arg : "Item_780.cv_arg") -> "Item_780":
        return cls._create(arg) # type: ignore

class NonSpare_1552(NonSpare):
    cv_arg: TypeAlias = RuleVariation_514.cv_arg
    cv_name = "RAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_514

    @classmethod
    def create(cls, arg : "NonSpare_1552.cv_arg") -> "NonSpare_1552":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_514:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_525:
        return self.rule.variation

class Item_779(Item):
    cv_arg: TypeAlias = NonSpare_1552.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1552

    @classmethod
    def create(cls, arg : "Item_779.cv_arg") -> "Item_779":
        return cls._create(arg) # type: ignore

class NonSpare_1328(NonSpare):
    cv_arg: TypeAlias = RuleVariation_616.cv_arg
    cv_name = "MSAW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_616

    @classmethod
    def create(cls, arg : "NonSpare_1328.cv_arg") -> "NonSpare_1328":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_616:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_627:
        return self.rule.variation

class Item_589(Item):
    cv_arg: TypeAlias = NonSpare_1328.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1328

    @classmethod
    def create(cls, arg : "Item_589.cv_arg") -> "Item_589":
        return cls._create(arg) # type: ignore

class NonSpare_621(NonSpare):
    cv_arg: TypeAlias = RuleVariation_696.cv_arg
    cv_name = "APW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_696

    @classmethod
    def create(cls, arg : "NonSpare_621.cv_arg") -> "NonSpare_621":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_696:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_707:
        return self.rule.variation

class Item_78(Item):
    cv_arg: TypeAlias = NonSpare_621.cv_arg
    cv_non_spare: TypeAlias = NonSpare_621

    @classmethod
    def create(cls, arg : "Item_78.cv_arg") -> "Item_78":
        return cls._create(arg) # type: ignore

class NonSpare_747(NonSpare):
    cv_arg: TypeAlias = RuleVariation_803.cv_arg
    cv_name = "CLAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_803

    @classmethod
    def create(cls, arg : "NonSpare_747.cv_arg") -> "NonSpare_747":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_803:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_833:
        return self.rule.variation

class Item_163(Item):
    cv_arg: TypeAlias = NonSpare_747.cv_arg
    cv_non_spare: TypeAlias = NonSpare_747

    @classmethod
    def create(cls, arg : "Item_163.cv_arg") -> "Item_163":
        return cls._create(arg) # type: ignore

class NonSpare_1794(NonSpare):
    cv_arg: TypeAlias = RuleVariation_892.cv_arg
    cv_name = "STCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_892

    @classmethod
    def create(cls, arg : "NonSpare_1794.cv_arg") -> "NonSpare_1794":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_892:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_922:
        return self.rule.variation

class Item_952(Item):
    cv_arg: TypeAlias = NonSpare_1794.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1794

    @classmethod
    def create(cls, arg : "Item_952.cv_arg") -> "Item_952":
        return cls._create(arg) # type: ignore

class NonSpare_620(NonSpare):
    cv_arg: TypeAlias = RuleVariation_24.cv_arg
    cv_name = "APM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_24

    @classmethod
    def create(cls, arg : "NonSpare_620.cv_arg") -> "NonSpare_620":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_24:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_24:
        return self.rule.variation

class Item_77(Item):
    cv_arg: TypeAlias = NonSpare_620.cv_arg
    cv_non_spare: TypeAlias = NonSpare_620

    @classmethod
    def create(cls, arg : "Item_77.cv_arg") -> "Item_77":
        return cls._create(arg) # type: ignore

class NonSpare_1603(NonSpare):
    cv_arg: TypeAlias = RuleVariation_406.cv_arg
    cv_name = "RIMCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_406

    @classmethod
    def create(cls, arg : "NonSpare_1603.cv_arg") -> "NonSpare_1603":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_406:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_417:
        return self.rule.variation

class Item_825(Item):
    cv_arg: TypeAlias = NonSpare_1603.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1603

    @classmethod
    def create(cls, arg : "Item_825.cv_arg") -> "Item_825":
        return cls._create(arg) # type: ignore

class NonSpare_562(NonSpare):
    cv_arg: TypeAlias = RuleVariation_504.cv_arg
    cv_name = "ACASRA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_504

    @classmethod
    def create(cls, arg : "NonSpare_562.cv_arg") -> "NonSpare_562":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_504:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_515:
        return self.rule.variation

class Item_40(Item):
    cv_arg: TypeAlias = NonSpare_562.cv_arg
    cv_non_spare: TypeAlias = NonSpare_562

    @classmethod
    def create(cls, arg : "Item_40.cv_arg") -> "Item_40":
        return cls._create(arg) # type: ignore

class NonSpare_1387(NonSpare):
    cv_arg: TypeAlias = RuleVariation_621.cv_arg
    cv_name = "NTCA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_621

    @classmethod
    def create(cls, arg : "NonSpare_1387.cv_arg") -> "NonSpare_1387":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_621:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_632:
        return self.rule.variation

class Item_643(Item):
    cv_arg: TypeAlias = NonSpare_1387.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1387

    @classmethod
    def create(cls, arg : "Item_643.cv_arg") -> "Item_643":
        return cls._create(arg) # type: ignore

class NonSpare_888(NonSpare):
    cv_arg: TypeAlias = RuleVariation_702.cv_arg
    cv_name = "DG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_702

    @classmethod
    def create(cls, arg : "NonSpare_888.cv_arg") -> "NonSpare_888":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_702:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_713:
        return self.rule.variation

class Item_262(Item):
    cv_arg: TypeAlias = NonSpare_888.cv_arg
    cv_non_spare: TypeAlias = NonSpare_888

    @classmethod
    def create(cls, arg : "Item_262.cv_arg") -> "Item_262":
        return cls._create(arg) # type: ignore

class NonSpare_1402(NonSpare):
    cv_arg: TypeAlias = RuleVariation_807.cv_arg
    cv_name = "OF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_807

    @classmethod
    def create(cls, arg : "NonSpare_1402.cv_arg") -> "NonSpare_1402":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_807:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_837:
        return self.rule.variation

class Item_658(Item):
    cv_arg: TypeAlias = NonSpare_1402.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1402

    @classmethod
    def create(cls, arg : "Item_658.cv_arg") -> "Item_658":
        return cls._create(arg) # type: ignore

class NonSpare_1403(NonSpare):
    cv_arg: TypeAlias = RuleVariation_889.cv_arg
    cv_name = "OL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_889

    @classmethod
    def create(cls, arg : "NonSpare_1403.cv_arg") -> "NonSpare_1403":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_889:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_919:
        return self.rule.variation

class Item_659(Item):
    cv_arg: TypeAlias = NonSpare_1403.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1403

    @classmethod
    def create(cls, arg : "Item_659.cv_arg") -> "Item_659":
        return cls._create(arg) # type: ignore

class NonSpare_591(NonSpare):
    cv_arg: TypeAlias = RuleVariation_23.cv_arg
    cv_name = "AIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_23

    @classmethod
    def create(cls, arg : "NonSpare_591.cv_arg") -> "NonSpare_591":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_23:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_23:
        return self.rule.variation

class Item_56(Item):
    cv_arg: TypeAlias = NonSpare_591.cv_arg
    cv_non_spare: TypeAlias = NonSpare_591

    @classmethod
    def create(cls, arg : "Item_56.cv_arg") -> "Item_56":
        return cls._create(arg) # type: ignore

class NonSpare_1427(NonSpare):
    cv_arg: TypeAlias = RuleVariation_404.cv_arg
    cv_name = "PAIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_404

    @classmethod
    def create(cls, arg : "NonSpare_1427.cv_arg") -> "NonSpare_1427":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_404:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_415:
        return self.rule.variation

class Item_681(Item):
    cv_arg: TypeAlias = NonSpare_1427.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1427

    @classmethod
    def create(cls, arg : "Item_681.cv_arg") -> "Item_681":
        return cls._create(arg) # type: ignore

class NonSpare_1396(NonSpare):
    cv_arg: TypeAlias = RuleVariation_512.cv_arg
    cv_name = "OCAT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_512

    @classmethod
    def create(cls, arg : "NonSpare_1396.cv_arg") -> "NonSpare_1396":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_512:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_523:
        return self.rule.variation

class Item_652(Item):
    cv_arg: TypeAlias = NonSpare_1396.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1396

    @classmethod
    def create(cls, arg : "Item_652.cv_arg") -> "Item_652":
        return cls._create(arg) # type: ignore

class NonSpare_1668(NonSpare):
    cv_arg: TypeAlias = RuleVariation_622.cv_arg
    cv_name = "SAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_622

    @classmethod
    def create(cls, arg : "NonSpare_1668.cv_arg") -> "NonSpare_1668":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_622:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_633:
        return self.rule.variation

class Item_863(Item):
    cv_arg: TypeAlias = NonSpare_1668.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1668

    @classmethod
    def create(cls, arg : "Item_863.cv_arg") -> "Item_863":
        return cls._create(arg) # type: ignore

class NonSpare_2039(NonSpare):
    cv_arg: TypeAlias = RuleVariation_703.cv_arg
    cv_name = "VCD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_703

    @classmethod
    def create(cls, arg : "NonSpare_2039.cv_arg") -> "NonSpare_2039":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_703:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_714:
        return self.rule.variation

class Item_1145(Item):
    cv_arg: TypeAlias = NonSpare_2039.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2039

    @classmethod
    def create(cls, arg : "Item_1145.cv_arg") -> "Item_1145":
        return cls._create(arg) # type: ignore

class NonSpare_737(NonSpare):
    cv_arg: TypeAlias = RuleVariation_802.cv_arg
    cv_name = "CHAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_802

    @classmethod
    def create(cls, arg : "NonSpare_737.cv_arg") -> "NonSpare_737":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_802:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_832:
        return self.rule.variation

class Item_156(Item):
    cv_arg: TypeAlias = NonSpare_737.cv_arg
    cv_non_spare: TypeAlias = NonSpare_737

    @classmethod
    def create(cls, arg : "Item_156.cv_arg") -> "Item_156":
        return cls._create(arg) # type: ignore

class NonSpare_908(NonSpare):
    cv_arg: TypeAlias = RuleVariation_883.cv_arg
    cv_name = "DSAM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_883

    @classmethod
    def create(cls, arg : "NonSpare_908.cv_arg") -> "NonSpare_908":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_883:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_913:
        return self.rule.variation

class Item_278(Item):
    cv_arg: TypeAlias = NonSpare_908.cv_arg
    cv_non_spare: TypeAlias = NonSpare_908

    @classmethod
    def create(cls, arg : "Item_278.cv_arg") -> "Item_278":
        return cls._create(arg) # type: ignore

class NonSpare_870(NonSpare):
    cv_arg: TypeAlias = RuleVariation_27.cv_arg
    cv_name = "DBPSMARR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_27

    @classmethod
    def create(cls, arg : "NonSpare_870.cv_arg") -> "NonSpare_870":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_27:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_27:
        return self.rule.variation

class Item_245(Item):
    cv_arg: TypeAlias = NonSpare_870.cv_arg
    cv_non_spare: TypeAlias = NonSpare_870

    @classmethod
    def create(cls, arg : "Item_245.cv_arg") -> "Item_245":
        return cls._create(arg) # type: ignore

class NonSpare_872(NonSpare):
    cv_arg: TypeAlias = RuleVariation_395.cv_arg
    cv_name = "DBPSMDEP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_395

    @classmethod
    def create(cls, arg : "NonSpare_872.cv_arg") -> "NonSpare_872":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_395:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_406:
        return self.rule.variation

class Item_247(Item):
    cv_arg: TypeAlias = NonSpare_872.cv_arg
    cv_non_spare: TypeAlias = NonSpare_872

    @classmethod
    def create(cls, arg : "Item_247.cv_arg") -> "Item_247":
        return cls._create(arg) # type: ignore

class NonSpare_874(NonSpare):
    cv_arg: TypeAlias = RuleVariation_506.cv_arg
    cv_name = "DBPSMTL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_506

    @classmethod
    def create(cls, arg : "NonSpare_874.cv_arg") -> "NonSpare_874":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_506:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_517:
        return self.rule.variation

class Item_249(Item):
    cv_arg: TypeAlias = NonSpare_874.cv_arg
    cv_non_spare: TypeAlias = NonSpare_874

    @classmethod
    def create(cls, arg : "Item_249.cv_arg") -> "Item_249":
        return cls._create(arg) # type: ignore

class NonSpare_2051(NonSpare):
    cv_arg: TypeAlias = RuleVariation_624.cv_arg
    cv_name = "VRAMCRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_624

    @classmethod
    def create(cls, arg : "NonSpare_2051.cv_arg") -> "NonSpare_2051":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_624:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_635:
        return self.rule.variation

class Item_1156(Item):
    cv_arg: TypeAlias = NonSpare_2051.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2051

    @classmethod
    def create(cls, arg : "Item_1156.cv_arg") -> "Item_1156":
        return cls._create(arg) # type: ignore

class NonSpare_2054(NonSpare):
    cv_arg: TypeAlias = RuleVariation_705.cv_arg
    cv_name = "VRAMVTM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_705

    @classmethod
    def create(cls, arg : "NonSpare_2054.cv_arg") -> "NonSpare_2054":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_705:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_716:
        return self.rule.variation

class Item_1159(Item):
    cv_arg: TypeAlias = NonSpare_2054.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2054

    @classmethod
    def create(cls, arg : "Item_1159.cv_arg") -> "Item_1159":
        return cls._create(arg) # type: ignore

class NonSpare_2053(NonSpare):
    cv_arg: TypeAlias = RuleVariation_814.cv_arg
    cv_name = "VRAMVRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_814

    @classmethod
    def create(cls, arg : "NonSpare_2053.cv_arg") -> "NonSpare_2053":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_814:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_844:
        return self.rule.variation

class Item_1158(Item):
    cv_arg: TypeAlias = NonSpare_2053.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2053

    @classmethod
    def create(cls, arg : "Item_1158.cv_arg") -> "Item_1158":
        return cls._create(arg) # type: ignore

class NonSpare_1059(NonSpare):
    cv_arg: TypeAlias = RuleVariation_886.cv_arg
    cv_name = "HAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_886

    @classmethod
    def create(cls, arg : "NonSpare_1059.cv_arg") -> "NonSpare_1059":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_886:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_916:
        return self.rule.variation

class Item_384(Item):
    cv_arg: TypeAlias = NonSpare_1059.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1059

    @classmethod
    def create(cls, arg : "Item_384.cv_arg") -> "Item_384":
        return cls._create(arg) # type: ignore

class NonSpare_1061(NonSpare):
    cv_arg: TypeAlias = RuleVariation_29.cv_arg
    cv_name = "HAMRD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_29

    @classmethod
    def create(cls, arg : "NonSpare_1061.cv_arg") -> "NonSpare_1061":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_29:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_29:
        return self.rule.variation

class Item_386(Item):
    cv_arg: TypeAlias = NonSpare_1061.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1061

    @classmethod
    def create(cls, arg : "Item_386.cv_arg") -> "Item_386":
        return cls._create(arg) # type: ignore

class NonSpare_1063(NonSpare):
    cv_arg: TypeAlias = RuleVariation_398.cv_arg
    cv_name = "HAMVD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_398

    @classmethod
    def create(cls, arg : "NonSpare_1063.cv_arg") -> "NonSpare_1063":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_398:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_409:
        return self.rule.variation

class Item_388(Item):
    cv_arg: TypeAlias = NonSpare_1063.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1063

    @classmethod
    def create(cls, arg : "Item_388.cv_arg") -> "Item_388":
        return cls._create(arg) # type: ignore

class NonSpare_1090(NonSpare):
    cv_arg: TypeAlias = RuleVariation_508.cv_arg
    cv_name = "HVI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_508

    @classmethod
    def create(cls, arg : "NonSpare_1090.cv_arg") -> "NonSpare_1090":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_508:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_519:
        return self.rule.variation

class Item_409(Item):
    cv_arg: TypeAlias = NonSpare_1090.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1090

    @classmethod
    def create(cls, arg : "Item_409.cv_arg") -> "Item_409":
        return cls._create(arg) # type: ignore

class NonSpare_1207(NonSpare):
    cv_arg: TypeAlias = RuleVariation_615.cv_arg
    cv_name = "LTW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_615

    @classmethod
    def create(cls, arg : "NonSpare_1207.cv_arg") -> "NonSpare_1207":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_615:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_626:
        return self.rule.variation

class Item_512(Item):
    cv_arg: TypeAlias = NonSpare_1207.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1207

    @classmethod
    def create(cls, arg : "Item_512.cv_arg") -> "Item_512":
        return cls._create(arg) # type: ignore

class NonSpare_2049(NonSpare):
    cv_arg: TypeAlias = RuleVariation_704.cv_arg
    cv_name = "VPM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_704

    @classmethod
    def create(cls, arg : "NonSpare_2049.cv_arg") -> "NonSpare_2049":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_704:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_715:
        return self.rule.variation

class Item_1154(Item):
    cv_arg: TypeAlias = NonSpare_2049.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2049

    @classmethod
    def create(cls, arg : "Item_1154.cv_arg") -> "Item_1154":
        return cls._create(arg) # type: ignore

class NonSpare_1953(NonSpare):
    cv_arg: TypeAlias = RuleVariation_812.cv_arg
    cv_name = "TTA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_812

    @classmethod
    def create(cls, arg : "NonSpare_1953.cv_arg") -> "NonSpare_1953":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_812:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_842:
        return self.rule.variation

class Item_1065(Item):
    cv_arg: TypeAlias = NonSpare_1953.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1953

    @classmethod
    def create(cls, arg : "Item_1065.cv_arg") -> "Item_1065":
        return cls._create(arg) # type: ignore

class NonSpare_832(NonSpare):
    cv_arg: TypeAlias = RuleVariation_881.cv_arg
    cv_name = "CRA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_881

    @classmethod
    def create(cls, arg : "NonSpare_832.cv_arg") -> "NonSpare_832":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_881:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_911:
        return self.rule.variation

class Item_215(Item):
    cv_arg: TypeAlias = NonSpare_832.cv_arg
    cv_non_spare: TypeAlias = NonSpare_832

    @classmethod
    def create(cls, arg : "Item_215.cv_arg") -> "Item_215":
        return cls._create(arg) # type: ignore

class NonSpare_640(NonSpare):
    cv_arg: TypeAlias = RuleVariation_25.cv_arg
    cv_name = "ASM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_25

    @classmethod
    def create(cls, arg : "NonSpare_640.cv_arg") -> "NonSpare_640":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_25:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_25:
        return self.rule.variation

class Item_87(Item):
    cv_arg: TypeAlias = NonSpare_640.cv_arg
    cv_non_spare: TypeAlias = NonSpare_640

    @classmethod
    def create(cls, arg : "Item_87.cv_arg") -> "Item_87":
        return cls._create(arg) # type: ignore

class NonSpare_1110(NonSpare):
    cv_arg: TypeAlias = RuleVariation_399.cv_arg
    cv_name = "IAVM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_399

    @classmethod
    def create(cls, arg : "NonSpare_1110.cv_arg") -> "NonSpare_1110":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_399:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_410:
        return self.rule.variation

class Item_425(Item):
    cv_arg: TypeAlias = NonSpare_1110.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1110

    @classmethod
    def create(cls, arg : "Item_425.cv_arg") -> "Item_425":
        return cls._create(arg) # type: ignore

class NonSpare_1010(NonSpare):
    cv_arg: TypeAlias = RuleVariation_507.cv_arg
    cv_name = "FTD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_507

    @classmethod
    def create(cls, arg : "NonSpare_1010.cv_arg") -> "NonSpare_1010":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_507:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_518:
        return self.rule.variation

class Item_353(Item):
    cv_arg: TypeAlias = NonSpare_1010.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1010

    @classmethod
    def create(cls, arg : "Item_353.cv_arg") -> "Item_353":
        return cls._create(arg) # type: ignore

class NonSpare_1134(NonSpare):
    cv_arg: TypeAlias = RuleVariation_613.cv_arg
    cv_name = "ITD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_613

    @classmethod
    def create(cls, arg : "NonSpare_1134.cv_arg") -> "NonSpare_1134":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_613:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_624:
        return self.rule.variation

class Item_443(Item):
    cv_arg: TypeAlias = NonSpare_1134.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1134

    @classmethod
    def create(cls, arg : "Item_443.cv_arg") -> "Item_443":
        return cls._create(arg) # type: ignore

class NonSpare_1125(NonSpare):
    cv_arg: TypeAlias = RuleVariation_698.cv_arg
    cv_name = "IIA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_698

    @classmethod
    def create(cls, arg : "NonSpare_1125.cv_arg") -> "NonSpare_1125":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_698:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_709:
        return self.rule.variation

class Item_436(Item):
    cv_arg: TypeAlias = NonSpare_1125.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1125

    @classmethod
    def create(cls, arg : "Item_436.cv_arg") -> "Item_436":
        return cls._create(arg) # type: ignore

class NonSpare_1751(NonSpare):
    cv_arg: TypeAlias = RuleVariation_809.cv_arg
    cv_name = "SQW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_809

    @classmethod
    def create(cls, arg : "NonSpare_1751.cv_arg") -> "NonSpare_1751":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_809:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_839:
        return self.rule.variation

class Item_921(Item):
    cv_arg: TypeAlias = NonSpare_1751.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1751

    @classmethod
    def create(cls, arg : "Item_921.cv_arg") -> "Item_921":
        return cls._create(arg) # type: ignore

class NonSpare_855(NonSpare):
    cv_arg: TypeAlias = RuleVariation_882.cv_arg
    cv_name = "CUW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_882

    @classmethod
    def create(cls, arg : "NonSpare_855.cv_arg") -> "NonSpare_855":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_882:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_912:
        return self.rule.variation

class Item_233(Item):
    cv_arg: TypeAlias = NonSpare_855.cv_arg
    cv_non_spare: TypeAlias = NonSpare_855

    @classmethod
    def create(cls, arg : "Item_233.cv_arg") -> "Item_233":
        return cls._create(arg) # type: ignore

class NonSpare_710(NonSpare):
    cv_arg: TypeAlias = RuleVariation_26.cv_arg
    cv_name = "CATC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_26

    @classmethod
    def create(cls, arg : "NonSpare_710.cv_arg") -> "NonSpare_710":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_26:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_26:
        return self.rule.variation

class Item_137(Item):
    cv_arg: TypeAlias = NonSpare_710.cv_arg
    cv_non_spare: TypeAlias = NonSpare_710

    @classmethod
    def create(cls, arg : "Item_137.cv_arg") -> "Item_137":
        return cls._create(arg) # type: ignore

class NonSpare_1369(NonSpare):
    cv_arg: TypeAlias = RuleVariation_403.cv_arg
    cv_name = "NOCLR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_403

    @classmethod
    def create(cls, arg : "NonSpare_1369.cv_arg") -> "NonSpare_1369":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_403:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_414:
        return self.rule.variation

class Item_626(Item):
    cv_arg: TypeAlias = NonSpare_1369.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1369

    @classmethod
    def create(cls, arg : "Item_626.cv_arg") -> "Item_626":
        return cls._create(arg) # type: ignore

class NonSpare_1382(NonSpare):
    cv_arg: TypeAlias = RuleVariation_511.cv_arg
    cv_name = "NOMOV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_511

    @classmethod
    def create(cls, arg : "NonSpare_1382.cv_arg") -> "NonSpare_1382":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_511:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_522:
        return self.rule.variation

class Item_639(Item):
    cv_arg: TypeAlias = NonSpare_1382.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1382

    @classmethod
    def create(cls, arg : "Item_639.cv_arg") -> "Item_639":
        return cls._create(arg) # type: ignore

class NonSpare_1377(NonSpare):
    cv_arg: TypeAlias = RuleVariation_620.cv_arg
    cv_name = "NOH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_620

    @classmethod
    def create(cls, arg : "NonSpare_1377.cv_arg") -> "NonSpare_1377":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_620:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_631:
        return self.rule.variation

class Item_634(Item):
    cv_arg: TypeAlias = NonSpare_1377.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1377

    @classmethod
    def create(cls, arg : "Item_634.cv_arg") -> "Item_634":
        return cls._create(arg) # type: ignore

class NonSpare_2075(NonSpare):
    cv_arg: TypeAlias = RuleVariation_706.cv_arg
    cv_name = "WRTY"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_706

    @classmethod
    def create(cls, arg : "NonSpare_2075.cv_arg") -> "NonSpare_2075":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_706:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_717:
        return self.rule.variation

class Item_1175(Item):
    cv_arg: TypeAlias = NonSpare_2075.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2075

    @classmethod
    def create(cls, arg : "Item_1175.cv_arg") -> "Item_1175":
        return cls._create(arg) # type: ignore

class NonSpare_1801(NonSpare):
    cv_arg: TypeAlias = RuleVariation_810.cv_arg
    cv_name = "STOCC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_810

    @classmethod
    def create(cls, arg : "NonSpare_1801.cv_arg") -> "NonSpare_1801":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_810:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_840:
        return self.rule.variation

class Item_958(Item):
    cv_arg: TypeAlias = NonSpare_1801.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1801

    @classmethod
    def create(cls, arg : "Item_958.cv_arg") -> "Item_958":
        return cls._create(arg) # type: ignore

class NonSpare_1405(NonSpare):
    cv_arg: TypeAlias = RuleVariation_888.cv_arg
    cv_name = "ONGOING"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_888

    @classmethod
    def create(cls, arg : "NonSpare_1405.cv_arg") -> "NonSpare_1405":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_888:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_918:
        return self.rule.variation

class Item_661(Item):
    cv_arg: TypeAlias = NonSpare_1405.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1405

    @classmethod
    def create(cls, arg : "Item_661.cv_arg") -> "Item_661":
        return cls._create(arg) # type: ignore

class Variation_1380(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_32.cv_arg, Tuple[Literal["MRVA"], RuleVariation_32.cv_arg]], Union[RuleVariation_405.cv_arg, Tuple[Literal["RAMLD"], RuleVariation_405.cv_arg]], Union[RuleVariation_514.cv_arg, Tuple[Literal["RAMHD"], RuleVariation_514.cv_arg]], Union[RuleVariation_616.cv_arg, Tuple[Literal["MSAW"], RuleVariation_616.cv_arg]], Union[RuleVariation_696.cv_arg, Tuple[Literal["APW"], RuleVariation_696.cv_arg]], Union[RuleVariation_803.cv_arg, Tuple[Literal["CLAM"], RuleVariation_803.cv_arg]], Union[RuleVariation_892.cv_arg, Tuple[Literal["STCA"], RuleVariation_892.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_24.cv_arg, Tuple[Literal["APM"], RuleVariation_24.cv_arg]], Union[RuleVariation_406.cv_arg, Tuple[Literal["RIMCA"], RuleVariation_406.cv_arg]], Union[RuleVariation_504.cv_arg, Tuple[Literal["ACASRA"], RuleVariation_504.cv_arg]], Union[RuleVariation_621.cv_arg, Tuple[Literal["NTCA"], RuleVariation_621.cv_arg]], Union[RuleVariation_702.cv_arg, Tuple[Literal["DG"], RuleVariation_702.cv_arg]], Union[RuleVariation_807.cv_arg, Tuple[Literal["OF"], RuleVariation_807.cv_arg]], Union[RuleVariation_889.cv_arg, Tuple[Literal["OL"], RuleVariation_889.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_23.cv_arg, Tuple[Literal["AIW"], RuleVariation_23.cv_arg]], Union[RuleVariation_404.cv_arg, Tuple[Literal["PAIW"], RuleVariation_404.cv_arg]], Union[RuleVariation_512.cv_arg, Tuple[Literal["OCAT"], RuleVariation_512.cv_arg]], Union[RuleVariation_622.cv_arg, Tuple[Literal["SAM"], RuleVariation_622.cv_arg]], Union[RuleVariation_703.cv_arg, Tuple[Literal["VCD"], RuleVariation_703.cv_arg]], Union[RuleVariation_802.cv_arg, Tuple[Literal["CHAM"], RuleVariation_802.cv_arg]], Union[RuleVariation_883.cv_arg, Tuple[Literal["DSAM"], RuleVariation_883.cv_arg]], None]]
    cv_arg_group_4: TypeAlias = Union[int, Tuple[Union[RuleVariation_27.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_27.cv_arg]], Union[RuleVariation_395.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_395.cv_arg]], Union[RuleVariation_506.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_506.cv_arg]], Union[RuleVariation_624.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_624.cv_arg]], Union[RuleVariation_705.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_705.cv_arg]], Union[RuleVariation_814.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_814.cv_arg]], Union[RuleVariation_886.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_886.cv_arg]], None]]
    cv_arg_group_5: TypeAlias = Union[int, Tuple[Union[RuleVariation_29.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_29.cv_arg]], Union[RuleVariation_398.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_398.cv_arg]], Union[RuleVariation_508.cv_arg, Tuple[Literal["HVI"], RuleVariation_508.cv_arg]], Union[RuleVariation_615.cv_arg, Tuple[Literal["LTW"], RuleVariation_615.cv_arg]], Union[RuleVariation_704.cv_arg, Tuple[Literal["VPM"], RuleVariation_704.cv_arg]], Union[RuleVariation_812.cv_arg, Tuple[Literal["TTA"], RuleVariation_812.cv_arg]], Union[RuleVariation_881.cv_arg, Tuple[Literal["CRA"], RuleVariation_881.cv_arg]], None]]
    cv_arg_group_6: TypeAlias = Union[int, Tuple[Union[RuleVariation_25.cv_arg, Tuple[Literal["ASM"], RuleVariation_25.cv_arg]], Union[RuleVariation_399.cv_arg, Tuple[Literal["IAVM"], RuleVariation_399.cv_arg]], Union[RuleVariation_507.cv_arg, Tuple[Literal["FTD"], RuleVariation_507.cv_arg]], Union[RuleVariation_613.cv_arg, Tuple[Literal["ITD"], RuleVariation_613.cv_arg]], Union[RuleVariation_698.cv_arg, Tuple[Literal["IIA"], RuleVariation_698.cv_arg]], Union[RuleVariation_809.cv_arg, Tuple[Literal["SQW"], RuleVariation_809.cv_arg]], Union[RuleVariation_882.cv_arg, Tuple[Literal["CUW"], RuleVariation_882.cv_arg]], None]]
    cv_arg_group_7: TypeAlias = Union[int, Tuple[Union[RuleVariation_26.cv_arg, Tuple[Literal["CATC"], RuleVariation_26.cv_arg]], Union[RuleVariation_403.cv_arg, Tuple[Literal["NOCLR"], RuleVariation_403.cv_arg]], Union[RuleVariation_511.cv_arg, Tuple[Literal["NOMOV"], RuleVariation_511.cv_arg]], Union[RuleVariation_620.cv_arg, Tuple[Literal["NOH"], RuleVariation_620.cv_arg]], Union[RuleVariation_706.cv_arg, Tuple[Literal["WRTY"], RuleVariation_706.cv_arg]], Union[RuleVariation_810.cv_arg, Tuple[Literal["STOCC"], RuleVariation_810.cv_arg]], Union[RuleVariation_888.cv_arg, Tuple[Literal["ONGOING"], RuleVariation_888.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1380.cv_arg_group_1"],
        Tuple["Variation_1380.cv_arg_group_1", "Variation_1380.cv_arg_group_2"],
        Tuple["Variation_1380.cv_arg_group_1", "Variation_1380.cv_arg_group_2", "Variation_1380.cv_arg_group_3"],
        Tuple["Variation_1380.cv_arg_group_1", "Variation_1380.cv_arg_group_2", "Variation_1380.cv_arg_group_3", "Variation_1380.cv_arg_group_4"],
        Tuple["Variation_1380.cv_arg_group_1", "Variation_1380.cv_arg_group_2", "Variation_1380.cv_arg_group_3", "Variation_1380.cv_arg_group_4", "Variation_1380.cv_arg_group_5"],
        Tuple["Variation_1380.cv_arg_group_1", "Variation_1380.cv_arg_group_2", "Variation_1380.cv_arg_group_3", "Variation_1380.cv_arg_group_4", "Variation_1380.cv_arg_group_5", "Variation_1380.cv_arg_group_6"],
        Tuple["Variation_1380.cv_arg_group_1", "Variation_1380.cv_arg_group_2", "Variation_1380.cv_arg_group_3", "Variation_1380.cv_arg_group_4", "Variation_1380.cv_arg_group_5", "Variation_1380.cv_arg_group_6", "Variation_1380.cv_arg_group_7"],
    ]
    cv_items_list = [[(Item_586, 1), (Item_780, 1), (Item_779, 1), (Item_589, 1), (Item_78, 1), (Item_163, 1), (Item_952, 1), None], [(Item_77, 1), (Item_825, 1), (Item_40, 1), (Item_643, 1), (Item_262, 1), (Item_658, 1), (Item_659, 1), None], [(Item_56, 1), (Item_681, 1), (Item_652, 1), (Item_863, 1), (Item_1145, 1), (Item_156, 1), (Item_278, 1), None], [(Item_245, 1), (Item_247, 1), (Item_249, 1), (Item_1156, 1), (Item_1159, 1), (Item_1158, 1), (Item_384, 1), None], [(Item_386, 1), (Item_388, 1), (Item_409, 1), (Item_512, 1), (Item_1154, 1), (Item_1065, 1), (Item_215, 1), None], [(Item_87, 1), (Item_425, 1), (Item_353, 1), (Item_443, 1), (Item_436, 1), (Item_921, 1), (Item_233, 1), None], [(Item_137, 1), (Item_626, 1), (Item_639, 1), (Item_634, 1), (Item_1175, 1), (Item_958, 1), (Item_661, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1380.cv_arg") -> 'Variation_1380':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MRVA"]) -> RuleVariation_32:
        ...
    @overload
    def get_item(self, key : Literal["RAMLD"]) -> RuleVariation_405:
        ...
    @overload
    def get_item(self, key : Literal["RAMHD"]) -> RuleVariation_514:
        ...
    @overload
    def get_item(self, key : Literal["MSAW"]) -> RuleVariation_616:
        ...
    @overload
    def get_item(self, key : Literal["APW"]) -> RuleVariation_696:
        ...
    @overload
    def get_item(self, key : Literal["CLAM"]) -> RuleVariation_803:
        ...
    @overload
    def get_item(self, key : Literal["STCA"]) -> RuleVariation_892:
        ...
    @overload
    def get_item(self, key : Literal["APM"]) -> Optional[RuleVariation_24]:
        ...
    @overload
    def get_item(self, key : Literal["RIMCA"]) -> Optional[RuleVariation_406]:
        ...
    @overload
    def get_item(self, key : Literal["ACASRA"]) -> Optional[RuleVariation_504]:
        ...
    @overload
    def get_item(self, key : Literal["NTCA"]) -> Optional[RuleVariation_621]:
        ...
    @overload
    def get_item(self, key : Literal["DG"]) -> Optional[RuleVariation_702]:
        ...
    @overload
    def get_item(self, key : Literal["OF"]) -> Optional[RuleVariation_807]:
        ...
    @overload
    def get_item(self, key : Literal["OL"]) -> Optional[RuleVariation_889]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_23]:
        ...
    @overload
    def get_item(self, key : Literal["PAIW"]) -> Optional[RuleVariation_404]:
        ...
    @overload
    def get_item(self, key : Literal["OCAT"]) -> Optional[RuleVariation_512]:
        ...
    @overload
    def get_item(self, key : Literal["SAM"]) -> Optional[RuleVariation_622]:
        ...
    @overload
    def get_item(self, key : Literal["VCD"]) -> Optional[RuleVariation_703]:
        ...
    @overload
    def get_item(self, key : Literal["CHAM"]) -> Optional[RuleVariation_802]:
        ...
    @overload
    def get_item(self, key : Literal["DSAM"]) -> Optional[RuleVariation_883]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_27]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_395]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_506]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_624]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_705]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_814]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_886]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_29]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_398]:
        ...
    @overload
    def get_item(self, key : Literal["HVI"]) -> Optional[RuleVariation_508]:
        ...
    @overload
    def get_item(self, key : Literal["LTW"]) -> Optional[RuleVariation_615]:
        ...
    @overload
    def get_item(self, key : Literal["VPM"]) -> Optional[RuleVariation_704]:
        ...
    @overload
    def get_item(self, key : Literal["TTA"]) -> Optional[RuleVariation_812]:
        ...
    @overload
    def get_item(self, key : Literal["CRA"]) -> Optional[RuleVariation_881]:
        ...
    @overload
    def get_item(self, key : Literal["ASM"]) -> Optional[RuleVariation_25]:
        ...
    @overload
    def get_item(self, key : Literal["IAVM"]) -> Optional[RuleVariation_399]:
        ...
    @overload
    def get_item(self, key : Literal["FTD"]) -> Optional[RuleVariation_507]:
        ...
    @overload
    def get_item(self, key : Literal["ITD"]) -> Optional[RuleVariation_613]:
        ...
    @overload
    def get_item(self, key : Literal["IIA"]) -> Optional[RuleVariation_698]:
        ...
    @overload
    def get_item(self, key : Literal["SQW"]) -> Optional[RuleVariation_809]:
        ...
    @overload
    def get_item(self, key : Literal["CUW"]) -> Optional[RuleVariation_882]:
        ...
    @overload
    def get_item(self, key : Literal["CATC"]) -> Optional[RuleVariation_26]:
        ...
    @overload
    def get_item(self, key : Literal["NOCLR"]) -> Optional[RuleVariation_403]:
        ...
    @overload
    def get_item(self, key : Literal["NOMOV"]) -> Optional[RuleVariation_511]:
        ...
    @overload
    def get_item(self, key : Literal["NOH"]) -> Optional[RuleVariation_620]:
        ...
    @overload
    def get_item(self, key : Literal["WRTY"]) -> Optional[RuleVariation_706]:
        ...
    @overload
    def get_item(self, key : Literal["STOCC"]) -> Optional[RuleVariation_810]:
        ...
    @overload
    def get_item(self, key : Literal["ONGOING"]) -> Optional[RuleVariation_888]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1301(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1380.cv_arg
    cv_variation: TypeAlias = Variation_1380

    @classmethod
    def create(cls, arg : "RuleVariation_1301.cv_arg") -> "RuleVariation_1301":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1380:
        return self.arg # type: ignore

class NonSpare_195(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1301.cv_arg
    cv_name = "060"
    cv_title = "Safety Net Function and System Status"
    cv_rule: TypeAlias = RuleVariation_1301

    @classmethod
    def create(cls, arg : "NonSpare_195.cv_arg") -> "NonSpare_195":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1301:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1380:
        return self.rule.variation

class UapItem_195(UapItem):
    cv_non_spare: TypeAlias = NonSpare_195

class NonSpare_114(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "030"
    cv_title = "Track Number 1"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_114.cv_arg") -> "NonSpare_114":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_114(UapItem):
    cv_non_spare: TypeAlias = NonSpare_114

class Content_610(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringAscii

class RuleContent_610(RuleContentContextFree):
    cv_arg: TypeAlias = Content_610.cv_arg
    cv_content: TypeAlias = Content_610

    @property
    def content(self) -> Content_610:
        return self._get_content() # type: ignore

class Variation_393(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_393.cv_arg") -> "Variation_393":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_385(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_393.cv_arg
    cv_variation: TypeAlias = Variation_393

    @classmethod
    def create(cls, arg : "RuleVariation_385.cv_arg") -> "RuleVariation_385":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_393:
        return self.arg # type: ignore

class NonSpare_588(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "AI1"
    cv_title = "Aircraft Identifier (in 7 Characters) of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_588.cv_arg") -> "NonSpare_588":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1312(NonSpare):
    cv_arg: TypeAlias = RuleVariation_782.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Code (Converted Into Octal Representation) of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_782

    @classmethod
    def create(cls, arg : "NonSpare_1312.cv_arg") -> "NonSpare_1312":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_782:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_812:
        return self.rule.variation

class Item_575(Item):
    cv_arg: TypeAlias = NonSpare_1312.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1312

    @classmethod
    def create(cls, arg : "Item_575.cv_arg") -> "Item_575":
        return cls._create(arg) # type: ignore

class Variation_1031(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_782.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_782.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1031.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_575, 12)]
    cv_items_dict = {"MODE3A": RuleVariation_782}

    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> Type[RuleVariation_782]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_782:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1031.cv_arg") -> 'Variation_1031':
        return cls._create(arg) # type: ignore

class RuleVariation_1000(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1031.cv_arg
    cv_variation: TypeAlias = Variation_1031

    @classmethod
    def create(cls, arg : "RuleVariation_1000.cv_arg") -> "RuleVariation_1000":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1031:
        return self.arg # type: ignore

class NonSpare_1219(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1000.cv_arg
    cv_name = "M31"
    cv_title = "Mode 3/A Code Aircraft 1"
    cv_rule: TypeAlias = RuleVariation_1000

    @classmethod
    def create(cls, arg : "NonSpare_1219.cv_arg") -> "NonSpare_1219":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1000:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1031:
        return self.rule.variation

class Content_700(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 5.364418029785156e-6
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_700(RuleContentContextFree):
    cv_arg: TypeAlias = Content_700.cv_arg
    cv_content: TypeAlias = Content_700

    @property
    def content(self) -> Content_700:
        return self._get_content() # type: ignore

class Variation_378(Element):
    cv_arg: TypeAlias = RuleContent_700.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_700

    @classmethod
    def create(cls, arg: "Variation_378.cv_arg") -> "Variation_378":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_700:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_700:
        return self.rule.content

class RuleVariation_371(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_378.cv_arg
    cv_variation: TypeAlias = Variation_378

    @classmethod
    def create(cls, arg : "RuleVariation_371.cv_arg") -> "RuleVariation_371":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_378:
        return self.arg # type: ignore

class NonSpare_1164(NonSpare):
    cv_arg: TypeAlias = RuleVariation_371.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude in WGS-84 in Two’s Complement"
    cv_rule: TypeAlias = RuleVariation_371

    @classmethod
    def create(cls, arg : "NonSpare_1164.cv_arg") -> "NonSpare_1164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_371:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_378:
        return self.rule.variation

class Item_473(Item):
    cv_arg: TypeAlias = NonSpare_1164.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1164

    @classmethod
    def create(cls, arg : "Item_473.cv_arg") -> "Item_473":
        return cls._create(arg) # type: ignore

class Content_699(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 5.364418029785156e-6
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_699(RuleContentContextFree):
    cv_arg: TypeAlias = Content_699.cv_arg
    cv_content: TypeAlias = Content_699

    @property
    def content(self) -> Content_699:
        return self._get_content() # type: ignore

class Variation_377(Element):
    cv_arg: TypeAlias = RuleContent_699.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_699

    @classmethod
    def create(cls, arg: "Variation_377.cv_arg") -> "Variation_377":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_699:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_699:
        return self.rule.content

class RuleVariation_370(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_377.cv_arg
    cv_variation: TypeAlias = Variation_377

    @classmethod
    def create(cls, arg : "RuleVariation_370.cv_arg") -> "RuleVariation_370":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_377:
        return self.arg # type: ignore

class NonSpare_1194(NonSpare):
    cv_arg: TypeAlias = RuleVariation_370.cv_arg
    cv_name = "LON"
    cv_title = "Longitude in WGS-84 in Two’s Complement"
    cv_rule: TypeAlias = RuleVariation_370

    @classmethod
    def create(cls, arg : "NonSpare_1194.cv_arg") -> "NonSpare_1194":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_370:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_377:
        return self.rule.variation

class Item_501(Item):
    cv_arg: TypeAlias = NonSpare_1194.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1194

    @classmethod
    def create(cls, arg : "Item_501.cv_arg") -> "Item_501":
        return cls._create(arg) # type: ignore

class Content_635(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_635(RuleContentContextFree):
    cv_arg: TypeAlias = Content_635.cv_arg
    cv_content: TypeAlias = Content_635

    @property
    def content(self) -> Content_635:
        return self._get_content() # type: ignore

class Variation_263(Element):
    cv_arg: TypeAlias = RuleContent_635.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_635

    @classmethod
    def create(cls, arg: "Variation_263.cv_arg") -> "Variation_263":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_635:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_635:
        return self.rule.content

class RuleVariation_256(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_263.cv_arg
    cv_variation: TypeAlias = Variation_263

    @classmethod
    def create(cls, arg : "RuleVariation_256.cv_arg") -> "RuleVariation_256":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_263:
        return self.arg # type: ignore

class NonSpare_598(NonSpare):
    cv_arg: TypeAlias = RuleVariation_256.cv_arg
    cv_name = "ALT"
    cv_title = "Altitude of Predicted Conflict"
    cv_rule: TypeAlias = RuleVariation_256

    @classmethod
    def create(cls, arg : "NonSpare_598.cv_arg") -> "NonSpare_598":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_256:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_263:
        return self.rule.variation

class Item_63(Item):
    cv_arg: TypeAlias = NonSpare_598.cv_arg
    cv_non_spare: TypeAlias = NonSpare_598

    @classmethod
    def create(cls, arg : "Item_63.cv_arg") -> "Item_63":
        return cls._create(arg) # type: ignore

class Variation_1140(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_371.cv_arg, Tuple[Literal["LAT"], RuleVariation_371.cv_arg]], Union[RuleVariation_370.cv_arg, Tuple[Literal["LON"], RuleVariation_370.cv_arg]], Union[RuleVariation_256.cv_arg, Tuple[Literal["ALT"], RuleVariation_256.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1140.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 80
    cv_items_list = [(Item_473, 32), (Item_501, 32), (Item_63, 16)]
    cv_items_dict = {"LAT": RuleVariation_371, "LON": RuleVariation_370, "ALT": RuleVariation_256}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> Type[RuleVariation_371]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> Type[RuleVariation_370]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ALT"]) -> Type[RuleVariation_256]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"], Literal["ALT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_371:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_370:
        ...
    @overload
    def get_item(self, key : Literal["ALT"]) -> RuleVariation_256:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1140.cv_arg") -> 'Variation_1140':
        return cls._create(arg) # type: ignore

class RuleVariation_1096(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1140.cv_arg
    cv_variation: TypeAlias = Variation_1140

    @classmethod
    def create(cls, arg : "RuleVariation_1096.cv_arg") -> "RuleVariation_1096":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1140:
        return self.arg # type: ignore

class NonSpare_828(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1096.cv_arg
    cv_name = "CPW"
    cv_title = "Predicted Conflict Position Target 1 in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1096

    @classmethod
    def create(cls, arg : "NonSpare_828.cv_arg") -> "NonSpare_828":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1096:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1140:
        return self.rule.variation

class Content_640(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.5
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_640(RuleContentContextFree):
    cv_arg: TypeAlias = Content_640.cv_arg
    cv_content: TypeAlias = Content_640

    @property
    def content(self) -> Content_640:
        return self._get_content() # type: ignore

class Variation_352(Element):
    cv_arg: TypeAlias = RuleContent_640.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_640

    @classmethod
    def create(cls, arg: "Variation_352.cv_arg") -> "Variation_352":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_640:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_640:
        return self.rule.content

class RuleVariation_345(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_352.cv_arg
    cv_variation: TypeAlias = Variation_352

    @classmethod
    def create(cls, arg : "RuleVariation_345.cv_arg") -> "RuleVariation_345":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_352:
        return self.arg # type: ignore

class NonSpare_2104(NonSpare):
    cv_arg: TypeAlias = RuleVariation_345.cv_arg
    cv_name = "X"
    cv_title = "Starting X-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_345

    @classmethod
    def create(cls, arg : "NonSpare_2104.cv_arg") -> "NonSpare_2104":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_345:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_352:
        return self.rule.variation

class Item_1201(Item):
    cv_arg: TypeAlias = NonSpare_2104.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2104

    @classmethod
    def create(cls, arg : "Item_1201.cv_arg") -> "Item_1201":
        return cls._create(arg) # type: ignore

class NonSpare_2157(NonSpare):
    cv_arg: TypeAlias = RuleVariation_345.cv_arg
    cv_name = "Y"
    cv_title = "Starting Y-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_345

    @classmethod
    def create(cls, arg : "NonSpare_2157.cv_arg") -> "NonSpare_2157":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_345:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_352:
        return self.rule.variation

class Item_1251(Item):
    cv_arg: TypeAlias = NonSpare_2157.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2157

    @classmethod
    def create(cls, arg : "Item_1251.cv_arg") -> "Item_1251":
        return cls._create(arg) # type: ignore

class NonSpare_2175(NonSpare):
    cv_arg: TypeAlias = RuleVariation_256.cv_arg
    cv_name = "Z"
    cv_title = "Starting Z-position of the Conflict"
    cv_rule: TypeAlias = RuleVariation_256

    @classmethod
    def create(cls, arg : "NonSpare_2175.cv_arg") -> "NonSpare_2175":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_256:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_263:
        return self.rule.variation

class Item_1269(Item):
    cv_arg: TypeAlias = NonSpare_2175.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2175

    @classmethod
    def create(cls, arg : "Item_1269.cv_arg") -> "Item_1269":
        return cls._create(arg) # type: ignore

class Variation_1314(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_345.cv_arg, Tuple[Literal["X"], RuleVariation_345.cv_arg]], Union[RuleVariation_345.cv_arg, Tuple[Literal["Y"], RuleVariation_345.cv_arg]], Union[RuleVariation_256.cv_arg, Tuple[Literal["Z"], RuleVariation_256.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1314.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_1201, 24), (Item_1251, 24), (Item_1269, 16)]
    cv_items_dict = {"X": RuleVariation_345, "Y": RuleVariation_345, "Z": RuleVariation_256}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> Type[RuleVariation_345]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> Type[RuleVariation_345]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Z"]) -> Type[RuleVariation_256]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["Z"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_345:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_345:
        ...
    @overload
    def get_item(self, key : Literal["Z"]) -> RuleVariation_256:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1314.cv_arg") -> 'Variation_1314':
        return cls._create(arg) # type: ignore

class RuleVariation_1243(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1314.cv_arg
    cv_variation: TypeAlias = Variation_1314

    @classmethod
    def create(cls, arg : "RuleVariation_1243.cv_arg") -> "RuleVariation_1243":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1314:
        return self.arg # type: ignore

class NonSpare_823(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1243.cv_arg
    cv_name = "CPC"
    cv_title = "Predicted Conflict Position for the Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1243

    @classmethod
    def create(cls, arg : "NonSpare_823.cv_arg") -> "NonSpare_823":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1243:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1314:
        return self.rule.variation

class NonSpare_1951(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TT1"
    cv_title = "Time to Runway Threshold for First Approaching Aircraft in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1951.cv_arg") -> "NonSpare_1951":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class Content_733(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.5
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_733(RuleContentContextFree):
    cv_arg: TypeAlias = Content_733.cv_arg
    cv_content: TypeAlias = Content_733

    @property
    def content(self) -> Content_733:
        return self._get_content() # type: ignore

class Variation_311(Element):
    cv_arg: TypeAlias = RuleContent_733.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_733

    @classmethod
    def create(cls, arg: "Variation_311.cv_arg") -> "Variation_311":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_733:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_733:
        return self.rule.content

class RuleVariation_304(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_311.cv_arg
    cv_variation: TypeAlias = Variation_311

    @classmethod
    def create(cls, arg : "RuleVariation_304.cv_arg") -> "RuleVariation_304":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_311:
        return self.arg # type: ignore

class NonSpare_910(NonSpare):
    cv_arg: TypeAlias = RuleVariation_304.cv_arg
    cv_name = "DT1"
    cv_title = "Distance to Runway Threshold for Aircraft 1 Involved in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_304

    @classmethod
    def create(cls, arg : "NonSpare_910.cv_arg") -> "NonSpare_910":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_304:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_311:
        return self.rule.variation

class Content_549(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "General Air Traffic", 2: "Operational Air Traffic", 3: "Not applicable"}

class RuleContent_549(RuleContentContextFree):
    cv_arg: TypeAlias = Content_549.cv_arg
    cv_content: TypeAlias = Content_549

    @property
    def content(self) -> Content_549:
        return self._get_content() # type: ignore

class Variation_116(Element):
    cv_arg: TypeAlias = RuleContent_549.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_549

    @classmethod
    def create(cls, arg: "Variation_116.cv_arg") -> "Variation_116":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_549:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_549:
        return self.rule.content

class RuleVariation_116(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_116.cv_arg
    cv_variation: TypeAlias = Variation_116

    @classmethod
    def create(cls, arg : "RuleVariation_116.cv_arg") -> "RuleVariation_116":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_116:
        return self.arg # type: ignore

class Content_247(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Instrument Flight Rules", 1: "Visual Flight rules", 2: "Not applicable", 3: "Controlled Visual Flight Rules"}

class RuleContent_247(RuleContentContextFree):
    cv_arg: TypeAlias = Content_247.cv_arg
    cv_content: TypeAlias = Content_247

    @property
    def content(self) -> Content_247:
        return self._get_content() # type: ignore

class Variation_593(Element):
    cv_arg: TypeAlias = RuleContent_247.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_247

    @classmethod
    def create(cls, arg: "Variation_593.cv_arg") -> "Variation_593":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_247:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_247:
        return self.rule.content

class RuleVariation_582(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_593.cv_arg
    cv_variation: TypeAlias = Variation_593

    @classmethod
    def create(cls, arg : "RuleVariation_582.cv_arg") -> "RuleVariation_582":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_593:
        return self.arg # type: ignore

class Content_542(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "Approved", 2: "Exempt", 3: "Not Approved"}

class RuleContent_542(RuleContentContextFree):
    cv_arg: TypeAlias = Content_542.cv_arg
    cv_content: TypeAlias = Content_542

    @property
    def content(self) -> Content_542:
        return self._get_content() # type: ignore

class Variation_771(Element):
    cv_arg: TypeAlias = RuleContent_542.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 2
    cv_rule = RuleContent_542

    @classmethod
    def create(cls, arg: "Variation_771.cv_arg") -> "Variation_771":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_542:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_542:
        return self.rule.content

class RuleVariation_760(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_771.cv_arg
    cv_variation: TypeAlias = Variation_771

    @classmethod
    def create(cls, arg : "RuleVariation_760.cv_arg") -> "RuleVariation_760":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_771:
        return self.arg # type: ignore

class Content_384(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Normal Priority Flight", 1: "High Priority Flight"}

class RuleContent_384(RuleContentContextFree):
    cv_arg: TypeAlias = Content_384.cv_arg
    cv_content: TypeAlias = Content_384

    @property
    def content(self) -> Content_384:
        return self._get_content() # type: ignore

class Variation_945(Element):
    cv_arg: TypeAlias = RuleContent_384.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_384

    @classmethod
    def create(cls, arg: "Variation_945.cv_arg") -> "Variation_945":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_384:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_384:
        return self.rule.content

class RuleVariation_915(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_945.cv_arg
    cv_variation: TypeAlias = Variation_945

    @classmethod
    def create(cls, arg : "RuleVariation_915.cv_arg") -> "RuleVariation_915":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_945:
        return self.arg # type: ignore

class Content_264(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Maintaining", 1: "Climbing", 2: "Descending", 3: "Invalid"}

class RuleContent_264(RuleContentContextFree):
    cv_arg: TypeAlias = Content_264.cv_arg
    cv_content: TypeAlias = Content_264

    @property
    def content(self) -> Content_264:
        return self._get_content() # type: ignore

class Variation_104(Element):
    cv_arg: TypeAlias = RuleContent_264.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_264

    @classmethod
    def create(cls, arg: "Variation_104.cv_arg") -> "Variation_104":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_264:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_264:
        return self.rule.content

class RuleVariation_104(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_104.cv_arg
    cv_variation: TypeAlias = Variation_104

    @classmethod
    def create(cls, arg : "RuleVariation_104.cv_arg") -> "RuleVariation_104":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_104:
        return self.arg # type: ignore

class Content_379(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Non primary target", 1: "Primary target"}

class RuleContent_379(RuleContentContextFree):
    cv_arg: TypeAlias = Content_379.cv_arg
    cv_content: TypeAlias = Content_379

    @property
    def content(self) -> Content_379:
        return self._get_content() # type: ignore

class Variation_566(Element):
    cv_arg: TypeAlias = RuleContent_379.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_379

    @classmethod
    def create(cls, arg: "Variation_566.cv_arg") -> "Variation_566":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_379:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_379:
        return self.rule.content

class RuleVariation_555(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_566.cv_arg
    cv_variation: TypeAlias = Variation_566

    @classmethod
    def create(cls, arg : "RuleVariation_555.cv_arg") -> "RuleVariation_555":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_566:
        return self.arg # type: ignore

class Content_101(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Ground Vehicle"}

class RuleContent_101(RuleContentContextFree):
    cv_arg: TypeAlias = Content_101.cv_arg
    cv_content: TypeAlias = Content_101

    @property
    def content(self) -> Content_101:
        return self._get_content() # type: ignore

class Variation_623(Element):
    cv_arg: TypeAlias = RuleContent_101.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_101

    @classmethod
    def create(cls, arg: "Variation_623.cv_arg") -> "Variation_623":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_101:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_101:
        return self.rule.content

class RuleVariation_612(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_623.cv_arg
    cv_variation: TypeAlias = Variation_623

    @classmethod
    def create(cls, arg : "RuleVariation_612.cv_arg") -> "RuleVariation_612":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_623:
        return self.arg # type: ignore

class NonSpare_1031(NonSpare):
    cv_arg: TypeAlias = RuleVariation_116.cv_arg
    cv_name = "GATOAT"
    cv_title = "Identification of Conflict Categories Definition Table"
    cv_rule: TypeAlias = RuleVariation_116

    @classmethod
    def create(cls, arg : "NonSpare_1031.cv_arg") -> "NonSpare_1031":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_116:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_116:
        return self.rule.variation

class Item_366(Item):
    cv_arg: TypeAlias = NonSpare_1031.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1031

    @classmethod
    def create(cls, arg : "Item_366.cv_arg") -> "Item_366":
        return cls._create(arg) # type: ignore

class NonSpare_1000(NonSpare):
    cv_arg: TypeAlias = RuleVariation_582.cv_arg
    cv_name = "FR1FR2"
    cv_title = "Flight Rules"
    cv_rule: TypeAlias = RuleVariation_582

    @classmethod
    def create(cls, arg : "NonSpare_1000.cv_arg") -> "NonSpare_1000":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_582:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_593:
        return self.rule.variation

class Item_346(Item):
    cv_arg: TypeAlias = NonSpare_1000.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1000

    @classmethod
    def create(cls, arg : "Item_346.cv_arg") -> "Item_346":
        return cls._create(arg) # type: ignore

class NonSpare_1644(NonSpare):
    cv_arg: TypeAlias = RuleVariation_760.cv_arg
    cv_name = "RVSM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_760

    @classmethod
    def create(cls, arg : "NonSpare_1644.cv_arg") -> "NonSpare_1644":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_760:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_771:
        return self.rule.variation

class Item_846(Item):
    cv_arg: TypeAlias = NonSpare_1644.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1644

    @classmethod
    def create(cls, arg : "Item_846.cv_arg") -> "Item_846":
        return cls._create(arg) # type: ignore

class NonSpare_1082(NonSpare):
    cv_arg: TypeAlias = RuleVariation_915.cv_arg
    cv_name = "HPR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_915

    @classmethod
    def create(cls, arg : "NonSpare_1082.cv_arg") -> "NonSpare_1082":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_915:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_945:
        return self.rule.variation

class Item_403(Item):
    cv_arg: TypeAlias = NonSpare_1082.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1082

    @classmethod
    def create(cls, arg : "Item_403.cv_arg") -> "Item_403":
        return cls._create(arg) # type: ignore

class NonSpare_720(NonSpare):
    cv_arg: TypeAlias = RuleVariation_104.cv_arg
    cv_name = "CDM"
    cv_title = "Climbing/Descending Mode"
    cv_rule: TypeAlias = RuleVariation_104

    @classmethod
    def create(cls, arg : "NonSpare_720.cv_arg") -> "NonSpare_720":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_104:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_104:
        return self.rule.variation

class Item_143(Item):
    cv_arg: TypeAlias = NonSpare_720.cv_arg
    cv_non_spare: TypeAlias = NonSpare_720

    @classmethod
    def create(cls, arg : "Item_143.cv_arg") -> "Item_143":
        return cls._create(arg) # type: ignore

class NonSpare_1471(NonSpare):
    cv_arg: TypeAlias = RuleVariation_555.cv_arg
    cv_name = "PRI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_555

    @classmethod
    def create(cls, arg : "NonSpare_1471.cv_arg") -> "NonSpare_1471":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_555:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_566:
        return self.rule.variation

class Item_711(Item):
    cv_arg: TypeAlias = NonSpare_1471.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1471

    @classmethod
    def create(cls, arg : "Item_711.cv_arg") -> "Item_711":
        return cls._create(arg) # type: ignore

class NonSpare_1051(NonSpare):
    cv_arg: TypeAlias = RuleVariation_612.cv_arg
    cv_name = "GV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_612

    @classmethod
    def create(cls, arg : "NonSpare_1051.cv_arg") -> "NonSpare_1051":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_612:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_623:
        return self.rule.variation

class Item_381(Item):
    cv_arg: TypeAlias = NonSpare_1051.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1051

    @classmethod
    def create(cls, arg : "Item_381.cv_arg") -> "Item_381":
        return cls._create(arg) # type: ignore

class Item_21(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 4
    cv_bit_size = 3

class Variation_1371(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_116.cv_arg, Tuple[Literal["GATOAT"], RuleVariation_116.cv_arg]], Union[RuleVariation_582.cv_arg, Tuple[Literal["FR1FR2"], RuleVariation_582.cv_arg]], Union[RuleVariation_760.cv_arg, Tuple[Literal["RVSM"], RuleVariation_760.cv_arg]], Union[RuleVariation_915.cv_arg, Tuple[Literal["HPR"], RuleVariation_915.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_104.cv_arg, Tuple[Literal["CDM"], RuleVariation_104.cv_arg]], Union[RuleVariation_555.cv_arg, Tuple[Literal["PRI"], RuleVariation_555.cv_arg]], Union[RuleVariation_612.cv_arg, Tuple[Literal["GV"], RuleVariation_612.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1371.cv_arg_group_1"],
        Tuple["Variation_1371.cv_arg_group_1", "Variation_1371.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_366, 2), (Item_346, 2), (Item_846, 2), (Item_403, 1), None], [(Item_143, 2), (Item_711, 1), (Item_381, 1), (Item_21, 3), None]]

    @classmethod
    def create(cls, arg: "Variation_1371.cv_arg") -> 'Variation_1371':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["GATOAT"]) -> RuleVariation_116:
        ...
    @overload
    def get_item(self, key : Literal["FR1FR2"]) -> RuleVariation_582:
        ...
    @overload
    def get_item(self, key : Literal["RVSM"]) -> RuleVariation_760:
        ...
    @overload
    def get_item(self, key : Literal["HPR"]) -> RuleVariation_915:
        ...
    @overload
    def get_item(self, key : Literal["CDM"]) -> Optional[RuleVariation_104]:
        ...
    @overload
    def get_item(self, key : Literal["PRI"]) -> Optional[RuleVariation_555]:
        ...
    @overload
    def get_item(self, key : Literal["GV"]) -> Optional[RuleVariation_612]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1292(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1371.cv_arg
    cv_variation: TypeAlias = Variation_1371

    @classmethod
    def create(cls, arg : "RuleVariation_1292.cv_arg") -> "RuleVariation_1292":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1371:
        return self.arg # type: ignore

class NonSpare_560(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1292.cv_arg
    cv_name = "AC1"
    cv_title = "Characteristics of Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1292

    @classmethod
    def create(cls, arg : "NonSpare_560.cv_arg") -> "NonSpare_560":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1292:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1371:
        return self.rule.variation

class Content_611(ContentString):
    cv_arg: TypeAlias = Union[int, str]
    cv_string_type: TypeAlias = StringICAO

class RuleContent_611(RuleContentContextFree):
    cv_arg: TypeAlias = Content_611.cv_arg
    cv_content: TypeAlias = Content_611

    @property
    def content(self) -> Content_611:
        return self._get_content() # type: ignore

class Variation_391(Element):
    cv_arg: TypeAlias = RuleContent_611.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 48
    cv_rule = RuleContent_611

    @classmethod
    def create(cls, arg: "Variation_391.cv_arg") -> "Variation_391":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_611:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_611:
        return self.rule.content

class RuleVariation_383(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_391.cv_arg
    cv_variation: TypeAlias = Variation_391

    @classmethod
    def create(cls, arg : "RuleVariation_383.cv_arg") -> "RuleVariation_383":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_391:
        return self.arg # type: ignore

class NonSpare_1326(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "MS1"
    cv_title = "Aircraft Identification Downloaded from Aircraft 1 Involved in the Conflict If Equipped with a Mode-S Transponder"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1326.cv_arg") -> "NonSpare_1326":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Item_4(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 5

class Content_711(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal[""]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = ""

    def as_quantity(self, cv_unit : Optional[Literal[""]] = None) -> float:
        return self._as_quantity()

class RuleContent_711(RuleContentContextFree):
    cv_arg: TypeAlias = Content_711.cv_arg
    cv_content: TypeAlias = Content_711

    @property
    def content(self) -> Content_711:
        return self._get_content() # type: ignore

class Variation_901(Element):
    cv_arg: TypeAlias = RuleContent_711.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 27
    cv_rule = RuleContent_711

    @classmethod
    def create(cls, arg: "Variation_901.cv_arg") -> "Variation_901":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_711:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_711:
        return self.rule.content

class RuleVariation_871(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_901.cv_arg
    cv_variation: TypeAlias = Variation_901

    @classmethod
    def create(cls, arg : "RuleVariation_871.cv_arg") -> "RuleVariation_871":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_901:
        return self.arg # type: ignore

class NonSpare_1358(NonSpare):
    cv_arg: TypeAlias = RuleVariation_871.cv_arg
    cv_name = "NBR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_871

    @classmethod
    def create(cls, arg : "NonSpare_1358.cv_arg") -> "NonSpare_1358":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_871:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_901:
        return self.rule.variation

class Item_615(Item):
    cv_arg: TypeAlias = NonSpare_1358.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1358

    @classmethod
    def create(cls, arg : "Item_615.cv_arg") -> "Item_615":
        return cls._create(arg) # type: ignore

class Variation_1042(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_871.cv_arg, Tuple[Literal["NBR"], RuleVariation_871.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1042.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_4, 5), (Item_615, 27)]
    cv_items_dict = {"NBR": RuleVariation_871}

    @classmethod
    def spec(cls, key : Literal["NBR"]) -> Type[RuleVariation_871]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["NBR"]) -> RuleVariation_871:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1042.cv_arg") -> 'Variation_1042':
        return cls._create(arg) # type: ignore

class RuleVariation_1010(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1042.cv_arg
    cv_variation: TypeAlias = Variation_1042

    @classmethod
    def create(cls, arg : "RuleVariation_1010.cv_arg") -> "RuleVariation_1010":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1042:
        return self.arg # type: ignore

class NonSpare_991(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1010.cv_arg
    cv_name = "FP1"
    cv_title = "Number of the Flight Plan Correlated to Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1010

    @classmethod
    def create(cls, arg : "NonSpare_991.cv_arg") -> "NonSpare_991":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1010:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1042:
        return self.rule.variation

class Content_753(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["FL"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.25
    cv_unit = "FL"

    def as_quantity(self, cv_unit : Optional[Literal["FL"]] = None) -> float:
        return self._as_quantity()

class RuleContent_752(RuleContentContextFree):
    cv_arg: TypeAlias = Content_753.cv_arg
    cv_content: TypeAlias = Content_753

    @property
    def content(self) -> Content_753:
        return self._get_content() # type: ignore

class Variation_321(Element):
    cv_arg: TypeAlias = RuleContent_752.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_752

    @classmethod
    def create(cls, arg: "Variation_321.cv_arg") -> "Variation_321":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_752:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_753:
        return self.rule.content

class RuleVariation_314(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_321.cv_arg
    cv_variation: TypeAlias = Variation_321

    @classmethod
    def create(cls, arg : "RuleVariation_314.cv_arg") -> "RuleVariation_314":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_321:
        return self.arg # type: ignore

class NonSpare_729(NonSpare):
    cv_arg: TypeAlias = RuleVariation_314.cv_arg
    cv_name = "CF1"
    cv_title = "Cleared Flight Level for Aircraft 1 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_314

    @classmethod
    def create(cls, arg : "NonSpare_729.cv_arg") -> "NonSpare_729":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_314:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_321:
        return self.rule.variation

class Variation_1478(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AI1": NonSpare_588.cv_arg,
        "M31": NonSpare_1219.cv_arg,
        "CPW": NonSpare_828.cv_arg,
        "CPC": NonSpare_823.cv_arg,
        "TT1": NonSpare_1951.cv_arg,
        "DT1": NonSpare_910.cv_arg,
        "AC1": NonSpare_560.cv_arg,
        "MS1": NonSpare_1326.cv_arg,
        "FP1": NonSpare_991.cv_arg,
        "CF1": NonSpare_729.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_588, NonSpare_1219, NonSpare_828, NonSpare_823, NonSpare_1951, NonSpare_910, NonSpare_560, NonSpare_1326, NonSpare_991, NonSpare_729]
    cv_items_dict = {"AI1": NonSpare_588, "M31": NonSpare_1219, "CPW": NonSpare_828, "CPC": NonSpare_823, "TT1": NonSpare_1951, "DT1": NonSpare_910, "AC1": NonSpare_560, "MS1": NonSpare_1326, "FP1": NonSpare_991, "CF1": NonSpare_729}

    @overload
    @classmethod
    def spec(cls, key : Literal["AI1"]) -> Type[NonSpare_588]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["M31"]) -> Type[NonSpare_1219]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPW"]) -> Type[NonSpare_828]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> Type[NonSpare_823]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TT1"]) -> Type[NonSpare_1951]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DT1"]) -> Type[NonSpare_910]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC1"]) -> Type[NonSpare_560]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MS1"]) -> Type[NonSpare_1326]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FP1"]) -> Type[NonSpare_991]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CF1"]) -> Type[NonSpare_729]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AI1"], Literal["M31"], Literal["CPW"], Literal["CPC"], Literal["TT1"], Literal["DT1"], Literal["AC1"], Literal["MS1"], Literal["FP1"], Literal["CF1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AI1"]) -> Optional[NonSpare_588]:
        ...
    @overload
    def get_item(self, key : Literal["M31"]) -> Optional[NonSpare_1219]:
        ...
    @overload
    def get_item(self, key : Literal["CPW"]) -> Optional[NonSpare_828]:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> Optional[NonSpare_823]:
        ...
    @overload
    def get_item(self, key : Literal["TT1"]) -> Optional[NonSpare_1951]:
        ...
    @overload
    def get_item(self, key : Literal["DT1"]) -> Optional[NonSpare_910]:
        ...
    @overload
    def get_item(self, key : Literal["AC1"]) -> Optional[NonSpare_560]:
        ...
    @overload
    def get_item(self, key : Literal["MS1"]) -> Optional[NonSpare_1326]:
        ...
    @overload
    def get_item(self, key : Literal["FP1"]) -> Optional[NonSpare_991]:
        ...
    @overload
    def get_item(self, key : Literal["CF1"]) -> Optional[NonSpare_729]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AI1"], val : NonSpare_588.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["M31"], val : NonSpare_1219.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["CPW"], val : NonSpare_828.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["CPC"], val : NonSpare_823.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["TT1"], val : NonSpare_1951.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["DT1"], val : NonSpare_910.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["AC1"], val : NonSpare_560.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["MS1"], val : NonSpare_1326.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["FP1"], val : NonSpare_991.cv_arg) -> "Variation_1478":
        ...
    @overload
    def set_item(self, key : Literal["CF1"], val : NonSpare_729.cv_arg) -> "Variation_1478":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AI1"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["M31"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["CPW"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["CPC"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["TT1"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["DT1"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["AC1"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["MS1"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["FP1"]) -> "Variation_1478":
        ...
    @overload
    def del_item(self, key : Literal["CF1"]) -> "Variation_1478":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1478.cv_arg") -> 'Variation_1478':
        return cls._create(arg) # type: ignore

class RuleVariation_1399(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1478.cv_arg
    cv_variation: TypeAlias = Variation_1478

    @classmethod
    def create(cls, arg : "RuleVariation_1399.cv_arg") -> "RuleVariation_1399":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1478:
        return self.arg # type: ignore

class NonSpare_371(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1399.cv_arg
    cv_name = "170"
    cv_title = "Aircraft Identification and Characteristics 1"
    cv_rule: TypeAlias = RuleVariation_1399

    @classmethod
    def create(cls, arg : "NonSpare_371.cv_arg") -> "NonSpare_371":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1399:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1478:
        return self.rule.variation

class UapItem_371(UapItem):
    cv_non_spare: TypeAlias = NonSpare_371

class Content_67(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Conflict not predicted to occur in military airspace", 1: "Conflict predicted to occur in military airspace"}

class RuleContent_67(RuleContentContextFree):
    cv_arg: TypeAlias = Content_67.cv_arg
    cv_content: TypeAlias = Content_67

    @property
    def content(self) -> Content_67:
        return self._get_content() # type: ignore

class Variation_20(Element):
    cv_arg: TypeAlias = RuleContent_67.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_67

    @classmethod
    def create(cls, arg: "Variation_20.cv_arg") -> "Variation_20":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_67:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_67:
        return self.rule.content

class RuleVariation_20(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_20.cv_arg
    cv_variation: TypeAlias = Variation_20

    @classmethod
    def create(cls, arg : "RuleVariation_20.cv_arg") -> "RuleVariation_20":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_20:
        return self.arg # type: ignore

class Content_66(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Conflict not predicted to occur in civil airspace", 1: "Conflict predicted to occur in civil airspace"}

class RuleContent_66(RuleContentContextFree):
    cv_arg: TypeAlias = Content_66.cv_arg
    cv_content: TypeAlias = Content_66

    @property
    def content(self) -> Content_66:
        return self._get_content() # type: ignore

class Variation_404(Element):
    cv_arg: TypeAlias = RuleContent_66.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_66

    @classmethod
    def create(cls, arg: "Variation_404.cv_arg") -> "Variation_404":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_66:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_66:
        return self.rule.content

class RuleVariation_393(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_404.cv_arg
    cv_variation: TypeAlias = Variation_404

    @classmethod
    def create(cls, arg : "RuleVariation_393.cv_arg") -> "RuleVariation_393":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_404:
        return self.arg # type: ignore

class Content_26(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not fast diverging laterally at current time", 1: "Aircraft are fast diverging laterally at current time"}

class RuleContent_26(RuleContentContextFree):
    cv_arg: TypeAlias = Content_26.cv_arg
    cv_content: TypeAlias = Content_26

    @property
    def content(self) -> Content_26:
        return self._get_content() # type: ignore

class Variation_510(Element):
    cv_arg: TypeAlias = RuleContent_26.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_26

    @classmethod
    def create(cls, arg: "Variation_510.cv_arg") -> "Variation_510":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_26:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_26:
        return self.rule.content

class RuleVariation_499(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_510.cv_arg
    cv_variation: TypeAlias = Variation_510

    @classmethod
    def create(cls, arg : "RuleVariation_499.cv_arg") -> "RuleVariation_499":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_510:
        return self.arg # type: ignore

class Content_27(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not fast diverging vertically at current time", 1: "Aircraft are fast diverging vertically at current time"}

class RuleContent_27(RuleContentContextFree):
    cv_arg: TypeAlias = Content_27.cv_arg
    cv_content: TypeAlias = Content_27

    @property
    def content(self) -> Content_27:
        return self._get_content() # type: ignore

class Variation_617(Element):
    cv_arg: TypeAlias = RuleContent_27.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_27

    @classmethod
    def create(cls, arg: "Variation_617.cv_arg") -> "Variation_617":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_27:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_27:
        return self.rule.content

class RuleVariation_606(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_617.cv_arg
    cv_variation: TypeAlias = Variation_617

    @classmethod
    def create(cls, arg : "RuleVariation_606.cv_arg") -> "RuleVariation_606":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_617:
        return self.arg # type: ignore

class Content_271(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Minor separation infringement", 1: "Major separation infringement"}

class RuleContent_271(RuleContentContextFree):
    cv_arg: TypeAlias = Content_271.cv_arg
    cv_content: TypeAlias = Content_271

    @property
    def content(self) -> Content_271:
        return self._get_content() # type: ignore

class Variation_734(Element):
    cv_arg: TypeAlias = RuleContent_271.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_271

    @classmethod
    def create(cls, arg: "Variation_734.cv_arg") -> "Variation_734":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_271:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_271:
        return self.rule.content

class RuleVariation_723(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_734.cv_arg
    cv_variation: TypeAlias = Variation_734

    @classmethod
    def create(cls, arg : "RuleVariation_723.cv_arg") -> "RuleVariation_723":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_734:
        return self.arg # type: ignore

class Content_29(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft have not crossed at starting time of conflict", 1: "Aircraft have crossed at starting time of conflict"}

class RuleContent_29(RuleContentContextFree):
    cv_arg: TypeAlias = Content_29.cv_arg
    cv_content: TypeAlias = Content_29

    @property
    def content(self) -> Content_29:
        return self._get_content() # type: ignore

class Variation_824(Element):
    cv_arg: TypeAlias = RuleContent_29.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_29

    @classmethod
    def create(cls, arg: "Variation_824.cv_arg") -> "Variation_824":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_29:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_29:
        return self.rule.content

class RuleVariation_794(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_824.cv_arg
    cv_variation: TypeAlias = Variation_824

    @classmethod
    def create(cls, arg : "RuleVariation_794.cv_arg") -> "RuleVariation_794":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_824:
        return self.arg # type: ignore

class Content_25(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Aircraft are not diverging at starting time of conflict", 1: "Aircraft are diverging at starting time of conflict"}

class RuleContent_25(RuleContentContextFree):
    cv_arg: TypeAlias = Content_25.cv_arg
    cv_content: TypeAlias = Content_25

    @property
    def content(self) -> Content_25:
        return self._get_content() # type: ignore

class Variation_905(Element):
    cv_arg: TypeAlias = RuleContent_25.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_25

    @classmethod
    def create(cls, arg: "Variation_905.cv_arg") -> "Variation_905":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_25:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_25:
        return self.rule.content

class RuleVariation_875(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_905.cv_arg
    cv_variation: TypeAlias = Variation_905

    @classmethod
    def create(cls, arg : "RuleVariation_875.cv_arg") -> "RuleVariation_875":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_905:
        return self.arg # type: ignore

class Content_147(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Runway/Runway Crossing"}

class RuleContent_147(RuleContentContextFree):
    cv_arg: TypeAlias = Content_147.cv_arg
    cv_content: TypeAlias = Content_147

    @property
    def content(self) -> Content_147:
        return self._get_content() # type: ignore

class Variation_35(Element):
    cv_arg: TypeAlias = RuleContent_147.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_147

    @classmethod
    def create(cls, arg: "Variation_35.cv_arg") -> "Variation_35":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_147:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_147:
        return self.rule.content

class RuleVariation_35(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_35.cv_arg
    cv_variation: TypeAlias = Variation_35

    @classmethod
    def create(cls, arg : "RuleVariation_35.cv_arg") -> "RuleVariation_35":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_35:
        return self.arg # type: ignore

class Content_148(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Runway/Taxiway Crossing"}

class RuleContent_148(RuleContentContextFree):
    cv_arg: TypeAlias = Content_148.cv_arg
    cv_content: TypeAlias = Content_148

    @property
    def content(self) -> Content_148:
        return self._get_content() # type: ignore

class Variation_418(Element):
    cv_arg: TypeAlias = RuleContent_148.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_148

    @classmethod
    def create(cls, arg: "Variation_418.cv_arg") -> "Variation_418":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_148:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_148:
        return self.rule.content

class RuleVariation_407(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_418.cv_arg
    cv_variation: TypeAlias = Variation_418

    @classmethod
    def create(cls, arg : "RuleVariation_407.cv_arg") -> "RuleVariation_407":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_418:
        return self.arg # type: ignore

class Content_128(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 4 (MSAW) indicates MRVA"}

class RuleContent_128(RuleContentContextFree):
    cv_arg: TypeAlias = Content_128.cv_arg
    cv_content: TypeAlias = Content_128

    @property
    def content(self) -> Content_128:
        return self._get_content() # type: ignore

class Variation_521(Element):
    cv_arg: TypeAlias = RuleContent_128.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_128

    @classmethod
    def create(cls, arg: "Variation_521.cv_arg") -> "Variation_521":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_128:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_128:
        return self.rule.content

class RuleVariation_510(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_521.cv_arg
    cv_variation: TypeAlias = Variation_521

    @classmethod
    def create(cls, arg : "RuleVariation_510.cv_arg") -> "RuleVariation_510":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_521:
        return self.arg # type: ignore

class Content_122(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates CRM"}

class RuleContent_122(RuleContentContextFree):
    cv_arg: TypeAlias = Content_122.cv_arg
    cv_content: TypeAlias = Content_122

    @property
    def content(self) -> Content_122:
        return self._get_content() # type: ignore

class Variation_630(Element):
    cv_arg: TypeAlias = RuleContent_122.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_122

    @classmethod
    def create(cls, arg: "Variation_630.cv_arg") -> "Variation_630":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_122:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_122:
        return self.rule.content

class RuleVariation_619(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_630.cv_arg
    cv_variation: TypeAlias = Variation_630

    @classmethod
    def create(cls, arg : "RuleVariation_619.cv_arg") -> "RuleVariation_619":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_630:
        return self.arg # type: ignore

class Content_123(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates VRM"}

class RuleContent_123(RuleContentContextFree):
    cv_arg: TypeAlias = Content_123.cv_arg
    cv_content: TypeAlias = Content_123

    @property
    def content(self) -> Content_123:
        return self._get_content() # type: ignore

class Variation_712(Element):
    cv_arg: TypeAlias = RuleContent_123.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_123

    @classmethod
    def create(cls, arg: "Variation_712.cv_arg") -> "Variation_712":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_123:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_123:
        return self.rule.content

class RuleVariation_701(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_712.cv_arg
    cv_variation: TypeAlias = Variation_712

    @classmethod
    def create(cls, arg : "RuleVariation_701.cv_arg") -> "RuleVariation_701":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_712:
        return self.arg # type: ignore

class Content_124(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 25 (VRAM) indicates VTM"}

class RuleContent_124(RuleContentContextFree):
    cv_arg: TypeAlias = Content_124.cv_arg
    cv_content: TypeAlias = Content_124

    @property
    def content(self) -> Content_124:
        return self._get_content() # type: ignore

class Variation_835(Element):
    cv_arg: TypeAlias = RuleContent_124.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_124

    @classmethod
    def create(cls, arg: "Variation_835.cv_arg") -> "Variation_835":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_124:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_124:
        return self.rule.content

class RuleVariation_805(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_835.cv_arg
    cv_variation: TypeAlias = Variation_835

    @classmethod
    def create(cls, arg : "RuleVariation_805.cv_arg") -> "RuleVariation_805":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_835:
        return self.arg # type: ignore

class Content_125(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates HD"}

class RuleContent_125(RuleContentContextFree):
    cv_arg: TypeAlias = Content_125.cv_arg
    cv_content: TypeAlias = Content_125

    @property
    def content(self) -> Content_125:
        return self._get_content() # type: ignore

class Variation_917(Element):
    cv_arg: TypeAlias = RuleContent_125.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_125

    @classmethod
    def create(cls, arg: "Variation_917.cv_arg") -> "Variation_917":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_125:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_125:
        return self.rule.content

class RuleVariation_887(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_917.cv_arg
    cv_variation: TypeAlias = Variation_917

    @classmethod
    def create(cls, arg : "RuleVariation_887.cv_arg") -> "RuleVariation_887":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_917:
        return self.arg # type: ignore

class Content_126(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates RD"}

class RuleContent_126(RuleContentContextFree):
    cv_arg: TypeAlias = Content_126.cv_arg
    cv_content: TypeAlias = Content_126

    @property
    def content(self) -> Content_126:
        return self._get_content() # type: ignore

class Variation_33(Element):
    cv_arg: TypeAlias = RuleContent_126.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_126

    @classmethod
    def create(cls, arg: "Variation_33.cv_arg") -> "Variation_33":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_126:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_126:
        return self.rule.content

class RuleVariation_33(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_33.cv_arg
    cv_variation: TypeAlias = Variation_33

    @classmethod
    def create(cls, arg : "RuleVariation_33.cv_arg") -> "RuleVariation_33":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_33:
        return self.arg # type: ignore

class Content_127(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 29 (HAM) indicates VD"}

class RuleContent_127(RuleContentContextFree):
    cv_arg: TypeAlias = Content_127.cv_arg
    cv_content: TypeAlias = Content_127

    @property
    def content(self) -> Content_127:
        return self._get_content() # type: ignore

class Variation_413(Element):
    cv_arg: TypeAlias = RuleContent_127.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_127

    @classmethod
    def create(cls, arg: "Variation_413.cv_arg") -> "Variation_413":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_127:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_127:
        return self.rule.content

class RuleVariation_402(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_413.cv_arg
    cv_variation: TypeAlias = Variation_413

    @classmethod
    def create(cls, arg : "RuleVariation_402.cv_arg") -> "RuleVariation_402":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_413:
        return self.arg # type: ignore

class Content_119(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates ARR"}

class RuleContent_119(RuleContentContextFree):
    cv_arg: TypeAlias = Content_119.cv_arg
    cv_content: TypeAlias = Content_119

    @property
    def content(self) -> Content_119:
        return self._get_content() # type: ignore

class Variation_520(Element):
    cv_arg: TypeAlias = RuleContent_119.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_119

    @classmethod
    def create(cls, arg: "Variation_520.cv_arg") -> "Variation_520":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_119:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_119:
        return self.rule.content

class RuleVariation_509(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_520.cv_arg
    cv_variation: TypeAlias = Variation_520

    @classmethod
    def create(cls, arg : "RuleVariation_509.cv_arg") -> "RuleVariation_509":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_520:
        return self.arg # type: ignore

class Content_120(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates DEP"}

class RuleContent_120(RuleContentContextFree):
    cv_arg: TypeAlias = Content_120.cv_arg
    cv_content: TypeAlias = Content_120

    @property
    def content(self) -> Content_120:
        return self._get_content() # type: ignore

class Variation_629(Element):
    cv_arg: TypeAlias = RuleContent_120.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_120

    @classmethod
    def create(cls, arg: "Variation_629.cv_arg") -> "Variation_629":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_120:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_120:
        return self.rule.content

class RuleVariation_618(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_629.cv_arg
    cv_variation: TypeAlias = Variation_629

    @classmethod
    def create(cls, arg : "RuleVariation_618.cv_arg") -> "RuleVariation_618":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_629:
        return self.arg # type: ignore

class Content_121(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 20 (DBPSM) indicates above TL"}

class RuleContent_121(RuleContentContextFree):
    cv_arg: TypeAlias = Content_121.cv_arg
    cv_content: TypeAlias = Content_121

    @property
    def content(self) -> Content_121:
        return self._get_content() # type: ignore

class Variation_711(Element):
    cv_arg: TypeAlias = RuleContent_121.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_121

    @classmethod
    def create(cls, arg: "Variation_711.cv_arg") -> "Variation_711":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_121:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_121:
        return self.rule.content

class RuleVariation_700(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_711.cv_arg
    cv_variation: TypeAlias = Variation_711

    @classmethod
    def create(cls, arg : "RuleVariation_700.cv_arg") -> "RuleVariation_700":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_711:
        return self.arg # type: ignore

class Content_129(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Msg Type 99 (AIW) indicates pAIW Alert"}

class RuleContent_129(RuleContentContextFree):
    cv_arg: TypeAlias = Content_129.cv_arg
    cv_content: TypeAlias = Content_129

    @property
    def content(self) -> Content_129:
        return self._get_content() # type: ignore

class Variation_836(Element):
    cv_arg: TypeAlias = RuleContent_129.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_129

    @classmethod
    def create(cls, arg: "Variation_836.cv_arg") -> "Variation_836":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_129:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_129:
        return self.rule.content

class RuleVariation_806(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_836.cv_arg
    cv_variation: TypeAlias = Variation_836

    @classmethod
    def create(cls, arg : "RuleVariation_806.cv_arg") -> "RuleVariation_806":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_836:
        return self.arg # type: ignore

class NonSpare_1235(NonSpare):
    cv_arg: TypeAlias = RuleVariation_20.cv_arg
    cv_name = "MAS"
    cv_title = "Conflict Location in Military Airspace"
    cv_rule: TypeAlias = RuleVariation_20

    @classmethod
    def create(cls, arg : "NonSpare_1235.cv_arg") -> "NonSpare_1235":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_20:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_20:
        return self.rule.variation

class Item_531(Item):
    cv_arg: TypeAlias = NonSpare_1235.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1235

    @classmethod
    def create(cls, arg : "Item_531.cv_arg") -> "Item_531":
        return cls._create(arg) # type: ignore

class NonSpare_707(NonSpare):
    cv_arg: TypeAlias = RuleVariation_393.cv_arg
    cv_name = "CAS"
    cv_title = "Conflict Location in Civil Airspace"
    cv_rule: TypeAlias = RuleVariation_393

    @classmethod
    def create(cls, arg : "NonSpare_707.cv_arg") -> "NonSpare_707":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_393:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_404:
        return self.rule.variation

class Item_135(Item):
    cv_arg: TypeAlias = NonSpare_707.cv_arg
    cv_non_spare: TypeAlias = NonSpare_707

    @classmethod
    def create(cls, arg : "Item_135.cv_arg") -> "Item_135":
        return cls._create(arg) # type: ignore

class NonSpare_981(NonSpare):
    cv_arg: TypeAlias = RuleVariation_499.cv_arg
    cv_name = "FLD"
    cv_title = "Fast Lateral Divergence"
    cv_rule: TypeAlias = RuleVariation_499

    @classmethod
    def create(cls, arg : "NonSpare_981.cv_arg") -> "NonSpare_981":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_499:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_510:
        return self.rule.variation

class Item_334(Item):
    cv_arg: TypeAlias = NonSpare_981.cv_arg
    cv_non_spare: TypeAlias = NonSpare_981

    @classmethod
    def create(cls, arg : "Item_334.cv_arg") -> "Item_334":
        return cls._create(arg) # type: ignore

class NonSpare_1013(NonSpare):
    cv_arg: TypeAlias = RuleVariation_606.cv_arg
    cv_name = "FVD"
    cv_title = "Fast Vertical Divergence"
    cv_rule: TypeAlias = RuleVariation_606

    @classmethod
    def create(cls, arg : "NonSpare_1013.cv_arg") -> "NonSpare_1013":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_606:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_617:
        return self.rule.variation

class Item_356(Item):
    cv_arg: TypeAlias = NonSpare_1013.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1013

    @classmethod
    def create(cls, arg : "Item_356.cv_arg") -> "Item_356":
        return cls._create(arg) # type: ignore

class NonSpare_1982(NonSpare):
    cv_arg: TypeAlias = RuleVariation_723.cv_arg
    cv_name = "TYPE"
    cv_title = "Type of Separation Infringement"
    cv_rule: TypeAlias = RuleVariation_723

    @classmethod
    def create(cls, arg : "NonSpare_1982.cv_arg") -> "NonSpare_1982":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_723:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_734:
        return self.rule.variation

class Item_1092(Item):
    cv_arg: TypeAlias = NonSpare_1982.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1982

    @classmethod
    def create(cls, arg : "Item_1092.cv_arg") -> "Item_1092":
        return cls._create(arg) # type: ignore

class NonSpare_833(NonSpare):
    cv_arg: TypeAlias = RuleVariation_794.cv_arg
    cv_name = "CROSS"
    cv_title = "Crossing Test"
    cv_rule: TypeAlias = RuleVariation_794

    @classmethod
    def create(cls, arg : "NonSpare_833.cv_arg") -> "NonSpare_833":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_794:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_824:
        return self.rule.variation

class Item_216(Item):
    cv_arg: TypeAlias = NonSpare_833.cv_arg
    cv_non_spare: TypeAlias = NonSpare_833

    @classmethod
    def create(cls, arg : "Item_216.cv_arg") -> "Item_216":
        return cls._create(arg) # type: ignore

class NonSpare_891(NonSpare):
    cv_arg: TypeAlias = RuleVariation_875.cv_arg
    cv_name = "DIV"
    cv_title = "Divergence Test"
    cv_rule: TypeAlias = RuleVariation_875

    @classmethod
    def create(cls, arg : "NonSpare_891.cv_arg") -> "NonSpare_891":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_875:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_905:
        return self.rule.variation

class Item_265(Item):
    cv_arg: TypeAlias = NonSpare_891.cv_arg
    cv_non_spare: TypeAlias = NonSpare_891

    @classmethod
    def create(cls, arg : "Item_265.cv_arg") -> "Item_265":
        return cls._create(arg) # type: ignore

class NonSpare_1617(NonSpare):
    cv_arg: TypeAlias = RuleVariation_35.cv_arg
    cv_name = "RRC"
    cv_title = "Runway/Runway Crossing in RIMCAS"
    cv_rule: TypeAlias = RuleVariation_35

    @classmethod
    def create(cls, arg : "NonSpare_1617.cv_arg") -> "NonSpare_1617":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_35:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_35:
        return self.rule.variation

class Item_832(Item):
    cv_arg: TypeAlias = NonSpare_1617.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1617

    @classmethod
    def create(cls, arg : "Item_832.cv_arg") -> "Item_832":
        return cls._create(arg) # type: ignore

class NonSpare_1639(NonSpare):
    cv_arg: TypeAlias = RuleVariation_407.cv_arg
    cv_name = "RTC"
    cv_title = "Runway/Taxiway Crossing in RIMCAS"
    cv_rule: TypeAlias = RuleVariation_407

    @classmethod
    def create(cls, arg : "NonSpare_1639.cv_arg") -> "NonSpare_1639":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_407:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_418:
        return self.rule.variation

class Item_842(Item):
    cv_arg: TypeAlias = NonSpare_1639.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1639

    @classmethod
    def create(cls, arg : "Item_842.cv_arg") -> "Item_842":
        return cls._create(arg) # type: ignore

class NonSpare_1324(NonSpare):
    cv_arg: TypeAlias = RuleVariation_510.cv_arg
    cv_name = "MRVA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_510

    @classmethod
    def create(cls, arg : "NonSpare_1324.cv_arg") -> "NonSpare_1324":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_510:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_521:
        return self.rule.variation

class Item_587(Item):
    cv_arg: TypeAlias = NonSpare_1324.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1324

    @classmethod
    def create(cls, arg : "Item_587.cv_arg") -> "Item_587":
        return cls._create(arg) # type: ignore

class NonSpare_2050(NonSpare):
    cv_arg: TypeAlias = RuleVariation_619.cv_arg
    cv_name = "VRAMCRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_619

    @classmethod
    def create(cls, arg : "NonSpare_2050.cv_arg") -> "NonSpare_2050":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_619:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_630:
        return self.rule.variation

class Item_1155(Item):
    cv_arg: TypeAlias = NonSpare_2050.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2050

    @classmethod
    def create(cls, arg : "Item_1155.cv_arg") -> "Item_1155":
        return cls._create(arg) # type: ignore

class NonSpare_2052(NonSpare):
    cv_arg: TypeAlias = RuleVariation_701.cv_arg
    cv_name = "VRAMVRM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_701

    @classmethod
    def create(cls, arg : "NonSpare_2052.cv_arg") -> "NonSpare_2052":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_701:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_712:
        return self.rule.variation

class Item_1157(Item):
    cv_arg: TypeAlias = NonSpare_2052.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2052

    @classmethod
    def create(cls, arg : "Item_1157.cv_arg") -> "Item_1157":
        return cls._create(arg) # type: ignore

class NonSpare_2055(NonSpare):
    cv_arg: TypeAlias = RuleVariation_805.cv_arg
    cv_name = "VRAMVTM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_805

    @classmethod
    def create(cls, arg : "NonSpare_2055.cv_arg") -> "NonSpare_2055":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_805:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_835:
        return self.rule.variation

class Item_1160(Item):
    cv_arg: TypeAlias = NonSpare_2055.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2055

    @classmethod
    def create(cls, arg : "Item_1160.cv_arg") -> "Item_1160":
        return cls._create(arg) # type: ignore

class NonSpare_1060(NonSpare):
    cv_arg: TypeAlias = RuleVariation_887.cv_arg
    cv_name = "HAMHD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_887

    @classmethod
    def create(cls, arg : "NonSpare_1060.cv_arg") -> "NonSpare_1060":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_887:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_917:
        return self.rule.variation

class Item_385(Item):
    cv_arg: TypeAlias = NonSpare_1060.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1060

    @classmethod
    def create(cls, arg : "Item_385.cv_arg") -> "Item_385":
        return cls._create(arg) # type: ignore

class NonSpare_1062(NonSpare):
    cv_arg: TypeAlias = RuleVariation_33.cv_arg
    cv_name = "HAMRD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_33

    @classmethod
    def create(cls, arg : "NonSpare_1062.cv_arg") -> "NonSpare_1062":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_33:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_33:
        return self.rule.variation

class Item_387(Item):
    cv_arg: TypeAlias = NonSpare_1062.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1062

    @classmethod
    def create(cls, arg : "Item_387.cv_arg") -> "Item_387":
        return cls._create(arg) # type: ignore

class NonSpare_1064(NonSpare):
    cv_arg: TypeAlias = RuleVariation_402.cv_arg
    cv_name = "HAMVD"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_402

    @classmethod
    def create(cls, arg : "NonSpare_1064.cv_arg") -> "NonSpare_1064":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_402:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_413:
        return self.rule.variation

class Item_389(Item):
    cv_arg: TypeAlias = NonSpare_1064.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1064

    @classmethod
    def create(cls, arg : "Item_389.cv_arg") -> "Item_389":
        return cls._create(arg) # type: ignore

class NonSpare_871(NonSpare):
    cv_arg: TypeAlias = RuleVariation_509.cv_arg
    cv_name = "DBPSMARR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_509

    @classmethod
    def create(cls, arg : "NonSpare_871.cv_arg") -> "NonSpare_871":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_509:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_520:
        return self.rule.variation

class Item_246(Item):
    cv_arg: TypeAlias = NonSpare_871.cv_arg
    cv_non_spare: TypeAlias = NonSpare_871

    @classmethod
    def create(cls, arg : "Item_246.cv_arg") -> "Item_246":
        return cls._create(arg) # type: ignore

class NonSpare_873(NonSpare):
    cv_arg: TypeAlias = RuleVariation_618.cv_arg
    cv_name = "DBPSMDEP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_618

    @classmethod
    def create(cls, arg : "NonSpare_873.cv_arg") -> "NonSpare_873":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_618:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_629:
        return self.rule.variation

class Item_248(Item):
    cv_arg: TypeAlias = NonSpare_873.cv_arg
    cv_non_spare: TypeAlias = NonSpare_873

    @classmethod
    def create(cls, arg : "Item_248.cv_arg") -> "Item_248":
        return cls._create(arg) # type: ignore

class NonSpare_875(NonSpare):
    cv_arg: TypeAlias = RuleVariation_700.cv_arg
    cv_name = "DBPSMTL"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_700

    @classmethod
    def create(cls, arg : "NonSpare_875.cv_arg") -> "NonSpare_875":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_700:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_711:
        return self.rule.variation

class Item_250(Item):
    cv_arg: TypeAlias = NonSpare_875.cv_arg
    cv_non_spare: TypeAlias = NonSpare_875

    @classmethod
    def create(cls, arg : "Item_250.cv_arg") -> "Item_250":
        return cls._create(arg) # type: ignore

class NonSpare_592(NonSpare):
    cv_arg: TypeAlias = RuleVariation_806.cv_arg
    cv_name = "AIW"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_806

    @classmethod
    def create(cls, arg : "NonSpare_592.cv_arg") -> "NonSpare_592":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_806:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_836:
        return self.rule.variation

class Item_57(Item):
    cv_arg: TypeAlias = NonSpare_592.cv_arg
    cv_non_spare: TypeAlias = NonSpare_592

    @classmethod
    def create(cls, arg : "Item_57.cv_arg") -> "Item_57":
        return cls._create(arg) # type: ignore

class Item_26(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 6
    cv_bit_size = 1

class Variation_1373(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_20.cv_arg, Tuple[Literal["MAS"], RuleVariation_20.cv_arg]], Union[RuleVariation_393.cv_arg, Tuple[Literal["CAS"], RuleVariation_393.cv_arg]], Union[RuleVariation_499.cv_arg, Tuple[Literal["FLD"], RuleVariation_499.cv_arg]], Union[RuleVariation_606.cv_arg, Tuple[Literal["FVD"], RuleVariation_606.cv_arg]], Union[RuleVariation_723.cv_arg, Tuple[Literal["TYPE"], RuleVariation_723.cv_arg]], Union[RuleVariation_794.cv_arg, Tuple[Literal["CROSS"], RuleVariation_794.cv_arg]], Union[RuleVariation_875.cv_arg, Tuple[Literal["DIV"], RuleVariation_875.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_35.cv_arg, Tuple[Literal["RRC"], RuleVariation_35.cv_arg]], Union[RuleVariation_407.cv_arg, Tuple[Literal["RTC"], RuleVariation_407.cv_arg]], Union[RuleVariation_510.cv_arg, Tuple[Literal["MRVA"], RuleVariation_510.cv_arg]], Union[RuleVariation_619.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_619.cv_arg]], Union[RuleVariation_701.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_701.cv_arg]], Union[RuleVariation_805.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_805.cv_arg]], Union[RuleVariation_887.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_887.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_33.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_33.cv_arg]], Union[RuleVariation_402.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_402.cv_arg]], Union[RuleVariation_509.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_509.cv_arg]], Union[RuleVariation_618.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_618.cv_arg]], Union[RuleVariation_700.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_700.cv_arg]], Union[RuleVariation_806.cv_arg, Tuple[Literal["AIW"], RuleVariation_806.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1373.cv_arg_group_1"],
        Tuple["Variation_1373.cv_arg_group_1", "Variation_1373.cv_arg_group_2"],
        Tuple["Variation_1373.cv_arg_group_1", "Variation_1373.cv_arg_group_2", "Variation_1373.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_531, 1), (Item_135, 1), (Item_334, 1), (Item_356, 1), (Item_1092, 1), (Item_216, 1), (Item_265, 1), None], [(Item_832, 1), (Item_842, 1), (Item_587, 1), (Item_1155, 1), (Item_1157, 1), (Item_1160, 1), (Item_385, 1), None], [(Item_387, 1), (Item_389, 1), (Item_246, 1), (Item_248, 1), (Item_250, 1), (Item_57, 1), (Item_26, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1373.cv_arg") -> 'Variation_1373':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MAS"]) -> RuleVariation_20:
        ...
    @overload
    def get_item(self, key : Literal["CAS"]) -> RuleVariation_393:
        ...
    @overload
    def get_item(self, key : Literal["FLD"]) -> RuleVariation_499:
        ...
    @overload
    def get_item(self, key : Literal["FVD"]) -> RuleVariation_606:
        ...
    @overload
    def get_item(self, key : Literal["TYPE"]) -> RuleVariation_723:
        ...
    @overload
    def get_item(self, key : Literal["CROSS"]) -> RuleVariation_794:
        ...
    @overload
    def get_item(self, key : Literal["DIV"]) -> RuleVariation_875:
        ...
    @overload
    def get_item(self, key : Literal["RRC"]) -> Optional[RuleVariation_35]:
        ...
    @overload
    def get_item(self, key : Literal["RTC"]) -> Optional[RuleVariation_407]:
        ...
    @overload
    def get_item(self, key : Literal["MRVA"]) -> Optional[RuleVariation_510]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_619]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_701]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_805]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_887]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_33]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_402]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_509]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_618]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_700]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_806]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1294(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1373.cv_arg
    cv_variation: TypeAlias = Variation_1373

    @classmethod
    def create(cls, arg : "RuleVariation_1294.cv_arg") -> "RuleVariation_1294":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1373:
        return self.arg # type: ignore

class NonSpare_750(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1294.cv_arg
    cv_name = "CN"
    cv_title = "Conflict Nature"
    cv_rule: TypeAlias = RuleVariation_1294

    @classmethod
    def create(cls, arg : "NonSpare_750.cv_arg") -> "NonSpare_750":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1294:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1373:
        return self.rule.variation

class Variation_132(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 4
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_132.cv_arg") -> "Variation_132":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_132(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_132.cv_arg
    cv_variation: TypeAlias = Variation_132

    @classmethod
    def create(cls, arg : "RuleVariation_132.cv_arg") -> "RuleVariation_132":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_132:
        return self.arg # type: ignore

class NonSpare_1869(NonSpare):
    cv_arg: TypeAlias = RuleVariation_132.cv_arg
    cv_name = "TID"
    cv_title = "Identification of Conflict Categories Definition Table"
    cv_rule: TypeAlias = RuleVariation_132

    @classmethod
    def create(cls, arg : "NonSpare_1869.cv_arg") -> "NonSpare_1869":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_132:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_132:
        return self.rule.variation

class Item_1002(Item):
    cv_arg: TypeAlias = NonSpare_1869.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1869

    @classmethod
    def create(cls, arg : "Item_1002.cv_arg") -> "Item_1002":
        return cls._create(arg) # type: ignore

class Content_11(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "APW Low Severity", 1: "APW Medium Severity", 2: "APW High Severity"}

class RuleContent_11(RuleContentContextFree):
    cv_arg: TypeAlias = Content_11.cv_arg
    cv_content: TypeAlias = Content_11

    @property
    def content(self) -> Content_11:
        return self._get_content() # type: ignore

class Variation_779(Element):
    cv_arg: TypeAlias = RuleContent_11.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_11

    @classmethod
    def create(cls, arg: "Variation_779.cv_arg") -> "Variation_779":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_11:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_11:
        return self.rule.content

class Content_585(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Major seperation infringement and not (crossed and diverging)", 2: "Minor seperation infringement and not (crossed and diverging)", 3: "Major seperation infringement and (crossed and diverging)", 4: "Minor seperation infringement and (crossed and diverging)"}

class RuleContent_585(RuleContentContextFree):
    cv_arg: TypeAlias = Content_585.cv_arg
    cv_content: TypeAlias = Content_585

    @property
    def content(self) -> Content_585:
        return self._get_content() # type: ignore

class Variation_801(Element):
    cv_arg: TypeAlias = RuleContent_585.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_585

    @classmethod
    def create(cls, arg: "Variation_801.cv_arg") -> "Variation_801":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_585:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_585:
        return self.rule.content

class Content_213(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Filter not set", 1: "Filter set"}

class RuleContent_213(RuleContentContextFree):
    cv_arg: TypeAlias = Content_213.cv_arg
    cv_content: TypeAlias = Content_213

    @property
    def content(self) -> Content_213:
        return self._get_content() # type: ignore

class Variation_726(Element):
    cv_arg: TypeAlias = RuleContent_213.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_213

    @classmethod
    def create(cls, arg: "Variation_726.cv_arg") -> "Variation_726":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_213:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_213:
        return self.rule.content

class RuleVariation_715(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_726.cv_arg
    cv_variation: TypeAlias = Variation_726

    @classmethod
    def create(cls, arg : "RuleVariation_715.cv_arg") -> "RuleVariation_715":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_726:
        return self.arg # type: ignore

class NonSpare_1202(NonSpare):
    cv_arg: TypeAlias = RuleVariation_715.cv_arg
    cv_name = "LPF"
    cv_title = "Linear Prediction Filter"
    cv_rule: TypeAlias = RuleVariation_715

    @classmethod
    def create(cls, arg : "NonSpare_1202.cv_arg") -> "NonSpare_1202":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_715:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_726:
        return self.rule.variation

class Item_507(Item):
    cv_arg: TypeAlias = NonSpare_1202.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1202

    @classmethod
    def create(cls, arg : "Item_507.cv_arg") -> "Item_507":
        return cls._create(arg) # type: ignore

class Variation_854(Element):
    cv_arg: TypeAlias = RuleContent_213.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_213

    @classmethod
    def create(cls, arg: "Variation_854.cv_arg") -> "Variation_854":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_213:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_213:
        return self.rule.content

class RuleVariation_824(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_854.cv_arg
    cv_variation: TypeAlias = Variation_854

    @classmethod
    def create(cls, arg : "RuleVariation_824.cv_arg") -> "RuleVariation_824":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_854:
        return self.arg # type: ignore

class NonSpare_824(NonSpare):
    cv_arg: TypeAlias = RuleVariation_824.cv_arg
    cv_name = "CPF"
    cv_title = "Current Proximity Filter"
    cv_rule: TypeAlias = RuleVariation_824

    @classmethod
    def create(cls, arg : "NonSpare_824.cv_arg") -> "NonSpare_824":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_824:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_854:
        return self.rule.variation

class Item_210(Item):
    cv_arg: TypeAlias = NonSpare_824.cv_arg
    cv_non_spare: TypeAlias = NonSpare_824

    @classmethod
    def create(cls, arg : "Item_210.cv_arg") -> "Item_210":
        return cls._create(arg) # type: ignore

class Variation_930(Element):
    cv_arg: TypeAlias = RuleContent_213.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_213

    @classmethod
    def create(cls, arg: "Variation_930.cv_arg") -> "Variation_930":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_213:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_213:
        return self.rule.content

class RuleVariation_900(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_930.cv_arg
    cv_variation: TypeAlias = Variation_930

    @classmethod
    def create(cls, arg : "RuleVariation_900.cv_arg") -> "RuleVariation_900":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_930:
        return self.arg # type: ignore

class NonSpare_1284(NonSpare):
    cv_arg: TypeAlias = RuleVariation_900.cv_arg
    cv_name = "MHF"
    cv_title = "Manoeuvre Hazard Filter"
    cv_rule: TypeAlias = RuleVariation_900

    @classmethod
    def create(cls, arg : "NonSpare_1284.cv_arg") -> "NonSpare_1284":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_900:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_930:
        return self.rule.variation

class Item_551(Item):
    cv_arg: TypeAlias = NonSpare_1284.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1284

    @classmethod
    def create(cls, arg : "Item_551.cv_arg") -> "Item_551":
        return cls._create(arg) # type: ignore

class Variation_1346(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_715.cv_arg, Tuple[Literal["LPF"], RuleVariation_715.cv_arg]], Union[RuleVariation_824.cv_arg, Tuple[Literal["CPF"], RuleVariation_824.cv_arg]], Union[RuleVariation_900.cv_arg, Tuple[Literal["MHF"], RuleVariation_900.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1346.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_507, 1), (Item_210, 1), (Item_551, 1)]
    cv_items_dict = {"LPF": RuleVariation_715, "CPF": RuleVariation_824, "MHF": RuleVariation_900}

    @overload
    @classmethod
    def spec(cls, key : Literal["LPF"]) -> Type[RuleVariation_715]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPF"]) -> Type[RuleVariation_824]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MHF"]) -> Type[RuleVariation_900]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LPF"], Literal["CPF"], Literal["MHF"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LPF"]) -> RuleVariation_715:
        ...
    @overload
    def get_item(self, key : Literal["CPF"]) -> RuleVariation_824:
        ...
    @overload
    def get_item(self, key : Literal["MHF"]) -> RuleVariation_900:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1346.cv_arg") -> 'Variation_1346':
        return cls._create(arg) # type: ignore

class Content_459(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Stage One Alert", 1: "Stage Two Alert"}

class RuleContent_459(RuleContentContextFree):
    cv_arg: TypeAlias = Content_459.cv_arg
    cv_content: TypeAlias = Content_459

    @property
    def content(self) -> Content_459:
        return self._get_content() # type: ignore

class Variation_753(Element):
    cv_arg: TypeAlias = RuleContent_459.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_459

    @classmethod
    def create(cls, arg: "Variation_753.cv_arg") -> "Variation_753":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_459:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_459:
        return self.rule.content

class RuleVariation_742(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_753.cv_arg
    cv_variation: TypeAlias = Variation_753

    @classmethod
    def create(cls, arg : "RuleVariation_742.cv_arg") -> "RuleVariation_742":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_753:
        return self.arg # type: ignore

class NonSpare_1556(NonSpare):
    cv_arg: TypeAlias = RuleVariation_742.cv_arg
    cv_name = "RAS"
    cv_title = "RIMCAS Alert Stage"
    cv_rule: TypeAlias = RuleVariation_742

    @classmethod
    def create(cls, arg : "NonSpare_1556.cv_arg") -> "NonSpare_1556":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_742:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_753:
        return self.rule.variation

class Item_781(Item):
    cv_arg: TypeAlias = NonSpare_1556.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1556

    @classmethod
    def create(cls, arg : "Item_781.cv_arg") -> "Item_781":
        return cls._create(arg) # type: ignore

class Variation_1347(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_742.cv_arg, Tuple[Literal["RAS"], RuleVariation_742.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1347.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_781, 1), (Item_24, 2)]
    cv_items_dict = {"RAS": RuleVariation_742}

    @classmethod
    def spec(cls, key : Literal["RAS"]) -> Type[RuleVariation_742]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["RAS"]) -> RuleVariation_742:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1347.cv_arg") -> 'Variation_1347':
        return cls._create(arg) # type: ignore

class Content_4(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "2 aircraft, same taxiway, opposite direction", 1: "Aircraft entering wrong direction", 2: "Aircraft entering wrong taxiway", 3: "Speed violation"}

class RuleContent_4(RuleContentContextFree):
    cv_arg: TypeAlias = Content_4.cv_arg
    cv_content: TypeAlias = Content_4

    @property
    def content(self) -> Content_4:
        return self._get_content() # type: ignore

class Variation_778(Element):
    cv_arg: TypeAlias = RuleContent_4.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_4

    @classmethod
    def create(cls, arg: "Variation_778.cv_arg") -> "Variation_778":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_4:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_4:
        return self.rule.content

class Content_558(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VRM Slow Climb", 1: "VRM Slow Descent"}

class RuleContent_558(RuleContentContextFree):
    cv_arg: TypeAlias = Content_558.cv_arg
    cv_content: TypeAlias = Content_558

    @property
    def content(self) -> Content_558:
        return self._get_content() # type: ignore

class Variation_798(Element):
    cv_arg: TypeAlias = RuleContent_558.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_558

    @classmethod
    def create(cls, arg: "Variation_798.cv_arg") -> "Variation_798":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_558:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_558:
        return self.rule.content

class Content_559(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VTM Fast Climb", 1: "VTM Fast Descent"}

class RuleContent_559(RuleContentContextFree):
    cv_arg: TypeAlias = Content_559.cv_arg
    cv_content: TypeAlias = Content_559

    @property
    def content(self) -> Content_559:
        return self._get_content() # type: ignore

class Variation_799(Element):
    cv_arg: TypeAlias = RuleContent_559.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_559

    @classmethod
    def create(cls, arg: "Variation_799.cv_arg") -> "Variation_799":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_559:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_559:
        return self.rule.content

class Content_564(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Vertical manoeuvre deviation prior to reaching its expected level", 1: "Vertical manoeuvre deviation past its expected level"}

class RuleContent_564(RuleContentContextFree):
    cv_arg: TypeAlias = Content_564.cv_arg
    cv_content: TypeAlias = Content_564

    @property
    def content(self) -> Content_564:
        return self._get_content() # type: ignore

class Variation_800(Element):
    cv_arg: TypeAlias = RuleContent_564.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_564

    @classmethod
    def create(cls, arg: "Variation_800.cv_arg") -> "Variation_800":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_564:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_564:
        return self.rule.content

class Content_458(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Slow Descent", 1: "Fast Descent", 2: "Slow Climb", 3: "Fast Climb"}

class RuleContent_458(RuleContentContextFree):
    cv_arg: TypeAlias = Content_458.cv_arg
    cv_content: TypeAlias = Content_458

    @property
    def content(self) -> Content_458:
        return self._get_content() # type: ignore

class Variation_793(Element):
    cv_arg: TypeAlias = RuleContent_458.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_458

    @classmethod
    def create(cls, arg: "Variation_793.cv_arg") -> "Variation_793":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_458:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_458:
        return self.rule.content

class Content_12(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Above", 1: "Below"}

class RuleContent_12(RuleContentContextFree):
    cv_arg: TypeAlias = Content_12.cv_arg
    cv_content: TypeAlias = Content_12

    @property
    def content(self) -> Content_12:
        return self._get_content() # type: ignore

class Variation_780(Element):
    cv_arg: TypeAlias = RuleContent_12.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_12

    @classmethod
    def create(cls, arg: "Variation_780.cv_arg") -> "Variation_780":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_12:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_12:
        return self.rule.content

class Content_478(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Table - Single RWY Operation", 1: "MRS - Single RWY Operation", 2: "ROT - Single RWY Operation", 3: "GAP - Single RWY Operation", 4: "Table - Parallel RWY Operation", 5: "MRS - Parallel RWY Operation", 6: "ROT - Parallel RWY Operation", 7: "GAP - Parallel RWY Operation"}

class RuleContent_478(RuleContentContextFree):
    cv_arg: TypeAlias = Content_478.cv_arg
    cv_content: TypeAlias = Content_478

    @property
    def content(self) -> Content_478:
        return self._get_content() # type: ignore

class Variation_794(Element):
    cv_arg: TypeAlias = RuleContent_478.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_478

    @classmethod
    def create(cls, arg: "Variation_794.cv_arg") -> "Variation_794":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_478:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_478:
        return self.rule.content

class Content_209(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "End of Alert", 1: "Planned Alert", 2: "Alert on TABLE Indicator", 3: "Alert on MRS Indicator", 4: "Alert on ROT Indicator", 5: "Alert on GAP Indicator"}

class RuleContent_209(RuleContentContextFree):
    cv_arg: TypeAlias = Content_209.cv_arg
    cv_content: TypeAlias = Content_209

    @property
    def content(self) -> Content_209:
        return self._get_content() # type: ignore

class Variation_785(Element):
    cv_arg: TypeAlias = RuleContent_209.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_209

    @classmethod
    def create(cls, arg: "Variation_785.cv_arg") -> "Variation_785":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_209:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_209:
        return self.rule.content

class Content_258(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Line-Up vs. Line-Up", 1: "Line-Up vs. Cross or Enter", 2: "Line-Up vs. Take-Off", 3: "Line-Up vs. Landing"}

class RuleContent_258(RuleContentContextFree):
    cv_arg: TypeAlias = Content_258.cv_arg
    cv_content: TypeAlias = Content_258

    @property
    def content(self) -> Content_258:
        return self._get_content() # type: ignore

class Variation_787(Element):
    cv_arg: TypeAlias = RuleContent_258.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_258

    @classmethod
    def create(cls, arg: "Variation_787.cv_arg") -> "Variation_787":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_258:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_258:
        return self.rule.content

class Content_71(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Cross or Enter  vs. Line-Up", 1: "Cross or Enter  vs. Cross or Enter", 2: "Cross or Enter  vs. Take-Off", 3: "Cross or Enter  vs. Landing"}

class RuleContent_71(RuleContentContextFree):
    cv_arg: TypeAlias = Content_71.cv_arg
    cv_content: TypeAlias = Content_71

    @property
    def content(self) -> Content_71:
        return self._get_content() # type: ignore

class Variation_784(Element):
    cv_arg: TypeAlias = RuleContent_71.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_71

    @classmethod
    def create(cls, arg: "Variation_784.cv_arg") -> "Variation_784":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_71:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_71:
        return self.rule.content

class Content_479(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Take-Off vs. Line-Up", 1: "Take-Off vs. Cross or Enter", 2: "Take-Off vs. Take-Off", 3: "Take-Off vs. Landing"}

class RuleContent_479(RuleContentContextFree):
    cv_arg: TypeAlias = Content_479.cv_arg
    cv_content: TypeAlias = Content_479

    @property
    def content(self) -> Content_479:
        return self._get_content() # type: ignore

class Variation_795(Element):
    cv_arg: TypeAlias = RuleContent_479.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_479

    @classmethod
    def create(cls, arg: "Variation_795.cv_arg") -> "Variation_795":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_479:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_479:
        return self.rule.content

class Content_255(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Landing vs. Line-Up", 1: "Landing vs. Cross or Enter", 2: "Landing vs. Take-Off", 3: "Landing vs. Landing"}

class RuleContent_255(RuleContentContextFree):
    cv_arg: TypeAlias = Content_255.cv_arg
    cv_content: TypeAlias = Content_255

    @property
    def content(self) -> Content_255:
        return self._get_content() # type: ignore

class Variation_786(Element):
    cv_arg: TypeAlias = RuleContent_255.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_255

    @classmethod
    def create(cls, arg: "Variation_786.cv_arg") -> "Variation_786":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_255:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_255:
        return self.rule.content

class Content_433(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Push-Back vs. Push-Back", 1: "Push-Back vs. Taxi"}

class RuleContent_433(RuleContentContextFree):
    cv_arg: TypeAlias = Content_433.cv_arg
    cv_content: TypeAlias = Content_433

    @property
    def content(self) -> Content_433:
        return self._get_content() # type: ignore

class Variation_792(Element):
    cv_arg: TypeAlias = RuleContent_433.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_433

    @classmethod
    def create(cls, arg: "Variation_792.cv_arg") -> "Variation_792":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_433:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_433:
        return self.rule.content

class Content_486(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Taxi vs. Push-Back", 1: "TAxi vs. Taxi"}

class RuleContent_486(RuleContentContextFree):
    cv_arg: TypeAlias = Content_486.cv_arg
    cv_content: TypeAlias = Content_486

    @property
    def content(self) -> Content_486:
        return self._get_content() # type: ignore

class Variation_796(Element):
    cv_arg: TypeAlias = RuleContent_486.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_486

    @classmethod
    def create(cls, arg: "Variation_796.cv_arg") -> "Variation_796":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_486:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_486:
        return self.rule.content

class Content_315(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Push-Back Clearance", 1: "No Taxi Clearance", 2: "No Line-Up Clearance", 3: "No Crossing Clearance", 4: "No Enter Clearance", 5: "No Take-Off Clearance", 6: "Landing Clearance"}

class RuleContent_315(RuleContentContextFree):
    cv_arg: TypeAlias = Content_315.cv_arg
    cv_content: TypeAlias = Content_315

    @property
    def content(self) -> Content_315:
        return self._get_content() # type: ignore

class Variation_788(Element):
    cv_arg: TypeAlias = RuleContent_315.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_315

    @classmethod
    def create(cls, arg: "Variation_788.cv_arg") -> "Variation_788":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_315:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_315:
        return self.rule.content

class Content_22(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "After Push-Back Clearance", 1: "After Taxi Clearance", 2: "After Line-Up Clearance", 3: "After Crossing Clearance", 4: "After Enter Clearance", 5: "After Take-Off Clearance", 6: "Stationary on Runway", 7: "Stationary on Taxiway"}

class RuleContent_22(RuleContentContextFree):
    cv_arg: TypeAlias = Content_22.cv_arg
    cv_content: TypeAlias = Content_22

    @property
    def content(self) -> Content_22:
        return self._get_content() # type: ignore

class Variation_783(Element):
    cv_arg: TypeAlias = RuleContent_22.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_22

    @classmethod
    def create(cls, arg: "Variation_783.cv_arg") -> "Variation_783":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_22:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_22:
        return self.rule.content

class Content_344(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No contact (receiving ATSU)", 1: "No transfer (leaving ATSU)"}

class RuleContent_344(RuleContentContextFree):
    cv_arg: TypeAlias = Content_344.cv_arg
    cv_content: TypeAlias = Content_344

    @property
    def content(self) -> Content_344:
        return self._get_content() # type: ignore

class Variation_789(Element):
    cv_arg: TypeAlias = RuleContent_344.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_344

    @classmethod
    def create(cls, arg: "Variation_789.cv_arg") -> "Variation_789":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_344:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_344:
        return self.rule.content

class RuleVariation_1451(RuleVariationDependent):
    cv_arg: TypeAlias = Union[
        Variation_776.cv_arg,
        Variation_779.cv_arg,
        Variation_801.cv_arg,
        Variation_1346.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_778.cv_arg,
        Variation_798.cv_arg,
        Variation_799.cv_arg,
        Variation_800.cv_arg,
        Variation_793.cv_arg,
        Variation_780.cv_arg,
        Variation_794.cv_arg,
        Variation_794.cv_arg,
        Variation_785.cv_arg,
        Variation_787.cv_arg,
        Variation_784.cv_arg,
        Variation_795.cv_arg,
        Variation_786.cv_arg,
        Variation_792.cv_arg,
        Variation_796.cv_arg,
        Variation_788.cv_arg,
        Variation_783.cv_arg,
        Variation_789.cv_arg,
    ]
    cv_depends_on = [["000"], ["120", "CC", "TID"]]
    cv_default_variation: TypeAlias = Variation_776
    cv_cases = [
        ([5, 1], Variation_779),
        ([7, 0], Variation_801),
        ([7, 1], Variation_1346),
        ([9, 2], Variation_1347),
        ([10, 2], Variation_1347),
        ([11, 2], Variation_1347),
        ([12, 2], Variation_1347),
        ([13, 2], Variation_1347),
        ([14, 2], Variation_1347),
        ([15, 2], Variation_1347),
        ([16, 2], Variation_1347),
        ([15, 1], Variation_778),
        ([24, 1], Variation_798),
        ([24, 2], Variation_799),
        ([26, 1], Variation_800),
        ([27, 1], Variation_793),
        ([27, 2], Variation_780),
        ([33, 1], Variation_794),
        ([34, 1], Variation_794),
        ([35, 1], Variation_785),
        ([38, 0], Variation_787),
        ([38, 1], Variation_784),
        ([38, 2], Variation_795),
        ([38, 3], Variation_786),
        ([38, 4], Variation_792),
        ([38, 5], Variation_796),
        ([39, 1], Variation_788),
        ([40, 1], Variation_783),
        ([41, 1], Variation_789),
    ]

    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[5], Literal[1]]) -> Variation_779:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[0]]) -> Variation_801:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[1]]) -> Variation_1346:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[9], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[10], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[11], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[12], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[13], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[14], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[16], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[1]]) -> Variation_778:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[1]]) -> Variation_798:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[2]]) -> Variation_799:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[26], Literal[1]]) -> Variation_800:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[1]]) -> Variation_793:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[2]]) -> Variation_780:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[33], Literal[1]]) -> Variation_794:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[34], Literal[1]]) -> Variation_794:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[35], Literal[1]]) -> Variation_785:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[0]]) -> Variation_787:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[1]]) -> Variation_784:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[2]]) -> Variation_795:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[3]]) -> Variation_786:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[4]]) -> Variation_792:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[5]]) -> Variation_796:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[39], Literal[1]]) -> Variation_788:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[40], Literal[1]]) -> Variation_783:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[41], Literal[1]]) -> Variation_789:
        ...

    @classmethod
    def variation(cls, key : Any) -> Any:
        return cls._variation(key)

    @classmethod
    def create(cls, arg : "RuleVariation_1451.cv_arg") -> "RuleVariation_1451":
        return cls._create(arg) # type: ignore

class NonSpare_821(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1451.cv_arg
    cv_name = "CPC"
    cv_title = "Conflict Properties Class"
    cv_rule: TypeAlias = RuleVariation_1451

    @classmethod
    def create(cls, arg : "NonSpare_821.cv_arg") -> "NonSpare_821":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1451:
        return self.arg # type: ignore

class Item_208(Item):
    cv_arg: TypeAlias = NonSpare_821.cv_arg
    cv_non_spare: TypeAlias = NonSpare_821

    @classmethod
    def create(cls, arg : "Item_208.cv_arg") -> "Item_208":
        return cls._create(arg) # type: ignore

class Content_254(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "LOW", 1: "HIGH"}

class RuleContent_254(RuleContentContextFree):
    cv_arg: TypeAlias = Content_254.cv_arg
    cv_content: TypeAlias = Content_254

    @property
    def content(self) -> Content_254:
        return self._get_content() # type: ignore

class Variation_985(Element):
    cv_arg: TypeAlias = RuleContent_254.cv_arg
    cv_bit_offset8 = 7
    cv_bit_size = 1
    cv_rule = RuleContent_254

    @classmethod
    def create(cls, arg: "Variation_985.cv_arg") -> "Variation_985":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_254:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_254:
        return self.rule.content

class RuleVariation_955(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_985.cv_arg
    cv_variation: TypeAlias = Variation_985

    @classmethod
    def create(cls, arg : "RuleVariation_955.cv_arg") -> "RuleVariation_955":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_985:
        return self.arg # type: ignore

class NonSpare_838(NonSpare):
    cv_arg: TypeAlias = RuleVariation_955.cv_arg
    cv_name = "CS"
    cv_title = "Conflict Severity"
    cv_rule: TypeAlias = RuleVariation_955

    @classmethod
    def create(cls, arg : "NonSpare_838.cv_arg") -> "NonSpare_838":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_955:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_985:
        return self.rule.variation

class Item_220(Item):
    cv_arg: TypeAlias = NonSpare_838.cv_arg
    cv_non_spare: TypeAlias = NonSpare_838

    @classmethod
    def create(cls, arg : "Item_220.cv_arg") -> "Item_220":
        return cls._create(arg) # type: ignore

class Variation_1231(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_132.cv_arg, Tuple[Literal["TID"], RuleVariation_132.cv_arg]], Union[RuleVariation_1451.cv_arg, Tuple[Literal["CPC"], RuleVariation_1451.cv_arg]], Union[RuleVariation_955.cv_arg, Tuple[Literal["CS"], RuleVariation_955.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1231.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1002, 4), (Item_208, 3), (Item_220, 1)]
    cv_items_dict = {"TID": RuleVariation_132, "CPC": RuleVariation_1451, "CS": RuleVariation_955}

    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> Type[RuleVariation_132]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> Type[RuleVariation_1451]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CS"]) -> Type[RuleVariation_955]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TID"], Literal["CPC"], Literal["CS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_132:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> RuleVariation_1451:
        ...
    @overload
    def get_item(self, key : Literal["CS"]) -> RuleVariation_955:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1231.cv_arg") -> 'Variation_1231':
        return cls._create(arg) # type: ignore

class RuleVariation_1171(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1231.cv_arg
    cv_variation: TypeAlias = Variation_1231

    @classmethod
    def create(cls, arg : "RuleVariation_1171.cv_arg") -> "RuleVariation_1171":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1231:
        return self.arg # type: ignore

class NonSpare_714(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1171.cv_arg
    cv_name = "CC"
    cv_title = "Conflict Classification"
    cv_rule: TypeAlias = RuleVariation_1171

    @classmethod
    def create(cls, arg : "NonSpare_714.cv_arg") -> "NonSpare_714":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1171:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1231:
        return self.rule.variation

class Content_732(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["%"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.5
    cv_unit = "%"

    def as_quantity(self, cv_unit : Optional[Literal["%"]] = None) -> float:
        return self._as_quantity()

class RuleContent_732(RuleContentContextFree):
    cv_arg: TypeAlias = Content_732.cv_arg
    cv_content: TypeAlias = Content_732

    @property
    def content(self) -> Content_732:
        return self._get_content() # type: ignore

class Variation_226(Element):
    cv_arg: TypeAlias = RuleContent_732.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_732

    @classmethod
    def create(cls, arg: "Variation_226.cv_arg") -> "Variation_226":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_732:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_732:
        return self.rule.content

class RuleVariation_219(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_226.cv_arg
    cv_variation: TypeAlias = Variation_226

    @classmethod
    def create(cls, arg : "RuleVariation_219.cv_arg") -> "RuleVariation_219":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_226:
        return self.arg # type: ignore

class NonSpare_819(NonSpare):
    cv_arg: TypeAlias = RuleVariation_219.cv_arg
    cv_name = "CP"
    cv_title = "Conflict Probability"
    cv_rule: TypeAlias = RuleVariation_219

    @classmethod
    def create(cls, arg : "NonSpare_819.cv_arg") -> "NonSpare_819":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_219:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_226:
        return self.rule.variation

class NonSpare_717(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "CD"
    cv_title = "Conflict Duration"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_717.cv_arg") -> "NonSpare_717":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class Variation_1488(Compound):
    cv_arg = TypedDict('cv_arg', {
        "CN": NonSpare_750.cv_arg,
        "CC": NonSpare_714.cv_arg,
        "CP": NonSpare_819.cv_arg,
        "CD": NonSpare_717.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_750, NonSpare_714, NonSpare_819, NonSpare_717]
    cv_items_dict = {"CN": NonSpare_750, "CC": NonSpare_714, "CP": NonSpare_819, "CD": NonSpare_717}

    @overload
    @classmethod
    def spec(cls, key : Literal["CN"]) -> Type[NonSpare_750]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CC"]) -> Type[NonSpare_714]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> Type[NonSpare_819]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CD"]) -> Type[NonSpare_717]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CN"], Literal["CC"], Literal["CP"], Literal["CD"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CN"]) -> Optional[NonSpare_750]:
        ...
    @overload
    def get_item(self, key : Literal["CC"]) -> Optional[NonSpare_714]:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> Optional[NonSpare_819]:
        ...
    @overload
    def get_item(self, key : Literal["CD"]) -> Optional[NonSpare_717]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["CN"], val : NonSpare_750.cv_arg) -> "Variation_1488":
        ...
    @overload
    def set_item(self, key : Literal["CC"], val : NonSpare_714.cv_arg) -> "Variation_1488":
        ...
    @overload
    def set_item(self, key : Literal["CP"], val : NonSpare_819.cv_arg) -> "Variation_1488":
        ...
    @overload
    def set_item(self, key : Literal["CD"], val : NonSpare_717.cv_arg) -> "Variation_1488":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["CN"]) -> "Variation_1488":
        ...
    @overload
    def del_item(self, key : Literal["CC"]) -> "Variation_1488":
        ...
    @overload
    def del_item(self, key : Literal["CP"]) -> "Variation_1488":
        ...
    @overload
    def del_item(self, key : Literal["CD"]) -> "Variation_1488":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1488.cv_arg") -> 'Variation_1488':
        return cls._create(arg) # type: ignore

class RuleVariation_1409(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1488.cv_arg
    cv_variation: TypeAlias = Variation_1488

    @classmethod
    def create(cls, arg : "RuleVariation_1409.cv_arg") -> "RuleVariation_1409":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1488:
        return self.arg # type: ignore

class NonSpare_298(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1409.cv_arg
    cv_name = "120"
    cv_title = "Conflict Characteristics"
    cv_rule: TypeAlias = RuleVariation_1409

    @classmethod
    def create(cls, arg : "NonSpare_298.cv_arg") -> "NonSpare_298":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1409:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1488:
        return self.rule.variation

class UapItem_298(UapItem):
    cv_non_spare: TypeAlias = NonSpare_298

class NonSpare_1842(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TC"
    cv_title = "Time to Conflict"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1842.cv_arg") -> "NonSpare_1842":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class NonSpare_1846(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TCA"
    cv_title = "Time to Closest Approach"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1846.cv_arg") -> "NonSpare_1846":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class Variation_366(Element):
    cv_arg: TypeAlias = RuleContent_733.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_733

    @classmethod
    def create(cls, arg: "Variation_366.cv_arg") -> "Variation_366":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_733:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_733:
        return self.rule.content

class RuleVariation_359(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_366.cv_arg
    cv_variation: TypeAlias = Variation_366

    @classmethod
    def create(cls, arg : "RuleVariation_359.cv_arg") -> "RuleVariation_359":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_366:
        return self.arg # type: ignore

class NonSpare_742(NonSpare):
    cv_arg: TypeAlias = RuleVariation_359.cv_arg
    cv_name = "CHS"
    cv_title = "Current Horizontal Separation"
    cv_rule: TypeAlias = RuleVariation_359

    @classmethod
    def create(cls, arg : "NonSpare_742.cv_arg") -> "NonSpare_742":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_359:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_366:
        return self.rule.variation

class NonSpare_1287(NonSpare):
    cv_arg: TypeAlias = RuleVariation_304.cv_arg
    cv_name = "MHS"
    cv_title = "Estimated Minimum Horizontal Separation"
    cv_rule: TypeAlias = RuleVariation_304

    @classmethod
    def create(cls, arg : "NonSpare_1287.cv_arg") -> "NonSpare_1287":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_304:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_311:
        return self.rule.variation

class Content_730(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_730(RuleContentContextFree):
    cv_arg: TypeAlias = Content_730.cv_arg
    cv_content: TypeAlias = Content_730

    @property
    def content(self) -> Content_730:
        return self._get_content() # type: ignore

class Variation_310(Element):
    cv_arg: TypeAlias = RuleContent_730.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_730

    @classmethod
    def create(cls, arg: "Variation_310.cv_arg") -> "Variation_310":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_730:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_730:
        return self.rule.content

class RuleVariation_303(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_310.cv_arg
    cv_variation: TypeAlias = Variation_310

    @classmethod
    def create(cls, arg : "RuleVariation_303.cv_arg") -> "RuleVariation_303":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_310:
        return self.arg # type: ignore

class NonSpare_857(NonSpare):
    cv_arg: TypeAlias = RuleVariation_303.cv_arg
    cv_name = "CVS"
    cv_title = "Current Vertical Separation"
    cv_rule: TypeAlias = RuleVariation_303

    @classmethod
    def create(cls, arg : "NonSpare_857.cv_arg") -> "NonSpare_857":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_303:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_310:
        return self.rule.variation

class NonSpare_1347(NonSpare):
    cv_arg: TypeAlias = RuleVariation_303.cv_arg
    cv_name = "MVS"
    cv_title = "Estimated Minimum Vertical Separation"
    cv_rule: TypeAlias = RuleVariation_303

    @classmethod
    def create(cls, arg : "NonSpare_1347.cv_arg") -> "NonSpare_1347":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_303:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_310:
        return self.rule.variation

class Variation_1524(Compound):
    cv_arg = TypedDict('cv_arg', {
        "TC": NonSpare_1842.cv_arg,
        "TCA": NonSpare_1846.cv_arg,
        "CHS": NonSpare_742.cv_arg,
        "MHS": NonSpare_1287.cv_arg,
        "CVS": NonSpare_857.cv_arg,
        "MVS": NonSpare_1347.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_1842, NonSpare_1846, NonSpare_742, NonSpare_1287, NonSpare_857, NonSpare_1347]
    cv_items_dict = {"TC": NonSpare_1842, "TCA": NonSpare_1846, "CHS": NonSpare_742, "MHS": NonSpare_1287, "CVS": NonSpare_857, "MVS": NonSpare_1347}

    @overload
    @classmethod
    def spec(cls, key : Literal["TC"]) -> Type[NonSpare_1842]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TCA"]) -> Type[NonSpare_1846]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CHS"]) -> Type[NonSpare_742]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MHS"]) -> Type[NonSpare_1287]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CVS"]) -> Type[NonSpare_857]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MVS"]) -> Type[NonSpare_1347]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TC"], Literal["TCA"], Literal["CHS"], Literal["MHS"], Literal["CVS"], Literal["MVS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TC"]) -> Optional[NonSpare_1842]:
        ...
    @overload
    def get_item(self, key : Literal["TCA"]) -> Optional[NonSpare_1846]:
        ...
    @overload
    def get_item(self, key : Literal["CHS"]) -> Optional[NonSpare_742]:
        ...
    @overload
    def get_item(self, key : Literal["MHS"]) -> Optional[NonSpare_1287]:
        ...
    @overload
    def get_item(self, key : Literal["CVS"]) -> Optional[NonSpare_857]:
        ...
    @overload
    def get_item(self, key : Literal["MVS"]) -> Optional[NonSpare_1347]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["TC"], val : NonSpare_1842.cv_arg) -> "Variation_1524":
        ...
    @overload
    def set_item(self, key : Literal["TCA"], val : NonSpare_1846.cv_arg) -> "Variation_1524":
        ...
    @overload
    def set_item(self, key : Literal["CHS"], val : NonSpare_742.cv_arg) -> "Variation_1524":
        ...
    @overload
    def set_item(self, key : Literal["MHS"], val : NonSpare_1287.cv_arg) -> "Variation_1524":
        ...
    @overload
    def set_item(self, key : Literal["CVS"], val : NonSpare_857.cv_arg) -> "Variation_1524":
        ...
    @overload
    def set_item(self, key : Literal["MVS"], val : NonSpare_1347.cv_arg) -> "Variation_1524":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["TC"]) -> "Variation_1524":
        ...
    @overload
    def del_item(self, key : Literal["TCA"]) -> "Variation_1524":
        ...
    @overload
    def del_item(self, key : Literal["CHS"]) -> "Variation_1524":
        ...
    @overload
    def del_item(self, key : Literal["MHS"]) -> "Variation_1524":
        ...
    @overload
    def del_item(self, key : Literal["CVS"]) -> "Variation_1524":
        ...
    @overload
    def del_item(self, key : Literal["MVS"]) -> "Variation_1524":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1524.cv_arg") -> 'Variation_1524':
        return cls._create(arg) # type: ignore

class RuleVariation_1445(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1524.cv_arg
    cv_variation: TypeAlias = Variation_1524

    @classmethod
    def create(cls, arg : "RuleVariation_1445.cv_arg") -> "RuleVariation_1445":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1524:
        return self.arg # type: ignore

class NonSpare_205(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1445.cv_arg
    cv_name = "070"
    cv_title = "Conflict Timing and Separation"
    cv_rule: TypeAlias = RuleVariation_1445

    @classmethod
    def create(cls, arg : "NonSpare_205.cv_arg") -> "NonSpare_205":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1445:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1524:
        return self.rule.variation

class UapItem_205(UapItem):
    cv_non_spare: TypeAlias = NonSpare_205

class Content_634(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 25.0
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_634(RuleContentContextFree):
    cv_arg: TypeAlias = Content_634.cv_arg
    cv_content: TypeAlias = Content_634

    @property
    def content(self) -> Content_634:
        return self._get_content() # type: ignore

class Variation_262(Element):
    cv_arg: TypeAlias = RuleContent_634.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_634

    @classmethod
    def create(cls, arg: "Variation_262.cv_arg") -> "Variation_262":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_634:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_634:
        return self.rule.content

class RuleVariation_255(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_262.cv_arg
    cv_variation: TypeAlias = Variation_262

    @classmethod
    def create(cls, arg : "RuleVariation_255.cv_arg") -> "RuleVariation_255":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_262:
        return self.arg # type: ignore

class NonSpare_231(NonSpare):
    cv_arg: TypeAlias = RuleVariation_255.cv_arg
    cv_name = "076"
    cv_title = "Vertical Deviation"
    cv_rule: TypeAlias = RuleVariation_255

    @classmethod
    def create(cls, arg : "NonSpare_231.cv_arg") -> "NonSpare_231":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_255:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_262:
        return self.rule.variation

class UapItem_231(UapItem):
    cv_non_spare: TypeAlias = NonSpare_231

class Content_639(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 32.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_639(RuleContentContextFree):
    cv_arg: TypeAlias = Content_639.cv_arg
    cv_content: TypeAlias = Content_639

    @property
    def content(self) -> Content_639:
        return self._get_content() # type: ignore

class Variation_264(Element):
    cv_arg: TypeAlias = RuleContent_639.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_639

    @classmethod
    def create(cls, arg: "Variation_264.cv_arg") -> "Variation_264":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_639:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_639:
        return self.rule.content

class RuleVariation_257(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_264.cv_arg
    cv_variation: TypeAlias = Variation_264

    @classmethod
    def create(cls, arg : "RuleVariation_257.cv_arg") -> "RuleVariation_257":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_264:
        return self.arg # type: ignore

class NonSpare_226(NonSpare):
    cv_arg: TypeAlias = RuleVariation_257.cv_arg
    cv_name = "074"
    cv_title = "Longitudinal Deviation"
    cv_rule: TypeAlias = RuleVariation_257

    @classmethod
    def create(cls, arg : "NonSpare_226.cv_arg") -> "NonSpare_226":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_257:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_264:
        return self.rule.variation

class UapItem_226(UapItem):
    cv_non_spare: TypeAlias = NonSpare_226

class NonSpare_229(NonSpare):
    cv_arg: TypeAlias = RuleVariation_345.cv_arg
    cv_name = "075"
    cv_title = "Transversal Distance Deviation"
    cv_rule: TypeAlias = RuleVariation_345

    @classmethod
    def create(cls, arg : "NonSpare_229.cv_arg") -> "NonSpare_229":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_345:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_352:
        return self.rule.variation

class UapItem_229(UapItem):
    cv_non_spare: TypeAlias = NonSpare_229

class NonSpare_612(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "AN"
    cv_title = "Area Name"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_612.cv_arg") -> "NonSpare_612":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_706(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "CAN"
    cv_title = "Crossing Area Name"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_706.cv_arg") -> "NonSpare_706":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1635(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "RT1"
    cv_title = "Runway/Taxiway Designator 1"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1635.cv_arg") -> "NonSpare_1635":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1636(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "RT2"
    cv_title = "Runway/Taxiway Designator 2"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1636.cv_arg") -> "NonSpare_1636":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1672(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "SB"
    cv_title = "Stop Bar Designator"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1672.cv_arg") -> "NonSpare_1672":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1017(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "G"
    cv_title = "Gate Designator"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_1017.cv_arg") -> "NonSpare_1017":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class Variation_1481(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AN": NonSpare_612.cv_arg,
        "CAN": NonSpare_706.cv_arg,
        "RT1": NonSpare_1635.cv_arg,
        "RT2": NonSpare_1636.cv_arg,
        "SB": NonSpare_1672.cv_arg,
        "G": NonSpare_1017.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_612, NonSpare_706, NonSpare_1635, NonSpare_1636, NonSpare_1672, NonSpare_1017]
    cv_items_dict = {"AN": NonSpare_612, "CAN": NonSpare_706, "RT1": NonSpare_1635, "RT2": NonSpare_1636, "SB": NonSpare_1672, "G": NonSpare_1017}

    @overload
    @classmethod
    def spec(cls, key : Literal["AN"]) -> Type[NonSpare_612]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CAN"]) -> Type[NonSpare_706]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RT1"]) -> Type[NonSpare_1635]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RT2"]) -> Type[NonSpare_1636]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SB"]) -> Type[NonSpare_1672]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> Type[NonSpare_1017]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AN"], Literal["CAN"], Literal["RT1"], Literal["RT2"], Literal["SB"], Literal["G"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AN"]) -> Optional[NonSpare_612]:
        ...
    @overload
    def get_item(self, key : Literal["CAN"]) -> Optional[NonSpare_706]:
        ...
    @overload
    def get_item(self, key : Literal["RT1"]) -> Optional[NonSpare_1635]:
        ...
    @overload
    def get_item(self, key : Literal["RT2"]) -> Optional[NonSpare_1636]:
        ...
    @overload
    def get_item(self, key : Literal["SB"]) -> Optional[NonSpare_1672]:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> Optional[NonSpare_1017]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AN"], val : NonSpare_612.cv_arg) -> "Variation_1481":
        ...
    @overload
    def set_item(self, key : Literal["CAN"], val : NonSpare_706.cv_arg) -> "Variation_1481":
        ...
    @overload
    def set_item(self, key : Literal["RT1"], val : NonSpare_1635.cv_arg) -> "Variation_1481":
        ...
    @overload
    def set_item(self, key : Literal["RT2"], val : NonSpare_1636.cv_arg) -> "Variation_1481":
        ...
    @overload
    def set_item(self, key : Literal["SB"], val : NonSpare_1672.cv_arg) -> "Variation_1481":
        ...
    @overload
    def set_item(self, key : Literal["G"], val : NonSpare_1017.cv_arg) -> "Variation_1481":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AN"]) -> "Variation_1481":
        ...
    @overload
    def del_item(self, key : Literal["CAN"]) -> "Variation_1481":
        ...
    @overload
    def del_item(self, key : Literal["RT1"]) -> "Variation_1481":
        ...
    @overload
    def del_item(self, key : Literal["RT2"]) -> "Variation_1481":
        ...
    @overload
    def del_item(self, key : Literal["SB"]) -> "Variation_1481":
        ...
    @overload
    def del_item(self, key : Literal["G"]) -> "Variation_1481":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1481.cv_arg") -> 'Variation_1481':
        return cls._create(arg) # type: ignore

class RuleVariation_1402(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1481.cv_arg
    cv_variation: TypeAlias = Variation_1481

    @classmethod
    def create(cls, arg : "RuleVariation_1402.cv_arg") -> "RuleVariation_1402":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1481:
        return self.arg # type: ignore

class NonSpare_268(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1402.cv_arg
    cv_name = "100"
    cv_title = "Area Definition"
    cv_rule: TypeAlias = RuleVariation_1402

    @classmethod
    def create(cls, arg : "NonSpare_268.cv_arg") -> "NonSpare_268":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1402:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1481:
        return self.rule.variation

class UapItem_268(UapItem):
    cv_non_spare: TypeAlias = NonSpare_268

class NonSpare_130(NonSpare):
    cv_arg: TypeAlias = RuleVariation_246.cv_arg
    cv_name = "035"
    cv_title = "Track Number 2"
    cv_rule: TypeAlias = RuleVariation_246

    @classmethod
    def create(cls, arg : "NonSpare_130.cv_arg") -> "NonSpare_130":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_253:
        return self.rule.variation

class UapItem_130(UapItem):
    cv_non_spare: TypeAlias = NonSpare_130

class NonSpare_589(NonSpare):
    cv_arg: TypeAlias = RuleVariation_385.cv_arg
    cv_name = "AI2"
    cv_title = "Aircraft Identifier (in 7 Characters) of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_385

    @classmethod
    def create(cls, arg : "NonSpare_589.cv_arg") -> "NonSpare_589":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_385:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_393:
        return self.rule.variation

class NonSpare_1313(NonSpare):
    cv_arg: TypeAlias = RuleVariation_782.cv_arg
    cv_name = "MODE3A"
    cv_title = "Mode-3/A Code (Converted Into Octal Representation) of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_782

    @classmethod
    def create(cls, arg : "NonSpare_1313.cv_arg") -> "NonSpare_1313":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_782:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_812:
        return self.rule.variation

class Item_576(Item):
    cv_arg: TypeAlias = NonSpare_1313.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1313

    @classmethod
    def create(cls, arg : "Item_576.cv_arg") -> "Item_576":
        return cls._create(arg) # type: ignore

class Variation_1032(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_782.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_782.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1032.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_576, 12)]
    cv_items_dict = {"MODE3A": RuleVariation_782}

    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> Type[RuleVariation_782]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_782:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1032.cv_arg") -> 'Variation_1032':
        return cls._create(arg) # type: ignore

class RuleVariation_1001(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1032.cv_arg
    cv_variation: TypeAlias = Variation_1032

    @classmethod
    def create(cls, arg : "RuleVariation_1001.cv_arg") -> "RuleVariation_1001":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1032:
        return self.arg # type: ignore

class NonSpare_1220(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1001.cv_arg
    cv_name = "M32"
    cv_title = "Mode 3/A Code Aircraft 2"
    cv_rule: TypeAlias = RuleVariation_1001

    @classmethod
    def create(cls, arg : "NonSpare_1220.cv_arg") -> "NonSpare_1220":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1001:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1032:
        return self.rule.variation

class NonSpare_829(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1096.cv_arg
    cv_name = "CPW"
    cv_title = "Predicted Conflict Position Target 2 in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1096

    @classmethod
    def create(cls, arg : "NonSpare_829.cv_arg") -> "NonSpare_829":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1096:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1140:
        return self.rule.variation

class NonSpare_826(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1243.cv_arg
    cv_name = "CPL"
    cv_title = "Predicted Conflict Position for the Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1243

    @classmethod
    def create(cls, arg : "NonSpare_826.cv_arg") -> "NonSpare_826":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1243:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1314:
        return self.rule.variation

class NonSpare_1952(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "TT2"
    cv_title = "Time to Runway Threshold for Second Approaching Aircraft in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_1952.cv_arg") -> "NonSpare_1952":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class NonSpare_911(NonSpare):
    cv_arg: TypeAlias = RuleVariation_304.cv_arg
    cv_name = "DT2"
    cv_title = "Distance to Runway Threshold for Aircraft 2 Involved in a RIMCA"
    cv_rule: TypeAlias = RuleVariation_304

    @classmethod
    def create(cls, arg : "NonSpare_911.cv_arg") -> "NonSpare_911":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_304:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_311:
        return self.rule.variation

class NonSpare_561(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1292.cv_arg
    cv_name = "AC2"
    cv_title = "Characteristics of Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1292

    @classmethod
    def create(cls, arg : "NonSpare_561.cv_arg") -> "NonSpare_561":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1292:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1371:
        return self.rule.variation

class NonSpare_1327(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "MS2"
    cv_title = "Aircraft Identification Downloaded From Aircraft 2 Involved in the Conflict If Eequipped With a Mode-S Transponder"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1327.cv_arg") -> "NonSpare_1327":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class NonSpare_992(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1010.cv_arg
    cv_name = "FP2"
    cv_title = "Number of the Flight Plan Correlated to Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_1010

    @classmethod
    def create(cls, arg : "NonSpare_992.cv_arg") -> "NonSpare_992":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1010:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1042:
        return self.rule.variation

class NonSpare_730(NonSpare):
    cv_arg: TypeAlias = RuleVariation_314.cv_arg
    cv_name = "CF2"
    cv_title = "Cleared Flight Level for Aircraft 2 Involved in the Conflict"
    cv_rule: TypeAlias = RuleVariation_314

    @classmethod
    def create(cls, arg : "NonSpare_730.cv_arg") -> "NonSpare_730":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_314:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_321:
        return self.rule.variation

class Variation_1479(Compound):
    cv_arg = TypedDict('cv_arg', {
        "AI2": NonSpare_589.cv_arg,
        "M32": NonSpare_1220.cv_arg,
        "CPW": NonSpare_829.cv_arg,
        "CPL": NonSpare_826.cv_arg,
        "TT2": NonSpare_1952.cv_arg,
        "DT2": NonSpare_911.cv_arg,
        "AC2": NonSpare_561.cv_arg,
        "MS2": NonSpare_1327.cv_arg,
        "FP2": NonSpare_992.cv_arg,
        "CF2": NonSpare_730.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_589, NonSpare_1220, NonSpare_829, NonSpare_826, NonSpare_1952, NonSpare_911, NonSpare_561, NonSpare_1327, NonSpare_992, NonSpare_730]
    cv_items_dict = {"AI2": NonSpare_589, "M32": NonSpare_1220, "CPW": NonSpare_829, "CPL": NonSpare_826, "TT2": NonSpare_1952, "DT2": NonSpare_911, "AC2": NonSpare_561, "MS2": NonSpare_1327, "FP2": NonSpare_992, "CF2": NonSpare_730}

    @overload
    @classmethod
    def spec(cls, key : Literal["AI2"]) -> Type[NonSpare_589]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["M32"]) -> Type[NonSpare_1220]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPW"]) -> Type[NonSpare_829]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPL"]) -> Type[NonSpare_826]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TT2"]) -> Type[NonSpare_1952]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DT2"]) -> Type[NonSpare_911]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC2"]) -> Type[NonSpare_561]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MS2"]) -> Type[NonSpare_1327]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FP2"]) -> Type[NonSpare_992]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CF2"]) -> Type[NonSpare_730]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AI2"], Literal["M32"], Literal["CPW"], Literal["CPL"], Literal["TT2"], Literal["DT2"], Literal["AC2"], Literal["MS2"], Literal["FP2"], Literal["CF2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AI2"]) -> Optional[NonSpare_589]:
        ...
    @overload
    def get_item(self, key : Literal["M32"]) -> Optional[NonSpare_1220]:
        ...
    @overload
    def get_item(self, key : Literal["CPW"]) -> Optional[NonSpare_829]:
        ...
    @overload
    def get_item(self, key : Literal["CPL"]) -> Optional[NonSpare_826]:
        ...
    @overload
    def get_item(self, key : Literal["TT2"]) -> Optional[NonSpare_1952]:
        ...
    @overload
    def get_item(self, key : Literal["DT2"]) -> Optional[NonSpare_911]:
        ...
    @overload
    def get_item(self, key : Literal["AC2"]) -> Optional[NonSpare_561]:
        ...
    @overload
    def get_item(self, key : Literal["MS2"]) -> Optional[NonSpare_1327]:
        ...
    @overload
    def get_item(self, key : Literal["FP2"]) -> Optional[NonSpare_992]:
        ...
    @overload
    def get_item(self, key : Literal["CF2"]) -> Optional[NonSpare_730]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["AI2"], val : NonSpare_589.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["M32"], val : NonSpare_1220.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["CPW"], val : NonSpare_829.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["CPL"], val : NonSpare_826.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["TT2"], val : NonSpare_1952.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["DT2"], val : NonSpare_911.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["AC2"], val : NonSpare_561.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["MS2"], val : NonSpare_1327.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["FP2"], val : NonSpare_992.cv_arg) -> "Variation_1479":
        ...
    @overload
    def set_item(self, key : Literal["CF2"], val : NonSpare_730.cv_arg) -> "Variation_1479":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["AI2"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["M32"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["CPW"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["CPL"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["TT2"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["DT2"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["AC2"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["MS2"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["FP2"]) -> "Variation_1479":
        ...
    @overload
    def del_item(self, key : Literal["CF2"]) -> "Variation_1479":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1479.cv_arg") -> 'Variation_1479':
        return cls._create(arg) # type: ignore

class RuleVariation_1400(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1479.cv_arg
    cv_variation: TypeAlias = Variation_1479

    @classmethod
    def create(cls, arg : "RuleVariation_1400.cv_arg") -> "RuleVariation_1400":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1479:
        return self.arg # type: ignore

class NonSpare_383(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1400.cv_arg
    cv_name = "171"
    cv_title = "Aircraft Identification and Characteristics 2"
    cv_rule: TypeAlias = RuleVariation_1400

    @classmethod
    def create(cls, arg : "NonSpare_383.cv_arg") -> "NonSpare_383":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1400:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1479:
        return self.rule.variation

class UapItem_383(UapItem):
    cv_non_spare: TypeAlias = NonSpare_383

class NonSpare_725(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "CEN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_725.cv_arg") -> "NonSpare_725":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_148(Item):
    cv_arg: TypeAlias = NonSpare_725.cv_arg
    cv_non_spare: TypeAlias = NonSpare_725

    @classmethod
    def create(cls, arg : "Item_148.cv_arg") -> "Item_148":
        return cls._create(arg) # type: ignore

class NonSpare_1449(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "POS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1449.cv_arg") -> "NonSpare_1449":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_695(Item):
    cv_arg: TypeAlias = NonSpare_1449.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1449

    @classmethod
    def create(cls, arg : "Item_695.cv_arg") -> "Item_695":
        return cls._create(arg) # type: ignore

class Variation_1070(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["CEN"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["POS"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1070.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_148, 8), (Item_695, 8)]
    cv_items_dict = {"CEN": RuleVariation_159, "POS": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["CEN"]) -> Type[RuleVariation_159]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["POS"]) -> Type[RuleVariation_159]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CEN"], Literal["POS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CEN"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["POS"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1070.cv_arg") -> 'Variation_1070':
        return cls._create(arg) # type: ignore

class Variation_1423(Repetitive):
    cv_arg: TypeAlias = List[Variation_1070.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1070

    @classmethod
    def create(cls, arg: "Variation_1423.cv_arg") -> 'Variation_1423':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1070]:
        return self._get_list() # type: ignore

class RuleVariation_1344(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1423.cv_arg
    cv_variation: TypeAlias = Variation_1423

    @classmethod
    def create(cls, arg : "RuleVariation_1344.cv_arg") -> "RuleVariation_1344":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1423:
        return self.arg # type: ignore

class NonSpare_287(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1344.cv_arg
    cv_name = "110"
    cv_title = "FDPS Sector Control Identification"
    cv_rule: TypeAlias = RuleVariation_1344

    @classmethod
    def create(cls, arg : "NonSpare_287.cv_arg") -> "NonSpare_287":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1344:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1423:
        return self.rule.variation

class UapItem_287(UapItem):
    cv_non_spare: TypeAlias = NonSpare_287

class Variation_1472(Explicit):
    cv_arg: TypeAlias = bytes
    cv_explicit_type: TypeAlias = ReservedExpansion

    @classmethod
    def create(cls, arg: "Variation_1472.cv_arg") -> 'Variation_1472':
        return cls._create(arg) # type: ignore

class RuleVariation_1393(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1472.cv_arg
    cv_variation: TypeAlias = Variation_1472

    @classmethod
    def create(cls, arg : "RuleVariation_1393.cv_arg") -> "RuleVariation_1393":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1472:
        return self.arg # type: ignore

class NonSpare_1574(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1393.cv_arg
    cv_name = "RE"
    cv_title = "Reserved Expansion Field"
    cv_rule: TypeAlias = RuleVariation_1393

    @classmethod
    def create(cls, arg : "NonSpare_1574.cv_arg") -> "NonSpare_1574":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1393:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1472:
        return self.rule.variation

class UapItem_549(UapItem):
    cv_non_spare: TypeAlias = NonSpare_1574

class Record_14(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_34.cv_arg,
        "000": NonSpare_3.cv_arg,
        "015": NonSpare_58.cv_arg,
        "020": NonSpare_94.cv_arg,
        "040": NonSpare_136.cv_arg,
        "045": NonSpare_163.cv_arg,
        "060": NonSpare_195.cv_arg,
        "030": NonSpare_114.cv_arg,
        "170": NonSpare_371.cv_arg,
        "120": NonSpare_298.cv_arg,
        "070": NonSpare_205.cv_arg,
        "076": NonSpare_231.cv_arg,
        "074": NonSpare_226.cv_arg,
        "075": NonSpare_229.cv_arg,
        "100": NonSpare_268.cv_arg,
        "035": NonSpare_130.cv_arg,
        "171": NonSpare_383.cv_arg,
        "110": NonSpare_287.cv_arg,
        "RE": NonSpare_1574.cv_arg,
        "SP": NonSpare_1739.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_34, UapItem_3, UapItem_58, UapItem_94, UapItem_136, UapItem_163, UapItem_195, UapItem_114, UapItem_371, UapItem_298, UapItem_205, UapItem_231, UapItem_226, UapItem_229, UapItem_268, UapItem_130, UapItem_383, UapItem_287, UapItem_551, UapItem_549, UapItem_550]
    cv_items_dict = {"010": NonSpare_34, "000": NonSpare_3, "015": NonSpare_58, "020": NonSpare_94, "040": NonSpare_136, "045": NonSpare_163, "060": NonSpare_195, "030": NonSpare_114, "170": NonSpare_371, "120": NonSpare_298, "070": NonSpare_205, "076": NonSpare_231, "074": NonSpare_226, "075": NonSpare_229, "100": NonSpare_268, "035": NonSpare_130, "171": NonSpare_383, "110": NonSpare_287, "RE": NonSpare_1574, "SP": NonSpare_1739}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_34]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> Type[NonSpare_3]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["015"]) -> Type[NonSpare_58]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_94]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_136]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["045"]) -> Type[NonSpare_163]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_195]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_114]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> Type[NonSpare_371]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> Type[NonSpare_298]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_205]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["076"]) -> Type[NonSpare_231]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["074"]) -> Type[NonSpare_226]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["075"]) -> Type[NonSpare_229]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_268]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["035"]) -> Type[NonSpare_130]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["171"]) -> Type[NonSpare_383]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> Type[NonSpare_287]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> Type[NonSpare_1574]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["015"], Literal["020"], Literal["040"], Literal["045"], Literal["060"], Literal["030"], Literal["170"], Literal["120"], Literal["070"], Literal["076"], Literal["074"], Literal["075"], Literal["100"], Literal["035"], Literal["171"], Literal["110"], Literal["RE"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_34]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_3]:
        ...
    @overload
    def get_item(self, key : Literal["015"]) -> Optional[NonSpare_58]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_94]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["045"]) -> Optional[NonSpare_163]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_195]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_114]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_371]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_298]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_205]:
        ...
    @overload
    def get_item(self, key : Literal["076"]) -> Optional[NonSpare_231]:
        ...
    @overload
    def get_item(self, key : Literal["074"]) -> Optional[NonSpare_226]:
        ...
    @overload
    def get_item(self, key : Literal["075"]) -> Optional[NonSpare_229]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_268]:
        ...
    @overload
    def get_item(self, key : Literal["035"]) -> Optional[NonSpare_130]:
        ...
    @overload
    def get_item(self, key : Literal["171"]) -> Optional[NonSpare_383]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_287]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1574]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_34.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_3.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["015"], val : NonSpare_58.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_94.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["045"], val : NonSpare_163.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_195.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_114.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_371.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_298.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_205.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["076"], val : NonSpare_231.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["074"], val : NonSpare_226.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["075"], val : NonSpare_229.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_268.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["035"], val : NonSpare_130.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["171"], val : NonSpare_383.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_287.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1574.cv_arg) -> 'Record_14':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_14':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["015"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["045"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["076"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["074"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["075"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["035"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["171"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_14':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_14':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_14.cv_arg") -> 'Record_14':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_14", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_14(UapSingle):
    cv_arg: TypeAlias = Record_14
    cv_record: TypeAlias = Record_14

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_14]]:
        return cls._parse(bs)

class Asterix_6(AstCat):
    cv_category = 4
    cv_edition = (1, 12)
    cv_uap: TypeAlias = Uap_14
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_14.cv_arg]) -> "Asterix_6":
        return cls._create(records) # type: ignore

class Content_576(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Alive Message (AM)", 2: "Route Adherence Monitor Longitudinal Deviation (RAMLD)", 3: "Route Adherence Monitor Heading Deviation (RAMHD)", 4: "Minimum Safe Altitude Warning (MSAW)", 5: "Area Proximity Warning (APW)", 6: "Clearance Level Adherence Monitor (CLAM)", 7: "Short Term Conflict Alert (STCA)", 8: "Approach Path Monitor (APM)", 9: "RIMCAS Arrival / Landing Monitor (ALM)", 10: "RIMCAS Arrival / Departure Wrong Runway Alert (WRA)", 11: "RIMCAS Arrival / Departure Opposite Traffic Alert (OTA)", 12: "RIMCAS Departure Monitor (RDM)", 13: "RIMCAS Runway / Taxiway Crossing Monitor (RCM)", 14: "RIMCAS Taxiway Separation Monitor (TSM)", 15: "RIMCAS Unauthorized Taxiway Movement Monitor(UTMM)", 16: "RIMCAS Stop Bar Overrun Alert (SBOA)", 17: "End Of Conflict (EOC)", 18: "ACAS Resolution Advisory (ACASRA)", 19: "Near Term Conflict Alert (NTCA)", 20: "Downlinked Barometric Pressure Setting Monitor (DBPSM)", 21: "Speed Adherence Monitor (SAM)", 22: "Outside Controlled Airspace Tool (OCAT)", 23: "Vertical Conflict Detection (VCD)", 24: "Vertical Rate Adherence Monitor (VRAM)", 25: "Cleared Heading Adherence Monitor (CHAM)", 26: "Downlinked Selected Altitude Monitor (DSAM)", 27: "Holding Adherence Monitor (HAM)", 28: "Vertical Path Monitor (VPM)", 29: "RIMCAS Taxiway Traffic Alert (TTA)", 30: "RIMCAS Arrival/Departure Close Runway Alert (CRA)", 31: "RIMCAS Arrival/Departure Aircraft Separation Monitor (ASM)", 32: "RIMCAS ILS Area Violation Monitor (IAVM)", 33: "Final Target Distance Indicator (FTD)", 34: "Initial Target Distance Indicator (ITD)", 35: "Wake Vortex Indicator Infringement Alert (IIA)", 36: "Sequence Warning (SQW)", 37: "Catch Up Warning (CUW)", 38: "Conflicting ATC Clearances (CATC)", 39: "No ATC Clearance (NOCLR)", 40: "Aircraft Not Moving despite ATC Clearance (NOMOV)", 41: "Aircraft leaving/entering the aerodrome area without proper handover (NOH)", 42: "Wrong Runway or Taxiway Type (WRTY)", 43: "Stand Occupied (STOCC)", 44: "Ongoing Alert (ONGOING)", 45: "Non-Transgression Zone Violation (NTZ)", 97: "Lost Track Warning (LTW)", 98: "Holding Volume Infringement (HVI)", 99: "Airspace Infringement Warning (AIW)"}

class RuleContent_576(RuleContentContextFree):
    cv_arg: TypeAlias = Content_576.cv_arg
    cv_content: TypeAlias = Content_576

    @property
    def content(self) -> Content_576:
        return self._get_content() # type: ignore

class Variation_179(Element):
    cv_arg: TypeAlias = RuleContent_576.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_576

    @classmethod
    def create(cls, arg: "Variation_179.cv_arg") -> "Variation_179":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_576:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_576:
        return self.rule.content

class RuleVariation_172(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_179.cv_arg
    cv_variation: TypeAlias = Variation_179

    @classmethod
    def create(cls, arg : "RuleVariation_172.cv_arg") -> "RuleVariation_172":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_179:
        return self.arg # type: ignore

class NonSpare_2(NonSpare):
    cv_arg: TypeAlias = RuleVariation_172.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_172

    @classmethod
    def create(cls, arg : "NonSpare_2.cv_arg") -> "NonSpare_2":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_172:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_179:
        return self.rule.variation

class UapItem_2(UapItem):
    cv_non_spare: TypeAlias = NonSpare_2

class NonSpare_93(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "020"
    cv_title = "Time of Message"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_93.cv_arg") -> "NonSpare_93":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_93(UapItem):
    cv_non_spare: TypeAlias = NonSpare_93

class Content_205(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Element not populated", 1: "Element populated"}

class RuleContent_205(RuleContentContextFree):
    cv_arg: TypeAlias = Content_205.cv_arg
    cv_content: TypeAlias = Content_205

    @property
    def content(self) -> Content_205:
        return self._get_content() # type: ignore

class Variation_42(Element):
    cv_arg: TypeAlias = RuleContent_205.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_205

    @classmethod
    def create(cls, arg: "Variation_42.cv_arg") -> "Variation_42":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_205:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_205:
        return self.rule.content

class RuleVariation_42(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_42.cv_arg
    cv_variation: TypeAlias = Variation_42

    @classmethod
    def create(cls, arg : "RuleVariation_42.cv_arg") -> "RuleVariation_42":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_42:
        return self.arg # type: ignore

class NonSpare_946(NonSpare):
    cv_arg: TypeAlias = RuleVariation_42.cv_arg
    cv_name = "EP"
    cv_title = "Element Populated Bit"
    cv_rule: TypeAlias = RuleVariation_42

    @classmethod
    def create(cls, arg : "NonSpare_946.cv_arg") -> "NonSpare_946":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_42:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_42:
        return self.rule.variation

class Item_304(Item):
    cv_arg: TypeAlias = NonSpare_946.cv_arg
    cv_non_spare: TypeAlias = NonSpare_946

    @classmethod
    def create(cls, arg : "Item_304.cv_arg") -> "Item_304":
        return cls._create(arg) # type: ignore

class Content_244(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Inactive", 1: "Active", 2: "Pre-active", 3: "Reserved for Future Use", 4: "Reserved for Future Use", 5: "Reserved for Future Use", 6: "Reserved for Future Use", 7: "Reserved for Future Use"}

class RuleContent_244(RuleContentContextFree):
    cv_arg: TypeAlias = Content_244.cv_arg
    cv_content: TypeAlias = Content_244

    @property
    def content(self) -> Content_244:
        return self._get_content() # type: ignore

class Variation_484(Element):
    cv_arg: TypeAlias = RuleContent_244.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_244

    @classmethod
    def create(cls, arg: "Variation_484.cv_arg") -> "Variation_484":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_244:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_244:
        return self.rule.content

class RuleVariation_473(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_484.cv_arg
    cv_variation: TypeAlias = Variation_484

    @classmethod
    def create(cls, arg : "RuleVariation_473.cv_arg") -> "RuleVariation_473":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_484:
        return self.arg # type: ignore

class NonSpare_2004(NonSpare):
    cv_arg: TypeAlias = RuleVariation_473.cv_arg
    cv_name = "VAL"
    cv_title = "Area Status Value"
    cv_rule: TypeAlias = RuleVariation_473

    @classmethod
    def create(cls, arg : "NonSpare_2004.cv_arg") -> "NonSpare_2004":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_473:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_484:
        return self.rule.variation

class Item_1110(Item):
    cv_arg: TypeAlias = NonSpare_2004.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2004

    @classmethod
    def create(cls, arg : "Item_1110.cv_arg") -> "Item_1110":
        return cls._create(arg) # type: ignore

class Variation_1096(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_42.cv_arg, Tuple[Literal["EP"], RuleVariation_42.cv_arg]], Union[RuleVariation_473.cv_arg, Tuple[Literal["VAL"], RuleVariation_473.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1096.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 4
    cv_items_list = [(Item_304, 1), (Item_1110, 3)]
    cv_items_dict = {"EP": RuleVariation_42, "VAL": RuleVariation_473}

    @overload
    @classmethod
    def spec(cls, key : Literal["EP"]) -> Type[RuleVariation_42]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VAL"]) -> Type[RuleVariation_473]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["EP"], Literal["VAL"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["EP"]) -> RuleVariation_42:
        ...
    @overload
    def get_item(self, key : Literal["VAL"]) -> RuleVariation_473:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1096.cv_arg") -> 'Variation_1096':
        return cls._create(arg) # type: ignore

class RuleVariation_1054(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1096.cv_arg
    cv_variation: TypeAlias = Variation_1096

    @classmethod
    def create(cls, arg : "RuleVariation_1054.cv_arg") -> "RuleVariation_1054":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1096:
        return self.arg # type: ignore

class NonSpare_633(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1054.cv_arg
    cv_name = "AREA"
    cv_title = "Area Status"
    cv_rule: TypeAlias = RuleVariation_1054

    @classmethod
    def create(cls, arg : "NonSpare_633.cv_arg") -> "NonSpare_633":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1054:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1096:
        return self.rule.variation

class Item_84(Item):
    cv_arg: TypeAlias = NonSpare_633.cv_arg
    cv_non_spare: TypeAlias = NonSpare_633

    @classmethod
    def create(cls, arg : "Item_84.cv_arg") -> "Item_84":
        return cls._create(arg) # type: ignore

class Variation_1058(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_1054.cv_arg, Tuple[Literal["AREA"], RuleVariation_1054.cv_arg]], Union[RuleVariation_765.cv_arg, Tuple[Literal["STAT"], RuleVariation_765.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1058.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_84, 4), (Item_948, 3), (Item_29, 1)]
    cv_items_dict = {"AREA": RuleVariation_1054, "STAT": RuleVariation_765}

    @overload
    @classmethod
    def spec(cls, key : Literal["AREA"]) -> Type[RuleVariation_1054]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["STAT"]) -> Type[RuleVariation_765]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AREA"], Literal["STAT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AREA"]) -> RuleVariation_1054:
        ...
    @overload
    def get_item(self, key : Literal["STAT"]) -> RuleVariation_765:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1058.cv_arg") -> 'Variation_1058':
        return cls._create(arg) # type: ignore

class RuleVariation_1025(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1058.cv_arg
    cv_variation: TypeAlias = Variation_1058

    @classmethod
    def create(cls, arg : "RuleVariation_1025.cv_arg") -> "RuleVariation_1025":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1058:
        return self.arg # type: ignore

class NonSpare_164(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1025.cv_arg
    cv_name = "045"
    cv_title = "Area and Alert Status"
    cv_rule: TypeAlias = RuleVariation_1025

    @classmethod
    def create(cls, arg : "NonSpare_164.cv_arg") -> "NonSpare_164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1025:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1058:
        return self.rule.variation

class UapItem_164(UapItem):
    cv_non_spare: TypeAlias = NonSpare_164

class Content_134(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Non-Transgression Zone Function"}

class RuleContent_134(RuleContentContextFree):
    cv_arg: TypeAlias = Content_134.cv_arg
    cv_content: TypeAlias = Content_134

    @property
    def content(self) -> Content_134:
        return self._get_content() # type: ignore

class Variation_34(Element):
    cv_arg: TypeAlias = RuleContent_134.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_134

    @classmethod
    def create(cls, arg: "Variation_34.cv_arg") -> "Variation_34":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_134:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_134:
        return self.rule.content

class RuleVariation_34(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_34.cv_arg
    cv_variation: TypeAlias = Variation_34

    @classmethod
    def create(cls, arg : "RuleVariation_34.cv_arg") -> "RuleVariation_34":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_34:
        return self.arg # type: ignore

class NonSpare_1388(NonSpare):
    cv_arg: TypeAlias = RuleVariation_34.cv_arg
    cv_name = "NTZ"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_34

    @classmethod
    def create(cls, arg : "NonSpare_1388.cv_arg") -> "NonSpare_1388":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_34:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_34:
        return self.rule.variation

class Item_644(Item):
    cv_arg: TypeAlias = NonSpare_1388.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1388

    @classmethod
    def create(cls, arg : "Item_644.cv_arg") -> "Item_644":
        return cls._create(arg) # type: ignore

class Variation_1381(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_32.cv_arg, Tuple[Literal["MRVA"], RuleVariation_32.cv_arg]], Union[RuleVariation_405.cv_arg, Tuple[Literal["RAMLD"], RuleVariation_405.cv_arg]], Union[RuleVariation_514.cv_arg, Tuple[Literal["RAMHD"], RuleVariation_514.cv_arg]], Union[RuleVariation_616.cv_arg, Tuple[Literal["MSAW"], RuleVariation_616.cv_arg]], Union[RuleVariation_696.cv_arg, Tuple[Literal["APW"], RuleVariation_696.cv_arg]], Union[RuleVariation_803.cv_arg, Tuple[Literal["CLAM"], RuleVariation_803.cv_arg]], Union[RuleVariation_892.cv_arg, Tuple[Literal["STCA"], RuleVariation_892.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_24.cv_arg, Tuple[Literal["APM"], RuleVariation_24.cv_arg]], Union[RuleVariation_406.cv_arg, Tuple[Literal["RIMCA"], RuleVariation_406.cv_arg]], Union[RuleVariation_504.cv_arg, Tuple[Literal["ACASRA"], RuleVariation_504.cv_arg]], Union[RuleVariation_621.cv_arg, Tuple[Literal["NTCA"], RuleVariation_621.cv_arg]], Union[RuleVariation_702.cv_arg, Tuple[Literal["DG"], RuleVariation_702.cv_arg]], Union[RuleVariation_807.cv_arg, Tuple[Literal["OF"], RuleVariation_807.cv_arg]], Union[RuleVariation_889.cv_arg, Tuple[Literal["OL"], RuleVariation_889.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_23.cv_arg, Tuple[Literal["AIW"], RuleVariation_23.cv_arg]], Union[RuleVariation_404.cv_arg, Tuple[Literal["PAIW"], RuleVariation_404.cv_arg]], Union[RuleVariation_512.cv_arg, Tuple[Literal["OCAT"], RuleVariation_512.cv_arg]], Union[RuleVariation_622.cv_arg, Tuple[Literal["SAM"], RuleVariation_622.cv_arg]], Union[RuleVariation_703.cv_arg, Tuple[Literal["VCD"], RuleVariation_703.cv_arg]], Union[RuleVariation_802.cv_arg, Tuple[Literal["CHAM"], RuleVariation_802.cv_arg]], Union[RuleVariation_883.cv_arg, Tuple[Literal["DSAM"], RuleVariation_883.cv_arg]], None]]
    cv_arg_group_4: TypeAlias = Union[int, Tuple[Union[RuleVariation_27.cv_arg, Tuple[Literal["DBPSMARR"], RuleVariation_27.cv_arg]], Union[RuleVariation_395.cv_arg, Tuple[Literal["DBPSMDEP"], RuleVariation_395.cv_arg]], Union[RuleVariation_506.cv_arg, Tuple[Literal["DBPSMTL"], RuleVariation_506.cv_arg]], Union[RuleVariation_624.cv_arg, Tuple[Literal["VRAMCRM"], RuleVariation_624.cv_arg]], Union[RuleVariation_705.cv_arg, Tuple[Literal["VRAMVTM"], RuleVariation_705.cv_arg]], Union[RuleVariation_814.cv_arg, Tuple[Literal["VRAMVRM"], RuleVariation_814.cv_arg]], Union[RuleVariation_886.cv_arg, Tuple[Literal["HAMHD"], RuleVariation_886.cv_arg]], None]]
    cv_arg_group_5: TypeAlias = Union[int, Tuple[Union[RuleVariation_29.cv_arg, Tuple[Literal["HAMRD"], RuleVariation_29.cv_arg]], Union[RuleVariation_398.cv_arg, Tuple[Literal["HAMVD"], RuleVariation_398.cv_arg]], Union[RuleVariation_508.cv_arg, Tuple[Literal["HVI"], RuleVariation_508.cv_arg]], Union[RuleVariation_615.cv_arg, Tuple[Literal["LTW"], RuleVariation_615.cv_arg]], Union[RuleVariation_704.cv_arg, Tuple[Literal["VPM"], RuleVariation_704.cv_arg]], Union[RuleVariation_812.cv_arg, Tuple[Literal["TTA"], RuleVariation_812.cv_arg]], Union[RuleVariation_881.cv_arg, Tuple[Literal["CRA"], RuleVariation_881.cv_arg]], None]]
    cv_arg_group_6: TypeAlias = Union[int, Tuple[Union[RuleVariation_25.cv_arg, Tuple[Literal["ASM"], RuleVariation_25.cv_arg]], Union[RuleVariation_399.cv_arg, Tuple[Literal["IAVM"], RuleVariation_399.cv_arg]], Union[RuleVariation_507.cv_arg, Tuple[Literal["FTD"], RuleVariation_507.cv_arg]], Union[RuleVariation_613.cv_arg, Tuple[Literal["ITD"], RuleVariation_613.cv_arg]], Union[RuleVariation_698.cv_arg, Tuple[Literal["IIA"], RuleVariation_698.cv_arg]], Union[RuleVariation_809.cv_arg, Tuple[Literal["SQW"], RuleVariation_809.cv_arg]], Union[RuleVariation_882.cv_arg, Tuple[Literal["CUW"], RuleVariation_882.cv_arg]], None]]
    cv_arg_group_7: TypeAlias = Union[int, Tuple[Union[RuleVariation_26.cv_arg, Tuple[Literal["CATC"], RuleVariation_26.cv_arg]], Union[RuleVariation_403.cv_arg, Tuple[Literal["NOCLR"], RuleVariation_403.cv_arg]], Union[RuleVariation_511.cv_arg, Tuple[Literal["NOMOV"], RuleVariation_511.cv_arg]], Union[RuleVariation_620.cv_arg, Tuple[Literal["NOH"], RuleVariation_620.cv_arg]], Union[RuleVariation_706.cv_arg, Tuple[Literal["WRTY"], RuleVariation_706.cv_arg]], Union[RuleVariation_810.cv_arg, Tuple[Literal["STOCC"], RuleVariation_810.cv_arg]], Union[RuleVariation_888.cv_arg, Tuple[Literal["ONGOING"], RuleVariation_888.cv_arg]], None]]
    cv_arg_group_8: TypeAlias = Union[int, Tuple[Union[RuleVariation_34.cv_arg, Tuple[Literal["NTZ"], RuleVariation_34.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1381.cv_arg_group_1"],
        Tuple["Variation_1381.cv_arg_group_1", "Variation_1381.cv_arg_group_2"],
        Tuple["Variation_1381.cv_arg_group_1", "Variation_1381.cv_arg_group_2", "Variation_1381.cv_arg_group_3"],
        Tuple["Variation_1381.cv_arg_group_1", "Variation_1381.cv_arg_group_2", "Variation_1381.cv_arg_group_3", "Variation_1381.cv_arg_group_4"],
        Tuple["Variation_1381.cv_arg_group_1", "Variation_1381.cv_arg_group_2", "Variation_1381.cv_arg_group_3", "Variation_1381.cv_arg_group_4", "Variation_1381.cv_arg_group_5"],
        Tuple["Variation_1381.cv_arg_group_1", "Variation_1381.cv_arg_group_2", "Variation_1381.cv_arg_group_3", "Variation_1381.cv_arg_group_4", "Variation_1381.cv_arg_group_5", "Variation_1381.cv_arg_group_6"],
        Tuple["Variation_1381.cv_arg_group_1", "Variation_1381.cv_arg_group_2", "Variation_1381.cv_arg_group_3", "Variation_1381.cv_arg_group_4", "Variation_1381.cv_arg_group_5", "Variation_1381.cv_arg_group_6", "Variation_1381.cv_arg_group_7"],
        Tuple["Variation_1381.cv_arg_group_1", "Variation_1381.cv_arg_group_2", "Variation_1381.cv_arg_group_3", "Variation_1381.cv_arg_group_4", "Variation_1381.cv_arg_group_5", "Variation_1381.cv_arg_group_6", "Variation_1381.cv_arg_group_7", "Variation_1381.cv_arg_group_8"],
    ]
    cv_items_list = [[(Item_586, 1), (Item_780, 1), (Item_779, 1), (Item_589, 1), (Item_78, 1), (Item_163, 1), (Item_952, 1), None], [(Item_77, 1), (Item_825, 1), (Item_40, 1), (Item_643, 1), (Item_262, 1), (Item_658, 1), (Item_659, 1), None], [(Item_56, 1), (Item_681, 1), (Item_652, 1), (Item_863, 1), (Item_1145, 1), (Item_156, 1), (Item_278, 1), None], [(Item_245, 1), (Item_247, 1), (Item_249, 1), (Item_1156, 1), (Item_1159, 1), (Item_1158, 1), (Item_384, 1), None], [(Item_386, 1), (Item_388, 1), (Item_409, 1), (Item_512, 1), (Item_1154, 1), (Item_1065, 1), (Item_215, 1), None], [(Item_87, 1), (Item_425, 1), (Item_353, 1), (Item_443, 1), (Item_436, 1), (Item_921, 1), (Item_233, 1), None], [(Item_137, 1), (Item_626, 1), (Item_639, 1), (Item_634, 1), (Item_1175, 1), (Item_958, 1), (Item_661, 1), None], [(Item_644, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1381.cv_arg") -> 'Variation_1381':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["MRVA"]) -> RuleVariation_32:
        ...
    @overload
    def get_item(self, key : Literal["RAMLD"]) -> RuleVariation_405:
        ...
    @overload
    def get_item(self, key : Literal["RAMHD"]) -> RuleVariation_514:
        ...
    @overload
    def get_item(self, key : Literal["MSAW"]) -> RuleVariation_616:
        ...
    @overload
    def get_item(self, key : Literal["APW"]) -> RuleVariation_696:
        ...
    @overload
    def get_item(self, key : Literal["CLAM"]) -> RuleVariation_803:
        ...
    @overload
    def get_item(self, key : Literal["STCA"]) -> RuleVariation_892:
        ...
    @overload
    def get_item(self, key : Literal["APM"]) -> Optional[RuleVariation_24]:
        ...
    @overload
    def get_item(self, key : Literal["RIMCA"]) -> Optional[RuleVariation_406]:
        ...
    @overload
    def get_item(self, key : Literal["ACASRA"]) -> Optional[RuleVariation_504]:
        ...
    @overload
    def get_item(self, key : Literal["NTCA"]) -> Optional[RuleVariation_621]:
        ...
    @overload
    def get_item(self, key : Literal["DG"]) -> Optional[RuleVariation_702]:
        ...
    @overload
    def get_item(self, key : Literal["OF"]) -> Optional[RuleVariation_807]:
        ...
    @overload
    def get_item(self, key : Literal["OL"]) -> Optional[RuleVariation_889]:
        ...
    @overload
    def get_item(self, key : Literal["AIW"]) -> Optional[RuleVariation_23]:
        ...
    @overload
    def get_item(self, key : Literal["PAIW"]) -> Optional[RuleVariation_404]:
        ...
    @overload
    def get_item(self, key : Literal["OCAT"]) -> Optional[RuleVariation_512]:
        ...
    @overload
    def get_item(self, key : Literal["SAM"]) -> Optional[RuleVariation_622]:
        ...
    @overload
    def get_item(self, key : Literal["VCD"]) -> Optional[RuleVariation_703]:
        ...
    @overload
    def get_item(self, key : Literal["CHAM"]) -> Optional[RuleVariation_802]:
        ...
    @overload
    def get_item(self, key : Literal["DSAM"]) -> Optional[RuleVariation_883]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMARR"]) -> Optional[RuleVariation_27]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMDEP"]) -> Optional[RuleVariation_395]:
        ...
    @overload
    def get_item(self, key : Literal["DBPSMTL"]) -> Optional[RuleVariation_506]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMCRM"]) -> Optional[RuleVariation_624]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVTM"]) -> Optional[RuleVariation_705]:
        ...
    @overload
    def get_item(self, key : Literal["VRAMVRM"]) -> Optional[RuleVariation_814]:
        ...
    @overload
    def get_item(self, key : Literal["HAMHD"]) -> Optional[RuleVariation_886]:
        ...
    @overload
    def get_item(self, key : Literal["HAMRD"]) -> Optional[RuleVariation_29]:
        ...
    @overload
    def get_item(self, key : Literal["HAMVD"]) -> Optional[RuleVariation_398]:
        ...
    @overload
    def get_item(self, key : Literal["HVI"]) -> Optional[RuleVariation_508]:
        ...
    @overload
    def get_item(self, key : Literal["LTW"]) -> Optional[RuleVariation_615]:
        ...
    @overload
    def get_item(self, key : Literal["VPM"]) -> Optional[RuleVariation_704]:
        ...
    @overload
    def get_item(self, key : Literal["TTA"]) -> Optional[RuleVariation_812]:
        ...
    @overload
    def get_item(self, key : Literal["CRA"]) -> Optional[RuleVariation_881]:
        ...
    @overload
    def get_item(self, key : Literal["ASM"]) -> Optional[RuleVariation_25]:
        ...
    @overload
    def get_item(self, key : Literal["IAVM"]) -> Optional[RuleVariation_399]:
        ...
    @overload
    def get_item(self, key : Literal["FTD"]) -> Optional[RuleVariation_507]:
        ...
    @overload
    def get_item(self, key : Literal["ITD"]) -> Optional[RuleVariation_613]:
        ...
    @overload
    def get_item(self, key : Literal["IIA"]) -> Optional[RuleVariation_698]:
        ...
    @overload
    def get_item(self, key : Literal["SQW"]) -> Optional[RuleVariation_809]:
        ...
    @overload
    def get_item(self, key : Literal["CUW"]) -> Optional[RuleVariation_882]:
        ...
    @overload
    def get_item(self, key : Literal["CATC"]) -> Optional[RuleVariation_26]:
        ...
    @overload
    def get_item(self, key : Literal["NOCLR"]) -> Optional[RuleVariation_403]:
        ...
    @overload
    def get_item(self, key : Literal["NOMOV"]) -> Optional[RuleVariation_511]:
        ...
    @overload
    def get_item(self, key : Literal["NOH"]) -> Optional[RuleVariation_620]:
        ...
    @overload
    def get_item(self, key : Literal["WRTY"]) -> Optional[RuleVariation_706]:
        ...
    @overload
    def get_item(self, key : Literal["STOCC"]) -> Optional[RuleVariation_810]:
        ...
    @overload
    def get_item(self, key : Literal["ONGOING"]) -> Optional[RuleVariation_888]:
        ...
    @overload
    def get_item(self, key : Literal["NTZ"]) -> Optional[RuleVariation_34]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1302(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1381.cv_arg
    cv_variation: TypeAlias = Variation_1381

    @classmethod
    def create(cls, arg : "RuleVariation_1302.cv_arg") -> "RuleVariation_1302":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1381:
        return self.arg # type: ignore

class NonSpare_196(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1302.cv_arg
    cv_name = "060"
    cv_title = "Safety Net Function and System Status"
    cv_rule: TypeAlias = RuleVariation_1302

    @classmethod
    def create(cls, arg : "NonSpare_196.cv_arg") -> "NonSpare_196":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1302:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1381:
        return self.rule.variation

class UapItem_196(UapItem):
    cv_non_spare: TypeAlias = NonSpare_196

class NonSpare_1175(NonSpare):
    cv_arg: TypeAlias = RuleVariation_715.cv_arg
    cv_name = "LFP"
    cv_title = "Linear Prediction Filter"
    cv_rule: TypeAlias = RuleVariation_715

    @classmethod
    def create(cls, arg : "NonSpare_1175.cv_arg") -> "NonSpare_1175":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_715:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_726:
        return self.rule.variation

class Item_482(Item):
    cv_arg: TypeAlias = NonSpare_1175.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1175

    @classmethod
    def create(cls, arg : "Item_482.cv_arg") -> "Item_482":
        return cls._create(arg) # type: ignore

class NonSpare_1337(NonSpare):
    cv_arg: TypeAlias = RuleVariation_900.cv_arg
    cv_name = "MSM"
    cv_title = "Mode S Manoeuvre/Prediction Filter"
    cv_rule: TypeAlias = RuleVariation_900

    @classmethod
    def create(cls, arg : "NonSpare_1337.cv_arg") -> "NonSpare_1337":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_900:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_930:
        return self.rule.variation

class Item_598(Item):
    cv_arg: TypeAlias = NonSpare_1337.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1337

    @classmethod
    def create(cls, arg : "Item_598.cv_arg") -> "Item_598":
        return cls._create(arg) # type: ignore

class Variation_1345(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_715.cv_arg, Tuple[Literal["LFP"], RuleVariation_715.cv_arg]], int, Union[RuleVariation_900.cv_arg, Tuple[Literal["MSM"], RuleVariation_900.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1345.cv_arg_group"]
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_items_list = [(Item_482, 1), (Item_23, 1), (Item_598, 1)]
    cv_items_dict = {"LFP": RuleVariation_715, "MSM": RuleVariation_900}

    @overload
    @classmethod
    def spec(cls, key : Literal["LFP"]) -> Type[RuleVariation_715]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MSM"]) -> Type[RuleVariation_900]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LFP"], Literal["MSM"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LFP"]) -> RuleVariation_715:
        ...
    @overload
    def get_item(self, key : Literal["MSM"]) -> RuleVariation_900:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1345.cv_arg") -> 'Variation_1345':
        return cls._create(arg) # type: ignore

class RuleVariation_1452(RuleVariationDependent):
    cv_arg: TypeAlias = Union[
        Variation_776.cv_arg,
        Variation_779.cv_arg,
        Variation_801.cv_arg,
        Variation_1346.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_1347.cv_arg,
        Variation_778.cv_arg,
        Variation_798.cv_arg,
        Variation_799.cv_arg,
        Variation_800.cv_arg,
        Variation_793.cv_arg,
        Variation_780.cv_arg,
        Variation_794.cv_arg,
        Variation_794.cv_arg,
        Variation_785.cv_arg,
        Variation_787.cv_arg,
        Variation_784.cv_arg,
        Variation_795.cv_arg,
        Variation_786.cv_arg,
        Variation_792.cv_arg,
        Variation_796.cv_arg,
        Variation_788.cv_arg,
        Variation_783.cv_arg,
        Variation_789.cv_arg,
        Variation_1345.cv_arg,
    ]
    cv_depends_on = [["000"], ["120", "CC", "TID"]]
    cv_default_variation: TypeAlias = Variation_776
    cv_cases = [
        ([5, 1], Variation_779),
        ([7, 0], Variation_801),
        ([7, 1], Variation_1346),
        ([9, 2], Variation_1347),
        ([10, 2], Variation_1347),
        ([11, 2], Variation_1347),
        ([12, 2], Variation_1347),
        ([13, 2], Variation_1347),
        ([14, 2], Variation_1347),
        ([15, 2], Variation_1347),
        ([16, 2], Variation_1347),
        ([15, 1], Variation_778),
        ([24, 1], Variation_798),
        ([24, 2], Variation_799),
        ([26, 1], Variation_800),
        ([27, 1], Variation_793),
        ([27, 2], Variation_780),
        ([33, 1], Variation_794),
        ([34, 1], Variation_794),
        ([35, 1], Variation_785),
        ([38, 0], Variation_787),
        ([38, 1], Variation_784),
        ([38, 2], Variation_795),
        ([38, 3], Variation_786),
        ([38, 4], Variation_792),
        ([38, 5], Variation_796),
        ([39, 1], Variation_788),
        ([40, 1], Variation_783),
        ([41, 1], Variation_789),
        ([45, 1], Variation_1345),
    ]

    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[5], Literal[1]]) -> Variation_779:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[0]]) -> Variation_801:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[7], Literal[1]]) -> Variation_1346:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[9], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[10], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[11], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[12], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[13], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[14], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[16], Literal[2]]) -> Variation_1347:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[15], Literal[1]]) -> Variation_778:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[1]]) -> Variation_798:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[24], Literal[2]]) -> Variation_799:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[26], Literal[1]]) -> Variation_800:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[1]]) -> Variation_793:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[27], Literal[2]]) -> Variation_780:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[33], Literal[1]]) -> Variation_794:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[34], Literal[1]]) -> Variation_794:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[35], Literal[1]]) -> Variation_785:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[0]]) -> Variation_787:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[1]]) -> Variation_784:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[2]]) -> Variation_795:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[3]]) -> Variation_786:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[4]]) -> Variation_792:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[38], Literal[5]]) -> Variation_796:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[39], Literal[1]]) -> Variation_788:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[40], Literal[1]]) -> Variation_783:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[41], Literal[1]]) -> Variation_789:
        ...
    @overload
    @classmethod
    def variation(cls, key : Tuple[Literal[45], Literal[1]]) -> Variation_1345:
        ...

    @classmethod
    def variation(cls, key : Any) -> Any:
        return cls._variation(key)

    @classmethod
    def create(cls, arg : "RuleVariation_1452.cv_arg") -> "RuleVariation_1452":
        return cls._create(arg) # type: ignore

class NonSpare_822(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1452.cv_arg
    cv_name = "CPC"
    cv_title = "Conflict Properties Class"
    cv_rule: TypeAlias = RuleVariation_1452

    @classmethod
    def create(cls, arg : "NonSpare_822.cv_arg") -> "NonSpare_822":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1452:
        return self.arg # type: ignore

class Item_209(Item):
    cv_arg: TypeAlias = NonSpare_822.cv_arg
    cv_non_spare: TypeAlias = NonSpare_822

    @classmethod
    def create(cls, arg : "Item_209.cv_arg") -> "Item_209":
        return cls._create(arg) # type: ignore

class Variation_1232(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_132.cv_arg, Tuple[Literal["TID"], RuleVariation_132.cv_arg]], Union[RuleVariation_1452.cv_arg, Tuple[Literal["CPC"], RuleVariation_1452.cv_arg]], Union[RuleVariation_955.cv_arg, Tuple[Literal["CS"], RuleVariation_955.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1232.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1002, 4), (Item_209, 3), (Item_220, 1)]
    cv_items_dict = {"TID": RuleVariation_132, "CPC": RuleVariation_1452, "CS": RuleVariation_955}

    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> Type[RuleVariation_132]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CPC"]) -> Type[RuleVariation_1452]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CS"]) -> Type[RuleVariation_955]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TID"], Literal["CPC"], Literal["CS"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_132:
        ...
    @overload
    def get_item(self, key : Literal["CPC"]) -> RuleVariation_1452:
        ...
    @overload
    def get_item(self, key : Literal["CS"]) -> RuleVariation_955:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1232.cv_arg") -> 'Variation_1232':
        return cls._create(arg) # type: ignore

class RuleVariation_1172(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1232.cv_arg
    cv_variation: TypeAlias = Variation_1232

    @classmethod
    def create(cls, arg : "RuleVariation_1172.cv_arg") -> "RuleVariation_1172":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1232:
        return self.arg # type: ignore

class NonSpare_715(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1172.cv_arg
    cv_name = "CC"
    cv_title = "Conflict Classification"
    cv_rule: TypeAlias = RuleVariation_1172

    @classmethod
    def create(cls, arg : "NonSpare_715.cv_arg") -> "NonSpare_715":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1172:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1232:
        return self.rule.variation

class Variation_1489(Compound):
    cv_arg = TypedDict('cv_arg', {
        "CN": NonSpare_750.cv_arg,
        "CC": NonSpare_715.cv_arg,
        "CP": NonSpare_819.cv_arg,
        "CD": NonSpare_717.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 1
    cv_items_list = [NonSpare_750, NonSpare_715, NonSpare_819, NonSpare_717]
    cv_items_dict = {"CN": NonSpare_750, "CC": NonSpare_715, "CP": NonSpare_819, "CD": NonSpare_717}

    @overload
    @classmethod
    def spec(cls, key : Literal["CN"]) -> Type[NonSpare_750]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CC"]) -> Type[NonSpare_715]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> Type[NonSpare_819]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CD"]) -> Type[NonSpare_717]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["CN"], Literal["CC"], Literal["CP"], Literal["CD"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["CN"]) -> Optional[NonSpare_750]:
        ...
    @overload
    def get_item(self, key : Literal["CC"]) -> Optional[NonSpare_715]:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> Optional[NonSpare_819]:
        ...
    @overload
    def get_item(self, key : Literal["CD"]) -> Optional[NonSpare_717]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["CN"], val : NonSpare_750.cv_arg) -> "Variation_1489":
        ...
    @overload
    def set_item(self, key : Literal["CC"], val : NonSpare_715.cv_arg) -> "Variation_1489":
        ...
    @overload
    def set_item(self, key : Literal["CP"], val : NonSpare_819.cv_arg) -> "Variation_1489":
        ...
    @overload
    def set_item(self, key : Literal["CD"], val : NonSpare_717.cv_arg) -> "Variation_1489":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["CN"]) -> "Variation_1489":
        ...
    @overload
    def del_item(self, key : Literal["CC"]) -> "Variation_1489":
        ...
    @overload
    def del_item(self, key : Literal["CP"]) -> "Variation_1489":
        ...
    @overload
    def del_item(self, key : Literal["CD"]) -> "Variation_1489":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1489.cv_arg") -> 'Variation_1489':
        return cls._create(arg) # type: ignore

class RuleVariation_1410(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1489.cv_arg
    cv_variation: TypeAlias = Variation_1489

    @classmethod
    def create(cls, arg : "RuleVariation_1410.cv_arg") -> "RuleVariation_1410":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1489:
        return self.arg # type: ignore

class NonSpare_299(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1410.cv_arg
    cv_name = "120"
    cv_title = "Conflict Characteristics"
    cv_rule: TypeAlias = RuleVariation_1410

    @classmethod
    def create(cls, arg : "NonSpare_299.cv_arg") -> "NonSpare_299":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1410:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1489:
        return self.rule.variation

class UapItem_299(UapItem):
    cv_non_spare: TypeAlias = NonSpare_299

class Record_13(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_34.cv_arg,
        "000": NonSpare_2.cv_arg,
        "015": NonSpare_58.cv_arg,
        "020": NonSpare_93.cv_arg,
        "040": NonSpare_136.cv_arg,
        "045": NonSpare_164.cv_arg,
        "060": NonSpare_196.cv_arg,
        "030": NonSpare_114.cv_arg,
        "170": NonSpare_371.cv_arg,
        "120": NonSpare_299.cv_arg,
        "070": NonSpare_205.cv_arg,
        "076": NonSpare_231.cv_arg,
        "074": NonSpare_226.cv_arg,
        "075": NonSpare_229.cv_arg,
        "100": NonSpare_268.cv_arg,
        "035": NonSpare_130.cv_arg,
        "171": NonSpare_383.cv_arg,
        "110": NonSpare_287.cv_arg,
        "RE": NonSpare_1574.cv_arg,
        "SP": NonSpare_1739.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 3
    cv_items_list = [UapItem_34, UapItem_2, UapItem_58, UapItem_93, UapItem_136, UapItem_164, UapItem_196, UapItem_114, UapItem_371, UapItem_299, UapItem_205, UapItem_231, UapItem_226, UapItem_229, UapItem_268, UapItem_130, UapItem_383, UapItem_287, UapItem_551, UapItem_549, UapItem_550]
    cv_items_dict = {"010": NonSpare_34, "000": NonSpare_2, "015": NonSpare_58, "020": NonSpare_93, "040": NonSpare_136, "045": NonSpare_164, "060": NonSpare_196, "030": NonSpare_114, "170": NonSpare_371, "120": NonSpare_299, "070": NonSpare_205, "076": NonSpare_231, "074": NonSpare_226, "075": NonSpare_229, "100": NonSpare_268, "035": NonSpare_130, "171": NonSpare_383, "110": NonSpare_287, "RE": NonSpare_1574, "SP": NonSpare_1739}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_34]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> Type[NonSpare_2]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["015"]) -> Type[NonSpare_58]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_93]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_136]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["045"]) -> Type[NonSpare_164]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_196]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_114]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> Type[NonSpare_371]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> Type[NonSpare_299]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_205]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["076"]) -> Type[NonSpare_231]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["074"]) -> Type[NonSpare_226]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["075"]) -> Type[NonSpare_229]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_268]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["035"]) -> Type[NonSpare_130]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["171"]) -> Type[NonSpare_383]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> Type[NonSpare_287]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> Type[NonSpare_1574]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["015"], Literal["020"], Literal["040"], Literal["045"], Literal["060"], Literal["030"], Literal["170"], Literal["120"], Literal["070"], Literal["076"], Literal["074"], Literal["075"], Literal["100"], Literal["035"], Literal["171"], Literal["110"], Literal["RE"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_34]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_2]:
        ...
    @overload
    def get_item(self, key : Literal["015"]) -> Optional[NonSpare_58]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_93]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_136]:
        ...
    @overload
    def get_item(self, key : Literal["045"]) -> Optional[NonSpare_164]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_196]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_114]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_371]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_299]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_205]:
        ...
    @overload
    def get_item(self, key : Literal["076"]) -> Optional[NonSpare_231]:
        ...
    @overload
    def get_item(self, key : Literal["074"]) -> Optional[NonSpare_226]:
        ...
    @overload
    def get_item(self, key : Literal["075"]) -> Optional[NonSpare_229]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_268]:
        ...
    @overload
    def get_item(self, key : Literal["035"]) -> Optional[NonSpare_130]:
        ...
    @overload
    def get_item(self, key : Literal["171"]) -> Optional[NonSpare_383]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_287]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1574]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_34.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_2.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["015"], val : NonSpare_58.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_93.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_136.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["045"], val : NonSpare_164.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_196.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_114.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_371.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_299.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_205.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["076"], val : NonSpare_231.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["074"], val : NonSpare_226.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["075"], val : NonSpare_229.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_268.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["035"], val : NonSpare_130.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["171"], val : NonSpare_383.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_287.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1574.cv_arg) -> 'Record_13':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_13':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["015"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["045"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["076"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["074"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["075"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["035"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["171"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_13':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_13':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_13.cv_arg") -> 'Record_13':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_13", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_13(UapSingle):
    cv_arg: TypeAlias = Record_13
    cv_record: TypeAlias = Record_13

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_13]]:
        return cls._parse(bs)

class Asterix_7(AstCat):
    cv_category = 4
    cv_edition = (1, 13)
    cv_uap: TypeAlias = Uap_13
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_13.cv_arg]) -> "Asterix_7":
        return cls._create(records) # type: ignore

class Content_593(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Polar vector", 2: "Cartesian vector of start point/length", 3: "Contour record", 4: "Cartesian start point and end point vector", 254: "SOP message", 255: "EOP message"}

class RuleContent_593(RuleContentContextFree):
    cv_arg: TypeAlias = Content_593.cv_arg
    cv_content: TypeAlias = Content_593

    @property
    def content(self) -> Content_593:
        return self._get_content() # type: ignore

class Variation_192(Element):
    cv_arg: TypeAlias = RuleContent_593.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_593

    @classmethod
    def create(cls, arg: "Variation_192.cv_arg") -> "Variation_192":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_593:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_593:
        return self.rule.content

class RuleVariation_185(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_192.cv_arg
    cv_variation: TypeAlias = Variation_192

    @classmethod
    def create(cls, arg : "RuleVariation_185.cv_arg") -> "RuleVariation_185":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_192:
        return self.arg # type: ignore

class NonSpare_8(NonSpare):
    cv_arg: TypeAlias = RuleVariation_185.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_185

    @classmethod
    def create(cls, arg : "NonSpare_8.cv_arg") -> "NonSpare_8":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_185:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_192:
        return self.rule.variation

class UapItem_8(UapItem):
    cv_non_spare: TypeAlias = NonSpare_8

class Content_260(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Local Coordinates", 1: "System Coordinates"}

class RuleContent_260(RuleContentContextFree):
    cv_arg: TypeAlias = Content_260.cv_arg
    cv_content: TypeAlias = Content_260

    @property
    def content(self) -> Content_260:
        return self._get_content() # type: ignore

class Variation_52(Element):
    cv_arg: TypeAlias = RuleContent_260.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_260

    @classmethod
    def create(cls, arg: "Variation_52.cv_arg") -> "Variation_52":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_260:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_260:
        return self.rule.content

class RuleVariation_52(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_52.cv_arg
    cv_variation: TypeAlias = Variation_52

    @classmethod
    def create(cls, arg : "RuleVariation_52.cv_arg") -> "RuleVariation_52":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_52:
        return self.arg # type: ignore

class Variation_489(Element):
    cv_arg: TypeAlias = RuleContent_614.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_614

    @classmethod
    def create(cls, arg: "Variation_489.cv_arg") -> "Variation_489":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_614:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_614:
        return self.rule.content

class RuleVariation_478(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_489.cv_arg
    cv_variation: TypeAlias = Variation_489

    @classmethod
    def create(cls, arg : "RuleVariation_478.cv_arg") -> "RuleVariation_478":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_489:
        return self.arg # type: ignore

class Content_2(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "0°", 1: "22.5°", 2: "45°", 3: "67.5°", 4: "90°", 5: "112.5°", 6: "135°", 7: "157.5°"}

class RuleContent_2(RuleContentContextFree):
    cv_arg: TypeAlias = Content_2.cv_arg
    cv_content: TypeAlias = Content_2

    @property
    def content(self) -> Content_2:
        return self._get_content() # type: ignore

class Variation_777(Element):
    cv_arg: TypeAlias = RuleContent_2.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 3
    cv_rule = RuleContent_2

    @classmethod
    def create(cls, arg: "Variation_777.cv_arg") -> "Variation_777":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_2:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_2:
        return self.rule.content

class RuleVariation_766(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_777.cv_arg
    cv_variation: TypeAlias = Variation_777

    @classmethod
    def create(cls, arg : "RuleVariation_766.cv_arg") -> "RuleVariation_766":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_777:
        return self.arg # type: ignore

class Content_158(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test vector"}

class RuleContent_158(RuleContentContextFree):
    cv_arg: TypeAlias = Content_158.cv_arg
    cv_content: TypeAlias = Content_158

    @property
    def content(self) -> Content_158:
        return self._get_content() # type: ignore

class Variation_843(Element):
    cv_arg: TypeAlias = RuleContent_158.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_158

    @classmethod
    def create(cls, arg: "Variation_843.cv_arg") -> "Variation_843":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_158:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_158:
        return self.rule.content

class RuleVariation_813(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_843.cv_arg
    cv_variation: TypeAlias = Variation_843

    @classmethod
    def create(cls, arg : "RuleVariation_813.cv_arg") -> "RuleVariation_813":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_843:
        return self.arg # type: ignore

class Content_96(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Error condition encountered"}

class RuleContent_96(RuleContentContextFree):
    cv_arg: TypeAlias = Content_96.cv_arg
    cv_content: TypeAlias = Content_96

    @property
    def content(self) -> Content_96:
        return self._get_content() # type: ignore

class Variation_914(Element):
    cv_arg: TypeAlias = RuleContent_96.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_96

    @classmethod
    def create(cls, arg: "Variation_914.cv_arg") -> "Variation_914":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_96:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_96:
        return self.rule.content

class RuleVariation_884(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_914.cv_arg
    cv_variation: TypeAlias = Variation_914

    @classmethod
    def create(cls, arg : "RuleVariation_884.cv_arg") -> "RuleVariation_884":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_914:
        return self.arg # type: ignore

class NonSpare_1408(NonSpare):
    cv_arg: TypeAlias = RuleVariation_52.cv_arg
    cv_name = "ORG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_52

    @classmethod
    def create(cls, arg : "NonSpare_1408.cv_arg") -> "NonSpare_1408":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_52:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_52:
        return self.rule.variation

class Item_664(Item):
    cv_arg: TypeAlias = NonSpare_1408.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1408

    @classmethod
    def create(cls, arg : "Item_664.cv_arg") -> "Item_664":
        return cls._create(arg) # type: ignore

class NonSpare_1092(NonSpare):
    cv_arg: TypeAlias = RuleVariation_478.cv_arg
    cv_name = "I"
    cv_title = "Intensity Level"
    cv_rule: TypeAlias = RuleVariation_478

    @classmethod
    def create(cls, arg : "NonSpare_1092.cv_arg") -> "NonSpare_1092":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_478:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_489:
        return self.rule.variation

class Item_411(Item):
    cv_arg: TypeAlias = NonSpare_1092.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1092

    @classmethod
    def create(cls, arg : "Item_411.cv_arg") -> "Item_411":
        return cls._create(arg) # type: ignore

class NonSpare_1654(NonSpare):
    cv_arg: TypeAlias = RuleVariation_766.cv_arg
    cv_name = "S"
    cv_title = "Shading Orientation with Respect to North"
    cv_rule: TypeAlias = RuleVariation_766

    @classmethod
    def create(cls, arg : "NonSpare_1654.cv_arg") -> "NonSpare_1654":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_766:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_777:
        return self.rule.variation

class Item_854(Item):
    cv_arg: TypeAlias = NonSpare_1654.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1654

    @classmethod
    def create(cls, arg : "Item_854.cv_arg") -> "Item_854":
        return cls._create(arg) # type: ignore

class NonSpare_1943(NonSpare):
    cv_arg: TypeAlias = RuleVariation_813.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_813

    @classmethod
    def create(cls, arg : "NonSpare_1943.cv_arg") -> "NonSpare_1943":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_813:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_843:
        return self.rule.variation

class Item_1057(Item):
    cv_arg: TypeAlias = NonSpare_1943.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1943

    @classmethod
    def create(cls, arg : "Item_1057.cv_arg") -> "Item_1057":
        return cls._create(arg) # type: ignore

class NonSpare_961(NonSpare):
    cv_arg: TypeAlias = RuleVariation_884.cv_arg
    cv_name = "ER"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_884

    @classmethod
    def create(cls, arg : "NonSpare_961.cv_arg") -> "NonSpare_961":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_884:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_914:
        return self.rule.variation

class Item_319(Item):
    cv_arg: TypeAlias = NonSpare_961.cv_arg
    cv_non_spare: TypeAlias = NonSpare_961

    @classmethod
    def create(cls, arg : "Item_319.cv_arg") -> "Item_319":
        return cls._create(arg) # type: ignore

class Variation_1388(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_52.cv_arg, Tuple[Literal["ORG"], RuleVariation_52.cv_arg]], Union[RuleVariation_478.cv_arg, Tuple[Literal["I"], RuleVariation_478.cv_arg]], Union[RuleVariation_766.cv_arg, Tuple[Literal["S"], RuleVariation_766.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[int, Union[RuleVariation_813.cv_arg, Tuple[Literal["TST"], RuleVariation_813.cv_arg]], Union[RuleVariation_884.cv_arg, Tuple[Literal["ER"], RuleVariation_884.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1388.cv_arg_group_1"],
        Tuple["Variation_1388.cv_arg_group_1", "Variation_1388.cv_arg_group_2"],
    ]
    cv_items_list = [[(Item_664, 1), (Item_411, 3), (Item_854, 3), None], [(Item_4, 5), (Item_1057, 1), (Item_319, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1388.cv_arg") -> 'Variation_1388':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_52:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_478:
        ...
    @overload
    def get_item(self, key : Literal["S"]) -> RuleVariation_766:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_813]:
        ...
    @overload
    def get_item(self, key : Literal["ER"]) -> Optional[RuleVariation_884]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1309(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1388.cv_arg
    cv_variation: TypeAlias = Variation_1388

    @classmethod
    def create(cls, arg : "RuleVariation_1309.cv_arg") -> "RuleVariation_1309":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1388:
        return self.arg # type: ignore

class NonSpare_96(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1309.cv_arg
    cv_name = "020"
    cv_title = "Vector Qualifier"
    cv_rule: TypeAlias = RuleVariation_1309

    @classmethod
    def create(cls, arg : "NonSpare_96.cv_arg") -> "NonSpare_96":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1309:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1388:
        return self.rule.variation

class UapItem_96(UapItem):
    cv_non_spare: TypeAlias = NonSpare_96

class Content_613(ContentInteger):
    cv_arg: TypeAlias = int
    cv_signedness: TypeAlias = Signed

class RuleContent_613(RuleContentContextFree):
    cv_arg: TypeAlias = Content_613.cv_arg
    cv_content: TypeAlias = Content_613

    @property
    def content(self) -> Content_613:
        return self._get_content() # type: ignore

class Variation_204(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_204.cv_arg") -> "Variation_204":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_197(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_204.cv_arg
    cv_variation: TypeAlias = Variation_204

    @classmethod
    def create(cls, arg : "RuleVariation_197.cv_arg") -> "RuleVariation_197":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_204:
        return self.arg # type: ignore

class NonSpare_2108(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2108.cv_arg") -> "NonSpare_2108":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1205(Item):
    cv_arg: TypeAlias = NonSpare_2108.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2108

    @classmethod
    def create(cls, arg : "Item_1205.cv_arg") -> "Item_1205":
        return cls._create(arg) # type: ignore

class NonSpare_2162(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2162.cv_arg") -> "NonSpare_2162":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1256(Item):
    cv_arg: TypeAlias = NonSpare_2162.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2162

    @classmethod
    def create(cls, arg : "Item_1256.cv_arg") -> "Item_1256":
        return cls._create(arg) # type: ignore

class Variation_205(Element):
    cv_arg: TypeAlias = RuleContent_614.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_614

    @classmethod
    def create(cls, arg: "Variation_205.cv_arg") -> "Variation_205":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_614:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_614:
        return self.rule.content

class RuleVariation_198(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_205.cv_arg
    cv_variation: TypeAlias = Variation_205

    @classmethod
    def create(cls, arg : "RuleVariation_198.cv_arg") -> "RuleVariation_198":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_205:
        return self.arg # type: ignore

class NonSpare_1174(NonSpare):
    cv_arg: TypeAlias = RuleVariation_198.cv_arg
    cv_name = "LENGTH"
    cv_title = "Length"
    cv_rule: TypeAlias = RuleVariation_198

    @classmethod
    def create(cls, arg : "NonSpare_1174.cv_arg") -> "NonSpare_1174":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_198:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_205:
        return self.rule.variation

class Item_481(Item):
    cv_arg: TypeAlias = NonSpare_1174.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1174

    @classmethod
    def create(cls, arg : "Item_481.cv_arg") -> "Item_481":
        return cls._create(arg) # type: ignore

class Variation_1318(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_197.cv_arg, Tuple[Literal["X"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y"], RuleVariation_197.cv_arg]], Union[RuleVariation_198.cv_arg, Tuple[Literal["LENGTH"], RuleVariation_198.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1318.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_1205, 8), (Item_1256, 8), (Item_481, 8)]
    cv_items_dict = {"X": RuleVariation_197, "Y": RuleVariation_197, "LENGTH": RuleVariation_198}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> Type[RuleVariation_197]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> Type[RuleVariation_197]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LENGTH"]) -> Type[RuleVariation_198]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["LENGTH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["LENGTH"]) -> RuleVariation_198:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1318.cv_arg") -> 'Variation_1318':
        return cls._create(arg) # type: ignore

class Variation_1459(Repetitive):
    cv_arg: TypeAlias = List[Variation_1318.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1318

    @classmethod
    def create(cls, arg: "Variation_1459.cv_arg") -> 'Variation_1459':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1318]:
        return self._get_list() # type: ignore

class RuleVariation_1380(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1459.cv_arg
    cv_variation: TypeAlias = Variation_1459

    @classmethod
    def create(cls, arg : "RuleVariation_1380.cv_arg") -> "RuleVariation_1380":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1459:
        return self.arg # type: ignore

class NonSpare_133(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1380.cv_arg
    cv_name = "036"
    cv_title = "Sequence of Cartesian Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1380

    @classmethod
    def create(cls, arg : "NonSpare_133.cv_arg") -> "NonSpare_133":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1380:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1459:
        return self.rule.variation

class UapItem_133(UapItem):
    cv_non_spare: TypeAlias = NonSpare_133

class NonSpare_1804(NonSpare):
    cv_arg: TypeAlias = RuleVariation_198.cv_arg
    cv_name = "STR"
    cv_title = "Start Range"
    cv_rule: TypeAlias = RuleVariation_198

    @classmethod
    def create(cls, arg : "NonSpare_1804.cv_arg") -> "NonSpare_1804":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_198:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_205:
        return self.rule.variation

class Item_961(Item):
    cv_arg: TypeAlias = NonSpare_1804.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1804

    @classmethod
    def create(cls, arg : "Item_961.cv_arg") -> "Item_961":
        return cls._create(arg) # type: ignore

class NonSpare_940(NonSpare):
    cv_arg: TypeAlias = RuleVariation_198.cv_arg
    cv_name = "ENDR"
    cv_title = "End Range"
    cv_rule: TypeAlias = RuleVariation_198

    @classmethod
    def create(cls, arg : "NonSpare_940.cv_arg") -> "NonSpare_940":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_198:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_205:
        return self.rule.variation

class Item_298(Item):
    cv_arg: TypeAlias = NonSpare_940.cv_arg
    cv_non_spare: TypeAlias = NonSpare_940

    @classmethod
    def create(cls, arg : "Item_298.cv_arg") -> "Item_298":
        return cls._create(arg) # type: ignore

class NonSpare_665(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "AZ"
    cv_title = "Azimuth"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_665.cv_arg") -> "NonSpare_665":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_106(Item):
    cv_arg: TypeAlias = NonSpare_665.cv_arg
    cv_non_spare: TypeAlias = NonSpare_665

    @classmethod
    def create(cls, arg : "Item_106.cv_arg") -> "Item_106":
        return cls._create(arg) # type: ignore

class Variation_1225(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_198.cv_arg, Tuple[Literal["STR"], RuleVariation_198.cv_arg]], Union[RuleVariation_198.cv_arg, Tuple[Literal["ENDR"], RuleVariation_198.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["AZ"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1225.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_961, 8), (Item_298, 8), (Item_106, 16)]
    cv_items_dict = {"STR": RuleVariation_198, "ENDR": RuleVariation_198, "AZ": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["STR"]) -> Type[RuleVariation_198]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ENDR"]) -> Type[RuleVariation_198]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AZ"]) -> Type[RuleVariation_336]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STR"], Literal["ENDR"], Literal["AZ"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STR"]) -> RuleVariation_198:
        ...
    @overload
    def get_item(self, key : Literal["ENDR"]) -> RuleVariation_198:
        ...
    @overload
    def get_item(self, key : Literal["AZ"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1225.cv_arg") -> 'Variation_1225':
        return cls._create(arg) # type: ignore

class Variation_1443(Repetitive):
    cv_arg: TypeAlias = List[Variation_1225.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1225

    @classmethod
    def create(cls, arg: "Variation_1443.cv_arg") -> 'Variation_1443':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1225]:
        return self._get_list() # type: ignore

class RuleVariation_1364(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1443.cv_arg
    cv_variation: TypeAlias = Variation_1443

    @classmethod
    def create(cls, arg : "RuleVariation_1364.cv_arg") -> "RuleVariation_1364":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1443:
        return self.arg # type: ignore

class NonSpare_128(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1364.cv_arg
    cv_name = "034"
    cv_title = "Sequence of Polar Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1364

    @classmethod
    def create(cls, arg : "NonSpare_128.cv_arg") -> "NonSpare_128":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1364:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1443:
        return self.rule.variation

class UapItem_128(UapItem):
    cv_non_spare: TypeAlias = NonSpare_128

class Variation_483(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_483.cv_arg") -> "Variation_483":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_472(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_483.cv_arg
    cv_variation: TypeAlias = Variation_483

    @classmethod
    def create(cls, arg : "RuleVariation_472.cv_arg") -> "RuleVariation_472":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_483:
        return self.arg # type: ignore

class NonSpare_1091(NonSpare):
    cv_arg: TypeAlias = RuleVariation_472.cv_arg
    cv_name = "I"
    cv_title = "Intensity Level"
    cv_rule: TypeAlias = RuleVariation_472

    @classmethod
    def create(cls, arg : "NonSpare_1091.cv_arg") -> "NonSpare_1091":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_472:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_483:
        return self.rule.variation

class Item_410(Item):
    cv_arg: TypeAlias = NonSpare_1091.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1091

    @classmethod
    def create(cls, arg : "Item_410.cv_arg") -> "Item_410":
        return cls._create(arg) # type: ignore

class Item_20(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 4
    cv_bit_size = 2

class Content_248(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Intermediate record of a contour", 1: "Last record of a contour of at least two records", 2: "First record of a contour of at least two records", 3: "First and only record, fully defining a contour"}

class RuleContent_248(RuleContentContextFree):
    cv_arg: TypeAlias = Content_248.cv_arg
    cv_content: TypeAlias = Content_248

    @property
    def content(self) -> Content_248:
        return self._get_content() # type: ignore

class Variation_964(Element):
    cv_arg: TypeAlias = RuleContent_248.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 2
    cv_rule = RuleContent_248

    @classmethod
    def create(cls, arg: "Variation_964.cv_arg") -> "Variation_964":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_248:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_248:
        return self.rule.content

class RuleVariation_934(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_964.cv_arg
    cv_variation: TypeAlias = Variation_964

    @classmethod
    def create(cls, arg : "RuleVariation_934.cv_arg") -> "RuleVariation_934":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_964:
        return self.arg # type: ignore

class NonSpare_1009(NonSpare):
    cv_arg: TypeAlias = RuleVariation_934.cv_arg
    cv_name = "FSTLST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_934

    @classmethod
    def create(cls, arg : "NonSpare_1009.cv_arg") -> "NonSpare_1009":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_934:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_964:
        return self.rule.variation

class Item_352(Item):
    cv_arg: TypeAlias = NonSpare_1009.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1009

    @classmethod
    def create(cls, arg : "Item_352.cv_arg") -> "Item_352":
        return cls._create(arg) # type: ignore

class NonSpare_840(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "CSN"
    cv_title = "Contour Serial Number"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_840.cv_arg") -> "NonSpare_840":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_221(Item):
    cv_arg: TypeAlias = NonSpare_840.cv_arg
    cv_non_spare: TypeAlias = NonSpare_840

    @classmethod
    def create(cls, arg : "Item_221.cv_arg") -> "Item_221":
        return cls._create(arg) # type: ignore

class Variation_1162(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_52.cv_arg, Tuple[Literal["ORG"], RuleVariation_52.cv_arg]], Union[RuleVariation_472.cv_arg, Tuple[Literal["I"], RuleVariation_472.cv_arg]], int, Union[RuleVariation_934.cv_arg, Tuple[Literal["FSTLST"], RuleVariation_934.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["CSN"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1162.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_664, 1), (Item_410, 3), (Item_20, 2), (Item_352, 2), (Item_221, 8)]
    cv_items_dict = {"ORG": RuleVariation_52, "I": RuleVariation_472, "FSTLST": RuleVariation_934, "CSN": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["ORG"]) -> Type[RuleVariation_52]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["I"]) -> Type[RuleVariation_472]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FSTLST"]) -> Type[RuleVariation_934]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CSN"]) -> Type[RuleVariation_159]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["ORG"], Literal["I"], Literal["FSTLST"], Literal["CSN"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_52:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_472:
        ...
    @overload
    def get_item(self, key : Literal["FSTLST"]) -> RuleVariation_934:
        ...
    @overload
    def get_item(self, key : Literal["CSN"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1162.cv_arg") -> 'Variation_1162':
        return cls._create(arg) # type: ignore

class RuleVariation_1115(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1162.cv_arg
    cv_variation: TypeAlias = Variation_1162

    @classmethod
    def create(cls, arg : "RuleVariation_1115.cv_arg") -> "RuleVariation_1115":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1162:
        return self.arg # type: ignore

class NonSpare_137(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1115.cv_arg
    cv_name = "040"
    cv_title = "Contour Identifier"
    cv_rule: TypeAlias = RuleVariation_1115

    @classmethod
    def create(cls, arg : "NonSpare_137.cv_arg") -> "NonSpare_137":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1115:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1162:
        return self.rule.variation

class UapItem_137(UapItem):
    cv_non_spare: TypeAlias = NonSpare_137

class NonSpare_2115(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2115.cv_arg") -> "NonSpare_2115":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1212(Item):
    cv_arg: TypeAlias = NonSpare_2115.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2115

    @classmethod
    def create(cls, arg : "Item_1212.cv_arg") -> "Item_1212":
        return cls._create(arg) # type: ignore

class NonSpare_2169(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2169.cv_arg") -> "NonSpare_2169":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1263(Item):
    cv_arg: TypeAlias = NonSpare_2169.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2169

    @classmethod
    def create(cls, arg : "Item_1263.cv_arg") -> "Item_1263":
        return cls._create(arg) # type: ignore

class Variation_1325(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_197.cv_arg, Tuple[Literal["X1"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y1"], RuleVariation_197.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1325.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1212, 8), (Item_1263, 8)]
    cv_items_dict = {"X1": RuleVariation_197, "Y1": RuleVariation_197}

    @overload
    @classmethod
    def spec(cls, key : Literal["X1"]) -> Type[RuleVariation_197]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y1"]) -> Type[RuleVariation_197]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X1"], Literal["Y1"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X1"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y1"]) -> RuleVariation_197:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1325.cv_arg") -> 'Variation_1325':
        return cls._create(arg) # type: ignore

class Variation_1461(Repetitive):
    cv_arg: TypeAlias = List[Variation_1325.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1325

    @classmethod
    def create(cls, arg: "Variation_1461.cv_arg") -> 'Variation_1461':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1325]:
        return self._get_list() # type: ignore

class RuleVariation_1382(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1461.cv_arg
    cv_variation: TypeAlias = Variation_1461

    @classmethod
    def create(cls, arg : "RuleVariation_1382.cv_arg") -> "RuleVariation_1382":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1461:
        return self.arg # type: ignore

class NonSpare_178(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1382.cv_arg
    cv_name = "050"
    cv_title = "Sequence of Contour Points in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1382

    @classmethod
    def create(cls, arg : "NonSpare_178.cv_arg") -> "NonSpare_178":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1382:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1461:
        return self.rule.variation

class UapItem_178(UapItem):
    cv_non_spare: TypeAlias = NonSpare_178

class NonSpare_260(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "090"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_260.cv_arg") -> "NonSpare_260":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_260(UapItem):
    cv_non_spare: TypeAlias = NonSpare_260

class Variation_146(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 5
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_146.cv_arg") -> "Variation_146":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_146(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_146.cv_arg
    cv_variation: TypeAlias = Variation_146

    @classmethod
    def create(cls, arg : "RuleVariation_146.cv_arg") -> "RuleVariation_146":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_146:
        return self.arg # type: ignore

class Variation_892(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 3
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_892.cv_arg") -> "Variation_892":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_862(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_892.cv_arg
    cv_variation: TypeAlias = Variation_892

    @classmethod
    def create(cls, arg : "RuleVariation_862.cv_arg") -> "RuleVariation_862":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_892:
        return self.arg # type: ignore

class Variation_251(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 15
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_251.cv_arg") -> "Variation_251":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_244(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_251.cv_arg
    cv_variation: TypeAlias = Variation_251

    @classmethod
    def create(cls, arg : "RuleVariation_244.cv_arg") -> "RuleVariation_244":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_251:
        return self.arg # type: ignore

class NonSpare_973(NonSpare):
    cv_arg: TypeAlias = RuleVariation_146.cv_arg
    cv_name = "F"
    cv_title = "Scaling Factor"
    cv_rule: TypeAlias = RuleVariation_146

    @classmethod
    def create(cls, arg : "NonSpare_973.cv_arg") -> "NonSpare_973":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_146:
        return self.rule.variation

class Item_328(Item):
    cv_arg: TypeAlias = NonSpare_973.cv_arg
    cv_non_spare: TypeAlias = NonSpare_973

    @classmethod
    def create(cls, arg : "Item_328.cv_arg") -> "Item_328":
        return cls._create(arg) # type: ignore

class NonSpare_1537(NonSpare):
    cv_arg: TypeAlias = RuleVariation_862.cv_arg
    cv_name = "R"
    cv_title = "Current Reduction Stage in Use"
    cv_rule: TypeAlias = RuleVariation_862

    @classmethod
    def create(cls, arg : "NonSpare_1537.cv_arg") -> "NonSpare_1537":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_862:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_892:
        return self.rule.variation

class Item_766(Item):
    cv_arg: TypeAlias = NonSpare_1537.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1537

    @classmethod
    def create(cls, arg : "Item_766.cv_arg") -> "Item_766":
        return cls._create(arg) # type: ignore

class NonSpare_1493(NonSpare):
    cv_arg: TypeAlias = RuleVariation_244.cv_arg
    cv_name = "Q"
    cv_title = "Processing Parameters"
    cv_rule: TypeAlias = RuleVariation_244

    @classmethod
    def create(cls, arg : "NonSpare_1493.cv_arg") -> "NonSpare_1493":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_251:
        return self.rule.variation

class Item_723(Item):
    cv_arg: TypeAlias = NonSpare_1493.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1493

    @classmethod
    def create(cls, arg : "Item_723.cv_arg") -> "Item_723":
        return cls._create(arg) # type: ignore

class Variation_1368(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_146.cv_arg, Tuple[Literal["F"], RuleVariation_146.cv_arg]], Union[RuleVariation_862.cv_arg, Tuple[Literal["R"], RuleVariation_862.cv_arg]], Union[RuleVariation_244.cv_arg, Tuple[Literal["Q"], RuleVariation_244.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1368.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_328, 5), (Item_766, 3), (Item_723, 15), None]]

    @classmethod
    def create(cls, arg: "Variation_1368.cv_arg") -> 'Variation_1368':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["F"]) -> RuleVariation_146:
        ...
    @overload
    def get_item(self, key : Literal["R"]) -> RuleVariation_862:
        ...
    @overload
    def get_item(self, key : Literal["Q"]) -> RuleVariation_244:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1289(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1368.cv_arg
    cv_variation: TypeAlias = Variation_1368

    @classmethod
    def create(cls, arg : "RuleVariation_1289.cv_arg") -> "RuleVariation_1289":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1368:
        return self.arg # type: ignore

class NonSpare_276(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1289.cv_arg
    cv_name = "100"
    cv_title = "Processing Status"
    cv_rule: TypeAlias = RuleVariation_1289

    @classmethod
    def create(cls, arg : "NonSpare_276.cv_arg") -> "NonSpare_276":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1289:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1368:
        return self.rule.variation

class UapItem_276(UapItem):
    cv_non_spare: TypeAlias = NonSpare_276

class NonSpare_292(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1384.cv_arg
    cv_name = "110"
    cv_title = "Station Configuration Status"
    cv_rule: TypeAlias = RuleVariation_1384

    @classmethod
    def create(cls, arg : "NonSpare_292.cv_arg") -> "NonSpare_292":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1463:
        return self.rule.variation

class UapItem_292(UapItem):
    cv_non_spare: TypeAlias = NonSpare_292

class Variation_256(Element):
    cv_arg: TypeAlias = RuleContent_614.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_614

    @classmethod
    def create(cls, arg: "Variation_256.cv_arg") -> "Variation_256":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_614:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_614:
        return self.rule.content

class RuleVariation_249(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_256.cv_arg
    cv_variation: TypeAlias = Variation_256

    @classmethod
    def create(cls, arg : "RuleVariation_249.cv_arg") -> "RuleVariation_249":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_256:
        return self.arg # type: ignore

class NonSpare_305(NonSpare):
    cv_arg: TypeAlias = RuleVariation_249.cv_arg
    cv_name = "120"
    cv_title = "Total Number of Items Constituting One Weather Picture"
    cv_rule: TypeAlias = RuleVariation_249

    @classmethod
    def create(cls, arg : "NonSpare_305.cv_arg") -> "NonSpare_305":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_249:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_256:
        return self.rule.variation

class UapItem_305(UapItem):
    cv_non_spare: TypeAlias = NonSpare_305

class NonSpare_2117(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X1"
    cv_title = "X1-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2117.cv_arg") -> "NonSpare_2117":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1214(Item):
    cv_arg: TypeAlias = NonSpare_2117.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2117

    @classmethod
    def create(cls, arg : "Item_1214.cv_arg") -> "Item_1214":
        return cls._create(arg) # type: ignore

class NonSpare_2170(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y1"
    cv_title = "Y1-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2170.cv_arg") -> "NonSpare_2170":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1264(Item):
    cv_arg: TypeAlias = NonSpare_2170.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2170

    @classmethod
    def create(cls, arg : "Item_1264.cv_arg") -> "Item_1264":
        return cls._create(arg) # type: ignore

class NonSpare_2121(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "X2"
    cv_title = "X2-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2121.cv_arg") -> "NonSpare_2121":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1218(Item):
    cv_arg: TypeAlias = NonSpare_2121.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2121

    @classmethod
    def create(cls, arg : "Item_1218.cv_arg") -> "Item_1218":
        return cls._create(arg) # type: ignore

class NonSpare_2172(NonSpare):
    cv_arg: TypeAlias = RuleVariation_197.cv_arg
    cv_name = "Y2"
    cv_title = "Y2-Component"
    cv_rule: TypeAlias = RuleVariation_197

    @classmethod
    def create(cls, arg : "NonSpare_2172.cv_arg") -> "NonSpare_2172":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_197:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_204:
        return self.rule.variation

class Item_1266(Item):
    cv_arg: TypeAlias = NonSpare_2172.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2172

    @classmethod
    def create(cls, arg : "Item_1266.cv_arg") -> "Item_1266":
        return cls._create(arg) # type: ignore

class Variation_1326(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_197.cv_arg, Tuple[Literal["X1"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y1"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["X2"], RuleVariation_197.cv_arg]], Union[RuleVariation_197.cv_arg, Tuple[Literal["Y2"], RuleVariation_197.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1326.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1214, 8), (Item_1264, 8), (Item_1218, 8), (Item_1266, 8)]
    cv_items_dict = {"X1": RuleVariation_197, "Y1": RuleVariation_197, "X2": RuleVariation_197, "Y2": RuleVariation_197}

    @overload
    @classmethod
    def spec(cls, key : Literal["X1"]) -> Type[RuleVariation_197]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y1"]) -> Type[RuleVariation_197]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["X2"]) -> Type[RuleVariation_197]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y2"]) -> Type[RuleVariation_197]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X1"], Literal["Y1"], Literal["X2"], Literal["Y2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X1"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y1"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["X2"]) -> RuleVariation_197:
        ...
    @overload
    def get_item(self, key : Literal["Y2"]) -> RuleVariation_197:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1326.cv_arg") -> 'Variation_1326':
        return cls._create(arg) # type: ignore

class Variation_1462(Repetitive):
    cv_arg: TypeAlias = List[Variation_1326.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1326

    @classmethod
    def create(cls, arg: "Variation_1462.cv_arg") -> 'Variation_1462':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1326]:
        return self._get_list() # type: ignore

class RuleVariation_1383(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1462.cv_arg
    cv_variation: TypeAlias = Variation_1462

    @classmethod
    def create(cls, arg : "RuleVariation_1383.cv_arg") -> "RuleVariation_1383":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1462:
        return self.arg # type: ignore

class NonSpare_135(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1383.cv_arg
    cv_name = "038"
    cv_title = "Sequence of Weather Vectors in SPF Notation"
    cv_rule: TypeAlias = RuleVariation_1383

    @classmethod
    def create(cls, arg : "NonSpare_135.cv_arg") -> "NonSpare_135":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1462:
        return self.rule.variation

class UapItem_135(UapItem):
    cv_non_spare: TypeAlias = NonSpare_135

class Record_20(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "000": NonSpare_8.cv_arg,
        "020": NonSpare_96.cv_arg,
        "036": NonSpare_133.cv_arg,
        "034": NonSpare_128.cv_arg,
        "040": NonSpare_137.cv_arg,
        "050": NonSpare_178.cv_arg,
        "090": NonSpare_260.cv_arg,
        "100": NonSpare_276.cv_arg,
        "110": NonSpare_292.cv_arg,
        "120": NonSpare_305.cv_arg,
        "038": NonSpare_135.cv_arg,
        "SP": NonSpare_1739.cv_arg,
    }, total=False)
    cv_union: TypeAlias = Union[
        Tuple[Literal["010"], NonSpare_37.cv_arg],
        Tuple[Literal["000"], NonSpare_8.cv_arg],
        Tuple[Literal["020"], NonSpare_96.cv_arg],
        Tuple[Literal["036"], NonSpare_133.cv_arg],
        Tuple[Literal["034"], NonSpare_128.cv_arg],
        Tuple[Literal["040"], NonSpare_137.cv_arg],
        Tuple[Literal["050"], NonSpare_178.cv_arg],
        Tuple[Literal["090"], NonSpare_260.cv_arg],
        Tuple[Literal["100"], NonSpare_276.cv_arg],
        Tuple[Literal["110"], NonSpare_292.cv_arg],
        Tuple[Literal["120"], NonSpare_305.cv_arg],
        Tuple[Literal["038"], NonSpare_135.cv_arg],
        Tuple[Literal["SP"], NonSpare_1739.cv_arg],
    ]
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_37, UapItem_8, UapItem_96, UapItem_133, UapItem_128, UapItem_137, UapItem_178, UapItem_260, UapItem_276, UapItem_292, UapItem_305, UapItem_135, UapItem_550, UapItem_552]
    cv_items_dict = {"010": NonSpare_37, "000": NonSpare_8, "020": NonSpare_96, "036": NonSpare_133, "034": NonSpare_128, "040": NonSpare_137, "050": NonSpare_178, "090": NonSpare_260, "100": NonSpare_276, "110": NonSpare_292, "120": NonSpare_305, "038": NonSpare_135, "SP": NonSpare_1739}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_37]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> Type[NonSpare_8]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_96]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["036"]) -> Type[NonSpare_133]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["034"]) -> Type[NonSpare_128]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_137]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["050"]) -> Type[NonSpare_178]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_260]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_276]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["110"]) -> Type[NonSpare_292]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["120"]) -> Type[NonSpare_305]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["038"]) -> Type[NonSpare_135]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["036"], Literal["034"], Literal["040"], Literal["050"], Literal["090"], Literal["100"], Literal["110"], Literal["120"], Literal["038"], Literal["SP"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_8]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_96]:
        ...
    @overload
    def get_item(self, key : Literal["036"]) -> Optional[NonSpare_133]:
        ...
    @overload
    def get_item(self, key : Literal["034"]) -> Optional[NonSpare_128]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_137]:
        ...
    @overload
    def get_item(self, key : Literal["050"]) -> Optional[NonSpare_178]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_260]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_276]:
        ...
    @overload
    def get_item(self, key : Literal["110"]) -> Optional[NonSpare_292]:
        ...
    @overload
    def get_item(self, key : Literal["120"]) -> Optional[NonSpare_305]:
        ...
    @overload
    def get_item(self, key : Literal["038"]) -> Optional[NonSpare_135]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_8.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_96.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["036"], val : NonSpare_133.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["034"], val : NonSpare_128.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_137.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["050"], val : NonSpare_178.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_260.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_276.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["110"], val : NonSpare_292.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["120"], val : NonSpare_305.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["038"], val : NonSpare_135.cv_arg) -> 'Record_20':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_20':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["036"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["034"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["050"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["110"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["120"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["038"]) -> 'Record_20':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_20':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @overload
    def get_rfs_item(self, arg : Literal["010"]) -> List[NonSpare_37]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["000"]) -> List[NonSpare_8]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["020"]) -> List[NonSpare_96]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["036"]) -> List[NonSpare_133]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["034"]) -> List[NonSpare_128]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["040"]) -> List[NonSpare_137]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["050"]) -> List[NonSpare_178]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["090"]) -> List[NonSpare_260]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["100"]) -> List[NonSpare_276]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["110"]) -> List[NonSpare_292]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["120"]) -> List[NonSpare_305]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["038"]) -> List[NonSpare_135]:
        ...
    @overload
    def get_rfs_item(self, arg : Literal["SP"]) -> List[NonSpare_1739]:
        ...
    def get_rfs_item(self, arg : Any) -> Any:
        return self._get_rfs_item(arg)

    @classmethod
    def create(cls, arg: "Record_20.cv_arg", rfs: Optional[List["Record_20.cv_union"]] = None) -> 'Record_20':
        return cls._create(arg, rfs) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_20", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_18(UapSingle):
    cv_arg: TypeAlias = Record_20
    cv_record: TypeAlias = Record_20

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_20]]:
        return cls._parse(bs)

class Asterix_8(AstCat):
    cv_category = 8
    cv_edition = (1, 2)
    cv_uap: TypeAlias = Uap_18
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_18.cv_arg]) -> "Asterix_8":
        return cls._create(records) # type: ignore

class Asterix_9(AstCat):
    cv_category = 8
    cv_edition = (1, 3)
    cv_uap: TypeAlias = Uap_18
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_18.cv_arg]) -> "Asterix_9":
        return cls._create(records) # type: ignore

class Content_606(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {2: "Cartesian vector", 253: "Intermediate-update-step message", 254: "Start-of-picture message", 255: "End-of-picture message"}

class RuleContent_606(RuleContentContextFree):
    cv_arg: TypeAlias = Content_606.cv_arg
    cv_content: TypeAlias = Content_606

    @property
    def content(self) -> Content_606:
        return self._get_content() # type: ignore

class Variation_201(Element):
    cv_arg: TypeAlias = RuleContent_606.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_606

    @classmethod
    def create(cls, arg: "Variation_201.cv_arg") -> "Variation_201":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_606:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_606:
        return self.rule.content

class RuleVariation_194(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_201.cv_arg
    cv_variation: TypeAlias = Variation_201

    @classmethod
    def create(cls, arg : "RuleVariation_194.cv_arg") -> "RuleVariation_194":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_201:
        return self.arg # type: ignore

class NonSpare_16(NonSpare):
    cv_arg: TypeAlias = RuleVariation_194.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_194

    @classmethod
    def create(cls, arg : "NonSpare_16.cv_arg") -> "NonSpare_16":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_194:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_201:
        return self.rule.variation

class UapItem_16(UapItem):
    cv_non_spare: TypeAlias = NonSpare_16

class Variation_1387(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_52.cv_arg, Tuple[Literal["ORG"], RuleVariation_52.cv_arg]], Union[RuleVariation_478.cv_arg, Tuple[Literal["I"], RuleVariation_478.cv_arg]], Union[RuleVariation_766.cv_arg, Tuple[Literal["S"], RuleVariation_766.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1387.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_664, 1), (Item_411, 3), (Item_854, 3), None]]

    @classmethod
    def create(cls, arg: "Variation_1387.cv_arg") -> 'Variation_1387':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["ORG"]) -> RuleVariation_52:
        ...
    @overload
    def get_item(self, key : Literal["I"]) -> RuleVariation_478:
        ...
    @overload
    def get_item(self, key : Literal["S"]) -> RuleVariation_766:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1308(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1387.cv_arg
    cv_variation: TypeAlias = Variation_1387

    @classmethod
    def create(cls, arg : "RuleVariation_1308.cv_arg") -> "RuleVariation_1308":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1387:
        return self.arg # type: ignore

class NonSpare_95(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1308.cv_arg
    cv_name = "020"
    cv_title = "Vector Qualifier"
    cv_rule: TypeAlias = RuleVariation_1308

    @classmethod
    def create(cls, arg : "NonSpare_95.cv_arg") -> "NonSpare_95":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1308:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1387:
        return self.rule.variation

class UapItem_95(UapItem):
    cv_non_spare: TypeAlias = NonSpare_95

class Variation_255(Element):
    cv_arg: TypeAlias = RuleContent_613.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_613

    @classmethod
    def create(cls, arg: "Variation_255.cv_arg") -> "Variation_255":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_613:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_613:
        return self.rule.content

class RuleVariation_248(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_255.cv_arg
    cv_variation: TypeAlias = Variation_255

    @classmethod
    def create(cls, arg : "RuleVariation_248.cv_arg") -> "RuleVariation_248":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_255:
        return self.arg # type: ignore

class NonSpare_2112(NonSpare):
    cv_arg: TypeAlias = RuleVariation_248.cv_arg
    cv_name = "X"
    cv_title = "X-coordinate"
    cv_rule: TypeAlias = RuleVariation_248

    @classmethod
    def create(cls, arg : "NonSpare_2112.cv_arg") -> "NonSpare_2112":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_248:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_255:
        return self.rule.variation

class Item_1209(Item):
    cv_arg: TypeAlias = NonSpare_2112.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2112

    @classmethod
    def create(cls, arg : "Item_1209.cv_arg") -> "Item_1209":
        return cls._create(arg) # type: ignore

class NonSpare_2166(NonSpare):
    cv_arg: TypeAlias = RuleVariation_248.cv_arg
    cv_name = "Y"
    cv_title = "Y-coordinate"
    cv_rule: TypeAlias = RuleVariation_248

    @classmethod
    def create(cls, arg : "NonSpare_2166.cv_arg") -> "NonSpare_2166":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_248:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_255:
        return self.rule.variation

class Item_1260(Item):
    cv_arg: TypeAlias = NonSpare_2166.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2166

    @classmethod
    def create(cls, arg : "Item_1260.cv_arg") -> "Item_1260":
        return cls._create(arg) # type: ignore

class NonSpare_1150(NonSpare):
    cv_arg: TypeAlias = RuleVariation_249.cv_arg
    cv_name = "L"
    cv_title = "Vector Length"
    cv_rule: TypeAlias = RuleVariation_249

    @classmethod
    def create(cls, arg : "NonSpare_1150.cv_arg") -> "NonSpare_1150":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_249:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_256:
        return self.rule.variation

class Item_459(Item):
    cv_arg: TypeAlias = NonSpare_1150.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1150

    @classmethod
    def create(cls, arg : "Item_459.cv_arg") -> "Item_459":
        return cls._create(arg) # type: ignore

class Variation_1323(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_248.cv_arg, Tuple[Literal["X"], RuleVariation_248.cv_arg]], Union[RuleVariation_248.cv_arg, Tuple[Literal["Y"], RuleVariation_248.cv_arg]], Union[RuleVariation_249.cv_arg, Tuple[Literal["L"], RuleVariation_249.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1323.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 48
    cv_items_list = [(Item_1209, 16), (Item_1260, 16), (Item_459, 16)]
    cv_items_dict = {"X": RuleVariation_248, "Y": RuleVariation_248, "L": RuleVariation_249}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> Type[RuleVariation_248]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> Type[RuleVariation_248]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> Type[RuleVariation_249]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"], Literal["L"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_248:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_248:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_249:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1323.cv_arg") -> 'Variation_1323':
        return cls._create(arg) # type: ignore

class Variation_1460(Repetitive):
    cv_arg: TypeAlias = List[Variation_1323.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1323

    @classmethod
    def create(cls, arg: "Variation_1460.cv_arg") -> 'Variation_1460':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1323]:
        return self._get_list() # type: ignore

class RuleVariation_1381(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1460.cv_arg
    cv_variation: TypeAlias = Variation_1460

    @classmethod
    def create(cls, arg : "RuleVariation_1381.cv_arg") -> "RuleVariation_1381":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1460:
        return self.arg # type: ignore

class NonSpare_107(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1381.cv_arg
    cv_name = "030"
    cv_title = "Sequence of Cartesian Vectors"
    cv_rule: TypeAlias = RuleVariation_1381

    @classmethod
    def create(cls, arg : "NonSpare_107.cv_arg") -> "NonSpare_107":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1381:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1460:
        return self.rule.variation

class UapItem_107(UapItem):
    cv_non_spare: TypeAlias = NonSpare_107

class Variation_149(Element):
    cv_arg: TypeAlias = RuleContent_614.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 6
    cv_rule = RuleContent_614

    @classmethod
    def create(cls, arg: "Variation_149.cv_arg") -> "Variation_149":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_614:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_614:
        return self.rule.content

class RuleVariation_149(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_149.cv_arg
    cv_variation: TypeAlias = Variation_149

    @classmethod
    def create(cls, arg : "RuleVariation_149.cv_arg") -> "RuleVariation_149":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_149:
        return self.arg # type: ignore

class NonSpare_1736(NonSpare):
    cv_arg: TypeAlias = RuleVariation_149.cv_arg
    cv_name = "SN"
    cv_title = "Step Number"
    cv_rule: TypeAlias = RuleVariation_149

    @classmethod
    def create(cls, arg : "NonSpare_1736.cv_arg") -> "NonSpare_1736":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_149:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_149:
        return self.rule.variation

class Item_908(Item):
    cv_arg: TypeAlias = NonSpare_1736.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1736

    @classmethod
    def create(cls, arg : "Item_908.cv_arg") -> "Item_908":
        return cls._create(arg) # type: ignore

class Variation_1391(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_149.cv_arg, Tuple[Literal["SN"], RuleVariation_149.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1391.cv_arg_group_1"],
    ]
    cv_items_list = [[(Item_908, 6), (Item_26, 1), None]]

    @classmethod
    def create(cls, arg: "Variation_1391.cv_arg") -> 'Variation_1391':
        return cls._create(arg) # type: ignore

    @overload # type: ignore
    def get_item(self, key : Literal["SN"]) -> RuleVariation_149:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1312(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1391.cv_arg
    cv_variation: TypeAlias = Variation_1391

    @classmethod
    def create(cls, arg : "RuleVariation_1312.cv_arg") -> "RuleVariation_1312":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1391:
        return self.arg # type: ignore

class NonSpare_199(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1312.cv_arg
    cv_name = "060"
    cv_title = "Synchronisation/Control Signal"
    cv_rule: TypeAlias = RuleVariation_1312

    @classmethod
    def create(cls, arg : "NonSpare_199.cv_arg") -> "NonSpare_199":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1312:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1391:
        return self.rule.variation

class UapItem_199(UapItem):
    cv_non_spare: TypeAlias = NonSpare_199

class NonSpare_222(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "070"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_222.cv_arg") -> "NonSpare_222":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_222(UapItem):
    cv_non_spare: TypeAlias = NonSpare_222

class NonSpare_235(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1289.cv_arg
    cv_name = "080"
    cv_title = "Processing Status"
    cv_rule: TypeAlias = RuleVariation_1289

    @classmethod
    def create(cls, arg : "NonSpare_235.cv_arg") -> "NonSpare_235":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1289:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1368:
        return self.rule.variation

class UapItem_235(UapItem):
    cv_non_spare: TypeAlias = NonSpare_235

class NonSpare_1661(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SAC"
    cv_title = "SAC of Radar Concerned"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1661.cv_arg") -> "NonSpare_1661":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_859(Item):
    cv_arg: TypeAlias = NonSpare_1661.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1661

    @classmethod
    def create(cls, arg : "Item_859.cv_arg") -> "Item_859":
        return cls._create(arg) # type: ignore

class NonSpare_1716(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SIC"
    cv_title = "SIC of Radar Concerned"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1716.cv_arg") -> "NonSpare_1716":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_890(Item):
    cv_arg: TypeAlias = NonSpare_1716.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1716

    @classmethod
    def create(cls, arg : "Item_890.cv_arg") -> "Item_890":
        return cls._create(arg) # type: ignore

class Item_2(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 3

class Variation_615(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_615.cv_arg") -> "Variation_615":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_604(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_615.cv_arg
    cv_variation: TypeAlias = Variation_615

    @classmethod
    def create(cls, arg : "RuleVariation_604.cv_arg") -> "RuleVariation_604":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_615:
        return self.arg # type: ignore

class NonSpare_818(NonSpare):
    cv_arg: TypeAlias = RuleVariation_604.cv_arg
    cv_name = "CP"
    cv_title = "Circular Polarisation"
    cv_rule: TypeAlias = RuleVariation_604

    @classmethod
    def create(cls, arg : "NonSpare_818.cv_arg") -> "NonSpare_818":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_604:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_615:
        return self.rule.variation

class Item_207(Item):
    cv_arg: TypeAlias = NonSpare_818.cv_arg
    cv_non_spare: TypeAlias = NonSpare_818

    @classmethod
    def create(cls, arg : "Item_207.cv_arg") -> "Item_207":
        return cls._create(arg) # type: ignore

class Variation_701(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_701.cv_arg") -> "Variation_701":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_690(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_701.cv_arg
    cv_variation: TypeAlias = Variation_701

    @classmethod
    def create(cls, arg : "RuleVariation_690.cv_arg") -> "RuleVariation_690":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_701:
        return self.arg # type: ignore

class NonSpare_2074(NonSpare):
    cv_arg: TypeAlias = RuleVariation_690.cv_arg
    cv_name = "WO"
    cv_title = "Weather Channel Overload"
    cv_rule: TypeAlias = RuleVariation_690

    @classmethod
    def create(cls, arg : "NonSpare_2074.cv_arg") -> "NonSpare_2074":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_690:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_701:
        return self.rule.variation

class Item_1174(Item):
    cv_arg: TypeAlias = NonSpare_2074.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2074

    @classmethod
    def create(cls, arg : "Item_1174.cv_arg") -> "Item_1174":
        return cls._create(arg) # type: ignore

class NonSpare_1539(NonSpare):
    cv_arg: TypeAlias = RuleVariation_862.cv_arg
    cv_name = "R"
    cv_title = "Reduction Step in Use By Radar  Concerned"
    cv_rule: TypeAlias = RuleVariation_862

    @classmethod
    def create(cls, arg : "NonSpare_1539.cv_arg") -> "NonSpare_1539":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_862:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_892:
        return self.rule.variation

class Item_767(Item):
    cv_arg: TypeAlias = NonSpare_1539.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1539

    @classmethod
    def create(cls, arg : "Item_767.cv_arg") -> "Item_767":
        return cls._create(arg) # type: ignore

class Variation_1197(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["SAC"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["SIC"], RuleVariation_159.cv_arg]], int, Union[RuleVariation_604.cv_arg, Tuple[Literal["CP"], RuleVariation_604.cv_arg]], Union[RuleVariation_690.cv_arg, Tuple[Literal["WO"], RuleVariation_690.cv_arg]], Union[RuleVariation_862.cv_arg, Tuple[Literal["R"], RuleVariation_862.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1197.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_859, 8), (Item_890, 8), (Item_2, 3), (Item_207, 1), (Item_1174, 1), (Item_767, 3)]
    cv_items_dict = {"SAC": RuleVariation_159, "SIC": RuleVariation_159, "CP": RuleVariation_604, "WO": RuleVariation_690, "R": RuleVariation_862}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> Type[RuleVariation_159]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> Type[RuleVariation_159]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CP"]) -> Type[RuleVariation_604]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["WO"]) -> Type[RuleVariation_690]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["R"]) -> Type[RuleVariation_862]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"], Literal["CP"], Literal["WO"], Literal["R"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["CP"]) -> RuleVariation_604:
        ...
    @overload
    def get_item(self, key : Literal["WO"]) -> RuleVariation_690:
        ...
    @overload
    def get_item(self, key : Literal["R"]) -> RuleVariation_862:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1197.cv_arg") -> 'Variation_1197':
        return cls._create(arg) # type: ignore

class Variation_1437(Repetitive):
    cv_arg: TypeAlias = List[Variation_1197.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1197

    @classmethod
    def create(cls, arg: "Variation_1437.cv_arg") -> 'Variation_1437':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1197]:
        return self._get_list() # type: ignore

class RuleVariation_1358(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1437.cv_arg
    cv_variation: TypeAlias = Variation_1437

    @classmethod
    def create(cls, arg : "RuleVariation_1358.cv_arg") -> "RuleVariation_1358":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1437:
        return self.arg # type: ignore

class NonSpare_258(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1358.cv_arg
    cv_name = "090"
    cv_title = "Radar Configuration and Status"
    cv_rule: TypeAlias = RuleVariation_1358

    @classmethod
    def create(cls, arg : "NonSpare_258.cv_arg") -> "NonSpare_258":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1358:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1437:
        return self.rule.variation

class UapItem_258(UapItem):
    cv_non_spare: TypeAlias = NonSpare_258

class NonSpare_280(NonSpare):
    cv_arg: TypeAlias = RuleVariation_249.cv_arg
    cv_name = "100"
    cv_title = "Vector Count"
    cv_rule: TypeAlias = RuleVariation_249

    @classmethod
    def create(cls, arg : "NonSpare_280.cv_arg") -> "NonSpare_280":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_249:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_256:
        return self.rule.variation

class UapItem_280(UapItem):
    cv_non_spare: TypeAlias = NonSpare_280

class Record_21(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_37.cv_arg,
        "000": NonSpare_16.cv_arg,
        "020": NonSpare_95.cv_arg,
        "030": NonSpare_107.cv_arg,
        "060": NonSpare_199.cv_arg,
        "070": NonSpare_222.cv_arg,
        "080": NonSpare_235.cv_arg,
        "090": NonSpare_258.cv_arg,
        "100": NonSpare_280.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [UapItem_37, UapItem_16, UapItem_95, UapItem_107, UapItem_199, UapItem_222, UapItem_235, UapItem_258, UapItem_280]
    cv_items_dict = {"010": NonSpare_37, "000": NonSpare_16, "020": NonSpare_95, "030": NonSpare_107, "060": NonSpare_199, "070": NonSpare_222, "080": NonSpare_235, "090": NonSpare_258, "100": NonSpare_280}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_37]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> Type[NonSpare_16]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_95]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["030"]) -> Type[NonSpare_107]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_199]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["070"]) -> Type[NonSpare_222]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["080"]) -> Type[NonSpare_235]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_258]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["100"]) -> Type[NonSpare_280]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["030"], Literal["060"], Literal["070"], Literal["080"], Literal["090"], Literal["100"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_37]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_16]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_95]:
        ...
    @overload
    def get_item(self, key : Literal["030"]) -> Optional[NonSpare_107]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_199]:
        ...
    @overload
    def get_item(self, key : Literal["070"]) -> Optional[NonSpare_222]:
        ...
    @overload
    def get_item(self, key : Literal["080"]) -> Optional[NonSpare_235]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_258]:
        ...
    @overload
    def get_item(self, key : Literal["100"]) -> Optional[NonSpare_280]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_37.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_16.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_95.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["030"], val : NonSpare_107.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_199.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["070"], val : NonSpare_222.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["080"], val : NonSpare_235.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_258.cv_arg) -> 'Record_21':
        ...
    @overload
    def set_item(self, key : Literal["100"], val : NonSpare_280.cv_arg) -> 'Record_21':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["030"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["070"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["080"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_21':
        ...
    @overload
    def del_item(self, key : Literal["100"]) -> 'Record_21':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_21.cv_arg") -> 'Record_21':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_21", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_19(UapSingle):
    cv_arg: TypeAlias = Record_21
    cv_record: TypeAlias = Record_21

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_21]]:
        return cls._parse(bs)

class Asterix_10(AstCat):
    cv_category = 9
    cv_edition = (2, 1)
    cv_uap: TypeAlias = Uap_19
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_19.cv_arg]) -> "Asterix_10":
        return cls._create(records) # type: ignore

class NonSpare_43(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1146.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1146

    @classmethod
    def create(cls, arg : "NonSpare_43.cv_arg") -> "NonSpare_43":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1146:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1198:
        return self.rule.variation

class UapItem_43(UapItem):
    cv_non_spare: TypeAlias = NonSpare_43

class Content_600(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Target Report", 2: "Start of Update Cycle", 3: "Periodic Status Message", 4: "Event-triggered Status Message"}

class RuleContent_600(RuleContentContextFree):
    cv_arg: TypeAlias = Content_600.cv_arg
    cv_content: TypeAlias = Content_600

    @property
    def content(self) -> Content_600:
        return self._get_content() # type: ignore

class Variation_198(Element):
    cv_arg: TypeAlias = RuleContent_600.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_600

    @classmethod
    def create(cls, arg: "Variation_198.cv_arg") -> "Variation_198":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_600:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_600:
        return self.rule.content

class RuleVariation_191(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_198.cv_arg
    cv_variation: TypeAlias = Variation_198

    @classmethod
    def create(cls, arg : "RuleVariation_191.cv_arg") -> "RuleVariation_191":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_198:
        return self.arg # type: ignore

class NonSpare_13(NonSpare):
    cv_arg: TypeAlias = RuleVariation_191.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_191

    @classmethod
    def create(cls, arg : "NonSpare_13.cv_arg") -> "NonSpare_13":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_191:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_198:
        return self.rule.variation

class UapItem_13(UapItem):
    cv_non_spare: TypeAlias = NonSpare_13

class Content_452(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "SSR multilateration", 1: "Mode S multilateration", 2: "ADS-B", 3: "PSR", 4: "Magnetic Loop System", 5: "HF multilateration", 6: "Not defined", 7: "Other types"}

class RuleContent_452(RuleContentContextFree):
    cv_arg: TypeAlias = Content_452.cv_arg
    cv_content: TypeAlias = Content_452

    @property
    def content(self) -> Content_452:
        return self._get_content() # type: ignore

class Variation_131(Element):
    cv_arg: TypeAlias = RuleContent_452.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 3
    cv_rule = RuleContent_452

    @classmethod
    def create(cls, arg: "Variation_131.cv_arg") -> "Variation_131":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_452:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_452:
        return self.rule.content

class RuleVariation_131(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_131.cv_arg
    cv_variation: TypeAlias = Variation_131

    @classmethod
    def create(cls, arg : "RuleVariation_131.cv_arg") -> "RuleVariation_131":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_131:
        return self.arg # type: ignore

class Content_353(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No differential correction (ADS-B)", 1: "Differential correction (ADS-B)"}

class RuleContent_353(RuleContentContextFree):
    cv_arg: TypeAlias = Content_353.cv_arg
    cv_content: TypeAlias = Content_353

    @property
    def content(self) -> Content_353:
        return self._get_content() # type: ignore

class Variation_653(Element):
    cv_arg: TypeAlias = RuleContent_353.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_353

    @classmethod
    def create(cls, arg: "Variation_653.cv_arg") -> "Variation_653":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_353:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_353:
        return self.rule.content

class RuleVariation_642(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_653.cv_arg
    cv_variation: TypeAlias = Variation_653

    @classmethod
    def create(cls, arg : "RuleVariation_642.cv_arg") -> "RuleVariation_642":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_653:
        return self.arg # type: ignore

class Content_54(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Chain 1", 1: "Chain 2"}

class RuleContent_54(RuleContentContextFree):
    cv_arg: TypeAlias = Content_54.cv_arg
    cv_content: TypeAlias = Content_54

    @property
    def content(self) -> Content_54:
        return self._get_content() # type: ignore

class Variation_705(Element):
    cv_arg: TypeAlias = RuleContent_54.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_54

    @classmethod
    def create(cls, arg: "Variation_705.cv_arg") -> "Variation_705":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_54:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_54:
        return self.rule.content

class RuleVariation_694(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_705.cv_arg
    cv_variation: TypeAlias = Variation_705

    @classmethod
    def create(cls, arg : "RuleVariation_694.cv_arg") -> "RuleVariation_694":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_705:
        return self.arg # type: ignore

class Content_522(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Transponder Ground bit not set", 1: "Transponder Ground bit set"}

class RuleContent_522(RuleContentContextFree):
    cv_arg: TypeAlias = Content_522.cv_arg
    cv_content: TypeAlias = Content_522

    @property
    def content(self) -> Content_522:
        return self._get_content() # type: ignore

class Variation_878(Element):
    cv_arg: TypeAlias = RuleContent_522.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_522

    @classmethod
    def create(cls, arg: "Variation_878.cv_arg") -> "Variation_878":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_522:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_522:
        return self.rule.content

class RuleVariation_848(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_878.cv_arg
    cv_variation: TypeAlias = Variation_878

    @classmethod
    def create(cls, arg : "RuleVariation_848.cv_arg") -> "RuleVariation_848":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_878:
        return self.arg # type: ignore

class Content_307(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Corrupted reply in multilateration", 1: "Corrupted replies in multilateration"}

class RuleContent_307(RuleContentContextFree):
    cv_arg: TypeAlias = Content_307.cv_arg
    cv_content: TypeAlias = Content_307

    @property
    def content(self) -> Content_307:
        return self._get_content() # type: ignore

class Variation_943(Element):
    cv_arg: TypeAlias = RuleContent_307.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_307

    @classmethod
    def create(cls, arg: "Variation_943.cv_arg") -> "Variation_943":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_307:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_307:
        return self.rule.content

class RuleVariation_913(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_943.cv_arg
    cv_variation: TypeAlias = Variation_943

    @classmethod
    def create(cls, arg : "RuleVariation_913.cv_arg") -> "RuleVariation_913":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_943:
        return self.arg # type: ignore

class Content_20(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual target report", 1: "Simulated target report"}

class RuleContent_20(RuleContentContextFree):
    cv_arg: TypeAlias = Content_20.cv_arg
    cv_content: TypeAlias = Content_20

    @property
    def content(self) -> Content_20:
        return self._get_content() # type: ignore

class Variation_5(Element):
    cv_arg: TypeAlias = RuleContent_20.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_20

    @classmethod
    def create(cls, arg: "Variation_5.cv_arg") -> "Variation_5":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_20:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_20:
        return self.rule.content

class RuleVariation_5(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_5.cv_arg
    cv_variation: TypeAlias = Variation_5

    @classmethod
    def create(cls, arg : "RuleVariation_5.cv_arg") -> "RuleVariation_5":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_5:
        return self.arg # type: ignore

class Content_156(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Test Target"}

class RuleContent_156(RuleContentContextFree):
    cv_arg: TypeAlias = Content_156.cv_arg
    cv_content: TypeAlias = Content_156

    @property
    def content(self) -> Content_156:
        return self._get_content() # type: ignore

class Variation_419(Element):
    cv_arg: TypeAlias = RuleContent_156.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_156

    @classmethod
    def create(cls, arg: "Variation_419.cv_arg") -> "Variation_419":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_156:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_156:
        return self.rule.content

class RuleVariation_408(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_419.cv_arg
    cv_variation: TypeAlias = Variation_419

    @classmethod
    def create(cls, arg : "RuleVariation_408.cv_arg") -> "RuleVariation_408":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_419:
        return self.arg # type: ignore

class Content_443(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Report from target transponder", 1: "Report from field monitor (fixed transponder)"}

class RuleContent_443(RuleContentContextFree):
    cv_arg: TypeAlias = Content_443.cv_arg
    cv_content: TypeAlias = Content_443

    @property
    def content(self) -> Content_443:
        return self._get_content() # type: ignore

class Variation_575(Element):
    cv_arg: TypeAlias = RuleContent_443.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_443

    @classmethod
    def create(cls, arg: "Variation_575.cv_arg") -> "Variation_575":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_443:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_443:
        return self.rule.content

class RuleVariation_564(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_575.cv_arg
    cv_variation: TypeAlias = Variation_575

    @classmethod
    def create(cls, arg : "RuleVariation_564.cv_arg") -> "RuleVariation_564":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_575:
        return self.arg # type: ignore

class Content_534(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Undetermined", 1: "Loop start", 2: "Loop finish"}

class RuleContent_534(RuleContentContextFree):
    cv_arg: TypeAlias = Content_534.cv_arg
    cv_content: TypeAlias = Content_534

    @property
    def content(self) -> Content_534:
        return self._get_content() # type: ignore

class Variation_684(Element):
    cv_arg: TypeAlias = RuleContent_534.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 2
    cv_rule = RuleContent_534

    @classmethod
    def create(cls, arg: "Variation_684.cv_arg") -> "Variation_684":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_534:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_534:
        return self.rule.content

class RuleVariation_673(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_684.cv_arg
    cv_variation: TypeAlias = Variation_684

    @classmethod
    def create(cls, arg : "RuleVariation_673.cv_arg") -> "RuleVariation_673":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_684:
        return self.arg # type: ignore

class Content_533(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Undetermined", 1: "Aircraft", 2: "Ground vehicle", 3: "Helicopter"}

class RuleContent_533(RuleContentContextFree):
    cv_arg: TypeAlias = Content_533.cv_arg
    cv_content: TypeAlias = Content_533

    @property
    def content(self) -> Content_533:
        return self._get_content() # type: ignore

class Variation_890(Element):
    cv_arg: TypeAlias = RuleContent_533.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 2
    cv_rule = RuleContent_533

    @classmethod
    def create(cls, arg: "Variation_890.cv_arg") -> "Variation_890":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_533:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_533:
        return self.rule.content

class RuleVariation_860(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_890.cv_arg
    cv_variation: TypeAlias = Variation_890

    @classmethod
    def create(cls, arg : "RuleVariation_860.cv_arg") -> "RuleVariation_860":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_890:
        return self.arg # type: ignore

class Content_13(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Absence of SPI", 1: "Special Position Identification"}

class RuleContent_13(RuleContentContextFree):
    cv_arg: TypeAlias = Content_13.cv_arg
    cv_content: TypeAlias = Content_13

    @property
    def content(self) -> Content_13:
        return self._get_content() # type: ignore

class Variation_3(Element):
    cv_arg: TypeAlias = RuleContent_13.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_13

    @classmethod
    def create(cls, arg: "Variation_3.cv_arg") -> "Variation_3":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_13:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_13:
        return self.rule.content

class RuleVariation_3(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_3.cv_arg
    cv_variation: TypeAlias = Variation_3

    @classmethod
    def create(cls, arg : "RuleVariation_3.cv_arg") -> "RuleVariation_3":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_3:
        return self.arg # type: ignore

class NonSpare_1967(NonSpare):
    cv_arg: TypeAlias = RuleVariation_131.cv_arg
    cv_name = "TYP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_131

    @classmethod
    def create(cls, arg : "NonSpare_1967.cv_arg") -> "NonSpare_1967":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_131:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_131:
        return self.rule.variation

class Item_1078(Item):
    cv_arg: TypeAlias = NonSpare_1967.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1967

    @classmethod
    def create(cls, arg : "Item_1078.cv_arg") -> "Item_1078":
        return cls._create(arg) # type: ignore

class NonSpare_880(NonSpare):
    cv_arg: TypeAlias = RuleVariation_642.cv_arg
    cv_name = "DCR"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_642

    @classmethod
    def create(cls, arg : "NonSpare_880.cv_arg") -> "NonSpare_880":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_642:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_653:
        return self.rule.variation

class Item_255(Item):
    cv_arg: TypeAlias = NonSpare_880.cv_arg
    cv_non_spare: TypeAlias = NonSpare_880

    @classmethod
    def create(cls, arg : "Item_255.cv_arg") -> "Item_255":
        return cls._create(arg) # type: ignore

class NonSpare_739(NonSpare):
    cv_arg: TypeAlias = RuleVariation_694.cv_arg
    cv_name = "CHN"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_694

    @classmethod
    def create(cls, arg : "NonSpare_739.cv_arg") -> "NonSpare_739":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_694:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_705:
        return self.rule.variation

class Item_158(Item):
    cv_arg: TypeAlias = NonSpare_739.cv_arg
    cv_non_spare: TypeAlias = NonSpare_739

    @classmethod
    def create(cls, arg : "Item_158.cv_arg") -> "Item_158":
        return cls._create(arg) # type: ignore

class NonSpare_1034(NonSpare):
    cv_arg: TypeAlias = RuleVariation_848.cv_arg
    cv_name = "GBS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_848

    @classmethod
    def create(cls, arg : "NonSpare_1034.cv_arg") -> "NonSpare_1034":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_848:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_878:
        return self.rule.variation

class Item_369(Item):
    cv_arg: TypeAlias = NonSpare_1034.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1034

    @classmethod
    def create(cls, arg : "Item_369.cv_arg") -> "Item_369":
        return cls._create(arg) # type: ignore

class NonSpare_835(NonSpare):
    cv_arg: TypeAlias = RuleVariation_913.cv_arg
    cv_name = "CRT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_913

    @classmethod
    def create(cls, arg : "NonSpare_835.cv_arg") -> "NonSpare_835":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_913:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_943:
        return self.rule.variation

class Item_218(Item):
    cv_arg: TypeAlias = NonSpare_835.cv_arg
    cv_non_spare: TypeAlias = NonSpare_835

    @classmethod
    def create(cls, arg : "Item_218.cv_arg") -> "Item_218":
        return cls._create(arg) # type: ignore

class NonSpare_1730(NonSpare):
    cv_arg: TypeAlias = RuleVariation_5.cv_arg
    cv_name = "SIM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_5

    @classmethod
    def create(cls, arg : "NonSpare_1730.cv_arg") -> "NonSpare_1730":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_5:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_5:
        return self.rule.variation

class Item_902(Item):
    cv_arg: TypeAlias = NonSpare_1730.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1730

    @classmethod
    def create(cls, arg : "Item_902.cv_arg") -> "Item_902":
        return cls._create(arg) # type: ignore

class NonSpare_1942(NonSpare):
    cv_arg: TypeAlias = RuleVariation_408.cv_arg
    cv_name = "TST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_408

    @classmethod
    def create(cls, arg : "NonSpare_1942.cv_arg") -> "NonSpare_1942":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_408:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_419:
        return self.rule.variation

class Item_1056(Item):
    cv_arg: TypeAlias = NonSpare_1942.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1942

    @classmethod
    def create(cls, arg : "Item_1056.cv_arg") -> "Item_1056":
        return cls._create(arg) # type: ignore

class NonSpare_1543(NonSpare):
    cv_arg: TypeAlias = RuleVariation_564.cv_arg
    cv_name = "RAB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_564

    @classmethod
    def create(cls, arg : "NonSpare_1543.cv_arg") -> "NonSpare_1543":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_564:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_575:
        return self.rule.variation

class Item_770(Item):
    cv_arg: TypeAlias = NonSpare_1543.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1543

    @classmethod
    def create(cls, arg : "Item_770.cv_arg") -> "Item_770":
        return cls._create(arg) # type: ignore

class NonSpare_1199(NonSpare):
    cv_arg: TypeAlias = RuleVariation_673.cv_arg
    cv_name = "LOP"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_673

    @classmethod
    def create(cls, arg : "NonSpare_1199.cv_arg") -> "NonSpare_1199":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_673:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_684:
        return self.rule.variation

class Item_506(Item):
    cv_arg: TypeAlias = NonSpare_1199.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1199

    @classmethod
    def create(cls, arg : "Item_506.cv_arg") -> "Item_506":
        return cls._create(arg) # type: ignore

class NonSpare_1895(NonSpare):
    cv_arg: TypeAlias = RuleVariation_860.cv_arg
    cv_name = "TOT"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_860

    @classmethod
    def create(cls, arg : "NonSpare_1895.cv_arg") -> "NonSpare_1895":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_860:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_890:
        return self.rule.variation

class Item_1015(Item):
    cv_arg: TypeAlias = NonSpare_1895.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1895

    @classmethod
    def create(cls, arg : "Item_1015.cv_arg") -> "Item_1015":
        return cls._create(arg) # type: ignore

class NonSpare_1743(NonSpare):
    cv_arg: TypeAlias = RuleVariation_3.cv_arg
    cv_name = "SPI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_3

    @classmethod
    def create(cls, arg : "NonSpare_1743.cv_arg") -> "NonSpare_1743":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_3:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_3:
        return self.rule.variation

class Item_913(Item):
    cv_arg: TypeAlias = NonSpare_1743.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1743

    @classmethod
    def create(cls, arg : "Item_913.cv_arg") -> "Item_913":
        return cls._create(arg) # type: ignore

class Variation_1401(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_131.cv_arg, Tuple[Literal["TYP"], RuleVariation_131.cv_arg]], Union[RuleVariation_642.cv_arg, Tuple[Literal["DCR"], RuleVariation_642.cv_arg]], Union[RuleVariation_694.cv_arg, Tuple[Literal["CHN"], RuleVariation_694.cv_arg]], Union[RuleVariation_848.cv_arg, Tuple[Literal["GBS"], RuleVariation_848.cv_arg]], Union[RuleVariation_913.cv_arg, Tuple[Literal["CRT"], RuleVariation_913.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_5.cv_arg, Tuple[Literal["SIM"], RuleVariation_5.cv_arg]], Union[RuleVariation_408.cv_arg, Tuple[Literal["TST"], RuleVariation_408.cv_arg]], Union[RuleVariation_564.cv_arg, Tuple[Literal["RAB"], RuleVariation_564.cv_arg]], Union[RuleVariation_673.cv_arg, Tuple[Literal["LOP"], RuleVariation_673.cv_arg]], Union[RuleVariation_860.cv_arg, Tuple[Literal["TOT"], RuleVariation_860.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_3.cv_arg, Tuple[Literal["SPI"], RuleVariation_3.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1401.cv_arg_group_1"],
        Tuple["Variation_1401.cv_arg_group_1", "Variation_1401.cv_arg_group_2"],
        Tuple["Variation_1401.cv_arg_group_1", "Variation_1401.cv_arg_group_2", "Variation_1401.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_1078, 3), (Item_255, 1), (Item_158, 1), (Item_369, 1), (Item_218, 1), None], [(Item_902, 1), (Item_1056, 1), (Item_770, 1), (Item_506, 2), (Item_1015, 2), None], [(Item_913, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1401.cv_arg") -> 'Variation_1401':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["TYP"]) -> RuleVariation_131:
        ...
    @overload
    def get_item(self, key : Literal["DCR"]) -> RuleVariation_642:
        ...
    @overload
    def get_item(self, key : Literal["CHN"]) -> RuleVariation_694:
        ...
    @overload
    def get_item(self, key : Literal["GBS"]) -> RuleVariation_848:
        ...
    @overload
    def get_item(self, key : Literal["CRT"]) -> RuleVariation_913:
        ...
    @overload
    def get_item(self, key : Literal["SIM"]) -> Optional[RuleVariation_5]:
        ...
    @overload
    def get_item(self, key : Literal["TST"]) -> Optional[RuleVariation_408]:
        ...
    @overload
    def get_item(self, key : Literal["RAB"]) -> Optional[RuleVariation_564]:
        ...
    @overload
    def get_item(self, key : Literal["LOP"]) -> Optional[RuleVariation_673]:
        ...
    @overload
    def get_item(self, key : Literal["TOT"]) -> Optional[RuleVariation_860]:
        ...
    @overload
    def get_item(self, key : Literal["SPI"]) -> Optional[RuleVariation_3]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1322(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1401.cv_arg
    cv_variation: TypeAlias = Variation_1401

    @classmethod
    def create(cls, arg : "RuleVariation_1322.cv_arg") -> "RuleVariation_1322":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1401:
        return self.arg # type: ignore

class NonSpare_91(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1322.cv_arg
    cv_name = "020"
    cv_title = "Target Report Descriptor"
    cv_rule: TypeAlias = RuleVariation_1322

    @classmethod
    def create(cls, arg : "NonSpare_91.cv_arg") -> "NonSpare_91":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1322:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1401:
        return self.rule.variation

class UapItem_91(UapItem):
    cv_non_spare: TypeAlias = NonSpare_91

class NonSpare_332(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "140"
    cv_title = "Time of Day"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_332.cv_arg") -> "NonSpare_332":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_332(UapItem):
    cv_non_spare: TypeAlias = NonSpare_332

class Content_706(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 8.381903171539307e-8
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_706(RuleContentContextFree):
    cv_arg: TypeAlias = Content_706.cv_arg
    cv_content: TypeAlias = Content_706

    @property
    def content(self) -> Content_706:
        return self._get_content() # type: ignore

class Variation_383(Element):
    cv_arg: TypeAlias = RuleContent_706.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_706

    @classmethod
    def create(cls, arg: "Variation_383.cv_arg") -> "Variation_383":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_706:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_706:
        return self.rule.content

class RuleVariation_376(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_383.cv_arg
    cv_variation: TypeAlias = Variation_383

    @classmethod
    def create(cls, arg : "RuleVariation_376.cv_arg") -> "RuleVariation_376":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_383:
        return self.arg # type: ignore

class NonSpare_1159(NonSpare):
    cv_arg: TypeAlias = RuleVariation_376.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude"
    cv_rule: TypeAlias = RuleVariation_376

    @classmethod
    def create(cls, arg : "NonSpare_1159.cv_arg") -> "NonSpare_1159":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_376:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_383:
        return self.rule.variation

class Item_468(Item):
    cv_arg: TypeAlias = NonSpare_1159.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1159

    @classmethod
    def create(cls, arg : "Item_468.cv_arg") -> "Item_468":
        return cls._create(arg) # type: ignore

class Content_704(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 8.381903171539307e-8
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_704(RuleContentContextFree):
    cv_arg: TypeAlias = Content_704.cv_arg
    cv_content: TypeAlias = Content_704

    @property
    def content(self) -> Content_704:
        return self._get_content() # type: ignore

class Variation_381(Element):
    cv_arg: TypeAlias = RuleContent_704.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_704

    @classmethod
    def create(cls, arg: "Variation_381.cv_arg") -> "Variation_381":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_704:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_704:
        return self.rule.content

class RuleVariation_374(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_381.cv_arg
    cv_variation: TypeAlias = Variation_381

    @classmethod
    def create(cls, arg : "RuleVariation_374.cv_arg") -> "RuleVariation_374":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_381:
        return self.arg # type: ignore

class NonSpare_1189(NonSpare):
    cv_arg: TypeAlias = RuleVariation_374.cv_arg
    cv_name = "LON"
    cv_title = "Longitude"
    cv_rule: TypeAlias = RuleVariation_374

    @classmethod
    def create(cls, arg : "NonSpare_1189.cv_arg") -> "NonSpare_1189":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_374:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_381:
        return self.rule.variation

class Item_496(Item):
    cv_arg: TypeAlias = NonSpare_1189.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1189

    @classmethod
    def create(cls, arg : "Item_496.cv_arg") -> "Item_496":
        return cls._create(arg) # type: ignore

class Variation_1135(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_376.cv_arg, Tuple[Literal["LAT"], RuleVariation_376.cv_arg]], Union[RuleVariation_374.cv_arg, Tuple[Literal["LON"], RuleVariation_374.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1135.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_468, 32), (Item_496, 32)]
    cv_items_dict = {"LAT": RuleVariation_376, "LON": RuleVariation_374}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> Type[RuleVariation_376]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> Type[RuleVariation_374]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_376:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_374:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1135.cv_arg") -> 'Variation_1135':
        return cls._create(arg) # type: ignore

class RuleVariation_1091(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1135.cv_arg
    cv_variation: TypeAlias = Variation_1135

    @classmethod
    def create(cls, arg : "RuleVariation_1091.cv_arg") -> "RuleVariation_1091":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1135:
        return self.arg # type: ignore

class NonSpare_155(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1091.cv_arg
    cv_name = "041"
    cv_title = "Position in WGS-84 Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1091

    @classmethod
    def create(cls, arg : "NonSpare_155.cv_arg") -> "NonSpare_155":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1091:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1135:
        return self.rule.variation

class UapItem_155(UapItem):
    cv_non_spare: TypeAlias = NonSpare_155

class Content_721(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_721(RuleContentContextFree):
    cv_arg: TypeAlias = Content_721.cv_arg
    cv_content: TypeAlias = Content_721

    @property
    def content(self) -> Content_721:
        return self._get_content() # type: ignore

class Variation_305(Element):
    cv_arg: TypeAlias = RuleContent_721.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_721

    @classmethod
    def create(cls, arg: "Variation_305.cv_arg") -> "Variation_305":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_721:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_721:
        return self.rule.content

class RuleVariation_298(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_305.cv_arg
    cv_variation: TypeAlias = Variation_305

    @classmethod
    def create(cls, arg : "RuleVariation_298.cv_arg") -> "RuleVariation_298":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_305:
        return self.arg # type: ignore

class NonSpare_1598(NonSpare):
    cv_arg: TypeAlias = RuleVariation_298.cv_arg
    cv_name = "RHO"
    cv_title = "RHO"
    cv_rule: TypeAlias = RuleVariation_298

    @classmethod
    def create(cls, arg : "NonSpare_1598.cv_arg") -> "NonSpare_1598":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_298:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_305:
        return self.rule.variation

class Item_820(Item):
    cv_arg: TypeAlias = NonSpare_1598.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1598

    @classmethod
    def create(cls, arg : "Item_820.cv_arg") -> "Item_820":
        return cls._create(arg) # type: ignore

class NonSpare_1861(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TH"
    cv_title = "Theta"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1861.cv_arg") -> "NonSpare_1861":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_996(Item):
    cv_arg: TypeAlias = NonSpare_1861.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1861

    @classmethod
    def create(cls, arg : "Item_996.cv_arg") -> "Item_996":
        return cls._create(arg) # type: ignore

class Variation_1187(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_298.cv_arg, Tuple[Literal["RHO"], RuleVariation_298.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TH"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1187.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_820, 16), (Item_996, 16)]
    cv_items_dict = {"RHO": RuleVariation_298, "TH": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["RHO"]) -> Type[RuleVariation_298]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TH"]) -> Type[RuleVariation_336]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["RHO"], Literal["TH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["RHO"]) -> RuleVariation_298:
        ...
    @overload
    def get_item(self, key : Literal["TH"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1187.cv_arg") -> 'Variation_1187':
        return cls._create(arg) # type: ignore

class RuleVariation_1138(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1187.cv_arg
    cv_variation: TypeAlias = Variation_1187

    @classmethod
    def create(cls, arg : "RuleVariation_1138.cv_arg") -> "RuleVariation_1138":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1187:
        return self.arg # type: ignore

class NonSpare_140(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1138.cv_arg
    cv_name = "040"
    cv_title = "Measured Position in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1138

    @classmethod
    def create(cls, arg : "NonSpare_140.cv_arg") -> "NonSpare_140":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1138:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1187:
        return self.rule.variation

class UapItem_140(UapItem):
    cv_non_spare: TypeAlias = NonSpare_140

class Content_628(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_628(RuleContentContextFree):
    cv_arg: TypeAlias = Content_628.cv_arg
    cv_content: TypeAlias = Content_628

    @property
    def content(self) -> Content_628:
        return self._get_content() # type: ignore

class Variation_259(Element):
    cv_arg: TypeAlias = RuleContent_628.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_628

    @classmethod
    def create(cls, arg: "Variation_259.cv_arg") -> "Variation_259":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_628:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_628:
        return self.rule.content

class RuleVariation_252(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_259.cv_arg
    cv_variation: TypeAlias = Variation_259

    @classmethod
    def create(cls, arg : "RuleVariation_252.cv_arg") -> "RuleVariation_252":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_259:
        return self.arg # type: ignore

class NonSpare_2106(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "X"
    cv_title = "X Coordinate"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2106.cv_arg") -> "NonSpare_2106":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1203(Item):
    cv_arg: TypeAlias = NonSpare_2106.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2106

    @classmethod
    def create(cls, arg : "Item_1203.cv_arg") -> "Item_1203":
        return cls._create(arg) # type: ignore

class NonSpare_2160(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "Y"
    cv_title = "Y Coordinate"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2160.cv_arg") -> "NonSpare_2160":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1254(Item):
    cv_arg: TypeAlias = NonSpare_2160.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2160

    @classmethod
    def create(cls, arg : "Item_1254.cv_arg") -> "Item_1254":
        return cls._create(arg) # type: ignore

class Variation_1316(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_252.cv_arg, Tuple[Literal["X"], RuleVariation_252.cv_arg]], Union[RuleVariation_252.cv_arg, Tuple[Literal["Y"], RuleVariation_252.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1316.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1203, 16), (Item_1254, 16)]
    cv_items_dict = {"X": RuleVariation_252, "Y": RuleVariation_252}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> Type[RuleVariation_252]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> Type[RuleVariation_252]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_252:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_252:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1316.cv_arg") -> 'Variation_1316':
        return cls._create(arg) # type: ignore

class RuleVariation_1244(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1316.cv_arg
    cv_variation: TypeAlias = Variation_1316

    @classmethod
    def create(cls, arg : "RuleVariation_1244.cv_arg") -> "RuleVariation_1244":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1316:
        return self.arg # type: ignore

class NonSpare_161(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1244.cv_arg
    cv_name = "042"
    cv_title = "Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1244

    @classmethod
    def create(cls, arg : "NonSpare_161.cv_arg") -> "NonSpare_161":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1244:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1316:
        return self.rule.variation

class UapItem_161(UapItem):
    cv_non_spare: TypeAlias = NonSpare_161

class Content_781(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["NM/s"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 6.103515625e-5
    cv_unit = "NM/s"

    def as_quantity(self, cv_unit : Optional[Literal["NM/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_780(RuleContentContextFree):
    cv_arg: TypeAlias = Content_781.cv_arg
    cv_content: TypeAlias = Content_781

    @property
    def content(self) -> Content_781:
        return self._get_content() # type: ignore

class Variation_339(Element):
    cv_arg: TypeAlias = RuleContent_780.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_780

    @classmethod
    def create(cls, arg: "Variation_339.cv_arg") -> "Variation_339":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_780:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_781:
        return self.rule.content

class RuleVariation_332(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_339.cv_arg
    cv_variation: TypeAlias = Variation_339

    @classmethod
    def create(cls, arg : "RuleVariation_332.cv_arg") -> "RuleVariation_332":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_339:
        return self.arg # type: ignore

class NonSpare_1047(NonSpare):
    cv_arg: TypeAlias = RuleVariation_332.cv_arg
    cv_name = "GSP"
    cv_title = "Ground Speed"
    cv_rule: TypeAlias = RuleVariation_332

    @classmethod
    def create(cls, arg : "NonSpare_1047.cv_arg") -> "NonSpare_1047":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_332:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_339:
        return self.rule.variation

class Item_378(Item):
    cv_arg: TypeAlias = NonSpare_1047.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1047

    @classmethod
    def create(cls, arg : "Item_378.cv_arg") -> "Item_378":
        return cls._create(arg) # type: ignore

class NonSpare_1908(NonSpare):
    cv_arg: TypeAlias = RuleVariation_336.cv_arg
    cv_name = "TRA"
    cv_title = "Track Angle"
    cv_rule: TypeAlias = RuleVariation_336

    @classmethod
    def create(cls, arg : "NonSpare_1908.cv_arg") -> "NonSpare_1908":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_336:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_343:
        return self.rule.variation

class Item_1028(Item):
    cv_arg: TypeAlias = NonSpare_1908.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1908

    @classmethod
    def create(cls, arg : "Item_1028.cv_arg") -> "Item_1028":
        return cls._create(arg) # type: ignore

class Variation_1120(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_332.cv_arg, Tuple[Literal["GSP"], RuleVariation_332.cv_arg]], Union[RuleVariation_336.cv_arg, Tuple[Literal["TRA"], RuleVariation_336.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1120.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_378, 16), (Item_1028, 16)]
    cv_items_dict = {"GSP": RuleVariation_332, "TRA": RuleVariation_336}

    @overload
    @classmethod
    def spec(cls, key : Literal["GSP"]) -> Type[RuleVariation_332]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TRA"]) -> Type[RuleVariation_336]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["GSP"], Literal["TRA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["GSP"]) -> RuleVariation_332:
        ...
    @overload
    def get_item(self, key : Literal["TRA"]) -> RuleVariation_336:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1120.cv_arg") -> 'Variation_1120':
        return cls._create(arg) # type: ignore

class RuleVariation_1078(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1120.cv_arg
    cv_variation: TypeAlias = Variation_1120

    @classmethod
    def create(cls, arg : "RuleVariation_1078.cv_arg") -> "RuleVariation_1078":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1120:
        return self.arg # type: ignore

class NonSpare_392(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1078.cv_arg
    cv_name = "200"
    cv_title = "Calculated Track Velocity in Polar Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1078

    @classmethod
    def create(cls, arg : "NonSpare_392.cv_arg") -> "NonSpare_392":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1078:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1120:
        return self.rule.variation

class UapItem_392(UapItem):
    cv_non_spare: TypeAlias = NonSpare_392

class Content_670(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25e-2
    cv_unit = "m/s"

    def as_quantity(self, cv_unit : Optional[Literal["m/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_670(RuleContentContextFree):
    cv_arg: TypeAlias = Content_670.cv_arg
    cv_content: TypeAlias = Content_670

    @property
    def content(self) -> Content_670:
        return self._get_content() # type: ignore

class Variation_282(Element):
    cv_arg: TypeAlias = RuleContent_670.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_670

    @classmethod
    def create(cls, arg: "Variation_282.cv_arg") -> "Variation_282":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_670:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_670:
        return self.rule.content

class RuleVariation_275(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_282.cv_arg
    cv_variation: TypeAlias = Variation_282

    @classmethod
    def create(cls, arg : "RuleVariation_275.cv_arg") -> "RuleVariation_275":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_282:
        return self.arg # type: ignore

class NonSpare_2063(NonSpare):
    cv_arg: TypeAlias = RuleVariation_275.cv_arg
    cv_name = "VX"
    cv_title = "X Velocity"
    cv_rule: TypeAlias = RuleVariation_275

    @classmethod
    def create(cls, arg : "NonSpare_2063.cv_arg") -> "NonSpare_2063":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_275:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_282:
        return self.rule.variation

class Item_1165(Item):
    cv_arg: TypeAlias = NonSpare_2063.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2063

    @classmethod
    def create(cls, arg : "Item_1165.cv_arg") -> "Item_1165":
        return cls._create(arg) # type: ignore

class NonSpare_2068(NonSpare):
    cv_arg: TypeAlias = RuleVariation_275.cv_arg
    cv_name = "VY"
    cv_title = "Y Velocity"
    cv_rule: TypeAlias = RuleVariation_275

    @classmethod
    def create(cls, arg : "NonSpare_2068.cv_arg") -> "NonSpare_2068":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_275:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_282:
        return self.rule.variation

class Item_1170(Item):
    cv_arg: TypeAlias = NonSpare_2068.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2068

    @classmethod
    def create(cls, arg : "Item_1170.cv_arg") -> "Item_1170":
        return cls._create(arg) # type: ignore

class Variation_1290(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_275.cv_arg, Tuple[Literal["VX"], RuleVariation_275.cv_arg]], Union[RuleVariation_275.cv_arg, Tuple[Literal["VY"], RuleVariation_275.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1290.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1165, 16), (Item_1170, 16)]
    cv_items_dict = {"VX": RuleVariation_275, "VY": RuleVariation_275}

    @overload
    @classmethod
    def spec(cls, key : Literal["VX"]) -> Type[RuleVariation_275]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VY"]) -> Type[RuleVariation_275]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VX"], Literal["VY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VX"]) -> RuleVariation_275:
        ...
    @overload
    def get_item(self, key : Literal["VY"]) -> RuleVariation_275:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1290.cv_arg") -> 'Variation_1290':
        return cls._create(arg) # type: ignore

class RuleVariation_1219(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1290.cv_arg
    cv_variation: TypeAlias = Variation_1290

    @classmethod
    def create(cls, arg : "RuleVariation_1219.cv_arg") -> "RuleVariation_1219":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1290:
        return self.arg # type: ignore

class NonSpare_405(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1219.cv_arg
    cv_name = "202"
    cv_title = "Calculated Track Velocity in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1219

    @classmethod
    def create(cls, arg : "NonSpare_405.cv_arg") -> "NonSpare_405":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1219:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1290:
        return self.rule.variation

class UapItem_405(UapItem):
    cv_non_spare: TypeAlias = NonSpare_405

class NonSpare_1926(NonSpare):
    cv_arg: TypeAlias = RuleVariation_781.cv_arg
    cv_name = "TRK"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_781

    @classmethod
    def create(cls, arg : "NonSpare_1926.cv_arg") -> "NonSpare_1926":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_781:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_811:
        return self.rule.variation

class Item_1042(Item):
    cv_arg: TypeAlias = NonSpare_1926.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1926

    @classmethod
    def create(cls, arg : "Item_1042.cv_arg") -> "Item_1042":
        return cls._create(arg) # type: ignore

class Variation_1038(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_781.cv_arg, Tuple[Literal["TRK"], RuleVariation_781.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1038.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_1042, 12)]
    cv_items_dict = {"TRK": RuleVariation_781}

    @classmethod
    def spec(cls, key : Literal["TRK"]) -> Type[RuleVariation_781]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["TRK"]) -> RuleVariation_781:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1038.cv_arg") -> 'Variation_1038':
        return cls._create(arg) # type: ignore

class RuleVariation_1006(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1038.cv_arg
    cv_variation: TypeAlias = Variation_1038

    @classmethod
    def create(cls, arg : "RuleVariation_1006.cv_arg") -> "RuleVariation_1006":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1038:
        return self.arg # type: ignore

class NonSpare_363(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1006.cv_arg
    cv_name = "161"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_1006

    @classmethod
    def create(cls, arg : "NonSpare_363.cv_arg") -> "NonSpare_363":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1006:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1038:
        return self.rule.variation

class UapItem_363(UapItem):
    cv_non_spare: TypeAlias = NonSpare_363

class Content_64(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed track", 1: "Track in initialisation phase"}

class RuleContent_64(RuleContentContextFree):
    cv_arg: TypeAlias = Content_64.cv_arg
    cv_content: TypeAlias = Content_64

    @property
    def content(self) -> Content_64:
        return self._get_content() # type: ignore

class Variation_18(Element):
    cv_arg: TypeAlias = RuleContent_64.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_64

    @classmethod
    def create(cls, arg: "Variation_18.cv_arg") -> "Variation_18":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_64:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_64:
        return self.rule.content

class RuleVariation_18(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_18.cv_arg
    cv_variation: TypeAlias = Variation_18

    @classmethod
    def create(cls, arg : "RuleVariation_18.cv_arg") -> "RuleVariation_18":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_18:
        return self.arg # type: ignore

class Variation_411(Element):
    cv_arg: TypeAlias = RuleContent_113.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_113

    @classmethod
    def create(cls, arg: "Variation_411.cv_arg") -> "Variation_411":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_113:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_113:
        return self.rule.content

class RuleVariation_400(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_411.cv_arg
    cv_variation: TypeAlias = Variation_411

    @classmethod
    def create(cls, arg : "RuleVariation_400.cv_arg") -> "RuleVariation_400":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_411:
        return self.arg # type: ignore

class Content_362(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No extrapolation", 1: "Predictable extrapolation due to sensor refresh period (see NOTE)", 2: "Predictable extrapolation in masked area", 3: "Extrapolation due to unpredictable absence of detection"}

class RuleContent_362(RuleContentContextFree):
    cv_arg: TypeAlias = Content_362.cv_arg
    cv_content: TypeAlias = Content_362

    @property
    def content(self) -> Content_362:
        return self._get_content() # type: ignore

class Variation_595(Element):
    cv_arg: TypeAlias = RuleContent_362.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 2
    cv_rule = RuleContent_362

    @classmethod
    def create(cls, arg: "Variation_595.cv_arg") -> "Variation_595":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_362:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_362:
        return self.rule.content

class RuleVariation_584(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_595.cv_arg
    cv_variation: TypeAlias = Variation_595

    @classmethod
    def create(cls, arg : "RuleVariation_584.cv_arg") -> "RuleVariation_584":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_595:
        return self.arg # type: ignore

class Content_106(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "Horizontal manoeuvre"}

class RuleContent_106(RuleContentContextFree):
    cv_arg: TypeAlias = Content_106.cv_arg
    cv_content: TypeAlias = Content_106

    @property
    def content(self) -> Content_106:
        return self._get_content() # type: ignore

class Variation_708(Element):
    cv_arg: TypeAlias = RuleContent_106.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_106

    @classmethod
    def create(cls, arg: "Variation_708.cv_arg") -> "Variation_708":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_106:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_106:
        return self.rule.content

class RuleVariation_697(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_708.cv_arg
    cv_variation: TypeAlias = Variation_708

    @classmethod
    def create(cls, arg : "RuleVariation_697.cv_arg") -> "RuleVariation_697":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_708:
        return self.arg # type: ignore

class Content_516(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Tracking performed in 'Sensor Plane', i.e. neither slant range correction nor projection was applied", 1: "Slant range correction and a suitable projection technique are used to track in a 2D.reference plane, tangential to the earth model at the Sensor Site co-ordinates"}

class RuleContent_516(RuleContentContextFree):
    cv_arg: TypeAlias = Content_516.cv_arg
    cv_content: TypeAlias = Content_516

    @property
    def content(self) -> Content_516:
        return self._get_content() # type: ignore

class Variation_877(Element):
    cv_arg: TypeAlias = RuleContent_516.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_516

    @classmethod
    def create(cls, arg: "Variation_877.cv_arg") -> "Variation_877":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_516:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_516:
        return self.rule.content

class RuleVariation_847(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_877.cv_arg
    cv_variation: TypeAlias = Variation_877

    @classmethod
    def create(cls, arg : "RuleVariation_847.cv_arg") -> "RuleVariation_847":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_877:
        return self.arg # type: ignore

class Content_269(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Measured position", 1: "Smoothed position"}

class RuleContent_269(RuleContentContextFree):
    cv_arg: TypeAlias = Content_269.cv_arg
    cv_content: TypeAlias = Content_269

    @property
    def content(self) -> Content_269:
        return self._get_content() # type: ignore

class Variation_940(Element):
    cv_arg: TypeAlias = RuleContent_269.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_269

    @classmethod
    def create(cls, arg: "Variation_940.cv_arg") -> "Variation_940":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_269:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_269:
        return self.rule.content

class RuleVariation_910(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_940.cv_arg
    cv_variation: TypeAlias = Variation_940

    @classmethod
    def create(cls, arg : "RuleVariation_910.cv_arg") -> "RuleVariation_910":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_940:
        return self.arg # type: ignore

class Content_555(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown type of movement", 1: "Taking-off", 2: "Landing", 3: "Other types of movement"}

class RuleContent_555(RuleContentContextFree):
    cv_arg: TypeAlias = Content_555.cv_arg
    cv_content: TypeAlias = Content_555

    @property
    def content(self) -> Content_555:
        return self._get_content() # type: ignore

class Variation_117(Element):
    cv_arg: TypeAlias = RuleContent_555.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_555

    @classmethod
    def create(cls, arg: "Variation_117.cv_arg") -> "Variation_117":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_555:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_555:
        return self.rule.content

class RuleVariation_117(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_117.cv_arg
    cv_variation: TypeAlias = Variation_117

    @classmethod
    def create(cls, arg : "RuleVariation_117.cv_arg") -> "RuleVariation_117":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_117:
        return self.arg # type: ignore

class Content_354(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No doubt", 1: "Doubtful correlation (undetermined reason)", 2: "Doubtful correlation in clutter", 3: "Loss of accuracy", 4: "Loss of accuracy in clutter", 5: "Unstable track", 6: "Previously coasted"}

class RuleContent_354(RuleContentContextFree):
    cv_arg: TypeAlias = Content_354.cv_arg
    cv_content: TypeAlias = Content_354

    @property
    def content(self) -> Content_354:
        return self._get_content() # type: ignore

class Variation_601(Element):
    cv_arg: TypeAlias = RuleContent_354.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 3
    cv_rule = RuleContent_354

    @classmethod
    def create(cls, arg: "Variation_601.cv_arg") -> "Variation_601":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_354:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_354:
        return self.rule.content

class RuleVariation_590(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_601.cv_arg
    cv_variation: TypeAlias = Variation_601

    @classmethod
    def create(cls, arg : "RuleVariation_590.cv_arg") -> "RuleVariation_590":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_601:
        return self.arg # type: ignore

class Content_270(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Merge or split indication undetermined", 1: "Track merged by association to plot", 2: "Track merged by non-association to plot", 3: "Split track"}

class RuleContent_270(RuleContentContextFree):
    cv_arg: TypeAlias = Content_270.cv_arg
    cv_content: TypeAlias = Content_270

    @property
    def content(self) -> Content_270:
        return self._get_content() # type: ignore

class Variation_882(Element):
    cv_arg: TypeAlias = RuleContent_270.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 2
    cv_rule = RuleContent_270

    @classmethod
    def create(cls, arg: "Variation_882.cv_arg") -> "Variation_882":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_270:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_270:
        return self.rule.content

class RuleVariation_852(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_882.cv_arg
    cv_variation: TypeAlias = Variation_882

    @classmethod
    def create(cls, arg : "RuleVariation_852.cv_arg") -> "RuleVariation_852":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_882:
        return self.arg # type: ignore

class Variation_28(Element):
    cv_arg: TypeAlias = RuleContent_100.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_100

    @classmethod
    def create(cls, arg: "Variation_28.cv_arg") -> "Variation_28":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_100:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_100:
        return self.rule.content

class RuleVariation_28(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_28.cv_arg
    cv_variation: TypeAlias = Variation_28

    @classmethod
    def create(cls, arg : "RuleVariation_28.cv_arg") -> "RuleVariation_28":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_28:
        return self.arg # type: ignore

class NonSpare_751(NonSpare):
    cv_arg: TypeAlias = RuleVariation_18.cv_arg
    cv_name = "CNF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_18

    @classmethod
    def create(cls, arg : "NonSpare_751.cv_arg") -> "NonSpare_751":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_18:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_18:
        return self.rule.variation

class Item_166(Item):
    cv_arg: TypeAlias = NonSpare_751.cv_arg
    cv_non_spare: TypeAlias = NonSpare_751

    @classmethod
    def create(cls, arg : "Item_166.cv_arg") -> "Item_166":
        return cls._create(arg) # type: ignore

class NonSpare_1922(NonSpare):
    cv_arg: TypeAlias = RuleVariation_400.cv_arg
    cv_name = "TRE"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_400

    @classmethod
    def create(cls, arg : "NonSpare_1922.cv_arg") -> "NonSpare_1922":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_400:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_411:
        return self.rule.variation

class Item_1040(Item):
    cv_arg: TypeAlias = NonSpare_1922.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1922

    @classmethod
    def create(cls, arg : "Item_1040.cv_arg") -> "Item_1040":
        return cls._create(arg) # type: ignore

class NonSpare_846(NonSpare):
    cv_arg: TypeAlias = RuleVariation_584.cv_arg
    cv_name = "CST"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_584

    @classmethod
    def create(cls, arg : "NonSpare_846.cv_arg") -> "NonSpare_846":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_584:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_595:
        return self.rule.variation

class Item_226(Item):
    cv_arg: TypeAlias = NonSpare_846.cv_arg
    cv_non_spare: TypeAlias = NonSpare_846

    @classmethod
    def create(cls, arg : "Item_226.cv_arg") -> "Item_226":
        return cls._create(arg) # type: ignore

class NonSpare_1229(NonSpare):
    cv_arg: TypeAlias = RuleVariation_697.cv_arg
    cv_name = "MAH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_697

    @classmethod
    def create(cls, arg : "NonSpare_1229.cv_arg") -> "NonSpare_1229":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_697:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_708:
        return self.rule.variation

class Item_526(Item):
    cv_arg: TypeAlias = NonSpare_1229.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1229

    @classmethod
    def create(cls, arg : "Item_526.cv_arg") -> "Item_526":
        return cls._create(arg) # type: ignore

class NonSpare_1847(NonSpare):
    cv_arg: TypeAlias = RuleVariation_847.cv_arg
    cv_name = "TCC"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_847

    @classmethod
    def create(cls, arg : "NonSpare_1847.cv_arg") -> "NonSpare_1847":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_847:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_877:
        return self.rule.variation

class Item_983(Item):
    cv_arg: TypeAlias = NonSpare_1847.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1847

    @classmethod
    def create(cls, arg : "Item_983.cv_arg") -> "Item_983":
        return cls._create(arg) # type: ignore

class NonSpare_1796(NonSpare):
    cv_arg: TypeAlias = RuleVariation_910.cv_arg
    cv_name = "STH"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_910

    @classmethod
    def create(cls, arg : "NonSpare_1796.cv_arg") -> "NonSpare_1796":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_910:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_940:
        return self.rule.variation

class Item_953(Item):
    cv_arg: TypeAlias = NonSpare_1796.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1796

    @classmethod
    def create(cls, arg : "Item_953.cv_arg") -> "Item_953":
        return cls._create(arg) # type: ignore

class NonSpare_1891(NonSpare):
    cv_arg: TypeAlias = RuleVariation_117.cv_arg
    cv_name = "TOM"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_117

    @classmethod
    def create(cls, arg : "NonSpare_1891.cv_arg") -> "NonSpare_1891":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_117:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_117:
        return self.rule.variation

class Item_1013(Item):
    cv_arg: TypeAlias = NonSpare_1891.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1891

    @classmethod
    def create(cls, arg : "Item_1013.cv_arg") -> "Item_1013":
        return cls._create(arg) # type: ignore

class NonSpare_898(NonSpare):
    cv_arg: TypeAlias = RuleVariation_590.cv_arg
    cv_name = "DOU"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_590

    @classmethod
    def create(cls, arg : "NonSpare_898.cv_arg") -> "NonSpare_898":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_590:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_601:
        return self.rule.variation

class Item_270(Item):
    cv_arg: TypeAlias = NonSpare_898.cv_arg
    cv_non_spare: TypeAlias = NonSpare_898

    @classmethod
    def create(cls, arg : "Item_270.cv_arg") -> "Item_270":
        return cls._create(arg) # type: ignore

class NonSpare_1322(NonSpare):
    cv_arg: TypeAlias = RuleVariation_852.cv_arg
    cv_name = "MRS"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_852

    @classmethod
    def create(cls, arg : "NonSpare_1322.cv_arg") -> "NonSpare_1322":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_852:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_882:
        return self.rule.variation

class Item_585(Item):
    cv_arg: TypeAlias = NonSpare_1322.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1322

    @classmethod
    def create(cls, arg : "Item_585.cv_arg") -> "Item_585":
        return cls._create(arg) # type: ignore

class NonSpare_1040(NonSpare):
    cv_arg: TypeAlias = RuleVariation_28.cv_arg
    cv_name = "GHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_28

    @classmethod
    def create(cls, arg : "NonSpare_1040.cv_arg") -> "NonSpare_1040":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_28:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_28:
        return self.rule.variation

class Item_372(Item):
    cv_arg: TypeAlias = NonSpare_1040.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1040

    @classmethod
    def create(cls, arg : "Item_372.cv_arg") -> "Item_372":
        return cls._create(arg) # type: ignore

class Variation_1360(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_18.cv_arg, Tuple[Literal["CNF"], RuleVariation_18.cv_arg]], Union[RuleVariation_400.cv_arg, Tuple[Literal["TRE"], RuleVariation_400.cv_arg]], Union[RuleVariation_584.cv_arg, Tuple[Literal["CST"], RuleVariation_584.cv_arg]], Union[RuleVariation_697.cv_arg, Tuple[Literal["MAH"], RuleVariation_697.cv_arg]], Union[RuleVariation_847.cv_arg, Tuple[Literal["TCC"], RuleVariation_847.cv_arg]], Union[RuleVariation_910.cv_arg, Tuple[Literal["STH"], RuleVariation_910.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_117.cv_arg, Tuple[Literal["TOM"], RuleVariation_117.cv_arg]], Union[RuleVariation_590.cv_arg, Tuple[Literal["DOU"], RuleVariation_590.cv_arg]], Union[RuleVariation_852.cv_arg, Tuple[Literal["MRS"], RuleVariation_852.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_28.cv_arg, Tuple[Literal["GHO"], RuleVariation_28.cv_arg]], int, None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1360.cv_arg_group_1"],
        Tuple["Variation_1360.cv_arg_group_1", "Variation_1360.cv_arg_group_2"],
        Tuple["Variation_1360.cv_arg_group_1", "Variation_1360.cv_arg_group_2", "Variation_1360.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_166, 1), (Item_1040, 1), (Item_226, 2), (Item_526, 1), (Item_983, 1), (Item_953, 1), None], [(Item_1013, 2), (Item_270, 3), (Item_585, 2), None], [(Item_372, 1), (Item_9, 6), None]]

    @classmethod
    def create(cls, arg: "Variation_1360.cv_arg") -> 'Variation_1360':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["CNF"]) -> RuleVariation_18:
        ...
    @overload
    def get_item(self, key : Literal["TRE"]) -> RuleVariation_400:
        ...
    @overload
    def get_item(self, key : Literal["CST"]) -> RuleVariation_584:
        ...
    @overload
    def get_item(self, key : Literal["MAH"]) -> RuleVariation_697:
        ...
    @overload
    def get_item(self, key : Literal["TCC"]) -> RuleVariation_847:
        ...
    @overload
    def get_item(self, key : Literal["STH"]) -> RuleVariation_910:
        ...
    @overload
    def get_item(self, key : Literal["TOM"]) -> Optional[RuleVariation_117]:
        ...
    @overload
    def get_item(self, key : Literal["DOU"]) -> Optional[RuleVariation_590]:
        ...
    @overload
    def get_item(self, key : Literal["MRS"]) -> Optional[RuleVariation_852]:
        ...
    @overload
    def get_item(self, key : Literal["GHO"]) -> Optional[RuleVariation_28]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1281(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1360.cv_arg
    cv_variation: TypeAlias = Variation_1360

    @classmethod
    def create(cls, arg : "RuleVariation_1281.cv_arg") -> "RuleVariation_1281":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1360:
        return self.arg # type: ignore

class NonSpare_375(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1281.cv_arg
    cv_name = "170"
    cv_title = "Track Status"
    cv_rule: TypeAlias = RuleVariation_1281

    @classmethod
    def create(cls, arg : "NonSpare_375.cv_arg") -> "NonSpare_375":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1281:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1360:
        return self.rule.variation

class UapItem_375(UapItem):
    cv_non_spare: TypeAlias = NonSpare_375

class NonSpare_1999(NonSpare):
    cv_arg: TypeAlias = RuleVariation_15.cv_arg
    cv_name = "V"
    cv_title = "Validated"
    cv_rule: TypeAlias = RuleVariation_15

    @classmethod
    def create(cls, arg : "NonSpare_1999.cv_arg") -> "NonSpare_1999":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_15:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_15:
        return self.rule.variation

class Item_1107(Item):
    cv_arg: TypeAlias = NonSpare_1999.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1999

    @classmethod
    def create(cls, arg : "Item_1107.cv_arg") -> "Item_1107":
        return cls._create(arg) # type: ignore

class NonSpare_1016(NonSpare):
    cv_arg: TypeAlias = RuleVariation_396.cv_arg
    cv_name = "G"
    cv_title = "Garbled"
    cv_rule: TypeAlias = RuleVariation_396

    @classmethod
    def create(cls, arg : "NonSpare_1016.cv_arg") -> "NonSpare_1016":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_396:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_407:
        return self.rule.variation

class Item_359(Item):
    cv_arg: TypeAlias = NonSpare_1016.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1016

    @classmethod
    def create(cls, arg : "Item_359.cv_arg") -> "Item_359":
        return cls._create(arg) # type: ignore

class Content_291(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode-3/A code derived from the reply of the transponder", 1: "Mode-3/A code not extracted during the last scan"}

class RuleContent_291(RuleContentContextFree):
    cv_arg: TypeAlias = Content_291.cv_arg
    cv_content: TypeAlias = Content_291

    @property
    def content(self) -> Content_291:
        return self._get_content() # type: ignore

class Variation_554(Element):
    cv_arg: TypeAlias = RuleContent_291.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_291

    @classmethod
    def create(cls, arg: "Variation_554.cv_arg") -> "Variation_554":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_291:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_291:
        return self.rule.content

class RuleVariation_543(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_554.cv_arg
    cv_variation: TypeAlias = Variation_554

    @classmethod
    def create(cls, arg : "RuleVariation_543.cv_arg") -> "RuleVariation_543":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_554:
        return self.arg # type: ignore

class NonSpare_1146(NonSpare):
    cv_arg: TypeAlias = RuleVariation_543.cv_arg
    cv_name = "L"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_543

    @classmethod
    def create(cls, arg : "NonSpare_1146.cv_arg") -> "NonSpare_1146":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_543:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_554:
        return self.rule.variation

class Item_455(Item):
    cv_arg: TypeAlias = NonSpare_1146.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1146

    @classmethod
    def create(cls, arg : "Item_455.cv_arg") -> "Item_455":
        return cls._create(arg) # type: ignore

class Variation_1282(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_543.cv_arg, Tuple[Literal["L"], RuleVariation_543.cv_arg]], int, Union[RuleVariation_782.cv_arg, Tuple[Literal["MODE3A"], RuleVariation_782.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1282.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1107, 1), (Item_359, 1), (Item_455, 1), (Item_16, 1), (Item_577, 12)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "L": RuleVariation_543, "MODE3A": RuleVariation_782}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> Type[RuleVariation_15]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> Type[RuleVariation_396]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["L"]) -> Type[RuleVariation_543]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MODE3A"]) -> Type[RuleVariation_782]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["L"], Literal["MODE3A"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["L"]) -> RuleVariation_543:
        ...
    @overload
    def get_item(self, key : Literal["MODE3A"]) -> RuleVariation_782:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1282.cv_arg") -> 'Variation_1282':
        return cls._create(arg) # type: ignore

class RuleVariation_1211(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1282.cv_arg
    cv_variation: TypeAlias = Variation_1282

    @classmethod
    def create(cls, arg : "RuleVariation_1211.cv_arg") -> "RuleVariation_1211":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1282:
        return self.arg # type: ignore

class NonSpare_192(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1211.cv_arg
    cv_name = "060"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_1211

    @classmethod
    def create(cls, arg : "NonSpare_192.cv_arg") -> "NonSpare_192":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1211:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1282:
        return self.rule.variation

class UapItem_192(UapItem):
    cv_non_spare: TypeAlias = NonSpare_192

class Variation_349(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_349.cv_arg") -> "Variation_349":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_342(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_349.cv_arg
    cv_variation: TypeAlias = Variation_349

    @classmethod
    def create(cls, arg : "RuleVariation_342.cv_arg") -> "RuleVariation_342":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_349:
        return self.arg # type: ignore

class NonSpare_427(NonSpare):
    cv_arg: TypeAlias = RuleVariation_342.cv_arg
    cv_name = "220"
    cv_title = "Target Address"
    cv_rule: TypeAlias = RuleVariation_342

    @classmethod
    def create(cls, arg : "NonSpare_427.cv_arg") -> "NonSpare_427":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_342:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_349:
        return self.rule.variation

class UapItem_427(UapItem):
    cv_non_spare: TypeAlias = NonSpare_427

class Content_52(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Callsign or registration downlinked from transponder", 1: "Callsign not downlinked from transponder", 2: "Registration not downlinked from transponder"}

class RuleContent_52(RuleContentContextFree):
    cv_arg: TypeAlias = Content_52.cv_arg
    cv_content: TypeAlias = Content_52

    @property
    def content(self) -> Content_52:
        return self._get_content() # type: ignore

class Variation_98(Element):
    cv_arg: TypeAlias = RuleContent_52.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_52

    @classmethod
    def create(cls, arg: "Variation_98.cv_arg") -> "Variation_98":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_52:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_52:
        return self.rule.content

class RuleVariation_98(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_98.cv_arg
    cv_variation: TypeAlias = Variation_98

    @classmethod
    def create(cls, arg : "RuleVariation_98.cv_arg") -> "RuleVariation_98":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_98:
        return self.arg # type: ignore

class NonSpare_1798(NonSpare):
    cv_arg: TypeAlias = RuleVariation_98.cv_arg
    cv_name = "STI"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_98

    @classmethod
    def create(cls, arg : "NonSpare_1798.cv_arg") -> "NonSpare_1798":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_98:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_98:
        return self.rule.variation

class Item_955(Item):
    cv_arg: TypeAlias = NonSpare_1798.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1798

    @classmethod
    def create(cls, arg : "Item_955.cv_arg") -> "Item_955":
        return cls._create(arg) # type: ignore

class Item_15(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 2
    cv_bit_size = 6

class NonSpare_740(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "CHR"
    cv_title = "Characters 1-8 (Coded on 6 Bits Each) Defining Target Identification"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_740.cv_arg") -> "NonSpare_740":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Item_159(Item):
    cv_arg: TypeAlias = NonSpare_740.cv_arg
    cv_non_spare: TypeAlias = NonSpare_740

    @classmethod
    def create(cls, arg : "Item_159.cv_arg") -> "Item_159":
        return cls._create(arg) # type: ignore

class Variation_1222(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_98.cv_arg, Tuple[Literal["STI"], RuleVariation_98.cv_arg]], int, Union[RuleVariation_383.cv_arg, Tuple[Literal["CHR"], RuleVariation_383.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1222.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_items_list = [(Item_955, 2), (Item_15, 6), (Item_159, 48)]
    cv_items_dict = {"STI": RuleVariation_98, "CHR": RuleVariation_383}

    @overload
    @classmethod
    def spec(cls, key : Literal["STI"]) -> Type[RuleVariation_98]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["CHR"]) -> Type[RuleVariation_383]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STI"], Literal["CHR"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STI"]) -> RuleVariation_98:
        ...
    @overload
    def get_item(self, key : Literal["CHR"]) -> RuleVariation_383:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1222.cv_arg") -> 'Variation_1222':
        return cls._create(arg) # type: ignore

class RuleVariation_1166(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1222.cv_arg
    cv_variation: TypeAlias = Variation_1222

    @classmethod
    def create(cls, arg : "RuleVariation_1166.cv_arg") -> "RuleVariation_1166":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1222:
        return self.arg # type: ignore

class NonSpare_443(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1166.cv_arg
    cv_name = "245"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_1166

    @classmethod
    def create(cls, arg : "NonSpare_443.cv_arg") -> "NonSpare_443":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1166:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1222:
        return self.rule.variation

class UapItem_443(UapItem):
    cv_non_spare: TypeAlias = NonSpare_443

class Variation_392(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_392.cv_arg") -> "Variation_392":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_384(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_392.cv_arg
    cv_variation: TypeAlias = Variation_392

    @classmethod
    def create(cls, arg : "RuleVariation_384.cv_arg") -> "RuleVariation_384":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_392:
        return self.arg # type: ignore

class NonSpare_1240(NonSpare):
    cv_arg: TypeAlias = RuleVariation_384.cv_arg
    cv_name = "MBDATA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_384

    @classmethod
    def create(cls, arg : "NonSpare_1240.cv_arg") -> "NonSpare_1240":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_384:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_392:
        return self.rule.variation

class Item_533(Item):
    cv_arg: TypeAlias = NonSpare_1240.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1240

    @classmethod
    def create(cls, arg : "Item_533.cv_arg") -> "Item_533":
        return cls._create(arg) # type: ignore

class NonSpare_677(NonSpare):
    cv_arg: TypeAlias = RuleVariation_132.cv_arg
    cv_name = "BDS1"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_132

    @classmethod
    def create(cls, arg : "NonSpare_677.cv_arg") -> "NonSpare_677":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_132:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_132:
        return self.rule.variation

class Item_115(Item):
    cv_arg: TypeAlias = NonSpare_677.cv_arg
    cv_non_spare: TypeAlias = NonSpare_677

    @classmethod
    def create(cls, arg : "Item_115.cv_arg") -> "Item_115":
        return cls._create(arg) # type: ignore

class Variation_802(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 4
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_802.cv_arg") -> "Variation_802":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_772(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_802.cv_arg
    cv_variation: TypeAlias = Variation_802

    @classmethod
    def create(cls, arg : "RuleVariation_772.cv_arg") -> "RuleVariation_772":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_802:
        return self.arg # type: ignore

class NonSpare_679(NonSpare):
    cv_arg: TypeAlias = RuleVariation_772.cv_arg
    cv_name = "BDS2"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_772

    @classmethod
    def create(cls, arg : "NonSpare_679.cv_arg") -> "NonSpare_679":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_772:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_802:
        return self.rule.variation

class Item_117(Item):
    cv_arg: TypeAlias = NonSpare_679.cv_arg
    cv_non_spare: TypeAlias = NonSpare_679

    @classmethod
    def create(cls, arg : "Item_117.cv_arg") -> "Item_117":
        return cls._create(arg) # type: ignore

class Variation_1147(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_384.cv_arg, Tuple[Literal["MBDATA"], RuleVariation_384.cv_arg]], Union[RuleVariation_132.cv_arg, Tuple[Literal["BDS1"], RuleVariation_132.cv_arg]], Union[RuleVariation_772.cv_arg, Tuple[Literal["BDS2"], RuleVariation_772.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1147.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_533, 56), (Item_115, 4), (Item_117, 4)]
    cv_items_dict = {"MBDATA": RuleVariation_384, "BDS1": RuleVariation_132, "BDS2": RuleVariation_772}

    @overload
    @classmethod
    def spec(cls, key : Literal["MBDATA"]) -> Type[RuleVariation_384]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["BDS1"]) -> Type[RuleVariation_132]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["BDS2"]) -> Type[RuleVariation_772]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["MBDATA"], Literal["BDS1"], Literal["BDS2"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["MBDATA"]) -> RuleVariation_384:
        ...
    @overload
    def get_item(self, key : Literal["BDS1"]) -> RuleVariation_132:
        ...
    @overload
    def get_item(self, key : Literal["BDS2"]) -> RuleVariation_772:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1147.cv_arg") -> 'Variation_1147':
        return cls._create(arg) # type: ignore

class Variation_1430(Repetitive):
    cv_arg: TypeAlias = List[Variation_1147.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1147

    @classmethod
    def create(cls, arg: "Variation_1430.cv_arg") -> 'Variation_1430':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1147]:
        return self._get_list() # type: ignore

class RuleVariation_1351(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1430.cv_arg
    cv_variation: TypeAlias = Variation_1430

    @classmethod
    def create(cls, arg : "RuleVariation_1351.cv_arg") -> "RuleVariation_1351":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1430:
        return self.arg # type: ignore

class NonSpare_450(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1351.cv_arg
    cv_name = "250"
    cv_title = "Mode S MB Data"
    cv_rule: TypeAlias = RuleVariation_1351

    @classmethod
    def create(cls, arg : "NonSpare_450.cv_arg") -> "NonSpare_450":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1351:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1430:
        return self.rule.variation

class UapItem_450(UapItem):
    cv_non_spare: TypeAlias = NonSpare_450

class Content_538(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Unknown", 1: "ATC equipment maintenance", 2: "Airport maintenance", 3: "Fire", 4: "Bird scarer", 5: "Snow plough", 6: "Runway sweeper", 7: "Emergency", 8: "Police", 9: "Bus", 10: "Tug (push/tow)", 11: "Grass cutter", 12: "Fuel", 13: "Baggage", 14: "Catering", 15: "Aircraft maintenance", 16: "Flyco (follow me)"}

class RuleContent_538(RuleContentContextFree):
    cv_arg: TypeAlias = Content_538.cv_arg
    cv_content: TypeAlias = Content_538

    @property
    def content(self) -> Content_538:
        return self._get_content() # type: ignore

class Variation_177(Element):
    cv_arg: TypeAlias = RuleContent_538.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_538

    @classmethod
    def create(cls, arg: "Variation_177.cv_arg") -> "Variation_177":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_538:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_538:
        return self.rule.content

class RuleVariation_170(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_177.cv_arg
    cv_variation: TypeAlias = Variation_177

    @classmethod
    def create(cls, arg : "RuleVariation_170.cv_arg") -> "RuleVariation_170":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_177:
        return self.arg # type: ignore

class NonSpare_479(NonSpare):
    cv_arg: TypeAlias = RuleVariation_170.cv_arg
    cv_name = "300"
    cv_title = "Vehicle Fleet Identification"
    cv_rule: TypeAlias = RuleVariation_170

    @classmethod
    def create(cls, arg : "NonSpare_479.cv_arg") -> "NonSpare_479":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_170:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_177:
        return self.rule.variation

class UapItem_479(UapItem):
    cv_non_spare: TypeAlias = NonSpare_479

class NonSpare_979(NonSpare):
    cv_arg: TypeAlias = RuleVariation_599.cv_arg
    cv_name = "FL"
    cv_title = "Flight Level"
    cv_rule: TypeAlias = RuleVariation_599

    @classmethod
    def create(cls, arg : "NonSpare_979.cv_arg") -> "NonSpare_979":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_599:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_610:
        return self.rule.variation

class Item_333(Item):
    cv_arg: TypeAlias = NonSpare_979.cv_arg
    cv_non_spare: TypeAlias = NonSpare_979

    @classmethod
    def create(cls, arg : "Item_333.cv_arg") -> "Item_333":
        return cls._create(arg) # type: ignore

class Variation_1278(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_15.cv_arg, Tuple[Literal["V"], RuleVariation_15.cv_arg]], Union[RuleVariation_396.cv_arg, Tuple[Literal["G"], RuleVariation_396.cv_arg]], Union[RuleVariation_599.cv_arg, Tuple[Literal["FL"], RuleVariation_599.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1278.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_1107, 1), (Item_359, 1), (Item_333, 14)]
    cv_items_dict = {"V": RuleVariation_15, "G": RuleVariation_396, "FL": RuleVariation_599}

    @overload
    @classmethod
    def spec(cls, key : Literal["V"]) -> Type[RuleVariation_15]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["G"]) -> Type[RuleVariation_396]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["FL"]) -> Type[RuleVariation_599]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["V"], Literal["G"], Literal["FL"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["V"]) -> RuleVariation_15:
        ...
    @overload
    def get_item(self, key : Literal["G"]) -> RuleVariation_396:
        ...
    @overload
    def get_item(self, key : Literal["FL"]) -> RuleVariation_599:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1278.cv_arg") -> 'Variation_1278':
        return cls._create(arg) # type: ignore

class RuleVariation_1207(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1278.cv_arg
    cv_variation: TypeAlias = Variation_1278

    @classmethod
    def create(cls, arg : "RuleVariation_1207.cv_arg") -> "RuleVariation_1207":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1278:
        return self.arg # type: ignore

class NonSpare_251(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1207.cv_arg
    cv_name = "090"
    cv_title = "Flight Level in Binary Representation"
    cv_rule: TypeAlias = RuleVariation_1207

    @classmethod
    def create(cls, arg : "NonSpare_251.cv_arg") -> "NonSpare_251":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1207:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1278:
        return self.rule.variation

class UapItem_251(UapItem):
    cv_non_spare: TypeAlias = NonSpare_251

class Content_686(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["ft"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25
    cv_unit = "ft"

    def as_quantity(self, cv_unit : Optional[Literal["ft"]] = None) -> float:
        return self._as_quantity()

class RuleContent_686(RuleContentContextFree):
    cv_arg: TypeAlias = Content_686.cv_arg
    cv_content: TypeAlias = Content_686

    @property
    def content(self) -> Content_686:
        return self._get_content() # type: ignore

class Variation_290(Element):
    cv_arg: TypeAlias = RuleContent_686.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_686

    @classmethod
    def create(cls, arg: "Variation_290.cv_arg") -> "Variation_290":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_686:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_686:
        return self.rule.content

class RuleVariation_283(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_290.cv_arg
    cv_variation: TypeAlias = Variation_290

    @classmethod
    def create(cls, arg : "RuleVariation_283.cv_arg") -> "RuleVariation_283":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_290:
        return self.arg # type: ignore

class NonSpare_261(NonSpare):
    cv_arg: TypeAlias = RuleVariation_283.cv_arg
    cv_name = "091"
    cv_title = "Measured Height"
    cv_rule: TypeAlias = RuleVariation_283

    @classmethod
    def create(cls, arg : "NonSpare_261.cv_arg") -> "NonSpare_261":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_283:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_290:
        return self.rule.variation

class UapItem_261(UapItem):
    cv_non_spare: TypeAlias = NonSpare_261

class Content_720(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_720(RuleContentContextFree):
    cv_arg: TypeAlias = Content_720.cv_arg
    cv_content: TypeAlias = Content_720

    @property
    def content(self) -> Content_720:
        return self._get_content() # type: ignore

class Variation_161(Element):
    cv_arg: TypeAlias = RuleContent_720.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_720

    @classmethod
    def create(cls, arg: "Variation_161.cv_arg") -> "Variation_161":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_720:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_720:
        return self.rule.content

class RuleVariation_155(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_161.cv_arg
    cv_variation: TypeAlias = Variation_161

    @classmethod
    def create(cls, arg : "RuleVariation_155.cv_arg") -> "RuleVariation_155":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_161:
        return self.arg # type: ignore

class Content_790(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 2.8125
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_789(RuleContentContextFree):
    cv_arg: TypeAlias = Content_790.cv_arg
    cv_content: TypeAlias = Content_790

    @property
    def content(self) -> Content_790:
        return self._get_content() # type: ignore

class Variation_164(Element):
    cv_arg: TypeAlias = RuleContent_789.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 7
    cv_rule = RuleContent_789

    @classmethod
    def create(cls, arg: "Variation_164.cv_arg") -> "Variation_164":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_789:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_790:
        return self.rule.content

class RuleVariation_158(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_164.cv_arg
    cv_variation: TypeAlias = Variation_164

    @classmethod
    def create(cls, arg : "RuleVariation_158.cv_arg") -> "RuleVariation_158":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_164:
        return self.arg # type: ignore

class NonSpare_1173(NonSpare):
    cv_arg: TypeAlias = RuleVariation_155.cv_arg
    cv_name = "LENGTH"
    cv_title = "Length"
    cv_rule: TypeAlias = RuleVariation_155

    @classmethod
    def create(cls, arg : "NonSpare_1173.cv_arg") -> "NonSpare_1173":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_155:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_161:
        return self.rule.variation

class Item_480(Item):
    cv_arg: TypeAlias = NonSpare_1173.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1173

    @classmethod
    def create(cls, arg : "Item_480.cv_arg") -> "Item_480":
        return cls._create(arg) # type: ignore

class NonSpare_1409(NonSpare):
    cv_arg: TypeAlias = RuleVariation_158.cv_arg
    cv_name = "ORIENTATION"
    cv_title = "Orientation"
    cv_rule: TypeAlias = RuleVariation_158

    @classmethod
    def create(cls, arg : "NonSpare_1409.cv_arg") -> "NonSpare_1409":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_158:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_164:
        return self.rule.variation

class Item_665(Item):
    cv_arg: TypeAlias = NonSpare_1409.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1409

    @classmethod
    def create(cls, arg : "Item_665.cv_arg") -> "Item_665":
        return cls._create(arg) # type: ignore

class NonSpare_2073(NonSpare):
    cv_arg: TypeAlias = RuleVariation_155.cv_arg
    cv_name = "WIDTH"
    cv_title = "Width"
    cv_rule: TypeAlias = RuleVariation_155

    @classmethod
    def create(cls, arg : "NonSpare_2073.cv_arg") -> "NonSpare_2073":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_155:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_161:
        return self.rule.variation

class Item_1173(Item):
    cv_arg: TypeAlias = NonSpare_2073.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2073

    @classmethod
    def create(cls, arg : "Item_1173.cv_arg") -> "Item_1173":
        return cls._create(arg) # type: ignore

class Variation_1372(Extended):
    cv_arg_group_1: TypeAlias = Union[int, Tuple[Union[RuleVariation_155.cv_arg, Tuple[Literal["LENGTH"], RuleVariation_155.cv_arg]], None]]
    cv_arg_group_2: TypeAlias = Union[int, Tuple[Union[RuleVariation_158.cv_arg, Tuple[Literal["ORIENTATION"], RuleVariation_158.cv_arg]], None]]
    cv_arg_group_3: TypeAlias = Union[int, Tuple[Union[RuleVariation_155.cv_arg, Tuple[Literal["WIDTH"], RuleVariation_155.cv_arg]], None]]
    cv_arg: TypeAlias = Union[
        Tuple["Variation_1372.cv_arg_group_1"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2"],
        Tuple["Variation_1372.cv_arg_group_1", "Variation_1372.cv_arg_group_2", "Variation_1372.cv_arg_group_3"],
    ]
    cv_items_list = [[(Item_480, 7), None], [(Item_665, 7), None], [(Item_1173, 7), None]]

    @classmethod
    def create(cls, arg: "Variation_1372.cv_arg") -> 'Variation_1372':
        return cls._create(arg) # type: ignore

    @overload
    def get_item(self, key : Literal["LENGTH"]) -> RuleVariation_155:
        ...
    @overload
    def get_item(self, key : Literal["ORIENTATION"]) -> Optional[RuleVariation_158]:
        ...
    @overload
    def get_item(self, key : Literal["WIDTH"]) -> Optional[RuleVariation_155]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

class RuleVariation_1293(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1372.cv_arg
    cv_variation: TypeAlias = Variation_1372

    @classmethod
    def create(cls, arg : "RuleVariation_1293.cv_arg") -> "RuleVariation_1293":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1372:
        return self.arg # type: ignore

class NonSpare_463(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1293.cv_arg
    cv_name = "270"
    cv_title = "Target Size and Orientation"
    cv_rule: TypeAlias = RuleVariation_1293

    @classmethod
    def create(cls, arg : "NonSpare_463.cv_arg") -> "NonSpare_463":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1293:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1372:
        return self.rule.variation

class UapItem_463(UapItem):
    cv_non_spare: TypeAlias = NonSpare_463

class Content_412(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Operational", 1: "Degraded", 2: "NOGO"}

class RuleContent_412(RuleContentContextFree):
    cv_arg: TypeAlias = Content_412.cv_arg
    cv_content: TypeAlias = Content_412

    @property
    def content(self) -> Content_412:
        return self._get_content() # type: ignore

class Variation_108(Element):
    cv_arg: TypeAlias = RuleContent_412.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 2
    cv_rule = RuleContent_412

    @classmethod
    def create(cls, arg: "Variation_108.cv_arg") -> "Variation_108":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_412:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_412:
        return self.rule.content

class RuleVariation_108(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_108.cv_arg
    cv_variation: TypeAlias = Variation_108

    @classmethod
    def create(cls, arg : "RuleVariation_108.cv_arg") -> "RuleVariation_108":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_108:
        return self.arg # type: ignore

class NonSpare_1375(NonSpare):
    cv_arg: TypeAlias = RuleVariation_108.cv_arg
    cv_name = "NOGO"
    cv_title = "Operational Release Status of the System"
    cv_rule: TypeAlias = RuleVariation_108

    @classmethod
    def create(cls, arg : "NonSpare_1375.cv_arg") -> "NonSpare_1375":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_108:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_108:
        return self.rule.variation

class Item_632(Item):
    cv_arg: TypeAlias = NonSpare_1375.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1375

    @classmethod
    def create(cls, arg : "Item_632.cv_arg") -> "Item_632":
        return cls._create(arg) # type: ignore

class Content_370(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No overload", 1: "Overload"}

class RuleContent_370(RuleContentContextFree):
    cv_arg: TypeAlias = Content_370.cv_arg
    cv_content: TypeAlias = Content_370

    @property
    def content(self) -> Content_370:
        return self._get_content() # type: ignore

class Variation_565(Element):
    cv_arg: TypeAlias = RuleContent_370.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_370

    @classmethod
    def create(cls, arg: "Variation_565.cv_arg") -> "Variation_565":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_370:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_370:
        return self.rule.content

class RuleVariation_554(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_565.cv_arg
    cv_variation: TypeAlias = Variation_565

    @classmethod
    def create(cls, arg : "RuleVariation_554.cv_arg") -> "RuleVariation_554":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_565:
        return self.arg # type: ignore

class NonSpare_1416(NonSpare):
    cv_arg: TypeAlias = RuleVariation_554.cv_arg
    cv_name = "OVL"
    cv_title = "Overload Indicator"
    cv_rule: TypeAlias = RuleVariation_554

    @classmethod
    def create(cls, arg : "NonSpare_1416.cv_arg") -> "NonSpare_1416":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_554:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_565:
        return self.rule.variation

class Item_671(Item):
    cv_arg: TypeAlias = NonSpare_1416.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1416

    @classmethod
    def create(cls, arg : "Item_671.cv_arg") -> "Item_671":
        return cls._create(arg) # type: ignore

class Content_560(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Valid", 1: "Invalid"}

class RuleContent_560(RuleContentContextFree):
    cv_arg: TypeAlias = Content_560.cv_arg
    cv_content: TypeAlias = Content_560

    @property
    def content(self) -> Content_560:
        return self._get_content() # type: ignore

class Variation_674(Element):
    cv_arg: TypeAlias = RuleContent_560.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_560

    @classmethod
    def create(cls, arg: "Variation_674.cv_arg") -> "Variation_674":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_560:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_560:
        return self.rule.content

class RuleVariation_663(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_674.cv_arg
    cv_variation: TypeAlias = Variation_674

    @classmethod
    def create(cls, arg : "RuleVariation_663.cv_arg") -> "RuleVariation_663":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_674:
        return self.arg # type: ignore

class NonSpare_1948(NonSpare):
    cv_arg: TypeAlias = RuleVariation_663.cv_arg
    cv_name = "TSV"
    cv_title = "Time Source Validity"
    cv_rule: TypeAlias = RuleVariation_663

    @classmethod
    def create(cls, arg : "NonSpare_1948.cv_arg") -> "NonSpare_1948":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_663:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_674:
        return self.rule.variation

class Item_1062(Item):
    cv_arg: TypeAlias = NonSpare_1948.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1948

    @classmethod
    def create(cls, arg : "Item_1062.cv_arg") -> "Item_1062":
        return cls._create(arg) # type: ignore

class Content_383(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Normal Operation", 1: "Diversity degraded"}

class RuleContent_383(RuleContentContextFree):
    cv_arg: TypeAlias = Content_383.cv_arg
    cv_content: TypeAlias = Content_383

    @property
    def content(self) -> Content_383:
        return self._get_content() # type: ignore

class Variation_744(Element):
    cv_arg: TypeAlias = RuleContent_383.cv_arg
    cv_bit_offset8 = 4
    cv_bit_size = 1
    cv_rule = RuleContent_383

    @classmethod
    def create(cls, arg: "Variation_744.cv_arg") -> "Variation_744":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_383:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_383:
        return self.rule.content

class RuleVariation_733(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_744.cv_arg
    cv_variation: TypeAlias = Variation_744

    @classmethod
    def create(cls, arg : "RuleVariation_733.cv_arg") -> "RuleVariation_733":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_744:
        return self.arg # type: ignore

class NonSpare_890(NonSpare):
    cv_arg: TypeAlias = RuleVariation_733.cv_arg
    cv_name = "DIV"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_733

    @classmethod
    def create(cls, arg : "NonSpare_890.cv_arg") -> "NonSpare_890":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_733:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_744:
        return self.rule.variation

class Item_264(Item):
    cv_arg: TypeAlias = NonSpare_890.cv_arg
    cv_non_spare: TypeAlias = NonSpare_890

    @classmethod
    def create(cls, arg : "Item_264.cv_arg") -> "Item_264":
        return cls._create(arg) # type: ignore

class Content_488(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Test Target Operative", 1: "Test Target Failure"}

class RuleContent_488(RuleContentContextFree):
    cv_arg: TypeAlias = Content_488.cv_arg
    cv_content: TypeAlias = Content_488

    @property
    def content(self) -> Content_488:
        return self._get_content() # type: ignore

class Variation_875(Element):
    cv_arg: TypeAlias = RuleContent_488.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_488

    @classmethod
    def create(cls, arg: "Variation_875.cv_arg") -> "Variation_875":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_488:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_488:
        return self.rule.content

class RuleVariation_845(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_875.cv_arg
    cv_variation: TypeAlias = Variation_875

    @classmethod
    def create(cls, arg : "RuleVariation_845.cv_arg") -> "RuleVariation_845":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_875:
        return self.arg # type: ignore

class NonSpare_1955(NonSpare):
    cv_arg: TypeAlias = RuleVariation_845.cv_arg
    cv_name = "TTF"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_845

    @classmethod
    def create(cls, arg : "NonSpare_1955.cv_arg") -> "NonSpare_1955":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_845:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_875:
        return self.rule.variation

class Item_1067(Item):
    cv_arg: TypeAlias = NonSpare_1955.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1955

    @classmethod
    def create(cls, arg : "Item_1067.cv_arg") -> "Item_1067":
        return cls._create(arg) # type: ignore

class Variation_1159(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_108.cv_arg, Tuple[Literal["NOGO"], RuleVariation_108.cv_arg]], Union[RuleVariation_554.cv_arg, Tuple[Literal["OVL"], RuleVariation_554.cv_arg]], Union[RuleVariation_663.cv_arg, Tuple[Literal["TSV"], RuleVariation_663.cv_arg]], Union[RuleVariation_733.cv_arg, Tuple[Literal["DIV"], RuleVariation_733.cv_arg]], Union[RuleVariation_845.cv_arg, Tuple[Literal["TTF"], RuleVariation_845.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1159.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_632, 2), (Item_671, 1), (Item_1062, 1), (Item_264, 1), (Item_1067, 1), (Item_27, 2)]
    cv_items_dict = {"NOGO": RuleVariation_108, "OVL": RuleVariation_554, "TSV": RuleVariation_663, "DIV": RuleVariation_733, "TTF": RuleVariation_845}

    @overload
    @classmethod
    def spec(cls, key : Literal["NOGO"]) -> Type[RuleVariation_108]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["OVL"]) -> Type[RuleVariation_554]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TSV"]) -> Type[RuleVariation_663]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DIV"]) -> Type[RuleVariation_733]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TTF"]) -> Type[RuleVariation_845]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["NOGO"], Literal["OVL"], Literal["TSV"], Literal["DIV"], Literal["TTF"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["NOGO"]) -> RuleVariation_108:
        ...
    @overload
    def get_item(self, key : Literal["OVL"]) -> RuleVariation_554:
        ...
    @overload
    def get_item(self, key : Literal["TSV"]) -> RuleVariation_663:
        ...
    @overload
    def get_item(self, key : Literal["DIV"]) -> RuleVariation_733:
        ...
    @overload
    def get_item(self, key : Literal["TTF"]) -> RuleVariation_845:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1159.cv_arg") -> 'Variation_1159':
        return cls._create(arg) # type: ignore

class RuleVariation_1112(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1159.cv_arg
    cv_variation: TypeAlias = Variation_1159

    @classmethod
    def create(cls, arg : "RuleVariation_1112.cv_arg") -> "RuleVariation_1112":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1159:
        return self.arg # type: ignore

class NonSpare_525(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1112.cv_arg
    cv_name = "550"
    cv_title = "System Status"
    cv_rule: TypeAlias = RuleVariation_1112

    @classmethod
    def create(cls, arg : "NonSpare_525.cv_arg") -> "NonSpare_525":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1112:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1159:
        return self.rule.variation

class UapItem_524(UapItem):
    cv_non_spare: TypeAlias = NonSpare_525

class Content_110(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default", 1: "In Trouble"}

class RuleContent_110(RuleContentContextFree):
    cv_arg: TypeAlias = Content_110.cv_arg
    cv_content: TypeAlias = Content_110

    @property
    def content(self) -> Content_110:
        return self._get_content() # type: ignore

class Variation_30(Element):
    cv_arg: TypeAlias = RuleContent_110.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_110

    @classmethod
    def create(cls, arg: "Variation_30.cv_arg") -> "Variation_30":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_110:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_110:
        return self.rule.content

class RuleVariation_30(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_30.cv_arg
    cv_variation: TypeAlias = Variation_30

    @classmethod
    def create(cls, arg : "RuleVariation_30.cv_arg") -> "RuleVariation_30":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_30:
        return self.arg # type: ignore

class NonSpare_1915(NonSpare):
    cv_arg: TypeAlias = RuleVariation_30.cv_arg
    cv_name = "TRB"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_30

    @classmethod
    def create(cls, arg : "NonSpare_1915.cv_arg") -> "NonSpare_1915":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_30:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_30:
        return self.rule.variation

class Item_1035(Item):
    cv_arg: TypeAlias = NonSpare_1915.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1915

    @classmethod
    def create(cls, arg : "Item_1035.cv_arg") -> "Item_1035":
        return cls._create(arg) # type: ignore

class Content_603(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Towing aircraft", 2: "“Follow me” operation", 3: "Runway check", 4: "Emergency operation (fire, medical...)", 5: "Work in progress (maintenance, birds scarer, sweepers...)"}

class RuleContent_603(RuleContentContextFree):
    cv_arg: TypeAlias = Content_603.cv_arg
    cv_content: TypeAlias = Content_603

    @property
    def content(self) -> Content_603:
        return self._get_content() # type: ignore

class Variation_497(Element):
    cv_arg: TypeAlias = RuleContent_603.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 7
    cv_rule = RuleContent_603

    @classmethod
    def create(cls, arg: "Variation_497.cv_arg") -> "Variation_497":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_603:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_603:
        return self.rule.content

class RuleVariation_486(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_497.cv_arg
    cv_variation: TypeAlias = Variation_497

    @classmethod
    def create(cls, arg : "RuleVariation_486.cv_arg") -> "RuleVariation_486":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_497:
        return self.arg # type: ignore

class NonSpare_1335(NonSpare):
    cv_arg: TypeAlias = RuleVariation_486.cv_arg
    cv_name = "MSG"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_486

    @classmethod
    def create(cls, arg : "NonSpare_1335.cv_arg") -> "NonSpare_1335":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_486:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_497:
        return self.rule.variation

class Item_596(Item):
    cv_arg: TypeAlias = NonSpare_1335.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1335

    @classmethod
    def create(cls, arg : "Item_596.cv_arg") -> "Item_596":
        return cls._create(arg) # type: ignore

class Variation_1238(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_30.cv_arg, Tuple[Literal["TRB"], RuleVariation_30.cv_arg]], Union[RuleVariation_486.cv_arg, Tuple[Literal["MSG"], RuleVariation_486.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1238.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1035, 1), (Item_596, 7)]
    cv_items_dict = {"TRB": RuleVariation_30, "MSG": RuleVariation_486}

    @overload
    @classmethod
    def spec(cls, key : Literal["TRB"]) -> Type[RuleVariation_30]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MSG"]) -> Type[RuleVariation_486]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["TRB"], Literal["MSG"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["TRB"]) -> RuleVariation_30:
        ...
    @overload
    def get_item(self, key : Literal["MSG"]) -> RuleVariation_486:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1238.cv_arg") -> 'Variation_1238':
        return cls._create(arg) # type: ignore

class RuleVariation_1176(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1238.cv_arg
    cv_variation: TypeAlias = Variation_1238

    @classmethod
    def create(cls, arg : "RuleVariation_1176.cv_arg") -> "RuleVariation_1176":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1238:
        return self.arg # type: ignore

class NonSpare_481(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1176.cv_arg
    cv_name = "310"
    cv_title = "Pre-programmed Message"
    cv_rule: TypeAlias = RuleVariation_1176

    @classmethod
    def create(cls, arg : "NonSpare_481.cv_arg") -> "NonSpare_481":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1176:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1238:
        return self.rule.variation

class UapItem_481(UapItem):
    cv_non_spare: TypeAlias = NonSpare_481

class Content_756(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Unsigned
    cv_lsb = 0.25
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_755(RuleContentContextFree):
    cv_arg: TypeAlias = Content_756.cv_arg
    cv_content: TypeAlias = Content_756

    @property
    def content(self) -> Content_756:
        return self._get_content() # type: ignore

class Variation_232(Element):
    cv_arg: TypeAlias = RuleContent_755.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_755

    @classmethod
    def create(cls, arg: "Variation_232.cv_arg") -> "Variation_232":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_755:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_756:
        return self.rule.content

class RuleVariation_225(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_232.cv_arg
    cv_variation: TypeAlias = Variation_232

    @classmethod
    def create(cls, arg : "RuleVariation_225.cv_arg") -> "RuleVariation_225":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_232:
        return self.arg # type: ignore

class NonSpare_885(NonSpare):
    cv_arg: TypeAlias = RuleVariation_225.cv_arg
    cv_name = "DEVX"
    cv_title = "Standard Deviation of X Component"
    cv_rule: TypeAlias = RuleVariation_225

    @classmethod
    def create(cls, arg : "NonSpare_885.cv_arg") -> "NonSpare_885":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_225:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_232:
        return self.rule.variation

class Item_259(Item):
    cv_arg: TypeAlias = NonSpare_885.cv_arg
    cv_non_spare: TypeAlias = NonSpare_885

    @classmethod
    def create(cls, arg : "Item_259.cv_arg") -> "Item_259":
        return cls._create(arg) # type: ignore

class NonSpare_886(NonSpare):
    cv_arg: TypeAlias = RuleVariation_225.cv_arg
    cv_name = "DEVY"
    cv_title = "Standard Deviation of Y Component"
    cv_rule: TypeAlias = RuleVariation_225

    @classmethod
    def create(cls, arg : "NonSpare_886.cv_arg") -> "NonSpare_886":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_225:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_232:
        return self.rule.variation

class Item_260(Item):
    cv_arg: TypeAlias = NonSpare_886.cv_arg
    cv_non_spare: TypeAlias = NonSpare_886

    @classmethod
    def create(cls, arg : "Item_260.cv_arg") -> "Item_260":
        return cls._create(arg) # type: ignore

class Content_659(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_659(RuleContentContextFree):
    cv_arg: TypeAlias = Content_659.cv_arg
    cv_content: TypeAlias = Content_659

    @property
    def content(self) -> Content_659:
        return self._get_content() # type: ignore

class Variation_275(Element):
    cv_arg: TypeAlias = RuleContent_659.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_659

    @classmethod
    def create(cls, arg: "Variation_275.cv_arg") -> "Variation_275":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_659:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_659:
        return self.rule.content

class RuleVariation_268(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_275.cv_arg
    cv_variation: TypeAlias = Variation_275

    @classmethod
    def create(cls, arg : "RuleVariation_268.cv_arg") -> "RuleVariation_268":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_275:
        return self.arg # type: ignore

class NonSpare_817(NonSpare):
    cv_arg: TypeAlias = RuleVariation_268.cv_arg
    cv_name = "COVXY"
    cv_title = "Covariance in Two’s Complement Form"
    cv_rule: TypeAlias = RuleVariation_268

    @classmethod
    def create(cls, arg : "NonSpare_817.cv_arg") -> "NonSpare_817":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_268:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_275:
        return self.rule.variation

class Item_206(Item):
    cv_arg: TypeAlias = NonSpare_817.cv_arg
    cv_non_spare: TypeAlias = NonSpare_817

    @classmethod
    def create(cls, arg : "Item_206.cv_arg") -> "Item_206":
        return cls._create(arg) # type: ignore

class Variation_1088(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_225.cv_arg, Tuple[Literal["DEVX"], RuleVariation_225.cv_arg]], Union[RuleVariation_225.cv_arg, Tuple[Literal["DEVY"], RuleVariation_225.cv_arg]], Union[RuleVariation_268.cv_arg, Tuple[Literal["COVXY"], RuleVariation_268.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1088.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_259, 8), (Item_260, 8), (Item_206, 16)]
    cv_items_dict = {"DEVX": RuleVariation_225, "DEVY": RuleVariation_225, "COVXY": RuleVariation_268}

    @overload
    @classmethod
    def spec(cls, key : Literal["DEVX"]) -> Type[RuleVariation_225]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DEVY"]) -> Type[RuleVariation_225]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COVXY"]) -> Type[RuleVariation_268]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["DEVX"], Literal["DEVY"], Literal["COVXY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["DEVX"]) -> RuleVariation_225:
        ...
    @overload
    def get_item(self, key : Literal["DEVY"]) -> RuleVariation_225:
        ...
    @overload
    def get_item(self, key : Literal["COVXY"]) -> RuleVariation_268:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1088.cv_arg") -> 'Variation_1088':
        return cls._create(arg) # type: ignore

class RuleVariation_1048(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1088.cv_arg
    cv_variation: TypeAlias = Variation_1088

    @classmethod
    def create(cls, arg : "RuleVariation_1048.cv_arg") -> "RuleVariation_1048":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1088:
        return self.arg # type: ignore

class NonSpare_520(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1048.cv_arg
    cv_name = "500"
    cv_title = "Standard Deviation of Position"
    cv_rule: TypeAlias = RuleVariation_1048

    @classmethod
    def create(cls, arg : "NonSpare_520.cv_arg") -> "NonSpare_520":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1048:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1088:
        return self.rule.variation

class UapItem_519(UapItem):
    cv_non_spare: TypeAlias = NonSpare_520

class Content_629(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 1.0
    cv_unit = "m"

    def as_quantity(self, cv_unit : Optional[Literal["m"]] = None) -> float:
        return self._as_quantity()

class RuleContent_629(RuleContentContextFree):
    cv_arg: TypeAlias = Content_629.cv_arg
    cv_content: TypeAlias = Content_629

    @property
    def content(self) -> Content_629:
        return self._get_content() # type: ignore

class Variation_210(Element):
    cv_arg: TypeAlias = RuleContent_629.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_629

    @classmethod
    def create(cls, arg: "Variation_210.cv_arg") -> "Variation_210":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_629:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_629:
        return self.rule.content

class RuleVariation_203(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_210.cv_arg
    cv_variation: TypeAlias = Variation_210

    @classmethod
    def create(cls, arg : "RuleVariation_203.cv_arg") -> "RuleVariation_203":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_210:
        return self.arg # type: ignore

class NonSpare_903(NonSpare):
    cv_arg: TypeAlias = RuleVariation_203.cv_arg
    cv_name = "DRHO"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_203

    @classmethod
    def create(cls, arg : "NonSpare_903.cv_arg") -> "NonSpare_903":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_203:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_210:
        return self.rule.variation

class Item_273(Item):
    cv_arg: TypeAlias = NonSpare_903.cv_arg
    cv_non_spare: TypeAlias = NonSpare_903

    @classmethod
    def create(cls, arg : "Item_273.cv_arg") -> "Item_273":
        return cls._create(arg) # type: ignore

class Content_685(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["°"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.15
    cv_unit = "°"

    def as_quantity(self, cv_unit : Optional[Literal["°"]] = None) -> float:
        return self._as_quantity()

class RuleContent_685(RuleContentContextFree):
    cv_arg: TypeAlias = Content_685.cv_arg
    cv_content: TypeAlias = Content_685

    @property
    def content(self) -> Content_685:
        return self._get_content() # type: ignore

class Variation_219(Element):
    cv_arg: TypeAlias = RuleContent_685.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_685

    @classmethod
    def create(cls, arg: "Variation_219.cv_arg") -> "Variation_219":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_685:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_685:
        return self.rule.content

class RuleVariation_212(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_219.cv_arg
    cv_variation: TypeAlias = Variation_219

    @classmethod
    def create(cls, arg : "RuleVariation_212.cv_arg") -> "RuleVariation_212":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_219:
        return self.arg # type: ignore

class NonSpare_914(NonSpare):
    cv_arg: TypeAlias = RuleVariation_212.cv_arg
    cv_name = "DTHETA"
    cv_title = ""
    cv_rule: TypeAlias = RuleVariation_212

    @classmethod
    def create(cls, arg : "NonSpare_914.cv_arg") -> "NonSpare_914":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_212:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_219:
        return self.rule.variation

class Item_281(Item):
    cv_arg: TypeAlias = NonSpare_914.cv_arg
    cv_non_spare: TypeAlias = NonSpare_914

    @classmethod
    def create(cls, arg : "Item_281.cv_arg") -> "Item_281":
        return cls._create(arg) # type: ignore

class Variation_1090(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_203.cv_arg, Tuple[Literal["DRHO"], RuleVariation_203.cv_arg]], Union[RuleVariation_212.cv_arg, Tuple[Literal["DTHETA"], RuleVariation_212.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1090.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_273, 8), (Item_281, 8)]
    cv_items_dict = {"DRHO": RuleVariation_203, "DTHETA": RuleVariation_212}

    @overload
    @classmethod
    def spec(cls, key : Literal["DRHO"]) -> Type[RuleVariation_203]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DTHETA"]) -> Type[RuleVariation_212]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["DRHO"], Literal["DTHETA"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["DRHO"]) -> RuleVariation_203:
        ...
    @overload
    def get_item(self, key : Literal["DTHETA"]) -> RuleVariation_212:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1090.cv_arg") -> 'Variation_1090':
        return cls._create(arg) # type: ignore

class Variation_1427(Repetitive):
    cv_arg: TypeAlias = List[Variation_1090.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_1090

    @classmethod
    def create(cls, arg: "Variation_1427.cv_arg") -> 'Variation_1427':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_1090]:
        return self._get_list() # type: ignore

class RuleVariation_1348(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1427.cv_arg
    cv_variation: TypeAlias = Variation_1427

    @classmethod
    def create(cls, arg : "RuleVariation_1348.cv_arg") -> "RuleVariation_1348":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1427:
        return self.arg # type: ignore

class NonSpare_469(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1348.cv_arg
    cv_name = "280"
    cv_title = "Presence"
    cv_rule: TypeAlias = RuleVariation_1348

    @classmethod
    def create(cls, arg : "NonSpare_469.cv_arg") -> "NonSpare_469":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1348:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1427:
        return self.rule.variation

class UapItem_469(UapItem):
    cv_non_spare: TypeAlias = NonSpare_469

class NonSpare_315(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "131"
    cv_title = "Amplitude of Primary Plot"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_315.cv_arg") -> "NonSpare_315":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class UapItem_315(UapItem):
    cv_non_spare: TypeAlias = NonSpare_315

class Content_672(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s²"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 6.25e-2
    cv_unit = "m/s²"

    def as_quantity(self, cv_unit : Optional[Literal["m/s²"]] = None) -> float:
        return self._as_quantity()

class RuleContent_672(RuleContentContextFree):
    cv_arg: TypeAlias = Content_672.cv_arg
    cv_content: TypeAlias = Content_672

    @property
    def content(self) -> Content_672:
        return self._get_content() # type: ignore

class Variation_213(Element):
    cv_arg: TypeAlias = RuleContent_672.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_672

    @classmethod
    def create(cls, arg: "Variation_213.cv_arg") -> "Variation_213":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_672:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_672:
        return self.rule.content

class RuleVariation_206(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_213.cv_arg
    cv_variation: TypeAlias = Variation_213

    @classmethod
    def create(cls, arg : "RuleVariation_206.cv_arg") -> "RuleVariation_206":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_213:
        return self.arg # type: ignore

class NonSpare_660(NonSpare):
    cv_arg: TypeAlias = RuleVariation_206.cv_arg
    cv_name = "AX"
    cv_title = "X Acceleration"
    cv_rule: TypeAlias = RuleVariation_206

    @classmethod
    def create(cls, arg : "NonSpare_660.cv_arg") -> "NonSpare_660":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_206:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_213:
        return self.rule.variation

class Item_101(Item):
    cv_arg: TypeAlias = NonSpare_660.cv_arg
    cv_non_spare: TypeAlias = NonSpare_660

    @classmethod
    def create(cls, arg : "Item_101.cv_arg") -> "Item_101":
        return cls._create(arg) # type: ignore

class NonSpare_664(NonSpare):
    cv_arg: TypeAlias = RuleVariation_206.cv_arg
    cv_name = "AY"
    cv_title = "Y Acceleration"
    cv_rule: TypeAlias = RuleVariation_206

    @classmethod
    def create(cls, arg : "NonSpare_664.cv_arg") -> "NonSpare_664":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_206:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_213:
        return self.rule.variation

class Item_105(Item):
    cv_arg: TypeAlias = NonSpare_664.cv_arg
    cv_non_spare: TypeAlias = NonSpare_664

    @classmethod
    def create(cls, arg : "Item_105.cv_arg") -> "Item_105":
        return cls._create(arg) # type: ignore

class Variation_1062(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_206.cv_arg, Tuple[Literal["AX"], RuleVariation_206.cv_arg]], Union[RuleVariation_206.cv_arg, Tuple[Literal["AY"], RuleVariation_206.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1062.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_101, 8), (Item_105, 8)]
    cv_items_dict = {"AX": RuleVariation_206, "AY": RuleVariation_206}

    @overload
    @classmethod
    def spec(cls, key : Literal["AX"]) -> Type[RuleVariation_206]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AY"]) -> Type[RuleVariation_206]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AX"], Literal["AY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AX"]) -> RuleVariation_206:
        ...
    @overload
    def get_item(self, key : Literal["AY"]) -> RuleVariation_206:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1062.cv_arg") -> 'Variation_1062':
        return cls._create(arg) # type: ignore

class RuleVariation_1029(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1062.cv_arg
    cv_variation: TypeAlias = Variation_1062

    @classmethod
    def create(cls, arg : "RuleVariation_1029.cv_arg") -> "RuleVariation_1029":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1062:
        return self.arg # type: ignore

class NonSpare_410(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1029.cv_arg
    cv_name = "210"
    cv_title = "Calculated Acceleration"
    cv_rule: TypeAlias = RuleVariation_1029

    @classmethod
    def create(cls, arg : "NonSpare_410.cv_arg") -> "NonSpare_410":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1029:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1062:
        return self.rule.variation

class UapItem_410(UapItem):
    cv_non_spare: TypeAlias = NonSpare_410

class Record_38(Record):
    cv_arg = TypedDict('cv_arg', {
        "010": NonSpare_43.cv_arg,
        "000": NonSpare_13.cv_arg,
        "020": NonSpare_91.cv_arg,
        "140": NonSpare_332.cv_arg,
        "041": NonSpare_155.cv_arg,
        "040": NonSpare_140.cv_arg,
        "042": NonSpare_161.cv_arg,
        "200": NonSpare_392.cv_arg,
        "202": NonSpare_405.cv_arg,
        "161": NonSpare_363.cv_arg,
        "170": NonSpare_375.cv_arg,
        "060": NonSpare_192.cv_arg,
        "220": NonSpare_427.cv_arg,
        "245": NonSpare_443.cv_arg,
        "250": NonSpare_450.cv_arg,
        "300": NonSpare_479.cv_arg,
        "090": NonSpare_251.cv_arg,
        "091": NonSpare_261.cv_arg,
        "270": NonSpare_463.cv_arg,
        "550": NonSpare_525.cv_arg,
        "310": NonSpare_481.cv_arg,
        "500": NonSpare_520.cv_arg,
        "280": NonSpare_469.cv_arg,
        "131": NonSpare_315.cv_arg,
        "210": NonSpare_410.cv_arg,
        "SP": NonSpare_1739.cv_arg,
        "RE": NonSpare_1574.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 4
    cv_items_list = [UapItem_43, UapItem_13, UapItem_91, UapItem_332, UapItem_155, UapItem_140, UapItem_161, UapItem_392, UapItem_405, UapItem_363, UapItem_375, UapItem_192, UapItem_427, UapItem_443, UapItem_450, UapItem_479, UapItem_251, UapItem_261, UapItem_463, UapItem_524, UapItem_481, UapItem_519, UapItem_469, UapItem_315, UapItem_410, UapItem_551, UapItem_550, UapItem_549]
    cv_items_dict = {"010": NonSpare_43, "000": NonSpare_13, "020": NonSpare_91, "140": NonSpare_332, "041": NonSpare_155, "040": NonSpare_140, "042": NonSpare_161, "200": NonSpare_392, "202": NonSpare_405, "161": NonSpare_363, "170": NonSpare_375, "060": NonSpare_192, "220": NonSpare_427, "245": NonSpare_443, "250": NonSpare_450, "300": NonSpare_479, "090": NonSpare_251, "091": NonSpare_261, "270": NonSpare_463, "550": NonSpare_525, "310": NonSpare_481, "500": NonSpare_520, "280": NonSpare_469, "131": NonSpare_315, "210": NonSpare_410, "SP": NonSpare_1739, "RE": NonSpare_1574}

    @overload
    @classmethod
    def spec(cls, key : Literal["010"]) -> Type[NonSpare_43]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["000"]) -> Type[NonSpare_13]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["020"]) -> Type[NonSpare_91]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["140"]) -> Type[NonSpare_332]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["041"]) -> Type[NonSpare_155]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["040"]) -> Type[NonSpare_140]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["042"]) -> Type[NonSpare_161]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["200"]) -> Type[NonSpare_392]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["202"]) -> Type[NonSpare_405]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["161"]) -> Type[NonSpare_363]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["170"]) -> Type[NonSpare_375]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["060"]) -> Type[NonSpare_192]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["220"]) -> Type[NonSpare_427]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["245"]) -> Type[NonSpare_443]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["250"]) -> Type[NonSpare_450]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["300"]) -> Type[NonSpare_479]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["090"]) -> Type[NonSpare_251]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["091"]) -> Type[NonSpare_261]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["270"]) -> Type[NonSpare_463]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["550"]) -> Type[NonSpare_525]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["310"]) -> Type[NonSpare_481]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["500"]) -> Type[NonSpare_520]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["280"]) -> Type[NonSpare_469]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["131"]) -> Type[NonSpare_315]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["210"]) -> Type[NonSpare_410]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SP"]) -> Type[NonSpare_1739]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["RE"]) -> Type[NonSpare_1574]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["010"], Literal["000"], Literal["020"], Literal["140"], Literal["041"], Literal["040"], Literal["042"], Literal["200"], Literal["202"], Literal["161"], Literal["170"], Literal["060"], Literal["220"], Literal["245"], Literal["250"], Literal["300"], Literal["090"], Literal["091"], Literal["270"], Literal["550"], Literal["310"], Literal["500"], Literal["280"], Literal["131"], Literal["210"], Literal["SP"], Literal["RE"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["010"]) -> Optional[NonSpare_43]:
        ...
    @overload
    def get_item(self, key : Literal["000"]) -> Optional[NonSpare_13]:
        ...
    @overload
    def get_item(self, key : Literal["020"]) -> Optional[NonSpare_91]:
        ...
    @overload
    def get_item(self, key : Literal["140"]) -> Optional[NonSpare_332]:
        ...
    @overload
    def get_item(self, key : Literal["041"]) -> Optional[NonSpare_155]:
        ...
    @overload
    def get_item(self, key : Literal["040"]) -> Optional[NonSpare_140]:
        ...
    @overload
    def get_item(self, key : Literal["042"]) -> Optional[NonSpare_161]:
        ...
    @overload
    def get_item(self, key : Literal["200"]) -> Optional[NonSpare_392]:
        ...
    @overload
    def get_item(self, key : Literal["202"]) -> Optional[NonSpare_405]:
        ...
    @overload
    def get_item(self, key : Literal["161"]) -> Optional[NonSpare_363]:
        ...
    @overload
    def get_item(self, key : Literal["170"]) -> Optional[NonSpare_375]:
        ...
    @overload
    def get_item(self, key : Literal["060"]) -> Optional[NonSpare_192]:
        ...
    @overload
    def get_item(self, key : Literal["220"]) -> Optional[NonSpare_427]:
        ...
    @overload
    def get_item(self, key : Literal["245"]) -> Optional[NonSpare_443]:
        ...
    @overload
    def get_item(self, key : Literal["250"]) -> Optional[NonSpare_450]:
        ...
    @overload
    def get_item(self, key : Literal["300"]) -> Optional[NonSpare_479]:
        ...
    @overload
    def get_item(self, key : Literal["090"]) -> Optional[NonSpare_251]:
        ...
    @overload
    def get_item(self, key : Literal["091"]) -> Optional[NonSpare_261]:
        ...
    @overload
    def get_item(self, key : Literal["270"]) -> Optional[NonSpare_463]:
        ...
    @overload
    def get_item(self, key : Literal["550"]) -> Optional[NonSpare_525]:
        ...
    @overload
    def get_item(self, key : Literal["310"]) -> Optional[NonSpare_481]:
        ...
    @overload
    def get_item(self, key : Literal["500"]) -> Optional[NonSpare_520]:
        ...
    @overload
    def get_item(self, key : Literal["280"]) -> Optional[NonSpare_469]:
        ...
    @overload
    def get_item(self, key : Literal["131"]) -> Optional[NonSpare_315]:
        ...
    @overload
    def get_item(self, key : Literal["210"]) -> Optional[NonSpare_410]:
        ...
    @overload
    def get_item(self, key : Literal["SP"]) -> Optional[NonSpare_1739]:
        ...
    @overload
    def get_item(self, key : Literal["RE"]) -> Optional[NonSpare_1574]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["010"], val : NonSpare_43.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["000"], val : NonSpare_13.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["020"], val : NonSpare_91.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["140"], val : NonSpare_332.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["041"], val : NonSpare_155.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["040"], val : NonSpare_140.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["042"], val : NonSpare_161.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["200"], val : NonSpare_392.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["202"], val : NonSpare_405.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["161"], val : NonSpare_363.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["170"], val : NonSpare_375.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["060"], val : NonSpare_192.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["220"], val : NonSpare_427.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["245"], val : NonSpare_443.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["250"], val : NonSpare_450.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["300"], val : NonSpare_479.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["090"], val : NonSpare_251.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["091"], val : NonSpare_261.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["270"], val : NonSpare_463.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["550"], val : NonSpare_525.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["310"], val : NonSpare_481.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["500"], val : NonSpare_520.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["280"], val : NonSpare_469.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["131"], val : NonSpare_315.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["210"], val : NonSpare_410.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["SP"], val : NonSpare_1739.cv_arg) -> 'Record_38':
        ...
    @overload
    def set_item(self, key : Literal["RE"], val : NonSpare_1574.cv_arg) -> 'Record_38':
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["010"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["000"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["020"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["140"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["041"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["040"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["042"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["200"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["202"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["161"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["170"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["060"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["220"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["245"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["250"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["300"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["090"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["091"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["270"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["550"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["310"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["500"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["280"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["131"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["210"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["SP"]) -> 'Record_38':
        ...
    @overload
    def del_item(self, key : Literal["RE"]) -> 'Record_38':
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Record_38.cv_arg") -> 'Record_38':
        return cls._create(arg) # type: ignore

    @classmethod
    def parse(cls, pm: ParsingMode, bs : Bits) -> Union[ValueError, Tuple["Record_38", Bits]]:
        return cls._parse(pm, bs) # type: ignore

class Uap_34(UapSingle):
    cv_arg: TypeAlias = Record_38
    cv_record: TypeAlias = Record_38

    @classmethod
    def parse(cls, bs : Bits) -> Union[ValueError, List[Record_38]]:
        return cls._parse(bs)

class Asterix_11(AstCat):
    cv_category = 10
    cv_edition = (1, 1)
    cv_uap: TypeAlias = Uap_34
    cv_record: TypeAlias = cv_uap.cv_record # shortcut

    @classmethod
    def create(cls, records : List[Uap_34.cv_arg]) -> "Asterix_11":
        return cls._create(records) # type: ignore

class NonSpare_1663(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "SAC"
    cv_title = "System Area Code Fixed to Zero"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_1663.cv_arg") -> "NonSpare_1663":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class Item_861(Item):
    cv_arg: TypeAlias = NonSpare_1663.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1663

    @classmethod
    def create(cls, arg : "Item_861.cv_arg") -> "Item_861":
        return cls._create(arg) # type: ignore

class Variation_1202(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_159.cv_arg, Tuple[Literal["SAC"], RuleVariation_159.cv_arg]], Union[RuleVariation_159.cv_arg, Tuple[Literal["SIC"], RuleVariation_159.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1202.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_861, 8), (Item_891, 8)]
    cv_items_dict = {"SAC": RuleVariation_159, "SIC": RuleVariation_159}

    @overload
    @classmethod
    def spec(cls, key : Literal["SAC"]) -> Type[RuleVariation_159]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SIC"]) -> Type[RuleVariation_159]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["SAC"], Literal["SIC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["SAC"]) -> RuleVariation_159:
        ...
    @overload
    def get_item(self, key : Literal["SIC"]) -> RuleVariation_159:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1202.cv_arg") -> 'Variation_1202':
        return cls._create(arg) # type: ignore

class RuleVariation_1148(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1202.cv_arg
    cv_variation: TypeAlias = Variation_1202

    @classmethod
    def create(cls, arg : "RuleVariation_1148.cv_arg") -> "RuleVariation_1148":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1202:
        return self.arg # type: ignore

class NonSpare_48(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1148.cv_arg
    cv_name = "010"
    cv_title = "Data Source Identifier"
    cv_rule: TypeAlias = RuleVariation_1148

    @classmethod
    def create(cls, arg : "NonSpare_48.cv_arg") -> "NonSpare_48":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1148:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1202:
        return self.rule.variation

class UapItem_48(UapItem):
    cv_non_spare: TypeAlias = NonSpare_48

class Content_601(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Target reports, flight plan data and basic alerts", 2: "Manual attachment of flight plan to track", 3: "Manual detachment of flight plan to track", 4: "Insertion of flight plan data", 5: "Suppression of flight plan data", 6: "Modification of flight plan data", 7: "Holdbar status"}

class RuleContent_601(RuleContentContextFree):
    cv_arg: TypeAlias = Content_601.cv_arg
    cv_content: TypeAlias = Content_601

    @property
    def content(self) -> Content_601:
        return self._get_content() # type: ignore

class Variation_199(Element):
    cv_arg: TypeAlias = RuleContent_601.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_601

    @classmethod
    def create(cls, arg: "Variation_199.cv_arg") -> "Variation_199":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_601:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_601:
        return self.rule.content

class RuleVariation_192(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_199.cv_arg
    cv_variation: TypeAlias = Variation_199

    @classmethod
    def create(cls, arg : "RuleVariation_192.cv_arg") -> "RuleVariation_192":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_199:
        return self.arg # type: ignore

class NonSpare_14(NonSpare):
    cv_arg: TypeAlias = RuleVariation_192.cv_arg
    cv_name = "000"
    cv_title = "Message Type"
    cv_rule: TypeAlias = RuleVariation_192

    @classmethod
    def create(cls, arg : "NonSpare_14.cv_arg") -> "NonSpare_14":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_192:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_199:
        return self.rule.variation

class UapItem_14(UapItem):
    cv_non_spare: TypeAlias = NonSpare_14

class NonSpare_62(NonSpare):
    cv_arg: TypeAlias = RuleVariation_159.cv_arg
    cv_name = "015"
    cv_title = "Service Identification"
    cv_rule: TypeAlias = RuleVariation_159

    @classmethod
    def create(cls, arg : "NonSpare_62.cv_arg") -> "NonSpare_62":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_159:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_165:
        return self.rule.variation

class UapItem_62(UapItem):
    cv_non_spare: TypeAlias = NonSpare_62

class NonSpare_337(NonSpare):
    cv_arg: TypeAlias = RuleVariation_363.cv_arg
    cv_name = "140"
    cv_title = "Time of Track Information"
    cv_rule: TypeAlias = RuleVariation_363

    @classmethod
    def create(cls, arg : "NonSpare_337.cv_arg") -> "NonSpare_337":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_363:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_370:
        return self.rule.variation

class UapItem_337(UapItem):
    cv_non_spare: TypeAlias = NonSpare_337

class NonSpare_1163(NonSpare):
    cv_arg: TypeAlias = RuleVariation_376.cv_arg
    cv_name = "LAT"
    cv_title = "Latitude in WGS-84 in Two's Complement"
    cv_rule: TypeAlias = RuleVariation_376

    @classmethod
    def create(cls, arg : "NonSpare_1163.cv_arg") -> "NonSpare_1163":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_376:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_383:
        return self.rule.variation

class Item_472(Item):
    cv_arg: TypeAlias = NonSpare_1163.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1163

    @classmethod
    def create(cls, arg : "Item_472.cv_arg") -> "Item_472":
        return cls._create(arg) # type: ignore

class NonSpare_1193(NonSpare):
    cv_arg: TypeAlias = RuleVariation_374.cv_arg
    cv_name = "LON"
    cv_title = "Longitude in WGS-84 in Two's Complement"
    cv_rule: TypeAlias = RuleVariation_374

    @classmethod
    def create(cls, arg : "NonSpare_1193.cv_arg") -> "NonSpare_1193":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_374:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_381:
        return self.rule.variation

class Item_500(Item):
    cv_arg: TypeAlias = NonSpare_1193.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1193

    @classmethod
    def create(cls, arg : "Item_500.cv_arg") -> "Item_500":
        return cls._create(arg) # type: ignore

class Variation_1139(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_376.cv_arg, Tuple[Literal["LAT"], RuleVariation_376.cv_arg]], Union[RuleVariation_374.cv_arg, Tuple[Literal["LON"], RuleVariation_374.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1139.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_items_list = [(Item_472, 32), (Item_500, 32)]
    cv_items_dict = {"LAT": RuleVariation_376, "LON": RuleVariation_374}

    @overload
    @classmethod
    def spec(cls, key : Literal["LAT"]) -> Type[RuleVariation_376]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["LON"]) -> Type[RuleVariation_374]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["LAT"], Literal["LON"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["LAT"]) -> RuleVariation_376:
        ...
    @overload
    def get_item(self, key : Literal["LON"]) -> RuleVariation_374:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1139.cv_arg") -> 'Variation_1139':
        return cls._create(arg) # type: ignore

class RuleVariation_1095(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1139.cv_arg
    cv_variation: TypeAlias = Variation_1139

    @classmethod
    def create(cls, arg : "RuleVariation_1095.cv_arg") -> "RuleVariation_1095":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1139:
        return self.arg # type: ignore

class NonSpare_156(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1095.cv_arg
    cv_name = "041"
    cv_title = "Position in WGS-84 Coordinates"
    cv_rule: TypeAlias = RuleVariation_1095

    @classmethod
    def create(cls, arg : "NonSpare_156.cv_arg") -> "NonSpare_156":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1095:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1139:
        return self.rule.variation

class UapItem_156(UapItem):
    cv_non_spare: TypeAlias = NonSpare_156

class NonSpare_2109(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "X"
    cv_title = "X-Component"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2109.cv_arg") -> "NonSpare_2109":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1206(Item):
    cv_arg: TypeAlias = NonSpare_2109.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2109

    @classmethod
    def create(cls, arg : "Item_1206.cv_arg") -> "Item_1206":
        return cls._create(arg) # type: ignore

class NonSpare_2163(NonSpare):
    cv_arg: TypeAlias = RuleVariation_252.cv_arg
    cv_name = "Y"
    cv_title = "Y-Component"
    cv_rule: TypeAlias = RuleVariation_252

    @classmethod
    def create(cls, arg : "NonSpare_2163.cv_arg") -> "NonSpare_2163":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_252:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_259:
        return self.rule.variation

class Item_1257(Item):
    cv_arg: TypeAlias = NonSpare_2163.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2163

    @classmethod
    def create(cls, arg : "Item_1257.cv_arg") -> "Item_1257":
        return cls._create(arg) # type: ignore

class Variation_1319(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_252.cv_arg, Tuple[Literal["X"], RuleVariation_252.cv_arg]], Union[RuleVariation_252.cv_arg, Tuple[Literal["Y"], RuleVariation_252.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1319.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1206, 16), (Item_1257, 16)]
    cv_items_dict = {"X": RuleVariation_252, "Y": RuleVariation_252}

    @overload
    @classmethod
    def spec(cls, key : Literal["X"]) -> Type[RuleVariation_252]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["Y"]) -> Type[RuleVariation_252]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["X"], Literal["Y"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["X"]) -> RuleVariation_252:
        ...
    @overload
    def get_item(self, key : Literal["Y"]) -> RuleVariation_252:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1319.cv_arg") -> 'Variation_1319':
        return cls._create(arg) # type: ignore

class RuleVariation_1246(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1319.cv_arg
    cv_variation: TypeAlias = Variation_1319

    @classmethod
    def create(cls, arg : "RuleVariation_1246.cv_arg") -> "RuleVariation_1246":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1319:
        return self.arg # type: ignore

class NonSpare_158(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1246.cv_arg
    cv_name = "042"
    cv_title = "Calculated Position in Cartesian Co-ordinates"
    cv_rule: TypeAlias = RuleVariation_1246

    @classmethod
    def create(cls, arg : "NonSpare_158.cv_arg") -> "NonSpare_158":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1246:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1319:
        return self.rule.variation

class UapItem_158(UapItem):
    cv_non_spare: TypeAlias = NonSpare_158

class Content_663(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m/s"

    def as_quantity(self, cv_unit : Optional[Literal["m/s"]] = None) -> float:
        return self._as_quantity()

class RuleContent_663(RuleContentContextFree):
    cv_arg: TypeAlias = Content_663.cv_arg
    cv_content: TypeAlias = Content_663

    @property
    def content(self) -> Content_663:
        return self._get_content() # type: ignore

class Variation_279(Element):
    cv_arg: TypeAlias = RuleContent_663.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_rule = RuleContent_663

    @classmethod
    def create(cls, arg: "Variation_279.cv_arg") -> "Variation_279":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_663:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_663:
        return self.rule.content

class RuleVariation_272(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_279.cv_arg
    cv_variation: TypeAlias = Variation_279

    @classmethod
    def create(cls, arg : "RuleVariation_272.cv_arg") -> "RuleVariation_272":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_279:
        return self.arg # type: ignore

class NonSpare_2062(NonSpare):
    cv_arg: TypeAlias = RuleVariation_272.cv_arg
    cv_name = "VX"
    cv_title = "Vx"
    cv_rule: TypeAlias = RuleVariation_272

    @classmethod
    def create(cls, arg : "NonSpare_2062.cv_arg") -> "NonSpare_2062":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_272:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_279:
        return self.rule.variation

class Item_1164(Item):
    cv_arg: TypeAlias = NonSpare_2062.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2062

    @classmethod
    def create(cls, arg : "Item_1164.cv_arg") -> "Item_1164":
        return cls._create(arg) # type: ignore

class NonSpare_2067(NonSpare):
    cv_arg: TypeAlias = RuleVariation_272.cv_arg
    cv_name = "VY"
    cv_title = "Vy"
    cv_rule: TypeAlias = RuleVariation_272

    @classmethod
    def create(cls, arg : "NonSpare_2067.cv_arg") -> "NonSpare_2067":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_272:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_279:
        return self.rule.variation

class Item_1169(Item):
    cv_arg: TypeAlias = NonSpare_2067.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2067

    @classmethod
    def create(cls, arg : "Item_1169.cv_arg") -> "Item_1169":
        return cls._create(arg) # type: ignore

class Variation_1289(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_272.cv_arg, Tuple[Literal["VX"], RuleVariation_272.cv_arg]], Union[RuleVariation_272.cv_arg, Tuple[Literal["VY"], RuleVariation_272.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1289.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_items_list = [(Item_1164, 16), (Item_1169, 16)]
    cv_items_dict = {"VX": RuleVariation_272, "VY": RuleVariation_272}

    @overload
    @classmethod
    def spec(cls, key : Literal["VX"]) -> Type[RuleVariation_272]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["VY"]) -> Type[RuleVariation_272]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VX"], Literal["VY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VX"]) -> RuleVariation_272:
        ...
    @overload
    def get_item(self, key : Literal["VY"]) -> RuleVariation_272:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1289.cv_arg") -> 'Variation_1289':
        return cls._create(arg) # type: ignore

class RuleVariation_1218(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1289.cv_arg
    cv_variation: TypeAlias = Variation_1289

    @classmethod
    def create(cls, arg : "RuleVariation_1218.cv_arg") -> "RuleVariation_1218":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1289:
        return self.arg # type: ignore

class NonSpare_407(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1218.cv_arg
    cv_name = "202"
    cv_title = "Calculated Track Velocity in Cartesian Coordinates"
    cv_rule: TypeAlias = RuleVariation_1218

    @classmethod
    def create(cls, arg : "NonSpare_407.cv_arg") -> "NonSpare_407":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1218:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1289:
        return self.rule.variation

class UapItem_407(UapItem):
    cv_non_spare: TypeAlias = NonSpare_407

class Content_666(ContentQuantity):
    cv_arg: TypeAlias = Union[int, float, Tuple[float, Literal["m/s²"]]]
    cv_signedness: TypeAlias = Signed
    cv_lsb = 0.25
    cv_unit = "m/s²"

    def as_quantity(self, cv_unit : Optional[Literal["m/s²"]] = None) -> float:
        return self._as_quantity()

class RuleContent_666(RuleContentContextFree):
    cv_arg: TypeAlias = Content_666.cv_arg
    cv_content: TypeAlias = Content_666

    @property
    def content(self) -> Content_666:
        return self._get_content() # type: ignore

class Variation_212(Element):
    cv_arg: TypeAlias = RuleContent_666.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_666

    @classmethod
    def create(cls, arg: "Variation_212.cv_arg") -> "Variation_212":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_666:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_666:
        return self.rule.content

class RuleVariation_205(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_212.cv_arg
    cv_variation: TypeAlias = Variation_212

    @classmethod
    def create(cls, arg : "RuleVariation_205.cv_arg") -> "RuleVariation_205":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_212:
        return self.arg # type: ignore

class NonSpare_659(NonSpare):
    cv_arg: TypeAlias = RuleVariation_205.cv_arg
    cv_name = "AX"
    cv_title = "Ax"
    cv_rule: TypeAlias = RuleVariation_205

    @classmethod
    def create(cls, arg : "NonSpare_659.cv_arg") -> "NonSpare_659":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_205:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_212:
        return self.rule.variation

class Item_100(Item):
    cv_arg: TypeAlias = NonSpare_659.cv_arg
    cv_non_spare: TypeAlias = NonSpare_659

    @classmethod
    def create(cls, arg : "Item_100.cv_arg") -> "Item_100":
        return cls._create(arg) # type: ignore

class NonSpare_663(NonSpare):
    cv_arg: TypeAlias = RuleVariation_205.cv_arg
    cv_name = "AY"
    cv_title = "Ay"
    cv_rule: TypeAlias = RuleVariation_205

    @classmethod
    def create(cls, arg : "NonSpare_663.cv_arg") -> "NonSpare_663":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_205:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_212:
        return self.rule.variation

class Item_104(Item):
    cv_arg: TypeAlias = NonSpare_663.cv_arg
    cv_non_spare: TypeAlias = NonSpare_663

    @classmethod
    def create(cls, arg : "Item_104.cv_arg") -> "Item_104":
        return cls._create(arg) # type: ignore

class Variation_1061(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_205.cv_arg, Tuple[Literal["AX"], RuleVariation_205.cv_arg]], Union[RuleVariation_205.cv_arg, Tuple[Literal["AY"], RuleVariation_205.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1061.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_100, 8), (Item_104, 8)]
    cv_items_dict = {"AX": RuleVariation_205, "AY": RuleVariation_205}

    @overload
    @classmethod
    def spec(cls, key : Literal["AX"]) -> Type[RuleVariation_205]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AY"]) -> Type[RuleVariation_205]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["AX"], Literal["AY"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["AX"]) -> RuleVariation_205:
        ...
    @overload
    def get_item(self, key : Literal["AY"]) -> RuleVariation_205:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1061.cv_arg") -> 'Variation_1061':
        return cls._create(arg) # type: ignore

class RuleVariation_1028(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1061.cv_arg
    cv_variation: TypeAlias = Variation_1061

    @classmethod
    def create(cls, arg : "RuleVariation_1028.cv_arg") -> "RuleVariation_1028":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1061:
        return self.arg # type: ignore

class NonSpare_409(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1028.cv_arg
    cv_name = "210"
    cv_title = "Calculated Acceleration"
    cv_rule: TypeAlias = RuleVariation_1028

    @classmethod
    def create(cls, arg : "NonSpare_409.cv_arg") -> "NonSpare_409":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1028:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1061:
        return self.rule.variation

class UapItem_409(UapItem):
    cv_non_spare: TypeAlias = NonSpare_409

class NonSpare_1304(NonSpare):
    cv_arg: TypeAlias = RuleVariation_782.cv_arg
    cv_name = "MOD3A"
    cv_title = "Mode-3/A Reply in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_782

    @classmethod
    def create(cls, arg : "NonSpare_1304.cv_arg") -> "NonSpare_1304":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_782:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_812:
        return self.rule.variation

class Item_567(Item):
    cv_arg: TypeAlias = NonSpare_1304.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1304

    @classmethod
    def create(cls, arg : "Item_567.cv_arg") -> "Item_567":
        return cls._create(arg) # type: ignore

class Variation_1028(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_782.cv_arg, Tuple[Literal["MOD3A"], RuleVariation_782.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1028.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_3, 4), (Item_567, 12)]
    cv_items_dict = {"MOD3A": RuleVariation_782}

    @classmethod
    def spec(cls, key : Literal["MOD3A"]) -> Type[RuleVariation_782]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["MOD3A"]) -> RuleVariation_782:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_1028.cv_arg") -> 'Variation_1028':
        return cls._create(arg) # type: ignore

class RuleVariation_997(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1028.cv_arg
    cv_variation: TypeAlias = Variation_1028

    @classmethod
    def create(cls, arg : "RuleVariation_997.cv_arg") -> "RuleVariation_997":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1028:
        return self.arg # type: ignore

class NonSpare_191(NonSpare):
    cv_arg: TypeAlias = RuleVariation_997.cv_arg
    cv_name = "060"
    cv_title = "Mode-3/A Code in Octal Representation"
    cv_rule: TypeAlias = RuleVariation_997

    @classmethod
    def create(cls, arg : "NonSpare_191.cv_arg") -> "NonSpare_191":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_997:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1028:
        return self.rule.variation

class UapItem_191(UapItem):
    cv_non_spare: TypeAlias = NonSpare_191

class NonSpare_1870(NonSpare):
    cv_arg: TypeAlias = RuleVariation_383.cv_arg
    cv_name = "TID"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_383

    @classmethod
    def create(cls, arg : "NonSpare_1870.cv_arg") -> "NonSpare_1870":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_383:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_391:
        return self.rule.variation

class Item_1003(Item):
    cv_arg: TypeAlias = NonSpare_1870.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1870

    @classmethod
    def create(cls, arg : "Item_1003.cv_arg") -> "Item_1003":
        return cls._create(arg) # type: ignore

class Variation_1223(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_98.cv_arg, Tuple[Literal["STI"], RuleVariation_98.cv_arg]], int, Union[RuleVariation_383.cv_arg, Tuple[Literal["TID"], RuleVariation_383.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_1223.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 56
    cv_items_list = [(Item_955, 2), (Item_15, 6), (Item_1003, 48)]
    cv_items_dict = {"STI": RuleVariation_98, "TID": RuleVariation_383}

    @overload
    @classmethod
    def spec(cls, key : Literal["STI"]) -> Type[RuleVariation_98]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["TID"]) -> Type[RuleVariation_383]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["STI"], Literal["TID"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["STI"]) -> RuleVariation_98:
        ...
    @overload
    def get_item(self, key : Literal["TID"]) -> RuleVariation_383:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1223.cv_arg") -> 'Variation_1223':
        return cls._create(arg) # type: ignore

class RuleVariation_1167(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1223.cv_arg
    cv_variation: TypeAlias = Variation_1223

    @classmethod
    def create(cls, arg : "RuleVariation_1167.cv_arg") -> "RuleVariation_1167":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1223:
        return self.arg # type: ignore

class NonSpare_444(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1167.cv_arg
    cv_name = "245"
    cv_title = "Target Identification"
    cv_rule: TypeAlias = RuleVariation_1167

    @classmethod
    def create(cls, arg : "NonSpare_444.cv_arg") -> "NonSpare_444":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1167:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1223:
        return self.rule.variation

class UapItem_444(UapItem):
    cv_non_spare: TypeAlias = NonSpare_444

class Content_799(ContentBds):
    cv_arg: TypeAlias = int
    cv_bds_type = BdsWithAddress

class RuleContent_798(RuleContentContextFree):
    cv_arg: TypeAlias = Content_799.cv_arg
    cv_content: TypeAlias = Content_799

    @property
    def content(self) -> Content_799:
        return self._get_content() # type: ignore

class Variation_396(Element):
    cv_arg: TypeAlias = RuleContent_798.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 64
    cv_rule = RuleContent_798

    @classmethod
    def create(cls, arg: "Variation_396.cv_arg") -> "Variation_396":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_798:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_799:
        return self.rule.content

class Variation_1413(Repetitive):
    cv_arg: TypeAlias = List[Variation_396.cv_arg]
    cv_rep_bytes = 1
    cv_variation: TypeAlias = Variation_396

    @classmethod
    def create(cls, arg: "Variation_1413.cv_arg") -> 'Variation_1413':
        return cls._create(arg) # type: ignore

    def get_list(self) -> List[Variation_396]:
        return self._get_list() # type: ignore

class RuleVariation_1334(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1413.cv_arg
    cv_variation: TypeAlias = Variation_1413

    @classmethod
    def create(cls, arg : "RuleVariation_1334.cv_arg") -> "RuleVariation_1334":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1413:
        return self.arg # type: ignore

class NonSpare_1236(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1334.cv_arg
    cv_name = "MB"
    cv_title = "BDS"
    cv_rule: TypeAlias = RuleVariation_1334

    @classmethod
    def create(cls, arg : "NonSpare_1236.cv_arg") -> "NonSpare_1236":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1334:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1413:
        return self.rule.variation

class NonSpare_573(NonSpare):
    cv_arg: TypeAlias = RuleVariation_342.cv_arg
    cv_name = "ADR"
    cv_title = "24 Bits Aircraft Address"
    cv_rule: TypeAlias = RuleVariation_342

    @classmethod
    def create(cls, arg : "NonSpare_573.cv_arg") -> "NonSpare_573":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_342:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_349:
        return self.rule.variation

class Content_340(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No communications capability (surveillance only)", 1: "Comm. A and Comm. B capability", 2: "Comm. A, Comm. B and Uplink ELM", 3: "Comm. A, Comm. B, Uplink ELM and Downlink ELM", 4: "Level 5 Transponder capability", 5: "Not assigned", 6: "Not assigned", 7: "Not assigned"}

class RuleContent_340(RuleContentContextFree):
    cv_arg: TypeAlias = Content_340.cv_arg
    cv_content: TypeAlias = Content_340

    @property
    def content(self) -> Content_340:
        return self._get_content() # type: ignore

class Variation_124(Element):
    cv_arg: TypeAlias = RuleContent_340.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 3
    cv_rule = RuleContent_340

    @classmethod
    def create(cls, arg: "Variation_124.cv_arg") -> "Variation_124":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_340:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_340:
        return self.rule.content

class RuleVariation_124(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_124.cv_arg
    cv_variation: TypeAlias = Variation_124

    @classmethod
    def create(cls, arg : "RuleVariation_124.cv_arg") -> "RuleVariation_124":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_124:
        return self.arg # type: ignore

class NonSpare_789(NonSpare):
    cv_arg: TypeAlias = RuleVariation_124.cv_arg
    cv_name = "COM"
    cv_title = "Communications Capability of the Transponder"
    cv_rule: TypeAlias = RuleVariation_124

    @classmethod
    def create(cls, arg : "NonSpare_789.cv_arg") -> "NonSpare_789":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_124:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_124:
        return self.rule.variation

class Item_189(Item):
    cv_arg: TypeAlias = NonSpare_789.cv_arg
    cv_non_spare: TypeAlias = NonSpare_789

    @classmethod
    def create(cls, arg : "Item_189.cv_arg") -> "Item_189":
        return cls._create(arg) # type: ignore

class Content_321(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No alert, no SPI, aircraft airborne", 1: "No alert, no SPI, aircraft on ground", 2: "Alert, no SPI, aircraft airborne", 3: "Alert, no SPI, aircraft on ground", 4: "Alert, SPI, aircraft airborne or on ground", 5: "No alert, SPI, aircraft airborne or on ground", 6: "General Emergency", 7: "Lifeguard / medical", 8: "Minimum fuel", 9: "No communications", 10: "Unlawful"}

class RuleContent_321(RuleContentContextFree):
    cv_arg: TypeAlias = Content_321.cv_arg
    cv_content: TypeAlias = Content_321

    @property
    def content(self) -> Content_321:
        return self._get_content() # type: ignore

class Variation_694(Element):
    cv_arg: TypeAlias = RuleContent_321.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 4
    cv_rule = RuleContent_321

    @classmethod
    def create(cls, arg: "Variation_694.cv_arg") -> "Variation_694":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_321:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_321:
        return self.rule.content

class RuleVariation_683(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_694.cv_arg
    cv_variation: TypeAlias = Variation_694

    @classmethod
    def create(cls, arg : "RuleVariation_683.cv_arg") -> "RuleVariation_683":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_694:
        return self.arg # type: ignore

class NonSpare_1786(NonSpare):
    cv_arg: TypeAlias = RuleVariation_683.cv_arg
    cv_name = "STAT"
    cv_title = "Flight Status"
    cv_rule: TypeAlias = RuleVariation_683

    @classmethod
    def create(cls, arg : "NonSpare_1786.cv_arg") -> "NonSpare_1786":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_683:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_694:
        return self.rule.variation

class Item_944(Item):
    cv_arg: TypeAlias = NonSpare_1786.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1786

    @classmethod
    def create(cls, arg : "Item_944.cv_arg") -> "Item_944":
        return cls._create(arg) # type: ignore

class Content_305(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No", 1: "Yes"}

class RuleContent_305(RuleContentContextFree):
    cv_arg: TypeAlias = Content_305.cv_arg
    cv_content: TypeAlias = Content_305

    @property
    def content(self) -> Content_305:
        return self._get_content() # type: ignore

class Variation_56(Element):
    cv_arg: TypeAlias = RuleContent_305.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_305

    @classmethod
    def create(cls, arg: "Variation_56.cv_arg") -> "Variation_56":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_305:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_305:
        return self.rule.content

class RuleVariation_56(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_56.cv_arg
    cv_variation: TypeAlias = Variation_56

    @classmethod
    def create(cls, arg : "RuleVariation_56.cv_arg") -> "RuleVariation_56":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_56:
        return self.arg # type: ignore

class NonSpare_1763(NonSpare):
    cv_arg: TypeAlias = RuleVariation_56.cv_arg
    cv_name = "SSC"
    cv_title = "Specific Service Capability"
    cv_rule: TypeAlias = RuleVariation_56

    @classmethod
    def create(cls, arg : "NonSpare_1763.cv_arg") -> "NonSpare_1763":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_56:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_56:
        return self.rule.variation

class Item_930(Item):
    cv_arg: TypeAlias = NonSpare_1763.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1763

    @classmethod
    def create(cls, arg : "Item_930.cv_arg") -> "Item_930":
        return cls._create(arg) # type: ignore

class Content_3(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "100 ft resolution", 1: "25 ft resolution"}

class RuleContent_3(RuleContentContextFree):
    cv_arg: TypeAlias = Content_3.cv_arg
    cv_content: TypeAlias = Content_3

    @property
    def content(self) -> Content_3:
        return self._get_content() # type: ignore

class Variation_401(Element):
    cv_arg: TypeAlias = RuleContent_3.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_3

    @classmethod
    def create(cls, arg: "Variation_401.cv_arg") -> "Variation_401":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_3:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_3:
        return self.rule.content

class RuleVariation_390(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_401.cv_arg
    cv_variation: TypeAlias = Variation_401

    @classmethod
    def create(cls, arg : "RuleVariation_390.cv_arg") -> "RuleVariation_390":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_401:
        return self.arg # type: ignore

class NonSpare_628(NonSpare):
    cv_arg: TypeAlias = RuleVariation_390.cv_arg
    cv_name = "ARC"
    cv_title = "Altitude Reporting Capability"
    cv_rule: TypeAlias = RuleVariation_390

    @classmethod
    def create(cls, arg : "NonSpare_628.cv_arg") -> "NonSpare_628":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_390:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_401:
        return self.rule.variation

class Item_81(Item):
    cv_arg: TypeAlias = NonSpare_628.cv_arg
    cv_non_spare: TypeAlias = NonSpare_628

    @classmethod
    def create(cls, arg : "Item_81.cv_arg") -> "Item_81":
        return cls._create(arg) # type: ignore

class Variation_559(Element):
    cv_arg: TypeAlias = RuleContent_305.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_305

    @classmethod
    def create(cls, arg: "Variation_559.cv_arg") -> "Variation_559":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_305:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_305:
        return self.rule.content

class RuleVariation_548(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_559.cv_arg
    cv_variation: TypeAlias = Variation_559

    @classmethod
    def create(cls, arg : "RuleVariation_548.cv_arg") -> "RuleVariation_548":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_559:
        return self.arg # type: ignore

class NonSpare_590(NonSpare):
    cv_arg: TypeAlias = RuleVariation_548.cv_arg
    cv_name = "AIC"
    cv_title = "Aircraft Identification Capability"
    cv_rule: TypeAlias = RuleVariation_548

    @classmethod
    def create(cls, arg : "NonSpare_590.cv_arg") -> "NonSpare_590":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_548:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_559:
        return self.rule.variation

class Item_55(Item):
    cv_arg: TypeAlias = NonSpare_590.cv_arg
    cv_non_spare: TypeAlias = NonSpare_590

    @classmethod
    def create(cls, arg : "Item_55.cv_arg") -> "Item_55":
        return cls._create(arg) # type: ignore

class NonSpare_671(NonSpare):
    cv_arg: TypeAlias = RuleVariation_604.cv_arg
    cv_name = "B1A"
    cv_title = "BDS 1,0 Bit 16"
    cv_rule: TypeAlias = RuleVariation_604

    @classmethod
    def create(cls, arg : "NonSpare_671.cv_arg") -> "NonSpare_671":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_604:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_615:
        return self.rule.variation

class Item_109(Item):
    cv_arg: TypeAlias = NonSpare_671.cv_arg
    cv_non_spare: TypeAlias = NonSpare_671

    @classmethod
    def create(cls, arg : "Item_109.cv_arg") -> "Item_109":
        return cls._create(arg) # type: ignore

class NonSpare_672(NonSpare):
    cv_arg: TypeAlias = RuleVariation_772.cv_arg
    cv_name = "B1B"
    cv_title = "BDS 1,0 Bit 37/40"
    cv_rule: TypeAlias = RuleVariation_772

    @classmethod
    def create(cls, arg : "NonSpare_672.cv_arg") -> "NonSpare_672":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_772:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_802:
        return self.rule.variation

class Item_110(Item):
    cv_arg: TypeAlias = NonSpare_672.cv_arg
    cv_non_spare: TypeAlias = NonSpare_672

    @classmethod
    def create(cls, arg : "Item_110.cv_arg") -> "Item_110":
        return cls._create(arg) # type: ignore

class NonSpare_557(NonSpare):
    cv_arg: TypeAlias = RuleVariation_56.cv_arg
    cv_name = "AC"
    cv_title = "ACAS Operational"
    cv_rule: TypeAlias = RuleVariation_56

    @classmethod
    def create(cls, arg : "NonSpare_557.cv_arg") -> "NonSpare_557":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_56:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_56:
        return self.rule.variation

class Item_37(Item):
    cv_arg: TypeAlias = NonSpare_557.cv_arg
    cv_non_spare: TypeAlias = NonSpare_557

    @classmethod
    def create(cls, arg : "Item_37.cv_arg") -> "Item_37":
        return cls._create(arg) # type: ignore

class Variation_440(Element):
    cv_arg: TypeAlias = RuleContent_305.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_305

    @classmethod
    def create(cls, arg: "Variation_440.cv_arg") -> "Variation_440":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_305:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_305:
        return self.rule.content

class RuleVariation_429(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_440.cv_arg
    cv_variation: TypeAlias = Variation_440

    @classmethod
    def create(cls, arg : "RuleVariation_429.cv_arg") -> "RuleVariation_429":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_440:
        return self.arg # type: ignore

class NonSpare_1301(NonSpare):
    cv_arg: TypeAlias = RuleVariation_429.cv_arg
    cv_name = "MN"
    cv_title = "Multiple Navigational Aids Operating"
    cv_rule: TypeAlias = RuleVariation_429

    @classmethod
    def create(cls, arg : "NonSpare_1301.cv_arg") -> "NonSpare_1301":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_429:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_440:
        return self.rule.variation

class Item_564(Item):
    cv_arg: TypeAlias = NonSpare_1301.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1301

    @classmethod
    def create(cls, arg : "Item_564.cv_arg") -> "Item_564":
        return cls._create(arg) # type: ignore

class Content_572(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Yes", 1: "No"}

class RuleContent_572(RuleContentContextFree):
    cv_arg: TypeAlias = Content_572.cv_arg
    cv_content: TypeAlias = Content_572

    @property
    def content(self) -> Content_572:
        return self._get_content() # type: ignore

class Variation_586(Element):
    cv_arg: TypeAlias = RuleContent_572.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_572

    @classmethod
    def create(cls, arg: "Variation_586.cv_arg") -> "Variation_586":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_572:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_572:
        return self.rule.content

class RuleVariation_575(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_586.cv_arg
    cv_variation: TypeAlias = Variation_586

    @classmethod
    def create(cls, arg : "RuleVariation_575.cv_arg") -> "RuleVariation_575":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_586:
        return self.arg # type: ignore

class NonSpare_877(NonSpare):
    cv_arg: TypeAlias = RuleVariation_575.cv_arg
    cv_name = "DC"
    cv_title = "Differential Correction"
    cv_rule: TypeAlias = RuleVariation_575

    @classmethod
    def create(cls, arg : "NonSpare_877.cv_arg") -> "NonSpare_877":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_575:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_586:
        return self.rule.variation

class Item_252(Item):
    cv_arg: TypeAlias = NonSpare_877.cv_arg
    cv_non_spare: TypeAlias = NonSpare_877

    @classmethod
    def create(cls, arg : "Item_252.cv_arg") -> "Item_252":
        return cls._create(arg) # type: ignore

class Item_19(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 3
    cv_bit_size = 5

class Variation_1083(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_124.cv_arg, Tuple[Literal["COM"], RuleVariation_124.cv_arg]], Union[RuleVariation_683.cv_arg, Tuple[Literal["STAT"], RuleVariation_683.cv_arg]], int, Union[RuleVariation_56.cv_arg, Tuple[Literal["SSC"], RuleVariation_56.cv_arg]], Union[RuleVariation_390.cv_arg, Tuple[Literal["ARC"], RuleVariation_390.cv_arg]], Union[RuleVariation_548.cv_arg, Tuple[Literal["AIC"], RuleVariation_548.cv_arg]], Union[RuleVariation_604.cv_arg, Tuple[Literal["B1A"], RuleVariation_604.cv_arg]], Union[RuleVariation_772.cv_arg, Tuple[Literal["B1B"], RuleVariation_772.cv_arg]], Union[RuleVariation_56.cv_arg, Tuple[Literal["AC"], RuleVariation_56.cv_arg]], Union[RuleVariation_429.cv_arg, Tuple[Literal["MN"], RuleVariation_429.cv_arg]], Union[RuleVariation_575.cv_arg, Tuple[Literal["DC"], RuleVariation_575.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1083.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 24
    cv_items_list = [(Item_189, 3), (Item_944, 4), (Item_29, 1), (Item_930, 1), (Item_81, 1), (Item_55, 1), (Item_109, 1), (Item_110, 4), (Item_37, 1), (Item_564, 1), (Item_252, 1), (Item_19, 5)]
    cv_items_dict = {"COM": RuleVariation_124, "STAT": RuleVariation_683, "SSC": RuleVariation_56, "ARC": RuleVariation_390, "AIC": RuleVariation_548, "B1A": RuleVariation_604, "B1B": RuleVariation_772, "AC": RuleVariation_56, "MN": RuleVariation_429, "DC": RuleVariation_575}

    @overload
    @classmethod
    def spec(cls, key : Literal["COM"]) -> Type[RuleVariation_124]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["STAT"]) -> Type[RuleVariation_683]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["SSC"]) -> Type[RuleVariation_56]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ARC"]) -> Type[RuleVariation_390]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AIC"]) -> Type[RuleVariation_548]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["B1A"]) -> Type[RuleVariation_604]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["B1B"]) -> Type[RuleVariation_772]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AC"]) -> Type[RuleVariation_56]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MN"]) -> Type[RuleVariation_429]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["DC"]) -> Type[RuleVariation_575]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["COM"], Literal["STAT"], Literal["SSC"], Literal["ARC"], Literal["AIC"], Literal["B1A"], Literal["B1B"], Literal["AC"], Literal["MN"], Literal["DC"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["COM"]) -> RuleVariation_124:
        ...
    @overload
    def get_item(self, key : Literal["STAT"]) -> RuleVariation_683:
        ...
    @overload
    def get_item(self, key : Literal["SSC"]) -> RuleVariation_56:
        ...
    @overload
    def get_item(self, key : Literal["ARC"]) -> RuleVariation_390:
        ...
    @overload
    def get_item(self, key : Literal["AIC"]) -> RuleVariation_548:
        ...
    @overload
    def get_item(self, key : Literal["B1A"]) -> RuleVariation_604:
        ...
    @overload
    def get_item(self, key : Literal["B1B"]) -> RuleVariation_772:
        ...
    @overload
    def get_item(self, key : Literal["AC"]) -> RuleVariation_56:
        ...
    @overload
    def get_item(self, key : Literal["MN"]) -> RuleVariation_429:
        ...
    @overload
    def get_item(self, key : Literal["DC"]) -> RuleVariation_575:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1083.cv_arg") -> 'Variation_1083':
        return cls._create(arg) # type: ignore

class RuleVariation_1043(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1083.cv_arg
    cv_variation: TypeAlias = Variation_1083

    @classmethod
    def create(cls, arg : "RuleVariation_1043.cv_arg") -> "RuleVariation_1043":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1083:
        return self.arg # type: ignore

class NonSpare_793(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1043.cv_arg
    cv_name = "COMACAS"
    cv_title = "Communications/ACAS Capability and Flight Status"
    cv_rule: TypeAlias = RuleVariation_1043

    @classmethod
    def create(cls, arg : "NonSpare_793.cv_arg") -> "NonSpare_793":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1043:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1083:
        return self.rule.variation

class Variation_374(Element):
    cv_arg: TypeAlias = RuleContent_610.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 32
    cv_rule = RuleContent_610

    @classmethod
    def create(cls, arg: "Variation_374.cv_arg") -> "Variation_374":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_610:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_610:
        return self.rule.content

class RuleVariation_367(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_374.cv_arg
    cv_variation: TypeAlias = Variation_374

    @classmethod
    def create(cls, arg : "RuleVariation_367.cv_arg") -> "RuleVariation_367":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_374:
        return self.arg # type: ignore

class NonSpare_568(NonSpare):
    cv_arg: TypeAlias = RuleVariation_367.cv_arg
    cv_name = "ACT"
    cv_title = "Aircraft Derived Aircraft Type"
    cv_rule: TypeAlias = RuleVariation_367

    @classmethod
    def create(cls, arg : "NonSpare_568.cv_arg") -> "NonSpare_568":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_367:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_374:
        return self.rule.variation

class Content_582(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {1: "Light aircraft <= 7000 kg", 2: "Reserved", 3: "7000 kg &lt; medium aircraft &lt; 136000 kg", 4: "Reserved", 5: "136000 kg <= heavy aircraft", 6: "Highly manoeuvrable (5g acceleration capability) and high speed (&gt;400 knots cruise)", 7: "Reserved", 8: "Reserved", 9: "Reserved", 10: "Rotocraft", 11: "Glider / sailplane", 12: "Lighter-than-air", 13: "Unmanned aerial vehicle", 14: "Space / transatmospheric vehicle", 15: "Ultralight / handglider / paraglider", 16: "Parachutist / skydiver", 17: "Reserved", 18: "Reserved", 19: "Reserved", 20: "Surface emergency vehicle", 21: "Surface service vehicle", 22: "Fixed ground or tethered obstruction", 23: "Reserved", 24: "Reserved"}

class RuleContent_582(RuleContentContextFree):
    cv_arg: TypeAlias = Content_582.cv_arg
    cv_content: TypeAlias = Content_582

    @property
    def content(self) -> Content_582:
        return self._get_content() # type: ignore

class Variation_183(Element):
    cv_arg: TypeAlias = RuleContent_582.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_rule = RuleContent_582

    @classmethod
    def create(cls, arg: "Variation_183.cv_arg") -> "Variation_183":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_582:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_582:
        return self.rule.content

class RuleVariation_176(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_183.cv_arg
    cv_variation: TypeAlias = Variation_183

    @classmethod
    def create(cls, arg : "RuleVariation_176.cv_arg") -> "RuleVariation_176":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_183:
        return self.arg # type: ignore

class NonSpare_924(NonSpare):
    cv_arg: TypeAlias = RuleVariation_176.cv_arg
    cv_name = "ECAT"
    cv_title = "Emitter Category"
    cv_rule: TypeAlias = RuleVariation_176

    @classmethod
    def create(cls, arg : "NonSpare_924.cv_arg") -> "NonSpare_924":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_176:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_183:
        return self.rule.variation

class Content_556(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "VDL Mode 4 available", 1: "VDL Mode 4 not available"}

class RuleContent_556(RuleContentContextFree):
    cv_arg: TypeAlias = Content_556.cv_arg
    cv_content: TypeAlias = Content_556

    @property
    def content(self) -> Content_556:
        return self._get_content() # type: ignore

class Variation_95(Element):
    cv_arg: TypeAlias = RuleContent_556.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_556

    @classmethod
    def create(cls, arg: "Variation_95.cv_arg") -> "Variation_95":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_556:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_556:
        return self.rule.content

class RuleVariation_95(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_95.cv_arg
    cv_variation: TypeAlias = Variation_95

    @classmethod
    def create(cls, arg : "RuleVariation_95.cv_arg") -> "RuleVariation_95":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_95:
        return self.arg # type: ignore

class NonSpare_2041(NonSpare):
    cv_arg: TypeAlias = RuleVariation_95.cv_arg
    cv_name = "VDL"
    cv_title = "VDL Mode 4"
    cv_rule: TypeAlias = RuleVariation_95

    @classmethod
    def create(cls, arg : "NonSpare_2041.cv_arg") -> "NonSpare_2041":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_95:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_95:
        return self.rule.variation

class Item_1146(Item):
    cv_arg: TypeAlias = NonSpare_2041.cv_arg
    cv_non_spare: TypeAlias = NonSpare_2041

    @classmethod
    def create(cls, arg : "Item_1146.cv_arg") -> "Item_1146":
        return cls._create(arg) # type: ignore

class Content_283(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Mode S available", 1: "Mode S not available"}

class RuleContent_283(RuleContentContextFree):
    cv_arg: TypeAlias = Content_283.cv_arg
    cv_content: TypeAlias = Content_283

    @property
    def content(self) -> Content_283:
        return self._get_content() # type: ignore

class Variation_438(Element):
    cv_arg: TypeAlias = RuleContent_283.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_283

    @classmethod
    def create(cls, arg: "Variation_438.cv_arg") -> "Variation_438":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_283:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_283:
        return self.rule.content

class RuleVariation_427(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_438.cv_arg
    cv_variation: TypeAlias = Variation_438

    @classmethod
    def create(cls, arg : "RuleVariation_427.cv_arg") -> "RuleVariation_427":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_438:
        return self.arg # type: ignore

class NonSpare_1265(NonSpare):
    cv_arg: TypeAlias = RuleVariation_427.cv_arg
    cv_name = "MDS"
    cv_title = "Mode S"
    cv_rule: TypeAlias = RuleVariation_427

    @classmethod
    def create(cls, arg : "NonSpare_1265.cv_arg") -> "NonSpare_1265":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_427:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_438:
        return self.rule.variation

class Item_543(Item):
    cv_arg: TypeAlias = NonSpare_1265.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1265

    @classmethod
    def create(cls, arg : "Item_543.cv_arg") -> "Item_543":
        return cls._create(arg) # type: ignore

class Content_529(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "UAT available", 1: "UAT not available"}

class RuleContent_529(RuleContentContextFree):
    cv_arg: TypeAlias = Content_529.cv_arg
    cv_content: TypeAlias = Content_529

    @property
    def content(self) -> Content_529:
        return self._get_content() # type: ignore

class Variation_584(Element):
    cv_arg: TypeAlias = RuleContent_529.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_529

    @classmethod
    def create(cls, arg: "Variation_584.cv_arg") -> "Variation_584":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_529:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_529:
        return self.rule.content

class RuleVariation_573(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_584.cv_arg
    cv_variation: TypeAlias = Variation_584

    @classmethod
    def create(cls, arg : "RuleVariation_573.cv_arg") -> "RuleVariation_573":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_584:
        return self.arg # type: ignore

class NonSpare_1987(NonSpare):
    cv_arg: TypeAlias = RuleVariation_573.cv_arg
    cv_name = "UAT"
    cv_title = "UAT"
    cv_rule: TypeAlias = RuleVariation_573

    @classmethod
    def create(cls, arg : "NonSpare_1987.cv_arg") -> "NonSpare_1987":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_573:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_584:
        return self.rule.variation

class Item_1095(Item):
    cv_arg: TypeAlias = NonSpare_1987.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1987

    @classmethod
    def create(cls, arg : "Item_1095.cv_arg") -> "Item_1095":
        return cls._create(arg) # type: ignore

class Variation_1285(Group):
    cv_arg_group: TypeAlias = Tuple[Union[RuleVariation_95.cv_arg, Tuple[Literal["VDL"], RuleVariation_95.cv_arg]], Union[RuleVariation_427.cv_arg, Tuple[Literal["MDS"], RuleVariation_427.cv_arg]], Union[RuleVariation_573.cv_arg, Tuple[Literal["UAT"], RuleVariation_573.cv_arg]], int]
    cv_arg: TypeAlias = Union[int, "Variation_1285.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 8
    cv_items_list = [(Item_1146, 1), (Item_543, 1), (Item_1095, 1), (Item_19, 5)]
    cv_items_dict = {"VDL": RuleVariation_95, "MDS": RuleVariation_427, "UAT": RuleVariation_573}

    @overload
    @classmethod
    def spec(cls, key : Literal["VDL"]) -> Type[RuleVariation_95]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["MDS"]) -> Type[RuleVariation_427]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["UAT"]) -> Type[RuleVariation_573]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["VDL"], Literal["MDS"], Literal["UAT"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["VDL"]) -> RuleVariation_95:
        ...
    @overload
    def get_item(self, key : Literal["MDS"]) -> RuleVariation_427:
        ...
    @overload
    def get_item(self, key : Literal["UAT"]) -> RuleVariation_573:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @classmethod
    def create(cls, arg: "Variation_1285.cv_arg") -> 'Variation_1285':
        return cls._create(arg) # type: ignore

class RuleVariation_1214(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1285.cv_arg
    cv_variation: TypeAlias = Variation_1285

    @classmethod
    def create(cls, arg : "RuleVariation_1214.cv_arg") -> "RuleVariation_1214":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1285:
        return self.arg # type: ignore

class NonSpare_656(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1214.cv_arg
    cv_name = "AVTECH"
    cv_title = "Available Technologies"
    cv_rule: TypeAlias = RuleVariation_1214

    @classmethod
    def create(cls, arg : "NonSpare_656.cv_arg") -> "NonSpare_656":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1214:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1285:
        return self.rule.variation

class Variation_1503(Compound):
    cv_arg = TypedDict('cv_arg', {
        "MB": NonSpare_1236.cv_arg,
        "ADR": NonSpare_573.cv_arg,
        "COMACAS": NonSpare_793.cv_arg,
        "ACT": NonSpare_568.cv_arg,
        "ECAT": NonSpare_924.cv_arg,
        "AVTECH": NonSpare_656.cv_arg,
    }, total=False)
    cv_fspec_max_bytes = 2
    cv_items_list = [NonSpare_1236, NonSpare_573, None, NonSpare_793, None, None, None, NonSpare_568, NonSpare_924, None, NonSpare_656]
    cv_items_dict = {"MB": NonSpare_1236, "ADR": NonSpare_573, "COMACAS": NonSpare_793, "ACT": NonSpare_568, "ECAT": NonSpare_924, "AVTECH": NonSpare_656}

    @overload
    @classmethod
    def spec(cls, key : Literal["MB"]) -> Type[NonSpare_1236]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ADR"]) -> Type[NonSpare_573]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["COMACAS"]) -> Type[NonSpare_793]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ACT"]) -> Type[NonSpare_568]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["ECAT"]) -> Type[NonSpare_924]:
        ...
    @overload
    @classmethod
    def spec(cls, key : Literal["AVTECH"]) -> Type[NonSpare_656]:
        ...
    @classmethod
    def spec(cls, key : Union[Literal["MB"], Literal["ADR"], Literal["COMACAS"], Literal["ACT"], Literal["ECAT"], Literal["AVTECH"]]) -> Any:
        return cls._spec(key)

    @overload
    def get_item(self, key : Literal["MB"]) -> Optional[NonSpare_1236]:
        ...
    @overload
    def get_item(self, key : Literal["ADR"]) -> Optional[NonSpare_573]:
        ...
    @overload
    def get_item(self, key : Literal["COMACAS"]) -> Optional[NonSpare_793]:
        ...
    @overload
    def get_item(self, key : Literal["ACT"]) -> Optional[NonSpare_568]:
        ...
    @overload
    def get_item(self, key : Literal["ECAT"]) -> Optional[NonSpare_924]:
        ...
    @overload
    def get_item(self, key : Literal["AVTECH"]) -> Optional[NonSpare_656]:
        ...
    def get_item(self, key : Any) -> Any:
        return self._get_item(key)

    @overload
    def set_item(self, key : Literal["MB"], val : NonSpare_1236.cv_arg) -> "Variation_1503":
        ...
    @overload
    def set_item(self, key : Literal["ADR"], val : NonSpare_573.cv_arg) -> "Variation_1503":
        ...
    @overload
    def set_item(self, key : Literal["COMACAS"], val : NonSpare_793.cv_arg) -> "Variation_1503":
        ...
    @overload
    def set_item(self, key : Literal["ACT"], val : NonSpare_568.cv_arg) -> "Variation_1503":
        ...
    @overload
    def set_item(self, key : Literal["ECAT"], val : NonSpare_924.cv_arg) -> "Variation_1503":
        ...
    @overload
    def set_item(self, key : Literal["AVTECH"], val : NonSpare_656.cv_arg) -> "Variation_1503":
        ...
    def set_item(self, key : Any, val : Any) -> Any:
        return self._set_item(key, val)

    @overload
    def del_item(self, key : Literal["MB"]) -> "Variation_1503":
        ...
    @overload
    def del_item(self, key : Literal["ADR"]) -> "Variation_1503":
        ...
    @overload
    def del_item(self, key : Literal["COMACAS"]) -> "Variation_1503":
        ...
    @overload
    def del_item(self, key : Literal["ACT"]) -> "Variation_1503":
        ...
    @overload
    def del_item(self, key : Literal["ECAT"]) -> "Variation_1503":
        ...
    @overload
    def del_item(self, key : Literal["AVTECH"]) -> "Variation_1503":
        ...
    def del_item(self, key : Any) -> Any:
        return self._del_item(key)

    @classmethod
    def create(cls, arg: "Variation_1503.cv_arg") -> 'Variation_1503':
        return cls._create(arg) # type: ignore

class RuleVariation_1424(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_1503.cv_arg
    cv_variation: TypeAlias = Variation_1503

    @classmethod
    def create(cls, arg : "RuleVariation_1424.cv_arg") -> "RuleVariation_1424":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_1503:
        return self.arg # type: ignore

class NonSpare_491(NonSpare):
    cv_arg: TypeAlias = RuleVariation_1424.cv_arg
    cv_name = "380"
    cv_title = "Mode-S / ADS-B Related Data"
    cv_rule: TypeAlias = RuleVariation_1424

    @classmethod
    def create(cls, arg : "NonSpare_491.cv_arg") -> "NonSpare_491":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_1424:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_1503:
        return self.rule.variation

class UapItem_491(UapItem):
    cv_non_spare: TypeAlias = NonSpare_491

class Item_0(Spare):
    cv_arg: TypeAlias = int
    cv_bit_offset8 = 0
    cv_bit_size = 1

class Variation_500(Element):
    cv_arg: TypeAlias = RuleContent_0.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 15
    cv_rule = RuleContent_0

    @classmethod
    def create(cls, arg: "Variation_500.cv_arg") -> "Variation_500":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_0:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_0:
        return self.rule.content

class RuleVariation_489(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_500.cv_arg
    cv_variation: TypeAlias = Variation_500

    @classmethod
    def create(cls, arg : "RuleVariation_489.cv_arg") -> "RuleVariation_489":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_500:
        return self.arg # type: ignore

class NonSpare_1011(NonSpare):
    cv_arg: TypeAlias = RuleVariation_489.cv_arg
    cv_name = "FTN"
    cv_title = "Fusion Track Number"
    cv_rule: TypeAlias = RuleVariation_489

    @classmethod
    def create(cls, arg : "NonSpare_1011.cv_arg") -> "NonSpare_1011":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_489:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_500:
        return self.rule.variation

class Item_354(Item):
    cv_arg: TypeAlias = NonSpare_1011.cv_arg
    cv_non_spare: TypeAlias = NonSpare_1011

    @classmethod
    def create(cls, arg : "Item_354.cv_arg") -> "Item_354":
        return cls._create(arg) # type: ignore

class Variation_998(Group):
    cv_arg_group: TypeAlias = Tuple[int, Union[RuleVariation_489.cv_arg, Tuple[Literal["FTN"], RuleVariation_489.cv_arg]]]
    cv_arg: TypeAlias = Union[int, "Variation_998.cv_arg_group"]
    cv_bit_offset8 = 0
    cv_bit_size = 16
    cv_items_list = [(Item_0, 1), (Item_354, 15)]
    cv_items_dict = {"FTN": RuleVariation_489}

    @classmethod
    def spec(cls, key : Literal["FTN"]) -> Type[RuleVariation_489]:
        return cls._spec(arg) # type: ignore

    def get_item(self, key : Literal["FTN"]) -> RuleVariation_489:
        return self._get_item(key) # type: ignore

    @classmethod
    def create(cls, arg:"Variation_998.cv_arg") -> 'Variation_998':
        return cls._create(arg) # type: ignore

class RuleVariation_968(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_998.cv_arg
    cv_variation: TypeAlias = Variation_998

    @classmethod
    def create(cls, arg : "RuleVariation_968.cv_arg") -> "RuleVariation_968":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_998:
        return self.arg # type: ignore

class NonSpare_362(NonSpare):
    cv_arg: TypeAlias = RuleVariation_968.cv_arg
    cv_name = "161"
    cv_title = "Track Number"
    cv_rule: TypeAlias = RuleVariation_968

    @classmethod
    def create(cls, arg : "NonSpare_362.cv_arg") -> "NonSpare_362":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleVariation_968:
        return self.arg # type: ignore

    # shortcut to variation
    @property
    def variation(self) -> Variation_998:
        return self.rule.variation

class UapItem_362(UapItem):
    cv_non_spare: TypeAlias = NonSpare_362

class Content_299(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Multisensor Track", 1: "Monosensor Track"}

class RuleContent_299(RuleContentContextFree):
    cv_arg: TypeAlias = Content_299.cv_arg
    cv_content: TypeAlias = Content_299

    @property
    def content(self) -> Content_299:
        return self._get_content() # type: ignore

class Variation_54(Element):
    cv_arg: TypeAlias = RuleContent_299.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_299

    @classmethod
    def create(cls, arg: "Variation_54.cv_arg") -> "Variation_54":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_299:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_299:
        return self.rule.content

class RuleVariation_54(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_54.cv_arg
    cv_variation: TypeAlias = Variation_54

    @classmethod
    def create(cls, arg : "RuleVariation_54.cv_arg") -> "RuleVariation_54":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_54:
        return self.arg # type: ignore

class Content_523(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Transponder Ground bit not set or unknown", 1: "Transponder Ground bit set"}

class RuleContent_523(RuleContentContextFree):
    cv_arg: TypeAlias = Content_523.cv_arg
    cv_content: TypeAlias = Content_523

    @property
    def content(self) -> Content_523:
        return self._get_content() # type: ignore

class Variation_462(Element):
    cv_arg: TypeAlias = RuleContent_523.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_523

    @classmethod
    def create(cls, arg: "Variation_462.cv_arg") -> "Variation_462":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_523:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_523:
        return self.rule.content

class RuleVariation_451(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_462.cv_arg
    cv_variation: TypeAlias = Variation_462

    @classmethod
    def create(cls, arg : "RuleVariation_451.cv_arg") -> "RuleVariation_451":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_462:
        return self.arg # type: ignore

class Content_46(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Barometric altitude (Mode C) more reliable", 1: "Geometric altitude more reliable"}

class RuleContent_46(RuleContentContextFree):
    cv_arg: TypeAlias = Content_46.cv_arg
    cv_content: TypeAlias = Content_46

    @property
    def content(self) -> Content_46:
        return self._get_content() # type: ignore

class Variation_512(Element):
    cv_arg: TypeAlias = RuleContent_46.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_46

    @classmethod
    def create(cls, arg: "Variation_512.cv_arg") -> "Variation_512":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_46:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_46:
        return self.rule.content

class RuleVariation_501(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_512.cv_arg
    cv_variation: TypeAlias = Variation_512

    @classmethod
    def create(cls, arg : "RuleVariation_501.cv_arg") -> "RuleVariation_501":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_512:
        return self.arg # type: ignore

class Content_373(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No source", 1: "GPS", 2: "3d radar", 3: "Triangulation", 4: "Height from coverage", 5: "Speed look-up table", 6: "Default height", 7: "Multilateration"}

class RuleContent_373(RuleContentContextFree):
    cv_arg: TypeAlias = Content_373.cv_arg
    cv_content: TypeAlias = Content_373

    @property
    def content(self) -> Content_373:
        return self._get_content() # type: ignore

class Variation_692(Element):
    cv_arg: TypeAlias = RuleContent_373.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 3
    cv_rule = RuleContent_373

    @classmethod
    def create(cls, arg: "Variation_692.cv_arg") -> "Variation_692":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_373:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_373:
        return self.rule.content

class RuleVariation_681(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_692.cv_arg
    cv_variation: TypeAlias = Variation_692

    @classmethod
    def create(cls, arg : "RuleVariation_681.cv_arg") -> "RuleVariation_681":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_692:
        return self.arg # type: ignore

class Content_63(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Confirmed track", 1: "Tentative track"}

class RuleContent_63(RuleContentContextFree):
    cv_arg: TypeAlias = Content_63.cv_arg
    cv_content: TypeAlias = Content_63

    @property
    def content(self) -> Content_63:
        return self._get_content() # type: ignore

class Variation_910(Element):
    cv_arg: TypeAlias = RuleContent_63.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_63

    @classmethod
    def create(cls, arg: "Variation_910.cv_arg") -> "Variation_910":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_63:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_63:
        return self.rule.content

class RuleVariation_880(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_910.cv_arg
    cv_variation: TypeAlias = Variation_910

    @classmethod
    def create(cls, arg : "RuleVariation_880.cv_arg") -> "RuleVariation_880":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_910:
        return self.arg # type: ignore

class Content_18(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Actual Track", 1: "Simulated track"}

class RuleContent_18(RuleContentContextFree):
    cv_arg: TypeAlias = Content_18.cv_arg
    cv_content: TypeAlias = Content_18

    @property
    def content(self) -> Content_18:
        return self._get_content() # type: ignore

class Variation_4(Element):
    cv_arg: TypeAlias = RuleContent_18.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_18

    @classmethod
    def create(cls, arg: "Variation_4.cv_arg") -> "Variation_4":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_18:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_18:
        return self.rule.content

class RuleVariation_4(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_4.cv_arg
    cv_variation: TypeAlias = Variation_4

    @classmethod
    def create(cls, arg : "RuleVariation_4.cv_arg") -> "RuleVariation_4":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_4:
        return self.arg # type: ignore

class Content_197(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Track service end (i.e. last message transmitted to the user for the track)"}

class RuleContent_197(RuleContentContextFree):
    cv_arg: TypeAlias = Content_197.cv_arg
    cv_content: TypeAlias = Content_197

    @property
    def content(self) -> Content_197:
        return self._get_content() # type: ignore

class Variation_424(Element):
    cv_arg: TypeAlias = RuleContent_197.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_197

    @classmethod
    def create(cls, arg: "Variation_424.cv_arg") -> "Variation_424":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_197:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_197:
        return self.rule.content

class RuleVariation_413(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_424.cv_arg
    cv_variation: TypeAlias = Variation_424

    @classmethod
    def create(cls, arg : "RuleVariation_413.cv_arg") -> "RuleVariation_413":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_424:
        return self.arg # type: ignore

class Content_196(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Track service begin (i.e. first message transmitted to the user for the track)"}

class RuleContent_196(RuleContentContextFree):
    cv_arg: TypeAlias = Content_196.cv_arg
    cv_content: TypeAlias = Content_196

    @property
    def content(self) -> Content_196:
        return self._get_content() # type: ignore

class Variation_533(Element):
    cv_arg: TypeAlias = RuleContent_196.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_196

    @classmethod
    def create(cls, arg: "Variation_533.cv_arg") -> "Variation_533":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_196:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_196:
        return self.rule.content

class RuleVariation_522(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_533.cv_arg
    cv_variation: TypeAlias = Variation_533

    @classmethod
    def create(cls, arg : "RuleVariation_522.cv_arg") -> "RuleVariation_522":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_533:
        return self.arg # type: ignore

class Content_312(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "No Mode 4 interrogationt", 1: "Friendly target", 2: "Unknown target", 3: "No reply"}

class RuleContent_312(RuleContentContextFree):
    cv_arg: TypeAlias = Content_312.cv_arg
    cv_content: TypeAlias = Content_312

    @property
    def content(self) -> Content_312:
        return self._get_content() # type: ignore

class Variation_680(Element):
    cv_arg: TypeAlias = RuleContent_312.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 2
    cv_rule = RuleContent_312

    @classmethod
    def create(cls, arg: "Variation_680.cv_arg") -> "Variation_680":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_312:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_312:
        return self.rule.content

class RuleVariation_669(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_680.cv_arg
    cv_variation: TypeAlias = Variation_680

    @classmethod
    def create(cls, arg : "RuleVariation_669.cv_arg") -> "RuleVariation_669":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_680:
        return self.arg # type: ignore

class Content_189(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Military Emergency present in the last report received from a sensor capable of decoding this data"}

class RuleContent_189(RuleContentContextFree):
    cv_arg: TypeAlias = Content_189.cv_arg
    cv_content: TypeAlias = Content_189

    @property
    def content(self) -> Content_189:
        return self._get_content() # type: ignore

class Variation_848(Element):
    cv_arg: TypeAlias = RuleContent_189.cv_arg
    cv_bit_offset8 = 5
    cv_bit_size = 1
    cv_rule = RuleContent_189

    @classmethod
    def create(cls, arg: "Variation_848.cv_arg") -> "Variation_848":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_189:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_189:
        return self.rule.content

class RuleVariation_818(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_848.cv_arg
    cv_variation: TypeAlias = Variation_848

    @classmethod
    def create(cls, arg : "RuleVariation_818.cv_arg") -> "RuleVariation_818":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_848:
        return self.arg # type: ignore

class Content_210(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "End of Data Item", 1: "Military Identification present in the last report received from a sensor capable of decoding this data"}

class RuleContent_210(RuleContentContextFree):
    cv_arg: TypeAlias = Content_210.cv_arg
    cv_content: TypeAlias = Content_210

    @property
    def content(self) -> Content_210:
        return self._get_content() # type: ignore

class Variation_929(Element):
    cv_arg: TypeAlias = RuleContent_210.cv_arg
    cv_bit_offset8 = 6
    cv_bit_size = 1
    cv_rule = RuleContent_210

    @classmethod
    def create(cls, arg: "Variation_929.cv_arg") -> "Variation_929":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_210:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_210:
        return self.rule.content

class RuleVariation_899(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_929.cv_arg
    cv_variation: TypeAlias = Variation_929

    @classmethod
    def create(cls, arg : "RuleVariation_899.cv_arg") -> "RuleVariation_899":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_929:
        return self.arg # type: ignore

class Content_514(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Track not resulting from amalgamation process", 1: "Track resulting from amalgamation process"}

class RuleContent_514(RuleContentContextFree):
    cv_arg: TypeAlias = Content_514.cv_arg
    cv_content: TypeAlias = Content_514

    @property
    def content(self) -> Content_514:
        return self._get_content() # type: ignore

class Variation_90(Element):
    cv_arg: TypeAlias = RuleContent_514.cv_arg
    cv_bit_offset8 = 0
    cv_bit_size = 1
    cv_rule = RuleContent_514

    @classmethod
    def create(cls, arg: "Variation_90.cv_arg") -> "Variation_90":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_514:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_514:
        return self.rule.content

class RuleVariation_90(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_90.cv_arg
    cv_variation: TypeAlias = Variation_90

    @classmethod
    def create(cls, arg : "RuleVariation_90.cv_arg") -> "RuleVariation_90":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_90:
        return self.arg # type: ignore

class Content_191(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "SPI present in the last report received from a sensor capable of decoding this data"}

class RuleContent_191(RuleContentContextFree):
    cv_arg: TypeAlias = Content_191.cv_arg
    cv_content: TypeAlias = Content_191

    @property
    def content(self) -> Content_191:
        return self._get_content() # type: ignore

class Variation_423(Element):
    cv_arg: TypeAlias = RuleContent_191.cv_arg
    cv_bit_offset8 = 1
    cv_bit_size = 1
    cv_rule = RuleContent_191

    @classmethod
    def create(cls, arg: "Variation_423.cv_arg") -> "Variation_423":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_191:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_191:
        return self.rule.content

class RuleVariation_412(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_423.cv_arg
    cv_variation: TypeAlias = Variation_423

    @classmethod
    def create(cls, arg : "RuleVariation_412.cv_arg") -> "RuleVariation_412":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_423:
        return self.arg # type: ignore

class Content_180(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "Age of the last received track update is higher than system dependent threshold (coasting)"}

class RuleContent_180(RuleContentContextFree):
    cv_arg: TypeAlias = Content_180.cv_arg
    cv_content: TypeAlias = Content_180

    @property
    def content(self) -> Content_180:
        return self._get_content() # type: ignore

class Variation_530(Element):
    cv_arg: TypeAlias = RuleContent_180.cv_arg
    cv_bit_offset8 = 2
    cv_bit_size = 1
    cv_rule = RuleContent_180

    @classmethod
    def create(cls, arg: "Variation_530.cv_arg") -> "Variation_530":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_180:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_180:
        return self.rule.content

class RuleVariation_519(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_530.cv_arg
    cv_variation: TypeAlias = Variation_530

    @classmethod
    def create(cls, arg : "RuleVariation_519.cv_arg") -> "RuleVariation_519":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_530:
        return self.arg # type: ignore

class Content_400(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Not flight-plan correlated", 1: "Flight plan correlated"}

class RuleContent_400(RuleContentContextFree):
    cv_arg: TypeAlias = Content_400.cv_arg
    cv_content: TypeAlias = Content_400

    @property
    def content(self) -> Content_400:
        return self._get_content() # type: ignore

class Variation_659(Element):
    cv_arg: TypeAlias = RuleContent_400.cv_arg
    cv_bit_offset8 = 3
    cv_bit_size = 1
    cv_rule = RuleContent_400

    @classmethod
    def create(cls, arg: "Variation_659.cv_arg") -> "Variation_659":
        return cls._create(arg) # type: ignore

    @property
    def rule(self) -> RuleContent_400:
        return self._get_rule() # type: ignore

    # shortcut
    @property
    def content(self) -> Content_400:
        return self.rule.content

class RuleVariation_648(RuleVariationContextFree):
    cv_arg: TypeAlias = Variation_659.cv_arg
    cv_variation: TypeAlias = Variation_659

    @classmethod
    def create(cls, arg : "RuleVariation_648.cv_arg") -> "RuleVariation_648":
        return cls._create(arg) # type: ignore

    @property
    def variation(self) -> Variation_659:
        return self.arg # type: ignore

class Content_173(ContentTable):
    cv_arg: TypeAlias = int
    cv_values = {0: "Default value", 1: "ADS-B data inconsistent with other surveillance information"}

class RuleContent_173(RuleContentContextFree):
    cv_arg: TypeAlias = Content_173.cv_arg
    cv_content: TypeAlias = Content_173

    @property
    def content(self) -> Content_173:
        return self._get_content() # type: ignore

class Variation_718(Element):
    cv_a