# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OceanArgs', 'Ocean']

@pulumi.input_type
class OceanArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 image_id: pulumi.Input[_builtins.str],
                 region: pulumi.Input[_builtins.str],
                 security_group_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 subnet_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaler: Optional[pulumi.Input['OceanAutoscalerArgs']] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input['OceanFiltersArgs']] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input['OceanLoggingArgs']] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimize_images: Optional[pulumi.Input['OceanOptimizeImagesArgs']] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanUpdatePolicyArgs']] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Ocean resource.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the ECS cluster.
        :param pulumi.Input[_builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[_builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more security group ids.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input['OceanAutoscalerArgs'] autoscaler: Describes the Ocean ECS autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]] block_device_mappings: Object. List of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[_builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[_builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[_builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input['OceanInstanceMetadataOptionsArgs'] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[_builtins.str] key_pair: The key pair to attach the instances.
        :param pulumi.Input['OceanLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[_builtins.str] name: The Ocean cluster name.
        :param pulumi.Input['OceanOptimizeImagesArgs'] optimize_images: Object. Set auto image update settings.
        :param pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]] scheduled_tasks: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[_builtins.int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input['OceanUpdatePolicyArgs'] update_policy: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[_builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[_builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[_builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "subnet_ids", subnet_ids)
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if blacklists is not None:
            pulumi.set(__self__, "blacklists", blacklists)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if cluster_orientations is not None:
            pulumi.set(__self__, "cluster_orientations", cluster_orientations)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimize_images is not None:
            pulumi.set(__self__, "optimize_images", optimize_images)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if use_as_template_only is not None:
            pulumi.set(__self__, "use_as_template_only", use_as_template_only)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if utilize_commitments is not None:
            pulumi.set(__self__, "utilize_commitments", utilize_commitments)
        if utilize_reserved_instances is not None:
            pulumi.set(__self__, "utilize_reserved_instances", utilize_reserved_instances)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the ECS cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Input[_builtins.str]:
        """
        The region the cluster will run in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        One or more security group ids.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanAutoscalerArgs']]:
        """
        Describes the Ocean ECS autoscaler.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter
    def blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "blacklists")

    @blacklists.setter
    def blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blacklists", value)

    @_builtins.property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]:
        """
        Object. List of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @_builtins.property
    @pulumi.getter(name="clusterOrientations")
    def cluster_orientations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]:
        return pulumi.get(self, "cluster_orientations")

    @cluster_orientations.setter
    def cluster_orientations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]):
        pulumi.set(self, "cluster_orientations", value)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If no Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanFiltersArgs']]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance profile iam role.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @_builtins.property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key pair to attach the instances.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['OceanLoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['OceanLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Ocean cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optimizeImages")
    def optimize_images(self) -> Optional[pulumi.Input['OceanOptimizeImagesArgs']]:
        """
        Object. Set auto image update settings.
        """
        return pulumi.get(self, "optimize_images")

    @optimize_images.setter
    def optimize_images(self, value: Optional[pulumi.Input['OceanOptimizeImagesArgs']]):
        pulumi.set(self, "optimize_images", value)

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @_builtins.property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of Spot instances that would spin up from the `desired_capacity` number.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_percentage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]:
        """
        Optionally adds tags to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanUpdatePolicyArgs']]:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        """
        return pulumi.get(self, "use_as_template_only")

    @use_as_template_only.setter
    def use_as_template_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_template_only", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If savings plans exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_commitments")

    @utilize_commitments.setter
    def utilize_commitments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "utilize_commitments", value)

    @_builtins.property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @utilize_reserved_instances.setter
    def utilize_reserved_instances(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "utilize_reserved_instances", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.input_type
class _OceanState:
    def __init__(__self__, *,
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaler: Optional[pulumi.Input['OceanAutoscalerArgs']] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input['OceanFiltersArgs']] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input['OceanLoggingArgs']] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimize_images: Optional[pulumi.Input['OceanOptimizeImagesArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]] = None,
                 update_policy: Optional[pulumi.Input['OceanUpdatePolicyArgs']] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Ocean resources.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input['OceanAutoscalerArgs'] autoscaler: Describes the Ocean ECS autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]] block_device_mappings: Object. List of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the ECS cluster.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[_builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[_builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[_builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[_builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input['OceanInstanceMetadataOptionsArgs'] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[_builtins.str] key_pair: The key pair to attach the instances.
        :param pulumi.Input['OceanLoggingArgs'] logging: Logging configuration.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[_builtins.str] name: The Ocean cluster name.
        :param pulumi.Input['OceanOptimizeImagesArgs'] optimize_images: Object. Set auto image update settings.
        :param pulumi.Input[_builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]] scheduled_tasks: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more security group ids.
        :param pulumi.Input[_builtins.int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        :param pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input['OceanUpdatePolicyArgs'] update_policy: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[_builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[_builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[_builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        if associate_public_ip_address is not None:
            pulumi.set(__self__, "associate_public_ip_address", associate_public_ip_address)
        if autoscaler is not None:
            pulumi.set(__self__, "autoscaler", autoscaler)
        if blacklists is not None:
            pulumi.set(__self__, "blacklists", blacklists)
        if block_device_mappings is not None:
            pulumi.set(__self__, "block_device_mappings", block_device_mappings)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_orientations is not None:
            pulumi.set(__self__, "cluster_orientations", cluster_orientations)
        if desired_capacity is not None:
            pulumi.set(__self__, "desired_capacity", desired_capacity)
        if draining_timeout is not None:
            pulumi.set(__self__, "draining_timeout", draining_timeout)
        if ebs_optimized is not None:
            pulumi.set(__self__, "ebs_optimized", ebs_optimized)
        if fallback_to_ondemand is not None:
            pulumi.set(__self__, "fallback_to_ondemand", fallback_to_ondemand)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if iam_instance_profile is not None:
            pulumi.set(__self__, "iam_instance_profile", iam_instance_profile)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if instance_metadata_options is not None:
            pulumi.set(__self__, "instance_metadata_options", instance_metadata_options)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if logging is not None:
            pulumi.set(__self__, "logging", logging)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if optimize_images is not None:
            pulumi.set(__self__, "optimize_images", optimize_images)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduled_tasks is not None:
            pulumi.set(__self__, "scheduled_tasks", scheduled_tasks)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if spot_percentage is not None:
            pulumi.set(__self__, "spot_percentage", spot_percentage)
        if subnet_ids is not None:
            pulumi.set(__self__, "subnet_ids", subnet_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if update_policy is not None:
            pulumi.set(__self__, "update_policy", update_policy)
        if use_as_template_only is not None:
            pulumi.set(__self__, "use_as_template_only", use_as_template_only)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if utilize_commitments is not None:
            pulumi.set(__self__, "utilize_commitments", utilize_commitments)
        if utilize_reserved_instances is not None:
            pulumi.set(__self__, "utilize_reserved_instances", utilize_reserved_instances)
        if whitelists is not None:
            pulumi.set(__self__, "whitelists", whitelists)

    @_builtins.property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @associate_public_ip_address.setter
    def associate_public_ip_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "associate_public_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> Optional[pulumi.Input['OceanAutoscalerArgs']]:
        """
        Describes the Ocean ECS autoscaler.
        """
        return pulumi.get(self, "autoscaler")

    @autoscaler.setter
    def autoscaler(self, value: Optional[pulumi.Input['OceanAutoscalerArgs']]):
        pulumi.set(self, "autoscaler", value)

    @_builtins.property
    @pulumi.getter
    def blacklists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "blacklists")

    @blacklists.setter
    def blacklists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "blacklists", value)

    @_builtins.property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]:
        """
        Object. List of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @block_device_mappings.setter
    def block_device_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanBlockDeviceMappingArgs']]]]):
        pulumi.set(self, "block_device_mappings", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the ECS cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterOrientations")
    def cluster_orientations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]:
        return pulumi.get(self, "cluster_orientations")

    @cluster_orientations.setter
    def cluster_orientations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanClusterOrientationArgs']]]]):
        pulumi.set(self, "cluster_orientations", value)

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @desired_capacity.setter
    def desired_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "desired_capacity", value)

    @_builtins.property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @draining_timeout.setter
    def draining_timeout(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "draining_timeout", value)

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @ebs_optimized.setter
    def ebs_optimized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ebs_optimized", value)

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If no Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @fallback_to_ondemand.setter
    def fallback_to_ondemand(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "fallback_to_ondemand", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input['OceanFiltersArgs']]:
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input['OceanFiltersArgs']]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The instance profile iam role.
        """
        return pulumi.get(self, "iam_instance_profile")

    @iam_instance_profile.setter
    def iam_instance_profile(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iam_instance_profile", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @instance_metadata_options.setter
    def instance_metadata_options(self, value: Optional[pulumi.Input['OceanInstanceMetadataOptionsArgs']]):
        pulumi.set(self, "instance_metadata_options", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The key pair to attach the instances.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter
    def logging(self) -> Optional[pulumi.Input['OceanLoggingArgs']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @logging.setter
    def logging(self, value: Optional[pulumi.Input['OceanLoggingArgs']]):
        pulumi.set(self, "logging", value)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_size", value)

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_size", value)

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "monitoring", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Ocean cluster name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="optimizeImages")
    def optimize_images(self) -> Optional[pulumi.Input['OceanOptimizeImagesArgs']]:
        """
        Object. Set auto image update settings.
        """
        return pulumi.get(self, "optimize_images")

    @optimize_images.setter
    def optimize_images(self, value: Optional[pulumi.Input['OceanOptimizeImagesArgs']]):
        pulumi.set(self, "optimize_images", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region the cluster will run in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "scheduled_tasks")

    @scheduled_tasks.setter
    def scheduled_tasks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanScheduledTaskArgs']]]]):
        pulumi.set(self, "scheduled_tasks", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more security group ids.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The percentage of Spot instances that would spin up from the `desired_capacity` number.
        """
        return pulumi.get(self, "spot_percentage")

    @spot_percentage.setter
    def spot_percentage(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_percentage", value)

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        """
        return pulumi.get(self, "subnet_ids")

    @subnet_ids.setter
    def subnet_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "subnet_ids", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]:
        """
        Optionally adds tags to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OceanTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> Optional[pulumi.Input['OceanUpdatePolicyArgs']]:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "update_policy")

    @update_policy.setter
    def update_policy(self, value: Optional[pulumi.Input['OceanUpdatePolicyArgs']]):
        pulumi.set(self, "update_policy", value)

    @_builtins.property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        """
        return pulumi.get(self, "use_as_template_only")

    @use_as_template_only.setter
    def use_as_template_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_as_template_only", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If savings plans exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_commitments")

    @utilize_commitments.setter
    def utilize_commitments(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "utilize_commitments", value)

    @_builtins.property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @utilize_reserved_instances.setter
    def utilize_reserved_instances(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "utilize_reserved_instances", value)

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "whitelists")

    @whitelists.setter
    def whitelists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "whitelists", value)


@pulumi.type_token("spotinst:ecs/ocean:Ocean")
class Ocean(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanClusterOrientationArgs', 'OceanClusterOrientationArgsDict']]]]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanFiltersArgs', 'OceanFiltersArgsDict']]] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimize_images: Optional[pulumi.Input[Union['OceanOptimizeImagesArgs', 'OceanOptimizeImagesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']]] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a Spotinst Ocean ECS resource.

        ## Import

        Clusters can be imported using the Ocean `id`, e.g.,

        hcl

        ```sh
        $ pulumi import spotinst:ecs/ocean:Ocean nameOfTheResource o-12345678
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']] autoscaler: Describes the Ocean ECS autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]] block_device_mappings: Object. List of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the ECS cluster.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[_builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[_builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[_builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[_builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[_builtins.str] key_pair: The key pair to attach the instances.
        :param pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']] logging: Logging configuration.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[_builtins.str] name: The Ocean cluster name.
        :param pulumi.Input[Union['OceanOptimizeImagesArgs', 'OceanOptimizeImagesArgsDict']] optimize_images: Object. Set auto image update settings.
        :param pulumi.Input[_builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]] scheduled_tasks: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more security group ids.
        :param pulumi.Input[_builtins.int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']] update_policy: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[_builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[_builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[_builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OceanArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Spotinst Ocean ECS resource.

        ## Import

        Clusters can be imported using the Ocean `id`, e.g.,

        hcl

        ```sh
        $ pulumi import spotinst:ecs/ocean:Ocean nameOfTheResource o-12345678
        ```

        :param str resource_name: The name of the resource.
        :param OceanArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OceanArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 autoscaler: Optional[pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']]] = None,
                 blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanClusterOrientationArgs', 'OceanClusterOrientationArgsDict']]]]] = None,
                 desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
                 ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
                 fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
                 filters: Optional[pulumi.Input[Union['OceanFiltersArgs', 'OceanFiltersArgsDict']]] = None,
                 iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_metadata_options: Optional[pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 logging: Optional[pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']]] = None,
                 max_size: Optional[pulumi.Input[_builtins.int]] = None,
                 min_size: Optional[pulumi.Input[_builtins.int]] = None,
                 monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 optimize_images: Optional[pulumi.Input[Union['OceanOptimizeImagesArgs', 'OceanOptimizeImagesArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
                 subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]]] = None,
                 update_policy: Optional[pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']]] = None,
                 use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
                 utilize_reserved_instances: Optional[pulumi.Input[_builtins.bool]] = None,
                 whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OceanArgs.__new__(OceanArgs)

            __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
            __props__.__dict__["autoscaler"] = autoscaler
            __props__.__dict__["blacklists"] = blacklists
            __props__.__dict__["block_device_mappings"] = block_device_mappings
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["cluster_orientations"] = cluster_orientations
            __props__.__dict__["desired_capacity"] = desired_capacity
            __props__.__dict__["draining_timeout"] = draining_timeout
            __props__.__dict__["ebs_optimized"] = ebs_optimized
            __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
            __props__.__dict__["filters"] = filters
            __props__.__dict__["iam_instance_profile"] = iam_instance_profile
            if image_id is None and not opts.urn:
                raise TypeError("Missing required property 'image_id'")
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["instance_metadata_options"] = instance_metadata_options
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["logging"] = logging
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["optimize_images"] = optimize_images
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["scheduled_tasks"] = scheduled_tasks
            if security_group_ids is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_ids'")
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["spot_percentage"] = spot_percentage
            if subnet_ids is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_ids'")
            __props__.__dict__["subnet_ids"] = subnet_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["update_policy"] = update_policy
            __props__.__dict__["use_as_template_only"] = use_as_template_only
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["utilize_commitments"] = utilize_commitments
            __props__.__dict__["utilize_reserved_instances"] = utilize_reserved_instances
            __props__.__dict__["whitelists"] = whitelists
        super(Ocean, __self__).__init__(
            'spotinst:ecs/ocean:Ocean',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associate_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
            autoscaler: Optional[pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']]] = None,
            blacklists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            block_device_mappings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_orientations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanClusterOrientationArgs', 'OceanClusterOrientationArgsDict']]]]] = None,
            desired_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            draining_timeout: Optional[pulumi.Input[_builtins.int]] = None,
            ebs_optimized: Optional[pulumi.Input[_builtins.bool]] = None,
            fallback_to_ondemand: Optional[pulumi.Input[_builtins.bool]] = None,
            filters: Optional[pulumi.Input[Union['OceanFiltersArgs', 'OceanFiltersArgsDict']]] = None,
            iam_instance_profile: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_metadata_options: Optional[pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']]] = None,
            key_pair: Optional[pulumi.Input[_builtins.str]] = None,
            logging: Optional[pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']]] = None,
            max_size: Optional[pulumi.Input[_builtins.int]] = None,
            min_size: Optional[pulumi.Input[_builtins.int]] = None,
            monitoring: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            optimize_images: Optional[pulumi.Input[Union['OceanOptimizeImagesArgs', 'OceanOptimizeImagesArgsDict']]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_tasks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            spot_percentage: Optional[pulumi.Input[_builtins.int]] = None,
            subnet_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]]] = None,
            update_policy: Optional[pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']]] = None,
            use_as_template_only: Optional[pulumi.Input[_builtins.bool]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            utilize_commitments: Optional[pulumi.Input[_builtins.bool]] = None,
            utilize_reserved_instances: Optional[pulumi.Input[_builtins.bool]] = None,
            whitelists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'Ocean':
        """
        Get an existing Ocean resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] associate_public_ip_address: Configure public IP address allocation.
        :param pulumi.Input[Union['OceanAutoscalerArgs', 'OceanAutoscalerArgsDict']] autoscaler: Describes the Ocean ECS autoscaler.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanBlockDeviceMappingArgs', 'OceanBlockDeviceMappingArgsDict']]]] block_device_mappings: Object. List of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        :param pulumi.Input[_builtins.str] cluster_name: The name of the ECS cluster.
        :param pulumi.Input[_builtins.int] desired_capacity: The number of instances to launch and maintain in the cluster.
        :param pulumi.Input[_builtins.int] draining_timeout: The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        :param pulumi.Input[_builtins.bool] ebs_optimized: Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        :param pulumi.Input[_builtins.bool] fallback_to_ondemand: If no Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        :param pulumi.Input[_builtins.str] iam_instance_profile: The instance profile iam role.
        :param pulumi.Input[_builtins.str] image_id: ID of the image used to launch the instances.
        :param pulumi.Input[Union['OceanInstanceMetadataOptionsArgs', 'OceanInstanceMetadataOptionsArgsDict']] instance_metadata_options: Ocean instance metadata options object for IMDSv2.
        :param pulumi.Input[_builtins.str] key_pair: The key pair to attach the instances.
        :param pulumi.Input[Union['OceanLoggingArgs', 'OceanLoggingArgsDict']] logging: Logging configuration.
        :param pulumi.Input[_builtins.int] max_size: The upper limit of instances the cluster can scale up to.
        :param pulumi.Input[_builtins.int] min_size: The lower limit of instances the cluster can scale down to.
        :param pulumi.Input[_builtins.bool] monitoring: Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        :param pulumi.Input[_builtins.str] name: The Ocean cluster name.
        :param pulumi.Input[Union['OceanOptimizeImagesArgs', 'OceanOptimizeImagesArgsDict']] optimize_images: Object. Set auto image update settings.
        :param pulumi.Input[_builtins.str] region: The region the cluster will run in.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanScheduledTaskArgs', 'OceanScheduledTaskArgsDict']]]] scheduled_tasks: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: One or more security group ids.
        :param pulumi.Input[_builtins.int] spot_percentage: The percentage of Spot instances that would spin up from the `desired_capacity` number.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] subnet_ids: A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OceanTagArgs', 'OceanTagArgsDict']]]] tags: Optionally adds tags to instances launched in an Ocean cluster.
        :param pulumi.Input[Union['OceanUpdatePolicyArgs', 'OceanUpdatePolicyArgsDict']] update_policy: While used, you can control whether the group should perform a deployment after an update to the configuration.
        :param pulumi.Input[_builtins.bool] use_as_template_only: launch specification defined on the Ocean object will function only as a template for virtual node groups.
        :param pulumi.Input[_builtins.str] user_data: Base64-encoded MIME user data to make available to the instances.
        :param pulumi.Input[_builtins.bool] utilize_commitments: If savings plans exist, Ocean will utilize them before launching Spot instances.
        :param pulumi.Input[_builtins.bool] utilize_reserved_instances: If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OceanState.__new__(_OceanState)

        __props__.__dict__["associate_public_ip_address"] = associate_public_ip_address
        __props__.__dict__["autoscaler"] = autoscaler
        __props__.__dict__["blacklists"] = blacklists
        __props__.__dict__["block_device_mappings"] = block_device_mappings
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_orientations"] = cluster_orientations
        __props__.__dict__["desired_capacity"] = desired_capacity
        __props__.__dict__["draining_timeout"] = draining_timeout
        __props__.__dict__["ebs_optimized"] = ebs_optimized
        __props__.__dict__["fallback_to_ondemand"] = fallback_to_ondemand
        __props__.__dict__["filters"] = filters
        __props__.__dict__["iam_instance_profile"] = iam_instance_profile
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["instance_metadata_options"] = instance_metadata_options
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["logging"] = logging
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["optimize_images"] = optimize_images
        __props__.__dict__["region"] = region
        __props__.__dict__["scheduled_tasks"] = scheduled_tasks
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["spot_percentage"] = spot_percentage
        __props__.__dict__["subnet_ids"] = subnet_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["update_policy"] = update_policy
        __props__.__dict__["use_as_template_only"] = use_as_template_only
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["utilize_commitments"] = utilize_commitments
        __props__.__dict__["utilize_reserved_instances"] = utilize_reserved_instances
        __props__.__dict__["whitelists"] = whitelists
        return Ocean(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="associatePublicIpAddress")
    def associate_public_ip_address(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Configure public IP address allocation.
        """
        return pulumi.get(self, "associate_public_ip_address")

    @_builtins.property
    @pulumi.getter
    def autoscaler(self) -> pulumi.Output[Optional['outputs.OceanAutoscaler']]:
        """
        Describes the Ocean ECS autoscaler.
        """
        return pulumi.get(self, "autoscaler")

    @_builtins.property
    @pulumi.getter
    def blacklists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "blacklists")

    @_builtins.property
    @pulumi.getter(name="blockDeviceMappings")
    def block_device_mappings(self) -> pulumi.Output[Optional[Sequence['outputs.OceanBlockDeviceMapping']]]:
        """
        Object. List of block devices that are exposed to the instance, specify either virtual devices and EBS volumes.
        """
        return pulumi.get(self, "block_device_mappings")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the ECS cluster.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterOrientations")
    def cluster_orientations(self) -> pulumi.Output[Optional[Sequence['outputs.OceanClusterOrientation']]]:
        return pulumi.get(self, "cluster_orientations")

    @_builtins.property
    @pulumi.getter(name="desiredCapacity")
    def desired_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The number of instances to launch and maintain in the cluster.
        """
        return pulumi.get(self, "desired_capacity")

    @_builtins.property
    @pulumi.getter(name="drainingTimeout")
    def draining_timeout(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time in seconds, the instance is allowed to run while detached from the ELB. This is to allow the instance time to be drained from incoming TCP connections before terminating it, during a scale down operation.
        """
        return pulumi.get(self, "draining_timeout")

    @_builtins.property
    @pulumi.getter(name="ebsOptimized")
    def ebs_optimized(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable EBS optimized for cluster. Flag will enable optimized capacity for high bandwidth connectivity to the EB service for non EBS optimized instance types. For instances that are EBS optimized this flag will be ignored.
        """
        return pulumi.get(self, "ebs_optimized")

    @_builtins.property
    @pulumi.getter(name="fallbackToOndemand")
    def fallback_to_ondemand(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If no Spot instance markets are available, enable Ocean to launch On-Demand instances instead.
        """
        return pulumi.get(self, "fallback_to_ondemand")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional['outputs.OceanFilters']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="iamInstanceProfile")
    def iam_instance_profile(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The instance profile iam role.
        """
        return pulumi.get(self, "iam_instance_profile")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of the image used to launch the instances.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceMetadataOptions")
    def instance_metadata_options(self) -> pulumi.Output[Optional['outputs.OceanInstanceMetadataOptions']]:
        """
        Ocean instance metadata options object for IMDSv2.
        """
        return pulumi.get(self, "instance_metadata_options")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The key pair to attach the instances.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def logging(self) -> pulumi.Output[Optional['outputs.OceanLogging']]:
        """
        Logging configuration.
        """
        return pulumi.get(self, "logging")

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[_builtins.int]:
        """
        The upper limit of instances the cluster can scale up to.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[_builtins.int]:
        """
        The lower limit of instances the cluster can scale down to.
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable detailed monitoring for cluster. Flag will enable Cloud Watch detailed monitoring (one minute increments). Note: there are additional hourly costs for this service based on the region used.
        """
        return pulumi.get(self, "monitoring")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The Ocean cluster name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="optimizeImages")
    def optimize_images(self) -> pulumi.Output[Optional['outputs.OceanOptimizeImages']]:
        """
        Object. Set auto image update settings.
        """
        return pulumi.get(self, "optimize_images")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region the cluster will run in.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="scheduledTasks")
    def scheduled_tasks(self) -> pulumi.Output[Optional[Sequence['outputs.OceanScheduledTask']]]:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "scheduled_tasks")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        One or more security group ids.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="spotPercentage")
    def spot_percentage(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The percentage of Spot instances that would spin up from the `desired_capacity` number.
        """
        return pulumi.get(self, "spot_percentage")

    @_builtins.property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A comma-separated list of subnet identifiers for the Ocean cluster. Subnet IDs should be configured with auto assign public ip.
        """
        return pulumi.get(self, "subnet_ids")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.OceanTag']]]:
        """
        Optionally adds tags to instances launched in an Ocean cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatePolicy")
    def update_policy(self) -> pulumi.Output[Optional['outputs.OceanUpdatePolicy']]:
        """
        While used, you can control whether the group should perform a deployment after an update to the configuration.
        """
        return pulumi.get(self, "update_policy")

    @_builtins.property
    @pulumi.getter(name="useAsTemplateOnly")
    def use_as_template_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        launch specification defined on the Ocean object will function only as a template for virtual node groups.
        """
        return pulumi.get(self, "use_as_template_only")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Base64-encoded MIME user data to make available to the instances.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="utilizeCommitments")
    def utilize_commitments(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If savings plans exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_commitments")

    @_builtins.property
    @pulumi.getter(name="utilizeReservedInstances")
    def utilize_reserved_instances(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If Reserved instances exist, Ocean will utilize them before launching Spot instances.
        """
        return pulumi.get(self, "utilize_reserved_instances")

    @_builtins.property
    @pulumi.getter
    def whitelists(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "whitelists")

