# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'OceanCompute',
    'OceanIngress',
    'OceanIngressController',
    'OceanIngressCustomEndpoint',
    'OceanIngressLoadBalancer',
    'OceanIngressPrivateLink',
    'OceanLogCollection',
    'OceanSpark',
    'OceanWebhook',
    'OceanWorkspaces',
    'OceanWorkspacesStorage',
    'OceanWorkspacesStorageDefaults',
]

@pulumi.output_type
class OceanCompute(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createVngs":
            suggest = "create_vngs"
        elif key == "useTaints":
            suggest = "use_taints"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanCompute. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanCompute.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanCompute.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_vngs: Optional[_builtins.bool] = None,
                 use_taints: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool create_vngs: - Enable/disable the creation of Ocean Spark VNGs during cluster creation.
        :param _builtins.bool use_taints: - Enable/disable Ocean Spark taints on the Ocean Spark VNGs. By default, Ocean Spark uses taints to prevent non-Spark workloads from running on Ocean Spark VNGs.
        """
        if create_vngs is not None:
            pulumi.set(__self__, "create_vngs", create_vngs)
        if use_taints is not None:
            pulumi.set(__self__, "use_taints", use_taints)

    @_builtins.property
    @pulumi.getter(name="createVngs")
    def create_vngs(self) -> Optional[_builtins.bool]:
        """
        - Enable/disable the creation of Ocean Spark VNGs during cluster creation.
        """
        return pulumi.get(self, "create_vngs")

    @_builtins.property
    @pulumi.getter(name="useTaints")
    def use_taints(self) -> Optional[_builtins.bool]:
        """
        - Enable/disable Ocean Spark taints on the Ocean Spark VNGs. By default, Ocean Spark uses taints to prevent non-Spark workloads from running on Ocean Spark VNGs.
        """
        return pulumi.get(self, "use_taints")


@pulumi.output_type
class OceanIngress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customEndpoint":
            suggest = "custom_endpoint"
        elif key == "loadBalancer":
            suggest = "load_balancer"
        elif key == "privateLink":
            suggest = "private_link"
        elif key == "serviceAnnotations":
            suggest = "service_annotations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanIngress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanIngress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanIngress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 controller: Optional['outputs.OceanIngressController'] = None,
                 custom_endpoint: Optional['outputs.OceanIngressCustomEndpoint'] = None,
                 load_balancer: Optional['outputs.OceanIngressLoadBalancer'] = None,
                 private_link: Optional['outputs.OceanIngressPrivateLink'] = None,
                 service_annotations: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param Mapping[str, _builtins.str] service_annotations: - **DEPRECATED**: Use `load_balancer.service_annotations` instead.
        """
        if controller is not None:
            pulumi.set(__self__, "controller", controller)
        if custom_endpoint is not None:
            pulumi.set(__self__, "custom_endpoint", custom_endpoint)
        if load_balancer is not None:
            pulumi.set(__self__, "load_balancer", load_balancer)
        if private_link is not None:
            pulumi.set(__self__, "private_link", private_link)
        if service_annotations is not None:
            pulumi.set(__self__, "service_annotations", service_annotations)

    @_builtins.property
    @pulumi.getter
    def controller(self) -> Optional['outputs.OceanIngressController']:
        return pulumi.get(self, "controller")

    @_builtins.property
    @pulumi.getter(name="customEndpoint")
    def custom_endpoint(self) -> Optional['outputs.OceanIngressCustomEndpoint']:
        return pulumi.get(self, "custom_endpoint")

    @_builtins.property
    @pulumi.getter(name="loadBalancer")
    def load_balancer(self) -> Optional['outputs.OceanIngressLoadBalancer']:
        return pulumi.get(self, "load_balancer")

    @_builtins.property
    @pulumi.getter(name="privateLink")
    def private_link(self) -> Optional['outputs.OceanIngressPrivateLink']:
        return pulumi.get(self, "private_link")

    @_builtins.property
    @pulumi.getter(name="serviceAnnotations")
    def service_annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        - **DEPRECATED**: Use `load_balancer.service_annotations` instead.
        """
        return pulumi.get(self, "service_annotations")


@pulumi.output_type
class OceanIngressController(dict):
    def __init__(__self__, *,
                 managed: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool managed: - Should an ingress controller managed by Ocean for Apache Spark be installed on the cluster.
        """
        if managed is not None:
            pulumi.set(__self__, "managed", managed)

    @_builtins.property
    @pulumi.getter
    def managed(self) -> Optional[_builtins.bool]:
        """
        - Should an ingress controller managed by Ocean for Apache Spark be installed on the cluster.
        """
        return pulumi.get(self, "managed")


@pulumi.output_type
class OceanIngressCustomEndpoint(dict):
    def __init__(__self__, *,
                 address: Optional[_builtins.str] = None,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str address: - The address the Ocean for Apache Spark control plane will use when addressing the cluster.
        :param _builtins.bool enabled: - Should the Ocean for Apache Spark control plane address the cluster using a custom endpoint. Use this to specify the DNS address of an externally provisioned (unmanaged) load balancer.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter
    def address(self) -> Optional[_builtins.str]:
        """
        - The address the Ocean for Apache Spark control plane will use when addressing the cluster.
        """
        return pulumi.get(self, "address")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        - Should the Ocean for Apache Spark control plane address the cluster using a custom endpoint. Use this to specify the DNS address of an externally provisioned (unmanaged) load balancer.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class OceanIngressLoadBalancer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAnnotations":
            suggest = "service_annotations"
        elif key == "targetGroupArn":
            suggest = "target_group_arn"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanIngressLoadBalancer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanIngressLoadBalancer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanIngressLoadBalancer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 managed: Optional[_builtins.bool] = None,
                 service_annotations: Optional[Mapping[str, _builtins.str]] = None,
                 target_group_arn: Optional[_builtins.str] = None):
        """
        :param _builtins.bool managed: - Should a load balancer managed by Ocean for Apache Spark be provisioned for the cluster. Set this to false if you want to use an existing load balancer (only available on AWS).
        :param Mapping[str, _builtins.str] service_annotations: - Annotations to add to the ingress controller load balancer service. This is useful to configure properties of the managed load balancer, like the nature of the load balancer (e.g. ELB, NLB, ALB on AWS), the security groups, or various timeouts.
        :param _builtins.str target_group_arn: - The ARN of a target group that the Ocean for Apache Spark ingress controller will be bound to. Set this to use an existing load balancer with Ocean for Apache Spark. Has no effect if using a managed load balancer. Only available on AWS.
        """
        if managed is not None:
            pulumi.set(__self__, "managed", managed)
        if service_annotations is not None:
            pulumi.set(__self__, "service_annotations", service_annotations)
        if target_group_arn is not None:
            pulumi.set(__self__, "target_group_arn", target_group_arn)

    @_builtins.property
    @pulumi.getter
    def managed(self) -> Optional[_builtins.bool]:
        """
        - Should a load balancer managed by Ocean for Apache Spark be provisioned for the cluster. Set this to false if you want to use an existing load balancer (only available on AWS).
        """
        return pulumi.get(self, "managed")

    @_builtins.property
    @pulumi.getter(name="serviceAnnotations")
    def service_annotations(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        - Annotations to add to the ingress controller load balancer service. This is useful to configure properties of the managed load balancer, like the nature of the load balancer (e.g. ELB, NLB, ALB on AWS), the security groups, or various timeouts.
        """
        return pulumi.get(self, "service_annotations")

    @_builtins.property
    @pulumi.getter(name="targetGroupArn")
    def target_group_arn(self) -> Optional[_builtins.str]:
        """
        - The ARN of a target group that the Ocean for Apache Spark ingress controller will be bound to. Set this to use an existing load balancer with Ocean for Apache Spark. Has no effect if using a managed load balancer. Only available on AWS.
        """
        return pulumi.get(self, "target_group_arn")


@pulumi.output_type
class OceanIngressPrivateLink(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "vpcEndpointService":
            suggest = "vpc_endpoint_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanIngressPrivateLink. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanIngressPrivateLink.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanIngressPrivateLink.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 vpc_endpoint_service: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: - Should the Ocean for Apache Spark control plane address the cluster via an AWS Private Link. Only available on AWS.
        :param _builtins.str vpc_endpoint_service: - The name of the VPC Endpoint Service the Ocean for Apache Spark control plane should bind to.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if vpc_endpoint_service is not None:
            pulumi.set(__self__, "vpc_endpoint_service", vpc_endpoint_service)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        - Should the Ocean for Apache Spark control plane address the cluster via an AWS Private Link. Only available on AWS.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="vpcEndpointService")
    def vpc_endpoint_service(self) -> Optional[_builtins.str]:
        """
        - The name of the VPC Endpoint Service the Ocean for Apache Spark control plane should bind to.
        """
        return pulumi.get(self, "vpc_endpoint_service")


@pulumi.output_type
class OceanLogCollection(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "collectAppLogs":
            suggest = "collect_app_logs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanLogCollection. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanLogCollection.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanLogCollection.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 collect_app_logs: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool collect_app_logs: - Enable/Disable collecting driver and executor logs. When enabled, logs are stored by NetApp and can be downloaded from the Spot console web interface. The logs are deleted after 30 days.
        """
        if collect_app_logs is not None:
            pulumi.set(__self__, "collect_app_logs", collect_app_logs)

    @_builtins.property
    @pulumi.getter(name="collectAppLogs")
    def collect_app_logs(self) -> Optional[_builtins.bool]:
        """
        - Enable/Disable collecting driver and executor logs. When enabled, logs are stored by NetApp and can be downloaded from the Spot console web interface. The logs are deleted after 30 days.
        """
        return pulumi.get(self, "collect_app_logs")


@pulumi.output_type
class OceanSpark(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalAppNamespaces":
            suggest = "additional_app_namespaces"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanSpark. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanSpark.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanSpark.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_app_namespaces: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] additional_app_namespaces: - List of Kubernetes namespaces that should be configured to run Spark applications, in addition to the default Spark application namespace `spark-apps`.
        """
        if additional_app_namespaces is not None:
            pulumi.set(__self__, "additional_app_namespaces", additional_app_namespaces)

    @_builtins.property
    @pulumi.getter(name="additionalAppNamespaces")
    def additional_app_namespaces(self) -> Optional[Sequence[_builtins.str]]:
        """
        - List of Kubernetes namespaces that should be configured to run Spark applications, in addition to the default Spark application namespace `spark-apps`.
        """
        return pulumi.get(self, "additional_app_namespaces")


@pulumi.output_type
class OceanWebhook(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostNetworkPorts":
            suggest = "host_network_ports"
        elif key == "useHostNetwork":
            suggest = "use_host_network"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanWebhook. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanWebhook.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanWebhook.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_network_ports: Optional[Sequence[_builtins.int]] = None,
                 use_host_network: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.int] host_network_ports: - List of ports allowed to use on the host network - if empty default is `25554`.
        :param _builtins.bool use_host_network: - Enable/disable host networking for the Spark Operator. Host networking can be useful when using custom CNI plugins like Calico on EKS.
        """
        if host_network_ports is not None:
            pulumi.set(__self__, "host_network_ports", host_network_ports)
        if use_host_network is not None:
            pulumi.set(__self__, "use_host_network", use_host_network)

    @_builtins.property
    @pulumi.getter(name="hostNetworkPorts")
    def host_network_ports(self) -> Optional[Sequence[_builtins.int]]:
        """
        - List of ports allowed to use on the host network - if empty default is `25554`.
        """
        return pulumi.get(self, "host_network_ports")

    @_builtins.property
    @pulumi.getter(name="useHostNetwork")
    def use_host_network(self) -> Optional[_builtins.bool]:
        """
        - Enable/disable host networking for the Spark Operator. Host networking can be useful when using custom CNI plugins like Calico on EKS.
        """
        return pulumi.get(self, "use_host_network")


@pulumi.output_type
class OceanWorkspaces(dict):
    def __init__(__self__, *,
                 storage: Optional['outputs.OceanWorkspacesStorage'] = None):
        if storage is not None:
            pulumi.set(__self__, "storage", storage)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional['outputs.OceanWorkspacesStorage']:
        return pulumi.get(self, "storage")


@pulumi.output_type
class OceanWorkspacesStorage(dict):
    def __init__(__self__, *,
                 defaults: Optional['outputs.OceanWorkspacesStorageDefaults'] = None):
        if defaults is not None:
            pulumi.set(__self__, "defaults", defaults)

    @_builtins.property
    @pulumi.getter
    def defaults(self) -> Optional['outputs.OceanWorkspacesStorageDefaults']:
        return pulumi.get(self, "defaults")


@pulumi.output_type
class OceanWorkspacesStorageDefaults(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageClassName":
            suggest = "storage_class_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OceanWorkspacesStorageDefaults. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OceanWorkspacesStorageDefaults.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OceanWorkspacesStorageDefaults.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_class_name: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_class_name: - The name of the default storage class to use for new workspaces. If not specified, the default storage class of the Kubernetes cluster will be used.
        """
        if storage_class_name is not None:
            pulumi.set(__self__, "storage_class_name", storage_class_name)

    @_builtins.property
    @pulumi.getter(name="storageClassName")
    def storage_class_name(self) -> Optional[_builtins.str]:
        """
        - The name of the default storage class to use for new workspaces. If not specified, the default storage class of the Kubernetes cluster will be used.
        """
        return pulumi.get(self, "storage_class_name")


