<p align="center">
  <a href="https://squidfunk.github.io/mkdocs-material/">
    <img src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/logo.svg" width="320" alt="Material for MkDocs">
  </a>
</p>

<p align="center">
  <strong>
    A 
    <a href="https://material.io/">Material Design</a> 
    theme for 
    <a href="https://www.mkdocs.org/">MkDocs</a>
  </strong>
</p>

<p align="center">
  <a href="https://github.com/squidfunk/mkdocs-material/actions"><img
    src="https://github.com/squidfunk/mkdocs-material/workflows/build/badge.svg?branch=master"
    alt="Build"
  /></a>
  <a href="https://pypistats.org/packages/mkdocs-material"><img
    src="https://img.shields.io/pypi/dm/mkdocs-material.svg" 
    alt="Downloads"
  /></a>
  <a href="https://gitter.im/squidfunk/mkdocs-material"><img 
    src="https://badges.gitter.im/squidfunk/mkdocs-material.svg" 
    alt="Chat on Gitter"
  /></a>
  <a href="https://pypi.org/project/mkdocs-material"><img 
    src="https://img.shields.io/pypi/v/mkdocs-material.svg" 
    alt="Python Package Index"
  /></a>
  <a href="https://hub.docker.com/r/squidfunk/mkdocs-material/"><img 
    src="https://img.shields.io/docker/pulls/squidfunk/mkdocs-material" 
    alt="Docker Pulls"
  /></a>
</p>

<p align="center">
  Write your documentation in Markdown and create a professional static site for
  your Open Source or commercial project in minutes – searchable, customizable,
  more than 50 languages, for all devices.
</p>

<p align="center">
  <a href="https://squidfunk.github.io/mkdocs-material/getting-started/">
    <img src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/screenshot.png" width="700" />
  </a>
</p>

<p align="center">
  <em>
    Check out the demo – 
    <a
      href="https://squidfunk.github.io/mkdocs-material/"
    >squidfunk.github.io/mkdocs-material</a>.
  </em>
</p>

<h2></h2>
<p>&nbsp;</p>
<p id="premium-sponsors" align="center"><strong>Special thanks</strong> to our <strong>premium sponsors</strong>:</p>
<p>&nbsp;</p>
<p align="center">
  <a href="https://cirrus-ci.org/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-cirrus-ci.png" height="65"
  /></a>
  <a href="https://docs.baslerweb.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-basler.png" height="65"
  /></a>
  <a href="https://hummingbot.io/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-hummingbot.png" height="65"
  /></a>
  <a href="https://kx.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-kx.png" height="65"
  /></a>
  <a href="https://www.manticoregames.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-manticore-games.png" height="65"
  /></a>
  <a href="https://www.accounttechnologies.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-account-technologies.png" height="65"
  /></a>
  <a href="https://orion-docs.prefect.io/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-prefect.png" height="65"
  /></a>
  <a href="https://datadoghq.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-datadog.png" height="65"
  /></a>
  <a href="https://www.zenoss.com/" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-zenoss.png" height="65"
  /></a>
  <a href="https://www.elli.eco/en/home" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-elli.png" height="65"
  /></a>
  <a href="https://solutions.rstudio.com" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-rstudio.png" height="65"
  /></a>
  <a href="https://n8n.io" target=_blank><img
    src="https://raw.githubusercontent.com/squidfunk/mkdocs-material/master/.github/assets/sponsors/sponsor-n8n.png" height="65"
  /></a>
</p>
<p>&nbsp;</p>

## Everything you would expect

### It's just Markdown

Focus on the content of your documentation and create a professional static site
in minutes. No need to know HTML, CSS or JavaScript – let Material for MkDocs do
the heavy lifting for you.

### Works on all devices

Serve your documentation with confidence – Material for MkDocs automatically
adapts to perfectly fit the available screen estate, no matter the type or size
of the viewing device. Desktop. Tablet. Mobile. All great.

### Made to measure

Make it yours – change the colors, fonts, language, icons, logo, and more with
a few lines of configuration. Material for MkDocs can be easily extended and
provides many options to alter appearance and behavior.

### Fast and lightweight

Don't let your users wait – get incredible value with a small footprint by using
one of the fastest themes available with excellent performance, yielding optimal
search engine rankings and happy users that return.

### Built for everyone

Make accessibility a priority – users can navigate your documentation with touch
devices, keyboards, and screen readers. Semantic markup ensures that your
documentation works for everyone.

### Open Source

Trust 10,000+ users – choose a mature and actively maintained solution built
with state-of-the-art Open Source technologies. Keep ownership of your content
without fear of vendor lock-in. Licensed under MIT.

## Quick start

Material for MkDocs can be installed with `pip`:

``` sh
pip install mkdocs-material
```

Add the following lines to `mkdocs.yml`:

``` yaml
theme:
  name: material
```

For detailed installation instructions, configuration options, and a demo, visit
[squidfunk.github.io/mkdocs-material][Material for MkDocs]

  [Material for MkDocs]: https://squidfunk.github.io/mkdocs-material/

## Trusted by ...

### ... industry leaders

[Atlassian](https://atlassian.github.io/data-center-helm-charts/),
[AWS](https://aws.github.io/copilot-cli/),
[Binance](https://docs.binance.org/),
[Bloomberg](https://bloomberg.github.io/selekt/),
[CERN](http://abpcomputing.web.cern.ch/),
[Datadog](https://datadoghq.dev/integrations-core/),
[Google](https://google.github.io/accompanist/),
[Hewlett Packard](https://hewlettpackard.github.io/squest/),
[ING](https://ing-bank.github.io/baker/),
[Intel](https://open-amt-cloud-toolkit.github.io/docs/),
[LinkedIn](https://linkedin.github.io/school-of-sre/),
[Microsoft](https://microsoft.github.io/code-with-engineering-playbook/),
[Mozilla](https://mozillafoundation.github.io/engineering-handbook/),
[Netflix](https://netflix.github.io/titus/),
[Salesforce](https://policy-sentry.readthedocs.io/en/latest/),
[SoundCloud](https://intervene.dev/),
[Square](https://square.github.io/okhttp/),
[Zalando](https://opensource.zalando.com/skipper/)

### ... and successful Open Source projects

[Arduino](https://arduino.github.io/arduino-cli/),
[AutoKeras](https://autokeras.com/),
[BFE](https://www.bfe-networks.net/),
[CentOS](https://docs.infra.centos.org/),
[Crystal](https://crystal-lang.org/reference/),
[Electron](https://www.electron.build/),
[FastAPI](https://fastapi.tiangolo.com/),
[GoReleaser](https://goreleaser.com/),
[Knative](https://knative.dev/docs/),
[Kubernetes](https://kops.sigs.k8s.io/),
[kSQL](https://docs.ksqldb.io/),
[MindsDB](https://docs.mindsdb.com/),
[Nokogiri](https://nokogiri.org/),
[OpenFaaS](https://docs.openfaas.com/),
[Percona](https://docs.percona.com/percona-monitoring-and-management/),
[Pi-Hole](https://docs.pi-hole.net/),
[Pydantic](https://pydantic-docs.helpmanual.io/),
[Renovate](https://docs.renovatebot.com/),
[Traefik](https://docs.traefik.io/),
[Vapor](https://docs.vapor.codes/),
[ZeroNet](https://zeronet.io/docs/),
[WTF](https://wtfutil.com/)

## License

**MIT License**

Copyright (c) 2016-2022 Martin Donath

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
