"""Fix TaskPersonLink

Revision ID: 3d8e68dffeee
Revises: d97f2730bf7b
Create Date: 2025-07-18 11:39:02.795034

"""

from alembic import op

# revision identifiers, used by Alembic.
revision = "3d8e68dffeee"
down_revision = "d97f2730bf7b"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task_person_link", schema=None) as batch_op:
        batch_op.alter_column("task", new_column_name="task_id")
        batch_op.alter_column("person", new_column_name="person_id")
        batch_op.drop_constraint(
            batch_op.f("assignations_person_fkey"), type_="foreignkey"
        )
        batch_op.drop_constraint(
            batch_op.f("assignations_task_fkey"), type_="foreignkey"
        )
        batch_op.create_foreign_key(None, "person", ["person_id"], ["id"])
        batch_op.create_foreign_key(None, "task", ["task_id"], ["id"])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task_person_link", schema=None) as batch_op:
        batch_op.alter_column("task_id", new_column_name="task")
        batch_op.alter_column("person_id", new_column_name="person")
        batch_op.drop_constraint(
            "task_person_link_person_id_fkey", type_="foreignkey"
        )
        batch_op.drop_constraint(
            "task_person_link_task_id_fkey", type_="foreignkey"
        )
        batch_op.create_foreign_key(
            batch_op.f("assignations_task_fkey"), "task", ["task"], ["id"]
        )
        batch_op.create_foreign_key(
            batch_op.f("assignations_person_fkey"),
            "person",
            ["person"],
            ["id"],
        )

    # ### end Alembic commands ###
