"""add is_done field to the task model

Revision ID: ca28796a2a62
Revises: 971dbf5a0faf
Create Date: 2024-07-19 15:24:21.064991

"""

from alembic import op
import sqlalchemy as sa
from sqlalchemy import orm
from sqlalchemy.ext.declarative import declarative_base
from zou.migrations.utils.base import BaseMixin
from sqlalchemy_utils import UUIDType, ChoiceType


# revision identifiers, used by Alembic.
revision = "ca28796a2a62"
down_revision = "971dbf5a0faf"
branch_labels = None
depends_on = None


def upgrade():
    base = declarative_base()

    TYPES = [
        ("comment", "Comment"),
        ("mention", "Mention"),
        ("assignation", "Assignation"),
        ("reply", "Reply"),
        ("reply-mention", "Reply Mention"),
    ]

    class Notification(base, BaseMixin):
        """
        A notification is stored each time a comment is posted.
        """

        __tablename__ = "notification"
        read = sa.Column(sa.Boolean, nullable=False, default=False)
        change = sa.Column(sa.Boolean, nullable=False, default=False)
        type = sa.Column(ChoiceType(TYPES), nullable=False)
        person_id = sa.Column(
            UUIDType(binary=False),
            nullable=False,
            index=True,
        )
        author_id = sa.Column(
            UUIDType(binary=False),
            nullable=False,
            index=True,
        )
        comment_id = sa.Column(
            UUIDType(binary=False),
            nullable=True,
            index=True,
        )
        task_id = sa.Column(
            UUIDType(binary=False),
            nullable=False,
            index=True,
        )
        reply_id = sa.Column(UUIDType(binary=False), nullable=True, index=True)

        __table_args__ = (
            sa.UniqueConstraint(
                "person_id",
                "author_id",
                "comment_id",
                "reply_id",
                "type",
                name="notification_uc",
            ),
        )

    bind = op.get_bind()
    session = orm.Session(bind=bind)
    session.query(Notification).where(Notification.type == None).update(
        {Notification.type: "comment"}
    )
    session.commit()

    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("notification", schema=None) as batch_op:
        batch_op.alter_column(
            "type", existing_type=sa.VARCHAR(length=255), nullable=False
        )

    with op.batch_alter_table("task", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column("done_date", sa.DateTime(), nullable=True)
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("task", schema=None) as batch_op:
        batch_op.drop_column("done_date")

    with op.batch_alter_table("notification", schema=None) as batch_op:
        batch_op.alter_column(
            "type", existing_type=sa.VARCHAR(length=255), nullable=True
        )

    # ### end Alembic commands ###
