"""Add Project.production_schedule_version_id

Revision ID: e4b48ca33539
Revises: 26f96f65cfa3
Create Date: 2025-07-22 02:57:31.987773

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "e4b48ca33539"
down_revision = "26f96f65cfa3"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("project", schema=None) as batch_op:
        batch_op.add_column(
            sa.Column(
                "from_schedule_version_id",
                sqlalchemy_utils.types.uuid.UUIDType(binary=False),
                default=uuid.uuid4,
                nullable=True,
            )
        )
        batch_op.create_index(
            batch_op.f("ix_project_from_schedule_version_id"),
            ["from_schedule_version_id"],
            unique=False,
        )
        batch_op.create_foreign_key(
            None,
            "production_schedule_version",
            ["from_schedule_version_id"],
            ["id"],
        )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("project", schema=None) as batch_op:
        batch_op.drop_constraint(
            "project_from_schedule_version_id_fkey", type_="foreignkey"
        )
        batch_op.drop_index(batch_op.f("ix_project_from_schedule_version_id"))
        batch_op.drop_column("from_schedule_version_id")

    # ### end Alembic commands ###
