"""add person id to shot history

Revision ID: e839d6603c09
Revises: 346250b5304c
Create Date: 2020-12-14 12:00:19.045783

"""

from alembic import op
import sqlalchemy as sa
import sqlalchemy_utils
import sqlalchemy_utils
import uuid

# revision identifiers, used by Alembic.
revision = "e839d6603c09"
down_revision = "346250b5304c"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "entity_version",
        sa.Column(
            "person_id",
            sqlalchemy_utils.types.uuid.UUIDType(binary=False),
            default=uuid.uuid4,
            nullable=True,
        ),
    )
    op.create_index(
        op.f("ix_entity_version_person_id"),
        "entity_version",
        ["person_id"],
        unique=False,
    )
    op.create_foreign_key(
        None, "entity_version", "person", ["person_id"], ["id"]
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "entity_version", type_="foreignkey")
    op.drop_index(
        op.f("ix_entity_version_person_id"), table_name="entity_version"
    )
    op.drop_column("entity_version", "person_id")
    # ### end Alembic commands ###
