# Generated by Plain 0.52.2 on 2025-07-17 02:27

import plain.models.deletion
from plain import models
from plain.models import migrations


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Trace",
            fields=[
                ("id", models.PrimaryKeyField()),
                ("trace_id", models.CharField(max_length=255)),
                ("start_time", models.DateTimeField()),
                ("end_time", models.DateTimeField()),
                ("root_span_name", models.TextField(default="", required=False)),
                (
                    "request_id",
                    models.CharField(default="", max_length=255, required=False),
                ),
                (
                    "session_id",
                    models.CharField(default="", max_length=255, required=False),
                ),
                (
                    "user_id",
                    models.CharField(default="", max_length=255, required=False),
                ),
            ],
            options={
                "ordering": ["-start_time"],
            },
        ),
        migrations.CreateModel(
            name="Span",
            fields=[
                ("id", models.PrimaryKeyField()),
                ("span_id", models.CharField(max_length=255)),
                ("name", models.CharField(max_length=255)),
                ("kind", models.CharField(max_length=50)),
                (
                    "parent_id",
                    models.CharField(default="", max_length=255, required=False),
                ),
                ("start_time", models.DateTimeField()),
                ("end_time", models.DateTimeField()),
                ("status", models.CharField(default="", max_length=50, required=False)),
                ("span_data", models.JSONField(default=dict, required=False)),
            ],
            options={
                "ordering": ["-start_time"],
            },
        ),
        migrations.AddConstraint(
            model_name="trace",
            constraint=models.UniqueConstraint(
                fields=("trace_id",), name="observer_unique_trace_id"
            ),
        ),
        migrations.AddField(
            model_name="span",
            name="trace",
            field=models.ForeignKey(
                on_delete=plain.models.deletion.CASCADE,
                related_name="spans",
                to="plainobserver.trace",
            ),
        ),
        migrations.AddIndex(
            model_name="span",
            index=models.Index(
                fields=["trace", "span_id"], name="plainobserv_trace_i_89a97c_idx"
            ),
        ),
        migrations.AddIndex(
            model_name="span",
            index=models.Index(fields=["trace"], name="plainobserv_trace_i_84958a_idx"),
        ),
        migrations.AddIndex(
            model_name="span",
            index=models.Index(
                fields=["start_time"], name="plainobserv_start_t_cb47a3_idx"
            ),
        ),
        migrations.AddConstraint(
            model_name="span",
            constraint=models.UniqueConstraint(
                fields=("trace", "span_id"), name="observer_unique_span_id"
            ),
        ),
    ]
