"""
Ibutsu API

A system to store and query test results

The version of the OpenAPI document: 2.8.3
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Self
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field, StrictStr


class Dashboard(BaseModel):
    """
    Dashboard
    """

    id: UUID | None = Field(default=None, description="Unique ID of the dashboard")
    title: StrictStr | None = Field(default=None, description="The title of the dashboard")
    description: StrictStr | None = Field(
        default=None, description="A basic description of the dashboard"
    )
    filters: StrictStr | None = Field(default=None, description="An optional set of filters")
    project_id: UUID | None = Field(
        default=None, description="The ID of the project this dashboard is associated with"
    )
    user_id: UUID | None = Field(
        default=None, description="The ID of a user this dashboard might be associated with"
    )
    __properties: ClassVar[list[str]] = [
        "id",
        "title",
        "description",
        "filters",
        "project_id",
        "user_id",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self | None:
        """Create an instance of Dashboard from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: set[str] = set()

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict[str, Any] | None) -> Self | None:
        """Create an instance of Dashboard from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "title": obj.get("title"),
                "description": obj.get("description"),
                "filters": obj.get("filters"),
                "project_id": obj.get("project_id"),
                "user_id": obj.get("user_id"),
            }
        )
        return _obj
