"""
Ibutsu API

A system to store and query test results

The version of the OpenAPI document: 2.8.3
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Self

from pydantic import BaseModel, ConfigDict, Field, StrictBool


class LoginSupport(BaseModel):
    """
    LoginSupport
    """

    user: StrictBool | None = Field(
        default=None, description="Flag to see if email/password login is available"
    )
    keycloak: StrictBool | None = Field(
        default=None, description="Flag to see if Keycloak login is available"
    )
    google: StrictBool | None = Field(
        default=None, description="Flag to see if Google login is available"
    )
    github: StrictBool | None = Field(
        default=None, description="Flag to see if GitHub login is available"
    )
    facebook: StrictBool | None = Field(
        default=None, description="Flag to see if Facebook login is available"
    )
    gitlab: StrictBool | None = Field(
        default=None, description="Flag to see if GitLab login is available"
    )
    __properties: ClassVar[list[str]] = [
        "user",
        "keycloak",
        "google",
        "github",
        "facebook",
        "gitlab",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self | None:
        """Create an instance of LoginSupport from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: set[str] = set()

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: dict[str, Any] | None) -> Self | None:
        """Create an instance of LoginSupport from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "user": obj.get("user"),
                "keycloak": obj.get("keycloak"),
                "google": obj.get("google"),
                "github": obj.get("github"),
                "facebook": obj.get("facebook"),
                "gitlab": obj.get("gitlab"),
            }
        )
        return _obj
