"""
Ibutsu API

A system to store and query test results

The version of the OpenAPI document: 2.8.3
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Self
from uuid import UUID

from pydantic import (
    BaseModel,
    ConfigDict,
    Field,
    StrictFloat,
    StrictInt,
    StrictStr,
    field_validator,
)


class Result(BaseModel):
    """
    Result
    """

    id: UUID | None = Field(default=None, description="Unique ID of the test result")
    test_id: StrictStr | None = Field(default=None, description="Unique id")
    start_time: StrictStr | None = Field(default=None, description="Timestamp of starttime.")
    duration: StrictFloat | StrictInt | None = Field(
        default=None, description="Duration of test in seconds."
    )
    result: StrictStr | None = Field(default=None, description="Status of result.")
    component: StrictStr | None = Field(default=None, description="A component")
    env: StrictStr | None = Field(
        default=None, description="The environment which is being tested"
    )
    run_id: UUID | None = Field(default=None, description="The run this result is associated with")
    project_id: UUID | None = Field(
        default=None, description="The project this run is associated with"
    )
    metadata: dict[str, Any] | None = None
    params: dict[str, Any] | None = None
    source: StrictStr | None = Field(
        default=None, description="Where the data came from (useful for filtering)"
    )
    __properties: ClassVar[list[str]] = [
        "id",
        "test_id",
        "start_time",
        "duration",
        "result",
        "component",
        "env",
        "run_id",
        "project_id",
        "metadata",
        "params",
        "source",
    ]

    @field_validator("result")
    def result_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in {
            "passed",
            "failed",
            "error",
            "skipped",
            "xpassed",
            "xfailed",
            "manual",
            "blocked",
        }:
            raise ValueError(
                "must be one of enum values ('passed', 'failed', 'error', 'skipped', 'xpassed', 'xfailed', 'manual', 'blocked')"
            )
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self | None:
        """Create an instance of Result from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: set[str] = set()

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if component (nullable) is None
        # and model_fields_set contains the field
        if self.component is None and "component" in self.model_fields_set:
            _dict["component"] = None

        # set to None if env (nullable) is None
        # and model_fields_set contains the field
        if self.env is None and "env" in self.model_fields_set:
            _dict["env"] = None

        # set to None if run_id (nullable) is None
        # and model_fields_set contains the field
        if self.run_id is None and "run_id" in self.model_fields_set:
            _dict["run_id"] = None

        # set to None if project_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_id is None and "project_id" in self.model_fields_set:
            _dict["project_id"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict[str, Any] | None) -> Self | None:
        """Create an instance of Result from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "test_id": obj.get("test_id"),
                "start_time": obj.get("start_time"),
                "duration": obj.get("duration"),
                "result": obj.get("result"),
                "component": obj.get("component"),
                "env": obj.get("env"),
                "run_id": obj.get("run_id"),
                "project_id": obj.get("project_id"),
                "metadata": obj.get("metadata"),
                "params": obj.get("params"),
                "source": obj.get("source"),
            }
        )
        return _obj
