"""
Ibutsu API

A system to store and query test results

The version of the OpenAPI document: 2.8.3
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from __future__ import annotations

import json
import pprint
import re  # noqa: F401
from typing import Any, ClassVar, Self
from uuid import UUID

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr


class Run(BaseModel):
    """
    Run
    """

    id: UUID | None = Field(default=None, description="Unique ID of the test run")
    created: StrictStr | None = Field(default=None, description="The time this record was created")
    duration: StrictFloat | StrictInt | None = Field(
        default=None, description="Duration of tests in seconds"
    )
    source: StrictStr | None = Field(default=None, description="A source for this test run")
    start_time: StrictStr | None = Field(default=None, description="The time the test run started")
    component: StrictStr | None = Field(default=None, description="A component")
    env: StrictStr | None = Field(
        default=None, description="The environment which is being tested"
    )
    project_id: UUID | None = Field(
        default=None, description="The project this run is associated with"
    )
    summary: dict[str, Any] | None = Field(
        default=None, description="A summary of the test results"
    )
    metadata: dict[str, Any] | None = Field(
        default=None, description="Extra metadata for this run"
    )
    __properties: ClassVar[list[str]] = [
        "id",
        "created",
        "duration",
        "source",
        "start_time",
        "component",
        "env",
        "project_id",
        "summary",
        "metadata",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Self | None:
        """Create an instance of Run from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: set[str] = set()

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if source (nullable) is None
        # and model_fields_set contains the field
        if self.source is None and "source" in self.model_fields_set:
            _dict["source"] = None

        # set to None if component (nullable) is None
        # and model_fields_set contains the field
        if self.component is None and "component" in self.model_fields_set:
            _dict["component"] = None

        # set to None if env (nullable) is None
        # and model_fields_set contains the field
        if self.env is None and "env" in self.model_fields_set:
            _dict["env"] = None

        # set to None if project_id (nullable) is None
        # and model_fields_set contains the field
        if self.project_id is None and "project_id" in self.model_fields_set:
            _dict["project_id"] = None

        # set to None if metadata (nullable) is None
        # and model_fields_set contains the field
        if self.metadata is None and "metadata" in self.model_fields_set:
            _dict["metadata"] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict[str, Any] | None) -> Self | None:
        """Create an instance of Run from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "id": obj.get("id"),
                "created": obj.get("created"),
                "duration": obj.get("duration"),
                "source": obj.get("source"),
                "start_time": obj.get("start_time"),
                "component": obj.get("component"),
                "env": obj.get("env"),
                "project_id": obj.get("project_id"),
                "summary": obj.get("summary"),
                "metadata": obj.get("metadata"),
            }
        )
        return _obj
