import { IFileSystem, FileSystemProps } from "aws-cdk-lib/aws-efs";
import { IKey } from "aws-cdk-lib/aws-kms";
import { Construct, IConstruct } from "constructs";
/**
 * Interface for EncryptedFileSystem.
 */
export interface IEncryptedFileSystem extends IConstruct {
    /**
     * The KMS encryption key.
     */
    readonly key: IKey;
    /**
     * The EFS file system.
     */
    readonly fileSystem: IFileSystem;
}
/**
 * Constructor parameters for EncryptedFileSystem.
 *
 * The `encrypted` argument is ignored.
 */
export interface EncryptedFileSystemProps extends FileSystemProps {
}
/**
 * An EncryptedFileSystem.
 */
export declare class EncryptedFileSystem extends Construct implements IEncryptedFileSystem {
    readonly key: IKey;
    readonly fileSystem: IFileSystem;
    /**
     * Creates a new EncryptedFileSystem.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param props - The configuration properties for this construct.
     */
    constructor(scope: IConstruct, id: string, props: EncryptedFileSystemProps);
}
