"""Add delete cascade to fkeys

Revision ID: 13dffb003203
Revises: ad07b1b72351
Create Date: 2023-03-30 15:05:46.835230

"""
from alembic import op
import sqlalchemy as sa
import geoalchemy2


# revision identifiers, used by Alembic.
revision = '13dffb003203'
down_revision = 'ad07b1b72351'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('reference_tag',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.Column('created', sa.DateTime(), nullable=False),
    sa.Column('deleted', sa.DateTime(), nullable=True),
    sa.Column('superceded_id', sa.BigInteger(), nullable=True),
    sa.Column('tag', sa.String(), nullable=True),
    sa.Column('valid', sa.Boolean(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['target_id'], ['reference_table.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_reference_tag_created'), 'reference_tag', ['created'], unique=False)
    op.create_index(op.f('ix_reference_tag_deleted'), 'reference_tag', ['deleted'], unique=False)
    op.create_index(op.f('ix_reference_tag_target_id'), 'reference_tag', ['target_id'], unique=False)
    op.create_table('reference_tag__tests_pcg',
    sa.Column('id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['id'], ['reference_tag.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.drop_constraint('bound_2tag__tests_pcg_id_fkey', 'bound_2tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'bound_2tag__tests_pcg', 'bound_2tag', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('bound_2tag_user__tests_pcg_id_fkey', 'bound_2tag_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'bound_2tag_user__tests_pcg', 'bound_2tag_user', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('bound_double_tag__tests_pcg_id_fkey', 'bound_double_tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'bound_double_tag__tests_pcg', 'bound_double_tag', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('bound_double_tag_user__tests_pcg_id_fkey', 'bound_double_tag_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'bound_double_tag_user__tests_pcg', 'bound_double_tag_user', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('bound_tag__tests_pcg_id_fkey', 'bound_tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'bound_tag__tests_pcg', 'bound_tag', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('bound_tag_user__tests_pcg_id_fkey', 'bound_tag_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'bound_tag_user__tests_pcg', 'bound_tag_user', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('bouton_shape_target_id_fkey', 'bouton_shape', type_='foreignkey')
    op.create_foreign_key(None, 'bouton_shape', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('bouton_shape__tests_pcg_id_fkey', 'bouton_shape__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'bouton_shape__tests_pcg', 'bouton_shape', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('braincircuits_annotation_user__tests_pcg_id_fkey', 'braincircuits_annotation_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'braincircuits_annotation_user__tests_pcg', 'braincircuits_annotation_user', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('cell_type_local__tests_pcg_id_fkey', 'cell_type_local__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'cell_type_local__tests_pcg', 'cell_type_local', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('cell_type_reference_target_id_fkey', 'cell_type_reference', type_='foreignkey')
    op.create_foreign_key(None, 'cell_type_reference', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('cell_type_reference__tests_pcg_id_fkey', 'cell_type_reference__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'cell_type_reference__tests_pcg', 'cell_type_reference', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('compartment_proofread_status__tests_pcg_id_fkey', 'compartment_proofread_status__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'compartment_proofread_status__tests_pcg', 'compartment_proofread_status', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('contact__tests_pcg_id_fkey', 'contact__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'contact__tests_pcg', 'contact', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('derived_numeric_value__tests_pcg_id_fkey', 'derived_numeric_value__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'derived_numeric_value__tests_pcg', 'derived_numeric_value', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('derived_spatial_point__tests_pcg_id_fkey', 'derived_spatial_point__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'derived_spatial_point__tests_pcg', 'derived_spatial_point', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('derived_tag__tests_pcg_id_fkey', 'derived_tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'derived_tag__tests_pcg', 'derived_tag', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('extended_classical_cell_type__tests_pcg_id_fkey', 'extended_classical_cell_type__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'extended_classical_cell_type__tests_pcg', 'extended_classical_cell_type', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('fly_cell_type__tests_pcg_id_fkey', 'fly_cell_type__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'fly_cell_type__tests_pcg', 'fly_cell_type', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('fly_cell_type_ext__tests_pcg_id_fkey', 'fly_cell_type_ext__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'fly_cell_type_ext__tests_pcg', 'fly_cell_type_ext', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('fly_neuropil_target_id_fkey', 'fly_neuropil', type_='foreignkey')
    op.create_foreign_key(None, 'fly_neuropil', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('fly_neuropil__tests_pcg_id_fkey', 'fly_neuropil__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'fly_neuropil__tests_pcg', 'fly_neuropil', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('fly_nt_synapse__tests_pcg_id_fkey', 'fly_nt_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'fly_nt_synapse__tests_pcg', 'fly_nt_synapse', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('fly_synapse__tests_pcg_id_fkey', 'fly_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'fly_synapse__tests_pcg', 'fly_synapse', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('func_unit_ext_coreg_target_id_fkey', 'func_unit_ext_coreg', type_='foreignkey')
    op.create_foreign_key(None, 'func_unit_ext_coreg', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('func_unit_ext_coreg__tests_pcg_id_fkey', 'func_unit_ext_coreg__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'func_unit_ext_coreg__tests_pcg', 'func_unit_ext_coreg', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('glia_contact__tests_pcg_id_fkey', 'glia_contact__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'glia_contact__tests_pcg', 'glia_contact', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('microns_func_coreg__tests_pcg_id_fkey', 'microns_func_coreg__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'microns_func_coreg__tests_pcg', 'microns_func_coreg', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('microns_func_unit_coreg__tests_pcg_id_fkey', 'microns_func_unit_coreg__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'microns_func_unit_coreg__tests_pcg', 'microns_func_unit_coreg', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('nocleft_synapse__tests_pcg_id_fkey', 'nocleft_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'nocleft_synapse__tests_pcg', 'nocleft_synapse', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('nucleus_detection__tests_pcg_id_fkey', 'nucleus_detection__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'nucleus_detection__tests_pcg', 'nucleus_detection', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('plastic_synapse__tests_pcg_id_fkey', 'plastic_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'plastic_synapse__tests_pcg', 'plastic_synapse', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('postsynaptic_compartment_target_id_fkey', 'postsynaptic_compartment', type_='foreignkey')
    op.create_foreign_key(None, 'postsynaptic_compartment', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('postsynaptic_compartment__tests_pcg_id_fkey', 'postsynaptic_compartment__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'postsynaptic_compartment__tests_pcg', 'postsynaptic_compartment', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('presynaptic_bouton_type_target_id_fkey', 'presynaptic_bouton_type', type_='foreignkey')
    op.create_foreign_key(None, 'presynaptic_bouton_type', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('presynaptic_bouton_type__tests_pcg_id_fkey', 'presynaptic_bouton_type__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'presynaptic_bouton_type__tests_pcg', 'presynaptic_bouton_type', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('proofread_status__tests_pcg_id_fkey', 'proofread_status__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'proofread_status__tests_pcg', 'proofread_status', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('proofreading_boolstatus_user__tests_pcg_id_fkey', 'proofreading_boolstatus_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'proofreading_boolstatus_user__tests_pcg', 'proofreading_boolstatus_user', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('reference_point_target_id_fkey', 'reference_point', type_='foreignkey')
    op.create_foreign_key(None, 'reference_point', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('reference_point__tests_pcg_id_fkey', 'reference_point__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'reference_point__tests_pcg', 'reference_point', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('reference_simple_group_target_id_fkey', 'reference_simple_group', type_='foreignkey')
    op.create_foreign_key(None, 'reference_simple_group', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('reference_simple_group__tests_pcg_id_fkey', 'reference_simple_group__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'reference_simple_group__tests_pcg', 'reference_simple_group', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('reference_synapse_valid_target_id_fkey', 'reference_synapse_valid', type_='foreignkey')
    op.create_foreign_key(None, 'reference_synapse_valid', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('reference_synapse_valid__tests_pcg_id_fkey', 'reference_synapse_valid__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'reference_synapse_valid__tests_pcg', 'reference_synapse_valid', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('representative_point__tests_pcg_id_fkey', 'representative_point__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'representative_point__tests_pcg', 'representative_point', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('simple_reference_target_id_fkey', 'simple_reference', type_='foreignkey')
    op.create_foreign_key(None, 'simple_reference', 'reference_table', ['target_id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('simple_reference__tests_pcg_id_fkey', 'simple_reference__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'simple_reference__tests_pcg', 'simple_reference', ['id'], ['id'], ondelete='CASCADE')
    op.drop_constraint('synapse__tests_pcg_id_fkey', 'synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key(None, 'synapse__tests_pcg', 'synapse', ['id'], ['id'], ondelete='CASCADE')
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, 'synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key('synapse__tests_pcg_id_fkey', 'synapse__tests_pcg', 'synapse', ['id'], ['id'])
    op.drop_constraint(None, 'simple_reference__tests_pcg', type_='foreignkey')
    op.create_foreign_key('simple_reference__tests_pcg_id_fkey', 'simple_reference__tests_pcg', 'simple_reference', ['id'], ['id'])
    op.drop_constraint(None, 'simple_reference', type_='foreignkey')
    op.create_foreign_key('simple_reference_target_id_fkey', 'simple_reference', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'representative_point__tests_pcg', type_='foreignkey')
    op.create_foreign_key('representative_point__tests_pcg_id_fkey', 'representative_point__tests_pcg', 'representative_point', ['id'], ['id'])
    op.drop_constraint(None, 'reference_synapse_valid__tests_pcg', type_='foreignkey')
    op.create_foreign_key('reference_synapse_valid__tests_pcg_id_fkey', 'reference_synapse_valid__tests_pcg', 'reference_synapse_valid', ['id'], ['id'])
    op.drop_constraint(None, 'reference_synapse_valid', type_='foreignkey')
    op.create_foreign_key('reference_synapse_valid_target_id_fkey', 'reference_synapse_valid', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'reference_simple_group__tests_pcg', type_='foreignkey')
    op.create_foreign_key('reference_simple_group__tests_pcg_id_fkey', 'reference_simple_group__tests_pcg', 'reference_simple_group', ['id'], ['id'])
    op.drop_constraint(None, 'reference_simple_group', type_='foreignkey')
    op.create_foreign_key('reference_simple_group_target_id_fkey', 'reference_simple_group', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'reference_point__tests_pcg', type_='foreignkey')
    op.create_foreign_key('reference_point__tests_pcg_id_fkey', 'reference_point__tests_pcg', 'reference_point', ['id'], ['id'])
    op.drop_constraint(None, 'reference_point', type_='foreignkey')
    op.create_foreign_key('reference_point_target_id_fkey', 'reference_point', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'proofreading_boolstatus_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key('proofreading_boolstatus_user__tests_pcg_id_fkey', 'proofreading_boolstatus_user__tests_pcg', 'proofreading_boolstatus_user', ['id'], ['id'])
    op.drop_constraint(None, 'proofread_status__tests_pcg', type_='foreignkey')
    op.create_foreign_key('proofread_status__tests_pcg_id_fkey', 'proofread_status__tests_pcg', 'proofread_status', ['id'], ['id'])
    op.drop_constraint(None, 'presynaptic_bouton_type__tests_pcg', type_='foreignkey')
    op.create_foreign_key('presynaptic_bouton_type__tests_pcg_id_fkey', 'presynaptic_bouton_type__tests_pcg', 'presynaptic_bouton_type', ['id'], ['id'])
    op.drop_constraint(None, 'presynaptic_bouton_type', type_='foreignkey')
    op.create_foreign_key('presynaptic_bouton_type_target_id_fkey', 'presynaptic_bouton_type', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'postsynaptic_compartment__tests_pcg', type_='foreignkey')
    op.create_foreign_key('postsynaptic_compartment__tests_pcg_id_fkey', 'postsynaptic_compartment__tests_pcg', 'postsynaptic_compartment', ['id'], ['id'])
    op.drop_constraint(None, 'postsynaptic_compartment', type_='foreignkey')
    op.create_foreign_key('postsynaptic_compartment_target_id_fkey', 'postsynaptic_compartment', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'plastic_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key('plastic_synapse__tests_pcg_id_fkey', 'plastic_synapse__tests_pcg', 'plastic_synapse', ['id'], ['id'])
    op.drop_constraint(None, 'nucleus_detection__tests_pcg', type_='foreignkey')
    op.create_foreign_key('nucleus_detection__tests_pcg_id_fkey', 'nucleus_detection__tests_pcg', 'nucleus_detection', ['id'], ['id'])
    op.drop_constraint(None, 'nocleft_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key('nocleft_synapse__tests_pcg_id_fkey', 'nocleft_synapse__tests_pcg', 'nocleft_synapse', ['id'], ['id'])
    op.drop_constraint(None, 'microns_func_unit_coreg__tests_pcg', type_='foreignkey')
    op.create_foreign_key('microns_func_unit_coreg__tests_pcg_id_fkey', 'microns_func_unit_coreg__tests_pcg', 'microns_func_unit_coreg', ['id'], ['id'])
    op.drop_constraint(None, 'microns_func_coreg__tests_pcg', type_='foreignkey')
    op.create_foreign_key('microns_func_coreg__tests_pcg_id_fkey', 'microns_func_coreg__tests_pcg', 'microns_func_coreg', ['id'], ['id'])
    op.drop_constraint(None, 'glia_contact__tests_pcg', type_='foreignkey')
    op.create_foreign_key('glia_contact__tests_pcg_id_fkey', 'glia_contact__tests_pcg', 'glia_contact', ['id'], ['id'])
    op.drop_constraint(None, 'func_unit_ext_coreg__tests_pcg', type_='foreignkey')
    op.create_foreign_key('func_unit_ext_coreg__tests_pcg_id_fkey', 'func_unit_ext_coreg__tests_pcg', 'func_unit_ext_coreg', ['id'], ['id'])
    op.drop_constraint(None, 'func_unit_ext_coreg', type_='foreignkey')
    op.create_foreign_key('func_unit_ext_coreg_target_id_fkey', 'func_unit_ext_coreg', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'fly_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key('fly_synapse__tests_pcg_id_fkey', 'fly_synapse__tests_pcg', 'fly_synapse', ['id'], ['id'])
    op.drop_constraint(None, 'fly_nt_synapse__tests_pcg', type_='foreignkey')
    op.create_foreign_key('fly_nt_synapse__tests_pcg_id_fkey', 'fly_nt_synapse__tests_pcg', 'fly_nt_synapse', ['id'], ['id'])
    op.drop_constraint(None, 'fly_neuropil__tests_pcg', type_='foreignkey')
    op.create_foreign_key('fly_neuropil__tests_pcg_id_fkey', 'fly_neuropil__tests_pcg', 'fly_neuropil', ['id'], ['id'])
    op.drop_constraint(None, 'fly_neuropil', type_='foreignkey')
    op.create_foreign_key('fly_neuropil_target_id_fkey', 'fly_neuropil', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'fly_cell_type_ext__tests_pcg', type_='foreignkey')
    op.create_foreign_key('fly_cell_type_ext__tests_pcg_id_fkey', 'fly_cell_type_ext__tests_pcg', 'fly_cell_type_ext', ['id'], ['id'])
    op.drop_constraint(None, 'fly_cell_type__tests_pcg', type_='foreignkey')
    op.create_foreign_key('fly_cell_type__tests_pcg_id_fkey', 'fly_cell_type__tests_pcg', 'fly_cell_type', ['id'], ['id'])
    op.drop_constraint(None, 'extended_classical_cell_type__tests_pcg', type_='foreignkey')
    op.create_foreign_key('extended_classical_cell_type__tests_pcg_id_fkey', 'extended_classical_cell_type__tests_pcg', 'extended_classical_cell_type', ['id'], ['id'])
    op.drop_constraint(None, 'derived_tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key('derived_tag__tests_pcg_id_fkey', 'derived_tag__tests_pcg', 'derived_tag', ['id'], ['id'])
    op.drop_constraint(None, 'derived_spatial_point__tests_pcg', type_='foreignkey')
    op.create_foreign_key('derived_spatial_point__tests_pcg_id_fkey', 'derived_spatial_point__tests_pcg', 'derived_spatial_point', ['id'], ['id'])
    op.drop_constraint(None, 'derived_numeric_value__tests_pcg', type_='foreignkey')
    op.create_foreign_key('derived_numeric_value__tests_pcg_id_fkey', 'derived_numeric_value__tests_pcg', 'derived_numeric_value', ['id'], ['id'])
    op.drop_constraint(None, 'contact__tests_pcg', type_='foreignkey')
    op.create_foreign_key('contact__tests_pcg_id_fkey', 'contact__tests_pcg', 'contact', ['id'], ['id'])
    op.drop_constraint(None, 'compartment_proofread_status__tests_pcg', type_='foreignkey')
    op.create_foreign_key('compartment_proofread_status__tests_pcg_id_fkey', 'compartment_proofread_status__tests_pcg', 'compartment_proofread_status', ['id'], ['id'])
    op.drop_constraint(None, 'cell_type_reference__tests_pcg', type_='foreignkey')
    op.create_foreign_key('cell_type_reference__tests_pcg_id_fkey', 'cell_type_reference__tests_pcg', 'cell_type_reference', ['id'], ['id'])
    op.drop_constraint(None, 'cell_type_reference', type_='foreignkey')
    op.create_foreign_key('cell_type_reference_target_id_fkey', 'cell_type_reference', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'cell_type_local__tests_pcg', type_='foreignkey')
    op.create_foreign_key('cell_type_local__tests_pcg_id_fkey', 'cell_type_local__tests_pcg', 'cell_type_local', ['id'], ['id'])
    op.drop_constraint(None, 'braincircuits_annotation_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key('braincircuits_annotation_user__tests_pcg_id_fkey', 'braincircuits_annotation_user__tests_pcg', 'braincircuits_annotation_user', ['id'], ['id'])
    op.drop_constraint(None, 'bouton_shape__tests_pcg', type_='foreignkey')
    op.create_foreign_key('bouton_shape__tests_pcg_id_fkey', 'bouton_shape__tests_pcg', 'bouton_shape', ['id'], ['id'])
    op.drop_constraint(None, 'bouton_shape', type_='foreignkey')
    op.create_foreign_key('bouton_shape_target_id_fkey', 'bouton_shape', 'reference_table', ['target_id'], ['id'])
    op.drop_constraint(None, 'bound_tag_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key('bound_tag_user__tests_pcg_id_fkey', 'bound_tag_user__tests_pcg', 'bound_tag_user', ['id'], ['id'])
    op.drop_constraint(None, 'bound_tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key('bound_tag__tests_pcg_id_fkey', 'bound_tag__tests_pcg', 'bound_tag', ['id'], ['id'])
    op.drop_constraint(None, 'bound_double_tag_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key('bound_double_tag_user__tests_pcg_id_fkey', 'bound_double_tag_user__tests_pcg', 'bound_double_tag_user', ['id'], ['id'])
    op.drop_constraint(None, 'bound_double_tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key('bound_double_tag__tests_pcg_id_fkey', 'bound_double_tag__tests_pcg', 'bound_double_tag', ['id'], ['id'])
    op.drop_constraint(None, 'bound_2tag_user__tests_pcg', type_='foreignkey')
    op.create_foreign_key('bound_2tag_user__tests_pcg_id_fkey', 'bound_2tag_user__tests_pcg', 'bound_2tag_user', ['id'], ['id'])
    op.drop_constraint(None, 'bound_2tag__tests_pcg', type_='foreignkey')
    op.create_foreign_key('bound_2tag__tests_pcg_id_fkey', 'bound_2tag__tests_pcg', 'bound_2tag', ['id'], ['id'])
    op.drop_table('reference_tag__tests_pcg')
    op.drop_index(op.f('ix_reference_tag_target_id'), table_name='reference_tag')
    op.drop_index(op.f('ix_reference_tag_deleted'), table_name='reference_tag')
    op.drop_index(op.f('ix_reference_tag_created'), table_name='reference_tag')
    op.drop_table('reference_tag')
    # ### end Alembic commands ###
