# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['GroupV2Args', 'GroupV2']

@pulumi.input_type
class GroupV2Args:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 ingress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 shared: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a GroupV2 resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the firewall
               group (must be "true" or "false" if provided - defaults to "true").
               Changing this updates the `admin_state_up` of an existing firewall group.
        :param pulumi.Input[str] description: A description for the firewall group. Changing this
               updates the `description` of an existing firewall group.
        :param pulumi.Input[str] egress_firewall_policy_id: The egress firewall policy resource
               id for the firewall group. Changing this updates the
               `egress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] ingress_firewall_policy_id: The ingress firewall policy resource
               id for the firewall group. Changing this updates the
               `ingress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] name: A name for the firewall group. Changing this
               updates the `name` of an existing firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: Port(s) to associate this firewall group
               with. Must be a list of strings. Changing this updates the associated ports
               of an existing firewall group.
        :param pulumi.Input[str] project_id: This argument conflicts and  is interchangeable
               with `tenant_id`. The owner of the firewall group. Required if admin wants
               to create a firewall group for another project. Changing this creates a new
               firewall group.
        :param pulumi.Input[str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall group.
        :param pulumi.Input[bool] shared: Sharing status of the firewall group (must be "true"
               or "false" if provided). If this is "true" the firewall group is visible to,
               and can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall group. Only administrative users
               can specify if the firewall group should be shared.
        :param pulumi.Input[str] tenant_id: This argument conflicts and is interchangeable with
               `project_id`. The owner of the firewall group. Required if admin wants to
               create a firewall group for another tenant. Changing this creates a new
               firewall group.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_firewall_policy_id is not None:
            pulumi.set(__self__, "egress_firewall_policy_id", egress_firewall_policy_id)
        if ingress_firewall_policy_id is not None:
            pulumi.set(__self__, "ingress_firewall_policy_id", ingress_firewall_policy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shared is not None:
            pulumi.set(__self__, "shared", shared)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative up/down status for the firewall
        group (must be "true" or "false" if provided - defaults to "true").
        Changing this updates the `admin_state_up` of an existing firewall group.
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the firewall group. Changing this
        updates the `description` of an existing firewall group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="egressFirewallPolicyId")
    def egress_firewall_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The egress firewall policy resource
        id for the firewall group. Changing this updates the
        `egress_firewall_policy_id` of an existing firewall group.
        """
        return pulumi.get(self, "egress_firewall_policy_id")

    @egress_firewall_policy_id.setter
    def egress_firewall_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_firewall_policy_id", value)

    @property
    @pulumi.getter(name="ingressFirewallPolicyId")
    def ingress_firewall_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ingress firewall policy resource
        id for the firewall group. Changing this updates the
        `ingress_firewall_policy_id` of an existing firewall group.
        """
        return pulumi.get(self, "ingress_firewall_policy_id")

    @ingress_firewall_policy_id.setter
    def ingress_firewall_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_firewall_policy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the firewall group. Changing this
        updates the `name` of an existing firewall.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Port(s) to associate this firewall group
        with. Must be a list of strings. Changing this updates the associated ports
        of an existing firewall group.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        This argument conflicts and  is interchangeable
        with `tenant_id`. The owner of the firewall group. Required if admin wants
        to create a firewall group for another project. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the v2 networking client.
        A networking client is needed to create a firewall group. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def shared(self) -> Optional[pulumi.Input[bool]]:
        """
        Sharing status of the firewall group (must be "true"
        or "false" if provided). If this is "true" the firewall group is visible to,
        and can be used in, firewalls in other tenants. Changing this updates the
        `shared` status of an existing firewall group. Only administrative users
        can specify if the firewall group should be shared.
        """
        return pulumi.get(self, "shared")

    @shared.setter
    def shared(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shared", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        This argument conflicts and is interchangeable with
        `project_id`. The owner of the firewall group. Required if admin wants to
        create a firewall group for another tenant. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _GroupV2State:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 ingress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 shared: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering GroupV2 resources.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the firewall
               group (must be "true" or "false" if provided - defaults to "true").
               Changing this updates the `admin_state_up` of an existing firewall group.
        :param pulumi.Input[str] description: A description for the firewall group. Changing this
               updates the `description` of an existing firewall group.
        :param pulumi.Input[str] egress_firewall_policy_id: The egress firewall policy resource
               id for the firewall group. Changing this updates the
               `egress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] ingress_firewall_policy_id: The ingress firewall policy resource
               id for the firewall group. Changing this updates the
               `ingress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] name: A name for the firewall group. Changing this
               updates the `name` of an existing firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: Port(s) to associate this firewall group
               with. Must be a list of strings. Changing this updates the associated ports
               of an existing firewall group.
        :param pulumi.Input[str] project_id: This argument conflicts and  is interchangeable
               with `tenant_id`. The owner of the firewall group. Required if admin wants
               to create a firewall group for another project. Changing this creates a new
               firewall group.
        :param pulumi.Input[str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall group.
        :param pulumi.Input[bool] shared: Sharing status of the firewall group (must be "true"
               or "false" if provided). If this is "true" the firewall group is visible to,
               and can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall group. Only administrative users
               can specify if the firewall group should be shared.
        :param pulumi.Input[str] status: The status of the firewall group.
        :param pulumi.Input[str] tenant_id: This argument conflicts and is interchangeable with
               `project_id`. The owner of the firewall group. Required if admin wants to
               create a firewall group for another tenant. Changing this creates a new
               firewall group.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if egress_firewall_policy_id is not None:
            pulumi.set(__self__, "egress_firewall_policy_id", egress_firewall_policy_id)
        if ingress_firewall_policy_id is not None:
            pulumi.set(__self__, "ingress_firewall_policy_id", ingress_firewall_policy_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ports is not None:
            pulumi.set(__self__, "ports", ports)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if shared is not None:
            pulumi.set(__self__, "shared", shared)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative up/down status for the firewall
        group (must be "true" or "false" if provided - defaults to "true").
        Changing this updates the `admin_state_up` of an existing firewall group.
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description for the firewall group. Changing this
        updates the `description` of an existing firewall group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="egressFirewallPolicyId")
    def egress_firewall_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The egress firewall policy resource
        id for the firewall group. Changing this updates the
        `egress_firewall_policy_id` of an existing firewall group.
        """
        return pulumi.get(self, "egress_firewall_policy_id")

    @egress_firewall_policy_id.setter
    def egress_firewall_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "egress_firewall_policy_id", value)

    @property
    @pulumi.getter(name="ingressFirewallPolicyId")
    def ingress_firewall_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ingress firewall policy resource
        id for the firewall group. Changing this updates the
        `ingress_firewall_policy_id` of an existing firewall group.
        """
        return pulumi.get(self, "ingress_firewall_policy_id")

    @ingress_firewall_policy_id.setter
    def ingress_firewall_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingress_firewall_policy_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A name for the firewall group. Changing this
        updates the `name` of an existing firewall.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Port(s) to associate this firewall group
        with. Must be a list of strings. Changing this updates the associated ports
        of an existing firewall group.
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        This argument conflicts and  is interchangeable
        with `tenant_id`. The owner of the firewall group. Required if admin wants
        to create a firewall group for another project. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the v2 networking client.
        A networking client is needed to create a firewall group. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def shared(self) -> Optional[pulumi.Input[bool]]:
        """
        Sharing status of the firewall group (must be "true"
        or "false" if provided). If this is "true" the firewall group is visible to,
        and can be used in, firewalls in other tenants. Changing this updates the
        `shared` status of an existing firewall group. Only administrative users
        can specify if the firewall group should be shared.
        """
        return pulumi.get(self, "shared")

    @shared.setter
    def shared(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "shared", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the firewall group.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        This argument conflicts and is interchangeable with
        `project_id`. The owner of the firewall group. Required if admin wants to
        create a firewall group for another tenant. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class GroupV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 ingress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 shared: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a v2 firewall group resource within OpenStack.

        > **Note:** Firewall v2 has no support for OVN currently.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        rule1 = openstack.firewall.RuleV2("rule_1",
            name="firewall_rule_2",
            description="drop TELNET traffic",
            action="deny",
            protocol="tcp",
            destination_port="23",
            enabled=True)
        rule2 = openstack.firewall.RuleV2("rule_2",
            name="firewall_rule_1",
            description="drop NTP traffic",
            action="deny",
            protocol="udp",
            destination_port="123",
            enabled=False)
        policy1 = openstack.firewall.PolicyV2("policy_1",
            name="firewall_ingress_policy",
            rules=[rule1.id])
        policy2 = openstack.firewall.PolicyV2("policy_2",
            name="firewall_egress_policy",
            rules=[rule2.id])
        group1 = openstack.firewall.GroupV2("group_1",
            name="firewall_group",
            ingress_firewall_policy_id=policy1.id,
            egress_firewall_policy_id=policy2.id)
        ```

        ## Import

        Firewall groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:firewall/groupV2:GroupV2 group_1 c9e39fb2-ce20-46c8-a964-25f3898c7a97
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the firewall
               group (must be "true" or "false" if provided - defaults to "true").
               Changing this updates the `admin_state_up` of an existing firewall group.
        :param pulumi.Input[str] description: A description for the firewall group. Changing this
               updates the `description` of an existing firewall group.
        :param pulumi.Input[str] egress_firewall_policy_id: The egress firewall policy resource
               id for the firewall group. Changing this updates the
               `egress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] ingress_firewall_policy_id: The ingress firewall policy resource
               id for the firewall group. Changing this updates the
               `ingress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] name: A name for the firewall group. Changing this
               updates the `name` of an existing firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: Port(s) to associate this firewall group
               with. Must be a list of strings. Changing this updates the associated ports
               of an existing firewall group.
        :param pulumi.Input[str] project_id: This argument conflicts and  is interchangeable
               with `tenant_id`. The owner of the firewall group. Required if admin wants
               to create a firewall group for another project. Changing this creates a new
               firewall group.
        :param pulumi.Input[str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall group.
        :param pulumi.Input[bool] shared: Sharing status of the firewall group (must be "true"
               or "false" if provided). If this is "true" the firewall group is visible to,
               and can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall group. Only administrative users
               can specify if the firewall group should be shared.
        :param pulumi.Input[str] tenant_id: This argument conflicts and is interchangeable with
               `project_id`. The owner of the firewall group. Required if admin wants to
               create a firewall group for another tenant. Changing this creates a new
               firewall group.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[GroupV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a v2 firewall group resource within OpenStack.

        > **Note:** Firewall v2 has no support for OVN currently.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        rule1 = openstack.firewall.RuleV2("rule_1",
            name="firewall_rule_2",
            description="drop TELNET traffic",
            action="deny",
            protocol="tcp",
            destination_port="23",
            enabled=True)
        rule2 = openstack.firewall.RuleV2("rule_2",
            name="firewall_rule_1",
            description="drop NTP traffic",
            action="deny",
            protocol="udp",
            destination_port="123",
            enabled=False)
        policy1 = openstack.firewall.PolicyV2("policy_1",
            name="firewall_ingress_policy",
            rules=[rule1.id])
        policy2 = openstack.firewall.PolicyV2("policy_2",
            name="firewall_egress_policy",
            rules=[rule2.id])
        group1 = openstack.firewall.GroupV2("group_1",
            name="firewall_group",
            ingress_firewall_policy_id=policy1.id,
            egress_firewall_policy_id=policy2.id)
        ```

        ## Import

        Firewall groups can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:firewall/groupV2:GroupV2 group_1 c9e39fb2-ce20-46c8-a964-25f3898c7a97
        ```

        :param str resource_name: The name of the resource.
        :param GroupV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 egress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 ingress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 shared: Optional[pulumi.Input[bool]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupV2Args.__new__(GroupV2Args)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["description"] = description
            __props__.__dict__["egress_firewall_policy_id"] = egress_firewall_policy_id
            __props__.__dict__["ingress_firewall_policy_id"] = ingress_firewall_policy_id
            __props__.__dict__["name"] = name
            __props__.__dict__["ports"] = ports
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["region"] = region
            __props__.__dict__["shared"] = shared
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["status"] = None
        super(GroupV2, __self__).__init__(
            'openstack:firewall/groupV2:GroupV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            egress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
            ingress_firewall_policy_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            ports: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            shared: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'GroupV2':
        """
        Get an existing GroupV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the firewall
               group (must be "true" or "false" if provided - defaults to "true").
               Changing this updates the `admin_state_up` of an existing firewall group.
        :param pulumi.Input[str] description: A description for the firewall group. Changing this
               updates the `description` of an existing firewall group.
        :param pulumi.Input[str] egress_firewall_policy_id: The egress firewall policy resource
               id for the firewall group. Changing this updates the
               `egress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] ingress_firewall_policy_id: The ingress firewall policy resource
               id for the firewall group. Changing this updates the
               `ingress_firewall_policy_id` of an existing firewall group.
        :param pulumi.Input[str] name: A name for the firewall group. Changing this
               updates the `name` of an existing firewall.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ports: Port(s) to associate this firewall group
               with. Must be a list of strings. Changing this updates the associated ports
               of an existing firewall group.
        :param pulumi.Input[str] project_id: This argument conflicts and  is interchangeable
               with `tenant_id`. The owner of the firewall group. Required if admin wants
               to create a firewall group for another project. Changing this creates a new
               firewall group.
        :param pulumi.Input[str] region: The region in which to obtain the v2 networking client.
               A networking client is needed to create a firewall group. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               firewall group.
        :param pulumi.Input[bool] shared: Sharing status of the firewall group (must be "true"
               or "false" if provided). If this is "true" the firewall group is visible to,
               and can be used in, firewalls in other tenants. Changing this updates the
               `shared` status of an existing firewall group. Only administrative users
               can specify if the firewall group should be shared.
        :param pulumi.Input[str] status: The status of the firewall group.
        :param pulumi.Input[str] tenant_id: This argument conflicts and is interchangeable with
               `project_id`. The owner of the firewall group. Required if admin wants to
               create a firewall group for another tenant. Changing this creates a new
               firewall group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupV2State.__new__(_GroupV2State)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["description"] = description
        __props__.__dict__["egress_firewall_policy_id"] = egress_firewall_policy_id
        __props__.__dict__["ingress_firewall_policy_id"] = ingress_firewall_policy_id
        __props__.__dict__["name"] = name
        __props__.__dict__["ports"] = ports
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["region"] = region
        __props__.__dict__["shared"] = shared
        __props__.__dict__["status"] = status
        __props__.__dict__["tenant_id"] = tenant_id
        return GroupV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[bool]]:
        """
        Administrative up/down status for the firewall
        group (must be "true" or "false" if provided - defaults to "true").
        Changing this updates the `admin_state_up` of an existing firewall group.
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description for the firewall group. Changing this
        updates the `description` of an existing firewall group.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="egressFirewallPolicyId")
    def egress_firewall_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        The egress firewall policy resource
        id for the firewall group. Changing this updates the
        `egress_firewall_policy_id` of an existing firewall group.
        """
        return pulumi.get(self, "egress_firewall_policy_id")

    @property
    @pulumi.getter(name="ingressFirewallPolicyId")
    def ingress_firewall_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ingress firewall policy resource
        id for the firewall group. Changing this updates the
        `ingress_firewall_policy_id` of an existing firewall group.
        """
        return pulumi.get(self, "ingress_firewall_policy_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A name for the firewall group. Changing this
        updates the `name` of an existing firewall.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Port(s) to associate this firewall group
        with. Must be a list of strings. Changing this updates the associated ports
        of an existing firewall group.
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        This argument conflicts and  is interchangeable
        with `tenant_id`. The owner of the firewall group. Required if admin wants
        to create a firewall group for another project. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the v2 networking client.
        A networking client is needed to create a firewall group. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def shared(self) -> pulumi.Output[Optional[bool]]:
        """
        Sharing status of the firewall group (must be "true"
        or "false" if provided). If this is "true" the firewall group is visible to,
        and can be used in, firewalls in other tenants. Changing this updates the
        `shared` status of an existing firewall group. Only administrative users
        can specify if the firewall group should be shared.
        """
        return pulumi.get(self, "shared")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the firewall group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        This argument conflicts and is interchangeable with
        `project_id`. The owner of the firewall group. Required if admin wants to
        create a firewall group for another tenant. Changing this creates a new
        firewall group.
        """
        return pulumi.get(self, "tenant_id")

