# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['LbLoadbalancerV2Args', 'LbLoadbalancerV2']

@pulumi.input_type
class LbLoadbalancerV2Args:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None,
                 vip_network_id: Optional[pulumi.Input[str]] = None,
                 vip_port_id: Optional[pulumi.Input[str]] = None,
                 vip_qos_policy_id: Optional[pulumi.Input[str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a LbLoadbalancerV2 resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the Loadbalancer.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[str] availability_zone: The availability zone of the Loadbalancer.
               Changing this creates a new loadbalancer. Available only for Octavia
               **minor version 2.14 or later**.
        :param pulumi.Input[str] description: Human-readable description for the Loadbalancer.
        :param pulumi.Input[str] flavor_id: The UUID of a flavor. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[str] loadbalancer_provider: The name of the provider. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the Loadbalancer. Does not have
               to be unique.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB member.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group IDs to apply to the
               loadbalancer. The security groups must be specified by ID and not name (as
               opposed to how they are configured with the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of simple strings assigned to the loadbalancer.
               Available only for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Loadbalancer.  Only administrative users can specify a tenant UUID
               other than their own.  Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer.
               Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_network_id: The network on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_port_id: The port UUID that the loadbalancer will use.
               Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_qos_policy_id: The ID of the QoS Policy which will 
               be applied to the Virtual IP (VIP).
        :param pulumi.Input[str] vip_subnet_id: The subnet on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vip_address is not None:
            pulumi.set(__self__, "vip_address", vip_address)
        if vip_network_id is not None:
            pulumi.set(__self__, "vip_network_id", vip_network_id)
        if vip_port_id is not None:
            pulumi.set(__self__, "vip_port_id", vip_port_id)
        if vip_qos_policy_id is not None:
            pulumi.set(__self__, "vip_qos_policy_id", vip_qos_policy_id)
        if vip_subnet_id is not None:
            pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the Loadbalancer.
        A valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone of the Loadbalancer.
        Changing this creates a new loadbalancer. Available only for Octavia
        **minor version 2.14 or later**.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the Loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of a flavor. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the provider. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the Loadbalancer. Does not have
        to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an LB member. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        LB member.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group IDs to apply to the
        loadbalancer. The security groups must be specified by ID and not name (as
        opposed to how they are configured with the Compute Instance).
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of simple strings assigned to the loadbalancer.
        Available only for Octavia **minor version 2.5 or later**.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required for admins. The UUID of the tenant who owns
        the Loadbalancer.  Only administrative users can specify a tenant UUID
        other than their own.  Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the load balancer.
        Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @vip_address.setter
    def vip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_address", value)

    @property
    @pulumi.getter(name="vipNetworkId")
    def vip_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network on which to allocate the
        Loadbalancer's address. A tenant can only create Loadbalancers on networks
        authorized by policy (e.g. networks that belong to them or networks that
        are shared).  Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_network_id")

    @vip_network_id.setter
    def vip_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_network_id", value)

    @property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The port UUID that the loadbalancer will use.
        Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_port_id")

    @vip_port_id.setter
    def vip_port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_port_id", value)

    @property
    @pulumi.getter(name="vipQosPolicyId")
    def vip_qos_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the QoS Policy which will 
        be applied to the Virtual IP (VIP).
        """
        return pulumi.get(self, "vip_qos_policy_id")

    @vip_qos_policy_id.setter
    def vip_qos_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_qos_policy_id", value)

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet on which to allocate the
        Loadbalancer's address. A tenant can only create Loadbalancers on networks
        authorized by policy (e.g. networks that belong to them or networks that
        are shared).  Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_subnet_id")

    @vip_subnet_id.setter
    def vip_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_subnet_id", value)


@pulumi.input_type
class _LbLoadbalancerV2State:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None,
                 vip_network_id: Optional[pulumi.Input[str]] = None,
                 vip_port_id: Optional[pulumi.Input[str]] = None,
                 vip_qos_policy_id: Optional[pulumi.Input[str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering LbLoadbalancerV2 resources.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the Loadbalancer.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[str] availability_zone: The availability zone of the Loadbalancer.
               Changing this creates a new loadbalancer. Available only for Octavia
               **minor version 2.14 or later**.
        :param pulumi.Input[str] description: Human-readable description for the Loadbalancer.
        :param pulumi.Input[str] flavor_id: The UUID of a flavor. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[str] loadbalancer_provider: The name of the provider. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the Loadbalancer. Does not have
               to be unique.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB member.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group IDs to apply to the
               loadbalancer. The security groups must be specified by ID and not name (as
               opposed to how they are configured with the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of simple strings assigned to the loadbalancer.
               Available only for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Loadbalancer.  Only administrative users can specify a tenant UUID
               other than their own.  Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer.
               Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_network_id: The network on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_port_id: The port UUID that the loadbalancer will use.
               Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_qos_policy_id: The ID of the QoS Policy which will 
               be applied to the Virtual IP (VIP).
        :param pulumi.Input[str] vip_subnet_id: The subnet on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if vip_address is not None:
            pulumi.set(__self__, "vip_address", vip_address)
        if vip_network_id is not None:
            pulumi.set(__self__, "vip_network_id", vip_network_id)
        if vip_port_id is not None:
            pulumi.set(__self__, "vip_port_id", vip_port_id)
        if vip_qos_policy_id is not None:
            pulumi.set(__self__, "vip_qos_policy_id", vip_qos_policy_id)
        if vip_subnet_id is not None:
            pulumi.set(__self__, "vip_subnet_id", vip_subnet_id)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        The administrative state of the Loadbalancer.
        A valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The availability zone of the Loadbalancer.
        Changing this creates a new loadbalancer. Available only for Octavia
        **minor version 2.14 or later**.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description for the Loadbalancer.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[str]]:
        """
        The UUID of a flavor. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor_id", value)

    @property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the provider. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable name for the Loadbalancer. Does not have
        to be unique.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an LB member. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        LB member.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of security group IDs to apply to the
        loadbalancer. The security groups must be specified by ID and not name (as
        opposed to how they are configured with the Compute Instance).
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of simple strings assigned to the loadbalancer.
        Available only for Octavia **minor version 2.5 or later**.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required for admins. The UUID of the tenant who owns
        the Loadbalancer.  Only administrative users can specify a tenant UUID
        other than their own.  Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the load balancer.
        Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @vip_address.setter
    def vip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_address", value)

    @property
    @pulumi.getter(name="vipNetworkId")
    def vip_network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The network on which to allocate the
        Loadbalancer's address. A tenant can only create Loadbalancers on networks
        authorized by policy (e.g. networks that belong to them or networks that
        are shared).  Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_network_id")

    @vip_network_id.setter
    def vip_network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_network_id", value)

    @property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> Optional[pulumi.Input[str]]:
        """
        The port UUID that the loadbalancer will use.
        Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_port_id")

    @vip_port_id.setter
    def vip_port_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_port_id", value)

    @property
    @pulumi.getter(name="vipQosPolicyId")
    def vip_qos_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the QoS Policy which will 
        be applied to the Virtual IP (VIP).
        """
        return pulumi.get(self, "vip_qos_policy_id")

    @vip_qos_policy_id.setter
    def vip_qos_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_qos_policy_id", value)

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet on which to allocate the
        Loadbalancer's address. A tenant can only create Loadbalancers on networks
        authorized by policy (e.g. networks that belong to them or networks that
        are shared).  Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_subnet_id")

    @vip_subnet_id.setter
    def vip_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vip_subnet_id", value)


class LbLoadbalancerV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None,
                 vip_network_id: Optional[pulumi.Input[str]] = None,
                 vip_port_id: Optional[pulumi.Input[str]] = None,
                 vip_qos_policy_id: Optional[pulumi.Input[str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a V2 loadbalancer resource within OpenStack.

        > **Note:** This resource has attributes that depend on octavia minor versions.
        Please ensure your Openstack cloud supports the required minor version.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        lb1 = openstack.LbLoadbalancerV2("lb_1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```

        ## Import

        Load Balancer can be imported using the Load Balancer ID, e.g.:

        ```sh
        $ pulumi import openstack:index/lbLoadbalancerV2:LbLoadbalancerV2 loadbalancer_1 19bcfdc7-c521-4a7e-9459-6750bd16df76
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the Loadbalancer.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[str] availability_zone: The availability zone of the Loadbalancer.
               Changing this creates a new loadbalancer. Available only for Octavia
               **minor version 2.14 or later**.
        :param pulumi.Input[str] description: Human-readable description for the Loadbalancer.
        :param pulumi.Input[str] flavor_id: The UUID of a flavor. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[str] loadbalancer_provider: The name of the provider. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the Loadbalancer. Does not have
               to be unique.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB member.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group IDs to apply to the
               loadbalancer. The security groups must be specified by ID and not name (as
               opposed to how they are configured with the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of simple strings assigned to the loadbalancer.
               Available only for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Loadbalancer.  Only administrative users can specify a tenant UUID
               other than their own.  Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer.
               Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_network_id: The network on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_port_id: The port UUID that the loadbalancer will use.
               Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_qos_policy_id: The ID of the QoS Policy which will 
               be applied to the Virtual IP (VIP).
        :param pulumi.Input[str] vip_subnet_id: The subnet on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[LbLoadbalancerV2Args] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 loadbalancer resource within OpenStack.

        > **Note:** This resource has attributes that depend on octavia minor versions.
        Please ensure your Openstack cloud supports the required minor version.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_openstack as openstack

        lb1 = openstack.LbLoadbalancerV2("lb_1", vip_subnet_id="d9415786-5f1a-428b-b35f-2f1523e146d2")
        ```

        ## Import

        Load Balancer can be imported using the Load Balancer ID, e.g.:

        ```sh
        $ pulumi import openstack:index/lbLoadbalancerV2:LbLoadbalancerV2 loadbalancer_1 19bcfdc7-c521-4a7e-9459-6750bd16df76
        ```

        :param str resource_name: The name of the resource.
        :param LbLoadbalancerV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LbLoadbalancerV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 flavor_id: Optional[pulumi.Input[str]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 vip_address: Optional[pulumi.Input[str]] = None,
                 vip_network_id: Optional[pulumi.Input[str]] = None,
                 vip_port_id: Optional[pulumi.Input[str]] = None,
                 vip_qos_policy_id: Optional[pulumi.Input[str]] = None,
                 vip_subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LbLoadbalancerV2Args.__new__(LbLoadbalancerV2Args)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["description"] = description
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["vip_address"] = vip_address
            __props__.__dict__["vip_network_id"] = vip_network_id
            __props__.__dict__["vip_port_id"] = vip_port_id
            __props__.__dict__["vip_qos_policy_id"] = vip_qos_policy_id
            __props__.__dict__["vip_subnet_id"] = vip_subnet_id
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="openstack:loadbalancer/loadBalancer:LoadBalancer")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(LbLoadbalancerV2, __self__).__init__(
            'openstack:index/lbLoadbalancerV2:LbLoadbalancerV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            flavor_id: Optional[pulumi.Input[str]] = None,
            loadbalancer_provider: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            vip_address: Optional[pulumi.Input[str]] = None,
            vip_network_id: Optional[pulumi.Input[str]] = None,
            vip_port_id: Optional[pulumi.Input[str]] = None,
            vip_qos_policy_id: Optional[pulumi.Input[str]] = None,
            vip_subnet_id: Optional[pulumi.Input[str]] = None) -> 'LbLoadbalancerV2':
        """
        Get an existing LbLoadbalancerV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: The administrative state of the Loadbalancer.
               A valid value is true (UP) or false (DOWN).
        :param pulumi.Input[str] availability_zone: The availability zone of the Loadbalancer.
               Changing this creates a new loadbalancer. Available only for Octavia
               **minor version 2.14 or later**.
        :param pulumi.Input[str] description: Human-readable description for the Loadbalancer.
        :param pulumi.Input[str] flavor_id: The UUID of a flavor. Changing this creates a new
               loadbalancer.
        :param pulumi.Input[str] loadbalancer_provider: The name of the provider. Changing this
               creates a new loadbalancer.
        :param pulumi.Input[str] name: Human-readable name for the Loadbalancer. Does not have
               to be unique.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create an LB member. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               LB member.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list of security group IDs to apply to the
               loadbalancer. The security groups must be specified by ID and not name (as
               opposed to how they are configured with the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of simple strings assigned to the loadbalancer.
               Available only for Octavia **minor version 2.5 or later**.
        :param pulumi.Input[str] tenant_id: Required for admins. The UUID of the tenant who owns
               the Loadbalancer.  Only administrative users can specify a tenant UUID
               other than their own.  Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_address: The ip address of the load balancer.
               Changing this creates a new loadbalancer.
        :param pulumi.Input[str] vip_network_id: The network on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_port_id: The port UUID that the loadbalancer will use.
               Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        :param pulumi.Input[str] vip_qos_policy_id: The ID of the QoS Policy which will 
               be applied to the Virtual IP (VIP).
        :param pulumi.Input[str] vip_subnet_id: The subnet on which to allocate the
               Loadbalancer's address. A tenant can only create Loadbalancers on networks
               authorized by policy (e.g. networks that belong to them or networks that
               are shared).  Changing this creates a new loadbalancer. Exactly one of
               `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LbLoadbalancerV2State.__new__(_LbLoadbalancerV2State)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["description"] = description
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["vip_address"] = vip_address
        __props__.__dict__["vip_network_id"] = vip_network_id
        __props__.__dict__["vip_port_id"] = vip_port_id
        __props__.__dict__["vip_qos_policy_id"] = vip_qos_policy_id
        __props__.__dict__["vip_subnet_id"] = vip_subnet_id
        return LbLoadbalancerV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[Optional[bool]]:
        """
        The administrative state of the Loadbalancer.
        A valid value is true (UP) or false (DOWN).
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[Optional[str]]:
        """
        The availability zone of the Loadbalancer.
        Changing this creates a new loadbalancer. Available only for Octavia
        **minor version 2.14 or later**.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description for the Loadbalancer.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[str]:
        """
        The UUID of a flavor. Changing this creates a new
        loadbalancer.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> pulumi.Output[str]:
        """
        The name of the provider. Changing this
        creates a new loadbalancer.
        """
        return pulumi.get(self, "loadbalancer_provider")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Human-readable name for the Loadbalancer. Does not have
        to be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create an LB member. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        LB member.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of security group IDs to apply to the
        loadbalancer. The security groups must be specified by ID and not name (as
        opposed to how they are configured with the Compute Instance).
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of simple strings assigned to the loadbalancer.
        Available only for Octavia **minor version 2.5 or later**.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        Required for admins. The UUID of the tenant who owns
        the Loadbalancer.  Only administrative users can specify a tenant UUID
        other than their own.  Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="vipAddress")
    def vip_address(self) -> pulumi.Output[str]:
        """
        The ip address of the load balancer.
        Changing this creates a new loadbalancer.
        """
        return pulumi.get(self, "vip_address")

    @property
    @pulumi.getter(name="vipNetworkId")
    def vip_network_id(self) -> pulumi.Output[str]:
        """
        The network on which to allocate the
        Loadbalancer's address. A tenant can only create Loadbalancers on networks
        authorized by policy (e.g. networks that belong to them or networks that
        are shared).  Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_network_id")

    @property
    @pulumi.getter(name="vipPortId")
    def vip_port_id(self) -> pulumi.Output[str]:
        """
        The port UUID that the loadbalancer will use.
        Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_port_id")

    @property
    @pulumi.getter(name="vipQosPolicyId")
    def vip_qos_policy_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ID of the QoS Policy which will 
        be applied to the Virtual IP (VIP).
        """
        return pulumi.get(self, "vip_qos_policy_id")

    @property
    @pulumi.getter(name="vipSubnetId")
    def vip_subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet on which to allocate the
        Loadbalancer's address. A tenant can only create Loadbalancers on networks
        authorized by policy (e.g. networks that belong to them or networks that
        are shared).  Changing this creates a new loadbalancer. Exactly one of
        `vip_subnet_id`, `vip_network_id` or `vip_port_id` has to be defined.
        """
        return pulumi.get(self, "vip_subnet_id")

