# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PortArgs', 'Port']

@pulumi.input_type
class PortArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 allowed_address_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]]] = None,
                 binding: Optional[pulumi.Input['PortBindingArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 device_owner: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 extra_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]]] = None,
                 fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 no_fixed_ip: Optional[pulumi.Input[bool]] = None,
                 no_security_groups: Optional[pulumi.Input[bool]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 qos_policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Port resource.
        :param pulumi.Input[str] network_id: The ID of the network to attach the port to. Changing
               this creates a new port.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the port
               (must be `true` or `false` if provided). Changing this updates the
               `admin_state_up` of an existing port.
        :param pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]] allowed_address_pairs: An IP/MAC Address pair of additional IP
               addresses that can be active on this port. The structure is described
               below.
        :param pulumi.Input['PortBindingArgs'] binding: The port binding allows to specify binding information
               for the port. The structure is described below.
        :param pulumi.Input[str] description: Human-readable description of the port. Changing
               this updates the `description` of an existing port.
        :param pulumi.Input[str] device_id: The ID of the device attached to the port. Changing this
               creates a new port.
        :param pulumi.Input[str] device_owner: The device owner of the port. Changing this creates
               a new port.
        :param pulumi.Input[str] dns_name: The port DNS name. Available, when Neutron DNS extension
               is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]] extra_dhcp_options: An extra DHCP option that needs to be configured
               on the port. The structure is described below. Can be specified multiple
               times.
        :param pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]] fixed_ips: An array of desired IPs for
               this port. The structure is described below.
        :param pulumi.Input[str] mac_address: Specify a specific MAC address for the port. Changing
               this creates a new port.
        :param pulumi.Input[str] name: A unique name for the port. Changing this
               updates the `name` of an existing port.
        :param pulumi.Input[bool] no_fixed_ip: Create a port with no fixed
               IP address. This will also remove any fixed IPs previously set on a port. `true`
               is the only valid value for this argument.
        :param pulumi.Input[bool] no_security_groups: If set to
               `true`, then no security groups are applied to the port. If set to `false` and
               no `security_group_ids` are specified, then the port will yield to the default
               behavior of the Networking service, which is to usually apply the "default"
               security group.
        :param pulumi.Input[bool] port_security_enabled: Whether to explicitly enable or disable
               port security on the port. Port Security is usually enabled by default, so
               omitting argument will usually result in a value of `true`. Setting this
               explicitly to `false` will disable port security. In order to disable port
               security, the port must not have any security groups. Valid values are `true`
               and `false`.
        :param pulumi.Input[str] qos_policy_id: Reference to the associated QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a port. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list
               of security group IDs to apply to the port. The security groups must be
               specified by ID and not name (as opposed to how they are configured with
               the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the port. Required if admin wants
               to create a port for another tenant. Changing this creates a new port.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options.
        """
        pulumi.set(__self__, "network_id", network_id)
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if allowed_address_pairs is not None:
            pulumi.set(__self__, "allowed_address_pairs", allowed_address_pairs)
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if device_owner is not None:
            pulumi.set(__self__, "device_owner", device_owner)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if extra_dhcp_options is not None:
            pulumi.set(__self__, "extra_dhcp_options", extra_dhcp_options)
        if fixed_ips is not None:
            pulumi.set(__self__, "fixed_ips", fixed_ips)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if no_fixed_ip is not None:
            pulumi.set(__self__, "no_fixed_ip", no_fixed_ip)
        if no_security_groups is not None:
            pulumi.set(__self__, "no_security_groups", no_security_groups)
        if port_security_enabled is not None:
            pulumi.set(__self__, "port_security_enabled", port_security_enabled)
        if qos_policy_id is not None:
            pulumi.set(__self__, "qos_policy_id", qos_policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        The ID of the network to attach the port to. Changing
        this creates a new port.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative up/down status for the port
        (must be `true` or `false` if provided). Changing this updates the
        `admin_state_up` of an existing port.
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="allowedAddressPairs")
    def allowed_address_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]]]:
        """
        An IP/MAC Address pair of additional IP
        addresses that can be active on this port. The structure is described
        below.
        """
        return pulumi.get(self, "allowed_address_pairs")

    @allowed_address_pairs.setter
    def allowed_address_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]]]):
        pulumi.set(self, "allowed_address_pairs", value)

    @property
    @pulumi.getter
    def binding(self) -> Optional[pulumi.Input['PortBindingArgs']]:
        """
        The port binding allows to specify binding information
        for the port. The structure is described below.
        """
        return pulumi.get(self, "binding")

    @binding.setter
    def binding(self, value: Optional[pulumi.Input['PortBindingArgs']]):
        pulumi.set(self, "binding", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description of the port. Changing
        this updates the `description` of an existing port.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the device attached to the port. Changing this
        creates a new port.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="deviceOwner")
    def device_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The device owner of the port. Changing this creates
        a new port.
        """
        return pulumi.get(self, "device_owner")

    @device_owner.setter
    def device_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_owner", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The port DNS name. Available, when Neutron DNS extension
        is enabled.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="extraDhcpOptions")
    def extra_dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]]]:
        """
        An extra DHCP option that needs to be configured
        on the port. The structure is described below. Can be specified multiple
        times.
        """
        return pulumi.get(self, "extra_dhcp_options")

    @extra_dhcp_options.setter
    def extra_dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]]]):
        pulumi.set(self, "extra_dhcp_options", value)

    @property
    @pulumi.getter(name="fixedIps")
    def fixed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]]]:
        """
        An array of desired IPs for
        this port. The structure is described below.
        """
        return pulumi.get(self, "fixed_ips")

    @fixed_ips.setter
    def fixed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]]]):
        pulumi.set(self, "fixed_ips", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a specific MAC address for the port. Changing
        this creates a new port.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the port. Changing this
        updates the `name` of an existing port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="noFixedIp")
    def no_fixed_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Create a port with no fixed
        IP address. This will also remove any fixed IPs previously set on a port. `true`
        is the only valid value for this argument.
        """
        return pulumi.get(self, "no_fixed_ip")

    @no_fixed_ip.setter
    def no_fixed_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_fixed_ip", value)

    @property
    @pulumi.getter(name="noSecurityGroups")
    def no_security_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to
        `true`, then no security groups are applied to the port. If set to `false` and
        no `security_group_ids` are specified, then the port will yield to the default
        behavior of the Networking service, which is to usually apply the "default"
        security group.
        """
        return pulumi.get(self, "no_security_groups")

    @no_security_groups.setter
    def no_security_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_security_groups", value)

    @property
    @pulumi.getter(name="portSecurityEnabled")
    def port_security_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to explicitly enable or disable
        port security on the port. Port Security is usually enabled by default, so
        omitting argument will usually result in a value of `true`. Setting this
        explicitly to `false` will disable port security. In order to disable port
        security, the port must not have any security groups. Valid values are `true`
        and `false`.
        """
        return pulumi.get(self, "port_security_enabled")

    @port_security_enabled.setter
    def port_security_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_security_enabled", value)

    @property
    @pulumi.getter(name="qosPolicyId")
    def qos_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Reference to the associated QoS policy.
        """
        return pulumi.get(self, "qos_policy_id")

    @qos_policy_id.setter
    def qos_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qos_policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a port. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        port.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list
        of security group IDs to apply to the port. The security groups must be
        specified by ID and not name (as opposed to how they are configured with
        the Compute Instance).
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of string tags for the port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The owner of the port. Required if admin wants
        to create a port for another tenant. Changing this creates a new port.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "value_specs", value)


@pulumi.input_type
class _PortState:
    def __init__(__self__, *,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 all_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 all_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_address_pairs: Optional[pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]]] = None,
                 binding: Optional[pulumi.Input['PortBindingArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 device_owner: Optional[pulumi.Input[str]] = None,
                 dns_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 extra_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]]] = None,
                 fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_fixed_ip: Optional[pulumi.Input[bool]] = None,
                 no_security_groups: Optional[pulumi.Input[bool]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 qos_policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Port resources.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the port
               (must be `true` or `false` if provided). Changing this updates the
               `admin_state_up` of an existing port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_fixed_ips: The collection of Fixed IP addresses on the port in the
               order returned by the Network v2 API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_security_group_ids: The collection of Security Group IDs on the port
               which have been explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_tags: The collection of tags assigned on the port, which have been
               explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]] allowed_address_pairs: An IP/MAC Address pair of additional IP
               addresses that can be active on this port. The structure is described
               below.
        :param pulumi.Input['PortBindingArgs'] binding: The port binding allows to specify binding information
               for the port. The structure is described below.
        :param pulumi.Input[str] description: Human-readable description of the port. Changing
               this updates the `description` of an existing port.
        :param pulumi.Input[str] device_id: The ID of the device attached to the port. Changing this
               creates a new port.
        :param pulumi.Input[str] device_owner: The device owner of the port. Changing this creates
               a new port.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] dns_assignments: The list of maps representing port DNS assignments.
        :param pulumi.Input[str] dns_name: The port DNS name. Available, when Neutron DNS extension
               is enabled.
        :param pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]] extra_dhcp_options: An extra DHCP option that needs to be configured
               on the port. The structure is described below. Can be specified multiple
               times.
        :param pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]] fixed_ips: An array of desired IPs for
               this port. The structure is described below.
        :param pulumi.Input[str] mac_address: Specify a specific MAC address for the port. Changing
               this creates a new port.
        :param pulumi.Input[str] name: A unique name for the port. Changing this
               updates the `name` of an existing port.
        :param pulumi.Input[str] network_id: The ID of the network to attach the port to. Changing
               this creates a new port.
        :param pulumi.Input[bool] no_fixed_ip: Create a port with no fixed
               IP address. This will also remove any fixed IPs previously set on a port. `true`
               is the only valid value for this argument.
        :param pulumi.Input[bool] no_security_groups: If set to
               `true`, then no security groups are applied to the port. If set to `false` and
               no `security_group_ids` are specified, then the port will yield to the default
               behavior of the Networking service, which is to usually apply the "default"
               security group.
        :param pulumi.Input[bool] port_security_enabled: Whether to explicitly enable or disable
               port security on the port. Port Security is usually enabled by default, so
               omitting argument will usually result in a value of `true`. Setting this
               explicitly to `false` will disable port security. In order to disable port
               security, the port must not have any security groups. Valid values are `true`
               and `false`.
        :param pulumi.Input[str] qos_policy_id: Reference to the associated QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a port. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list
               of security group IDs to apply to the port. The security groups must be
               specified by ID and not name (as opposed to how they are configured with
               the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the port. Required if admin wants
               to create a port for another tenant. Changing this creates a new port.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options.
        """
        if admin_state_up is not None:
            pulumi.set(__self__, "admin_state_up", admin_state_up)
        if all_fixed_ips is not None:
            pulumi.set(__self__, "all_fixed_ips", all_fixed_ips)
        if all_security_group_ids is not None:
            pulumi.set(__self__, "all_security_group_ids", all_security_group_ids)
        if all_tags is not None:
            pulumi.set(__self__, "all_tags", all_tags)
        if allowed_address_pairs is not None:
            pulumi.set(__self__, "allowed_address_pairs", allowed_address_pairs)
        if binding is not None:
            pulumi.set(__self__, "binding", binding)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if device_id is not None:
            pulumi.set(__self__, "device_id", device_id)
        if device_owner is not None:
            pulumi.set(__self__, "device_owner", device_owner)
        if dns_assignments is not None:
            pulumi.set(__self__, "dns_assignments", dns_assignments)
        if dns_name is not None:
            pulumi.set(__self__, "dns_name", dns_name)
        if extra_dhcp_options is not None:
            pulumi.set(__self__, "extra_dhcp_options", extra_dhcp_options)
        if fixed_ips is not None:
            pulumi.set(__self__, "fixed_ips", fixed_ips)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if no_fixed_ip is not None:
            pulumi.set(__self__, "no_fixed_ip", no_fixed_ip)
        if no_security_groups is not None:
            pulumi.set(__self__, "no_security_groups", no_security_groups)
        if port_security_enabled is not None:
            pulumi.set(__self__, "port_security_enabled", port_security_enabled)
        if qos_policy_id is not None:
            pulumi.set(__self__, "qos_policy_id", qos_policy_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if value_specs is not None:
            pulumi.set(__self__, "value_specs", value_specs)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> Optional[pulumi.Input[bool]]:
        """
        Administrative up/down status for the port
        (must be `true` or `false` if provided). Changing this updates the
        `admin_state_up` of an existing port.
        """
        return pulumi.get(self, "admin_state_up")

    @admin_state_up.setter
    def admin_state_up(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "admin_state_up", value)

    @property
    @pulumi.getter(name="allFixedIps")
    def all_fixed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of Fixed IP addresses on the port in the
        order returned by the Network v2 API.
        """
        return pulumi.get(self, "all_fixed_ips")

    @all_fixed_ips.setter
    def all_fixed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "all_fixed_ips", value)

    @property
    @pulumi.getter(name="allSecurityGroupIds")
    def all_security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of Security Group IDs on the port
        which have been explicitly and implicitly added.
        """
        return pulumi.get(self, "all_security_group_ids")

    @all_security_group_ids.setter
    def all_security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "all_security_group_ids", value)

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of tags assigned on the port, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @all_tags.setter
    def all_tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "all_tags", value)

    @property
    @pulumi.getter(name="allowedAddressPairs")
    def allowed_address_pairs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]]]:
        """
        An IP/MAC Address pair of additional IP
        addresses that can be active on this port. The structure is described
        below.
        """
        return pulumi.get(self, "allowed_address_pairs")

    @allowed_address_pairs.setter
    def allowed_address_pairs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortAllowedAddressPairArgs']]]]):
        pulumi.set(self, "allowed_address_pairs", value)

    @property
    @pulumi.getter
    def binding(self) -> Optional[pulumi.Input['PortBindingArgs']]:
        """
        The port binding allows to specify binding information
        for the port. The structure is described below.
        """
        return pulumi.get(self, "binding")

    @binding.setter
    def binding(self, value: Optional[pulumi.Input['PortBindingArgs']]):
        pulumi.set(self, "binding", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable description of the port. Changing
        this updates the `description` of an existing port.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the device attached to the port. Changing this
        creates a new port.
        """
        return pulumi.get(self, "device_id")

    @device_id.setter
    def device_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_id", value)

    @property
    @pulumi.getter(name="deviceOwner")
    def device_owner(self) -> Optional[pulumi.Input[str]]:
        """
        The device owner of the port. Changing this creates
        a new port.
        """
        return pulumi.get(self, "device_owner")

    @device_owner.setter
    def device_owner(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "device_owner", value)

    @property
    @pulumi.getter(name="dnsAssignments")
    def dns_assignments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        The list of maps representing port DNS assignments.
        """
        return pulumi.get(self, "dns_assignments")

    @dns_assignments.setter
    def dns_assignments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "dns_assignments", value)

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The port DNS name. Available, when Neutron DNS extension
        is enabled.
        """
        return pulumi.get(self, "dns_name")

    @dns_name.setter
    def dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dns_name", value)

    @property
    @pulumi.getter(name="extraDhcpOptions")
    def extra_dhcp_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]]]:
        """
        An extra DHCP option that needs to be configured
        on the port. The structure is described below. Can be specified multiple
        times.
        """
        return pulumi.get(self, "extra_dhcp_options")

    @extra_dhcp_options.setter
    def extra_dhcp_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortExtraDhcpOptionArgs']]]]):
        pulumi.set(self, "extra_dhcp_options", value)

    @property
    @pulumi.getter(name="fixedIps")
    def fixed_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]]]:
        """
        An array of desired IPs for
        this port. The structure is described below.
        """
        return pulumi.get(self, "fixed_ips")

    @fixed_ips.setter
    def fixed_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PortFixedIpArgs']]]]):
        pulumi.set(self, "fixed_ips", value)

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[pulumi.Input[str]]:
        """
        Specify a specific MAC address for the port. Changing
        this creates a new port.
        """
        return pulumi.get(self, "mac_address")

    @mac_address.setter
    def mac_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mac_address", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A unique name for the port. Changing this
        updates the `name` of an existing port.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the network to attach the port to. Changing
        this creates a new port.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="noFixedIp")
    def no_fixed_ip(self) -> Optional[pulumi.Input[bool]]:
        """
        Create a port with no fixed
        IP address. This will also remove any fixed IPs previously set on a port. `true`
        is the only valid value for this argument.
        """
        return pulumi.get(self, "no_fixed_ip")

    @no_fixed_ip.setter
    def no_fixed_ip(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_fixed_ip", value)

    @property
    @pulumi.getter(name="noSecurityGroups")
    def no_security_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to
        `true`, then no security groups are applied to the port. If set to `false` and
        no `security_group_ids` are specified, then the port will yield to the default
        behavior of the Networking service, which is to usually apply the "default"
        security group.
        """
        return pulumi.get(self, "no_security_groups")

    @no_security_groups.setter
    def no_security_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "no_security_groups", value)

    @property
    @pulumi.getter(name="portSecurityEnabled")
    def port_security_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to explicitly enable or disable
        port security on the port. Port Security is usually enabled by default, so
        omitting argument will usually result in a value of `true`. Setting this
        explicitly to `false` will disable port security. In order to disable port
        security, the port must not have any security groups. Valid values are `true`
        and `false`.
        """
        return pulumi.get(self, "port_security_enabled")

    @port_security_enabled.setter
    def port_security_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "port_security_enabled", value)

    @property
    @pulumi.getter(name="qosPolicyId")
    def qos_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Reference to the associated QoS policy.
        """
        return pulumi.get(self, "qos_policy_id")

    @qos_policy_id.setter
    def qos_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "qos_policy_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a port. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        port.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list
        of security group IDs to apply to the port. The security groups must be
        specified by ID and not name (as opposed to how they are configured with
        the Compute Instance).
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A set of string tags for the port.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The owner of the port. Required if admin wants
        to create a port for another tenant. Changing this creates a new port.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

    @value_specs.setter
    def value_specs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "value_specs", value)


class Port(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 allowed_address_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortAllowedAddressPairArgs', 'PortAllowedAddressPairArgsDict']]]]] = None,
                 binding: Optional[pulumi.Input[Union['PortBindingArgs', 'PortBindingArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 device_owner: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 extra_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortExtraDhcpOptionArgs', 'PortExtraDhcpOptionArgsDict']]]]] = None,
                 fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortFixedIpArgs', 'PortFixedIpArgsDict']]]]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_fixed_ip: Optional[pulumi.Input[bool]] = None,
                 no_security_groups: Optional[pulumi.Input[bool]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 qos_policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Manages a V2 port resource within OpenStack.

        > **Note:** Ports do not get an IP if the network they are attached
        to does not have a subnet. If you create the subnet resource in the
        same run as the port, make sure to use `fixed_ip.subnet_id` or
        `depends_on` to enforce the subnet resource creation before the port
        creation is triggered. More info here

        ## Example Usage

        ### Simple port

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        port1 = openstack.networking.Port("port_1",
            name="port_1",
            network_id=network1.id,
            admin_state_up=True)
        ```

        ### Port defining fixed_ip.subnet_id

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet_1",
            name="subnet_1",
            network_id=network1.id,
            cidr="192.168.199.0/24")
        port1 = openstack.networking.Port("port_1",
            name="port_1",
            network_id=network1.id,
            admin_state_up=True,
            fixed_ips=[{
                "subnet_id": subnet1.id,
            }])
        ```

        ### Port with physical binding information

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        port1 = openstack.networking.Port("port_1",
            name="port_1",
            network_id=network1.id,
            device_id="cdf70fcf-c161-4f24-9c70-96b3f5a54b71",
            device_owner="baremetal:none",
            admin_state_up=True,
            binding={
                "host_id": "b080b9cf-46e0-4ce8-ad47-0fd4accc872b",
                "vnic_type": "baremetal",
                "profile": \"\"\"{
          "local_link_information": [
            {
              "switch_info": "info1",
              "port_id": "Ethernet3/4",
              "switch_id": "12:34:56:78:9A:BC"
            },
            {
              "switch_info": "info2",
              "port_id": "Ethernet3/4",
              "switch_id": "12:34:56:78:9A:BD"
            }
          ],
          "vlan_type": "allowed"
        }
        \"\"\",
            })
        ```

        ## Notes

        ### Ports and Instances

        There are some notes to consider when connecting Instances to networks using
        Ports. Please see the `compute.Instance` documentation for further
        documentation.

        ## Import

        Ports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:networking/port:Port port_1 eae26a3e-1c33-4cc1-9c31-0cd729c438a1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the port
               (must be `true` or `false` if provided). Changing this updates the
               `admin_state_up` of an existing port.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortAllowedAddressPairArgs', 'PortAllowedAddressPairArgsDict']]]] allowed_address_pairs: An IP/MAC Address pair of additional IP
               addresses that can be active on this port. The structure is described
               below.
        :param pulumi.Input[Union['PortBindingArgs', 'PortBindingArgsDict']] binding: The port binding allows to specify binding information
               for the port. The structure is described below.
        :param pulumi.Input[str] description: Human-readable description of the port. Changing
               this updates the `description` of an existing port.
        :param pulumi.Input[str] device_id: The ID of the device attached to the port. Changing this
               creates a new port.
        :param pulumi.Input[str] device_owner: The device owner of the port. Changing this creates
               a new port.
        :param pulumi.Input[str] dns_name: The port DNS name. Available, when Neutron DNS extension
               is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortExtraDhcpOptionArgs', 'PortExtraDhcpOptionArgsDict']]]] extra_dhcp_options: An extra DHCP option that needs to be configured
               on the port. The structure is described below. Can be specified multiple
               times.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortFixedIpArgs', 'PortFixedIpArgsDict']]]] fixed_ips: An array of desired IPs for
               this port. The structure is described below.
        :param pulumi.Input[str] mac_address: Specify a specific MAC address for the port. Changing
               this creates a new port.
        :param pulumi.Input[str] name: A unique name for the port. Changing this
               updates the `name` of an existing port.
        :param pulumi.Input[str] network_id: The ID of the network to attach the port to. Changing
               this creates a new port.
        :param pulumi.Input[bool] no_fixed_ip: Create a port with no fixed
               IP address. This will also remove any fixed IPs previously set on a port. `true`
               is the only valid value for this argument.
        :param pulumi.Input[bool] no_security_groups: If set to
               `true`, then no security groups are applied to the port. If set to `false` and
               no `security_group_ids` are specified, then the port will yield to the default
               behavior of the Networking service, which is to usually apply the "default"
               security group.
        :param pulumi.Input[bool] port_security_enabled: Whether to explicitly enable or disable
               port security on the port. Port Security is usually enabled by default, so
               omitting argument will usually result in a value of `true`. Setting this
               explicitly to `false` will disable port security. In order to disable port
               security, the port must not have any security groups. Valid values are `true`
               and `false`.
        :param pulumi.Input[str] qos_policy_id: Reference to the associated QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a port. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list
               of security group IDs to apply to the port. The security groups must be
               specified by ID and not name (as opposed to how they are configured with
               the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the port. Required if admin wants
               to create a port for another tenant. Changing this creates a new port.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PortArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a V2 port resource within OpenStack.

        > **Note:** Ports do not get an IP if the network they are attached
        to does not have a subnet. If you create the subnet resource in the
        same run as the port, make sure to use `fixed_ip.subnet_id` or
        `depends_on` to enforce the subnet resource creation before the port
        creation is triggered. More info here

        ## Example Usage

        ### Simple port

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        port1 = openstack.networking.Port("port_1",
            name="port_1",
            network_id=network1.id,
            admin_state_up=True)
        ```

        ### Port defining fixed_ip.subnet_id

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        subnet1 = openstack.networking.Subnet("subnet_1",
            name="subnet_1",
            network_id=network1.id,
            cidr="192.168.199.0/24")
        port1 = openstack.networking.Port("port_1",
            name="port_1",
            network_id=network1.id,
            admin_state_up=True,
            fixed_ips=[{
                "subnet_id": subnet1.id,
            }])
        ```

        ### Port with physical binding information

        ```python
        import pulumi
        import pulumi_openstack as openstack

        network1 = openstack.networking.Network("network_1",
            name="network_1",
            admin_state_up=True)
        port1 = openstack.networking.Port("port_1",
            name="port_1",
            network_id=network1.id,
            device_id="cdf70fcf-c161-4f24-9c70-96b3f5a54b71",
            device_owner="baremetal:none",
            admin_state_up=True,
            binding={
                "host_id": "b080b9cf-46e0-4ce8-ad47-0fd4accc872b",
                "vnic_type": "baremetal",
                "profile": \"\"\"{
          "local_link_information": [
            {
              "switch_info": "info1",
              "port_id": "Ethernet3/4",
              "switch_id": "12:34:56:78:9A:BC"
            },
            {
              "switch_info": "info2",
              "port_id": "Ethernet3/4",
              "switch_id": "12:34:56:78:9A:BD"
            }
          ],
          "vlan_type": "allowed"
        }
        \"\"\",
            })
        ```

        ## Notes

        ### Ports and Instances

        There are some notes to consider when connecting Instances to networks using
        Ports. Please see the `compute.Instance` documentation for further
        documentation.

        ## Import

        Ports can be imported using the `id`, e.g.

        ```sh
        $ pulumi import openstack:networking/port:Port port_1 eae26a3e-1c33-4cc1-9c31-0cd729c438a1
        ```

        :param str resource_name: The name of the resource.
        :param PortArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PortArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_state_up: Optional[pulumi.Input[bool]] = None,
                 allowed_address_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortAllowedAddressPairArgs', 'PortAllowedAddressPairArgsDict']]]]] = None,
                 binding: Optional[pulumi.Input[Union['PortBindingArgs', 'PortBindingArgsDict']]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 device_id: Optional[pulumi.Input[str]] = None,
                 device_owner: Optional[pulumi.Input[str]] = None,
                 dns_name: Optional[pulumi.Input[str]] = None,
                 extra_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortExtraDhcpOptionArgs', 'PortExtraDhcpOptionArgsDict']]]]] = None,
                 fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortFixedIpArgs', 'PortFixedIpArgsDict']]]]] = None,
                 mac_address: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 no_fixed_ip: Optional[pulumi.Input[bool]] = None,
                 no_security_groups: Optional[pulumi.Input[bool]] = None,
                 port_security_enabled: Optional[pulumi.Input[bool]] = None,
                 qos_policy_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PortArgs.__new__(PortArgs)

            __props__.__dict__["admin_state_up"] = admin_state_up
            __props__.__dict__["allowed_address_pairs"] = allowed_address_pairs
            __props__.__dict__["binding"] = binding
            __props__.__dict__["description"] = description
            __props__.__dict__["device_id"] = device_id
            __props__.__dict__["device_owner"] = device_owner
            __props__.__dict__["dns_name"] = dns_name
            __props__.__dict__["extra_dhcp_options"] = extra_dhcp_options
            __props__.__dict__["fixed_ips"] = fixed_ips
            __props__.__dict__["mac_address"] = mac_address
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["no_fixed_ip"] = no_fixed_ip
            __props__.__dict__["no_security_groups"] = no_security_groups
            __props__.__dict__["port_security_enabled"] = port_security_enabled
            __props__.__dict__["qos_policy_id"] = qos_policy_id
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["value_specs"] = value_specs
            __props__.__dict__["all_fixed_ips"] = None
            __props__.__dict__["all_security_group_ids"] = None
            __props__.__dict__["all_tags"] = None
            __props__.__dict__["dns_assignments"] = None
        super(Port, __self__).__init__(
            'openstack:networking/port:Port',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_state_up: Optional[pulumi.Input[bool]] = None,
            all_fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            all_security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            all_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allowed_address_pairs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortAllowedAddressPairArgs', 'PortAllowedAddressPairArgsDict']]]]] = None,
            binding: Optional[pulumi.Input[Union['PortBindingArgs', 'PortBindingArgsDict']]] = None,
            description: Optional[pulumi.Input[str]] = None,
            device_id: Optional[pulumi.Input[str]] = None,
            device_owner: Optional[pulumi.Input[str]] = None,
            dns_assignments: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
            dns_name: Optional[pulumi.Input[str]] = None,
            extra_dhcp_options: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortExtraDhcpOptionArgs', 'PortExtraDhcpOptionArgsDict']]]]] = None,
            fixed_ips: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PortFixedIpArgs', 'PortFixedIpArgsDict']]]]] = None,
            mac_address: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            no_fixed_ip: Optional[pulumi.Input[bool]] = None,
            no_security_groups: Optional[pulumi.Input[bool]] = None,
            port_security_enabled: Optional[pulumi.Input[bool]] = None,
            qos_policy_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None,
            value_specs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Port':
        """
        Get an existing Port resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] admin_state_up: Administrative up/down status for the port
               (must be `true` or `false` if provided). Changing this updates the
               `admin_state_up` of an existing port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_fixed_ips: The collection of Fixed IP addresses on the port in the
               order returned by the Network v2 API.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_security_group_ids: The collection of Security Group IDs on the port
               which have been explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] all_tags: The collection of tags assigned on the port, which have been
               explicitly and implicitly added.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortAllowedAddressPairArgs', 'PortAllowedAddressPairArgsDict']]]] allowed_address_pairs: An IP/MAC Address pair of additional IP
               addresses that can be active on this port. The structure is described
               below.
        :param pulumi.Input[Union['PortBindingArgs', 'PortBindingArgsDict']] binding: The port binding allows to specify binding information
               for the port. The structure is described below.
        :param pulumi.Input[str] description: Human-readable description of the port. Changing
               this updates the `description` of an existing port.
        :param pulumi.Input[str] device_id: The ID of the device attached to the port. Changing this
               creates a new port.
        :param pulumi.Input[str] device_owner: The device owner of the port. Changing this creates
               a new port.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] dns_assignments: The list of maps representing port DNS assignments.
        :param pulumi.Input[str] dns_name: The port DNS name. Available, when Neutron DNS extension
               is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortExtraDhcpOptionArgs', 'PortExtraDhcpOptionArgsDict']]]] extra_dhcp_options: An extra DHCP option that needs to be configured
               on the port. The structure is described below. Can be specified multiple
               times.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PortFixedIpArgs', 'PortFixedIpArgsDict']]]] fixed_ips: An array of desired IPs for
               this port. The structure is described below.
        :param pulumi.Input[str] mac_address: Specify a specific MAC address for the port. Changing
               this creates a new port.
        :param pulumi.Input[str] name: A unique name for the port. Changing this
               updates the `name` of an existing port.
        :param pulumi.Input[str] network_id: The ID of the network to attach the port to. Changing
               this creates a new port.
        :param pulumi.Input[bool] no_fixed_ip: Create a port with no fixed
               IP address. This will also remove any fixed IPs previously set on a port. `true`
               is the only valid value for this argument.
        :param pulumi.Input[bool] no_security_groups: If set to
               `true`, then no security groups are applied to the port. If set to `false` and
               no `security_group_ids` are specified, then the port will yield to the default
               behavior of the Networking service, which is to usually apply the "default"
               security group.
        :param pulumi.Input[bool] port_security_enabled: Whether to explicitly enable or disable
               port security on the port. Port Security is usually enabled by default, so
               omitting argument will usually result in a value of `true`. Setting this
               explicitly to `false` will disable port security. In order to disable port
               security, the port must not have any security groups. Valid values are `true`
               and `false`.
        :param pulumi.Input[str] qos_policy_id: Reference to the associated QoS policy.
        :param pulumi.Input[str] region: The region in which to obtain the V2 Networking client.
               A Networking client is needed to create a port. If omitted, the
               `region` argument of the provider is used. Changing this creates a new
               port.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] security_group_ids: A list
               of security group IDs to apply to the port. The security groups must be
               specified by ID and not name (as opposed to how they are configured with
               the Compute Instance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of string tags for the port.
        :param pulumi.Input[str] tenant_id: The owner of the port. Required if admin wants
               to create a port for another tenant. Changing this creates a new port.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value_specs: Map of additional options.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PortState.__new__(_PortState)

        __props__.__dict__["admin_state_up"] = admin_state_up
        __props__.__dict__["all_fixed_ips"] = all_fixed_ips
        __props__.__dict__["all_security_group_ids"] = all_security_group_ids
        __props__.__dict__["all_tags"] = all_tags
        __props__.__dict__["allowed_address_pairs"] = allowed_address_pairs
        __props__.__dict__["binding"] = binding
        __props__.__dict__["description"] = description
        __props__.__dict__["device_id"] = device_id
        __props__.__dict__["device_owner"] = device_owner
        __props__.__dict__["dns_assignments"] = dns_assignments
        __props__.__dict__["dns_name"] = dns_name
        __props__.__dict__["extra_dhcp_options"] = extra_dhcp_options
        __props__.__dict__["fixed_ips"] = fixed_ips
        __props__.__dict__["mac_address"] = mac_address
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["no_fixed_ip"] = no_fixed_ip
        __props__.__dict__["no_security_groups"] = no_security_groups
        __props__.__dict__["port_security_enabled"] = port_security_enabled
        __props__.__dict__["qos_policy_id"] = qos_policy_id
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["value_specs"] = value_specs
        return Port(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminStateUp")
    def admin_state_up(self) -> pulumi.Output[bool]:
        """
        Administrative up/down status for the port
        (must be `true` or `false` if provided). Changing this updates the
        `admin_state_up` of an existing port.
        """
        return pulumi.get(self, "admin_state_up")

    @property
    @pulumi.getter(name="allFixedIps")
    def all_fixed_ips(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of Fixed IP addresses on the port in the
        order returned by the Network v2 API.
        """
        return pulumi.get(self, "all_fixed_ips")

    @property
    @pulumi.getter(name="allSecurityGroupIds")
    def all_security_group_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of Security Group IDs on the port
        which have been explicitly and implicitly added.
        """
        return pulumi.get(self, "all_security_group_ids")

    @property
    @pulumi.getter(name="allTags")
    def all_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        The collection of tags assigned on the port, which have been
        explicitly and implicitly added.
        """
        return pulumi.get(self, "all_tags")

    @property
    @pulumi.getter(name="allowedAddressPairs")
    def allowed_address_pairs(self) -> pulumi.Output[Optional[Sequence['outputs.PortAllowedAddressPair']]]:
        """
        An IP/MAC Address pair of additional IP
        addresses that can be active on this port. The structure is described
        below.
        """
        return pulumi.get(self, "allowed_address_pairs")

    @property
    @pulumi.getter
    def binding(self) -> pulumi.Output['outputs.PortBinding']:
        """
        The port binding allows to specify binding information
        for the port. The structure is described below.
        """
        return pulumi.get(self, "binding")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-readable description of the port. Changing
        this updates the `description` of an existing port.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="deviceId")
    def device_id(self) -> pulumi.Output[str]:
        """
        The ID of the device attached to the port. Changing this
        creates a new port.
        """
        return pulumi.get(self, "device_id")

    @property
    @pulumi.getter(name="deviceOwner")
    def device_owner(self) -> pulumi.Output[str]:
        """
        The device owner of the port. Changing this creates
        a new port.
        """
        return pulumi.get(self, "device_owner")

    @property
    @pulumi.getter(name="dnsAssignments")
    def dns_assignments(self) -> pulumi.Output[Sequence[Mapping[str, str]]]:
        """
        The list of maps representing port DNS assignments.
        """
        return pulumi.get(self, "dns_assignments")

    @property
    @pulumi.getter(name="dnsName")
    def dns_name(self) -> pulumi.Output[str]:
        """
        The port DNS name. Available, when Neutron DNS extension
        is enabled.
        """
        return pulumi.get(self, "dns_name")

    @property
    @pulumi.getter(name="extraDhcpOptions")
    def extra_dhcp_options(self) -> pulumi.Output[Optional[Sequence['outputs.PortExtraDhcpOption']]]:
        """
        An extra DHCP option that needs to be configured
        on the port. The structure is described below. Can be specified multiple
        times.
        """
        return pulumi.get(self, "extra_dhcp_options")

    @property
    @pulumi.getter(name="fixedIps")
    def fixed_ips(self) -> pulumi.Output[Optional[Sequence['outputs.PortFixedIp']]]:
        """
        An array of desired IPs for
        this port. The structure is described below.
        """
        return pulumi.get(self, "fixed_ips")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> pulumi.Output[str]:
        """
        Specify a specific MAC address for the port. Changing
        this creates a new port.
        """
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name for the port. Changing this
        updates the `name` of an existing port.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        The ID of the network to attach the port to. Changing
        this creates a new port.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="noFixedIp")
    def no_fixed_ip(self) -> pulumi.Output[Optional[bool]]:
        """
        Create a port with no fixed
        IP address. This will also remove any fixed IPs previously set on a port. `true`
        is the only valid value for this argument.
        """
        return pulumi.get(self, "no_fixed_ip")

    @property
    @pulumi.getter(name="noSecurityGroups")
    def no_security_groups(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to
        `true`, then no security groups are applied to the port. If set to `false` and
        no `security_group_ids` are specified, then the port will yield to the default
        behavior of the Networking service, which is to usually apply the "default"
        security group.
        """
        return pulumi.get(self, "no_security_groups")

    @property
    @pulumi.getter(name="portSecurityEnabled")
    def port_security_enabled(self) -> pulumi.Output[bool]:
        """
        Whether to explicitly enable or disable
        port security on the port. Port Security is usually enabled by default, so
        omitting argument will usually result in a value of `true`. Setting this
        explicitly to `false` will disable port security. In order to disable port
        security, the port must not have any security groups. Valid values are `true`
        and `false`.
        """
        return pulumi.get(self, "port_security_enabled")

    @property
    @pulumi.getter(name="qosPolicyId")
    def qos_policy_id(self) -> pulumi.Output[str]:
        """
        Reference to the associated QoS policy.
        """
        return pulumi.get(self, "qos_policy_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to obtain the V2 Networking client.
        A Networking client is needed to create a port. If omitted, the
        `region` argument of the provider is used. Changing this creates a new
        port.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list
        of security group IDs to apply to the port. The security groups must be
        specified by ID and not name (as opposed to how they are configured with
        the Compute Instance).
        """
        return pulumi.get(self, "security_group_ids")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A set of string tags for the port.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[str]:
        """
        The owner of the port. Required if admin wants
        to create a port for another tenant. Changing this creates a new port.
        """
        return pulumi.get(self, "tenant_id")

    @property
    @pulumi.getter(name="valueSpecs")
    def value_specs(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of additional options.
        """
        return pulumi.get(self, "value_specs")

