import logging  # noqa: INP001
import sqlite3

from .table import QolsysTable

LOGGER = logging.getLogger(__name__)


class QolsysTableTcc(QolsysTable):

    def __init__(self, db: sqlite3.Connection, cursor: sqlite3.Cursor) -> None:
        super().__init__(db, cursor)
        self._uri = "content://com.qolsys.qolsysprovider.TccContentProvider/tcc"
        self._table = "tcc"
        self._abort_on_error = False
        self._implemented = True

        self._columns = [
            "tableName",
            "counter",
        ]

        self._create_table()
