# Generated by Django 4.2.2 on 2023-10-05 11:10

import django.contrib.postgres.fields.ranges
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):
    dependencies = [
        ("flow", "0016_annotationvalue_uniquetogether_entity_field"),
    ]

    operations = [
        migrations.CreateModel(
            name="CollectionHistory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("valid", django.contrib.postgres.fields.ranges.DateTimeRangeField()),
                ("deleted", models.DateTimeField(blank=True, null=True)),
                (
                    "datum",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="history",
                        to="flow.collection",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="DataHistory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("valid", django.contrib.postgres.fields.ranges.DateTimeRangeField()),
                ("deleted", models.DateTimeField(blank=True, null=True)),
                (
                    "datum",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="history",
                        to="flow.data",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SizeChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                ("value", models.BigIntegerField()),
                (
                    "history",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)s",
                        to="flow.datahistory",
                    ),
                ),
            ],
            options={
                "ordering": ["timestamp"],
                "abstract": False,
                "indexes": [
                    models.Index(fields=["timestamp"], name="idx_sizechange_time")
                ],
            },
        ),
        migrations.CreateModel(
            name="ProcessingHistory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                (
                    "interval",
                    django.contrib.postgres.fields.ranges.DateTimeRangeField(),
                ),
                ("allocated_cpu", models.IntegerField()),
                ("allocated_memory", models.BigIntegerField()),
                ("node_cpu", models.IntegerField()),
                ("node_memory", models.BigIntegerField()),
                (
                    "history",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)s",
                        to="flow.datahistory",
                    ),
                ),
            ],
            options={
                "ordering": ["timestamp"],
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["timestamp"], name="idx_processinghistory_time"
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="DataSlugChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                ("value", models.CharField(max_length=100)),
                (
                    "history",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)s",
                        to="flow.datahistory",
                    ),
                ),
            ],
            options={
                "ordering": ["timestamp"],
                "abstract": False,
                "indexes": [
                    models.Index(fields=["timestamp"], name="idx_dataslugchange_time")
                ],
            },
        ),
        migrations.CreateModel(
            name="DataNameChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                ("value", models.CharField(max_length=100)),
                (
                    "history",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)s",
                        to="flow.datahistory",
                    ),
                ),
            ],
            options={
                "ordering": ["timestamp"],
                "abstract": False,
                "indexes": [
                    models.Index(fields=["timestamp"], name="idx_datanamechange_time")
                ],
            },
        ),
        migrations.CreateModel(
            name="CollectionSlugChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                ("value", models.CharField(max_length=100)),
                (
                    "history",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)s",
                        to="flow.collectionhistory",
                    ),
                ),
            ],
            options={
                "ordering": ["timestamp"],
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["timestamp"], name="idx_collectionslugchange_time"
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="CollectionNameChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                ("value", models.CharField(max_length=100)),
                (
                    "history",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)s",
                        to="flow.collectionhistory",
                    ),
                ),
            ],
            options={
                "ordering": ["timestamp"],
                "abstract": False,
                "indexes": [
                    models.Index(
                        fields=["timestamp"], name="idx_collectionnamechange_time"
                    )
                ],
            },
        ),
        migrations.CreateModel(
            name="CollectionChange",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                (
                    "history",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="%(class)s",
                        to="flow.datahistory",
                    ),
                ),
                (
                    "value",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="collection_changes",
                        to="flow.collectionhistory",
                    ),
                ),
            ],
            options={
                "ordering": ["timestamp"],
                "abstract": False,
                "indexes": [
                    models.Index(fields=["timestamp"], name="idx_collectionchange_time")
                ],
            },
        ),
    ]
