import warnings

from .constants import DOMAIN_NAME as DOMAIN_NAME
from .schemas import ChatMessage as ChatMessage
from .schemas import ChatMessageAssessment as ChatMessageAssessment
from .schemas import ChatMessageAssessmentLabel as ChatMessageAssessmentLabel
from .schemas import ChatMessageAssessmentStatus as ChatMessageAssessmentStatus
from .schemas import ChatMessageAssessmentType as ChatMessageAssessmentType
from .schemas import ChatMessageRole as ChatMessageRole

# Import ChatService with deprecation warning suppressed for internal use
with warnings.catch_warnings():
    warnings.simplefilter("ignore", DeprecationWarning)
    from .service import ChatService as ChatService

from .utils import (
    convert_chat_history_to_injectable_string as convert_chat_history_to_injectable_string,
)
