# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .integration_web_hook_id import IntegrationWebHookId
import pydantic
import typing
import datetime as dt
from ...engine.types.object import Object
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class IntegrationWebHook(UncheckedBaseModel):
    """
    Integration webhook
    """

    id: IntegrationWebHookId
    creator: str = pydantic.Field()
    """
    The user who created the webHook.
    """

    enabled: bool = pydantic.Field()
    """
    Status of the WebHook.
    """

    events: typing.List[str] = pydantic.Field()
    """
    List of events that trigger the WebHook.
    """

    name: str = pydantic.Field()
    """
    A name for the WebHook.
    """

    value: str = pydantic.Field()
    """
    The content of the webHook, this can be a URL or a specific code, it depends on the provider.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The date the WebHook was created.
    """

    updated_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date the WebHook was last updated.
    """

    unmapped: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The attributes that are not mapped to the WebHook schema. The names and values of those attributes are specific to the provider.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
