# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .file import File
from .user import User
from .remediation import Remediation
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class AffectedCode(UncheckedBaseModel):
    """
    The Affected Code object describes details about a code block identified as vulnerable.
    """

    end_line: typing.Optional[int] = pydantic.Field(default=None)
    """
    The line number of the last line of code block identified as vulnerable.
    """

    file: File = pydantic.Field()
    """
    Details about the file that contains the affected code block.
    """

    owner: typing.Optional[User] = pydantic.Field(default=None)
    """
    Details about the user that owns the affected file.
    """

    remediation: typing.Optional[Remediation] = pydantic.Field(default=None)
    """
    Describes the recommended remediation steps to address identified issue(s).
    """

    start_line: typing.Optional[int] = pydantic.Field(default=None)
    """
    The line number of the first line of code block identified as vulnerable.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
