# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class AutonomousSystem(UncheckedBaseModel):
    """
    An autonomous system (AS) is a collection of connected Internet Protocol (IP) routing prefixes under the control of one or more network operators on behalf of a single administrative entity or domain that presents a common, clearly defined routing policy to the internet.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Organization name for the Autonomous System.
    """

    number: typing.Optional[int] = pydantic.Field(default=None)
    """
    Unique number that the AS is identified by.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
