# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .data_security_category_id import DataSecurityCategoryId
from .data_security_confidentiality_id import DataSecurityConfidentialityId
from .data_security_data_lifecycle_state_id import DataSecurityDataLifecycleStateId
from .data_security_detection_system_id import DataSecurityDetectionSystemId
from .policy import Policy
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class DataSecurity(UncheckedBaseModel):
    """
    The Data Security object describes the characteristics, techniques and content of a Data Loss Prevention (DLP), Data Loss Detection (DLD), Data Classification, or similar tools' finding, alert, or detection mechanism(s).
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the data classification category that data matched into, e.g. Financial, Personal, Governmental, etc.
    """

    category_id: typing.Optional[DataSecurityCategoryId] = pydantic.Field(default=None)
    """
    The normalized identifier of the data classification category.
    """

    confidentiality: typing.Optional[str] = pydantic.Field(default=None)
    """
    The file content confidentiality, normalized to the confidentiality_id value. In the case of 'Other', it is defined by the event source.
    """

    confidentiality_id: typing.Optional[DataSecurityConfidentialityId] = pydantic.Field(
        default=None
    )
    """
    The normalized identifier of the file content confidentiality indicator.
    """

    data_lifecycle_state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the stage or state that the data was in. E.g., Data-at-Rest, Data-in-Transit, etc.
    """

    data_lifecycle_state_id: typing.Optional[DataSecurityDataLifecycleStateId] = (
        pydantic.Field(default=None)
    )
    """
    The stage or state that the data was in when it was assessed or scanned by a data security tool.
    """

    detection_pattern: typing.Optional[str] = pydantic.Field(default=None)
    """
    Specific pattern, algorithm, fingerpint, or model used for detection.
    """

    detection_system: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the type of data security tool or system that the finding, detection, or alert originated from. E.g., Endpoint, Secure Email Gateway, etc.
    """

    detection_system_id: typing.Optional[DataSecurityDetectionSystemId] = (
        pydantic.Field(default=None)
    )
    """
    The type of data security tool or system that the finding, detection, or alert originated from.
    """

    pattern_match: typing.Optional[str] = pydantic.Field(default=None)
    """
    A text, binary, file name, or datastore that matched against a detection rule.
    """

    policy: typing.Optional[Policy] = pydantic.Field(default=None)
    """
    Details about the policy that triggered the finding.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
