# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Service(UncheckedBaseModel):
    """
    The Service object describes characteristics of a service, <code> e.g. AWS EC2. </code>
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated with the service.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the service.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the service.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The version of the service.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
