# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .reputation import Reputation
from .observable_type_id import ObservableTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Observable(UncheckedBaseModel):
    """
    The observable object is a pivot element that contains related information found in many places in the event.
    """

    name: str = pydantic.Field()
    """
    The full name of the observable attribute. The <code>name</code> is a pointer/reference to an attribute within the event data. For example: <code>file.name</code>.
    """

    reputation: typing.Optional[Reputation] = pydantic.Field(default=None)
    """
    Contains the original and normalized reputation scores.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The observable value type name.
    """

    type_id: ObservableTypeId = pydantic.Field()
    """
    The observable value type identifier.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The value associated with the observable attribute. The meaning of the value depends on the observable type.<br/>If the <code>name</code> refers to a scalar attribute, then the <code>value</code> is the value of the attribute.<br/>If the <code>name</code> refers to an object attribute, then the <code>value</code> is not populated.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
