# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .fingerprint import Fingerprint
import pydantic
from .image import Image
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Container(UncheckedBaseModel):
    """
    The Container object describes an instance of a specific container. A container is a prepackaged, portable system image that runs isolated on an existing system using a container runtime like containerd.
    """

    hash: typing.Optional[Fingerprint] = pydantic.Field(default=None)
    """
    Commit hash of image created for docker or the SHA256 hash of the container. For example: <code>13550340a8681c84c861aac2e5b440161c2b33a3e4f302ac680ca5b686de48de</code>.
    """

    image: typing.Optional[Image] = pydantic.Field(default=None)
    """
    The container image used as a template to run the container.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The container name.
    """

    network_driver: typing.Optional[str] = pydantic.Field(default=None)
    """
    The network driver used by the container. For example, bridge, overlay, host, none, etc.
    """

    orchestrator: typing.Optional[str] = pydantic.Field(default=None)
    """
    The orchestrator managing the container, such as ECS, EKS, K8s, or OpenShift.
    """

    pod_uuid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the pod (or equivalent) that the container is executing on.
    """

    runtime: typing.Optional[str] = pydantic.Field(default=None)
    """
    The backend running the container, such as containerd or cri-o.
    """

    size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The size of the container image.
    """

    tag: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tag used by the container. It can indicate version, format, OS.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full container unique identifier for this instantiation of the container. For example: <code>ac2ea168264a08f9aaca0dfc82ff3551418dfd22d02b713142a6843caa2f61bf</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
