# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .fingerprint import Fingerprint
from .package_type_id import PackageTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Package(UncheckedBaseModel):
    """
    The Software Package object describes details about a software package. Defined by D3FEND <a target='_blank' href='https://d3fend.mitre.org/dao/artifact/d3f:SoftwarePackage/'>d3f:SoftwarePackage</a>.
    """

    architecture: typing.Optional[str] = pydantic.Field(default=None)
    """
    Architecture is a shorthand name describing the type of computer hardware the packaged software is meant to run on.
    """

    cpe_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Common Platform Enumeration (CPE) name for the software package.
    """

    epoch: typing.Optional[int] = pydantic.Field(default=None)
    """
    The software package epoch. Epoch is a way to define weighted dependencies based on version numbers.
    """

    hash: typing.Optional[Fingerprint] = pydantic.Field(default=None)
    """
    Cryptographic hash to identify the binary instance of a software component. This can include any component such file, package, or library.
    """

    license: typing.Optional[str] = pydantic.Field(default=None)
    """
    The software license applied to this package.
    """

    name: str = pydantic.Field()
    """
    The software package name.
    """

    purl: typing.Optional[str] = pydantic.Field(default=None)
    """
    A purl is a URL string used to identify and locate a software package in a mostly universal and uniform way across programming languages, package managers, packaging conventions, tools, APIs and databases.
    """

    release: typing.Optional[str] = pydantic.Field(default=None)
    """
    Release is the number of times a version of the software has been packaged.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of software package, normalized to the caption of the type_id value. In the case of 'Other', it is defined by the source.
    """

    type_id: typing.Optional[PackageTypeId] = pydantic.Field(default=None)
    """
    The type of software package.
    """

    vendor_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the vendor who published the software package.
    """

    version: str = pydantic.Field()
    """
    The software package version.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
