# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .certificate import Certificate
from .tls_extension import TlsExtension
from .fingerprint import Fingerprint
from .san import San
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Tls(UncheckedBaseModel):
    """
    The Transport Layer Security (TLS) object describes the negotiated TLS protocol used for secure communications over an establish network connection.
    """

    alert: typing.Optional[int] = pydantic.Field(default=None)
    """
    The integer value of TLS alert if present. The alerts are defined in the TLS specification in <a target='_blank' href='https://datatracker.ietf.org/doc/html/rfc2246'>RFC-2246</a>.
    """

    certificate: typing.Optional[Certificate] = pydantic.Field(default=None)
    """
    The certificate object containing information about the digital certificate.
    """

    certificate_chain: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The Chain of Certificate Serial Numbers field provides a chain of Certificate Issuer Serial Numbers leading to the Root Certificate Issuer.
    """

    cipher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The negotiated cipher suite.
    """

    client_ciphers: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The client cipher suites that were exchanged during the TLS handshake negotiation.
    """

    extension_list: typing.Optional[typing.List[TlsExtension]] = pydantic.Field(
        default=None
    )
    """
    The list of TLS extensions.
    """

    handshake_dur: typing.Optional[int] = pydantic.Field(default=None)
    """
    The amount of total time for the TLS handshake to complete after the TCP connection is established, including client-side delays, in milliseconds.
    """

    ja_3_hash: typing.Optional[Fingerprint] = pydantic.Field(
        alias="ja3_hash", default=None
    )
    """
    The MD5 hash of a JA3 string.
    """

    ja_3_s_hash: typing.Optional[Fingerprint] = pydantic.Field(
        alias="ja3s_hash", default=None
    )
    """
    The MD5 hash of a JA3S string.
    """

    key_length: typing.Optional[int] = pydantic.Field(default=None)
    """
    The length of the encryption key.
    """

    sans: typing.Optional[typing.List[San]] = pydantic.Field(default=None)
    """
    The list of subject alternative names that are secured by a specific certificate.
    """

    server_ciphers: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The server cipher suites that were exchanged during the TLS handshake negotiation.
    """

    sni: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Server Name Indication (SNI) extension sent by the client.
    """

    tls_extension_list: typing.Optional[typing.List[TlsExtension]] = pydantic.Field(
        default=None
    )
    """
    The list of TLS extensions.
    """

    version: str = pydantic.Field()
    """
    The TLS protocol version.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
