# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .process_entity import ProcessEntity
import pydantic
from .container import Container
from ...base.types.timestamp import Timestamp
import datetime as dt
from .environment_variable import EnvironmentVariable
from .file import File
from .group import Group
from .process_integrity_id import ProcessIntegrityId
from ...base.types.process_name import ProcessName
from .object import Object
from .session import Session
from .user import User
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Process(UncheckedBaseModel):
    """
    The Process object describes a running instance of a launched program.
    """

    ancestry: typing.Optional[typing.List[ProcessEntity]] = pydantic.Field(default=None)
    """
    An array of Process Entities describing the extended parentage of this process object. Direct parent information sould be expressed through the <code>parent_process</code> attribute. The first array element is the direct parent of this process object. Subsequent list elements go up the process parentage hierarchy. That is, the array is sorted from newest to oldest process. It is recommended to only populate this field for the top-level process object.
    """

    auid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The audit user assigned at login by the audit subsystem.
    """

    cmd_line: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full command line used to launch an application, service, process, or job. For example: <code>ssh user@10.0.0.10</code>. If the command line is unavailable or missing, the empty string <code>''</code> is to be used.
    """

    container: typing.Optional[Container] = pydantic.Field(default=None)
    """
    The information describing an instance of a container. A container is a prepackaged, portable system image that runs isolated on an existing system using a container runtime like containerd.
    """

    created_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the process was created/started.
    """

    created_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the process was created/started.
    """

    egid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The effective group under which this process is running.
    """

    environment_variables: typing.Optional[typing.List[EnvironmentVariable]] = (
        pydantic.Field(default=None)
    )
    """
    Environment variables associated with the process.
    """

    euid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The effective user under which this process is running.
    """

    file: typing.Optional[File] = pydantic.Field(default=None)
    """
    The process file object.
    """

    group: typing.Optional[Group] = pydantic.Field(default=None)
    """
    The group under which this process is running.
    """

    integrity: typing.Optional[str] = pydantic.Field(default=None)
    """
    The process integrity level, normalized to the caption of the integrity_id value. In the case of 'Other', it is defined by the event source (Windows only).
    """

    integrity_id: typing.Optional[ProcessIntegrityId] = pydantic.Field(default=None)
    """
    The normalized identifier of the process integrity level (Windows only).
    """

    lineage: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The lineage of the process, represented by a list of paths for each ancestor process. For example: <code>['/usr/sbin/sshd', '/usr/bin/bash', '/usr/bin/whoami']</code>.
    """

    loaded_modules: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of loaded module names.
    """

    name: typing.Optional[ProcessName] = pydantic.Field(default=None)
    """
    The friendly name of the process, for example: <code>Notepad++</code>.
    """

    namespace_pid: typing.Optional[int] = pydantic.Field(default=None)
    """
    If running under a process namespace (such as in a container), the process identifier within that process namespace.
    """

    parent_process: typing.Optional[Object] = pydantic.Field(default=None)
    """
    The parent process of this process object. It is recommended to only populate this field for the top-level process object, to prevent deep nesting. Additional ancestry information can be supplied in the <code>ancestry</code> attribute.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The process file path.
    """

    pid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The process identifier, as reported by the operating system. Process ID (PID) is a number used by the operating system to uniquely identify an active process.
    """

    sandbox: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the containment jail (i.e., sandbox). For example, hardened_ps, high_security_ps, oracle_ps, netsvcs_ps, or default_ps.
    """

    session: typing.Optional[Session] = pydantic.Field(default=None)
    """
    The user session under which this process is running.
    """

    terminated_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the process was terminated.
    """

    terminated_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the process was terminated.
    """

    tid: typing.Optional[int] = pydantic.Field(default=None)
    """
    The Identifier of the thread associated with the event, as returned by the operating system.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    A unique identifier for this process assigned by the producer (tool). Facilitates correlation of a process event with other events for that process.
    """

    user: typing.Optional[User] = pydantic.Field(default=None)
    """
    The user under which this process is running.
    """

    working_directory: typing.Optional[str] = pydantic.Field(default=None)
    """
    The working directory of a process.
    """

    xattributes: typing.Optional[Object] = pydantic.Field(default=None)
    """
    An unordered collection of zero or more name/value pairs that represent a process extended attribute.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
