# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .account import Account
import pydantic
from ...base.types.email_address import EmailAddress
from .group import Group
from .ldap_person import LdapPerson
from .user_mfa_status_id import UserMfaStatusId
from ...base.types.user_name import UserName
from .organization import Organization
from .user_risk_level_id import UserRiskLevelId
from .user_type_id import UserTypeId
from .user_user_status_id import UserUserStatusId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class User(UncheckedBaseModel):
    """
    The User object describes the characteristics of a user/person or a security principal.
    """

    account: typing.Optional[Account] = pydantic.Field(default=None)
    """
    The user's account or the account associated with the user.
    """

    credential_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the user's credential. For example, AWS Access Key ID.
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The domain where the user is defined. For example: the LDAP or Active Directory domain.
    """

    email_addr: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The user's primary email address.
    """

    forward_addr: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The user's forwarding email address.
    """

    full_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The full name of the person, as per the LDAP Common Name attribute (cn).
    """

    groups: typing.Optional[typing.List[Group]] = pydantic.Field(default=None)
    """
    The administrative groups to which the user belongs.
    """

    has_mfa: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The user has a multi-factor or secondary-factor device assigned.
    """

    ldap_person: typing.Optional[LdapPerson] = pydantic.Field(default=None)
    """
    The additional LDAP attributes that describe a person.
    """

    mfa_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The multi-factor authentication status, normalized to the caption of the mfa_status_id value. In the case of 'Other', it is defined by the data source.
    """

    mfa_status_id: typing.Optional[UserMfaStatusId] = pydantic.Field(default=None)
    """
    The normalized identifier of the user's multi-factor authentication status.
    """

    name: typing.Optional[UserName] = pydantic.Field(default=None)
    """
    The username. For example, <code>janedoe1</code>.
    """

    org: typing.Optional[Organization] = pydantic.Field(default=None)
    """
    Organization and org unit related to the user.
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The telephone number of the user.
    """

    privileges: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The user's privileges.
    """

    risk_level: typing.Optional[str] = pydantic.Field(default=None)
    """
    The risk level, normalized to the caption of the risk_level_id value.
    """

    risk_level_id: typing.Optional[UserRiskLevelId] = pydantic.Field(default=None)
    """
    The normalized risk level id.
    """

    risk_score: typing.Optional[int] = pydantic.Field(default=None)
    """
    The risk score as reported by the event source.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the user. For example, System, AWS IAM User, etc.
    """

    type_id: typing.Optional[UserTypeId] = pydantic.Field(default=None)
    """
    The account type identifier.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique user identifier. For example, the Windows user SID, ActiveDirectory DN or AWS user ARN.
    """

    uid_alt: typing.Optional[str] = pydantic.Field(default=None)
    """
    The alternate user identifier. For example, the Active Directory user GUID or AWS user Principal ID.
    """

    user_status: typing.Optional[str] = pydantic.Field(default=None)
    """
    The user status, normalized to the caption of the user_status_id value. In the case of 'Other', it is defined by the data source.
    """

    user_status_id: typing.Optional[UserUserStatusId] = pydantic.Field(default=None)
    """
    The normalized identifier of the user's status.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
