# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .policy import Policy
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Assessment(UncheckedBaseModel):
    """
    The Assessment object describes a point-in-time assessment, check, or evaluation of a specific configuration or signal against an asset, entity, person, or otherwise. For example, this can encapsulate <code>os_signals</code> from CrowdStrike Falcon Zero Trust Assessments, or account for <code>Datastore</code> configurations from Cyera, or capture details of Microsoft Intune configuration policies.
    """

    category: typing.Optional[str] = pydantic.Field(default=None)
    """
    The category that the assessment is part of. For example: <code>Prevention</code> or <code>Windows 10</code>.
    """

    desc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the assessment criteria, or a description of the specific configuration or signal the assessment is targeting.
    """

    meets_criteria: bool = pydantic.Field()
    """
    Determines whether the assessment against the specific configuration or signal meets the assessments criteria. For example, if the assessment checks if a <code>Datastore</code> is encrypted or not, having encryption would be evaluated as <code>true</code>.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the configuration or signal being assessed. For example: <code>Kernel Mode Code Integrity (KMCI)</code> or <code>publicAccessibilityState</code>.
    """

    policy: typing.Optional[Policy] = pydantic.Field(default=None)
    """
    The details of any policy associated with an assessment.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the configuration or signal being assessed. For example: the <code>signal_id</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
