# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class KeyboardInfo(UncheckedBaseModel):
    """
    The Keyboard Information object contains details and attributes related to a computer or device keyboard. It encompasses information that describes the characteristics, capabilities, and configuration of the keyboard.
    """

    function_keys: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of function keys on client keyboard.
    """

    ime: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Input Method Editor (IME) file name.
    """

    keyboard_layout: typing.Optional[str] = pydantic.Field(default=None)
    """
    The keyboard locale identifier name (e.g., en-US).
    """

    keyboard_subtype: typing.Optional[int] = pydantic.Field(default=None)
    """
    The keyboard numeric code.
    """

    keyboard_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The keyboard type (e.g., xt, ico).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
