# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from ...base.types.hostname import Hostname
import pydantic
from ...base.types.ip_address import IpAddress
from ...base.types.mac_address import MacAddress
from .network_interface_type_id import NetworkInterfaceTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class NetworkInterface(UncheckedBaseModel):
    """
    The Network Interface object describes the type and associated attributes of a physical or virtual network interface.
    """

    hostname: typing.Optional[Hostname] = pydantic.Field(default=None)
    """
    The hostname associated with the network interface.
    """

    ip: typing.Optional[IpAddress] = pydantic.Field(default=None)
    """
    The IP address associated with the network interface.
    """

    ip_addresses: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of IP addresses available on the network interface.
    """

    mac: typing.Optional[MacAddress] = pydantic.Field(default=None)
    """
    The MAC address of the network interface.
    """

    mac_addresses: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    A list of MAC addresses available on the network interface.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the network interface.
    """

    namespace: typing.Optional[str] = pydantic.Field(default=None)
    """
    The namespace is useful in merger or acquisition situations. For example, when similar entities exist that you need to keep separate.
    """

    subnet_prefix: typing.Optional[int] = pydantic.Field(default=None)
    """
    The subnet prefix length determines the number of bits used to represent the network part of the IP address. The remaining bits are reserved for identifying individual hosts within that subnet.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of network interface.
    """

    type_id: NetworkInterfaceTypeId = pydantic.Field()
    """
    The network interface type identifier.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the network interface.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
