# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .fingerprint import Fingerprint
from .software_component_relationship_id import SoftwareComponentRelationshipId
from .software_component_type_id import SoftwareComponentTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class SoftwareComponent(UncheckedBaseModel):
    """
    The Software Component object describes characteristics of a software component within a software package.
    """

    author: typing.Optional[str] = pydantic.Field(default=None)
    """
    The author(s) who published the software component.
    """

    hash: typing.Optional[Fingerprint] = pydantic.Field(default=None)
    """
    Cryptographic hash to identify the binary instance of a software component.
    """

    license: typing.Optional[str] = pydantic.Field(default=None)
    """
    The software license applied to this component.
    """

    name: str = pydantic.Field()
    """
    The software component name.
    """

    purl: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Package URL (PURL) to identify the software component. This is a URL that uniquely identifies the component, including the component's name, version, and type. The URL is used to locate and retrieve the component's metadata and content.
    """

    related_component: typing.Optional[str] = pydantic.Field(default=None)
    """
    The package URL (PURL) of the component that this software component has a relationship with.
    """

    relationship: typing.Optional[str] = pydantic.Field(default=None)
    """
    The relationship between two software components, normalized to the caption of the <code>relationship_id</code> value. In the case of 'Other', it is defined by the source.
    """

    relationship_id: typing.Optional[SoftwareComponentRelationshipId] = pydantic.Field(
        default=None
    )
    """
    The normalized identifier of the relationship between two software components.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of software component, normalized to the caption of the <code>type_id</code> value. In the case of 'Other', it is defined by the source.
    """

    type_id: typing.Optional[SoftwareComponentTypeId] = pydantic.Field(default=None)
    """
    The type of software component.
    """

    version: str = pydantic.Field()
    """
    The software component version.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
