# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Tactic(UncheckedBaseModel):
    """
    The MITRE Tactic object describes the ATT&CK® or ATLAS™ Tactic ID and/or name that is associated to an attack.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Tactic name that is associated with the attack technique. For example: <code>Reconnaissance</code> or <code>ML Model Access</code>.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The versioned permalink of the Tactic. For example: <code>https://attack.mitre.org/versions/v14/tactics/TA0043/</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Tactic ID that is associated with the attack technique. For example: <code>TA0043</code>, or <code>AML.TA0000</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
