# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class EmailAuth(UncheckedBaseModel):
    """
    The Email Authentication object describes the Sender Policy Framework (SPF), DomainKeys Identified Mail (DKIM) and Domain-based Message Authentication, Reporting and Conformance (DMARC) attributes of an email.
    """

    dkim: typing.Optional[str] = pydantic.Field(default=None)
    """
    The DomainKeys Identified Mail (DKIM) status of the email.
    """

    dkim_domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The DomainKeys Identified Mail (DKIM) signing domain of the email.
    """

    dkim_signature: typing.Optional[str] = pydantic.Field(default=None)
    """
    The DomainKeys Identified Mail (DKIM) signature used by the sending/receiving system.
    """

    dmarc: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Domain-based Message Authentication, Reporting and Conformance (DMARC) status of the email.
    """

    dmarc_override: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Domain-based Message Authentication, Reporting and Conformance (DMARC) override action.
    """

    dmarc_policy: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Domain-based Message Authentication, Reporting and Conformance (DMARC) policy status.
    """

    spf: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Sender Policy Framework (SPF) status of the email.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
