# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.url_string import UrlString
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class D3FTactic(UncheckedBaseModel):
    """
    The MITRE D3FEND™ Tactic object describes the tactic ID and/or name that is associated to an attack.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The tactic name that is associated with the defensive technique. For example: <code>Isolate</code>.
    """

    src_url: typing.Optional[UrlString] = pydantic.Field(default=None)
    """
    The versioned permalink of the defensive tactic. For example: <code>https://d3fend.mitre.org/tactic/d3f:Isolate/</code>.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the defensive tactic.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
