# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .encryption_details_algorithm_id import EncryptionDetailsAlgorithmId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class EncryptionDetails(UncheckedBaseModel):
    """
    Details about the encryption methodology utilized.
    """

    algorithm: typing.Optional[str] = pydantic.Field(default=None)
    """
    The encryption algorithm used, normalized to the caption of 'algorithm_id
    """

    algorithm_id: typing.Optional[EncryptionDetailsAlgorithmId] = pydantic.Field(
        default=None
    )
    """
    The encryption algorithm used.
    """

    key_length: typing.Optional[int] = pydantic.Field(default=None)
    """
    The length of the encryption key used.
    """

    key_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the key used for encryption. For example, AWS KMS Key ARN.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the encryption used.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
