# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.timestamp import Timestamp
import datetime as dt
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class HttpCookie(UncheckedBaseModel):
    """
    The HTTP Cookie object, also known as a web cookie or browser cookie, contains details and values pertaining to a small piece of data that a server sends to a user's web browser. This data is then stored by the browser and sent back to the server with subsequent requests, allowing the server to remember and track certain information about the user's browsing session or preferences.
    """

    domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    The domain name for the server from which the http_cookie is served.
    """

    expiration_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The expiration time of the HTTP cookie.
    """

    expiration_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The expiration time of the HTTP cookie.
    """

    http_only: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A cookie attribute to make it inaccessible via JavaScript
    """

    is_http_only: typing.Optional[bool] = pydantic.Field(default=None)
    """
    This attribute prevents the cookie from being accessed via JavaScript.
    """

    is_secure: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The cookie attribute indicates that cookies are sent to the server only when the request is encrypted using the HTTPS protocol.
    """

    name: str = pydantic.Field()
    """
    The HTTP cookie name.
    """

    path: typing.Optional[str] = pydantic.Field(default=None)
    """
    The path of the HTTP cookie.
    """

    samesite: typing.Optional[str] = pydantic.Field(default=None)
    """
    The cookie attribute that lets servers specify whether/when cookies are sent with cross-site requests. Values are: Strict, Lax or None
    """

    secure: typing.Optional[bool] = pydantic.Field(default=None)
    """
    The cookie attribute to only send cookies to the server with an encrypted request over the HTTPS protocol.
    """

    value: str = pydantic.Field()
    """
    The HTTP cookie value.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
