# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .http_header import HttpHeader
from .http_request_http_method import HttpRequestHttpMethod
from .url import Url
from ...base.types.ip_address import IpAddress
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class HttpRequest(UncheckedBaseModel):
    """
    The HTTP Request object represents the attributes of a request made to a web server. It encapsulates the details and metadata associated with an HTTP request, including the request method, headers, URL, query parameters, body content, and other relevant information.
    """

    args: typing.Optional[str] = pydantic.Field(default=None)
    """
    The arguments sent along with the HTTP request.
    """

    body_length: typing.Optional[int] = pydantic.Field(default=None)
    """
    The actual length of the HTTP request body, in number of bytes, independent of a potentially existing Content-Length header.
    """

    http_headers: typing.Optional[typing.List[HttpHeader]] = pydantic.Field(
        default=None
    )
    """
    Additional HTTP headers of an HTTP request or response.
    """

    http_method: typing.Optional[HttpRequestHttpMethod] = pydantic.Field(default=None)
    """
    The <a target='_blank' href='https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods'>HTTP request method</a> indicates the desired action to be performed for a given resource.
    """

    length: typing.Optional[int] = pydantic.Field(default=None)
    """
    The length of the entire HTTP request, in number of bytes.
    """

    referrer: typing.Optional[str] = pydantic.Field(default=None)
    """
    The request header that identifies the address of the previous web page, which is linked to the current web page or resource being requested.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier of the http request.
    """

    url: typing.Optional[Url] = pydantic.Field(default=None)
    """
    The URL object that pertains to the request.
    """

    user_agent: typing.Optional[str] = pydantic.Field(default=None)
    """
    The request header that identifies the operating system and web browser.
    """

    user_agent_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Concise version of the user agent, e.g. Chrome or Firefox instead of the full user-agent string.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Hypertext Transfer Protocol (HTTP) version.
    """

    x_forwarded_for: typing.Optional[typing.List[IpAddress]] = pydantic.Field(
        default=None
    )
    """
    The X-Forwarded-For header identifying the originating IP address(es) of a client connecting to a web server through an HTTP proxy or a load balancer.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
