# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .ja_4_fingerprint_type_id import Ja4FingerprintTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Ja4Fingerprint(UncheckedBaseModel):
    """
    The JA4+ fingerprint object provides detailed fingerprint information about various aspects of network traffic which is both machine and human readable.
    """

    section_a: typing.Optional[str] = pydantic.Field(default=None)
    """
    The 'a' section of the JA4 fingerprint.
    """

    section_b: typing.Optional[str] = pydantic.Field(default=None)
    """
    The 'b' section of the JA4 fingerprint.
    """

    section_c: typing.Optional[str] = pydantic.Field(default=None)
    """
    The 'c' section of the JA4 fingerprint.
    """

    section_d: typing.Optional[str] = pydantic.Field(default=None)
    """
    The 'd' section of the JA4 fingerprint.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The JA4+ fingerprint type as defined by <a href='https://blog.foxio.io/ja4+-network-fingerprinting target='\_blank'>FoxIO</a>, normalized to the caption of 'type_id'. In the case of 'Other', it is defined by the event source.
    """

    type_id: Ja4FingerprintTypeId = pydantic.Field()
    """
    The identifier of the JA4+ fingerprint type.
    """

    value: str = pydantic.Field()
    """
    The JA4+ fingerprint value.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
