# This file was auto-generated by Fern from our API Definition.

import typing
from ..core.client_wrapper import SyncClientWrapper
from ..events.types.event import Event
from ..core.request_options import RequestOptions
from .types.create_sink_events_response import CreateSinkEventsResponse
from ..core.unchecked_base_model import construct_type
from ..common.errors.bad_request_error import BadRequestError
from ..common.types.problem import Problem
from ..common.errors.unauthorized_error import UnauthorizedError
from ..common.errors.forbidden_error import ForbiddenError
from ..common.errors.not_found_error import NotFoundError
from ..common.errors.method_not_allowed_error import MethodNotAllowedError
from ..common.errors.conflict_error import ConflictError
from ..common.errors.unsupported_media_type_error import UnsupportedMediaTypeError
from ..common.errors.too_many_requests_error import TooManyRequestsError
from ..common.errors.internal_server_error import InternalServerError
from ..common.errors.not_implemented_error import NotImplementedError
from ..common.errors.bad_gateway_error import BadGatewayError
from ..common.errors.service_unavailable_error import ServiceUnavailableError
from ..common.errors.gateway_timeout_error import GatewayTimeoutError
from json.decoder import JSONDecodeError
from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SinkClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def post_events(
        self,
        *,
        request: typing.Sequence[Event],
        location: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSinkEventsResponse:
        """
        Writes a batch of `Event` objects to the Sink configured with the token used for authentication.

        Parameters
        ----------
        request : typing.Sequence[Event]

        location : typing.Optional[str]
            Updates the path or queue name for the sink. If not provided, the default path or queue name is used. When provided, the path or queue name is appended to the default path or queue name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSinkEventsResponse

        Examples
        --------
        import datetime

        from synqly import SynqlyEngine
        from synqly.events import Event_AccountChange
        from synqly.ocsf.v_1_3_0.accountchange.objects import (
            Account,
            Actor,
            Api,
            AutonomousSystem,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Enrichment,
            Extension,
            Feature,
            Group,
            HttpRequest,
            Idp,
            Image,
            Location,
            Logger,
            Metadata,
            NetworkEndpoint,
            NetworkProxy,
            Observable,
            Organization,
            Os,
            Osint,
            Policy,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            Url,
            User,
        )

        client = SynqlyEngine(
            token="YOUR_TOKEN",
        )
        client.sink.post_events(
            location="string",
            request=[
                Event_AccountChange(
                    activity_id=1,
                    activity_name="string",
                    actor=Actor(
                        actor_type="string",
                        actor_type_id=1,
                        app_name="string",
                        app_uid="string",
                        authorizations=[],
                        groups=[],
                        idp=Idp(),
                        invoked_by="string",
                        process=Process(),
                        session=Session(),
                        user=User(),
                    ),
                    api=Api(
                        group=Group(),
                        operation="string",
                        request=Request(
                            uid="string",
                        ),
                        response=Response(),
                        service=Service(),
                        version="string",
                    ),
                    category_name="string",
                    category_uid=1,
                    class_uid=1,
                    cloud=Cloud(
                        account=Account(),
                        org=Organization(),
                        project_uid="string",
                        provider="string",
                        region="string",
                        zone="string",
                    ),
                    count=1,
                    custom_fields={"string": {"key": "value"}},
                    device=Device(
                        agent_list=[],
                        autoscale_uid="string",
                        boot_time=1,
                        boot_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        container=Container(),
                        created_time=1,
                        created_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        desc="string",
                        domain="string",
                        first_seen_time=1,
                        first_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        groups=[],
                        hostname="string",
                        hw_info=DeviceHwInfo(),
                        hypervisor="string",
                        image=Image(
                            uid="string",
                        ),
                        imei="string",
                        instance_uid="string",
                        interface_name="string",
                        interface_uid="string",
                        ip="string",
                        ip_addresses=[],
                        is_compliant=True,
                        is_managed=True,
                        is_personal=True,
                        is_trusted=True,
                        last_seen_time=1,
                        last_seen_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        location=Location(),
                        mac="string",
                        mac_addresses=[],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        name="string",
                        namespace_pid=1,
                        netbios_names=[],
                        network_interfaces=[],
                        network_status="string",
                        network_status_id=1,
                        org=Organization(),
                        os=Os(
                            name="string",
                            type_id=1,
                        ),
                        owner=User(),
                        region="string",
                        risk_level="string",
                        risk_level_id=1,
                        risk_score=1,
                        subnet="string",
                        subnet_uid="string",
                        sw_info=[],
                        type="string",
                        type_id=1,
                        uid="string",
                        uid_alt="string",
                        vendor=Organization(),
                        vlan_uid="string",
                        vpc_uid="string",
                        zone="string",
                    ),
                    duration=1,
                    end_time=1,
                    end_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    enrichments=[
                        Enrichment(
                            data={"key": "value"},
                            name="string",
                            value="string",
                        )
                    ],
                    http_request=HttpRequest(
                        args="string",
                        http_headers=[],
                        http_method="string",
                        length=1,
                        referrer="string",
                        uid="string",
                        url=Url(),
                        user_agent="string",
                        user_agent_name="string",
                        version="string",
                        x_forwarded_for=[],
                    ),
                    message="string",
                    metadata=Metadata(
                        correlation_uid="string",
                        event_code="string",
                        extension=Extension(
                            name="string",
                            uid="string",
                            version="string",
                        ),
                        extensions=[
                            Extension(
                                name="string",
                                uid="string",
                                version="string",
                            )
                        ],
                        labels=["string"],
                        log_level="string",
                        log_name="string",
                        log_provider="string",
                        log_version="string",
                        logged_time=1,
                        logged_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        loggers=[Logger()],
                        modified_time=1,
                        modified_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        original_time="string",
                        processed_time=1,
                        processed_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        product=Product(
                            cpe_name="string",
                            distribution_mode="string",
                            feature=Feature(
                                name="string",
                                uid="string",
                                version="string",
                            ),
                            lang="string",
                            name="string",
                            path="string",
                            uid="string",
                            url_string="string",
                            vendor_name="string",
                            version="string",
                            workload="string",
                        ),
                        profiles=["string"],
                        sequence=1,
                        tenant_uid="string",
                        uid="string",
                        version="string",
                    ),
                    observables=[
                        Observable(
                            name="string",
                            type_id=1,
                        )
                    ],
                    osint=[
                        Osint(
                            type_id=1,
                            value="string",
                        )
                    ],
                    policy=Policy(
                        desc="string",
                        group=Group(),
                        is_applied=True,
                        name="string",
                        uid="string",
                        version="string",
                    ),
                    raw_data="string",
                    severity="string",
                    severity_id=1,
                    src_endpoint=NetworkEndpoint(
                        agent_list=[],
                        autonomous_system=AutonomousSystem(),
                        container=Container(),
                        domain="string",
                        hostname="string",
                        hw_info=DeviceHwInfo(),
                        instance_uid="string",
                        interface_name="string",
                        interface_uid="string",
                        intermediate_ips=[],
                        ip="string",
                        location=Location(),
                        mac="string",
                        name="string",
                        namespace_pid=1,
                        os=Os(
                            name="string",
                            type_id=1,
                        ),
                        owner=User(),
                        port=1,
                        proxy_endpoint=NetworkProxy(),
                        subnet_uid="string",
                        svc_name="string",
                        type="string",
                        type_id=1,
                        uid="string",
                        vlan_uid="string",
                        vpc_uid="string",
                        zone="string",
                    ),
                    start_time=1,
                    start_time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    status="string",
                    status_code="string",
                    status_detail="string",
                    status_id=1,
                    time=1,
                    time_dt=datetime.datetime.fromisoformat(
                        "2024-01-15 09:30:00+00:00",
                    ),
                    timezone_offset=1,
                    type_name="string",
                    type_uid=1,
                    unmapped={"string": {"key": "value"}},
                    user=User(),
                    user_result=User(),
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "v1/sink/events",
            method="POST",
            params={
                "location": location,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateSinkEventsResponse,
                    construct_type(
                        type_=CreateSinkEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncSinkClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def post_events(
        self,
        *,
        request: typing.Sequence[Event],
        location: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSinkEventsResponse:
        """
        Writes a batch of `Event` objects to the Sink configured with the token used for authentication.

        Parameters
        ----------
        request : typing.Sequence[Event]

        location : typing.Optional[str]
            Updates the path or queue name for the sink. If not provided, the default path or queue name is used. When provided, the path or queue name is appended to the default path or queue name.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSinkEventsResponse

        Examples
        --------
        import asyncio
        import datetime

        from synqly import AsyncSynqlyEngine
        from synqly.events import Event_AccountChange
        from synqly.ocsf.v_1_3_0.accountchange.objects import (
            Account,
            Actor,
            Api,
            AutonomousSystem,
            Cloud,
            Container,
            Device,
            DeviceHwInfo,
            Enrichment,
            Extension,
            Feature,
            Group,
            HttpRequest,
            Idp,
            Image,
            Location,
            Logger,
            Metadata,
            NetworkEndpoint,
            NetworkProxy,
            Observable,
            Organization,
            Os,
            Osint,
            Policy,
            Process,
            Product,
            Request,
            Response,
            Service,
            Session,
            Url,
            User,
        )

        client = AsyncSynqlyEngine(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.sink.post_events(
                location="string",
                request=[
                    Event_AccountChange(
                        activity_id=1,
                        activity_name="string",
                        actor=Actor(
                            actor_type="string",
                            actor_type_id=1,
                            app_name="string",
                            app_uid="string",
                            authorizations=[],
                            groups=[],
                            idp=Idp(),
                            invoked_by="string",
                            process=Process(),
                            session=Session(),
                            user=User(),
                        ),
                        api=Api(
                            group=Group(),
                            operation="string",
                            request=Request(
                                uid="string",
                            ),
                            response=Response(),
                            service=Service(),
                            version="string",
                        ),
                        category_name="string",
                        category_uid=1,
                        class_uid=1,
                        cloud=Cloud(
                            account=Account(),
                            org=Organization(),
                            project_uid="string",
                            provider="string",
                            region="string",
                            zone="string",
                        ),
                        count=1,
                        custom_fields={"string": {"key": "value"}},
                        device=Device(
                            agent_list=[],
                            autoscale_uid="string",
                            boot_time=1,
                            boot_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            container=Container(),
                            created_time=1,
                            created_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            desc="string",
                            domain="string",
                            first_seen_time=1,
                            first_seen_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            groups=[],
                            hostname="string",
                            hw_info=DeviceHwInfo(),
                            hypervisor="string",
                            image=Image(
                                uid="string",
                            ),
                            imei="string",
                            instance_uid="string",
                            interface_name="string",
                            interface_uid="string",
                            ip="string",
                            ip_addresses=[],
                            is_compliant=True,
                            is_managed=True,
                            is_personal=True,
                            is_trusted=True,
                            last_seen_time=1,
                            last_seen_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            location=Location(),
                            mac="string",
                            mac_addresses=[],
                            modified_time=1,
                            modified_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            name="string",
                            namespace_pid=1,
                            netbios_names=[],
                            network_interfaces=[],
                            network_status="string",
                            network_status_id=1,
                            org=Organization(),
                            os=Os(
                                name="string",
                                type_id=1,
                            ),
                            owner=User(),
                            region="string",
                            risk_level="string",
                            risk_level_id=1,
                            risk_score=1,
                            subnet="string",
                            subnet_uid="string",
                            sw_info=[],
                            type="string",
                            type_id=1,
                            uid="string",
                            uid_alt="string",
                            vendor=Organization(),
                            vlan_uid="string",
                            vpc_uid="string",
                            zone="string",
                        ),
                        duration=1,
                        end_time=1,
                        end_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        enrichments=[
                            Enrichment(
                                data={"key": "value"},
                                name="string",
                                value="string",
                            )
                        ],
                        http_request=HttpRequest(
                            args="string",
                            http_headers=[],
                            http_method="string",
                            length=1,
                            referrer="string",
                            uid="string",
                            url=Url(),
                            user_agent="string",
                            user_agent_name="string",
                            version="string",
                            x_forwarded_for=[],
                        ),
                        message="string",
                        metadata=Metadata(
                            correlation_uid="string",
                            event_code="string",
                            extension=Extension(
                                name="string",
                                uid="string",
                                version="string",
                            ),
                            extensions=[
                                Extension(
                                    name="string",
                                    uid="string",
                                    version="string",
                                )
                            ],
                            labels=["string"],
                            log_level="string",
                            log_name="string",
                            log_provider="string",
                            log_version="string",
                            logged_time=1,
                            logged_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            loggers=[Logger()],
                            modified_time=1,
                            modified_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            original_time="string",
                            processed_time=1,
                            processed_time_dt=datetime.datetime.fromisoformat(
                                "2024-01-15 09:30:00+00:00",
                            ),
                            product=Product(
                                cpe_name="string",
                                distribution_mode="string",
                                feature=Feature(
                                    name="string",
                                    uid="string",
                                    version="string",
                                ),
                                lang="string",
                                name="string",
                                path="string",
                                uid="string",
                                url_string="string",
                                vendor_name="string",
                                version="string",
                                workload="string",
                            ),
                            profiles=["string"],
                            sequence=1,
                            tenant_uid="string",
                            uid="string",
                            version="string",
                        ),
                        observables=[
                            Observable(
                                name="string",
                                type_id=1,
                            )
                        ],
                        osint=[
                            Osint(
                                type_id=1,
                                value="string",
                            )
                        ],
                        policy=Policy(
                            desc="string",
                            group=Group(),
                            is_applied=True,
                            name="string",
                            uid="string",
                            version="string",
                        ),
                        raw_data="string",
                        severity="string",
                        severity_id=1,
                        src_endpoint=NetworkEndpoint(
                            agent_list=[],
                            autonomous_system=AutonomousSystem(),
                            container=Container(),
                            domain="string",
                            hostname="string",
                            hw_info=DeviceHwInfo(),
                            instance_uid="string",
                            interface_name="string",
                            interface_uid="string",
                            intermediate_ips=[],
                            ip="string",
                            location=Location(),
                            mac="string",
                            name="string",
                            namespace_pid=1,
                            os=Os(
                                name="string",
                                type_id=1,
                            ),
                            owner=User(),
                            port=1,
                            proxy_endpoint=NetworkProxy(),
                            subnet_uid="string",
                            svc_name="string",
                            type="string",
                            type_id=1,
                            uid="string",
                            vlan_uid="string",
                            vpc_uid="string",
                            zone="string",
                        ),
                        start_time=1,
                        start_time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        status="string",
                        status_code="string",
                        status_detail="string",
                        status_id=1,
                        time=1,
                        time_dt=datetime.datetime.fromisoformat(
                            "2024-01-15 09:30:00+00:00",
                        ),
                        timezone_offset=1,
                        type_name="string",
                        type_uid=1,
                        unmapped={"string": {"key": "value"}},
                        user=User(),
                        user_result=User(),
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "v1/sink/events",
            method="POST",
            params={
                "location": location,
            },
            json=request,
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateSinkEventsResponse,
                    construct_type(
                        type_=CreateSinkEventsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 405:
                raise MethodNotAllowedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 409:
                raise ConflictError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 415:
                raise UnsupportedMediaTypeError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 500:
                raise InternalServerError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 501:
                raise NotImplementedError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 502:
                raise BadGatewayError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 503:
                raise ServiceUnavailableError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 504:
                raise GatewayTimeoutError(
                    typing.cast(
                        Problem,
                        construct_type(
                            type_=Problem,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)
